<?php

namespace Prk\Admin\Hub;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Class PRK_Hub
 * Handles the content callback for the ParsKala Hub tab in WooCommerce product page.
 */
class prk_Hub {
    /**
     * Holds the single instance of the class
     * @var prk_Hub|null
     */
    private static ?prk_Hub $instance = null;

    /**
     * Get the single instance of the class
     * @return prk_Hub
     */
    public static function get_instance(): prk_Hub {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * PRK_Hub constructor.
     * Private to enforce singleton pattern.
     */
    private function __construct() {

        // add_action('admin_enqueue_scripts', [ $this, 'enqueue_assets' ]);
        
    }

    // /**
    //  * Enqueue the common CSS and JS files for all tabs
    //  */
    // public function enqueue_assets(): void {
    //     $css_path = get_template_directory_uri() . '/app/Admin/assets/css/custom.css';
    //     $js_path = get_template_directory_uri() . '/app/Admin/assets/js/custom.js';

    //     wp_enqueue_style('pars-kala-custom-css', $css_path);
    //     wp_enqueue_script('pars-kala-custom-js', $js_path, false, true);
    // }

    /**
     * Display the content of the ParsKala Hub tab
     */
    public function display_hub_content(): void {
        $template_path = __DIR__ . '/template/main-hub.php';

        if ( file_exists( $template_path ) ) {
            require $template_path;
        } else {
            echo '<div style="color: red;">Template file not found: ' . esc_html( $template_path ) . '</div>';
        }
    }
}
