<section class="server-status-section">
    <h3 class="server-status-title heading-3"><?= __('وضعیت سرور','parskala'); ?></h3>
    <p class="server-status-text"><?= __('بررسی و مانیتورینگ وضعیت سرور و منابع هاست سایت.','parskala'); ?></p>

    <div class="server-status-container">

        <?php

        $warning_icon = '<i class="status-card-icon">
                  <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M12 13.75C11.59 13.75 11.25 13.41 11.25 13V7.75C11.25 7.34 11.59 7 12 7C12.41 7 12.75 7.34 12.75 7.75V13C12.75 13.41 12.41 13.75 12 13.75Z" fill="#F19100"></path>
                    <path d="M12 17.25C11.73 17.25 11.48 17.15 11.29 16.96C11.2 16.86 11.13 16.75 11.07 16.63C11.02 16.51 11 16.38 11 16.25C11 15.99 11.11 15.73 11.29 15.54C11.66 15.17 12.34 15.17 12.71 15.54C12.89 15.73 13 15.99 13 16.25C13 16.38 12.97 16.51 12.92 16.63C12.87 16.75 12.8 16.86 12.71 16.96C12.52 17.15 12.27 17.25 12 17.25Z" fill="#F19100"></path>
                    <path d="M12.0002 22.75C11.3302 22.75 10.6502 22.58 10.0502 22.23L4.11017 18.8C2.91017 18.1 2.16016 16.81 2.16016 15.42V8.57999C2.16016 7.18999 2.91017 5.89999 4.11017 5.19999L10.0502 1.77C11.2502 1.07 12.7402 1.07 13.9502 1.77L19.8902 5.19999C21.0902 5.89999 21.8402 7.18999 21.8402 8.57999V15.42C21.8402 16.81 21.0902 18.1 19.8902 18.8L13.9502 22.23C13.3502 22.58 12.6702 22.75 12.0002 22.75ZM12.0002 2.74998C11.5902 2.74998 11.1702 2.85998 10.8002 3.06998L4.86017 6.49998C4.12017 6.92998 3.66016 7.71999 3.66016 8.57999V15.42C3.66016 16.27 4.12017 17.07 4.86017 17.5L10.8002 20.93C11.5402 21.36 12.4602 21.36 13.1902 20.93L19.1302 17.5C19.8702 17.07 20.3302 16.28 20.3302 15.42V8.57999C20.3302 7.72999 19.8702 6.92998 19.1302 6.49998L13.1902 3.06998C12.8302 2.85998 12.4102 2.74998 12.0002 2.74998Z" fill="#F19100"></path>
                  </svg>
                </i>';
        
        $success_icon = '<i class="status-card-icon">
                  <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M12 13.75C11.59 13.75 11.25 13.41 11.25 13V7.75C11.25 7.34 11.59 7 12 7C12.41 7 12.75 7.34 12.75 7.75V13C12.75 13.41 12.41 13.75 12 13.75Z" fill="#ED3D2E"></path>
                    <path d="M12 17.25C11.73 17.25 11.48 17.15 11.29 16.96C11.2 16.86 11.13 16.75 11.07 16.63C11.02 16.51 11 16.38 11 16.25C11 15.99 11.11 15.73 11.29 15.54C11.66 15.17 12.34 15.17 12.71 15.54C12.89 15.73 13 15.99 13 16.25C13 16.38 12.97 16.51 12.92 16.63C12.87 16.75 12.8 16.86 12.71 16.96C12.52 17.15 12.27 17.25 12 17.25Z" fill="#ED3D2E"></path>
                    <path d="M12.0002 22.75C11.3302 22.75 10.6502 22.58 10.0502 22.23L4.11017 18.8C2.91017 18.1 2.16016 16.81 2.16016 15.42V8.57999C2.16016 7.18999 2.91017 5.89999 4.11017 5.19999L10.0502 1.77C11.2502 1.07 12.7402 1.07 13.9502 1.77L19.8902 5.19999C21.0902 5.89999 21.8402 7.18999 21.8402 8.57999V15.42C21.8402 16.81 21.0902 18.1 19.8902 18.8L13.9502 22.23C13.3502 22.58 12.6702 22.75 12.0002 22.75ZM12.0002 2.74998C11.5902 2.74998 11.1702 2.85998 10.8002 3.06998L4.86017 6.49998C4.12017 6.92998 3.66016 7.71999 3.66016 8.57999V15.42C3.66016 16.27 4.12017 17.07 4.86017 17.5L10.8002 20.93C11.5402 21.36 12.4602 21.36 13.1902 20.93L19.1302 17.5C19.8702 17.07 20.3302 16.28 20.3302 15.42V8.57999C20.3302 7.72999 19.8702 6.92998 19.1302 6.49998L13.1902 3.06998C12.8302 2.85998 12.4102 2.74998 12.0002 2.74998Z" fill="#ED3D2E"></path>
                  </svg>
                </i>';

        function get_server_status_value($key) {
            switch ($key) {
                case 'php_version':
                    return phpversion();
                case 'memory_limit':
                    return ini_get('memory_limit');
                case 'max_execution_time':
                    return ini_get('max_execution_time');
                case 'post_max_size':
                    return ini_get('post_max_size');
                case 'curl_enabled':
                    return function_exists('curl_version') ? 'فعال' : 'غیرفعال';
                case 'allow_url_fopen':
                    return ini_get('allow_url_fopen') ? 'فعال' : 'غیرفعال';
                default:
                    return 'نامشخص';
            }
        }

        function get_status_card_class($key, $value) {
            switch ($key) {
                case 'php_version':
                    return version_compare($value, '7.4', '>=') ? 'success' : (version_compare($value, '7.0', '>=') ? 'warning' : 'error');
                case 'memory_limit':
                    $num = (int) filter_var($value, FILTER_SANITIZE_NUMBER_INT);
                    return $num >= 256 ? 'success' : ($num >= 128 ? 'warning' : 'error');
                case 'max_execution_time':
                    $num = (int) $value;
                    return $num >= 60 ? 'success' : ($num >= 30 ? 'warning' : 'error');
                case 'post_max_size':
                    $num = (int) filter_var($value, FILTER_SANITIZE_NUMBER_INT);
                    return $num >= 32 ? 'success' : ($num >= 16 ? 'warning' : 'error');
                case 'curl_enabled':
                case 'allow_url_fopen':
                    return $value === 'فعال' ? 'success' : 'error';
                default:
                    return 'warning';
            }
        }

        function get_status_card_html($label, $key) {
            $warning_icon = 
            '<i class="status-card-icon">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M12 13.75C11.59 13.75 11.25 13.41 11.25 13V7.75C11.25 7.34 11.59 7 12 7C12.41 7 12.75 7.34 12.75 7.75V13C12.75 13.41 12.41 13.75 12 13.75Z" fill="#F19100"></path>
                <path d="M12 17.25C11.73 17.25 11.48 17.15 11.29 16.96C11.2 16.86 11.13 16.75 11.07 16.63C11.02 16.51 11 16.38 11 16.25C11 15.99 11.11 15.73 11.29 15.54C11.66 15.17 12.34 15.17 12.71 15.54C12.89 15.73 13 15.99 13 16.25C13 16.38 12.97 16.51 12.92 16.63C12.87 16.75 12.8 16.86 12.71 16.96C12.52 17.15 12.27 17.25 12 17.25Z" fill="#F19100"></path>
                <path d="M12.0002 22.75C11.3302 22.75 10.6502 22.58 10.0502 22.23L4.11017 18.8C2.91017 18.1 2.16016 16.81 2.16016 15.42V8.57999C2.16016 7.18999 2.91017 5.89999 4.11017 5.19999L10.0502 1.77C11.2502 1.07 12.7402 1.07 13.9502 1.77L19.8902 5.19999C21.0902 5.89999 21.8402 7.18999 21.8402 8.57999V15.42C21.8402 16.81 21.0902 18.1 19.8902 18.8L13.9502 22.23C13.3502 22.58 12.6702 22.75 12.0002 22.75ZM12.0002 2.74998C11.5902 2.74998 11.1702 2.85998 10.8002 3.06998L4.86017 6.49998C4.12017 6.92998 3.66016 7.71999 3.66016 8.57999V15.42C3.66016 16.27 4.12017 17.07 4.86017 17.5L10.8002 20.93C11.5402 21.36 12.4602 21.36 13.1902 20.93L19.1302 17.5C19.8702 17.07 20.3302 16.28 20.3302 15.42V8.57999C20.3302 7.72999 19.8702 6.92998 19.1302 6.49998L13.1902 3.06998C12.8302 2.85998 12.4102 2.74998 12.0002 2.74998Z" fill="#F19100"></path>
                </svg>
            </i>';
  
            $success_icon = 
            '<i class="status-card-icon">
                  <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M15 22.75H9C3.57 22.75 1.25 20.43 1.25 15V9C1.25 3.57 3.57 1.25 9 1.25H15C20.43 1.25 22.75 3.57 22.75 9V15C22.75 20.43 20.43 22.75 15 22.75ZM9 2.75C4.39 2.75 2.75 4.39 2.75 9V15C2.75 19.61 4.39 21.25 9 21.25H15C19.61 21.25 21.25 19.61 21.25 15V9C21.25 4.39 19.61 2.75 15 2.75H9Z" fill="#07C865"></path>
                    <path d="M10.5799 15.58C10.3799 15.58 10.1899 15.5 10.0499 15.36L7.21994 12.53C6.92994 12.24 6.92994 11.76 7.21994 11.47C7.50994 11.18 7.98994 11.18 8.27994 11.47L10.5799 13.77L15.7199 8.62998C16.0099 8.33998 16.4899 8.33998 16.7799 8.62998C17.0699 8.91998 17.0699 9.39998 16.7799 9.68998L11.1099 15.36C10.9699 15.5 10.7799 15.58 10.5799 15.58Z" fill="#07C865"></path>
                  </svg>
            </i>';

            $value = get_server_status_value($key);
            $status_class = get_status_card_class($key, $value);
            $report = ($status_class === 'success') ? 'خوب' : (($status_class === 'warning') ? 'قابل قبول' : 'نیاز به بررسی');

            $icon = ($status_class === 'success') ? $success_icon : $warning_icon;

            return "
            <div class='status-card status-card-{$status_class}'>
                <div class='status-card-right'>
                    {$icon}
                    <h6 class='status-card-title'>{$label}</h6>
                </div>
                <div class='status-card-left'>
                    <span class='status-card-version'>{$value}</span>
                    <span class='status-card-report'>{$report}</span>
                </div>
            </div>
            ";
        }

        // استفاده
        echo get_status_card_html('ورژن PHP سرور', 'php_version');
        echo get_status_card_html('مقدار Memory Limit', 'memory_limit');
        echo get_status_card_html('مدت زمان Max Execution Time', 'max_execution_time');
        echo get_status_card_html('Post Max Size', 'post_max_size');
        echo get_status_card_html('فعال بودن cURL', 'curl_enabled');
        echo get_status_card_html('فعال بودن allow_url_fopen', 'allow_url_fopen');

        ?>


    </div>

</section>