function iElement(selector){
    return typeof selector === 'function' ? selector : jQuery(selector);
}

function iWantLoader(element, type = ''){
    let el = iElement(element),
        loaderContent = iElement(`<div class="is-loader loader-line"></div>`);
    el.css('position', 'relative');
    if(type === 'text'){
        if(el.find('span')){
            el.data('text', el.find('span').text());
            el.find('span').text(assets_data.translate.doing);
        } else {
            el.data('text', el.text());
            el.text(assets_data.translate.doing);
        }

    } else {
        loaderContent.hide();
        el.append(loaderContent);
        el.find('.is-loader').slideDown();
    }
    el.addClass('has-loader');
}

function iCantLoader(element, type = 'text'){
    let el = iElement(element);
    if(type === 'text'){
        if(el.find('span')){
            el.find('span').text(el.data('text'));
        } else {
            el.text(el.data('text'));
        }
    } else {
        el.find('.is-loader').slideUp(function(){
            iElement(this).remove();
        });
    }
    el.removeClass('has-loader');
}

function ahuraSetCookie(name, value, exdays = 30) {
    const d = new Date();
    d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
    let expires = "expires=" + d.toUTCString();
    document.cookie = name + "=" + value + ";" + expires + ";path=/";
}

function ahuraDeleteCookie(name, exdays = 35) {
    const d = new Date();
    d.setTime(d.getTime() + (-exdays * 24 * 60 * 60 * 1000));
    let expires = "expires=" + d.toUTCString();
    document.cookie = name + "=;" + expires + ";path=/";
}

function ahuraGetCookie(cname) {
    let name = cname + "=";
    let ca = document.cookie.split(';');
    for(let i = 0; i < ca.length; i++) {
        let c = ca[i];
        while (c.charAt(0) == ' ') {
            c = c.substring(1);
        }
        if (c.indexOf(name) == 0) {
            return c.substring(name.length, c.length);
        }
    }
    return "";
}

function ahuraCheckCookie(name) {
    let data = ahuraGetCookie(name);
    if (data != "") {
        return true;
    }

    return false;
}