jQuery(document).ready(function($){
    
    $('.upload-option-checkbox input.checkbox').on('click', function() {
        console.log('Checkbox changed');
        $('.csf-form-warning').addClass('remove');
        $(".csf-form").removeData("validator");
        $(".csf-form").removeData("unobtrusiveValidation");

    });

    // $('.upload-option-checkbox input.checkbox').on('click', function() {
    //     $('.csf-form-warning').addClass('remove');
    //     $(".csf-form").removeData("validator");
    //     $(".csf-form").removeData("unobtrusiveValidation");
    // });

    $(document).on('click', '.prk-filter-tabs a', function(e){
        e.preventDefault();
        let btn = $(this),
            tabs = btn.parent().parent(),
            activeTabs = tabs.children('.active'),
            filterValue = btn.attr('data-filter');
  
        activeTabs.removeClass('active');
        btn.parent().addClass('active');

        $('.filter-item').fadeOut();
        $(filterValue).fadeIn();
    });
});

function ahura_is_json(str) {
    try {
        JSON.parse(str);
    } catch (e) {
        return false;
    }
    return true;
}

function ahura_timeout_message(title, type = 'success', time = 3000){
    Swal.fire({
        position: 'center-center',
        icon: type,
        title: title,
        showConfirmButton: false,
        timer: 3000
    })
}

let alert_queue = [];

function show_next_alert() {
    if (alert_queue.length === 0) return;

    let { message, type, duration } = alert_queue.shift();

    let icon_svg = '';
    let color_class = '';

    switch (type) {
        case 'success':
            icon_svg = `<svg class="MuiSvgIcon-root MuiSvgIcon-fontSizeInherit css-1l6e05h" viewBox="0 0 24 24"><path d="M20,12A8,8 0 0,1 12,20A8,8 0 0,1 4,12A8,8 0 0,1 12,4C12.76,4 13.5,4.11 14.2,4.31L15.77,2.74C14.61,2.26 13.34,2 12,2A10,10 0 0,0 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12M7.91,10.08L6.5,11.5L11,16L21,6L19.59,4.58L11,13.17L7.91,10.08Z"></path></svg>`;
            color_class = 'MuiAlert-colorSuccess MuiAlert-standardSuccess MuiAlert-standard';
            break;
        case 'info':
            icon_svg = `<svg class="MuiSvgIcon-root MuiSvgIcon-fontSizeInherit css-1l6e05h" viewBox="0 0 24 24"><path d="M11,9H13V7H11M12,20C7.59,20 4,16.41 4,12C4,7.59 7.59,4 12,4C16.41,4 20,7.59 20, 12C20,16.41 16.41,20 12,20M12,2A10,10 0 0,0 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12A10,10 0 0,0 12,2M11,17H13V11H11V17Z"></path></svg>`;
            color_class = 'MuiAlert-colorInfo MuiAlert-standardInfo MuiAlert-standard';
            break;
        default:
            icon_svg = '';
            color_class = 'MuiAlert-standard';
            break;
    }

    let alert_html = `
    <div class="MuiPaper-root MuiPaper-elevation MuiPaper-rounded MuiPaper-elevation0 MuiAlert-root ${color_class} css-1esubr7 show-alert-js" role="alert" direction="down" style="
        --Paper-shadow: none;
        opacity: 0;
        transform: scale(0.8);
        transition: opacity 300ms ease, transform 300ms ease;
    ">
        <div class="MuiAlert-icon css-131is6g">
            ${icon_svg}
        </div>
        <div class="MuiAlert-message css-127h8j3">${message}</div>
        <div class="MuiAlert-action css-1xfslal">
            <button class="MuiButtonBase-root MuiIconButton-root MuiIconButton-colorInherit MuiIconButton-sizeSmall css-1jk3rlz close-alert-btn" tabindex="0" type="button" aria-label="Close" title="Close">
                <svg class="MuiSvgIcon-root MuiSvgIcon-fontSizeSmall css-vh810p" viewBox="0 0 24 24"><path d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"></path></svg>
            </button>
        </div>
    </div>
    `;

    jQuery('.show-alert-js').remove();
    jQuery('body').append(alert_html);

    setTimeout(() => {
        jQuery('.show-alert-js').css({
            'opacity': '1',
            'transform': 'scale(1)'
        });
    }, 10);

    let timeout_id = setTimeout(() => {
        hide_alert();
    }, duration || 3000);

    jQuery(document).off('click', '.close-alert-btn').on('click', '.close-alert-btn', function () {
        clearTimeout(timeout_id);
        hide_alert();
    });
}

function hide_alert() {
    jQuery('.show-alert-js').css({
        'opacity': '0',
        'transform': 'scale(0.8)',
        'animation': 'zoomOutAlert 0.10s ease-in forwards',
    });
    setTimeout(() => {
        jQuery('.show-alert-js').remove();
        show_next_alert();
    }, 300); // هماهنگ با transition بالا
}

function queue_alert(message, type = 'success', duration = 3000) {
    alert_queue.push({ message, type, duration });
    if (jQuery('.show-alert-js').length === 0) {
        show_next_alert();
    }
}