<?php

namespace Prk\Admin;

class prk_plugin_activation  {

    private static $instance;

    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
		$this->init();	
    }

	public function init() {
		add_filter( 'tgmpa_load', array( $this, 'tgmpa_load' ), 10, 1 );
		add_action( 'wp_ajax_xts_deactivate_plugin', array( $this, 'ajax_deactivate_plugin' ) );
		add_action( 'wp_ajax_xts_check_plugins', array( $this, 'ajax_check_plugin' ) );
		add_action( 'admin_enqueue_scripts',array( $this, 'localize_script' ) );
		add_action( 'tgmpa_register',array( $this, 'xts_register_required_plugins' ) );
	}

	public function localize_script() {

		wp_enqueue_script('prkadmin', get_template_directory_uri() .'/inc/wizard/js/prkadmin.js', null, '22', true);
		$localize_data                                       = array();
		$localize_data['ajaxUrl']                            = admin_url( 'admin-ajax.php' );
		$localize_data['redirectAfterPlugins'] = admin_url('admin.php?page=theme-options');
		$localize_data['get_theme_settings_data_nonce']      = wp_create_nonce( 'xts-get-theme-settings-data-nonce' );
		$localize_data['wpUploadDir']                        = wp_upload_dir();
		$localize_data['activate_plugin_btn_text']           = esc_html__( 'فعال سازی', 'parskala' );
		$localize_data['update_plugin_btn_text']             = esc_html__( 'بروز رسانی', 'parskala' );
		$localize_data['deactivate_plugin_btn_text']         = esc_html__( 'غیر فعال سازی', 'parskala' );
		$localize_data['install_plugin_btn_text']            = esc_html__( 'نصب', 'parskala' );
		$localize_data['activate_process_plugin_btn_text']   = esc_html__( 'درحال فعال سازی..', 'parskala' );
		$localize_data['update_process_plugin_btn_text']     = esc_html__( 'درحال بروز رسانی..', 'parskala' );
		$localize_data['deactivate_process_plugin_btn_text'] = esc_html__( 'درحال غیرفعال سازی', 'parskala' );
		$localize_data['install_process_plugin_btn_text']    = esc_html__( 'در حال نصب..', 'parskala' );
		$localize_data['ajax_error']           = esc_html__( 'Something wrong with removing data. Please, try to remove data manually or contact our support center for further assistance.', 'parskala' );
		
		// // 🛎 اضافه کردن اطلاعات پلاگین ها شامل required
		// $plugins = $this->get_plugins();
		// $localize_data['plugins'] = array();

		// foreach ( $plugins as $slug => $plugin ) {
		// 	$localize_data['plugins'][ $slug ] = array(
		// 		'required' => isset( $plugin['required'] ) ? (bool) $plugin['required'] : false,
		// 	);
		// }

		// wp_localize_script(
		// 	'prkadmin',
		// 	'xtsAdminConfig',
		// 	apply_filters( 'test', $localize_data )
		// );


		// افزودن اطلاعات پلاگین ها
		$plugins = $this->get_plugins();
		$localize_data['plugins'] = array();

		foreach ( $plugins as $slug => $plugin ) {
			$localize_data['plugins'][ $slug ] = array(
				'required'      => isset( $plugin['required'] ) ? (bool) $plugin['required'] : false,
				'status'        => isset( $plugin['status'] ) ? $plugin['status'] : '',
				'activate_url'  => isset( $plugin['activate_url'] ) ? esc_url( $plugin['activate_url'] ) : '',
				'install_url'   => isset( $plugin['install_url'] ) ? esc_url( $plugin['install_url'] ) : '',
				'update_url'    => isset( $plugin['update_url'] ) ? esc_url( $plugin['update_url'] ) : '',
			);
		}
		wp_localize_script(
			'prkadmin',
			'xtsAdminConfig',
			apply_filters( 'test', $localize_data )
		);
	
	}

	/**
	 * Deactivate plugin.
	 *
	 * @since 1.0.0
	 */
	public function ajax_deactivate_plugin() {
		$plugins = $this->get_plugins();
		$tgmpa   = call_user_func( array( get_class( $GLOBALS['tgmpa'] ), 'get_instance' ) );

		if ( ! $plugins ) {
			wp_send_json(
				array(
					'message' => esc_html__( 'Plugins list is empty.', 'parskala' ),
					'status'  => 'error',
				)
			);
		}

		if ( ! current_user_can( 'manage_options' ) ) {
			wp_send_json(
				array(
					'message' => esc_html__( 'You not have access.', 'parskala' ),
					'status'  => 'error',
				)
			);
		}

		if ( is_plugin_active_for_network( $plugins[ $_POST['xts_plugin'] ]['file_path'] ) ) { // phpcs:ignore
			wp_send_json(
				array(
					'message' => esc_html__( 'You cannot deactivate the plugin on a multisite.', 'parskala' ),
					'status'  => 'error',
				)
			);
		}

		if ( isset( $_POST['xts_plugin'] ) && $tgmpa->is_active_plugin( $_POST['xts_plugin'] ) ) { // phpcs:ignore
			deactivate_plugins( $plugins[ $_POST['xts_plugin'] ]['file_path'] ); // phpcs:ignore
		}

		wp_send_json(
			array(
				'data'   => $plugins[ $_POST['xts_plugin'] ]['status'], // phpcs:ignore
				'status' => 'success',
			)
		);
	}

	/**
	 * Check plugin.
	 *
	 * @since 1.0.0
	 */
	public function ajax_check_plugin() {
		$plugins = $this->get_plugins();

		if ( ! $plugins ) {
			wp_send_json(
				array(
					'message' => esc_html__( 'Plugins list is empty.', 'parskala' ),
					'status'  => 'error',
				)
			);
		}

		if ( ! current_user_can( 'manage_options' ) ) {
			wp_send_json(
				array(
					'message' => esc_html__( 'You not have access.', 'parskala' ),
					'status'  => 'error',
				)
			);
		}

		wp_send_json(
			array(
				'data'   => array(
					'status'           => $plugins[ $_POST['xts_plugin'] ]['status'], // phpcs:ignore
					'version'          => $plugins[ $_POST['xts_plugin'] ]['version'], // phpcs:ignore
					'required_plugins' => count( $this->get_required_plugins_to_activate() ) > 0 ? 'has_required' : 'no',
					'is_all_activated' => $this->is_all_activated() ? 'yes' : 'no',
				),
				'status' => 'success',
			)
		);
	}

	/**
	 * Load TGM.
	 *
	 * @since 1.0.0
	 */
	public function tgmpa_load() {
		return is_admin() || current_user_can( 'install_themes' );
	}

	/**
	 * Get plugins list array.
	 *
	 * @since 1.0.0
	 */
	public function get_plugins() {
		$tgmpa             = call_user_func( array( get_class( $GLOBALS['tgmpa'] ), 'get_instance' ) );
		$tgmpa_plugins     = $tgmpa->plugins;
		$installed_plugins = get_plugins();

		$plugins = array();

		foreach ( $tgmpa_plugins as $slug => $plugin ) {
			$plugins[ $slug ]                   = $plugin;
			$plugins[ $slug ]['activate_url']   = $this->get_action_url( $slug, 'activate' );
			$plugins[ $slug ]['update_url']     = $this->get_action_url( $slug, 'update' );
			$plugins[ $slug ]['deactivate_url'] = '';

			if ( isset( $installed_plugins[ $plugin['file_path'] ]['Version'] ) ) {
				$plugins[ $slug ]['version'] = $installed_plugins[ $plugin['file_path'] ]['Version'];
			}

			if ( ! $tgmpa->is_plugin_installed( $slug ) ) {
				$plugins[ $slug ]['status'] = 'install';
			} else {
				if ( $tgmpa->does_plugin_have_update( $slug ) ) {
					$plugins[ $slug ]['status'] = 'update';
				} elseif ( $tgmpa->can_plugin_activate( $slug ) ) {
					$plugins[ $slug ]['status'] = 'activate';
				} elseif ( $tgmpa->does_plugin_require_update( $slug ) ) {
					$plugins[ $slug ]['status'] = 'require_update';
				} else {
					$plugins[ $slug ]['status'] = 'deactivate';
				}
			}
		}

		$order = array(
			'RTL-CareUnit',
			'elementor',
			'woocommerce',
			'contact-form-7',
		);


		if ( ! isset( $plugins['woocommerce'] ) ) {
			$order = array_flip( $order );
			unset( $order['woocommerce'] );
			$order = array_flip( $order );
		}

		return array_replace( array_flip( $order ), $plugins );
	}

	/**
	 * Get required plugins to activate.
	 *
	 * @since 1.0.0
	 */
	public function get_required_plugins_to_activate() {
		$plugins = $this->get_plugins();
		$tgmpa   = call_user_func( array( get_class( $GLOBALS['tgmpa'] ), 'get_instance' ) );
		$output  = array();

		foreach ( $plugins as $slug => $plugin ) {
			if ( ! $tgmpa->is_active_plugin( $slug ) && $tgmpa->can_plugin_activate( $slug ) && $plugin['required'] ) {
				$output[] = $plugin;
			}
		}

		return $output;
	}

	/**
	 * Is all plugins activated.
	 *
	 * @since 1.0.0
	 */
	public function is_all_activated() {
		$plugins = $this->get_plugins();
		$tgmpa   = call_user_func( array( get_class( $GLOBALS['tgmpa'] ), 'get_instance' ) );
		$output  = array();

		foreach ( $plugins as $slug => $plugin ) {
			if ( ! $tgmpa->is_active_plugin( $slug ) && $tgmpa->can_plugin_activate( $slug ) ) {
				$output[] = $plugin;
			}
		}

		return count( $output ) === 0;
	}

	public function is_all_required_plugins_activated() {
		$plugins = $this->get_plugins();
		$tgmpa = call_user_func( array( get_class( $GLOBALS['tgmpa'] ), 'get_instance' ) );
	
		foreach ( $plugins as $slug => $plugin ) {
			if ( isset( $plugin['required'] ) && $plugin['required'] ) {
				if ( ! $tgmpa->is_active_plugin( $slug ) ) {
					return false; // یکی از افزونه‌های ضروری فعال نیست!
				}
			}
		}
	
		return true; // همه افزونه‌های ضروری فعال هستن
	}

	/**
	 * Get required plugins to activate.
	 *
	 * @since 1.0.0
	 *
	 * @param string $slug   Slug.
	 * @param string $status Status.
	 *
	 * @return string
	 */
	public function get_action_url( $slug, $status ) {
		return wp_nonce_url(
			add_query_arg(
				array(
					'plugin'           => rawurlencode( $slug ),
					'tgmpa-' . $status => $status . '-plugin',
				),
				admin_url( 'themes.php?page=tgmpa-install-plugins' )
			),
			'tgmpa-' . $status,
			'tgmpa-nonce'
		);
	}

	/**
	 * Get required plugins to activate.
	 *
	 * @since 1.0.0
	 *
	 * @param string $status Status.
	 *
	 * @return string
	 */
	public function get_action_text( $status ) {
		$text = esc_html__( 'غیر فعال سازی', 'parskala' );

		if ( 'install' === $status ) {
			$text = esc_html__( 'نصب افزونه', 'parskala' );
		} elseif ( 'update' === $status ) {
			$text = esc_html__( 'بروز رسانی', 'parskala' );
		} elseif ( 'activate' === $status ) {
			$text = esc_html__( 'فعال کردن', 'parskala' );
		}

		return $text;
	}

	/**
	 * Template.
	 *
	 * @since 1.0.0
	 */
	public function plugins_template() {

		$plugins = $this->get_plugins();
		$classes = $this->is_all_activated() ? ' hidden' : '';
	
		include get_template_directory() . '/app/Admin/Hub/template/plugins-template.php';
	}



	/**
	 * TGM Plugin activator.
	 *
	 * @since 1.0.0
	 */
	public static function xts_register_required_plugins() {

		$plugins[] = array(
			'name'     => 'مدیریت هوشمند راستچین',
			'slug'     => 'RTL-CareUnit',
			'source'   => 'https://parskalas.com/api/files/RTL-CareUnit.zip',
			'required' => true,
			'tooltip'  => 'افزونه مخصوص قالب برای قابلیت‌های بیشتر',
		);

		$plugins[] = array(
			'name'     => 'المنتور',
			'slug'     => 'elementor',
			'required' => true,
			'tooltip'  => 'Required page builder for our theme',
		);
		$plugins[] = array(
			'name'     => 'ووکامرس',
			'slug'     => 'woocommerce',
			'required' => true,
			'tooltip'  => 'Base plugin for your online store',
		);
		$plugins[] = array(
			'name'    => 'فرم تماس 7',
			'slug'    => 'contact-form-7',
			'tooltip' => 'Plugin for creating custom contact forms',
		);

		$plugins[] = array(
			'name'    => 'پارسی دیت',
			'slug'    => 'wp-parsidate',
			'tooltip' => 'It includes Shamsi (Jalali) calendar, character issues fixes and Right-To-Left fix for WordPress back-end environment',
		);

		tgmpa( $plugins );
	}


}
