<?php

/**
 * Footer Class File
 *
 * This class handles the footer-related hooks and actions for the theme.
 *
 * @package ParsKala
 */

namespace Prk\Classes;

defined( 'ABSPATH' ) || exit;

class Footer_Class {

    /**
     * Instance of the class
     *
     * @var Footer_Class|null
     */
    private static ?Footer_Class $instance = null;

    /**
     * Get the instance of the class
     *
     * @return Footer_Class
     */
    public static function get_instance(): Footer_Class {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * Footer_Class constructor.
     */
    private function __construct() {
        $this->init_hooks();
    }

    /**
     * Initialize Hooks
     */
    private function init_hooks(): void {
        add_action('wp_footer', [ $this, 'prk_run_static_content'], 9);
        add_action( 'prk_before_wp_footer', [ $this, 'before_wp_footer_content' ] );
        add_action( 'prk_after_wp_footer', [ $this, 'after_wp_footer_content' ] );
    }

    /**
     * Content to display before wp_footer
     */
    public function before_wp_footer_content(): void {

    
        if (! is_front_page() && ! prk_faq_page() && !is_page_template( 'page-full-wide.php' ) ){

            echo '</div>';
        
        }
        if (class_exists( 'WooCommerce' ) ) {

            if ( prk_footer_seen_true() && empty(is_account_page()) && empty(is_checkout()) ){

            get_template_part( '/inc/template/footer/product-seen' );

            }
        }

        get_template_part( '/inc/template/footer/main-footer' );

        echo '<div class="navigation-overlay"></div>';
    }

    /**
     * Content to display after wp_footer
     */
    public function after_wp_footer_content(): void {
     
        echo '</body></html>';
    }

    
    /**
     * Footer run static content
     */
    function prk_run_static_content() {
        do_action('Prk_static_content');
    }


}