<?php

/**
 * Header Class File
 *
 * This class handles the header-related hooks and actions for the theme.
 *
 * @package ParsKala
 */

namespace Prk\Classes;

defined( 'ABSPATH' ) || exit;

class Header_Class {

    /**
     * Instance of the class
     *
     * @var Header_Class|null
     */
    private static ?Header_Class $instance = null;

    /**
     * Get the instance of the class
     *
     * @return Header_Class
     */
    public static function get_instance(): Header_Class {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * Header_Class constructor.
     */
    private function __construct() {
        $this->init_hooks();
    }

    /**
     * Initialize Hooks
     */
    private function init_hooks(): void {
        add_action( 'prk_before_wp_head', [ $this, 'before_wp_head_content' ] );
        add_action( 'prk_after_wp_head', [ $this, 'after_wp_head_content' ] );
    }

    /**
     * Content to display before wp_head
     */
    public function before_wp_head_content(): void {
        ?>
        <!DOCTYPE html>
        <html <?php language_attributes(); ?>>
        <head>
            <meta charset="<?php bloginfo('charset'); ?>">
            <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1,user-scalable=no"/>
            <meta name="fontiran.com:license" content="B3L8B">
            <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
            <meta name="theme-color" content="<?= prk_addressbar_color() ?>">

            <?php if (is_singular() ) {
                wp_enqueue_script('comment-reply');
            } 
    
            $seo_plugins = is_plugin_active('wordpress-seo/wp-seo.php') || is_plugin_active('wordpress-seo-premium/wp-seo-premium.php') || class_exists('WPSEO_Options') || is_plugin_active('rank-math/rank-math.php') ||class_exists( 'RankMath' );
        
            if ($seo_plugins){
        
               echo '<title>'. wp_title('') .'</title>';
        
            } else { 

                echo '<title>';
                
                    if( get_bloginfo('description')==null && is_front_page() ){
                        bloginfo('name'); 
                    }elseif (get_bloginfo('name')==null){
                        is_front_page() ? bloginfo('description') : wp_title('');

                    }elseif(is_front_page()){
                        bloginfo('name'); 
                        echo ' &ndash; ';
                        is_front_page() ? bloginfo('description') : wp_title('');
                    }else{
                        is_front_page() ? bloginfo('description') : wp_title(''); 
                        echo ' &ndash; ';
                        bloginfo('name'); 
                    }
                
                echo '</title>';

            } 

        wp_enqueue_script( 'jQuery' );

    }

    /**
     * Content to display after wp_head
     */
    public function after_wp_head_content(): void {

        echo '</head>';
        
        echo '<body class="">';
 
       get_template_part( '/inc/template/header/includes' );

       get_template_part('/inc/template/header/modren-header');

       // کنترل عرض سایت درصفحات غیر از صفحه اصلی
       if (! is_front_page() && ! prk_faq_page() && !is_page_template( 'page-full-wide.php' ) ){
    
         echo '<div class="continer">';
    
      }

    }
}


?>
