<?php


namespace Prk\Classes;

class post_types {

    private static $instance = null;

    private function __construct() {

        add_action('init', [$this,'faq_cat'], 2);
        add_action( 'init', [$this,'faq_posttype'],2 );


    }

    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function faq_cat(){
        $labels = array(
            'name' => 'دسته های پرسش متداول فروشگاه',
            'singular_name' => 'پرسش متداول',
            'menu_name' => 'دسته ها',
            'add_new'             => __( 'دسته جدید', 'prk' ),
            'search_items' => 'جستجو دسته',
            'all_items' => 'همه دسته ها',
            'edit_item' => 'ویرایش',
            'update_item' => 'به روز رسانی',
            'add_new_item' => 'افزودن جدید',
            'new_item_name' => 'نام دسته جدید',
            'separate_items_with_commas' => 'Separate cats with commas',
            'add_or_remove_items' => 'Add or remove cat',
            'choose_from_most_used' => 'Choose from the most used cat',
        );
        register_taxonomy('faq_cat', ['prkfaq'], array(
            'hierarchical' => true,
            'labels' => $labels,
            'public' => false,
            'publicly_queryable' => false,
            'show_ui' => true,
            'update_count_callback' => '_update_post_term_count',
            'query_var' => true,
            'rewrite' => array('slug' => 'faq_cat'),
        ));
    }

    public function faq_posttype() {
        register_post_type( 'prkfaq',
        // CPT Options
            array(
                'labels' => array(
                'name' => __( 'سوالات متداول', 'parskala' ),
                'add_new' => __('ایجاد سوال جدید', 'parskala'),
                'add_new_item'        => __( 'افزودن جدید', 'prk' ),
                'singular_name' => 'prkfaq'
                ),
                'taxonomies' => array('faq_cat'),
                'public' => false,
                'show_ui' => true,
                'has_archive' => true,
                'show_in_rest' => false,
                'menu_icon' 				=>  'dashicons-editor-help',
                'exclude_from_search' => true,
            )
        );
    }

}