<?php 
namespace Prk\Classes;

class prk_admin {


    private static $instance = null;
    
    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        if (!is_admin()) return;
        add_action( 'woocommerce_admin_order_data_after_billing_address', [$this, 'my_custom_checkout_field_display_admin_order_meta'], 1, 1 );
        add_action('init',[$this,'change_default_product_cat_function']);
        add_action("admin_notices", [$this,'prk_admin_notices'], 0);
        add_action("admin_head", [$this,'custom_style_for_field_items_menu']);
        add_action( 'save_post', [$this, 'saveparskala_subtitle_product_meta_product_parskala'], 10, 3 );
        add_action('edit_form_after_title',[$this, 'prk_en_name_field'],10,1);
        add_filter('admin_body_class', array($this, 'add_body_class_to_theme_options'));
        // add_action('admin_init', [$this, 'remove_admin_notices_on_theme_options_page']);
        add_action('admin_init', [$this, 'keep_only_custom_notice_on_theme_options_page']);

    }

    public function add_body_class_to_theme_options($classes) {
        if ( is_theme_options_page() ) {
            $classes .= ' prk-theme-options-page';
        }
        return $classes;
    }

    // public function remove_admin_notices_on_theme_options_page() {
    //     if ( is_theme_options_page() ) {
    //         remove_all_actions('admin_notices');
    //         remove_all_actions('all_admin_notices');
    //     }
    // }

    public function keep_only_custom_notice_on_theme_options_page() {
        if (is_theme_options_page()) {
            global $wp_filter;
            
            if (isset($wp_filter['admin_notices'])) {
                foreach ($wp_filter['admin_notices']->callbacks as $priority => $callbacks) {
                    foreach ($callbacks as $id => $callback) {
                        // اگر فانکشن prk_admin_notices نیست، حذفش کن
                        if (!isset($callback['function']) || !is_array($callback['function'])) {
                            continue;
                        }
                        if ($callback['function'][1] !== 'prk_admin_notices') {
                            unset($wp_filter['admin_notices']->callbacks[$priority][$id]);
                        }
                    }
                }
            }
        }
    }

     public function prk_en_name_field($post){

        global $typenow;
        if( in_array($typenow, array('product') ) ){ ?>
    
        <div id="titlediv">
            <div id="titlewrap">
          <br>
                <input value="<?php echo get_post_meta($post->ID, 'en_pro_name', true); ?>" dir="ltr" placeholder="English Title" type="text" name="en_pro_name" size="30"  id="title" spellcheck="true" autocomplete="off">
            </div>
        </div>
    
    <?php }
    }
    
    
    
    public function saveparskala_subtitle_product_meta_product_parskala( $post_id, $post, $update ) {
    
        $post_type = get_post_type($post_id);
    
        if ( "product" != $post_type ) return;
    
        if ( isset( $_POST['en_pro_name'] ) ) {
            update_post_meta( $post_id, 'en_pro_name', sanitize_text_field( $_POST['en_pro_name'] ) );
            update_post_meta( $post_id, 'product_english_name', sanitize_text_field( $_POST['en_pro_name'] ) );
        }
    }
    


    public function change_default_product_cat_function(){
    
        $rtl_chars_pattern = '/[\x{0590}-\x{05ff}\x{0600}-\x{06ff}]/u';
      
        $uncategorized_term_id = get_option( 'default_product_cat' );
      
        $default_category_woocommerce=get_term($uncategorized_term_id,'product_cat');
      
        $slug = urldecode($default_category_woocommerce->slug);
        
        if (preg_match($rtl_chars_pattern,$slug)){
          
          wp_update_term($uncategorized_term_id, 'product_cat', array(
            'slug' => 'uncategories'
            ));
      
        }
      
    }

    public function prk_admin_notices()
    {
    
            include PARSKALA_INC_TEMPLATEPATH . "/includes/admin-notices.php";
        
    }


    public function my_custom_checkout_field_display_admin_order_meta($order){
        $ncode_meta = prk_option('prk_ncode_factor_meta');
        if (get_post_meta( $order->get_id(), $ncode_meta, true ) && prk_option('prk_billing_ncode_factor')) {
            echo '<p><strong>'.__('کد ملی').':</strong> <br/>' . get_post_meta( $order->get_id(), $ncode_meta, true ) . '</p>';
        }
    }

        /**
     * اضافه کردن استایل‌های سفارشی به بخش هد صفحه ادمین
     */
    public function custom_style_for_field_items_menu() {
        ?>
        <style>
			li.menu-item .csf-nav-menu-options .show_line_menu,
			li.menu-item .csf-nav-menu-options .type_menu_for_display,
			li.menu-item .csf-nav-menu-options .background_mega_menu,
			li.menu-item .csf-nav-menu-options .dispaly_tabs{display:none;}

			li.menu-item-depth-0 .csf-nav-menu-options .show_line_menu,
			li.menu-item-depth-0 .csf-nav-menu-options .type_menu_for_display,
			li.menu-item-depth-0 .csf-nav-menu-options .background_mega_menu,
			li.menu-item-depth-0 .csf-nav-menu-options .dispaly_tabs{display:block;}
        </style>
        <?php
    }



}