<?php


namespace Prk\Elementor\Widgets\Header\Header_searchbox;

use Elementor\Widget_Base;

if (!defined('ABSPATH')) exit; // امنیت

class Header_searchbox extends Widget_Base {
    public function get_name() { return 'Header_searchbox'; }
    public function get_title() { return 'ویجت سرچ باکس هدر'; }
    public function get_icon() { return 'eicon-products-archive'; }
    public function get_categories() { return ['prk-category']; }

    protected function render() {
       
        ?>

        <form class="form_search desktop header_def search_input parskala search-section active relative flex items-center bg-white border border-gray-300 h-12 rounded-[11px]">

        <button type="submit" id="submit_search"
        class="active bg-gradient-to-r from-[#ff3a30] to-[#ff6a00] text-white w-[50px] h-full flex items-center justify-center transition rounded-[11px]">
        <i class="prk-search-normal-1 text-[22px]"></i>
        </button>

        <input type="text" name="s" id="txt_search" placeholder="جستجو در بین 1500 محصول تخفیف دار"
        class="prk_input_serach active flex-1 w-full text-[#232933] placeholder-gray-400 outline-none text-[14px] px-[15px] py-0">

        <div id="loading" class="absolute left-4 top-1/2 -translate-y-1/2 hidden">
        <div class="w-5 h-5 border-2 border-gray-800 border-t-transparent rounded-full animate-spin"></div>
        </div>

        <input type="hidden" value="product" name="post_type">

        <!-- نتایج جستجوی زنده -->
        <div
        class="main_results_ajax_search absolute top-[52px] right-0 w-full bg-white border-[1px] border-solid border-[#e0e0e0] shadow-lg rounded-[11px] mt-1 p-4"
        id="search-results">
        <span id="clearButton" class="absolute top-[-56px] left-[6px] text-[#3a3a3a] cursor-pointer text-[31px] z-10 hidden"
            id="close-search-results">
            <i class="ri-close-circle-fill"></i>

        </span>

        <div class="products_resulter">
            <!-- موردی یافت نشد -->
            <span class="not_resulted flex w-full items-center justify-center my-[20px] text-[#ff131352] text-xl font-bold">
            موردی یافت نشد
            <div class="relative flex mr-[6px]">
                <i class="ri-search-line text-[34px]"></i>
                <i class="ri-close-line absolute top-[-1px] right-[7px] text-[22px] text-[#ff131352]"></i>
            </div>
            
            </span>

            <!-- نتایج جستجو اینجا اضافه می‌شود -->
            <div class="border-b border-solid border-[#edededc4] pb-3">
            <div class="swiper-container overflow-hidden">
                <div class="swiper-wrapper">
                <div class="swiper-slide flex flex-col items-center p-2">
                    <article
                    class="border-[1px] border-solid border-[#eee] rounded-[11px] p[2px] pl-[15px] overflow-hidden">
                    <a class="flex items-center"
                        href="https://pars.parskalas.com/product/%d8%b3%d8%a7%d8%b9%d8%aa-%d9%85%da%86%db%8c-%d8%b9%d9%82%d8%b1%d8%a8%d9%87-%d8%a7%db%8c-%d8%b3%d9%88%d9%86-%d9%81%d8%b1%d8%a7%db%8c%d8%af%db%8c-%d9%85%d8%af%d9%84-sf-p1-03c0092-3/">
                        <div class="w-[28%] min-w-[28%] ml-[6px] relative">
                        <img
                            class="transition-all duration-200 absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-full h-auto max-w-inherit opacity-100"
                            src="https://pars.parskalas.com/wp-content/uploads/2022/07/wach-product.png" alt="">
                        </div>
                        <span class="text-[13px] leading-6 line-clamp-2 overflow-hidden text-ellipsis">
                        ساعت مچی عقربه ای سون فرایدی مدل SF-P1/03C0092
                        </span>
                    </a>
                    </article>
                </div>
                <div class="swiper-slide flex flex-col items-center p-2">
                    <article
                    class="border-[1px] border-solid border-[#eee] rounded-[11px] p[2px] pl-[15px] overflow-hidden">
                    <a class="flex items-center"
                        href="https://pars.parskalas.com/product/%d8%b3%d8%a7%d8%b9%d8%aa-%d9%85%da%86%db%8c-%d8%b9%d9%82%d8%b1%d8%a8%d9%87-%d8%a7%db%8c-%d8%b3%d9%88%d9%86-%d9%81%d8%b1%d8%a7%db%8c%d8%af%db%8c-%d9%85%d8%af%d9%84-sf-p1-03c0092-2/">
                        <div class="w-[28%] min-w-[28%] ml-[6px] relative">
                        <img
                            class="transition-all duration-200 absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-full h-auto max-w-inherit opacity-100"
                            src="https://pars.parskalas.com/wp-content/uploads/2022/07/wach-product.png" alt="">
                        </div>
                        <span class="text-[13px] leading-6 line-clamp-2 overflow-hidden text-ellipsis">
                        ساعت مچی عقربه ای سون فرایدی مدل SF-P1/03C0092
                        </span>
                    </a>
                    </article>
                </div>
                <div class="swiper-slide flex flex-col items-center p-2">
                    <article
                    class="border-[1px] border-solid border-[#eee] rounded-[11px] p[2px] pl-[15px] overflow-hidden">
                    <a class="flex items-center"
                        href="https://pars.parskalas.com/product/%d8%b3%d8%a7%d8%b9%d8%aa-%d9%85%da%86%db%8c-%d8%b9%d9%82%d8%b1%d8%a8%d9%87-%d8%a7%db%8c-%d8%b3%d9%88%d9%86-%d9%81%d8%b1%d8%a7%db%8c%d8%af%db%8c-%d9%85%d8%af%d9%84-sf-p1-03c0092/">
                        <div class="w-[28%] min-w-[28%] ml-[6px] relative">
                        <img
                            class="transition-all duration-200 absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-full h-auto max-w-inherit opacity-100"
                            src="https://pars.parskalas.com/wp-content/uploads/2022/07/wach-product.png" alt="">
                        </div>
                        <span class="text-[13px] leading-6 line-clamp-2 overflow-hidden text-ellipsis">
                        ساعت مچی عقربه ای سون فرایدی مدل SF-P1/03C0092
                        </span>
                    </a>
                    </article>
                </div>
                <div class="swiper-slide flex flex-col items-center p-2">
                    <article
                    class="border-[1px] border-solid border-[#eee] rounded-[11px] p[2px] pl-[15px] overflow-hidden">
                    <a class="flex items-center"
                        href="https://pars.parskalas.com/product/%d8%b3%d8%a7%d8%b9%d8%aa-%d9%87%d9%88%d8%b4%d9%85%d9%86%d8%af-%d8%b4%db%8c%d8%a7%d8%a6%d9%88%d9%85%db%8c/">
                        <div class="w-[28%] min-w-[28%] ml-[6px] relative">
                        <img
                            class="transition-all duration-200 absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-full h-auto max-w-inherit opacity-100"
                            src="https://pars.parskalas.com/wp-content/uploads/2022/01/36.jpg" alt="">
                        </div>
                        <span class="text-[13px] leading-6 line-clamp-2 overflow-hidden text-ellipsis">
                        ساعت هوشمند شیائومی
                        </span>
                    </a>
                    </article>
                </div>
                <div class="swiper-slide flex flex-col items-center p-2">
                    <article
                    class="border-[1px] border-solid border-[#eee] rounded-[11px] p[2px] pl-[15px] overflow-hidden">
                    <a class="flex items-center"
                        href="https://pars.parskalas.com/product/%d8%b3%d8%a7%d8%b9%d8%aa-%d9%87%d9%88%d8%b4%d9%85%d9%86%d8%af-%d8%b4%db%8c%d8%a7%d8%a6%d9%88%d9%85%db%8c/">
                        <div class="w-[28%] min-w-[28%] ml-[6px] relative">
                        <img
                            class="transition-all duration-200 absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-full h-auto max-w-inherit opacity-100"
                            src="https://pars.parskalas.com/wp-content/uploads/2022/01/36.jpg" alt="">
                        </div>
                        <span class="text-[13px] leading-6 line-clamp-2 overflow-hidden text-ellipsis">
                        ساعت هوشمند شیائومی
                        </span>
                    </a>
                    </article>
                </div>
                <div class="swiper-slide flex flex-col items-center p-2">
                    <article
                    class="border-[1px] border-solid border-[#eee] rounded-[11px] p[2px] pl-[15px] overflow-hidden">
                    <a class="flex items-center"
                        href="https://pars.parskalas.com/product/%d8%b3%d8%a7%d8%b9%d8%aa-%d9%87%d9%88%d8%b4%d9%85%d9%86%d8%af-%d8%b4%db%8c%d8%a7%d8%a6%d9%88%d9%85%db%8c/">
                        <div class="w-[28%] min-w-[28%] ml-[6px] relative">
                        <img
                            class="transition-all duration-200 absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-full h-auto max-w-inherit opacity-100"
                            src="https://pars.parskalas.com/wp-content/uploads/2022/01/36.jpg" alt="">
                        </div>
                        <span class="text-[13px] leading-6 line-clamp-2 overflow-hidden text-ellipsis">
                        ساعت هوشمند شیائومی
                        </span>
                    </a>
                    </article>
                </div>
                </div>

                <!-- دکمه‌های ناوبری -->
                <button type="button" id="prevBtn"
                class="absolute right-[15px] top-[48px] -translate-y-1/2 bg-white shadow-md border border-gray-300 text-[#424750] w-7 h-7 rounded-full flex items-center justify-center z-10 transition-opacity"
                style="display: none;">
                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" fill="none" viewBox="0 0 24 24"
                    stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                </svg>
                </button>

                <button type="button" id="nextBtn"
                class="absolute left-[15px] top-[48px] -translate-y-1/2 bg-white shadow-md border border-gray-300 text-[#424750] w-7 h-7 rounded-full flex items-center justify-center z-10 transition-opacity">
                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" fill="none" viewBox="0 0 24 24"
                    stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                </svg>
                </button>
            </div>
            </div>

            <!-- نتایج دسته بندی ها -->
            <div class="category_results">
            <div class="mt-6">
                <span class="flex items-center text-[#424750] text-[15px] font-semibold">
                <i class="ri-apps-2-line text-[29px] font-medium text-[#a1a3a8] ml-[11px] relative top-0"></i>
                جستجو در دسته بندی ها
                </span>
            </div>
            <div class="py-[29px] block border-b border-[#d8d8d8]">
                <span class="text-[1.1rem] font-semibold text-[#424750] pb-[12px] block">ساعت</span>
                <a href="#" class="text-sm font-semibold">
                <i class="text-[#81858b]">در دسته</i>
                <span class="text-[#00bf6f]">ساعت هوشمند</span>
                </a>
            </div>
            </div>
        </div>

        <!-- تصویر بنر جستجو -->
        <div style="display: none;">
            <a href="#">
            <img src="https://pars.parskalas.com/wp-content/uploads/2023/03/das-1.jpg" alt="جستجو"
                class="w-full rounded-[11px]">
            </a>
        </div>

        <!-- جستجوهای پرطرفدار -->
        <div class="mt-7">
            <span class="flex items-center text-[#424750] font-semibold text-lg">
            <i class="prk-trend-up ml-2 text-[29px] text-[#a1a3a8]"></i> جستجوی پرطرفدار
            </span>
            <ul class="mt-4 flex flex-wrap gap-3">
            <li><a href="https://pars.parskalas.com/?s=گوشی و موبایل&post_type=product"
                class="border-[1px] border-solid border-[#e0e0e2] px-[13px] py-[9px] flex items-center text-[#424750] rounded-full text-sm hover:bg-gray-300 transition">
                گوشی و موبایل <i class="ri-arrow-left-s-line text-base font-semibold"></i></a></li>
            <li><a href="https://pars.parskalas.com/?s=آیفون&post_type=product"
                class="border-[1px] border-solid border-[#e0e0e2] px-[13px] py-[9px] flex items-center text-[#424750] rounded-full text-sm hover:bg-gray-300 transition">
                آیفون <i class="ri-arrow-left-s-line text-base font-semibold"></i></a></li>
            <li><a href="https://pars.parskalas.com/?s=اپل واچ&post_type=product"
                class="border-[1px] border-solid border-[#e0e0e2] px-[13px] py-[9px] flex items-center text-[#424750] rounded-full text-sm hover:bg-gray-300 transition">
                اپل واچ <i class="ri-arrow-left-s-line text-base font-semibold"></i></a></li>
            <li><a href="https://pars.parskalas.com/?s=مک بوک سری ۸&post_type=product"
                class="border-[1px] border-solid border-[#e0e0e2] px-[13px] py-[9px] flex items-center text-[#424750] rounded-full text-sm hover:bg-gray-300 transition">مک
                بوک
                سری ۸ <i class="ri-arrow-left-s-line text-base font-semibold"></i></a></li>
            </ul>
        </div>
        </div>
        </form>

        <script>
    document.addEventListener('DOMContentLoaded', function () {
      const swiper = new Swiper('.swiper-container', {
        slidesPerView: '2.5',
        spaceBetween: 0,
        navigation: {
          nextEl: "#nextBtn",
          prevEl: "#prevBtn",
        },
        on: {
          init: function () {
            prevBtn.style.display = "none"; // مخفی کردن دکمه prev در ابتدا
          },
          slideChange: function () {
            // نمایش دکمه prev بعد از حرکت به جلو
            if (this.activeIndex > 0) {
              prevBtn.style.display = "flex";
            } else {
              prevBtn.style.display = "none";
            }

            // مخفی کردن دکمه next در آخرین اسلاید
            if (this.activeIndex >= this.slides.length - this.params.slidesPerView) {
              nextBtn.style.display = "none";
            } else {
              nextBtn.style.display = "flex";
            }
          },
        },
      });
    });
  </script>

  <script>
    const inputField = document.getElementById("txt_search");
    const loadingIcon = document.getElementById("loading");
    const clearButton = document.getElementById("clearButton");
    let typingTimer;

    inputField.addEventListener("input", () => {
      clearTimeout(typingTimer);

      // اگر ورودی خالی بود، ضربدر را مخفی و لودینگ را هم مخفی کن
      if (inputField.value.trim() === "") {
        loadingIcon.classList.add("hidden");
        clearButton.classList.add("hidden");
        return;
      }

      // نمایش لودینگ و مخفی کردن ضربدر
      loadingIcon.classList.remove("hidden");
      clearButton.classList.add("hidden");

      // تنظیم تایمر برای نمایش ضربدر بعد از 1 ثانیه از توقف تایپ
      typingTimer = setTimeout(() => {
        loadingIcon.classList.add("hidden");
        clearButton.classList.remove("hidden");
      }, 1000);
    });

    // وقتی روی ضربدر کلیک شد، مقدار ورودی پاک شود
    clearButton.addEventListener("click", () => {
      inputField.value = "";
      clearButton.classList.add("hidden");
      loadingIcon.classList.add("hidden");
    });
  </script>

        <?php
            
        }
}