<?php

/**
 *  Advanced next shopping system parskala
 *
 * @package      Advanced next shopping
 * @Author      Hosein Esmalian
 * @link        http://parskalas.ir
 */

namespace Prk\Modules\NextShopping;

use Prk\Modules\NextShopping\Includes\Init\Constant_Name;
use Prk\Modules\NextShopping\Includes\Init\Create_Tables;
use Prk\Modules\NextShopping\Includes\Init\Ajax;
use Prk\Modules\NextShopping\Admin\Admin_Menu;
use Prk\Modules\NextShopping\PublicFiles\Cart_Page;

class Next_Shopping_List {
    private static $instance = null;


    public function __construct() {
        if (prk_option('NextShopping_cart') == '1' || prk_option('NextShopping_cart') == ''){
            Constant_Name::define_constant();
            add_action( 'wp', [ $this, 'run_next_shopping_list_prk_wp' ] );
            add_action( 'init', [ $this, 'run_next_shopping_list_prk_init' ] );
        }
    }

    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function run_next_shopping_list_prk_wp() {

    
        if ( is_cart() ) {
            $Cart_Page = new Cart_Page();
            wp_enqueue_script(
                'ajax-nextshop.js',
                get_template_directory_uri() . '/app/Modules/NextShopping/assets/ajax-nextshop.js',
                ['jquery'],
                '1.0.0',
                true
            );

            wp_enqueue_style(
                'nextshop-css',
                get_template_directory_uri() . '/app/Modules/NextShopping/assets/style.css',
                [],
                '1.0.0'
            );
        }
    }

    public function run_next_shopping_list_prk_init() {
        if (is_admin()){
            $Admin_Menu = new Admin_Menu();
        }
        $ajax = new Ajax('prk_add_to_next_shopping_action', 'custom_ajaxurl');
        $Create_tables = new Create_tables();
    }

}