<?php

namespace Prk\Modules\PrkStory;

if (!defined('ABSPATH')) {
    exit;
}

if ( ! defined( 'PRK_PATH' ) ) {
    define( 'PRK_PATH', get_template_directory() . '/app/Modules/PrkStory/' );
}

if ( ! defined( 'PRK_URL' ) ) {
    define( 'PRK_URL', get_template_directory_uri() . '/app/Modules/PrkStory/' );
}

class parskala_story {

    private static $instance = null;

    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {

		if ( prk_option('prk_story_Activation') == 1 ) {
        $this->define_constants();
        $this->includes();
        $this->init_hooks();
       }

    }


    private function define_constants() {
        define('PRKSTORY_VERSION', '3.2.1');
        define('PRKSTORY_PATH', PRK_PATH);
        define('PRKSTORY_DIR', PRK_URL);
    }

    private function includes() {
        require_once PRKSTORY_PATH. 'includes/class-parskala-story-activator.php';
        require_once PRKSTORY_PATH . 'includes/class-parskala-story-deactivator.php';
        require_once PRKSTORY_PATH . 'includes/class-prkstory.php';
    }

    private function init_hooks() {
        register_activation_hook(__FILE__, [$this, 'activate']);
        register_deactivation_hook(__FILE__, [$this, 'deactivate']);
        add_action('init', [$this, 'run']);
    }

    /**
     * عملیات هنگام فعال‌سازی ماژول
     */
    public function activate() {
        \Prkstory_Activator::activate();
    }

    /**
     * عملیات هنگام غیرفعال‌سازی ماژول
     */
    public function deactivate() {
        \Prkstory_Deactivator::deactivate();
    }

    public function run() {
        $plugin = new \Prkstory();
        $plugin->run();
    }
}

