<?php

namespace Prk\Modules\SizeGuide;

// جلوگیری از دسترسی مستقیم
if ( !defined( 'ABSPATH' ) ) exit;

class prk_sizeguide {

	private static $instance;

   
    public static function get_instance() {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

	protected $active = true;

	public function __construct() {

		$this->setupConsts();
		$this->loadFiles();
		add_action( 'admin_init', array( $this, 'activationWooCommerceCheck' ) );
		add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), array( $this, 'descLinks' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'registerAdminAssets' ) );
		

	}
	public static function hasWooCommerce() {
		return class_exists( 'WooCommerce' );
	}
	protected function setupConsts() {
		// define( 'PRK_SIZEGUIDE_DIR', get_template_directory().'/app/Modules/SizeGuide');
		// define( 'PRK_SIZEGUIDE_URI', get_template_directory_uri().'/app/Modules/SizeGuide');
		// define( 'PRK_SIZEGUIDE_ASSETS', get_template_directory_uri().'/app/Modules/SizeGuide/assets/');
	}

	public function activationWooCommerceCheck() {
		if ( ! self::hasWooCommerce() ) {
			add_action( 'admin_notices', array( $this, 'showWooCommerceNotice' ) );
		}
	}

	public function showWooCommerceNotice() {
		echo '<div class="prk-notice error">
                	<p><strong>' . __( 'PARSKALA Size Guide Plugin', 'prk-sgp' ) . '</strong> &#8211; ' . __( 'WooCommerce Plugin must be installed and activated in order to use this plugin.', 'prk-sgp' ) . '</p>
                </div>';
	}
	protected function loadFiles() {
		require_once dirname( __FILE__ ) . '/prkSizeGuideCPT.php';
		require_once dirname( __FILE__ ) . '/prkSizeGuideDisplay.php';
		require_once dirname( __FILE__ ) . '/prkSizeGuideCategories.php';
		require_once dirname( __FILE__ ) . '/prkSizeGuideTable.php';
        require_once dirname( __FILE__ ) . '/integrations/prkSizeGuideProductCsvImport.php';
		require_once dirname( __FILE__ ) . '/prkSizeGuideTags.php';

	}

	/**
	 * Add  links
	 */

	public function descLinks( $links ) {

		return array_merge( array(
			'<a href="' . admin_url( 'admin.php?page=wc-settings&tab=size_guide_tab' ) . '">' . __( 'Settings', 'prk-sgp' ) . '</a>'
		), $links );

	}

	/**
	 * Add assets for admin
	 */

	public function registerAdminAssets( $hook ) {
		$screen = get_current_screen();
		if ( $screen && $screen->id == 'prk_size_guide' ) {
			wp_enqueue_style( 'prk_jquery_edittable', PRK_SIZEGUIDE_ASSETS . 'css/jquery.edittable.min.css' );
			wp_enqueue_script( 'prk_jquery_edittable', PRK_SIZEGUIDE_ASSETS . 'js/jquery.edittable.min.js', array( 'jquery' ) );
			wp_enqueue_style( 'prk_size_admin_style', PRK_SIZEGUIDE_ASSETS . 'css/admin.css' );
		}
        wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_script( 'prk.sg.admin.js', PRK_SIZEGUIDE_ASSETS . 'js/prk.sg.admin.js', array('jquery', 'wp-color-picker') );

	}



}

