<?php
defined('ABSPATH') || exit;

require_once get_template_directory() . "/inc/PRKSMSApp/PRKSMSApp.php";

class ParsKala_Authentication
{
    protected static $_instance = null;

    public $sms_count_code;

    private $sms_expire_code;

    private $login_process;

    private $login_method;

    const DEFAULT_ROLE=[
        'customer',
        'subscriber'
    ];

    const STATUS_MESSAGES=[
        '0000'=>'متاسفانه کد فعالسازی ارسال نشد.',
        '1000'=>'کد فعالسازی برای شما ارسال شد.' ,
        '1001'=>'کد مجدد ارسال شد.',
        '1002'=>'ایمیل تایید شد.',
        '1003'=>'ایمیل وارد شده معتبر نمی باشد.',
        '1004'=>'کد شما منقضی شده است',
        '1005'=>'در حال انتقال...',
        '1006'=> 'بازگشت انجام شد',
        '1007'=> 'کد شما اشتباه است.',
        '1008'=> 'لطفا کد را وارد نمایید :)',
        '1009'=> 'رمز عبور وارد شده اشتباه است.',
        '1010'=>'خطایی رخ داده است با پشتیبانی تماس بگیرید !',
        '1011'=>'ایمیل مجدد با موفقیت ارسال شد.',
        '1012'=>'لطفا رمز عبور خود را وارد نمایید :)',
        '1013' => 'خطایی در ثبت نام رخ داده است.',
        '1014' => 'شماره موبایل نامعتبر است',
        '1015' => 'فرمت ایمیل نامعتبر است',
        '1017' => 'شما محدود شدید',
        '1018' => 'وارد کردن رمز عبور',
        '1020' => 'رمز عبور خود را وارد کنید',

    ];

    public function __construct()
    {

        $this->sms_count_code = $this->prk_opt('gateway_sms_count_number');

        $this->sms_expire_code = $this->prk_opt('gateway_sms_count_number_expire_time');

        $this->sms_expire_code = $this->prk_opt('gateway_sms_count_number_expire_time');

        $this->sms_expire_code = $this->prk_opt('gateway_sms_count_number_expire_time');

        $this->login_process = $this->prk_opt('login_process');

        $this->login_method = $this->prk_opt('login_method');

        $this->init_data();

        $this->load_hook();
   


    }

    public function load_hook()
    {
        
        add_action('init', [$this, 'init_shortcode']);

        add_action('wp_ajax_nopriv_stm_login_register', [$this, 'stm_login_register']);

        add_action('wp_ajax_nopriv_stm_change_email_auth', [$this, 'stm_change_email_auth']);

        add_action('wp_ajax_nopriv_stm_sms_delete_code', [$this, 'stm_sms_delete_code']);

        add_action('wp_ajax_nopriv_stm_sms_check_log_reg', [$this, 'stm_sms_check_log_reg']);

        add_action('wp_ajax_nopriv_stm_sms_check_pass_log_reg', [$this, 'stm_sms_check_pass_log_reg']);

        add_action('wp_ajax_nopriv_stm_retrieve_login_register', [$this, 'stm_retrieve_login_register']);
        add_filter('auth_cookie_expiration', [$this,'auth_cookie_expiration_filter_days_remeber']);


    }

    public function init_shortcode()
    {
       
        add_shortcode('prk_auth_sms', function(){

            $login_method_text = '';

            switch($this->login_method){
                case 'mobile':
                    $login_method_text = 'موبایل';
                        break;
                case 'email':
                    $login_method_text = 'ایمیل';
                        break;
                case 'both':
                    $login_method_text = 'موبایل یا ایمیل';
                        break;
    
            }

            echo $this->get_template_form('form2',['login_method_text'=> $login_method_text]);

        });

        $this->script_enqueue();

    }

    function auth_cookie_expiration_filter_days_remeber()
    {
        $gateway_expire_Session = (int)$this->prk_opt('gateway_expire_Session');

        if($gateway_expire_Session != 0){
            return ($gateway_expire_Session * 24 * 60 * 60);
        }else{
            return  172800;
        }
     
    }

    function script_enqueue(){
        if(!is_admin()){
            wp_enqueue_script( "auth_script", get_template_directory_uri() . "/app/Modules/auth/assets/js/prk_auth.js", array('jquery') );        
        }
       
    }

    public function get_user_by_login($value){
        global $wpdb;
        $value    = sanitize_user( $value );
    
        $user = $wpdb->get_row(
			$wpdb->prepare(
				"SELECT * FROM $wpdb->users WHERE user_login LIKE %s LIMIT 1",
                '%' . $wpdb->esc_like($value) . '%'
			)
		);
      
        if ( ! $user ) {
			return false;
		}

		update_user_caches( $user );
        

		return $user;
        
    }

    public function get_user($key,$type){
        switch($type){
            case 'email':
                $user = get_user_by('email', $key);
                break;
            case 'mobile':
                $mobileregex = "/(\+?98|098|0|0098)?(9\d{9})/" ;  
                if(preg_match($mobileregex, $key,$match)){
                    $user = get_users(array(
                        'meta_key' => 'billing_mobile_phone',
                        'meta_value' => "{$match[2]}",
                        'meta_compare'=>'LIKE'
                    ));
           
                    if(!empty($user)){
                        $user=$user[0];
                    }else{
                       
                        $user=$this->get_user_by_login($match[2]);
                    }
                }else{
                    $user = null;
                }
               
                break;
            default:
                $user=null;

        }
        return $user;
    }

    function login_processing($key,$type,$status){
        if($this->login_process=='pass' && !$this->get_user($key,$type)){
            $this->login_process = 'otp';
        }elseif($this->login_process=='pass_without_email_otp' && !$this->get_user($key,$type)){
           if($type == 'mobile'){
                $this->login_process = 'otp';
            }
        }
        switch($this->login_process){
            case 'pass':
            case 'pass_without_email_otp':
                $this->authPass($key,$status,$type);
            case 'otp':
            case 'both':
                if($type == 'mobile'){
                    $this->authSMS($key,['0000','1000']);
                }elseif($type == 'email'){
                    $this->authEmail($key,['0000','1000']);
                }
        }
    }

    public function stm_login_register(){

        $key = sanitize_text_field($_POST['input']);

        $type = sanitize_text_field($_POST['type']);
        $this->check_limit_req();
        switch($this->login_method){
            case 'mobile':
                if ($type == 'mobile') {
                    $this->login_processing($key,$type,'1018');
                }else{
                    $this->send_json(false,'1014');

                }
            case 'email':
                if($type == 'email') {
                    $this->login_processing($key,$type,'1018');
                }else{
                    $this->send_json(false,'1015');

                }
            case 'both':
         
                    $this->login_processing($key,$type,'1018');
        

        }




    }

    function get_template_form($temlate_name,$data=null){

        if($data && is_array($data)){

            extract($data);

        }

        ob_start();

            include(__DIR__.'/inc/templates/'.$temlate_name.'.php');

        $temlate = ob_get_clean();

        return $temlate;

    }


    public function stm_change_email_auth()
    {

        $this->send_json(true,'1006',$this->get_template_form('form1'));

    }

    public function stm_sms_delete_code()
    {

        $key = $_POST['input'];

        $this->stm_sms_remove_key($key);

    }

    function register_user_email($email,$pass=null){


        if(is_null($pass)){
            $pass = $email;
        }

        $userdata = array(
            'user_login' => apply_filters('pre_user_login', $email),
            'user_email' => apply_filters('pre_user_email', $email),
            'display_name' => apply_filters( 'pre_user_display_name', $this->prk_opt('pre_user_rej_name') ? $this->prk_opt('pre_user_rej_name') : 'کاربر گرامی' ),
            'user_pass' => apply_filters('pre_user_pass', $pass),
            'role' => (in_array($this->prk_opt('prk_login_form_default_role'),self::DEFAULT_ROLE)) ? $this->prk_opt('prk_login_form_default_role'):'customer'

        );
     
        $user_id = wp_insert_user($userdata);

        if (is_wp_error($user_id)):

            $this->send_json(false,'1013');

        endif;

        update_user_meta($user_id, 'billing_email', $email);

        return $user_id;

    }
    function register_user_mobile($mobile,$pass=null){



        if(is_null($pass)){
            $pass = $mobile;
        }
        $userdata = array(
            'user_login' => apply_filters('pre_user_login', $mobile),
            'user_pass' => apply_filters('pre_user_pass', $pass),
            'display_name' => apply_filters( 'pre_user_display_name', $this->prk_opt('pre_user_rej_name') ? $this->prk_opt('pre_user_rej_name') : 'کاربر گرامی' ),
            'role' => (in_array($this->prk_opt('prk_login_form_default_role'),self::DEFAULT_ROLE)) ? $this->prk_opt('prk_login_form_default_role'):'customer'

        );

        $user_id = wp_insert_user($userdata);

        if (is_wp_error($user_id)):

            $this->send_json(false,'1013');

        endif;

        update_user_meta($user_id, 'billing_phone', $mobile);

        // updates account_meta
        update_user_meta($user_id, 'billing_mobile_phone', $mobile);

        update_user_meta($user_id, 'digits_phone_no', $mobile);

        update_user_meta($user_id, 'digits_phone', $mobile);

        return $user_id;

    }
    public function check_log_reg($key,$type){
        $user_id = 0;
        $user = $this->get_user($key,$type);

        if($this->login_process=='both'){
            $this->authPass($key,'1020',$type);
        }
        if (!empty($user) && isset($user->ID)) {

            $user_id = $user->ID;

        } else {

            if($this->login_process=='pass'){
                $this->authPass($key,'1020',$type);
            }else{

                switch($type){

                    case 'email':

                         $user_id = $this->register_user_email($key);

                        break;

                    case 'mobile':

                         $user_id = $this->register_user_mobile($key);

                        break;
                }

                



            }
        }

        if(isset($_SESSION['attempt'])){
            unset($_SESSION['attempt']);

        }
        if(isset($_SESSION['attempt_again'])){
            unset($_SESSION['attempt_again']);

        }

        wp_clear_auth_cookie();

        wp_set_current_user($user_id);

        wp_set_auth_cookie($user_id,true);

        $this->stm_sms_remove_key($key);

        $this->send_json(true,'1005');
        
    }
    public function stm_sms_check_log_reg()
    {
       
        $key = sanitize_text_field($_POST['key']);

        $value = sanitize_text_field($_POST['value']);

     

        $stm_counter = sanitize_text_field($_POST['counter']);

        $data_key = $this->verify_code($key, $value);

        if ($stm_counter == '00:00'):
            
            $this->stm_sms_remove_key($key);

            $this->send_json(false,'1004');
            
        endif;

        if (!empty($value)):
           
            if (isset($data_key->type)) {

              
                $this->check_log_reg($key,$data_key->type);

            } else {

                $this->send_json(false,'1007');

            }

        else:

            $this->send_json(false,'1008');

        endif;
    }


    public function check_pass_log_reg_email($key,$pass){
        $user_id = 0;

        $user = get_user_by('email', $key);

        if (!empty($user) && isset($user->ID)) {

            $user_id = $user->ID;

            $info = wp_authenticate_email_password(null, $key, $pass);

            if (is_wp_error($info)):

                $this->send_json(false,'1009');
              
            endif;

            $loginResult = wp_signon([
                'user_login' => $info->user_login,
                'user_password' => $pass,
                'remember' => true
            ]);

            if (is_wp_error($loginResult)):

                $this->send_json(false,'1010');

            endif;

        } else {

            $user_id = $this->register_user_email($key,$pass);
        }

        return $user_id;
    }
    public function check_pass_log_reg_mobile($key,$pass){
        $mobileregex = "/(\+?98|098|0|0098)?(9\d{9})/" ;  
        if(preg_match($mobileregex, $key,$match)){


             
                $data_user = $this->get_user($key,'mobile');

                if (!empty($data_user) && isset($data_user->ID)) {

                    $user_id = $data_user->ID;
                    
                    if(!wp_check_password($pass,$data_user->user_pass,$user_id)){
                        $this->send_json(false,'1009');
                    }

                    $loginResult = wp_signon([
                        'user_login' => $data_user->user_login,
                        'user_password' => $pass,
                        'remember' => true
                    ]);

                    if (is_wp_error($loginResult)):

                        $this->send_json(false,'1010');

                    endif;

                } else {
                

                    $user_id =$this->register_user_mobile($key,$pass);
                  
                }


                return $user_id;

     }
    }
    public function stm_sms_check_pass_log_reg()
    {
        
        $key = sanitize_text_field($_POST['key']);

        $value = sanitize_text_field($_POST['value']);

        if (!empty($value) && !empty($key)){

            if (is_email($key)){

                $user_id = $this->check_pass_log_reg_email($key,$value);

            }else{


                $user_id = $this->check_pass_log_reg_mobile($key,$value);
            
             }

             wp_clear_auth_cookie();

             wp_set_current_user($user_id);

             wp_set_auth_cookie($user_id,true);
             
             $this->send_json(true,'1005');


    }else{

        $this->send_json(false,'1012');

    }

    }

    function send_json($status,$code,$data=null){

        $arr =  array(
            'success' => $status,
            'text' => self::STATUS_MESSAGES[$code],
            'code'=>$code
        );

        if(!is_null($data)){

            $arr['data'] = $data;

        }

        wp_send_json($arr);

    }

    public function stm_retrieve_login_register()
    {

        $key = sanitize_text_field($_POST['input']);

        $type = sanitize_text_field($_POST['type']);
        
        $this->check_limit_req();


        if ($type == 'mobile') {

            $this->authSMS($key,['0000','1001']);


        } elseif ($type == 'email') {
            
            $this->authEmail($key,['0000','1008']);
            
        }
 
    }

    /**
     * Return Setting
     * @param $prk_id_opt
     * @return mixed
     */
    public function prk_opt($prk_id_opt)
    {

        $prk_option = get_option('prk_option');

        $prk_echo_opt = '';

        if (!empty($prk_option[$prk_id_opt])):

            $prk_echo_opt = $prk_option[$prk_id_opt];

        endif;

        return $prk_echo_opt;

    }

    public static function init()
    {

        if (is_null(self::$_instance)) {

            self::$_instance = new self();

        }

        return self::$_instance;

    }

    /**
     * Creat Table DB
     */
    public function init_data()
    {

        global $wpdb;

        $prk_table_name = $wpdb->prefix . 'prk_verify_code';

        if (!$wpdb->get_var("SHOW TABLES LIKE '$prk_table_name'") == $prk_table_name) :

            $prk_sql_sms = "CREATE TABLE IF NOT EXISTS `" . $prk_table_name . "` (
          `ID` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
          `key_code` varchar(255) NOT NULL,
          `value_code` varchar(255) NOT NULL,
          `expire` varchar(255) NOT NULL,
          `type` enum('mobile','email') NOT NULL,
          PRIMARY KEY (`ID`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;";

            require_once(ABSPATH . 'wp-admin/includes/upgrade.php');

            dbDelta($prk_sql_sms);

        endif;

    }

    /**
     * Generate Code
     * @return int
     */
    public function generate_random_code()
    {

        return rand(pow(10, $this->sms_count_code - 1), pow(10, $this->sms_count_code) - 1);

    }


    public function verify_code($key, $value)
    {

        global $wpdb;

        $table = $wpdb->prefix . 'prk_verify_code';

        $data_key = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table WHERE key_code = '%s' AND value_code = '%s' ", $key, $value));

        return $data_key;

    }

    public function verify_key($key)
    {

        global $wpdb;

        $table = $wpdb->prefix . 'prk_verify_code';

        return $wpdb->get_row($wpdb->prepare("SELECT * FROM $table WHERE key_code = %s", $key));

    }

    public function stm_sms_remove_key($key_code)
    {

        global $wpdb;

        $main_data = $this->verify_key($key_code);

        if (!empty($main_data)):

            $table = $wpdb->prefix . 'prk_verify_code';

            return $wpdb->get_row($wpdb->prepare("DELETE FROM $table WHERE id = %s", $main_data->ID));

        endif;

    }

    public function generate_verify_code($key,$type)
    {

        global $wpdb;

        $table = $wpdb->prefix . 'prk_verify_code';

        $expire = $this->sms_expire_code;

        $code = $this->generate_random_code();

        $row = $this->verify_key($key);

        if ($row->ID) {

            $wpdb->update(
                $table,
                array(
                    'key_code' => $key,
                    'value_code' => $code,
                    'expire' => $expire,
                    'type' => $type,
                ),
                array('ID' => $row->ID),
                array(
                    '%s',
                    '%s',
                    '%s',
                    '%s',
                ),
                array('%d')
            );

        } else {

            $wpdb->insert(
                $table,
                array(
                    'key_code' => $key,
                    'value_code' => $code,
                    'expire' => $expire,
                    'type' => $type,
                ),
                array(
                    '%s',
                    '%s',
                    '%s',
                    '%s',
                )
            );

        }

        return $code;

    }

    public function authPass($key,$status,$user_login_type){
   
      //  if($this->login_process == 'pass'){
            $htmlData  =  $this->stm_password_confirm($key,$user_login_type);
          
            $this->send_json(true,$status,$htmlData);
      //  }
    }

    public function check_limit_req(){
        //set login attempt if not set
		if(!isset($_SESSION['attempt'])){
			$_SESSION['attempt'] = 0;
		}
 
		//check if there are 3 attempts already
		if($_SESSION['attempt'] >= 1 && wp_doing_ajax()){
            	//check if can login again
            if(isset($_SESSION['attempt_again'])){
                $now = time();
                $remaining_time_limit = $_SESSION['attempt_again'] - $now;
                $text_limit = "شما محدود شدید تا :";

                if($now >= $_SESSION['attempt_again']){

                    unset($_SESSION['attempt']);
                    unset($_SESSION['attempt_again']);
                }else{
                    $htmlData = $text_limit.'<span class="login-limit-counter-again" id="login-limit-counter-again" data-countdown-seconds="'.$remaining_time_limit.'"></span>';
                    $this->send_json(false,'1017',$htmlData);
                }
            }
		}
       
		
    }



    function authSMS($key,$status){
   

    if (get_option("prk_sms_otp_user_status")) {
        $this->check_limit_req();
        $code = $this->generate_verify_code($key,'mobile');
            if ($templateID = get_option("prk_sms_otp_user_template")) {
                    $parameters = ["name"=>"prk_sms_otp_user_text",
                    "params"=>[
                        (object)[
                            "name"  => "code",
                            "value" => "$code"
                        ],
                      
                    ]];
                    $payamak = PRKSMSAppClass::sendVerifySMS($parameters, $templateID, "$key");
                
            } else {
                    $text = get_option("prk_sms_otp_user_text");
                    $text = str_replace("#code#", $code, $text);
             
                    $payamak = PRKSMSAppClass::sendBulkSMS($text, ["$key"]);
                
            }

            $htmlData  = $this->stm_confirm($key,'mobile');

            if(isset($payamak->status) && $payamak->status ==1){

					//this is where we put our 3 attempt limit
					$_SESSION['attempt'] += 1;
					//set the time to allow login if third attempt is reach
					if($_SESSION['attempt'] == 3){
						$_SESSION['attempt_again'] = time() + (2*60);
						//note 5*60 = 5mins, 60*60 = 1hr, to set to 2hrs change it to 2*60*60
					}

                $this->send_json(true,$status[1],$htmlData);
    
            }else{
    
                $this->send_json(false,$status[0]);
    
            }
        
    }
}

    public function authEmail($key,$status){

        $this->check_limit_req();


        if (is_email($key)){

                $title = $this->prk_opt('email_otp_title');

                $content = $this->prk_opt('email_otp_content');
                
                $code  = $this->generate_verify_code($key,'email');

                $tags = array(
                    '{code}'  => $code
                );

                $content = str_ireplace( array_keys( $tags ), array_values( $tags ), $content );
                $content = str_ireplace( array( '<br>', '<br/>', '<br />', '&nbsp;' ), array( '', '', '', ' ' ), $content );
                ob_start();
                include __DIR__.'/inc/templates/email-template.php';
                $html = ob_get_clean();

                $headers = array( 'Content-type: text/html');
                $email = wp_mail($key, $title, $html,$headers);
                $data  = $this->stm_confirm($key,'email');
            

            if( $email){

                //this is where we put our 3 attempt limit
                $_SESSION['attempt'] += 1;
                //set the time to allow login if third attempt is reach
                if($_SESSION['attempt'] == 3){
                    $_SESSION['attempt_again'] = time() + (2*60);
                    //note 5*60 = 5mins, 60*60 = 1hr, to set to 2hrs change it to 2*60*60
                }


                $this->send_json(true,$status[1],$data);
            }else{
                $this->send_json(false,$status[0]);
            }

            // $data  =  $this->stm_password_confirm($to,'email');

            
            

        }else{

            $this->send_json(false,$status[0]);
        }

    }

    public function stm_dash_input()
    {

        $dash = '';

        for ($n = 1; $n <= $this->sms_count_code; $n++) {

            $dash .= '-';

        }

        return $dash;

    }



    function stm_confirm($key, $type)
    {
       
        $text_title = 'کد برای شما ارسال شده است';

        if ($type == 'mobile') :

            $text_title = 'کد تایید را وارد کنید';

        elseif ($type == 'email'):

            $text_title = 'کد تأیید به ایمیل شما ارسال شد :';

        endif;

        if($this->login_process == 'pass'){
            $continue = 'pass';
        }else{
            $continue = 'finish';
        }
     
        return $this->get_template_form('form3',['key'=>$key,'text_title'=>$text_title,'continue'=>$continue]);

    }

    function stm_password_confirm($key, $type)
    {
     
        $text_title = 'کد برای شما ارسال شده است';

        if ($type == 'mobile') {

            $text_title = 'موبایل وارد شده:';
            // $data_users = get_users(array(
            //     'meta_key' => 'billing_mobile_phone',
            //     'meta_value' => "$key",
            //     'meta_compare' => 'LIKE'
            // ));
            $data_user = $this->get_user($key,$type);
            
           


        }elseif ($type == 'email'){

                $text_title = 'ایمیل وارد شده :';
                // $data_user = get_user_by('email', $key);
                $data_user = $this->get_user($key,$type);


        }


        $reset_pass = '';

        $txt_title = 'حساب کاربری';

        if (!empty($data_user) && isset($data_user->ID)):

            $txt_title = 'رمز عبور را وارد کنید.';

            $reset_pass = '<a class="stm-reset-pass" href="' . get_permalink(get_option('woocommerce_myaccount_page_id')) . 'lost-password">فراموشی رمز عبور</a>';

        else:

            $txt_title = 'حساب کاربری جدید';

            $reset_pass = 'رمز عبور جدید را وارد کنید.';

        endif;

        return $this->get_template_form('form4',['key'=>$key,'text_title'=>$text_title,'txt_title'=>$txt_title,'reset_pass'=>$reset_pass]);
        
    }
}

ParsKala_Authentication::init();
session_write_close();
