<?php 
namespace Prk\Woocommerce\Archive;

class Orderby_Stock_Status {

    private static $instance;

    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function __construct(){

            add_filter('posts_clauses', array($this, 'order_by_stock_status'), 2000);
    }

    public function order_by_stock_status($posts_clauses){
        global $wpdb;
        if (!is_page() && !is_single() && !is_admin() && is_woocommerce() && is_archive() ) {
          
            $posts_clauses['join'] .= " INNER JOIN $wpdb->postmeta istockstatus ON ($wpdb->posts.ID = istockstatus.post_id) ";
            $posts_clauses['orderby'] = " istockstatus.meta_value ASC, " . $posts_clauses['orderby'];
            $posts_clauses['where'] = " AND istockstatus.meta_key = '_stock_status' AND istockstatus.meta_value <> '' " . $posts_clauses['where'];
        }
        return $posts_clauses;
    }
}