<?php

namespace Prk\Woocommerce\Archive;

class infinite_scroll {

    private static $instance = null;

    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
   
    public function __construct() {
        
        add_action('wp_head', array($this, 'infinite_scroll_header_function'));
    }

    // متد پابلیک برای پردازش هدر
    public function infinite_scroll_header_function() {
        if( prk_option('ajax_prod_auto') == '1' && ( is_shop() || is_product_category() ) ) {
            $this->set_posts_per_page(12);
            $image_url = get_parent_theme_file_uri('assets/img/loader.gif');
            $logo_uploaded = prk_option('ajax_prod_auto_image_url');

            if (isset($logo_uploaded['url']) && !empty($logo_uploaded['url'])) {
                $image_url = esc_url($logo_uploaded['url']);
            }

            $this->enqueue_infinite_scroll_script($image_url);
        } else {
            $this->print_empty_script();
        }
    }

 
    private function set_posts_per_page($count) {
        update_option('posts_per_page', $count);
    }

    private function enqueue_infinite_scroll_script($image_url) {
        ?>
        <script type="text/javascript">
            var next_Selector = '.next';
            var item_Selector = '.product';
            var content_Selector = '.prk-product-archive-con';
            var image_loader = '<?php echo $image_url; ?>';
        </script>
        <style>
            .woocommerce-pagination {
                display: none;
            }
        </style>
        <?php
        wp_enqueue_script("scroll-js", parskala_URI.'/app/Woocommerce/archive/assets/js/wo_infinite_scroll.js', array('jquery'), '', true);
        wp_localize_script("scroll-js", "infi_scrol_ajaxurl", array('ajaxurl' => admin_url('admin-ajax.php')));
    }

    private function print_empty_script() {
        ?>
        <script type="text/javascript">
            function prk_ajax_load_product() {
                // عملکردی ندارد
            }
        </script>
        <?php
    }
}
