<?php


namespace Prk\Woocommerce\Archive;

class prk_hooks_archive {

    private static $instance = null;

    private function __construct() {
    
        if (is_admin()) return;
        add_filter( 'woocommerce_get_catalog_ordering_args', [$this, 'prk_woocommerce_get_catalog_ordering_args'], 10, 3 );
        add_action('prk_before_shop_page', [$this, 'prk_before_shop_page_woocomerce']);
        add_action('prk_shop_before_main_content', [$this, 'prk_before2_main_content']);
        add_action('prk_after_shop_page', [$this, 'prk_after_shop_page_woocomerce'],9);
        add_action('prk_after_shop_page','woocommerce_taxonomy_archive_description',10);
        add_filter('prk_after_shop_page',[$this, 'inner_product_content_shop'],11);
        add_action('woocommerce_shop_loop_item_title', [$this,'prk_onsale_loop_product'], 8 );
        add_action('woocommerce_shop_loop_item_title', [$this,'prk_thumbnail_loop_product'], 9 );
        add_action('woocommerce_shop_loop_item_title', [$this, 'prk_title_loop_product'], 10 );
        add_action('woocommerce_shop_loop_item_title', [$this, 'prk_stock_loop_product'], 11 );
        add_action('woocommerce_after_shop_loop_item_title','prk_price_loop_product',98);
        add_action('woocommerce_after_shop_loop_item_title','prk_author_loop_product',12);
        add_filter( 'woocommerce_widget_get_current_page_url', [$this,'prk_widget_get_current_page_url'] );
 
    


        // حذف هوک های پیشفرض ایتم های محصولات
        remove_action( 'woocommerce_before_shop_loop_item_title','woocommerce_template_loop_product_thumbnail', 10 );
        remove_action( 'woocommerce_archive_description', 'woocommerce_taxonomy_archive_description' );
        remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );
        remove_action( 'woocommerce_before_shop_loop_item_title','woocommerce_show_product_loop_sale_flash', 10 );
        remove_action( 'woocommerce_after_shop_loop_item_title','woocommerce_template_loop_rating', 5 );
        remove_action( 'woocommerce_after_shop_loop_item_title','woocommerce_template_loop_price', 10 );
        remove_action( 'woocommerce_after_shop_loop_item','woocommerce_template_loop_add_to_cart', 10 );
        remove_action( 'woocommerce_before_shop_loop' , 'woocommerce_result_count', 20 );
        remove_action( 'woocommerce_before_shop_loop' ,'woocommerce_catalog_ordering', 30 );
        remove_action( 'woocommerce_archive_description','woocommerce_product_archive_description' );

    }

    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }



     
    // add stock after title woocommerce loop
    public function prk_stock_loop_product() {

    echo '<div class="flexed stock_box">';

      pr_stock();

        if (prk_option('product_rate')) {
          pr_star();
        }


    echo '</div>';

    }


    public function prk_widget_get_current_page_url( $link ) {
      if ( isset( $_GET['stock_status'] ) ) {
        $link = add_query_arg( 'stock_status', wc_clean( $_GET['stock_status'] ), $link );
      }
  
          if ( isset( $_GET['filter_brand'] ) ) {
        $link = add_query_arg( 'filter_brand', wc_clean( $_GET['filter_brand'] ), $link );
      }
  
          if ( isset( $_GET['filter_cat'] ) ) {
        $link = add_query_arg( 'filter_cat', wc_clean( $_GET['filter_cat'] ), $link );
      }
  
      return $link;
    }




    public function prk_title_loop_product() {
        echo '<div class="index-title-pro archive">';
         echo '<h2 class="woocommerce-loop-product_title"><a href="'.get_the_permalink().'">' . get_the_title() . '</a></h2>';
        echo '</div>';
    }

    public function prk_before_shop_page_woocomerce(){

        $product_count = prk_option('archive_product_product_count');
        $offer = $catchild_true = $offer_text = $backcolor = $product_count = "";
      
        if (is_product_category()){
      
          $term = get_queried_object();
          $children = get_terms( $term->taxonomy, array(
              'parent'    => $term->term_id,
              'hide_empty' => false
          ) );
      
          $wenderfol = get_parent_theme_file_uri('assets/img/wenderfol.svg');
          $meta = get_term_meta( $term->term_id, 'prk_taxonomy_options', true );
      
          if(isset($meta) && !empty($meta)){
              if (isset($meta['offer']))		$offer    = $meta['offer'];
              if (isset($meta['catchild-true']))	$catchild_true    = $meta['catchild-true'];
              if (isset($meta['offer_text']))		$offer_text    = $meta['offer_text'];
          }
      
        }
      
      
          if ( $offer == '1' ) {
            $offer_class = ' offer';
          }else {
            $offer_class = '';
          }
      
        // change akax page
        echo '<div id="prk_content">';
      
      
        if ( is_product_category() && $offer == '1' ){
      
          echo '<div class="wenderfol_archive">';
          echo '<div class="continer">';
      
            echo '<span class="wenderfol_img">';
      
              echo '<img src="' .esc_url($wenderfol). '" alt="promotion">';
      
            echo '</span>';
      
          echo '<span class="vanderfol_title">'.$offer_text.'</span>';
      
          echo '</div></div>';
      
        }
         
        $balance_side = prk_option('max_continer')['width'] < '1400' ? ' balance_shop' : '';
       
      
        echo '<div class="constiky'.$offer_class. ''. $balance_side.'">';
      
        if (is_product_category() || is_shop()){
      
         
      
            $terms = get_terms([
                'taxonomy' => 'product_cat',
                'hide_empty' => false,
                'parent' => get_queried_object_id()
            ]);
      
            $settings_slider =  array(
              'loop'     => 'false',
              'nav'      => 'false',
              'autoplay' => 'false',
              'delay'    =>  300,
              'item'     => 7,
              'margins'  => 4,
      
            );
      
            $json_settings = json_encode($settings_slider);
      
            if (mobile_cheker() || tablet_cheker()) {
                    $class_dev = 'verticaler';
                    $class_section = 'carousel_lister';
                    $json_settings = '';
                }else {
                    $class_dev = '';
                    $class_section = 'carousel-items';
                    $json_settings = json_encode($settings_slider);
                }
      
              if ( (prk_option('archive_product_subcategories_order') == 'top_sidebar' || prk_option('archive_product_subcategories_order') == '') ){
      
                  echo \Prk\Woocommerce\archive\subcategories_box::get_instance()->prk_subcategories_product();
              
              }
            
          }
      
      
      
         // get sidebar shop
         if ( is_active_sidebar('sideby-pro-widget') && prk_option('active_side_shop') == 1 ) {
      
           if ( !mobile_cheker() && !tablet_cheker() ) {
              echo '<div id="sides" class="sides '.$offer_class.'">';
      
                dynamic_sidebar('sideby-pro-widget');
      
              echo '</div>';
           }
        }
      
         if ( empty( is_active_sidebar('sideby-pro-widget') ) || empty( prk_option('active_side_shop') )  ) {
           $class_shop = 'fullw';
         }else {
           $class_shop = '';
         }
        // start main item products
        echo '<main class="left-store '.$class_shop.'">';
      
        if (  prk_option('archive_product_subcategories_order') == 'next_sidebar' ){
      
        echo \Prk\Woocommerce\archive\subcategories_box::get_instance()->prk_subcategories_product();
      
        }
      
    }

    // قلاب اندازی قبل از قلاب اصلی  صفحه فروشگاه
    public function prk_before2_main_content(){


        $classes = 'prk-product-archive-con';
        $classes .= (  prk_option( 'prk_shop_ajax_add' ) ? ' ajax-prod' : '');
        $classes .= (  prk_option( 'prk_shop_ajax_add' ) &&  prk_option( 'ajax_prod_auto' )  ? ' ajax-prod-auto' : '');
        $ajax_prod_auto = (  prk_option( 'prk_shop_ajax_add' ) &&  prk_option( 'ajax_prod_auto' )  ? ' data-auto-ajax-load="100"' : ' data-auto-ajax-load="false"');
        $ajax_prod_history = (  prk_option( 'prk_shop_ajax_add' ) &&  prk_option( 'ajax_prod_history' )  ? ' data-ajax-prod-history="push"' : ' data-ajax-prod-history="false"');
    
        echo '<div class="left-index '.$classes.'" '.$ajax_prod_auto . $ajax_prod_history.'>';
    
    
        // sort by filter pc
        if ( empty(mobile_cheker()) && empty(tablet_cheker()) ) {
        echo '<div class="prk-head-shop">';
    
        echo '<div class="flexed">';
            $this->prK_orderby_filter();
            $this->pr_count_pages();
        echo '</div>';
    
        echo '</div>';
        }
    
        // head shop page mobile
        if ( mobile_cheker() || tablet_cheker() ) {
    
        // sort by filter pc
        echo '<div class="prk-head-shop-mobile">';
    
        echo '<div class="flexed title_shop">';
    
            $this->woocommerce_page_title();
            $this->pr_count_pages();
    
        echo '</div>';
    
        echo '<div class="box-filter-shop">';
            $this->prK_sidebarshop_mobile();
            $this->prK_orderby_filter_mobile();
        echo '</div>';
    
        echo '</div>';
    
        }
    }

    
    // after shop page
    public function prk_after_shop_page_woocomerce(){
    
        $order_typle_des = prk_option('archive_product_description_order') == 'next_sidebar' ? ' next_sidebar_order' : ' bottom_sidebar_order';
        if ( prk_option('archive_product_description_order') == 'bottom_sidebar' || prk_option('archive_product_description_order') == ''  ){
            // بسته شدن عنصر والد آیتم محصولات فروشگاه
            echo '</div>';
            echo '</main>';
        }

        $brand_slug = prk_option('product_brand_slug') ? prk_option('product_brand_slug') : 'brand';
        if ( is_tax( array( 'product_cat', 'product_tag' , $brand_slug ) ) && get_query_var( 'paged' ) == 0 ) {

            echo '<div class="footer-description-shop'.$order_typle_des.'">';
            
            if (prk_option('show_title_cat_archive') == '1' || prk_option('show_title_cat_archive') == '' ){


            echo '<h1 class="title-category">';

                echo single_cat_title();
            
            echo '</h1>';

            }

        }

    }


    public function inner_product_content_shop(){

        $description = wc_format_content( term_description() );
        if ( $description && is_tax( array( 'product_cat', 'product_tag', 'brand' ) ) && get_query_var( 'paged' ) == 0 ) {
            echo '<a href="#" class="mask-handler"><span class="show-more">نمایش بیشتر</span><span class="show-less">- بستن</span></a>';


            do_action('prk_after_des_shop');
            
            echo '</div>';
        }

        echo '</div>';

        if ( prk_option('archive_product_description_order') == 'next_sidebar' ){
            // بسته شدن عنصر والد آیتم محصولات فروشگاه
            echo '</div>';
            echo '</main>';
        }

    }


    // Ordering products based on the selected values
    public function prk_woocommerce_get_catalog_ordering_args( $args, $orderby, $order ) {
        switch( $orderby ) {
            case 'availability':
                $args['orderby']  = 'meta_value_num';
                $args['order']    = 'DESC';
                $args['meta_key'] = '_stock';
            break;
        }

        return $args;
    }

    public function prk_onsale_loop_product() {
      
        $this->pr_onsale_head();
    
        $product_label = get_post_meta(get_the_ID(), 'prk_product_label', true );
        if ($product_label){
           echo '<div class="custom_label"><span>'.$product_label.'</span></div>';
        }
          
        
    }

    public function pr_onsale_head(){

        global $post, $product;
        $onsales_round = '';
      
        if ( $product -> is_type( 'variable' ) ) {
          $children_ids = $product->get_children();
          $date = '';
          foreach ( $children_ids as $children_id ) {
              if ( ! empty( $date ) )
                  break;
              $child_date = get_post_meta( $children_id, '_sale_price_dates_to', true );
              if ( ! empty( $child_date ) ) {
                  $date = $child_date;
              }
          }
      } else {
       $date = get_post_meta( $product->get_id(), '_sale_price_dates_to', true );
      }
        $sale = get_post_meta( get_the_ID(), '_sale_price', true);
        $onsales_round = get_post_meta(get_the_ID(), 'onsales_round', 'no' );
        $timer_id = generateRandomString();
      
      
      
        if ($onsales_round == 'yes' ) {
      
        $onsale_title = 'پیشنهاد ویژه';
      
        }elseif( $product->is_on_sale() ) {
      
          $onsale_title = 'فروش ویژه';
      
        }
      
      
      
          if ( $onsales_round == 'yes' || $sale ){
          // sale-flash
          echo '<div class="head-archie-pro">';
      
          echo '<span class="onsale prs">'.$onsale_title.'</span>';
      
            if($date){
      
             ?>
             <p id="sales_timer_display" class="timer-pros1-<?php echo $timer_id;?>"></p>
             <script type="text/javascript">
               var dateEnd = new Date((<?php echo $date; ?>) * 1000);
               new TimezZ('.timer-pros1-<?php echo $timer_id;?>', {
               date: dateEnd,
               template: '<span><span class="number">NUMBER</span><span class="dot">:</span><span class="letter">LETTER</span></span>',
               text: {
               days: 'روز',
               hours: 'ساعت',
               minutes: 'دقیقه',
               seconds: 'ثانیه',
                 }
               });
              </script>
             <?php
            }
            echo '</div>';
          }
      
       
      
      
    }

    // remove def thumbnail woocommerce loop
    public function prk_thumbnail_loop_product() {
        pr_img();
    }


    public function pr_count_pages(){
        if (prk_option('ajax_prod_auto') == '0') {
      
      
        ?>
          <span class="prk_count_pages">
            <?php
            global $wp_query;
            $paged    = max(1, $wp_query->get('paged'));
            $per_page = $wp_query->get('posts_per_page');
            $total    = $wp_query->found_posts;
            $first    = ($per_page * $paged) - $per_page + 1;
            $last     = min($total, $wp_query->get('posts_per_page') * $paged); ?>
            <span class="show_page_count"><?php echo _e('show', 'parskala'); ?></span>
            <span class="show_page_count first"><?php echo ($first); ?></span>
            <span class="show_page_count">-</span>
            <span class="show_page_count last"><?php echo ($last); ?></span>
            <span class="show_page_count line"><?php echo _e('From  ', 'parskala'); ?></span>
            <span class="show_page_count total"><?php echo ($total); ?></span>
            <span class="show_page_count"><?php echo _e(' commodity ', 'parskala'); ?></span>
          </span>
        <?php
      }else {
        ?>
        <span class="prk_count_pages">
          <?php
          global $wp_query;
          $paged    = max(1, $wp_query->get('paged'));
          $per_page = $wp_query->get('posts_per_page');
          $total    = $wp_query->found_posts;
          $first    = ($per_page * $paged) - $per_page + 1;
          $last     = min($total, $wp_query->get('posts_per_page') * $paged); ?>
          <span class="show_page_count"><?php echo _e('show', 'parskala'); ?></span>
      
          <span class="show_page_count total"><?php echo ($total); ?></span>
      
          <span class="show_page_count"><?php echo _e(' commodity ', 'parskala'); ?></span>
        </span>
        <?php
      }
    }

    

    public function prK_orderby_filter() {

        ?>

    <div class="prK_orderby_filtering">
    <svg viewBox="0 0 24 24" class="svg">
        <path fill-rule="evenodd" d="M6 15.793L3.707 13.5l-1.414 1.414 4 4a1 1 0 001.414 0l4-4-1.414-1.414L8 15.793V5H6v10.793zM22 5H10v2h12V5zm0 4H12v2h10V9zm0 4h-8v2h8v-2zm-6 4h6v2h-6v-2z" clip-rule="evenodd"></path>
    </svg>
        <span class="menu_order_title"><?php _e('order by' , 'parskala'); ?>:</span>
        <ul class="prk-order-products">
        <?php

        if( isset($_GET['orderby'] ) ) {
            $orderby = $_GET['orderby'];
        } elseif( is_search() ) {
            $orderby = 'relevance';
        } else {
            $orderby = get_option( 'woocommerce_default_catalog_orderby' );
        }
        ?>

            <?php if( is_search() ){ ?>
            <li class="order-item order-relevance<?php echo ($orderby == 'relevance' ? ' is-active' : ''); ?>">
                <a rel="nofollow" href="<?php echo $this->prk_order_get_link( 'relevance' ); ?>">
                    <?php _e('پیشفرض' , 'parskala'); ?>
                </a>
            </li>

            <?php } elseif( $orderby == 'menu_order' || $orderby == '' ){ ?>
            <li class="order-item order-menu-order<?php echo ($orderby == 'menu_order' || $orderby == '' ? ' is-active' : ''); ?>">
                <a rel="nofollow" href="<?php echo $this->prk_order_get_link( 'menu_order' ); ?>">
                    <?php _e('default' , 'parskala'); ?>
                </a>
            </li>
            <?php } ?>

            <li class="order-item order-rating<?php echo ($orderby == 'rating' ? ' is-active' : ''); ?>">
                <a rel="nofollow" href="<?php echo $this->prk_order_get_link( 'rating' ); ?>">
                    <?php _e('Popular' , 'parskala'); ?>
                </a>
            </li>

            <li class="order-item order-popularity<?php echo ($orderby == 'popularity' ? ' is-active' : ''); ?>">
                <a rel="nofollow" href="<?php echo $this->prk_order_get_link( 'popularity' ); ?>">
                    <?php _e('popularity' , 'parskala'); ?>
                </a>
            </li>

            <li class="order-item order-date<?php echo ($orderby == 'date' ? ' is-active' : ''); ?>">
                <a rel="nofollow" href="<?php echo $this->prk_order_get_link( 'date' ); ?>">
                    <?php _e('newest' , 'parskala'); ?>
                </a>
            </li>

            <li class="order-item order-price<?php echo ($orderby == 'price' ? ' is-active' : ''); ?>">
                <a rel="nofollow" href="<?php echo $this->prk_order_get_link( 'price' ); ?>">
                    <?php _e('cheapest' , 'parskala'); ?>
                </a>
            </li>

            <li class="order-item order-price-desc<?php echo ($orderby == 'price-desc' ? ' is-active' : ''); ?>">
                <a rel="nofollow" href="<?php echo $this->prk_order_get_link( 'price-desc' ); ?>">
                    <?php _e('expensive' , 'parskala'); ?>
                </a>
            </li>
        </ul>
    </div>
    <?php
    }

    // filter by order mobile
    public function prK_orderby_filter_mobile() {

        ?>
        <span class="filter_by_botton show_sortby"><i class="ri-sort-desc"></i>مرتب سازی</span>
        <div id="filter-sidebar-mobile" class="remodals tabs_content_product mob_tab_filter_sortby remodal-full content_filter">
        <div class="remodal-header">
            <div class="title">مرتب سازی</div>
            <button data-remodal-action="close" class="remodal-back-tabs close_sortby">
                <i class="ri-close-line"></i>
            </button>
        </div>

        <div class="prK_orderby_mobile">

            <ul class="prk-order-products">
            <?php

            if( isset($_GET['orderby'] ) ) {
                $orderby = $_GET['orderby'];
            } elseif( is_search() ) {
                $orderby = 'relevance';
            } else {
                $orderby = get_option( 'woocommerce_default_catalog_orderby' );
            }
            ?>

                <?php if( is_search() ){ ?>
                <li class="order-item order-relevance<?php echo ($orderby == 'relevance' ? ' is-active' : ''); ?>">
                    <a rel="nofollow" href="<?php echo $this->prk_order_get_link( 'relevance' ); ?>">
                        <?php _e('پیشفرض' , 'parskala'); ?>
                    </a>
                </li>

                <?php } elseif( $orderby == 'menu_order' || $orderby == '' ){ ?>
                <li class="order-item order-menu-order<?php echo ($orderby == 'menu_order' || $orderby == '' ? ' is-active' : ''); ?>">
                <a rel="nofollow" href="<?php echo $this->prk_order_get_link( 'menu_order' ); ?>">
                    <?php _e('default' , 'parskala'); ?>
                </a>
            </li>
            <?php } ?>

            <li class="order-item order-rating<?php echo ($orderby == 'rating' ? ' is-active' : ''); ?>">
                <a rel="nofollow" href="<?php echo $this->prk_order_get_link( 'rating' ); ?>">
                    <?php _e('Popular' , 'parskala'); ?>
                </a>
            </li>

            <li class="order-item order-popularity<?php echo ($orderby == 'popularity' ? ' is-active' : ''); ?>">
                <a rel="nofollow" href="<?php echo $this->prk_order_get_link( 'popularity' ); ?>">
                    <?php _e('popularity' , 'parskala'); ?>
                </a>
            </li>

            <li class="order-item order-date<?php echo ($orderby == 'date' ? ' is-active' : ''); ?>">
                <a rel="nofollow" href="<?php echo $this->prk_order_get_link( 'date' ); ?>">
                    <?php _e('newest' , 'parskala'); ?>
                </a>
            </li>

            <li class="order-item order-price<?php echo ($orderby == 'price' ? ' is-active' : ''); ?>">
                <a rel="nofollow" href="<?php echo $this->prk_order_get_link( 'price' ); ?>">
                    <?php _e('cheapest' , 'parskala'); ?>
                </a>
            </li>

            <li class="order-item order-price-desc<?php echo ($orderby == 'price-desc' ? ' is-active' : ''); ?>">
                <a rel="nofollow" href="<?php echo $this->prk_order_get_link( 'price-desc' ); ?>">
                    <?php _e('expensive' , 'parskala'); ?>
                </a>
            </li>
            </ul>

        </div>
        </div>
    <?php
    }

    public function prK_sidebarshop_mobile(){

        if ( is_active_sidebar('sideby-pro-widget') ) {
      
          if ( empty(is_active_sidebar('sideby-pro-widget')) ) {
            $class_shop = 'fullw';
          }else {
            $class_shop = '';
          }
          ?>
      
          <span class="filter_by_botton show_sidebar <?php echo $class_shop;?>" ><i class="ri-filter-off-line"></i>فیلتر کردن</span>
          <div id="filter-sidebar-mobile" class="remodals tabs_content_product mob_tab_filter_sidebar remodal-full content_filter" >
      
            <div class="remodal-header">
                <div class="title"><?php echo woocommerce_page_title();?></div>
                <button  class="remodal-back-tabs filter_sides_close">
                  <i class="ri-close-line"></i>
                </button>
            </div>
           <?php
      
           // get sidebar shop
           echo '<div id="sides" class="sides">';
      
            dynamic_sidebar('sideby-pro-widget');
      
           echo '</div>';
      
           ?>
      
          </div>
      
          <?php
        }
      }
      
      //prk_order_get_link
    public function prk_order_get_link( $order_type ) {
          $base_link            = prk_shop_page_link( true );
          $link                 = remove_query_arg( 'orderby', $base_link );
      
          if( $order_type != 'menu_order' ) {
              $link = add_query_arg( 'orderby', $order_type, $link );
              $link = str_replace( '%2C', ',', $link );
          }
      
          return $link;
    }
      

}