<?php


namespace Prk\Woocommerce\Single\Features;


class Image_zoom {
    private static $instance;

    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        if (prk_option('prk_zoom_image') == '1' ){
            add_action('wp_footer',[$this, 'prk_gallery_zoom'],100);
            add_action('wp_enqueue_scripts', [$this, 'load_assets']);

        }

    }


    /**
     * بارگذاری استایل‌ها و اسکریپت‌های مورد نیاز
     */
    public function load_assets() {
          
        $base_path  = parskala_URI.'/app/Woocommerce/Single/Features/';
        wp_enqueue_script('elevateZoom-js', $base_path . 'assets/js/elevateZoom.js', array('jquery'), null, true);
  
    }



    public function prk_gallery_zoom() {
   
        if ( empty(mobile_cheker() ) ) { ?>

            <script>

                jQuery('#attachment-shop_single').elevateZoom({
                        zoomWindowFadeIn: 100,
                        zoomWindowFadeOut: 120,
                        zoomWindowWidth:520,
                        zoomWindowHeight:620,
                        easing : true,
                        zoomWindowPosition: "show_zoom_container",
                        lensSize    : 100,
                        lensOpacity: 1,
                        lensColour: false ,
                        cursor:"crosshair",
                        lensBorderColour: "#EF5661",
                        lensBorderSize: 1,
                        borderSize: 0.5,
                        left: -10,
                        borderColour: "#535353",
                });

                /* ------------------------------ image Zoom product ---------------------- */
                jQuery(".single-pro .thwvsf-checkbox").click(function () {
                    setTimeout(function () {
                    var ez = jQuery(".woocommerce-product-gallery__image .wp-post-image").data("elevateZoom");
                    var smallImage = jQuery(
                        "#attachment-shop_single"
                    ).attr("src");
                    var largeImage = jQuery(
                        ".woocommerce-product-gallery__wrapper .wp-post-image"
                    ).attr("data-src");
                    ez.swaptheimage(smallImage, largeImage);
                    }, 200);
                });

                jQuery(".single-pro input.variation_id").change(function () {
                    // jQuery('.ajax_add_to_cart').attr('data-variation_id',jQuery(this).val());
                    setTimeout(function () {
                    var ez = jQuery(".wp-post-image").data("elevateZoom");
                    var smallImage = jQuery(
                        "#attachment-shop_single"
                    ).attr("src");
                    var largeImage = jQuery(
                        ".woocommerce-product-gallery__wrapper .wp-post-image"
                    ).attr("data-src");
                    ez.swaptheimage(smallImage, largeImage);
                    }, 400);
                });

            </script>
            
            <?php
        }

    }



}