<?php


namespace Prk\Woocommerce\Single\Features;

class Produc_sticky_add2cart {
    private static $instance;

    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {

        if ( !(mobile_cheker() || tablet_cheker()) ){
            add_action( 'woocommerce_after_main_content', [$this, 'prk_sticky_add_to_cart'] );
        }

    }

    public function prk_sticky_add_to_cart() { 
     
        global $product;
        // $coming = get_post_meta( get_the_ID(), 'prk_coming', true );
         $sticky_add_blur = prk_option('show_sticky_add_blur') == '1'  ? 'blure_wite' : '';
    
        if(  ( $product->is_purchasable() || $product->is_type( 'external' ) ) && $product->is_in_stock() && prk_option( 'show_sticky_add' ) ) { ?>
        <div class="prk-sticky-add-cart <?= $sticky_add_blur ?>">
            <div class="continer flexed">
              <div class="prk-sticky-thumb">
                  <?php if ( has_post_thumbnail() ) {
                    echo  get_the_post_thumbnail($product->get_ID(), 'thumbnail' );
                  } else { 
                      prod_default_thumb();
                  } ?>
              </div>
    
              <div class="prk-sticky-title">
                  <?= $product->get_title(); ?>
    
                  <div class="prk-sticky-price  mobit">
                    <div class="index-prices-pro">
                      <div class="price_onsale_ar">
                        <?php woocommerce_template_single_price(); ?>
                      </div>
                    </div>
                  </div>
                  
              </div>
    
    
    
              <?php if( $product->is_type( 'simple' ) )  { ?>
                  <div class="prk-sticky-add">
                    <div class="index-prices-pro">
                      <div class="price_onsale_ar">
                         <?php do_action( 'prk_woocommerce_add_to_cart_form'); ?>
                      </div>
                    </div>
                  
                  </div>
              <?php } elseif ( $product->is_type( 'variable' ) ) { ?>
                  <div class="prk-sticky-add">
                      <span class=" button alt go-to-add">
                          <?php _e( 'انتخاب گزینه' , 'parskala' ); ?>
                      </span>
                  </div>
              <?php } elseif ( $product->is_type( 'external' ) ) { ?>
                  <div class="prk-sticky-add">
                      <?php woocommerce_external_add_to_cart(); ?>
                  </div>
              <?php } ?>
            </div>
        </div>

    <?php } 
    }

}