<?php
namespace Prk\Woocommerce\Single\Features;


class better_product {

    private static $instance;

    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        add_action( 'init', [$this, 'parskala_better_posttype'] );
        add_action( 'wp_footer', [$this, 'modal_better_product'] );
        add_action( 'gettext', [$this, 'change_publish_better'], 10, 2 );
        add_filter('post_updated_messages', [$this, 'codex_better_updated_messages']);
        add_filter( 'add_menu_classes', [$this, 'show_pending_number_better']);
        add_action( "wp_ajax_inset_better_product", [$this, 'inset_better_product'] );
        add_action( "wp_ajax_nopriv_inset_better_product", [$this, 'inset_better_product'] );
        add_action( "woocommerce_product_meta_start", [$this, 'better_product_button'] );
        add_action( 'save_post', [$this, 'subbetter_product_meta_product'], 10, 3 );
        add_action('edit_form_after_title',[$this, 'custom_field_post_type_better']);

    }


    public function parskala_better_posttype() {

        register_post_type( 'product-better',
        // CPT Options
            array(
                'labels' => array(
                    'name' => __( 'گزارش قیمت', 'parskala' ),
                    'singular_name'       => _x( 'better', 'Post Type Singular Name', 'prk' ),
            'view_item'           => __( 'نمایش گزارشات', 'prk' ),
            'add_new'             => __( 'افزودن جدید', 'prk' ),
            'edit_item'           => __( 'ویرایش گزارش', 'prk' ),
            'update_item'         => __( 'بروز رسانی گزارش', 'prk' ),
            'search_items'        => __( 'جستجو در گزارشات', 'prk' ),
            'not_found'           => __( 'گزارشی یافت نشد', 'prk' ),
            'not_found_in_trash'  => __( 'اوپس چیزی پیدا نشد', 'prk' ),
            'item_published'      =>  __( 'اوپس چیزی پیدا نشد', 'prk' ),
    
    
                ),
                'hierarchical'        => false,
                'public'              => false,
                'show_ui'             => true,
                'show_in_menu'        => true,
                'show_in_nav_menus'   => false,
                'show_in_admin_bar'   => false,
                'menu_position'       => 20,
                'can_export'          => true,
                'has_archive'         => false,
                'exclude_from_search' => true,
                'publicly_queryable'  => false,
                            'menu_icon' 				=>  'dashicons-money-alt',
                'show_in_rest' => false,
                'supports' => array( "title"),
    
            )
        );
    }
    public function inset_better_product(){
        $args = array(
            'post_title'    => 'گزارش قیمت برای : '.get_the_title($_POST['product_id']). ' | آیدی محصول:  '. $_POST['product_id'],
            'post_type'    => 'product-better',
            'post_status'  => 'pending',
            'post_parent'  =>$_POST['product_id'],
            'post_author'      => get_current_user_id() ? get_current_user_id() : 1,
        );
        $post_id = wp_insert_post( $args );
            update_post_meta($post_id, 'shop_price', $_POST['shop_price'] );
            update_post_meta($post_id, 'shop_name', $_POST['shop_name'] );
            update_post_meta($post_id, 'shop_city', $_POST['shop_city'] );
            update_post_meta($post_id, 'website_url', $_POST['website_url'] );
        if( $post_id )
            _e('متشکریم ، گزارش شما برای مدیریت ارسال شد.', 'parskala');
        else
            _e('مشکلی پیش آمده است مجددا سعی نمائید.', 'parskala');
    
        die();
    }
    public function show_pending_number_better( $menu ) {
        $type = "product-better";
        $status = "pending";
        $num_posts = wp_count_posts( $type, 'readable' );
        $pending_count = 0;
        if ( !empty($num_posts->$status) )
            $pending_count = $num_posts->$status;
    
        // build string to match in $menu array
        if ($type == 'post') {
            $menu_str = 'edit.php';
        // support custom post types
        } else {
            $menu_str = 'edit.php?post_type=' . $type;
        }
    
        // loop through $menu items, find match, add indicator
        foreach( $menu as $menu_key => $menu_data ) {
            if( $menu_str != $menu_data[2] )
                continue;
            $menu[$menu_key][0] .= " <span class='update-plugins count-$pending_count'><span class='plugin-count'>" . number_format_i18n($pending_count) . '</span></span>';
        }
        return $menu;
    }
    public function codex_better_updated_messages( $messages ) {
        global $post, $post_ID;
        $messages['product-better'] = array(
          0 => '', // Unused. Messages start at index 1.
          1 => sprintf( __('گزارش بروز رسانی شد') ),
          2 => __('Custom field updated.'),
          3 => __('Custom field deleted.'),
          4 => __('Book updated.'),
          /* translators: %s: date and time of the revision */
          5 => isset($_GET['revision']) ? sprintf( __('Book restored to revision from %s'), wp_post_revision_title( (int) $_GET['revision'], false ) ) : false,
          6 => sprintf( __('گزارش به لیست خوانده شده ها اضافه شد') ),
          7 => __('گزارش خوانده شد.'),
      
        );
        return $messages;
    }
    public function change_publish_better( $translation, $text ) {
        global $post;
       if ( get_post_type(get_the_ID()) == 'product-better' && $text == 'Publish' )
           return 'ذخیره به عنوان خوانده شده؟';
       
       return $translation;
    }

    public function modal_better_product(){
   
        global $woocommerce;
        global $product;
         
        ?>
        <!-- start of quick-view-modal -->
        <div class="remodal modal-better remodal-lg remodal-maxed" data-remodal-id="modal-better" data-remodal-options="hashTracking: false">

        <div class="remodal-header">
            <span class="title-feed">گزارش قیمت برای  <?php the_title();?></span>
            <button data-remodal-action="close" class="remodal-close"></button>
        </div>

            <div class="cover-loading-replay"></div>

                <div class="flexright">
                <div class="img-feed">
                    <?php echo get_the_post_thumbnail(get_the_ID(), 'shop_catalog', array( 'class' => 'center' ) ); ?>
                </div>
                        <div class="info-feed">
                <p class="form-better show">
            <label for="better_price">این کالا را با چه قیمتی دیده‌اید؟</label>
            <input type="text" name="better_price" id="better_price" placeholder="<?= _e('For example, 42,000','parskala') ?>">
            <span class="input_better">تومان</span>
                </p>
            <div class="flex_right swicher">
                <label class="switch">
                <input id="swich_before" type="checkbox" class="check_before" checked>
                <span class="slider"></span>
                </label>
                    <label class="swich_before" for="swich_before">در فروشگاه اینترنتی دیده‌ام</label>
                </div>
                <p class="form-better site show">
            <label for="better_price">آدرس اینترنتی فروشگاه</label>
            <input type="text" name="better_url" id="better_url" placeholder="www.example.com">
                </p>
                <p class="form-better shop">
            <label for="better_price">نام فروشگاه</label>
            <input type="text" name="better_name" id="better_name">
                </p>
                <p class="form-better shop">
            <label for="better_price">مکان فروشگاه</label>
            <input type="text" name="better_city" id="better_city" placeholder="تهران">
                </p>
                <span data-remodal-action="close" class="insert-better">ثبت اطلاعات</span>
                </div>
                </div>
        </div>

            <script>
                jQuery(document).ready(function($){

                $('.check_before').on('click', function(){
                    is_checked = $(this).is(':checked');
                    if(is_checked == true){
                    $('.form-better.site').addClass('show');
                    $('.form-better.shop').removeClass('show');
                    }else{
                    $('.form-better.site').removeClass('show');
                    $('.form-better.shop').addClass('show');
                    }
                });

                    $('.insert-better').click(function(){
                    var button_replay = $(this);
                    if ( button_replay.parent().parent().find('#better_price').val() == '' ) {
                        alert('<?php _e('لطفا قیمت را وارد کنید.', 'parskala'); ?>');
                        return;
                    }
                        $('.cover-loading-replay').show(0);

                        $.post(parskala_values.ajax_url,
                        {
                            action: "inset_better_product",
                            product_id: "<?php echo $product->get_id(); ?>",
                        shop_price: $('#better_price').val(),
                        website_url: $('#better_url').val(),
                        shop_name: $('#better_name').val(),
                        shop_city: $('#better_city').val(),
                        },
                        function(data, status){
                            alert(data);
                            $('.user-feed').val('');
                            $('.feed.micromodal-slide').removeClass('is-open');
                                            $(".body").css("overflow", "unset");
                                            $(".body").css("height", "unset");
                                            $('.better-btn').removeClass('show');
                                            $('.better-btn.thanks').addClass('show');
                            $('.cover-loading-replay').hide(0);
                        });
                    });

                });
            </script>

                <?php
    }

    public function better_product_button(){
        $better_product = prk_option('better_product');
        if ($better_product){
            if ( is_user_logged_in() ){
            echo '<span class="better-btn show" data-remodal-target="modal-better" >' .__ ('Do you know a better price?','parskala'). '<i class="prk-notification-bing"></i> </span>';
            echo '<span class="better-btn thanks">سپاسگزاریم، گزارش شما ثبت شد.</span>';
            }else{
                echo '<span class="better-btn show" data-remodal-id="loginmodal" >' .__ ('Do you know a better price?','parskala'). '<i class="prk-notification-bing"></i> </span>';
            }
        }
    }

    public function custom_field_post_type_better($post){

        global $typenow;
        if( in_array($typenow, array('product-better') ) ){ ?>
    <br>
            <div id="titlediv">
              <div id="titlewrap">
                <br>
                <input value="<?php echo get_post_meta($post->ID, 'shop_price', true); ?>" placeholder="قیمت" type="text" name="shop_price" size="10"  id="title" spellcheck="true" autocomplete="off">
              </div>
            </div>
          <div id="titlediv">
                <div id="titlewrap">
              <br>
                    <input value="<?php echo get_post_meta($post->ID, 'shop_name', true); ?>" placeholder="نام فروشگاه" type="text" name="shop_name" size="10"  id="title" spellcheck="true" autocomplete="off">
                </div>
            </div>
    
          <div id="titlediv">
            <div id="titlewrap">
              <br>
              <input value="<?php echo get_post_meta($post->ID, 'shop_city', true); ?>" placeholder="مکان فروشگاه" type="text" name="shop_city" size="10"  id="title" spellcheck="true" autocomplete="off">
            </div>
          </div>
    
        <div id="titlediv">
            <div id="titlewrap">
          <br>
                <input value="<?php echo get_post_meta($post->ID, 'website_url', true); ?>" placeholder="آدرس اینترنتی فروشگاه" type="text" name="website_url" size="10"  id="title" spellcheck="true" autocomplete="off">
            </div>
        </div>
    
    <?php }
    }
    
    
    
    public function subbetter_product_meta_product( $post_id, $post, $update ) {
        $post_type = get_post_type($post_id);
        if ( "product-better" != $post_type ) return;
        if ( isset( $_POST['shop_price'] ) ) {
            update_post_meta( $post_id, 'shop_price', sanitize_text_field( $_POST['shop_price'] ) );
            update_post_meta( $post_id, 'product_shop_price', sanitize_text_field( $_POST['shop_price'] ) );
        }
        if ( isset( $_POST['website_url'] ) ) {
            update_post_meta( $post_id, 'website_url', sanitize_text_field( $_POST['website_url'] ) );
            update_post_meta( $post_id, 'product_website_url', sanitize_text_field( $_POST['website_url'] ) );
        }
        if ( isset( $_POST['shop_name'] ) ) {
            update_post_meta( $post_id, 'shop_name', sanitize_text_field( $_POST['shop_name'] ) );
            update_post_meta( $post_id, 'product_shop_name', sanitize_text_field( $_POST['shop_name'] ) );
        }
        if ( isset( $_POST['shop_city'] ) ) {
            update_post_meta( $post_id, 'shop_city', sanitize_text_field( $_POST['shop_city'] ) );
            update_post_meta( $post_id, 'product_shop_city', sanitize_text_field( $_POST['shop_city'] ) );
        }
    }
    

    
}



