<?php


namespace Prk\Woocommerce\Single\Features;


class custom_info_tab {
    private static $instance;

    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {

        if ( prk_option('cattributes_product_tabs') == 1 ) {
            add_filter( 'woocommerce_product_tabs', [$this, 'additional_information_remove_product_tabs'], 9999 );
            add_filter( 'woocommerce_product_tabs', [$this, 'woo_cattributes_product_tabs'] );
        }
        
    }

    public function additional_information_remove_product_tabs( $tabs ) {
        unset( $tabs['additional_information'] );
        return $tabs;
    }

    // add cattributes Tab contents
    public function woo_cattributes_product_tabs( $tabs ) {
        $title_cattributes_tab = prk_option('title_cattributes_product_tabs') ? prk_option('title_cattributes_product_tabs') : __('Specifications','parskala');
        
            // Adds the cattributes products tab
            $tabs['cattributes_products_tab'] = array(
                'title'     => __( $title_cattributes_tab, 'woocommerce' ),
                'priority'  => 10,
                'callback' => [ 'Prk\Woocommerce\Single\Features\custom_info_tab', 'woo_cattributes_products_tab_content' ]
            );
        
            return $tabs;
    }

    public function woo_cattributes_products_tab_content() {
        
        $p_featured_attributes = get_post_meta( get_the_ID(), 'prk_product_featured_attributes', true );
        if ($p_featured_attributes) {
        ?>
        <table class="woocommerce-product-attributes shop_attributes">
            <tbody>
        
            <?php foreach ($p_featured_attributes as $value): ?>
                <tr class="woocommerce-product-attributes-item">
                    <th class="woocommerce-product-attributes-item__label"><?php echo $value['title'];?></th>
                    <td class="woocommerce-product-attributes-item__value"><p><?php echo $value['value'];?></p></td>
                </tr>
            <?php endforeach; ?>
        
            </tbody>
        </table>
        <?php
        }
    }

}