<?php

namespace Prk\Woocommerce\Single\Features;

class feedback_product {

    private static $instance;

    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        add_action( "wp_ajax_inset_feed_product", [$this, "inset_feed_product"] );
        add_action( "wp_ajax_nopriv_inset_feed_product", [$this,"inset_feed_product"] );
        add_action( 'init', [$this,'parskala_feed_posttype'] );
        add_filter( 'add_menu_classes', [$this,'show_pending_number_feed']);
        add_filter('post_updated_messages', [$this,'codex_book_updated_messages']);
        add_action( 'gettext', [$this,'change_publish_button'], 10, 2 );
        add_action( 'wp_footer', [$this,'modal_feednack_product'] );
        add_action( 'woocommerce_product_meta_start', [$this,'btn_feednack_product'] );

    }

    public function parskala_feed_posttype() {
    
        register_post_type( 'product-feed',
        // CPT Options
            array(
            'labels' => array(
            'name' => __( 'بازخوردها', 'parskala' ),
            'singular_name'       => _x( 'feed', 'Post Type Singular Name', 'prk' ),
            'view_item'           => __( 'نمایش بازخوردها', 'prk' ),
            'add_new'             => __( 'بازخورد جدید', 'prk' ),
            'edit_item'           => __( 'ویرایش بازخورد', 'prk' ),
            'update_item'         => __( 'بروز رسانی بازخورد', 'prk' ),
            'search_items'        => __( 'جستجو در بازخوردها', 'prk' ),
            'not_found'           => __( 'بازخوردی یافت نشد', 'prk' ),
            'not_found_in_trash'  => __( 'اوپس چیزی پیدا نشد', 'prk' ),
            'item_published'      =>  __( 'اوپس چیزی پیدا نشد', 'prk' ),
    
    
                ),
                'hierarchical'        => false,
                'public'              => false,
                'show_ui'             => true,
                'show_in_menu'        => true,
                'show_in_nav_menus'   => false,
                'show_in_admin_bar'   => false,
                'menu_position'       => 30,
                'can_export'          => true,
                'has_archive'         => false,
                'exclude_from_search' => true,
                'publicly_queryable'  => false,
                'menu_icon' 				=>  'dashicons-format-status',
                'show_in_rest' => false,
                'supports' => array( "title", "editor",),
    
            )
        );
    }
    public function change_publish_button( $translation, $text ) {
     global $post;
    if ( get_post_type(get_the_ID()) == 'product-feed' && $text == 'Publish' )
        return 'ذخیره به عنوان خوانده شده؟';
    
    return $translation;
    }
    public function codex_book_updated_messages( $messages ) {
      global $post, $post_ID;
    
      $messages['product-feed'] = array(
        0 => '', // Unused. Messages start at index 1.
        1 => sprintf( __('بازخورد بروز رسانی شد','parskala') ),
        2 => __('Custom field updated.'),
        3 => __('Custom field deleted.'),
        4 => __('Book updated.'),
        /* translators: %s: date and time of the revision */
        5 => isset($_GET['revision']) ? sprintf( __('Book restored to revision from %s','parskala'), wp_post_revision_title( (int) $_GET['revision'], false ) ) : false,
        6 => sprintf( __('بازخورد به لیست خوانده شده ها اضافه شد','parskala') ),
        7 => __('بازخورد خوانده شد.','parskala'),
    
      );
    
      return $messages;
    }
    public function show_pending_number_feed( $menu ) {
        $type = "product-feed";
        $status = "pending";
        $num_posts = wp_count_posts( $type, 'readable' );
        $pending_count = 0;
        if ( !empty($num_posts->$status) )
            $pending_count = $num_posts->$status;
    
        // build string to match in $menu array
        if ($type == 'post') {
            $menu_str = 'edit.php';
        // support custom post types
        } else {
            $menu_str = 'edit.php?post_type=' . $type;
        }
    
        // loop through $menu items, find match, add indicator
        foreach( $menu as $menu_key => $menu_data ) {
            if( $menu_str != $menu_data[2] )
                continue;
            $menu[$menu_key][0] .= " <span class='update-plugins count-$pending_count'><span class='plugin-count'>" . number_format_i18n($pending_count) . '</span></span>';
        }
        return $menu;
    } 
    public function inset_feed_product(){
    
        $checkboxes_translate = [
            "product_name" => __('Product name is not correct','parskala'),
            "product_thumb" => __('Product photos are not suitable','parskala'),
            "product_checked" => __('The technical specifications of the product are not correct','parskala'),
            "product_des" => __('Product description is not correct','parskala'),
        ];
        if(!empty($_POST['checkboxes']) and is_array($_POST['checkboxes'])){
            foreach($_POST['checkboxes'] as $key => $check){
                $conentcheckboxes .= ($check == 'true') ? '* '.$checkboxes_translate[$key].PHP_EOL:'';
            }
        }
      
        $args = array(
            'post_title'    =>  __('Feedback for','parskala') .get_the_title($_POST['product_id']).  __('| Product ID:','parskala') . $_POST['product_id'],
            'post_type'    => 'product-feed',
            'post_status'  => 'pending',
            'post_parent'  =>$_POST['product_id'],
            'post_content'      => $_POST['content'].PHP_EOL.$conentcheckboxes,
            'post_author'      => get_current_user_id() ? get_current_user_id() : 1,
        );
        $post_id = wp_insert_post( $args );
        if( $post_id )
            __('Thank you, your feedback has been received', 'parskala');
    
        else
            __('There is a problem, please try again.', 'parskala');
    
        die();
    
    }
    public function modal_feednack_product(){
        global $product;

        ?>
        <div class="remodal modal-feed remodal-lg remodal-maxed" data-remodal-id="modal-feed" data-remodal-options="hashTracking: false">

        <div class="remodal-header">
            <span class="title-feed"><?= _e('Your feedback about','parskala') ?> <?php the_title();?></span>
            <button data-remodal-action="close" class="remodal-close"></button>
        </div>

        <div class="cover-loading-replay"></div>

        <div class="flexright">

            <div class="img-feed">
                <?php echo get_the_post_thumbnail(get_the_ID(), 'shop_catalog', array( 'class' => 'center' ) ); ?>
            </div>

            <div class="info-feed">
            <p class="p-chexboxed">
            <input type="checkbox" id="product_name"><label for="product_name"> <?= _e('The product name is not correct','parskala') ?> </label>
            </p>
            <p class="p-chexboxed">
            <input type="checkbox" id="product_thumb" ><label for="product_thumb"><?= _e('Product photos are not suitable','parskala') ?></label>
            </p>
            <p class="p-chexboxed">
            <input type="checkbox" id="product_checked"><label for="product_checked"><?= _e('The technical specifications of the product are not correct','parskala') ?></label>
            </p>
            <p class="p-chexboxed">
            <input type="checkbox" id="product_des"><label for="product_des"><?= _e('The product description is not correct','parskala') ?></label>
            </p>
            <span><?= _e('Write your feedback','parskala') ?></span>
                <textarea class="user-feed" placeholder="<?= _e('Description','parskala') ?>"></textarea>
                <span data-remodal-action="close" class="insert-feed"><?= _e('Record information','parskala') ?></span>
            </div>

        </div>

        </div>
        <script>
            jQuery(document).ready(function($){
                $('.insert-feed').click(function(){

                    $('.cover-loading-replay').show(0);

                    ch_product_name = $('#product_name').prop('checked');
                    ch_product_thumb = $('#product_thumb').prop('checked');
                    ch_product_checked = $('#product_checked').prop('checked');
                    ch_product_des = $('#product_des').prop('checked');

                    var checkboxes ={
                        "product_name" : ch_product_name,
                        "product_thumb" : ch_product_thumb,
                        "product_checked" : ch_product_checked,
                        "product_des" : ch_product_des
                    };

                    $.post(parskala_values.ajax_url,
                    {
                        action: "inset_feed_product",
                        product_id: "<?php echo $product->get_id(); ?>",
                        content: $('.user-feed').val(),
                        checkboxes : checkboxes
                    },
                    function(data, status){
                        alert(data);
                        $('.user-feed').val('');
                        $('.feed.micromodal-slide').removeClass('is-open');
                                        $(".body").css("overflow", "unset");
                                        $(".body").css("height", "unset");
                                        $('.feed-btn').removeClass('show');
                                        $('.feed-btn.thanks').addClass('show');
                        $('.cover-loading-replay').hide(0);
                    });
                });

            });
        </script>

<?php
    }

    public function btn_feednack_product(){

        $feed_product = prk_option('feed_product');
        if ( is_singular('product') && $feed_product ){

            if (is_user_logged_in()) {

            echo '<div class="feed-btn show desctop" data-remodal-target="modal-feed" >'.__('Feedback about this product','parskala').'</div>';
            echo '<div class="feed-btn desctop thanks">متشکریم بازخورد شما دریافت شد</div>';

            }else {

            echo '<div class="feed-btn show desctop" data-remodal-id="loginmodal" >'.__('Feedback about this product','parskala').'</div>';

            }

        }

    }
    
}

