<?php

namespace Prk\Woocommerce\Single\Features;


class price_chart  {
    private static $instance;

    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        add_action( 'woocommerce_product_options_general_product_data', [$this, 'addFieldPriceChartPro'], 99999 );
        add_action( 'save_post_product', [$this, 'SaveFieldPriceChartPro'], 10, 3 );

        add_action( 'woocommerce_product_after_variable_attributes', [$this, 'variation_settings_fields'], 10, 3 );
        add_action( 'woocommerce_save_product_variation', [$this, 'save_variation_settings_fields'], 10, 2 );
        add_action('admin_head', [$this, 'parskala_custom_styles_admin']);

        
        add_action( 'wp_ajax_product_price_chart', [$this, 'get_product_price_chart'] );
        add_action( 'wp_ajax_nopriv_product_price_chart', [$this, 'get_product_price_chart'] );

    }


    /**
     *--------------------------------------------------------------------------
    * simple product
    *--------------------------------------------------------------------------
    */
     public function addFieldPriceChartPro() {
        global $woocommerce, $post;
        echo '<div class="simpleChart_options_group options_group" id="options_group'.$post->ID.'">';
        echo '<h5>'.__('نمودار قیمت','parskala').'</h5>';
        echo '<div class="childsField">';

        $value25 = get_post_meta( $post->ID, '_simplePriceChart',true) ;
        $DateValues = get_post_meta( $post->ID, '_simplePriceChartDate',true) ;
        $value = explode('|',$value25);
        $DateValues = explode('|',$DateValues);
        $img_handler = get_bloginfo('template_url').'/images/sorthandel-1.png';
        if($value[0]) {
            $i = 0;
            foreach ($value as $item) {
                if($i == 0){$class= 'first';}else{$class= '';}
                echo '<p class="'.$class.' form-field _priceChart[' . $post->ID . ']_field ">


                <input type="text" class="short shortPrice" style="" name="_simplePriceChart[' . $post->ID . '][]" id="_priceChart[' . $post->ID . ']" value="' . intval($item) . '" placeholder="قیمت" step="any" min="0">
                <input type="text" class="short shortDate" style="" name="_simplePriceChartDate[' . $post->ID . '][]" id="_priceChartDate[' . $post->ID . ']" value="' . $DateValues[$i] . '" placeholder="'.__('تاریخ','parskala').'" readonly >
                 <button class="deletation button"><span >X</span></button>
                 </p>';
                $i++;
            }
        }


        echo '</div>';
        echo '<button class="button addPriceCharter" id="addPriceChart' . $post->ID . '"><span>+</span></button>';
        echo '</div>'; ?>

		<script>
		// html tag
		var html_chart_fields<?php echo $post->ID; ?> = '<?php echo '<p class="form-field _priceChart[' . $post->ID . ']_field "><input type="text" class="short" style="" name="_simplePriceChart[' . $post->ID . '][]" id="_priceChart[' . $post->ID . ']" placeholder="قیمت" step="any" min="0"><input type="text" class="short shortDate" style="" name="_simplePriceChartDate[' . $post->ID . '][]" id="_priceChartDate[' . $post->ID . ']" placeholder="'.__('تاریخ','parskala').'" readonly ><button class="deletation button"><span >X</span></button> </p>'; ?>';
		</script>

		<?php
        echo "<script type='text/javascript'>
         jQuery(document).ready(function($) {
            $('#addPriceChart".$post->ID."').unbind('click').bind('click', function (e) {
                e.preventDefault();
                var elm = $( '#options_group{$post->ID} .childsField' ).append(html_chart_fields{$post->ID})
                .find('.deletation').click(function() {
                  $(this).parent().remove();
                  return false;
                });

                $('.shortDate').each(function() {
                  $(this).persianDatepicker({formatDate: 'YYYY-MM-DD'});
                });


                return false;
            });
            $( \".deletation\" ).on( \"click\", function() {
                $(this).parent().remove();
                return false;
            });
            $( '#product-type' ).change( function() {
                    var selected = $( '#product-type' ).find(':selected').val();
                    $( '.simpleChart_options_group' ).hide();
                    if ( selected == 'variable' ) {
                        $( '.simpleChart_options_group' ).hide();
                    }else {
                        $( '.simpleChart_options_group' ).show();
                    }
                });
                $( '#product-type' ).trigger( 'change' );


           $('.shortDate').each(function() {
                $(this).persianDatepicker({formatDate: 'YYYY-MM-DD'});
            });

               $('.childsField').sortable();
               $('.childsField').disableSelection();

        });
      </script>";
    }

    public function SaveFieldPriceChartPro( $post_id , $post, $update){
        $price = get_post_meta( get_the_ID(), '_regular_price', true);
        if ($price && isset($_POST['_simplePriceChart'][$post_id],$_POST['_simplePriceChartDate'][$post_id]) ){
          // Text Field
          $simplearrayPrice = $_POST['_simplePriceChart'][$post_id];
          $simplearrayPriceDate = $_POST['_simplePriceChartDate'][$post_id];
  
  
          // array maker
          $i = 0;
          $date_and_price_chart = array();
  
          if ( $simplearrayPrice[0] ){
              foreach( $simplearrayPrice as $x ) {
  
                  $date_and_price_chart[$simplearrayPriceDate[$i]] = $simplearrayPrice[$i];
                  $i++;
              }
          }
  
          // save array
          if ( $simplearrayPrice[0] )
              update_post_meta( $post_id, 'simple_date_and_price_chart', $date_and_price_chart );
          else
              update_post_meta( $post_id, 'simple_date_and_price_chart', '' );
  
  
          if( $simplearrayPrice[0] )
              update_post_meta( $post_id, '_simplePriceChart', esc_attr( implode('|',$simplearrayPrice) ) );
          else
              update_post_meta( $post_id, '_simplePriceChart', '' );
  
          if( $simplearrayPriceDate[0] )
              update_post_meta( $post_id, '_simplePriceChartDate', esc_attr( implode('|',$simplearrayPriceDate) ) );
          else
              update_post_meta( $post_id, '_simplePriceChartDate', '' );
        }
    }

    /**
     *--------------------------------------------------------------------------
    * variable products
    *--------------------------------------------------------------------------
    */
    public function variation_settings_fields( $loop, $variation_data, $variation ) {
        echo '<div class="options_group varitionChart_options_group" id="options_group'.$variation->ID.'">';
        echo '<h5>'.__('نمودار قیمت - محصولات متغیر','parskala').'</h5>';
        echo '<div class="childsField">';
        $value25 = get_post_meta( $variation->ID, '_priceChart',true) ;
        $DateValues = get_post_meta( $variation->ID, '_priceChartDate',true) ;
        $value = explode('|',$value25);
        $DateValues = explode('|',$DateValues);
        $img_handler = get_bloginfo('template_url').'/images/sorthandel-1.png';
        if( $value[0] ) {
            $i = 0;
            foreach ($value as $item) {
                if($i == 0){$class= 'first';}else{$class= '';}
                echo '<p class="'.$class.' form-field _priceChart[' . $variation->ID . ']_field ">

                <input type="text" class="short" style="" name="_priceChart[' . $variation->ID . '][]" id="_priceChart[' . $variation->ID . ']" value="' . intval($item) . '" placeholder="قیمت" step="any" min="0">
                <input type="text" class="short shortDate" style="" name="_priceChartDate[' . $variation->ID . '][]" id="_priceChartDate[' . $variation->ID . ']" value="' . $DateValues[$i] . '" placeholder="'.__('تاریخ','parskala').'" readonly >
                 <button class="deletation button"><span>X</span></button>
                 </p>';
                $i++;
            }
        }
        echo '</div>';
        echo '<button class="button addPriceCharter" id="addPriceChart' . $variation->ID . '"><span>+</span></button>';
        echo '</div>'; ?>

		<script>
		// html adder
		var html_chart_fields<?php echo $variation->ID; ?> = '<p class="form-field _priceChart[<?php echo $variation->ID; ?>]_field "><label for="_priceChart[<?php echo $post->ID; ?>]"><img src="<?php echo $img_handler; ?>" class="sort_handler" alt=""> <span>قیمت</span> </label><input type="text" class="short" style="" name="_priceChart[<?php echo $variation->ID; ?>][]" id="_priceChart[<?php echo $variation->ID; ?>]" placeholder="<?php _e('قیمت','parskala') ?> step="any" min="0"><input type="text" class="short shortDate" style="" name="_priceChartDate[<?php echo $variation->ID; ?>][]" id="_priceChartDate[<?php echo $variation->ID; ?>]" placeholder="<?php _e('تاریخ','parskala') ?>" readonly ><button class="deletation button"><span>X</span></button> </p>';
		</script>

        <?php
		echo "<script type='text/javascript'>
        jQuery(document).ready(function($) {
            $('#addPriceChart".$variation->ID."').unbind('click').bind('click', function (e) {
                e.preventDefault();
                var elm = $( '#options_group{$variation->ID} .childsField' ).append(html_chart_fields{$variation->ID})
                .find('.deletation').click(function() {
                  $(this).parent().remove();
                  return false;
                });

                $('.shortDate').each(function() {
                  $(this).persianDatepicker({formatDate: 'YYYY-MM-DD'});
                });

                return false;
            });

            $( \".deletation\" ).on( \"click\", function() {
                $(this).parent().remove();
                return false;
            });

           $('.shortDate').each(function() {
                $(this).persianDatepicker({formatDate: 'YYYY-MM-DD'});
            });

           $('.childsField').sortable();
               $('.childsField').disableSelection();

			jQuery('.varitionChart_options_group, .deletation span').on( 'click', function(){
				$(this).parents('.woocommerce_variation').addClass('variation-needs-update');
			});
        });
        </script>";
    }


    public function save_variation_settings_fields( $post_id ) {

        // get postmetas
        $number_field = $_POST['_priceChart'][$post_id];
        $Date_field = $_POST['_priceChartDate'][$post_id];

        // args maker
        $i = 0;
        $date_and_price_chart = array();
        foreach( $number_field as $x ) {

            $date_and_price_chart[$Date_field[$i]] = $number_field[$i];
            $i++;
        }
        // saves args
        if ( $number_field[0] )
            update_post_meta( $post_id, 'date_and_price_chart', $date_and_price_chart );
        else
            update_post_meta( $post_id, 'date_and_price_chart', '' );

        // field saver
        if ( $number_field[0] )
            update_post_meta( $post_id, '_priceChart', esc_attr( implode('|',$number_field) ) );
        else
            update_post_meta( $post_id, '_priceChart', '' );


        if ( $Date_field[0] )
            update_post_meta( $post_id, '_priceChartDate', esc_attr( implode('|',$Date_field) ) );
        else
            update_post_meta( $post_id, '_priceChartDate', '' );

    }

    /**
     *--------------------------------------------------------------------------
     * Custom fonts
     *--------------------------------------------------------------------------
     */
    public function parskala_custom_styles_admin() {
        ?>
        <style>
            .woocommerce_variable_attributes wc-metabox-content { height: auto !important; }
            .simpleChart_options_group , varitionChart_options_group {
                padding-bottom: 30px;
            }
            .simpleChart_options_group h5 , .varitionChart_options_group h5 {
                color: #535353;
                border-top: 2px solid #eeee;
                padding-top: 15px;
                padding-right: 10px;
            }
            ._priceChart {
                cursor: pointer !important;
            }
            .childsField p:nth-child(odd) {
                background-color: whitesmoke;
            }
            .childsField .form-field .deletation {
                color: #ef4556;
                width: 30px;
                height: 26px;
                font-size: 18px;
                padding: 0;
                border: 0;
            }
            .childsField .form-field .deletation span {
                position: relative;
                top: -2px;
                right: -1px;
            }
            .addPriceCharter {
                    width: 15%;
                    background-color: #ef4556 !important;
                    color: white !important;
                    border: none !important;
                    outline: none !important;
                    margin-right: 10px !important;
            }
            .sort_handler {
                width: 10px;
                height: 10px;
                vertical-align: sub;
            }
            .childsField .form-field input[type=text]{
                width: 26.7%;
                margin-left: 10px;
            }
        .childsField.ui-sortable p.form-field {
        padding-right: 9px !important
        }
        </style>
        <script>
            jQuery(document).ready(function($) {
                $('#product-type').change( function() {
                    var selected = $(this).find(':selected').val();
                    if (selected == 'variable') {
                        $('#inventory_product_data').css('display','block');
                        $('.inventory_tab').addClass('active');
                        $('.general_tab , #general_product_data').hide();
                    }
                });
            });
    
        </script>
        <?php
    }


	public function get_product_price_chart(){
	global $product;
		if ( empty( $_POST['product_id'] ) ) return;

		$product = wc_get_product( $_POST['product_id'] );


		?>

		<script type="text/javascript">
		jQuery(document).ready(function($){

			jQuery('#productchartprice').highcharts({

				title: {
					text: '<?php _e('نمودار قیمت محصول','parskala'); ?>',
					style: {
						color: '#6a6a6a',
						fontSize: '18px',
            fontFamily: "prk-font",
						whiteSpace: 'nowrap'
					},
				},

				subtitle: {
					text: '<?php _e('تخفیف‌ها و قیمت جشنواره‌ها در قیمت فروش در نظر گرفته نمی‌شود','parskala') ?>',
					style: {
						color: '#6a6a6a',
						fontSize: '12px',
            fontFamily: "prk-font",
						whiteSpace: 'nowrap'
					},
				},



				legend: {
					backgroundColor: "#F5F6F8",
					align: "right",
					verticalAlign: "bottom",
					borderWidth: 0,
					rtl: true,
					useHTML: true,
					margin: 30,
					width: 560,
					itemDistance: 50,
					itemMarginBottom: 10,
					itemStyle: {
						fontWeight: "normal",
            fontFamily: "prk-font",
						fontSize: "12px",
						color: "#777"
					},
				},

				plotOptions: {
					line: {
					connectNulls: true,
						marker: {
							enabled: true,
							fillColor: '#FFFFFF',
							lineWidth: 2,
							lineColor: null, // inherit from series
							radius: 4,
							symbol: "circle",
							width: 900,
							states: {
								hover: {
									enabled: false
								}
							}
						}
					}
				},

				tooltip: {
					valueSuffix: ' <?php echo get_woocommerce_currency_symbol(); ?>',
					rtl: true,
					crosshairs: {
						width: 1,
						color: 'gray',
						dashStyle: 'Dot'
					},
					style: {
          fontFamily: "prk-font",
						padding: '20px'
					},
					backgroundColor: "#fcfeff",
					borderColor: "#e6e7e8",
					borderRadius: 2,
					borderWidth: 1,
					followPointer: false,
					shared: false,
					useHTML: true,
				},

				series: [
		<?php
		if( $product->is_type('variable') ){

			$product_name   = $product->get_name();
			$product_childs = $product->get_children();

			$child_names = array();

			$childs_date = array();

			$vartion_ids = array();

			foreach($product->get_available_variations() as $variation ){


				$vartion_ids[] = $variation['variation_id'];

				// Attributes
				$attributes = array();
				foreach( $variation['attributes'] as $key => $value ){
					$taxonomy = str_replace('attribute_', '', $key );
					$taxonomy_label = get_taxonomy( $taxonomy )->labels->singular_name;
					$term_name = get_term_by( 'slug', $value, $taxonomy )->name;
					$attributes[] = $taxonomy_label.': '.$term_name;
				}
				$child_names[] =  $product_name.': '.implode( ' | ', $attributes );



				if ( ! empty( $dates = get_post_meta($variation['variation_id'],'date_and_price_chart',true) ) ) {

					foreach( $dates as $date => $price ){

						$childs_date[] = substr($date, 2);

					}
				}
			}

			function date_sort($a, $b) {
				return strtotime($a) - strtotime($b);
			}
			usort($childs_date, "date_sort");
			$first_end_date = array_unique($childs_date);

			$i = 0;

			foreach( $vartion_ids as $vartion_id ){



				echo '{';

					echo 'name: "'.$child_names[$i].'",';
					echo 'data: [';

						$date_price_variation = get_post_meta($vartion_id,'date_and_price_chart',true);


						foreach( $first_end_date as $date ){

							//$full_date = '13'.$date;
							$full_date =  $date > 96 ? '13'.$date : '14'.$date ;

							if ( ! empty( $date_price_variation[$full_date] ) ){

								echo $date_price_variation[$full_date].', ';

							}  else { echo 'null, '; }
						}
					echo ']';

				echo '},';
			$i++;
			}
		} else if ( $product->is_type('simple') ){

			$simplePriceChartDate = get_post_meta( $product->get_id(), 'simple_date_and_price_chart', true );

				echo '{';

					echo 'name: "'.$product->get_name().'",';
					echo 'data: [';

						foreach( $simplePriceChartDate as $date => $price ) echo $price.', ';

					echo ']';

				echo '},';
		}
		?>],

				xAxis: {
				categories: [<?php
				if( $product->is_type('variable') )
					foreach( $first_end_date as $date ) echo $date = $date > 96 ? '"13'.$date.'", ' : '"14'.$date.'",' ;

				else if ( $product->is_type('simple') )
					foreach( $simplePriceChartDate as $date => $price ) echo '"'.$date.'", ';
				?>],
					labels: {
						enabled: true,
						rtl: true,
						y: 25,
						x: 0,
						align: 'center',
						style: {
							color: '#979797',
							fontSize: '12px',
              fontFamily: "prk-font",
							whiteSpace: 'nowrap'
						},
						formatter: function () {
							return this.value;
						}
					}
				},

				yAxis: {
					title: {
						text: '<?php _e('تغییرات قیمت','parskala'); ?>',
						x: -15, //center
						style: {
							fontWeight: "normal",
              fontFamily: "prk-font",
							fontSize: "14px",
							direction: "rtl",
							color: "#777777"
						}
					},
					gridLineDashStyle: "Dot",

					labels: {
						x: -50,
						style: {
							color: '#4c4c4c',
							fontSize: '16px',
              fontFamily: "prk-font",
						},
						formatter: function () {
							return this.value;
						}
					},
					plotLines: [{
						value: 0,
						width: 1,
						color: "#808080"
					}]
				},

				responsive: {
					rules: [{
						condition: {
							maxWidth: 900
						},
						chartOptions: {
							legend: {
								layout: 'horizontal',
								align: 'center',
								verticalAlign: 'bottom'
							}
						}
					}]
				}

			});
		});
		</script>


        <style>
            .highcharts-legend-item {
                direction: rtl;
            }
            .highcharts-tooltip span:first-child {
                float: right;
                font-size: 10pt !important;
            }
            .highcharts-tooltip span:nth-child(2) {
                float: right;
                direction: rtl;
                text-align: right;
            }
            .highcharts-tooltip span b{
                float: right;
                direction: ltr;
                text-align: left;
            }
        </style>


		<?php

		wp_die();
	}

}
 





