<?php

namespace Prk\Woocommerce\checkout;

class National_code {

    private static $instance = null;

    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
   
    public function __construct() {
        
        if ( is_admin() ){
            add_action('add_meta_boxes', [$this, 'send_order_add_box']);
        }else{
            add_filter('woocommerce_checkout_fields', [$this, 'custom_woocommerce_billing_fields'], 1.1);
            add_action( 'woocommerce_checkout_update_order_meta', [$this, 'my_custom_checkout_field_update_order_meta'] );
        }

    }

    public function my_custom_checkout_field_update_order_meta( $order_id ) {
        if ( ! empty( $_POST['billing_ncode'] ) ) {
            update_post_meta( $order_id, 'billing_ncode', sanitize_text_field( $_POST['billing_ncode'] ) );
        }
    }



    // فیلد سفارشی کد ملی
    public function custom_woocommerce_billing_fields($fields){
        if ( prk_option('National_code_required') == '1' ) {
            $required_class = true;
        }else {
            $required_class = false;
        }
        $fields['billing']['billing_ncode'] = array(
            'label' =>'کد ملی',
            'placeholder' =>'کد ملی',
            'required' => $required_class,
            'clear' => false,
            'type' => 'number',

        );

        return $fields;
    }

    public function send_order_add_box() {
        add_meta_box(
            'prk-send-box',
            __('زمان ارسال سفارش', 'prk-send'),
            [$this, 'prk_send_create_box_order_page'], // اینجا باید به شکل آرایه باشه
            'shop_order',
            'side',
            'default'
        );
    }
    
    public function prk_send_create_box_order_page() {
        global $post_id;
        $days_send = get_post_meta($post_id, 'order_time_send', true);
        $times_send = get_post_meta($post_id, 'order_timer_send', true);
        ?>
        <div>
            <?php if ($days_send): ?>
                <div><i class="ri-mail-send-line"></i> <?php echo esc_html($days_send); ?></div>
            <?php else: ?>
                <div>کاربر تاریخ ارسالی تعیین نکرده است!</div>
            <?php endif; ?>
    
            <?php if ($times_send): ?>
                <div><i class="ri-map-pin-time-line"></i> <?php echo esc_html($times_send); ?></div>
            <?php else: ?>
                <div>مشتری زمان ارسال را تعیین نکرده است!</div>
            <?php endif; ?>
        </div>
        <?php
    }

}