<?php

namespace Prk\Woocommerce\checkout;

class prk_send_order {


    private static $instance;

    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {

        $options = get_option('prk_option');
        $required_timer_send = $options['required_timer_send'];
        if ($required_timer_send) {
        add_action( 'woocommerce_after_checkout_validation', [$this, 'action_error_timer_send'], 10, 2 );
        }
        $required_day_send = $options['required_day_send'];
        if ($required_day_send) {
        add_action( 'woocommerce_after_checkout_validation', [$this, 'action_woocommerce_after_checkout_validation'], 10, 2 );
        }
        add_action( 'woocommerce_checkout_update_order_meta', [$this, 'add_timer_send_to_order'] , 10, 1);
        add_action( 'woocommerce_after_checkout_billing_form', [$this, 'custom_checkout_question_field'], 11, 1 );
        add_action( 'woocommerce_admin_order_data_after_billing_address', ['checkout_field_display_admin_order_meta'], 10, 1 );
        add_action( 'woocommerce_checkout_update_order_meta', [$this, 'add_delivery_option_to_order'] , 10, 1);
        add_action( 'woocommerce_after_checkout_billing_form', [$this, 'send_dayes_order'] );
    
    
    
    }


    private function getCartProductsMaximumDeliveryTime(){
        $items    = WC()->cart->get_cart();
        $productsDelivery = 0;
        if ( empty($items) ) {
          return $productsDelivery;
        }
        foreach ( $items as $cart_item ) {
      
          $itemTime = get_post_meta($cart_item['product_id'], 'date_send_pro', true);
          if ( !is_numeric($itemTime) ) {
            continue;
          }
          $productsDelivery = $productsDelivery > (int) $itemTime ? $productsDelivery : (int) $itemTime;
        }
      
        return $productsDelivery;
      }
      
      public function getCartDeliveryTimes(){
        $productsDelivery = $this->getCartProductsMaximumDeliveryTime();
      
        $allowedDays = prk_option('delivery-dates',
          ['saturday', 'sunday', 'monday', 'tuesday', 'wednesday', 'thursday']);
        $deliveryMin = prk_option('delivery-min-time', 4);
        $deliveryMin = is_numeric($deliveryMin) ? (int) $deliveryMin : 4;
      
        $datesCount = prk_option('delivery-times-count', 5);
        $datesCount = is_numeric($datesCount) ? (int) $datesCount : 5;
        $datesCount += 7 - count($allowedDays);
        $results    = [];
      
        for ( $i = 0; $i < $datesCount; $i++ ) {
          $datetime = new \DateTime();
          $datetime->modify('+' . ($productsDelivery + $i + $deliveryMin) . ' ' . ($productsDelivery + $i + $deliveryMin > 1 ? 'day' : 'days'));
          if ( !in_array(strtolower($datetime->format('l')), $allowedDays, false) ) {
            continue;
          }
      
      
          $results[] = [
            'dayName' => $datetime->format('l'),
            'date'    => $datetime->format('U')
          ];
        }
      
      
      
        return $results;
      }
      
      // اضافه کردن فیلد تعیین تاریخ تحویل سفارش
      public function send_dayes_order(){
         $show_timer_send = $list_sends = "";
         $options = get_option('prk_option');
         $deliveryDates = $this->getCartDeliveryTimes();
         $delivery_label_pc = $options['checkout-delivery-label-pc'];
         $delivery_label_mobile = $options['checkout-delivery-label-mobil'];
         $delivery_icon_mobile = $options['checkout-delivery-icon-mobil'];
         $show_timer_send = $options['show_timer_send'];
         $list_sends = $options['list_send_time_order'];
      
         $popup_send_delivery = $options['prk_popup_send_delivery'];
         $required_day_send = $options['required_day_send'];
      
         if ($show_timer_send && $list_sends){
           $show_time_class = 'timer_class';
         }else {
           $show_time_class = '';
         }
      
         // تنظیمات نمایش پاپ  آپ فیلد تحویل سفارش
         if ($popup_send_delivery && mobile_cheker() || tablet_cheker() ) {
            $popup_class = 'delivery_mobile';
         }else {
           $popup_class = '';
         }
      
      ?>
        <?php if ( $popup_send_delivery && mobile_cheker() || tablet_cheker()): ?>
         <div class="select_delivery_time">
            <span>انتخاب زمان تحویل سفارش</span>
         </div>
        <?php else: ?>
          <label class="order-delivery-title"><?php echo $delivery_label_pc; ?></label>
        <?php endif; ?>
      
      
         <div class="order-delivery-times <?php echo $show_time_class .' '. $popup_class; ?>">
      
           <?php if ( $popup_send_delivery && mobile_cheker() || tablet_cheker()): ?>
      
            <div class="delivery_time_mobile_header flexed">
               <span class="order-delivery-title">
      
      
      
                 <?php
                  if ($delivery_icon_mobile) {
                   echo '<i class="'.$delivery_icon_mobile.'"></i>';
                  }
      
                  echo $delivery_label_mobile;
      
                  ?>
               </span>
               <span class="close-delivery-times"><i class="ri-close-line"></i></span>
            </div>
      
           <?php endif; ?>
      
           <ul class="">
               <?php foreach ( $deliveryDates as $key => $item ) { ?>
              <li>
                  <input type="radio" class="prk-radio" name="order_time_send"
                         value="<?= __($item['dayName']) ?> <?= prk_factor_jdates('d F, Y', $item['date']) ?>"  id="checkout-deliver-item-<?= $key ?>">
                  <label for="checkout-deliver-item-<?= $key ?>">
                      <b class="checkout-deliver-day-itmes"><?= __($item['dayName']) ?></b>
                      <span class="delivery-time"><?= prk_factor_jdates('d F Y', $item['date']) ?></span>
                  </label>
              </li>
               <?php } ?>
           </ul>
      
      
      
        <?php
        if (! $show_timer_send && ! $list_sends ) {
          echo '</div>';
        }elseif ($show_timer_send && ! $list_sends) {
          echo '</div>';
        }elseif (! $show_timer_send && $list_sends) {
          echo '</div>';
        }
      }
      
      // آپدیت فیلد انتخاب تاریخ تحویل سفارش
      public function add_delivery_option_to_order ( $order_id ) {
        if ( isset( $_POST ['order_time_send'] ) &&  prk_option('checkout-delivery', '1') === '1' ) {
              add_post_meta( $order_id, 'order_time_send',  sanitize_text_field( $_POST ['order_time_send'] ) );
          }
      }
      
      // ضروری کردن فیلد تعیین تاریخ تحویل سفارش
      private function action_woocommerce_after_checkout_validation( $data, $errors ) {
          if ( empty( $_POST['order_time_send'] ) ) :
              $errors->add( 'required-field', __( 'لطفا تاریخ تحویل سفارش را تعیین کنید.', 'parskala' ) );
          endif;
      }
      
      // نمایش محتوای فیلد تاریخ و ساعت تحویل
      public function checkout_field_display_admin_order_meta($order) {
      
        if ( prk_option('checkout-delivery', '1') === '1' ) {
          $delivery_day = $order->get_meta('order_time_send');
          $delivery_times = $order->get_meta('order_timer_send');
      
          if ($delivery_times && ! empty($delivery_day)) {
            $delivery_time = ' | '.$delivery_times;
          }elseif ($delivery_times && empty($delivery_day) ) {
            $delivery_time = $delivery_times;
          }else {
            $delivery_time = '';
          }
      
          if ($delivery_day || $delivery_time) {
            echo '<p><strong>' . __('زمان تحویل:','parskala') . '</strong> ' . $delivery_day .' '. $delivery_time . '</p>';
          }
      
        }
      }
      
      // فیلد تعیین ساعت تحویل سفارش
      public function custom_checkout_question_field( $checkout ) {
          $show_timer_send = $list_sends = "";
          $options = get_option('prk_option');
          $list_sends = $options['list_send_time_order'];
          $show_timer_send = $options['show_timer_send'];
          if ($show_timer_send && $list_sends ) {
            $list_send = array();
            // حلقه رادیوباکس انتخاب ساعت ارسال
            foreach ($list_sends as $value) {
              $R_String = generateRandomString();
              $title_send = $value['time_send_order'];
              echo '<div class="date-send-order">';
              echo '<input id="checkout-deliver-day-'.$R_String.'" type="radio" name="order_timer_send" value="'.$title_send.'" required />';
              echo '<label for="checkout-deliver-day-'.$R_String.'">'.$title_send.'</label>';
              echo '</div>';
            }
      
            echo "</div>";
          }
      }
      
      // ذخیره فیلد ساعت تحویل سفارش
      public function add_timer_send_to_order ( $order_id ) {
          if ( isset( $_POST ['order_timer_send'] ) &&  '' != $_POST ['order_timer_send'] ) {
              add_post_meta( $order_id, 'order_timer_send',  sanitize_text_field( $_POST ['order_timer_send'] ) );
          }
      }
      
      // ضروری کردن فیلد انتخاب ساعت تحویل
      public function action_error_timer_send( $data, $errors ) {
        $options = get_option('prk_option');
        $list_sends = $options['list_send_time_order'];
        $show_timer_send = $options['show_timer_send'];
          if ( $show_timer_send && $list_sends &&  empty( $_POST['order_timer_send'] ) ) :
              $errors->add( 'required-field', __( 'لطفا ساعت تحویل سفارش را انتخاب کنید.', 'parskala' ) );
          endif;
      }
      
    
}



