<?php

namespace Prk;

class class_loader {

    private static $classes = [

        'global' => [
            'Prk\Theme_Setup' => 'enable_woocamerce',
            'Prk\Classes\Header_Class' => 'enable_woocamerce',
            'Prk\Classes\Footer_Class' => 'enable_woocamerce',
            'Prk\Classes\prk_taxonomy' => 'enable_woocamerce',
            'Prk\Classes\Walker_Comment' => 'enable_woocamerce',
            'Prk\Classes\post_types' => 'enable_woocamerce',
            'Prk\Classes\prk_metaboxes' => 'enable_woocamerce',
            'Prk\Classes\breadcrumbs' => 'enabe_breadcrumbs',
            'Prk\Modules\Invoice\invoicesystem' => 'factor_pars',
            'Prk\Modules\NextShopping\Next_Shopping_List' => 'NextShopping_cart',
            'Prk\Modules\PrkStory\parskala_story' => 'prk_story_Activation',
            'Prk\Woocommerce\Globals\brand_page' => 'product_brand',
            'Prk\Woocommerce\Globals\prk_shortcodes' => 'enable_woocamerce',
            'Prk\Classes\prk_Ajax' => 'enable_woocamerce',
            'Prk\Modules\whishlist\prk_wishlist' => 'enable_woocamerce',
            'Prk\Woocommerce\Single\Features\compare_class' => 'single_product_compare',
            'Prk\Modules\OrderTrack\order_track' => 'enable_woocamerce',
            'Prk\Woocommerce\Myaccount\Class_notification' => 'prk_notification_enable',
            'Prk\Woocommerce\Myaccount\Class_comments' => 'prk_myaccount_comments',
            'Prk\Woocommerce\Single\Features\faq_product' => 'single_product_faq',
            'Prk\Modules\Add2cart\add_2cart' => 'ajax_add',
            'Prk\Woocommerce\archive\Orderby_Stock_Status' => 'sort_by_stock',
            'Prk\Woocommerce\Globals\search_product' => 'header_search_true',
            'Prk\Woocommerce\Globals\Set_location' => 'prk_filter_location',
            'Prk\Woocommerce\archive\class_widgets' => 'enable_archive_hooks',

        ],
        'wp_global' => [
            'Prk\Woocommerce\Globals\edit_price' => 'enable_woocamerce',
            'Prk\Woocommerce\Globals\fake_purchase' => 'fake_purchase',

        ],
        'single_product' => [
            'Prk\Woocommerce\Single\prk_Single_Product_hooks' => 'enable_product_hooks',
            'Prk\Woocommerce\Single\related_args' => 'enable_product_hooks',
            'Prk\Woocommerce\Single\Features\Product_Guarantee' => 'single_product_bail',
            'Prk\Woocommerce\Single\Features\Product_Return' => 'enable_product_return',
            'Prk\Woocommerce\Single\Features\Produc_sticky_add2cart' => 'show_sticky_add',
            'Prk\Woocommerce\Single\Features\custom_info_tab' => 'cattributes_product_tabs',
            'Prk\Woocommerce\Single\Features\faq_product' => 'single_product_faq',
            'Prk\Woocommerce\Single\Features\feedback_product' => 'feed_product',
            'Prk\Modules\SizeGuide\prk_sizeguide' => 'enable_size_guide',
            'Prk\Woocommerce\Single\Features\Image_zoom' => 'prk_zoom_image',
            'Prk\Woocommerce\Single\Features\price_chart' => 'prk_zoom_image',

        ],
        'mobile' => [
            'Prk\Classes\Mobile_Class' => 'prk_modern_mobile',
        ],
        'my_account' => [
            'Prk\Woocommerce\Myaccount\prk_hooks_account' => 'enable_account_hooks',
            // 'Prk\Woocommerce\Myaccount\Class_notification' => 'prk_notification_enable',
            // 'Prk\Woocommerce\Myaccount\Class_comments' => 'prk_myaccount_comments',
        ],
        'archive' => [
            'Prk\Woocommerce\archive\prk_hooks_archive' => 'enable_archive_hooks',
            'Prk\Woocommerce\archive\infinite_scroll' => 'ajax_prod_auto',

        ],
        'cart' => [
            // 'Prk\Modules\NextShopping\Next_Shopping_List' => 'NextShopping_cart',
            'Prk\Woocommerce\cart\cart_class' => 'enable_cart_hooks',

        ],
        'checkout' => [
            'Prk\Woocommerce\checkout\prk_hooks_chekout' => 'enable_checkout_hooks',
            'Prk\Woocommerce\checkout\National_code' => 'National_code',
            'Prk\Woocommerce\checkout\prk_send_order' => 'checkout-delivery',
            'Prk\Woocommerce\checkout\map_checkout' => 'checkout-map',
        ],
        'brand' => [
        ],
        'admin' => [
            'Prk\Classes\prk_admin' => 'enable_woocamerce',
            'Prk\Classes\Admin\prk_plugin_activation' => 'enable_woocamerce',
        ]

    ];

    public function __construct() {
        $this->load_classes();

        // بررسی ایجکس از صفحه محصول
        if (wp_doing_ajax() && $this->is_ajax_request_from_product_page()) {
            $this->load_class_group('single_product');
        }
        
    }

    private function load_classes() {

        $this->load_class_group('global');

        if ( is_admin() ) {
            $this->load_class_group('admin');
        }
        if (wp_is_mobile()) {
            $this->load_class_group('mobile');
        }

        add_action('wp', [$this, 'conditionally_load_classes']);

    }

    public function conditionally_load_classes() {

        $this->load_class_group('wp_global');

        if ( is_product() ) {
            $this->load_class_group('single_product');
        } elseif (is_account_page()) {
            $this->load_class_group('my_account');
        } elseif (is_archive()) {
            $this->load_class_group('archive');
        }elseif (is_cart()) {
            $this->load_class_group('cart');
        }elseif ( is_checkout() ) {
            $this->load_class_group('checkout');
        }elseif ( is_tax('brand')  ) {
            $this->load_class_group('brand');
        }
    }

    private function load_class_group($group) {
        if (!isset(self::$classes[$group])) {
            return;
        }

        foreach (self::$classes[$group] as $class_name => $option_key) {
            if ($this->is_feature_enabled($option_key)) {
                if (class_exists($class_name)) {
                    $class_name::get_instance();
                }
            }
        }
    }

    private function is_feature_enabled($option_key) {
        return prk_option($option_key) == '1' || prk_option($option_key) == '';
    }

        /**
     * Check if the AJAX request is made from a single product page.
     */
    private function is_ajax_request_from_product_page() {
        if (!empty($_SERVER['HTTP_REFERER'])) {
            $referer_url = $_SERVER['HTTP_REFERER'];
            if (strpos($referer_url, '/product/') !== false || strpos($referer_url, '?product=') !== false) {
                return true;
            }
        }
        return false;
    }

    private static $instance = null;
    
    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

}
