<?php

/**
 * Ag Themer Custom UI
 */

if (! class_exists('Ag_Target_Rules_Fields')) {
	require_once get_template_directory() . '/inc/ag-theme-builder/lib/target-rule/class-ag-target-rules-fields.php';
}

$elementor_edit_url = add_query_arg([
	'action' => 'elementor',
	'post'   => $post->ID,
], admin_url('post.php'));


$post_id    = isset($_GET['post']) ? intval($_GET['post']) : ($post->ID ?? 0);
$is_draft   = !$post_id || get_post_status($post_id) === 'auto-draft';
$is_published = $post_id && !$is_draft;

$template_type = get_post_meta($post->ID, 'ag_theme_builder_template_type', true);
$sticky        = get_post_meta($post->ID, 'ag_theme_builder_sticky', true);
$include_locations = get_post_meta($post->ID, 'ag_theme_builder_target_include_locations', true);
$exclude_locations = get_post_meta($post->ID, 'ag_theme_builder_target_exclude_locations', true);
$user_roles         = get_post_meta($post->ID, 'ag_theme_builder_target_user_roles', true);
$post_status = get_post_status($post);
$submit_label = in_array($post_status, ['publish', 'draft', 'pending', 'private']) ? 'ذخیره' : 'افزودن';
wp_nonce_field('ag_theme_builder_meta_nounce', 'ag_theme_builder_meta_nounce');

function ag_get_save_class($post_id)
{
	if (! $post_id || get_post_status($post_id) === 'auto-draft') {
		return 'disabled';
	}

	return 'enabled';
}
function get_ag_themer_list_url() {
    return admin_url( 'edit.php?post_type=ag-themer' );
}


?>

  <!-- ویرایش طرح -->
<?php if ($is_published) :?>

<div class="ag-ui-wrapper">

	<div class="ag-ui-header">
		<div class="ag-ui-icon">
			<img src="<?php echo get_template_directory_uri(); ?>/inc/ag-theme-builder/admin/assets/images/smile-code.png" alt="smile-code">
		</div>
		<div class="ag-ui-title" id="ag-themer-title">
			<?php
			$post_title = get_the_title($post);
			echo esc_html($post_title ? 'ویرایش «' . $post_title . '»' : 'طرح جدید!');
			?>
		</div>
	</div>

	<div class="ag-ui-form-group">
		<div class="ag-ui-form-group-icon">
			<svg width="14" height="14" viewBox="0 0 14 13" fill="none" xmlns="http://www.w3.org/2000/svg">
				<path d="M11.42 0H2.08C0.93 0 0 0.93 0 2.08V3.26C0 3.67 0.34 4.01 0.75 4.01C1.16 4.01 1.5 3.67 1.5 3.26V2.08C1.5 1.76 1.76 1.5 2.08 1.5H6V11.22H4.22C3.81 11.22 3.47 11.56 3.47 11.97C3.47 12.38 3.81 12.72 4.22 12.72H9.29C9.7 12.72 10.04 12.38 10.04 11.97C10.04 11.56 9.7 11.22 9.29 11.22H7.51V1.5H11.43C11.75 1.5 12.01 1.76 12.01 2.08V3.26C12.01 3.67 12.35 4.01 12.76 4.01C13.17 4.01 13.51 3.67 13.51 3.26V2.08C13.5 0.94 12.57 0 11.42 0Z" fill="#07C865" />
			</svg>
		</div>
		<input type="text" name="post_title" value="<?php echo esc_attr(get_the_title($post)); ?>" class="ag-ui-input" placeholder="افزودن عنوان جدید..." id="ag-themer-input">
	</div>




	<div class="ag-ui-section-title">
		تنظیمات تم بیلدر
		<div class="ag-ui-divider"></div>
	</div>

	<table class="ag-theme-builder-options-table widefat">

		<tbody>

			<tr class="ag-theme-builder-options-row type-of-template">
				<td class="ag-theme-builder-options-row-heading">
					<label for="ag_theme_builder_template_type"><?php esc_html_e('انتخاب نوع طرح', 'parskala'); ?></label>
				</td>
				<td class="ag-theme-builder-options-row-content">
					<select name="ag_theme_builder_template_type" id="ag_theme_builder_template_type">
						<option value="" <?php selected($template_type, ''); ?>><?php esc_html_e('انتخاب', 'parskala'); ?></option>
						<optgroup label="<?php esc_html_e('ساختار صفحه', 'parskala'); ?>">
							<option value="type_header" <?php selected($template_type, 'type_header'); ?>><?php esc_html_e('هدر سایت', 'parskala'); ?></option>
							<option value="type_footer" <?php selected($template_type, 'type_footer'); ?>><?php esc_html_e('فوتر سایت', 'parskala'); ?></option>
						</optgroup>
						<optgroup label="<?php esc_html_e('محتوای صفحه', 'parskala'); ?>">
							<option value="type_archive" <?php selected($template_type, 'type_archive'); ?>><?php esc_html_e('صفحه آرشیو', 'parskala'); ?></option>
							<option value="type_singular" <?php selected($template_type, 'type_singular'); ?>><?php esc_html_e('صفحه تکی', 'parskala'); ?></option>
							<option value="custom" <?php selected($template_type, 'custom'); ?>><?php esc_html_e('کد کوتاه', 'parskala'); ?></option>
						</optgroup>
					</select>
				</td>
			</tr>

			<tr class="ag-theme-builder-options-row header-sticky">
				<td class="ag-theme-builder-options-row-heading">
					<label for="ag_theme_builder_sticky"><?php esc_html_e('هدر چسبان', 'parskala'); ?></label>
					<i class="ag-theme-builder-options-row-heading-help dashicons dashicons-editor-help" title="<?php esc_html_e('Enable this in order to sticky header (xtb-appear).', 'parskala'); ?>"></i>
				</td>
				<td class="ag-theme-builder-options-row-content">
					<select name="ag_theme_builder_sticky" id="ag_theme_builder_sticky">
						<option value="" <?php selected($sticky, ''); ?>><?php esc_html_e('غیرفعال', 'parskala'); ?></option>
						<option value="enable" <?php selected($sticky, 'enable'); ?>><?php esc_html_e('فعال', 'parskala'); ?></option>
					</select>
				</td>
			</tr>

			<?php $this->display_rules_tab(); ?>

			<tr class="ag-theme-builder-options-row ag-theme-builder-shortcode">
				<td class="ag-theme-builder-options-row-heading">
					<label for="ag_theme_builder_template_type"><?php esc_html_e('Shortcode', 'parskala'); ?></label>
					<i class="ag-theme-builder-options-row-heading-help dashicons dashicons-editor-help" title="<?php esc_html_e('Copy this shortcode and paste it into post.', 'parskala'); ?>">
					</i>
				</td>
				<td class="ag-theme-builder-options-row-content">
					<span class="ag-theme-builder-shortcode-col-wrap">
						<input type="text" onfocus="this.select();" readonly="readonly" value="[ag_theme_builder_template id='<?php echo esc_attr($post->ID); ?>']" class="ag-theme-builder-large-text code">
					</span>
				</td>
			</tr>

		</tbody>
	</table>

	<div class="ag-ui-form-group">

		<?php


		if ($is_published) :
		?>
			<button class="ag-ui-save-btn ag-ui-submit-btn disabled" data-post-id="<?php echo esc_attr($post_id); ?>">
				ذخیره کردن
			</button>
		<?php else : ?>
			<button type="submit" name="publish" value="انتشار" class="ag-ui-submit-btn">
				<?= $submit_label ?>
			</button>
		<?php endif; ?>

		<?php if ($is_published && !empty($elementor_edit_url)) : ?>
			<a href="<?php echo esc_url($elementor_edit_url); ?>" class="ag-ui-editor-btn">
				<svg width="20" height="20" viewBox="0 0 15 15" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path d="M7.5 0C11.6421 0 15 3.35786 15 7.5C15 11.6421 11.6421 15 7.5 15C3.35786 15 0 11.6421 0 7.5C0 3.35786 3.35786 0 7.5 0ZM5 5V10H6V5H5ZM7 10H10V9H7V10ZM7 8H10V7H7V8ZM7 6H10V5H7V6Z" fill="white" />
				</svg>

				ویرایش با المنتور
			</a>
		<?php endif; ?>

	</div>

</div>
<?php else :?>


<!--  طرح جدید مدال -->
<div class="prk-modal" id="ag-themer-modal" data-append-to-body="false"  data-z-index="999999" data-overlay-blur="1px" data-overlay-background="rgba(0, 0, 0, 0.54)"
	data-overlay-close="false" data-esc-close="false" style="border-radius: 4px;width: 950px;max-width: 90%;z-index: 1000000;">
	<div class="modal-header">
		<h2 class="modal-title">افزودن طرح بندی جدید</h2>

	</div>

	<div class="modal-body">
		<div class="ag-theme-builder-options">
			<div class="ag-ui-form-group">

				<input type="text" name="post_title" value="<?php echo esc_attr(get_the_title($post)); ?>" class="ag-ui-input" placeholder="افزودن عنوان جدید..." id="ag-themer-input">
			</div>

			<div class="ag-theme-builder-options-row type-of-template">
				<div class="ag-theme-builder-options-row-heading">
					<label for="templateTypeSelector"><?php esc_html_e('انتخاب طرح', 'parskala'); ?></label>
				</div>
				<div class="ag-theme-builder-options-row-content">
					<select name="ag_theme_builder_template_type" id="ag_theme_builder_template_type" >
						<option value="" <?php selected($template_type, ''); ?>><?php esc_html_e('انتخاب', 'parskala'); ?></option>
						<optgroup label="<?php esc_html_e('ساختار', 'parskala'); ?>">
							<option value="type_header" <?php selected($template_type, 'type_header'); ?>><?php esc_html_e('هدر', 'parskala'); ?></option>
							<option value="type_footer" <?php selected($template_type, 'type_footer'); ?>><?php esc_html_e('فوتر', 'parskala'); ?></option>
						</optgroup>
						<optgroup label="<?php esc_html_e('محتوا', 'parskala'); ?>">
							<option value="type_archive" <?php selected($template_type, 'type_archive'); ?>><?php esc_html_e('آرشیو', 'parskala'); ?></option>
							<option value="type_singular" <?php selected($template_type, 'type_singular'); ?>><?php esc_html_e('صفحه تکی', 'parskala'); ?></option>
							<option value="custom" <?php selected($template_type, 'custom'); ?>><?php esc_html_e('کد کوتاه', 'parskala'); ?></option>
						</optgroup>
					</select>
				</div>
			</div>

			<input type="hidden" id="selectedLayout" name="ag_theme_builder_predefined_layout" value="">
		</div>



		<div class="predefined-layouts-section">
			<p>طرح بندی های از پیش تعریف شده</p>

			<div class="predefined-layouts">

				<div class="predefined-layout" data-name="layout_1" data-template-type="type_header">
					<img src="<?php echo get_template_directory_uri(); ?>/inc/ag-theme-builder/admin/assets/images/layout_1.jpg" alt="">
					<div class="predefined-layout-preview">
						<a href="#">
							<svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M15.5799 11.9999C15.5799 13.9799 13.9799 15.5799 11.9999 15.5799C10.0199 15.5799 8.41992 13.9799 8.41992 11.9999C8.41992 10.0199 10.0199 8.41992 11.9999 8.41992C13.9799 8.41992 15.5799 10.0199 15.5799 11.9999Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M11.9998 20.2702C15.5298 20.2702 18.8198 18.1902 21.1098 14.5902C22.0098 13.1802 22.0098 10.8102 21.1098 9.40021C18.8198 5.80021 15.5298 3.72021 11.9998 3.72021C8.46984 3.72021 5.17984 5.80021 2.88984 9.40021C1.98984 10.8102 1.98984 13.1802 2.88984 14.5902C5.17984 18.1902 8.46984 20.2702 11.9998 20.2702Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>

							پیش نمایش
						</a>
					</div>
				</div>

				<div class="predefined-layout" data-name="layout_2" data-template-type="type_header">
					<img src="<?php echo get_template_directory_uri(); ?>/inc/ag-theme-builder/admin/assets/images/layout_1.jpg" alt="">
					<div class="predefined-layout-preview">
						<a href="#">
							<svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M15.5799 11.9999C15.5799 13.9799 13.9799 15.5799 11.9999 15.5799C10.0199 15.5799 8.41992 13.9799 8.41992 11.9999C8.41992 10.0199 10.0199 8.41992 11.9999 8.41992C13.9799 8.41992 15.5799 10.0199 15.5799 11.9999Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M11.9998 20.2702C15.5298 20.2702 18.8198 18.1902 21.1098 14.5902C22.0098 13.1802 22.0098 10.8102 21.1098 9.40021C18.8198 5.80021 15.5298 3.72021 11.9998 3.72021C8.46984 3.72021 5.17984 5.80021 2.88984 9.40021C1.98984 10.8102 1.98984 13.1802 2.88984 14.5902C5.17984 18.1902 8.46984 20.2702 11.9998 20.2702Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>

							پیش نمایش
						</a>
					</div>
				</div>

				<div class="predefined-layout" data-name="layout_3" data-template-type="type_footer">
					<img src="<?php echo get_template_directory_uri(); ?>/inc/ag-theme-builder/admin/assets/images/layout_1.jpg" alt="">
					<div class="predefined-layout-preview">
						<a href="#">
							<svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M15.5799 11.9999C15.5799 13.9799 13.9799 15.5799 11.9999 15.5799C10.0199 15.5799 8.41992 13.9799 8.41992 11.9999C8.41992 10.0199 10.0199 8.41992 11.9999 8.41992C13.9799 8.41992 15.5799 10.0199 15.5799 11.9999Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M11.9998 20.2702C15.5298 20.2702 18.8198 18.1902 21.1098 14.5902C22.0098 13.1802 22.0098 10.8102 21.1098 9.40021C18.8198 5.80021 15.5298 3.72021 11.9998 3.72021C8.46984 3.72021 5.17984 5.80021 2.88984 9.40021C1.98984 10.8102 1.98984 13.1802 2.88984 14.5902C5.17984 18.1902 8.46984 20.2702 11.9998 20.2702Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>

							پیش نمایش
						</a>
					</div>
				</div>

				<div class="predefined-layout" data-name="layout_4" data-template-type="type_footer">
					<img src="<?php echo get_template_directory_uri(); ?>/inc/ag-theme-builder/admin/assets/images/layout_1.jpg" alt="">
					<div class="predefined-layout-preview">
						<a href="#">
							<svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M15.5799 11.9999C15.5799 13.9799 13.9799 15.5799 11.9999 15.5799C10.0199 15.5799 8.41992 13.9799 8.41992 11.9999C8.41992 10.0199 10.0199 8.41992 11.9999 8.41992C13.9799 8.41992 15.5799 10.0199 15.5799 11.9999Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M11.9998 20.2702C15.5298 20.2702 18.8198 18.1902 21.1098 14.5902C22.0098 13.1802 22.0098 10.8102 21.1098 9.40021C18.8198 5.80021 15.5298 3.72021 11.9998 3.72021C8.46984 3.72021 5.17984 5.80021 2.88984 9.40021C1.98984 10.8102 1.98984 13.1802 2.88984 14.5902C5.17984 18.1902 8.46984 20.2702 11.9998 20.2702Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>

							پیش نمایش
						</a>
					</div>
				</div>

				<div class="predefined-layout" data-name="layout_5" data-template-type="type_footer">
					<img src="<?php echo get_template_directory_uri(); ?>/inc/ag-theme-builder/admin/assets/images/layout_1.jpg" alt="">
					<div class="predefined-layout-preview">
						<a href="#">
							<svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M15.5799 11.9999C15.5799 13.9799 13.9799 15.5799 11.9999 15.5799C10.0199 15.5799 8.41992 13.9799 8.41992 11.9999C8.41992 10.0199 10.0199 8.41992 11.9999 8.41992C13.9799 8.41992 15.5799 10.0199 15.5799 11.9999Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M11.9998 20.2702C15.5298 20.2702 18.8198 18.1902 21.1098 14.5902C22.0098 13.1802 22.0098 10.8102 21.1098 9.40021C18.8198 5.80021 15.5298 3.72021 11.9998 3.72021C8.46984 3.72021 5.17984 5.80021 2.88984 9.40021C1.98984 10.8102 1.98984 13.1802 2.88984 14.5902C5.17984 18.1902 8.46984 20.2702 11.9998 20.2702Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>

							پیش نمایش
						</a>
					</div>
				</div>

				<div class="predefined-layout" data-name="layout_6" data-template-type="type_footer">
					<img src="<?php echo get_template_directory_uri(); ?>/inc/ag-theme-builder/admin/assets/images/layout_1.jpg" alt="">
					<div class="predefined-layout-preview">
						<a href="#">
							<svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M15.5799 11.9999C15.5799 13.9799 13.9799 15.5799 11.9999 15.5799C10.0199 15.5799 8.41992 13.9799 8.41992 11.9999C8.41992 10.0199 10.0199 8.41992 11.9999 8.41992C13.9799 8.41992 15.5799 10.0199 15.5799 11.9999Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M11.9998 20.2702C15.5298 20.2702 18.8198 18.1902 21.1098 14.5902C22.0098 13.1802 22.0098 10.8102 21.1098 9.40021C18.8198 5.80021 15.5298 3.72021 11.9998 3.72021C8.46984 3.72021 5.17984 5.80021 2.88984 9.40021C1.98984 10.8102 1.98984 13.1802 2.88984 14.5902C5.17984 18.1902 8.46984 20.2702 11.9998 20.2702Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>

							پیش نمایش
						</a>
					</div>
				</div>

				<div class="predefined-layout" data-name="layout_7" data-template-type="type_archive">
					<img src="<?php echo get_template_directory_uri(); ?>/inc/ag-theme-builder/admin/assets/images/layout_1.jpg" alt="">
					<div class="predefined-layout-preview">
						<a href="#">
							<svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M15.5799 11.9999C15.5799 13.9799 13.9799 15.5799 11.9999 15.5799C10.0199 15.5799 8.41992 13.9799 8.41992 11.9999C8.41992 10.0199 10.0199 8.41992 11.9999 8.41992C13.9799 8.41992 15.5799 10.0199 15.5799 11.9999Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M11.9998 20.2702C15.5298 20.2702 18.8198 18.1902 21.1098 14.5902C22.0098 13.1802 22.0098 10.8102 21.1098 9.40021C18.8198 5.80021 15.5298 3.72021 11.9998 3.72021C8.46984 3.72021 5.17984 5.80021 2.88984 9.40021C1.98984 10.8102 1.98984 13.1802 2.88984 14.5902C5.17984 18.1902 8.46984 20.2702 11.9998 20.2702Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>

							پیش نمایش
						</a>
					</div>
				</div>

				<div class="predefined-layout" data-name="layout_8" data-template-type="type_archive">
					<img src="<?php echo get_template_directory_uri(); ?>/inc/ag-theme-builder/admin/assets/images/layout_1.jpg" alt="">
					<div class="predefined-layout-preview">
						<a href="#">
							<svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M15.5799 11.9999C15.5799 13.9799 13.9799 15.5799 11.9999 15.5799C10.0199 15.5799 8.41992 13.9799 8.41992 11.9999C8.41992 10.0199 10.0199 8.41992 11.9999 8.41992C13.9799 8.41992 15.5799 10.0199 15.5799 11.9999Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M11.9998 20.2702C15.5298 20.2702 18.8198 18.1902 21.1098 14.5902C22.0098 13.1802 22.0098 10.8102 21.1098 9.40021C18.8198 5.80021 15.5298 3.72021 11.9998 3.72021C8.46984 3.72021 5.17984 5.80021 2.88984 9.40021C1.98984 10.8102 1.98984 13.1802 2.88984 14.5902C5.17984 18.1902 8.46984 20.2702 11.9998 20.2702Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>

							پیش نمایش
						</a>
					</div>
				</div>

				<div class="predefined-layout" data-name="layout_9" data-template-type="type_archive">
					<img src="<?php echo get_template_directory_uri(); ?>/inc/ag-theme-builder/admin/assets/images/layout_1.jpg" alt="">
					<div class="predefined-layout-preview">
						<a href="#">
							<svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M15.5799 11.9999C15.5799 13.9799 13.9799 15.5799 11.9999 15.5799C10.0199 15.5799 8.41992 13.9799 8.41992 11.9999C8.41992 10.0199 10.0199 8.41992 11.9999 8.41992C13.9799 8.41992 15.5799 10.0199 15.5799 11.9999Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M11.9998 20.2702C15.5298 20.2702 18.8198 18.1902 21.1098 14.5902C22.0098 13.1802 22.0098 10.8102 21.1098 9.40021C18.8198 5.80021 15.5298 3.72021 11.9998 3.72021C8.46984 3.72021 5.17984 5.80021 2.88984 9.40021C1.98984 10.8102 1.98984 13.1802 2.88984 14.5902C5.17984 18.1902 8.46984 20.2702 11.9998 20.2702Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>

							پیش نمایش
						</a>
					</div>
				</div>

				<div class="predefined-layout" data-name="layout_10" data-template-type="type_singular">
					<img src="<?php echo get_template_directory_uri(); ?>/inc/ag-theme-builder/admin/assets/images/layout_1.jpg" alt="">
					<div class="predefined-layout-preview">
						<a href="#">
							<svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M15.5799 11.9999C15.5799 13.9799 13.9799 15.5799 11.9999 15.5799C10.0199 15.5799 8.41992 13.9799 8.41992 11.9999C8.41992 10.0199 10.0199 8.41992 11.9999 8.41992C13.9799 8.41992 15.5799 10.0199 15.5799 11.9999Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M11.9998 20.2702C15.5298 20.2702 18.8198 18.1902 21.1098 14.5902C22.0098 13.1802 22.0098 10.8102 21.1098 9.40021C18.8198 5.80021 15.5298 3.72021 11.9998 3.72021C8.46984 3.72021 5.17984 5.80021 2.88984 9.40021C1.98984 10.8102 1.98984 13.1802 2.88984 14.5902C5.17984 18.1902 8.46984 20.2702 11.9998 20.2702Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>

							پیش نمایش
						</a>
					</div>
				</div>

				<div class="predefined-layout" data-name="layout_11" data-template-type="type_singular">
					<img src="<?php echo get_template_directory_uri(); ?>/inc/ag-theme-builder/admin/assets/images/layout_1.jpg" alt="">
					<div class="predefined-layout-preview">
						<a href="#">
							<svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M15.5799 11.9999C15.5799 13.9799 13.9799 15.5799 11.9999 15.5799C10.0199 15.5799 8.41992 13.9799 8.41992 11.9999C8.41992 10.0199 10.0199 8.41992 11.9999 8.41992C13.9799 8.41992 15.5799 10.0199 15.5799 11.9999Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M11.9998 20.2702C15.5298 20.2702 18.8198 18.1902 21.1098 14.5902C22.0098 13.1802 22.0098 10.8102 21.1098 9.40021C18.8198 5.80021 15.5298 3.72021 11.9998 3.72021C8.46984 3.72021 5.17984 5.80021 2.88984 9.40021C1.98984 10.8102 1.98984 13.1802 2.88984 14.5902C5.17984 18.1902 8.46984 20.2702 11.9998 20.2702Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>

							پیش نمایش
						</a>
					</div>
				</div>

				<div class="predefined-layout" data-name="layout_12" data-template-type="type_singular">
					<img src="<?php echo get_template_directory_uri(); ?>/inc/ag-theme-builder/admin/assets/images/layout_1.jpg" alt="">
					<div class="predefined-layout-preview">
						<a href="#">
							<svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M15.5799 11.9999C15.5799 13.9799 13.9799 15.5799 11.9999 15.5799C10.0199 15.5799 8.41992 13.9799 8.41992 11.9999C8.41992 10.0199 10.0199 8.41992 11.9999 8.41992C13.9799 8.41992 15.5799 10.0199 15.5799 11.9999Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M11.9998 20.2702C15.5298 20.2702 18.8198 18.1902 21.1098 14.5902C22.0098 13.1802 22.0098 10.8102 21.1098 9.40021C18.8198 5.80021 15.5298 3.72021 11.9998 3.72021C8.46984 3.72021 5.17984 5.80021 2.88984 9.40021C1.98984 10.8102 1.98984 13.1802 2.88984 14.5902C5.17984 18.1902 8.46984 20.2702 11.9998 20.2702Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>

							پیش نمایش
						</a>
					</div>
				</div>

				<div class="predefined-layout" data-name="layout_13" data-template-type="type_singular">
					<img src="<?php echo get_template_directory_uri(); ?>/inc/ag-theme-builder/admin/assets/images/layout_1.jpg" alt="">
					<div class="predefined-layout-preview">
						<a href="#">
							<svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M15.5799 11.9999C15.5799 13.9799 13.9799 15.5799 11.9999 15.5799C10.0199 15.5799 8.41992 13.9799 8.41992 11.9999C8.41992 10.0199 10.0199 8.41992 11.9999 8.41992C13.9799 8.41992 15.5799 10.0199 15.5799 11.9999Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M11.9998 20.2702C15.5298 20.2702 18.8198 18.1902 21.1098 14.5902C22.0098 13.1802 22.0098 10.8102 21.1098 9.40021C18.8198 5.80021 15.5298 3.72021 11.9998 3.72021C8.46984 3.72021 5.17984 5.80021 2.88984 9.40021C1.98984 10.8102 1.98984 13.1802 2.88984 14.5902C5.17984 18.1902 8.46984 20.2702 11.9998 20.2702Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>

							پیش نمایش
						</a>
					</div>
				</div>

				<div class="predefined-layout" data-name="layout_14" data-template-type="type_singular">
					<img src="<?php echo get_template_directory_uri(); ?>/inc/ag-theme-builder/admin/assets/images/layout_1.jpg" alt="">
					<div class="predefined-layout-preview">
						<a href="#">
							<svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M15.5799 11.9999C15.5799 13.9799 13.9799 15.5799 11.9999 15.5799C10.0199 15.5799 8.41992 13.9799 8.41992 11.9999C8.41992 10.0199 10.0199 8.41992 11.9999 8.41992C13.9799 8.41992 15.5799 10.0199 15.5799 11.9999Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M11.9998 20.2702C15.5298 20.2702 18.8198 18.1902 21.1098 14.5902C22.0098 13.1802 22.0098 10.8102 21.1098 9.40021C18.8198 5.80021 15.5298 3.72021 11.9998 3.72021C8.46984 3.72021 5.17984 5.80021 2.88984 9.40021C1.98984 10.8102 1.98984 13.1802 2.88984 14.5902C5.17984 18.1902 8.46984 20.2702 11.9998 20.2702Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>

							پیش نمایش
						</a>
					</div>
				</div>

				<div class="predefined-layout" data-name="layout_15" data-template-type="type_singular">
					<img src="<?php echo get_template_directory_uri(); ?>/inc/ag-theme-builder/admin/assets/images/layout_1.jpg" alt="">
					<div class="predefined-layout-preview">
						<a href="#">
							<svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M15.5799 11.9999C15.5799 13.9799 13.9799 15.5799 11.9999 15.5799C10.0199 15.5799 8.41992 13.9799 8.41992 11.9999C8.41992 10.0199 10.0199 8.41992 11.9999 8.41992C13.9799 8.41992 15.5799 10.0199 15.5799 11.9999Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M11.9998 20.2702C15.5298 20.2702 18.8198 18.1902 21.1098 14.5902C22.0098 13.1802 22.0098 10.8102 21.1098 9.40021C18.8198 5.80021 15.5298 3.72021 11.9998 3.72021C8.46984 3.72021 5.17984 5.80021 2.88984 9.40021C1.98984 10.8102 1.98984 13.1802 2.88984 14.5902C5.17984 18.1902 8.46984 20.2702 11.9998 20.2702Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>

							پیش نمایش
						</a>
					</div>
				</div>

				<div class="predefined-layout" data-name="layout_16" data-template-type="type_singular">
					<img src="<?php echo get_template_directory_uri(); ?>/inc/ag-theme-builder/admin/assets/images/layout_1.jpg" alt="">
					<div class="predefined-layout-preview">
						<a href="#">
							<svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M15.5799 11.9999C15.5799 13.9799 13.9799 15.5799 11.9999 15.5799C10.0199 15.5799 8.41992 13.9799 8.41992 11.9999C8.41992 10.0199 10.0199 8.41992 11.9999 8.41992C13.9799 8.41992 15.5799 10.0199 15.5799 11.9999Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M11.9998 20.2702C15.5298 20.2702 18.8198 18.1902 21.1098 14.5902C22.0098 13.1802 22.0098 10.8102 21.1098 9.40021C18.8198 5.80021 15.5298 3.72021 11.9998 3.72021C8.46984 3.72021 5.17984 5.80021 2.88984 9.40021C1.98984 10.8102 1.98984 13.1802 2.88984 14.5902C5.17984 18.1902 8.46984 20.2702 11.9998 20.2702Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>

							پیش نمایش
						</a>
					</div>
				</div>

				<div class="predefined-layout" data-name="layout_17" data-template-type="type_singular">
					<img src="<?php echo get_template_directory_uri(); ?>/inc/ag-theme-builder/admin/assets/images/layout_1.jpg" alt="">
					<div class="predefined-layout-preview">
						<a href="#">
							<svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M15.5799 11.9999C15.5799 13.9799 13.9799 15.5799 11.9999 15.5799C10.0199 15.5799 8.41992 13.9799 8.41992 11.9999C8.41992 10.0199 10.0199 8.41992 11.9999 8.41992C13.9799 8.41992 15.5799 10.0199 15.5799 11.9999Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M11.9998 20.2702C15.5298 20.2702 18.8198 18.1902 21.1098 14.5902C22.0098 13.1802 22.0098 10.8102 21.1098 9.40021C18.8198 5.80021 15.5298 3.72021 11.9998 3.72021C8.46984 3.72021 5.17984 5.80021 2.88984 9.40021C1.98984 10.8102 1.98984 13.1802 2.88984 14.5902C5.17984 18.1902 8.46984 20.2702 11.9998 20.2702Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>

							پیش نمایش
						</a>
					</div>
				</div>

				<div class="predefined-layout" data-name="layout_18" data-template-type="type_singular">
					<img src="<?php echo get_template_directory_uri(); ?>/inc/ag-theme-builder/admin/assets/images/layout_1.jpg" alt="">
					<div class="predefined-layout-preview">
						<a href="#">
							<svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M15.5799 11.9999C15.5799 13.9799 13.9799 15.5799 11.9999 15.5799C10.0199 15.5799 8.41992 13.9799 8.41992 11.9999C8.41992 10.0199 10.0199 8.41992 11.9999 8.41992C13.9799 8.41992 15.5799 10.0199 15.5799 11.9999Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M11.9998 20.2702C15.5298 20.2702 18.8198 18.1902 21.1098 14.5902C22.0098 13.1802 22.0098 10.8102 21.1098 9.40021C18.8198 5.80021 15.5298 3.72021 11.9998 3.72021C8.46984 3.72021 5.17984 5.80021 2.88984 9.40021C1.98984 10.8102 1.98984 13.1802 2.88984 14.5902C5.17984 18.1902 8.46984 20.2702 11.9998 20.2702Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>

							پیش نمایش
						</a>
					</div>
				</div>

				<div class="predefined-layout" data-name="layout_19" data-template-type="type_header">
					<img src="<?php echo get_template_directory_uri(); ?>/inc/ag-theme-builder/admin/assets/images/layout_1.jpg" alt="">
					<div class="predefined-layout-preview">
						<a href="#">
							<svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M15.5799 11.9999C15.5799 13.9799 13.9799 15.5799 11.9999 15.5799C10.0199 15.5799 8.41992 13.9799 8.41992 11.9999C8.41992 10.0199 10.0199 8.41992 11.9999 8.41992C13.9799 8.41992 15.5799 10.0199 15.5799 11.9999Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M11.9998 20.2702C15.5298 20.2702 18.8198 18.1902 21.1098 14.5902C22.0098 13.1802 22.0098 10.8102 21.1098 9.40021C18.8198 5.80021 15.5298 3.72021 11.9998 3.72021C8.46984 3.72021 5.17984 5.80021 2.88984 9.40021C1.98984 10.8102 1.98984 13.1802 2.88984 14.5902C5.17984 18.1902 8.46984 20.2702 11.9998 20.2702Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>

							پیش نمایش
						</a>
					</div>
				</div>

				<div class="predefined-layout" data-name="layout_20" data-template-type="type_header">
					<img src="<?php echo get_template_directory_uri(); ?>/inc/ag-theme-builder/admin/assets/images/layout_1.jpg" alt="">
					<div class="predefined-layout-preview">
						<a href="#">
							<svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M15.5799 11.9999C15.5799 13.9799 13.9799 15.5799 11.9999 15.5799C10.0199 15.5799 8.41992 13.9799 8.41992 11.9999C8.41992 10.0199 10.0199 8.41992 11.9999 8.41992C13.9799 8.41992 15.5799 10.0199 15.5799 11.9999Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M11.9998 20.2702C15.5298 20.2702 18.8198 18.1902 21.1098 14.5902C22.0098 13.1802 22.0098 10.8102 21.1098 9.40021C18.8198 5.80021 15.5298 3.72021 11.9998 3.72021C8.46984 3.72021 5.17984 5.80021 2.88984 9.40021C1.98984 10.8102 1.98984 13.1802 2.88984 14.5902C5.17984 18.1902 8.46984 20.2702 11.9998 20.2702Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>

							پیش نمایش
						</a>
					</div>
				</div>

				<div class="predefined-layout" data-name="layout_21" data-template-type="type_header">
					<img src="<?php echo get_template_directory_uri(); ?>/inc/ag-theme-builder/admin/assets/images/layout_1.jpg" alt="">
					<div class="predefined-layout-preview">
						<a href="#">
							<svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M15.5799 11.9999C15.5799 13.9799 13.9799 15.5799 11.9999 15.5799C10.0199 15.5799 8.41992 13.9799 8.41992 11.9999C8.41992 10.0199 10.0199 8.41992 11.9999 8.41992C13.9799 8.41992 15.5799 10.0199 15.5799 11.9999Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M11.9998 20.2702C15.5298 20.2702 18.8198 18.1902 21.1098 14.5902C22.0098 13.1802 22.0098 10.8102 21.1098 9.40021C18.8198 5.80021 15.5298 3.72021 11.9998 3.72021C8.46984 3.72021 5.17984 5.80021 2.88984 9.40021C1.98984 10.8102 1.98984 13.1802 2.88984 14.5902C5.17984 18.1902 8.46984 20.2702 11.9998 20.2702Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>

							پیش نمایش
						</a>
					</div>
				</div>

				<div class="predefined-layout" data-name="layout_22" data-template-type="type_header">
					<img src="<?php echo get_template_directory_uri(); ?>/inc/ag-theme-builder/admin/assets/images/layout_1.jpg" alt="">
					<div class="predefined-layout-preview">
						<a href="#">
							<svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M15.5799 11.9999C15.5799 13.9799 13.9799 15.5799 11.9999 15.5799C10.0199 15.5799 8.41992 13.9799 8.41992 11.9999C8.41992 10.0199 10.0199 8.41992 11.9999 8.41992C13.9799 8.41992 15.5799 10.0199 15.5799 11.9999Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M11.9998 20.2702C15.5298 20.2702 18.8198 18.1902 21.1098 14.5902C22.0098 13.1802 22.0098 10.8102 21.1098 9.40021C18.8198 5.80021 15.5298 3.72021 11.9998 3.72021C8.46984 3.72021 5.17984 5.80021 2.88984 9.40021C1.98984 10.8102 1.98984 13.1802 2.88984 14.5902C5.17984 18.1902 8.46984 20.2702 11.9998 20.2702Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>

							پیش نمایش
						</a>
					</div>
				</div>

				<div class="predefined-layout" data-name="layout_23" data-template-type="type_header">
					<img src="<?php echo get_template_directory_uri(); ?>/inc/ag-theme-builder/admin/assets/images/layout_1.jpg" alt="">
					<div class="predefined-layout-preview">
						<a href="#">
							<svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M15.5799 11.9999C15.5799 13.9799 13.9799 15.5799 11.9999 15.5799C10.0199 15.5799 8.41992 13.9799 8.41992 11.9999C8.41992 10.0199 10.0199 8.41992 11.9999 8.41992C13.9799 8.41992 15.5799 10.0199 15.5799 11.9999Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M11.9998 20.2702C15.5298 20.2702 18.8198 18.1902 21.1098 14.5902C22.0098 13.1802 22.0098 10.8102 21.1098 9.40021C18.8198 5.80021 15.5298 3.72021 11.9998 3.72021C8.46984 3.72021 5.17984 5.80021 2.88984 9.40021C1.98984 10.8102 1.98984 13.1802 2.88984 14.5902C5.17984 18.1902 8.46984 20.2702 11.9998 20.2702Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>

							پیش نمایش
						</a>
					</div>
				</div>

				<div class="predefined-layout" data-name="layout_24" data-template-type="type_header">
					<img src="<?php echo get_template_directory_uri(); ?>/inc/ag-theme-builder/admin/assets/images/layout_1.jpg" alt="">
					<div class="predefined-layout-preview">
						<a href="#">
							<svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M15.5799 11.9999C15.5799 13.9799 13.9799 15.5799 11.9999 15.5799C10.0199 15.5799 8.41992 13.9799 8.41992 11.9999C8.41992 10.0199 10.0199 8.41992 11.9999 8.41992C13.9799 8.41992 15.5799 10.0199 15.5799 11.9999Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
								<path d="M11.9998 20.2702C15.5298 20.2702 18.8198 18.1902 21.1098 14.5902C22.0098 13.1802 22.0098 10.8102 21.1098 9.40021C18.8198 5.80021 15.5298 3.72021 11.9998 3.72021C8.46984 3.72021 5.17984 5.80021 2.88984 9.40021C1.98984 10.8102 1.98984 13.1802 2.88984 14.5902C5.17984 18.1902 8.46984 20.2702 11.9998 20.2702Z" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
							</svg>

							پیش نمایش
						</a>
					</div>
				</div>


			</div>
		</div>
	</div>


	<div class="modal-footer">

		<button id="agThemerConfirmModal" class="ag-themer-modal-submit-btn ag-ui-submit-btn" type="submit" name="publish" value="انتشار">
			<svg width="21" height="21" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
				<path d="M6 12H18" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
				<path d="M12 18V6" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
			</svg>

			افزودن
		</button>
	
           <a href="<?php echo admin_url( 'edit.php?post_type=ag-themer' ); ?>" class="ag-themer-modal-submit-btn cansel">لغو</a>	
	
	</div>

</div>

<script>
	

	document.addEventListener('DOMContentLoaded', function() {
		const layoutSection = document.querySelector('.predefined-layouts-section');
		const layoutItems = document.querySelectorAll('.predefined-layout');
		const hiddenInput = document.getElementById('selectedLayout');
		const templateTypeSelect = document.getElementById('ag_theme_builder_template_type');

		function updateVisibleLayouts() {
			const selectedType = templateTypeSelect.value;
			console.log(selectedType);


			// اگر چیزی انتخاب نشده، کل سکشن پنهان میشه
			if (!selectedType) {
				layoutSection.style.display = 'none';
			} else {
				layoutSection.style.display = '';
				layoutItems.forEach(item => {
					const itemType = item.getAttribute('data-template-type');
					item.style.display = (itemType === selectedType) ? '' : 'none';
				});
			}
		}

		templateTypeSelect.addEventListener('change', updateVisibleLayouts);
		updateVisibleLayouts();

		layoutItems.forEach(item => {
			item.addEventListener('click', () => {
				const isActive = item.classList.contains('active');
				layoutItems.forEach(el => el.classList.remove('active'));

				if (!isActive) {
					item.classList.add('active');
					hiddenInput.value = item.getAttribute('data-name');
				} else {
					hiddenInput.value = '';
				}
			});
		});
	});


</script>

<?php endif;?>