<?php


add_action('wp_ajax_save_ag_themer_post', function () {

    // بررسی نانس و مجوز
    if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'save_ag_themer_nonce')) {
        wp_send_json_error(['message' => 'Nonce نامعتبر است']);
    }

    $post_id = intval($_POST['post_id'] ?? 0);
    if (!$post_id || get_post_type($post_id) !== 'ag-themer') {
        wp_send_json_error(['message' => 'پست آیدی نامعتبر است']);
    }

    // ذخیره عنوان پست
    if (!empty($_POST['post_title'])) {
        wp_update_post([
            'ID'         => $post_id,
            'post_title' => sanitize_text_field($_POST['post_title']),
        ]);
    }

    // ذخیره Display و Exclude از فیلد JSON
    if (!empty($_POST['ag_theme_builder_target_include_locations_json'])) {
        $include = json_decode(stripslashes($_POST['ag_theme_builder_target_include_locations_json']), true);
        update_post_meta($post_id, 'ag_theme_builder_target_include_locations', $include);
    }

    if (!empty($_POST['ag_theme_builder_target_exclude_locations_json'])) {
        $exclude = json_decode(stripslashes($_POST['ag_theme_builder_target_exclude_locations_json']), true);
        update_post_meta($post_id, 'ag_theme_builder_target_exclude_locations', $exclude);
    }

    // ذخیره نقش‌های کاربری
    if (!empty($_POST['ag-theme-builder-target-rules-users'])) {
        $users = array_map('sanitize_text_field', $_POST['ag-theme-builder-target-rules-users']);
        update_post_meta($post_id, 'ag_theme_builder_target_user_roles', $users);
    }

    // حذف فیلدهایی که نباید ذخیره شن
    $exclude_keys = ['action', 'nonce', 'post_id', 'ag_theme_builder_target_include_locations_json', 'ag_theme_builder_target_exclude_locations_json'];

    // ذخیره سایر متاها
    foreach ($_POST as $key => $value) {
        if (in_array($key, $exclude_keys, true)) continue;

        // آرایه‌ها رو جیسون کن
        if (is_array($value)) {
            update_post_meta($post_id, $key, wp_json_encode($value));
        } else {
            update_post_meta($post_id, $key, sanitize_text_field($value));
        }
    }

    wp_send_json_success(['message' => 'با موفقیت ذخیره شد']);
});


/**
 * Ajax callback to create a new ag-themer post and redirect to edit page
 */
add_action('wp_ajax_prk_create_ag_themer_post', 'prk_create_ag_themer_post');
function prk_create_ag_themer_post() {
	// تأیید نانس برای امنیت
	check_ajax_referer('create_ag_themer_post');

	// دریافت و پاک‌سازی داده‌ها
	$title  = sanitize_text_field($_POST['post_title'] ?? '');
	$type   = sanitize_text_field($_POST['ag_theme_builder_template_type'] ?? '');
	$layout = sanitize_text_field($_POST['ag_theme_builder_predefined_layout'] ?? '');

	// بررسی کامل بودن فیلدها
	if (empty($title) || empty($type)) {
		wp_send_json_error('فیلد عنوان و نوع طرح الزامی است.');
	}

	// ایجاد پست جدید
	$post_id = wp_insert_post([
		'post_type'   => 'ag-themer',
		'post_title'  => $title,
		'post_status' => 'publish',
	]);

	// بررسی خطا در درج پست
	if (is_wp_error($post_id)) {
		wp_send_json_error('ایجاد پست با خطا مواجه شد.');
	}

	// ذخیره متاهای طرح
	update_post_meta($post_id, 'ag_theme_builder_template_type', $type);

	if (!empty($layout)) {
		update_post_meta($post_id, 'ag_theme_builder_predefined_layout', $layout);
	}

	// بازگشت موفقیت با لینک ویرایش
	wp_send_json_success([
		'edit_url' => admin_url("post.php?post={$post_id}&action=edit")
	]);
}

