<?php
/**
 * Plugin Name: Ag Theme Builder
 * Plugin URI:  https://agarousi.com
 * Description: Free Theme Builder for Elementor
 * Author:      Amirhossein Garousi
 * Author URI:  https://agarousi.comf
 * Version:     1.0
 * Developer:   Amirhossein Garousi
 * Text Domain: ag-theme-builder
 * Elementor tested up to: 3.17.1
 *
 * @package ag-theme-builder
 */

define( 'AG_THEME_BUILDER_VER', '1.0' );
define( 'AG_THEME_BUILDER_FILE', __FILE__ );
define( 'AG_THEME_BUILDER_BASE', plugin_basename( __FILE__ ) );
define( 'AG_THEME_BUILDER_DIR', parskala_TEMPLATEPATH . '/inc/ag-theme-builder/' );
define( 'AG_THEME_BUILDER_URL', get_template_directory_uri() . '/inc/ag-theme-builder/' );


final class Ag_Theme_Builder {
    /**
     * Constructor
     *
     * @since 1.0.0
     * @access public
     */
    public function __construct() {
        // Init Plugin
        add_action( 'after_setup_theme', array( $this, 'init' ) );

        // Fires when Ag Theme Builder is fully loaded
        do_action( 'ag_theme_builder_loaded' );

    }

    /**
     * Initialize the plugin
     *
     * Validates that Elementor is already loaded.
     * Checks for basic plugin requirements, if one check fails don't continue,
     * if all checks have passed include the plugin class.
     *
     * Fired by `after_setup_theme` action hook.
     *
     * @since 1.0.0
     * @access public
     */
    public function init() {
        // Once we get here, we have passed all validation checks so we can safely include our plugin
        require_once AG_THEME_BUILDER_DIR . 'plugin.php';
    }
}

// Instantiate Ag_Theme_Builder.
new Ag_Theme_Builder();
