/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-08-01 15:18:25 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=2318 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=105175 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=7052 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=214 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=108 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_dokan_announcement` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `post_id` bigint(11) NOT NULL,
  `status` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_dokan_orders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) DEFAULT NULL,
  `seller_id` bigint(20) DEFAULT NULL,
  `order_total` decimal(19,4) DEFAULT NULL,
  `net_amount` decimal(19,4) DEFAULT NULL,
  `order_status` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  KEY `seller_id` (`seller_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_dokan_refund` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `seller_id` bigint(20) NOT NULL,
  `refund_amount` decimal(19,4) NOT NULL,
  `refund_reason` text DEFAULT NULL,
  `item_qtys` varchar(200) DEFAULT NULL,
  `item_totals` text DEFAULT NULL,
  `item_tax_totals` text DEFAULT NULL,
  `restock_items` varchar(10) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `status` int(1) NOT NULL,
  `method` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_dokan_reverse_withdrawal` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `trn_id` bigint(20) unsigned NOT NULL,
  `trn_type` varchar(200) NOT NULL DEFAULT 'order_commission',
  `vendor_id` bigint(20) unsigned NOT NULL,
  `note` mediumtext DEFAULT NULL,
  `debit` decimal(19,4) NOT NULL DEFAULT 0.0000,
  `credit` decimal(19,4) NOT NULL DEFAULT 0.0000,
  `trn_date` int(11) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `trn_date` (`trn_date`),
  KEY `vendor_id_trn_date` (`vendor_id`,`trn_date`),
  KEY `vendor_id` (`vendor_id`),
  KEY `trn_id_type` (`trn_id`,`trn_type`(191)),
  KEY `vendor_id_trn_date_type` (`vendor_id`,`trn_date`,`trn_type`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_dokan_vendor_balance` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `vendor_id` bigint(20) unsigned NOT NULL,
  `trn_id` bigint(20) unsigned NOT NULL,
  `trn_type` varchar(30) NOT NULL,
  `perticulars` text NOT NULL,
  `debit` decimal(19,4) NOT NULL,
  `credit` decimal(19,4) NOT NULL,
  `status` varchar(30) DEFAULT NULL,
  `trn_date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `balance_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_dokan_withdraw` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `amount` decimal(19,4) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `status` int(1) NOT NULL,
  `method` varchar(30) NOT NULL,
  `note` text NOT NULL,
  `details` longtext NOT NULL,
  `ip` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_eh_sms_verification` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `phone` varchar(15) NOT NULL,
  `code` varchar(10) NOT NULL,
  `expire_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `phone` (`phone`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_next_shopping_list` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `product_name` varchar(500) NOT NULL DEFAULT '',
  `user_name` varchar(500) NOT NULL DEFAULT '',
  `product_price` varchar(200) NOT NULL DEFAULT '',
  `variation_id` int(11) DEFAULT NULL,
  `variation_attributes` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `product_id` (`product_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=174612 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=26086 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=2966 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_prk_sms_app_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `message` varchar(100) NOT NULL,
  `status` int(11) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_prk_sms_app_newsletter` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mobile` bigint(20) NOT NULL,
  `active` enum('0','1') DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_prk_verify_code` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `key_code` varchar(255) NOT NULL,
  `value_code` varchar(255) NOT NULL,
  `expire` varchar(255) NOT NULL,
  `type` enum('mobile','email') NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=236 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_smush_dir_images` (
  `id` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  `path_hash` char(32) DEFAULT NULL,
  `resize` varchar(55) DEFAULT NULL,
  `lossy` varchar(55) DEFAULT NULL,
  `error` varchar(55) DEFAULT NULL,
  `image_size` int(10) unsigned DEFAULT NULL,
  `orig_size` int(10) unsigned DEFAULT NULL,
  `file_time` int(10) unsigned DEFAULT NULL,
  `last_scan` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `path_hash` (`path_hash`),
  KEY `image_size` (`image_size`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=187 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=251 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=187 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=1812 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=67 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=37048 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=159 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=MyISAM AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_ir` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text1` text NOT NULL,
  `text2` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM AUTO_INCREMENT=958 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM AUTO_INCREMENT=121 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=904 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_yith_wcwl` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `prod_id` bigint(20) NOT NULL,
  `quantity` int(11) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `wishlist_id` bigint(20) DEFAULT NULL,
  `position` int(11) DEFAULT 0,
  `original_price` decimal(9,3) DEFAULT NULL,
  `original_currency` char(3) DEFAULT NULL,
  `dateadded` timestamp NOT NULL DEFAULT current_timestamp(),
  `on_sale` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `prod_id` (`prod_id`)
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_yith_wcwl_lists` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `session_id` varchar(255) DEFAULT NULL,
  `wishlist_slug` varchar(200) NOT NULL,
  `wishlist_name` text DEFAULT NULL,
  `wishlist_token` varchar(64) NOT NULL,
  `wishlist_privacy` tinyint(1) NOT NULL DEFAULT 0,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `dateadded` timestamp NOT NULL DEFAULT current_timestamp(),
  `expiration` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `wishlist_token` (`wishlist_token`),
  KEY `wishlist_slug` (`wishlist_slug`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("2290", "woocommerce_cleanup_draft_orders", "complete", "2025-07-26 22:32:37", "2025-07-26 22:32:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753569157;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753569157;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-26 22:37:37", "2025-07-27 02:07:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2289", "woocommerce_cleanup_draft_orders", "complete", "2025-07-26 22:32:37", "2025-07-26 22:32:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753569157;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753569157;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-26 22:37:37", "2025-07-27 02:07:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2206", "woocommerce_cleanup_draft_orders", "complete", "2025-07-05 18:32:47", "2025-07-05 18:32:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751740367;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751740367;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-05 18:36:34", "2025-07-05 22:06:34", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2203", "woocommerce_refresh_order_count_cache", "complete", "2025-07-04 06:32:08", "2025-07-04 06:32:08", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751610728;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751610728;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-04 06:32:12", "2025-07-04 10:02:12", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2194", "woocommerce_cleanup_draft_orders", "complete", "2025-07-02 18:30:41", "2025-07-02 18:30:41", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751481041;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751481041;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-02 18:31:37", "2025-07-02 22:01:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2198", "woocommerce_cleanup_draft_orders", "complete", "2025-07-03 18:31:37", "2025-07-03 18:31:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751567497;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751567497;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-03 18:32:08", "2025-07-03 22:02:08", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2210", "woocommerce_cleanup_draft_orders", "complete", "2025-07-06 18:36:34", "2025-07-06 18:36:34", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751826994;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751826994;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-06 19:09:17", "2025-07-06 22:39:17", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2202", "woocommerce_cleanup_draft_orders", "complete", "2025-07-04 18:32:08", "2025-07-04 18:32:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751653928;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751653928;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-04 18:32:47", "2025-07-04 22:02:47", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2234", "woocommerce_cleanup_draft_orders", "complete", "2025-07-12 20:40:39", "2025-07-12 20:40:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752352839;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752352839;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-12 20:47:13", "2025-07-13 00:17:13", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2267", "woocommerce_refresh_order_count_cache", "complete", "2025-07-20 12:36:53", "2025-07-20 12:36:53", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753015013;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753015013;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-20 12:38:04", "2025-07-20 16:08:04", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2266", "woocommerce_cleanup_draft_orders", "complete", "2025-07-20 22:06:48", "2025-07-20 22:06:48", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753049208;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753049208;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-20 22:06:59", "2025-07-21 01:36:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2238", "woocommerce_cleanup_draft_orders", "complete", "2025-07-13 20:47:13", "2025-07-13 20:47:13", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752439633;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752439633;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-13 20:53:43", "2025-07-14 00:23:43", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2274", "woocommerce_cleanup_draft_orders", "complete", "2025-07-22 22:13:53", "2025-07-22 22:13:53", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753222433;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753222433;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-22 22:16:48", "2025-07-23 01:46:48", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2269", "woocommerce_cleanup_draft_orders", "complete", "2025-07-21 22:06:59", "2025-07-21 22:06:59", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753135619;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753135619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-21 22:13:53", "2025-07-22 01:43:53", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2286", "woocommerce_cleanup_draft_orders", "complete", "2025-07-25 22:29:45", "2025-07-25 22:29:45", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753482585;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753482585;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-25 22:32:37", "2025-07-26 02:02:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2273", "woocommerce_cleanup_draft_orders", "complete", "2025-07-22 22:13:53", "2025-07-22 22:13:53", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753222433;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753222433;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-22 22:16:48", "2025-07-23 01:46:48", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2271", "woocommerce_refresh_order_count_cache", "complete", "2025-07-21 12:50:52", "2025-07-21 12:50:52", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753102252;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753102252;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-21 13:00:35", "2025-07-21 16:30:35", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2233", "woocommerce_cleanup_draft_orders", "complete", "2025-07-12 20:40:39", "2025-07-12 20:40:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752352839;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752352839;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-12 20:47:13", "2025-07-13 00:17:13", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2230", "woocommerce_cleanup_draft_orders", "complete", "2025-07-11 20:22:11", "2025-07-11 20:22:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752265331;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752265331;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-11 20:40:39", "2025-07-12 00:10:39", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2222", "woocommerce_cleanup_draft_orders", "complete", "2025-07-09 19:29:01", "2025-07-09 19:29:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752089341;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752089341;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-09 20:15:10", "2025-07-09 23:45:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2229", "woocommerce_cleanup_draft_orders", "complete", "2025-07-11 20:22:11", "2025-07-11 20:22:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752265331;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752265331;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-11 20:40:39", "2025-07-12 00:10:39", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2226", "woocommerce_cleanup_draft_orders", "complete", "2025-07-10 20:15:10", "2025-07-10 20:15:10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752178510;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752178510;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-10 20:22:11", "2025-07-10 23:52:11", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2288", "woocommerce_refresh_order_count_cache", "complete", "2025-07-26 01:25:10", "2025-07-26 01:25:10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753493110;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753493110;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-26 01:26:53", "2025-07-26 04:56:53", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2285", "woocommerce_cleanup_draft_orders", "complete", "2025-07-25 22:29:45", "2025-07-25 22:29:45", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753482585;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753482585;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-25 22:32:37", "2025-07-26 02:02:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2263", "woocommerce_refresh_order_count_cache", "complete", "2025-07-19 12:06:35", "2025-07-19 12:06:35", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752926795;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752926795;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-19 12:07:17", "2025-07-19 15:37:17", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2278", "woocommerce_cleanup_draft_orders", "complete", "2025-07-23 22:16:48", "2025-07-23 22:16:48", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753309008;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753309008;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-23 22:27:12", "2025-07-24 01:57:12", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2298", "woocommerce_cleanup_draft_orders", "complete", "2025-07-28 22:37:47", "2025-07-28 22:37:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753742267;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753742267;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-28 22:37:55", "2025-07-29 02:07:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2294", "woocommerce_cleanup_draft_orders", "complete", "2025-07-27 22:37:37", "2025-07-27 22:37:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753655857;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753655857;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-27 22:37:47", "2025-07-28 02:07:47", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2311", "woocommerce_cleanup_draft_orders", "complete", "2025-07-31 22:38:12", "2025-07-31 22:38:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754001492;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754001492;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-31 22:38:21", "2025-08-01 02:08:21", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2209", "woocommerce_cleanup_draft_orders", "complete", "2025-07-06 18:36:34", "2025-07-06 18:36:34", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751826994;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751826994;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-06 19:09:17", "2025-07-06 22:39:17", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2218", "woocommerce_cleanup_draft_orders", "complete", "2025-07-08 19:10:15", "2025-07-08 19:10:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752001815;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752001815;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-08 19:29:01", "2025-07-08 22:59:01", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2211", "woocommerce_refresh_order_count_cache", "complete", "2025-07-06 06:36:34", "2025-07-06 06:36:34", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751783794;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751783794;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-06 06:37:44", "2025-07-06 10:07:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2215", "woocommerce_refresh_order_count_cache", "complete", "2025-07-07 07:09:17", "2025-07-07 07:09:17", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751872157;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751872157;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-07 07:21:46", "2025-07-07 10:51:46", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2214", "woocommerce_cleanup_draft_orders", "complete", "2025-07-07 19:09:17", "2025-07-07 19:09:17", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751915357;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751915357;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-07 19:10:15", "2025-07-07 22:40:15", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2225", "woocommerce_cleanup_draft_orders", "complete", "2025-07-10 20:15:10", "2025-07-10 20:15:10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752178510;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752178510;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-10 20:22:11", "2025-07-10 23:52:11", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2221", "woocommerce_cleanup_draft_orders", "complete", "2025-07-09 19:29:01", "2025-07-09 19:29:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752089341;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752089341;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-09 20:15:10", "2025-07-09 23:45:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2246", "woocommerce_cleanup_draft_orders", "complete", "2025-07-15 21:35:18", "2025-07-15 21:35:18", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752615318;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752615318;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-15 21:35:25", "2025-07-16 01:05:25", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2245", "woocommerce_cleanup_draft_orders", "complete", "2025-07-15 21:35:18", "2025-07-15 21:35:18", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752615318;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752615318;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-15 21:35:25", "2025-07-16 01:05:25", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2237", "woocommerce_cleanup_draft_orders", "complete", "2025-07-13 20:47:13", "2025-07-13 20:47:13", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752439633;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752439633;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-13 20:53:43", "2025-07-14 00:23:43", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2250", "woocommerce_cleanup_draft_orders", "complete", "2025-07-16 21:35:25", "2025-07-16 21:35:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752701725;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752701725;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-16 21:37:13", "2025-07-17 01:07:13", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2262", "woocommerce_cleanup_draft_orders", "complete", "2025-07-19 22:06:34", "2025-07-19 22:06:34", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752962794;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752962794;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-19 22:06:48", "2025-07-20 01:36:48", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2249", "woocommerce_cleanup_draft_orders", "complete", "2025-07-16 21:35:25", "2025-07-16 21:35:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752701725;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752701725;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-16 21:37:13", "2025-07-17 01:07:13", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2282", "woocommerce_cleanup_draft_orders", "complete", "2025-07-24 22:27:12", "2025-07-24 22:27:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753396032;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753396032;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-24 22:29:45", "2025-07-25 01:59:45", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2302", "woocommerce_cleanup_draft_orders", "complete", "2025-07-29 22:37:55", "2025-07-29 22:37:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753828675;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753828675;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-29 22:38:04", "2025-07-30 02:08:04", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2297", "woocommerce_cleanup_draft_orders", "complete", "2025-07-28 22:37:47", "2025-07-28 22:37:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753742267;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753742267;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-28 22:37:55", "2025-07-29 02:07:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2199", "woocommerce_refresh_order_count_cache", "complete", "2025-07-03 06:31:37", "2025-07-03 06:31:37", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751524297;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751524297;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-03 06:32:02", "2025-07-03 10:02:02", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2200", "woocommerce_refresh_order_count_cache", "complete", "2025-07-03 18:32:02", "2025-07-03 18:32:02", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751567522;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751567522;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-03 18:32:08", "2025-07-03 22:02:08", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2191", "woocommerce_cleanup_draft_orders", "complete", "2025-06-30 21:30:45", "2025-06-30 21:30:45", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751319045;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751319045;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-01 18:30:41", "2025-07-01 22:00:41", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2217", "woocommerce_cleanup_draft_orders", "complete", "2025-07-08 19:10:15", "2025-07-08 19:10:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752001815;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752001815;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-08 19:29:01", "2025-07-08 22:59:01", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2205", "woocommerce_cleanup_draft_orders", "complete", "2025-07-05 18:32:47", "2025-07-05 18:32:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751740367;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751740367;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-05 18:36:34", "2025-07-05 22:06:34", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2242", "woocommerce_cleanup_draft_orders", "complete", "2025-07-14 20:53:43", "2025-07-14 20:53:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752526423;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752526423;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-14 21:35:18", "2025-07-15 01:05:18", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2241", "woocommerce_cleanup_draft_orders", "complete", "2025-07-14 20:53:43", "2025-07-14 20:53:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752526423;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752526423;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-14 21:35:18", "2025-07-15 01:05:18", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2259", "woocommerce_refresh_order_count_cache", "complete", "2025-07-18 11:36:29", "2025-07-18 11:36:29", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752838589;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752838589;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-18 11:36:56", "2025-07-18 15:06:56", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2254", "woocommerce_cleanup_draft_orders", "complete", "2025-07-17 21:37:13", "2025-07-17 21:37:13", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752788233;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752788233;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-17 21:45:26", "2025-07-18 01:15:26", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2257", "woocommerce_cleanup_draft_orders", "complete", "2025-07-18 21:45:26", "2025-07-18 21:45:26", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752875126;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752875126;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-18 22:06:34", "2025-07-19 01:36:34", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2197", "woocommerce_cleanup_draft_orders", "complete", "2025-07-03 18:31:37", "2025-07-03 18:31:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751567497;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751567497;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-03 18:32:08", "2025-07-03 22:02:08", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2310", "woocommerce_cleanup_draft_orders", "complete", "2025-07-31 22:38:12", "2025-07-31 22:38:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754001492;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754001492;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-31 22:38:21", "2025-08-01 02:08:21", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2306", "woocommerce_cleanup_draft_orders", "complete", "2025-07-30 22:38:04", "2025-07-30 22:38:04", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753915084;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753915084;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-30 22:38:12", "2025-07-31 02:08:12", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2281", "woocommerce_cleanup_draft_orders", "complete", "2025-07-24 22:27:12", "2025-07-24 22:27:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753396032;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753396032;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-24 22:29:45", "2025-07-25 01:59:45", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2293", "woocommerce_cleanup_draft_orders", "complete", "2025-07-27 22:37:37", "2025-07-27 22:37:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753655857;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753655857;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-27 22:37:47", "2025-07-28 02:07:47", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2305", "woocommerce_cleanup_draft_orders", "complete", "2025-07-30 22:38:04", "2025-07-30 22:38:04", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753915084;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753915084;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-30 22:38:12", "2025-07-31 02:08:12", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2190", "woocommerce_cleanup_draft_orders", "complete", "2025-06-30 21:30:45", "2025-06-30 21:30:45", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751319045;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751319045;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-01 18:30:41", "2025-07-01 22:00:41", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2213", "woocommerce_cleanup_draft_orders", "complete", "2025-07-07 19:09:17", "2025-07-07 19:09:17", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751915357;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751915357;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-07 19:10:15", "2025-07-07 22:40:15", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2283", "woocommerce_refresh_order_count_cache", "complete", "2025-07-24 13:07:09", "2025-07-24 13:07:09", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753362429;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753362429;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-24 13:07:13", "2025-07-24 16:37:13", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2280", "woocommerce_refresh_order_count_cache", "complete", "2025-07-24 01:07:06", "2025-07-24 01:07:06", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753319226;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753319226;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-24 01:07:09", "2025-07-24 04:37:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2277", "woocommerce_cleanup_draft_orders", "complete", "2025-07-23 22:16:48", "2025-07-23 22:16:48", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753309008;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753309008;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-23 22:27:12", "2025-07-24 01:57:12", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2270", "woocommerce_cleanup_draft_orders", "complete", "2025-07-21 22:06:59", "2025-07-21 22:06:59", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753135619;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753135619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-21 22:13:53", "2025-07-22 01:43:53", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2196", "woocommerce_refresh_order_count_cache", "complete", "2025-07-02 18:30:43", "2025-07-02 18:30:43", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751481043;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751481043;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-02 18:31:37", "2025-07-02 22:01:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2195", "woocommerce_cleanup_draft_orders", "complete", "2025-07-02 18:30:41", "2025-07-02 18:30:41", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751481041;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751481041;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-02 18:31:37", "2025-07-02 22:01:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2201", "woocommerce_cleanup_draft_orders", "complete", "2025-07-04 18:32:08", "2025-07-04 18:32:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751653928;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751653928;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-04 18:32:47", "2025-07-04 22:02:47", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2253", "woocommerce_cleanup_draft_orders", "complete", "2025-07-17 21:37:13", "2025-07-17 21:37:13", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752788233;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752788233;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-17 21:45:26", "2025-07-18 01:15:26", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2255", "woocommerce_refresh_order_count_cache", "complete", "2025-07-17 11:24:28", "2025-07-17 11:24:28", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752751468;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752751468;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-17 11:36:18", "2025-07-17 15:06:18", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2256", "woocommerce_refresh_order_count_cache", "complete", "2025-07-17 23:36:18", "2025-07-17 23:36:18", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752795378;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752795378;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-17 23:36:29", "2025-07-18 03:06:29", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2252", "woocommerce_refresh_order_count_cache", "complete", "2025-07-16 23:17:06", "2025-07-16 23:17:06", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752707826;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752707826;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-16 23:24:28", "2025-07-17 02:54:28", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2258", "woocommerce_cleanup_draft_orders", "complete", "2025-07-18 21:45:26", "2025-07-18 21:45:26", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752875126;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752875126;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-18 22:06:34", "2025-07-19 01:36:34", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2260", "woocommerce_refresh_order_count_cache", "complete", "2025-07-18 23:36:56", "2025-07-18 23:36:56", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752881816;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752881816;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-19 00:06:35", "2025-07-19 03:36:35", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2261", "woocommerce_cleanup_draft_orders", "complete", "2025-07-19 22:06:34", "2025-07-19 22:06:34", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752962794;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752962794;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-19 22:06:48", "2025-07-20 01:36:48", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2264", "woocommerce_refresh_order_count_cache", "complete", "2025-07-20 00:07:17", "2025-07-20 00:07:17", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752970037;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752970037;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-20 00:36:53", "2025-07-20 04:06:53", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2265", "woocommerce_cleanup_draft_orders", "complete", "2025-07-20 22:06:48", "2025-07-20 22:06:48", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753049208;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753049208;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-20 22:06:59", "2025-07-21 01:36:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2268", "woocommerce_refresh_order_count_cache", "complete", "2025-07-21 00:38:04", "2025-07-21 00:38:04", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753058284;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753058284;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-21 00:50:52", "2025-07-21 04:20:52", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2272", "woocommerce_refresh_order_count_cache", "complete", "2025-07-22 01:00:35", "2025-07-22 01:00:35", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753146035;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753146035;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-22 01:06:55", "2025-07-22 04:36:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2279", "woocommerce_refresh_order_count_cache", "complete", "2025-07-23 13:07:01", "2025-07-23 13:07:01", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753276021;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753276021;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-23 13:07:06", "2025-07-23 16:37:06", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2275", "woocommerce_refresh_order_count_cache", "complete", "2025-07-22 13:06:55", "2025-07-22 13:06:55", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753189615;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753189615;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-22 13:07:01", "2025-07-22 16:37:01", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2291", "woocommerce_refresh_order_count_cache", "complete", "2025-07-26 13:26:53", "2025-07-26 13:26:53", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753536413;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753536413;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-26 13:29:06", "2025-07-26 16:59:06", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2287", "woocommerce_refresh_order_count_cache", "complete", "2025-07-25 13:07:18", "2025-07-25 13:07:18", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753448838;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753448838;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-25 13:25:10", "2025-07-25 16:55:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2295", "woocommerce_refresh_order_count_cache", "complete", "2025-07-27 13:33:40", "2025-07-27 13:33:40", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753623220;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753623220;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-27 13:37:43", "2025-07-27 17:07:43", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2301", "woocommerce_cleanup_draft_orders", "complete", "2025-07-29 22:37:55", "2025-07-29 22:37:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753828675;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753828675;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-07-29 22:38:04", "2025-07-30 02:08:04", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2296", "woocommerce_refresh_order_count_cache", "complete", "2025-07-28 01:37:43", "2025-07-28 01:37:43", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753666663;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753666663;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-28 01:37:45", "2025-07-28 05:07:45", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2307", "woocommerce_refresh_order_count_cache", "complete", "2025-07-30 13:38:04", "2025-07-30 13:38:04", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753882684;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753882684;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-30 13:40:29", "2025-07-30 17:10:29", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2303", "woocommerce_refresh_order_count_cache", "complete", "2025-07-29 13:37:57", "2025-07-29 13:37:57", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753796277;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753796277;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-29 13:38:01", "2025-07-29 17:08:01", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2313", "woocommerce_refresh_order_count_cache", "complete", "2025-08-01 01:51:16", "2025-08-01 01:51:16", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754013076;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754013076;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-08-01 01:59:06", "2025-08-01 05:29:06", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2312", "woocommerce_refresh_order_count_cache", "complete", "2025-07-31 13:42:44", "2025-07-31 13:42:44", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753969364;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753969364;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-31 13:51:16", "2025-07-31 17:21:16", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2193", "woocommerce_refresh_order_count_cache", "complete", "2025-07-02 06:30:41", "2025-07-02 06:30:41", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751437841;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751437841;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-02 06:30:43", "2025-07-02 10:00:43", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2192", "woocommerce_refresh_order_count_cache", "complete", "2025-06-30 13:14:59", "2025-06-30 13:14:59", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751289299;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751289299;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-01 18:30:41", "2025-07-01 22:00:41", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2204", "woocommerce_refresh_order_count_cache", "complete", "2025-07-04 18:32:12", "2025-07-04 18:32:12", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751653932;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751653932;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-04 18:32:47", "2025-07-04 22:02:47", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2208", "woocommerce_refresh_order_count_cache", "complete", "2025-07-05 18:33:29", "2025-07-05 18:33:29", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751740409;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751740409;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-05 18:36:34", "2025-07-05 22:06:34", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2207", "woocommerce_refresh_order_count_cache", "complete", "2025-07-05 06:32:47", "2025-07-05 06:32:47", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751697167;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751697167;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-05 06:33:29", "2025-07-05 10:03:29", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2212", "woocommerce_refresh_order_count_cache", "complete", "2025-07-06 18:37:44", "2025-07-06 18:37:44", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751827064;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751827064;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-06 19:09:17", "2025-07-06 22:39:17", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2216", "woocommerce_refresh_order_count_cache", "complete", "2025-07-07 19:21:46", "2025-07-07 19:21:46", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751916106;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751916106;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-07 19:36:35", "2025-07-07 23:06:35", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2219", "woocommerce_refresh_order_count_cache", "complete", "2025-07-08 07:36:35", "2025-07-08 07:36:35", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751960195;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751960195;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-08 07:49:04", "2025-07-08 11:19:04", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2220", "woocommerce_refresh_order_count_cache", "complete", "2025-07-08 19:49:04", "2025-07-08 19:49:04", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752004144;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752004144;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-08 19:52:33", "2025-07-08 23:22:33", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2223", "woocommerce_refresh_order_count_cache", "complete", "2025-07-09 07:52:33", "2025-07-09 07:52:33", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752047553;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752047553;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-09 08:01:26", "2025-07-09 11:31:26", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2224", "woocommerce_refresh_order_count_cache", "complete", "2025-07-09 20:01:26", "2025-07-09 20:01:26", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752091286;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752091286;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-09 20:15:10", "2025-07-09 23:45:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2228", "woocommerce_refresh_order_count_cache", "complete", "2025-07-10 21:03:53", "2025-07-10 21:03:53", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752181433;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752181433;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-10 21:25:34", "2025-07-11 00:55:34", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2227", "woocommerce_refresh_order_count_cache", "complete", "2025-07-10 08:15:10", "2025-07-10 08:15:10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752135310;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752135310;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-10 09:03:53", "2025-07-10 12:33:53", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2231", "woocommerce_refresh_order_count_cache", "complete", "2025-07-11 09:25:34", "2025-07-11 09:25:34", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752225934;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752225934;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-11 09:27:08", "2025-07-11 12:57:08", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2232", "woocommerce_refresh_order_count_cache", "complete", "2025-07-11 21:27:08", "2025-07-11 21:27:08", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752269228;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752269228;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-11 21:28:13", "2025-07-12 00:58:13", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2235", "woocommerce_refresh_order_count_cache", "complete", "2025-07-12 09:28:13", "2025-07-12 09:28:13", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752312493;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752312493;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-12 09:28:46", "2025-07-12 12:58:46", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2236", "woocommerce_refresh_order_count_cache", "complete", "2025-07-12 21:28:46", "2025-07-12 21:28:46", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752355726;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752355726;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-12 21:31:03", "2025-07-13 01:01:03", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2239", "woocommerce_refresh_order_count_cache", "complete", "2025-07-13 09:31:03", "2025-07-13 09:31:03", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752399063;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752399063;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-13 09:37:49", "2025-07-13 13:07:49", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2240", "woocommerce_refresh_order_count_cache", "complete", "2025-07-13 21:37:49", "2025-07-13 21:37:49", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752442669;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752442669;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-13 21:39:05", "2025-07-14 01:09:05", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2243", "woocommerce_refresh_order_count_cache", "complete", "2025-07-14 09:39:05", "2025-07-14 09:39:05", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752485945;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752485945;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-14 09:59:54", "2025-07-14 13:29:54", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2244", "woocommerce_refresh_order_count_cache", "complete", "2025-07-14 21:59:54", "2025-07-14 21:59:54", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752530394;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752530394;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-14 22:06:53", "2025-07-15 01:36:53", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2247", "woocommerce_refresh_order_count_cache", "complete", "2025-07-15 10:06:53", "2025-07-15 10:06:53", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752574013;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752574013;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-15 10:40:32", "2025-07-15 14:10:32", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2248", "woocommerce_refresh_order_count_cache", "complete", "2025-07-15 22:40:32", "2025-07-15 22:40:32", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752619232;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752619232;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-15 22:59:35", "2025-07-16 02:29:35", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2251", "woocommerce_refresh_order_count_cache", "complete", "2025-07-16 10:59:35", "2025-07-16 10:59:35", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752663575;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752663575;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-16 11:17:06", "2025-07-16 14:47:06", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2276", "woocommerce_refresh_order_count_cache", "complete", "2025-07-23 01:07:01", "2025-07-23 01:07:01", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753232821;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753232821;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-23 01:07:01", "2025-07-23 04:37:01", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2284", "woocommerce_refresh_order_count_cache", "complete", "2025-07-25 01:07:13", "2025-07-25 01:07:13", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753405633;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753405633;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-25 01:07:18", "2025-07-25 04:37:18", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2292", "woocommerce_refresh_order_count_cache", "complete", "2025-07-27 01:29:06", "2025-07-27 01:29:06", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753579746;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753579746;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-27 01:33:40", "2025-07-27 05:03:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2299", "woocommerce_refresh_order_count_cache", "complete", "2025-07-28 13:37:45", "2025-07-28 13:37:45", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753709865;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753709865;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-28 13:37:51", "2025-07-28 17:07:51", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2300", "woocommerce_refresh_order_count_cache", "complete", "2025-07-29 01:37:51", "2025-07-29 01:37:51", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753753071;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753753071;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-29 01:37:57", "2025-07-29 05:07:57", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2304", "woocommerce_refresh_order_count_cache", "complete", "2025-07-30 01:38:01", "2025-07-30 01:38:01", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753839481;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753839481;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-30 01:38:04", "2025-07-30 05:08:04", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2308", "woocommerce_refresh_order_count_cache", "complete", "2025-07-31 01:40:29", "2025-07-31 01:40:29", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753926029;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753926029;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-07-31 01:42:44", "2025-07-31 05:12:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2309", "wc-admin_import_orders", "complete", "2025-07-30 17:10:47", "2025-07-30 17:10:47", "[2963]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1753895447;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1753895447;}", "2", "1", "2025-07-30 17:10:49", "2025-07-30 20:40:49", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2314", "woocommerce_cleanup_draft_orders", "pending", "2025-08-01 22:38:21", "2025-08-01 22:38:21", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754087901;s:18:\"\0*\0first_timestamp\";i:1656546396;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754087901;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2315", "woocommerce_cleanup_draft_orders", "pending", "2025-08-01 22:38:21", "2025-08-01 22:38:21", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754087901;s:18:\"\0*\0first_timestamp\";i:1657608205;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754087901;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2317", "woocommerce_refresh_order_count_cache", "pending", "2025-08-02 02:08:28", "2025-08-02 02:08:28", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754100508;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754100508;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2316", "woocommerce_refresh_order_count_cache", "complete", "2025-08-01 13:59:06", "2025-08-01 13:59:06", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754056746;s:18:\"\0*\0first_timestamp\";i:1750017744;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754056746;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-08-01 14:08:28", "2025-08-01 17:38:28", "0", NULL, "10");

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "wc-admin-data");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "wc_update_product_default_cat");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "woocommerce-remote-inbox-engine");
INSERT INTO `wp_actionscheduler_groups` VALUES("6", "count");
INSERT INTO `wp_actionscheduler_groups` VALUES("7", "");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("6695", "2196", "عملیات با WP Cron شروع شد", "2025-07-02 18:31:37", "2025-07-02 18:31:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("6776", "2222", "عملیات با WP Cron شروع شد", "2025-07-09 20:15:10", "2025-07-09 20:15:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6728", "2206", "عملیات با WP Cron شروع شد", "2025-07-05 18:36:34", "2025-07-05 18:36:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("6743", "2212", "عملیات با WP Cron شروع شد", "2025-07-06 19:09:17", "2025-07-06 19:09:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("6670", "2190", "عملیات ایجاد شد", "2025-06-29 21:30:45", "2025-06-29 21:30:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("7032", "2306", "عملیات با WP Cron تکمیل شد", "2025-07-30 22:38:12", "2025-07-30 22:38:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("7018", "2306", "عملیات ایجاد شد", "2025-07-29 22:38:04", "2025-07-29 22:38:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("6709", "2203", "عملیات ایجاد شد", "2025-07-03 18:32:08", "2025-07-03 18:32:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("6691", "2197", "عملیات ایجاد شد", "2025-07-02 18:31:37", "2025-07-02 18:31:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("6751", "2217", "عملیات ایجاد شد", "2025-07-07 19:10:15", "2025-07-07 19:10:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("6799", "2233", "عملیات ایجاد شد", "2025-07-11 20:40:39", "2025-07-11 20:40:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("6787", "2229", "عملیات ایجاد شد", "2025-07-10 20:22:11", "2025-07-10 20:22:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("6786", "2225", "عملیات با WP Cron تکمیل شد", "2025-07-10 20:22:11", "2025-07-10 20:22:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("6802", "2234", "عملیات ایجاد شد", "2025-07-11 20:40:39", "2025-07-11 20:40:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("6887", "2260", "عملیات با WP Cron شروع شد", "2025-07-19 00:06:35", "2025-07-19 00:06:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("6835", "2245", "عملیات ایجاد شد", "2025-07-14 21:35:18", "2025-07-14 21:35:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6861", "2250", "عملیات با WP Cron تکمیل شد", "2025-07-16 21:37:13", "2025-07-16 21:37:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("6847", "2249", "عملیات ایجاد شد", "2025-07-15 21:35:25", "2025-07-15 21:35:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("6848", "2246", "عملیات با WP Cron شروع شد", "2025-07-15 21:35:25", "2025-07-15 21:35:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("6897", "2262", "عملیات با WP Cron تکمیل شد", "2025-07-19 22:06:48", "2025-07-19 22:06:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("6919", "2273", "عملیات ایجاد شد", "2025-07-21 22:13:53", "2025-07-21 22:13:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("6931", "2277", "عملیات ایجاد شد", "2025-07-22 22:16:48", "2025-07-22 22:16:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("6909", "2266", "عملیات با WP Cron تکمیل شد", "2025-07-20 22:06:59", "2025-07-20 22:06:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("6907", "2269", "عملیات ایجاد شد", "2025-07-20 22:06:59", "2025-07-20 22:06:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("6969", "2286", "عملیات با WP Cron تکمیل شد", "2025-07-25 22:32:37", "2025-07-25 22:32:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("6934", "2278", "عملیات ایجاد شد", "2025-07-22 22:16:48", "2025-07-22 22:16:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("6922", "2274", "عملیات ایجاد شد", "2025-07-21 22:13:53", "2025-07-21 22:13:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7030", "2310", "عملیات ایجاد شد", "2025-07-30 22:38:12", "2025-07-30 22:38:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("7017", "2302", "عملیات با WP Cron تکمیل شد", "2025-07-29 22:38:04", "2025-07-29 22:38:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("6703", "2201", "عملیات ایجاد شد", "2025-07-03 18:32:08", "2025-07-03 18:32:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("6690", "2194", "عملیات با WP Cron تکمیل شد", "2025-07-02 18:31:37", "2025-07-02 18:31:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("6706", "2202", "عملیات ایجاد شد", "2025-07-03 18:32:08", "2025-07-03 18:32:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("6686", "2193", "عملیات با WP Cron شروع شد", "2025-07-02 06:30:43", "2025-07-02 06:30:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("6685", "2195", "عملیات ایجاد شد", "2025-07-01 18:30:41", "2025-07-01 18:30:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6689", "2194", "عملیات با WP Cron شروع شد", "2025-07-02 18:31:37", "2025-07-02 18:31:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("6683", "2191", "عملیات با WP Cron شروع شد", "2025-07-01 18:30:41", "2025-07-01 18:30:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6704", "2198", "عملیات با WP Cron شروع شد", "2025-07-03 18:32:08", "2025-07-03 18:32:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("6718", "2206", "عملیات ایجاد شد", "2025-07-04 18:32:47", "2025-07-04 18:32:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("6754", "2218", "عملیات ایجاد شد", "2025-07-07 19:10:15", "2025-07-07 19:10:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("6740", "2210", "عملیات با WP Cron شروع شد", "2025-07-06 19:09:17", "2025-07-06 19:09:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("6766", "2222", "عملیات ایجاد شد", "2025-07-08 19:29:01", "2025-07-08 19:29:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("6765", "2218", "عملیات با WP Cron تکمیل شد", "2025-07-08 19:29:01", "2025-07-08 19:29:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("6763", "2221", "عملیات ایجاد شد", "2025-07-08 19:29:01", "2025-07-08 19:29:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("6752", "2214", "عملیات با WP Cron شروع شد", "2025-07-07 19:10:15", "2025-07-07 19:10:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("6911", "2268", "عملیات با WP Cron شروع شد", "2025-07-21 00:50:52", "2025-07-21 00:50:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("6906", "2265", "عملیات با WP Cron تکمیل شد", "2025-07-20 22:06:59", "2025-07-20 22:06:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("6885", "2258", "عملیات با WP Cron تکمیل شد", "2025-07-18 22:06:34", "2025-07-18 22:06:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("6886", "2262", "عملیات ایجاد شد", "2025-07-18 22:06:34", "2025-07-18 22:06:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("6899", "2264", "عملیات با WP Cron شروع شد", "2025-07-20 00:36:53", "2025-07-20 00:36:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("6918", "2269", "عملیات با WP Cron تکمیل شد", "2025-07-21 22:13:53", "2025-07-21 22:13:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("6979", "2293", "عملیات ایجاد شد", "2025-07-26 22:37:37", "2025-07-26 22:37:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("6980", "2290", "عملیات با WP Cron شروع شد", "2025-07-26 22:37:37", "2025-07-26 22:37:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("6991", "2297", "عملیات ایجاد شد", "2025-07-27 22:37:47", "2025-07-27 22:37:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("7005", "2298", "عملیات با WP Cron تکمیل شد", "2025-07-28 22:37:55", "2025-07-28 22:37:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("6680", "2190", "عملیات با WP Cron شروع شد", "2025-07-01 18:30:41", "2025-07-01 18:30:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6681", "2190", "عملیات با WP Cron تکمیل شد", "2025-07-01 18:30:41", "2025-07-01 18:30:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6682", "2194", "عملیات ایجاد شد", "2025-07-01 18:30:41", "2025-07-01 18:30:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6994", "2298", "عملیات ایجاد شد", "2025-07-27 22:37:47", "2025-07-27 22:37:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("6733", "2211", "عملیات ایجاد شد", "2025-07-05 18:36:34", "2025-07-05 18:36:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("6732", "2208", "عملیات با WP Cron تکمیل شد", "2025-07-05 18:36:34", "2025-07-05 18:36:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("6731", "2208", "عملیات با WP Cron شروع شد", "2025-07-05 18:36:34", "2025-07-05 18:36:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("6697", "2199", "عملیات ایجاد شد", "2025-07-02 18:31:37", "2025-07-02 18:31:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("6684", "2191", "عملیات با WP Cron تکمیل شد", "2025-07-01 18:30:41", "2025-07-01 18:30:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6705", "2198", "عملیات با WP Cron تکمیل شد", "2025-07-03 18:32:08", "2025-07-03 18:32:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("6738", "2209", "عملیات با WP Cron تکمیل شد", "2025-07-06 19:09:17", "2025-07-06 19:09:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("6730", "2210", "عملیات ایجاد شد", "2025-07-05 18:36:34", "2025-07-05 18:36:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("6749", "2213", "عملیات با WP Cron شروع شد", "2025-07-07 19:10:15", "2025-07-07 19:10:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("6789", "2226", "عملیات با WP Cron تکمیل شد", "2025-07-10 20:22:11", "2025-07-10 20:22:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("6788", "2226", "عملیات با WP Cron شروع شد", "2025-07-10 20:22:11", "2025-07-10 20:22:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("6811", "2237", "عملیات ایجاد شد", "2025-07-12 20:47:13", "2025-07-12 20:47:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("6798", "2229", "عملیات با WP Cron تکمیل شد", "2025-07-11 20:40:39", "2025-07-11 20:40:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("6860", "2250", "عملیات با WP Cron شروع شد", "2025-07-16 21:37:13", "2025-07-16 21:37:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("6875", "2256", "عملیات با WP Cron شروع شد", "2025-07-17 23:36:29", "2025-07-17 23:36:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("6873", "2254", "عملیات با WP Cron تکمیل شد", "2025-07-17 21:45:26", "2025-07-17 21:45:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("6862", "2254", "عملیات ایجاد شد", "2025-07-16 21:37:13", "2025-07-16 21:37:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("6863", "2252", "عملیات با WP Cron شروع شد", "2025-07-16 23:24:28", "2025-07-16 23:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("6864", "2252", "عملیات با WP Cron تکمیل شد", "2025-07-16 23:24:28", "2025-07-16 23:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("6865", "2255", "عملیات ایجاد شد", "2025-07-16 23:24:28", "2025-07-16 23:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("6917", "2269", "عملیات با WP Cron شروع شد", "2025-07-21 22:13:53", "2025-07-21 22:13:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("6978", "2289", "عملیات با WP Cron تکمیل شد", "2025-07-26 22:37:37", "2025-07-26 22:37:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("6966", "2285", "عملیات با WP Cron تکمیل شد", "2025-07-25 22:32:37", "2025-07-25 22:32:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7015", "2305", "عملیات ایجاد شد", "2025-07-29 22:38:04", "2025-07-29 22:38:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("6981", "2290", "عملیات با WP Cron تکمیل شد", "2025-07-26 22:37:37", "2025-07-26 22:37:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7016", "2302", "عملیات با WP Cron شروع شد", "2025-07-29 22:38:04", "2025-07-29 22:38:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("6838", "2246", "عملیات ایجاد شد", "2025-07-14 21:35:18", "2025-07-14 21:35:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6778", "2226", "عملیات ایجاد شد", "2025-07-09 20:15:10", "2025-07-09 20:15:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6777", "2222", "عملیات با WP Cron تکمیل شد", "2025-07-09 20:15:10", "2025-07-09 20:15:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6785", "2225", "عملیات با WP Cron شروع شد", "2025-07-10 20:22:11", "2025-07-10 20:22:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("6834", "2241", "عملیات با WP Cron تکمیل شد", "2025-07-14 21:35:18", "2025-07-14 21:35:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6898", "2266", "عملیات ایجاد شد", "2025-07-19 22:06:48", "2025-07-19 22:06:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("6921", "2270", "عملیات با WP Cron تکمیل شد", "2025-07-21 22:13:53", "2025-07-21 22:13:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("6946", "2282", "عملیات ایجاد شد", "2025-07-23 22:27:12", "2025-07-23 22:27:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("6955", "2285", "عملیات ایجاد شد", "2025-07-24 22:29:45", "2025-07-24 22:29:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("6753", "2214", "عملیات با WP Cron تکمیل شد", "2025-07-07 19:10:15", "2025-07-07 19:10:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("6775", "2225", "عملیات ایجاد شد", "2025-07-09 20:15:10", "2025-07-09 20:15:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6762", "2217", "عملیات با WP Cron تکمیل شد", "2025-07-08 19:29:01", "2025-07-08 19:29:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("6761", "2217", "عملیات با WP Cron شروع شد", "2025-07-08 19:29:01", "2025-07-08 19:29:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("6836", "2242", "عملیات با WP Cron شروع شد", "2025-07-14 21:35:18", "2025-07-14 21:35:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6823", "2241", "عملیات ایجاد شد", "2025-07-13 20:53:43", "2025-07-13 20:53:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("6715", "2205", "عملیات ایجاد شد", "2025-07-04 18:32:47", "2025-07-04 18:32:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("6920", "2270", "عملیات با WP Cron شروع شد", "2025-07-21 22:13:53", "2025-07-21 22:13:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("6954", "2281", "عملیات با WP Cron تکمیل شد", "2025-07-24 22:29:45", "2025-07-24 22:29:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("6933", "2274", "عملیات با WP Cron تکمیل شد", "2025-07-22 22:16:48", "2025-07-22 22:16:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("6958", "2286", "عملیات ایجاد شد", "2025-07-24 22:29:45", "2025-07-24 22:29:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("6993", "2294", "عملیات با WP Cron تکمیل شد", "2025-07-27 22:37:47", "2025-07-27 22:37:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("6992", "2294", "عملیات با WP Cron شروع شد", "2025-07-27 22:37:47", "2025-07-27 22:37:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("6673", "2191", "عملیات ایجاد شد", "2025-06-29 21:30:45", "2025-06-29 21:30:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("6822", "2237", "عملیات با WP Cron تکمیل شد", "2025-07-13 20:53:43", "2025-07-13 20:53:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("6825", "2238", "عملیات با WP Cron تکمیل شد", "2025-07-13 20:53:43", "2025-07-13 20:53:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("6826", "2242", "عملیات ایجاد شد", "2025-07-13 20:53:43", "2025-07-13 20:53:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("6827", "2240", "عملیات با WP Cron شروع شد", "2025-07-13 21:39:05", "2025-07-13 21:39:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("6679", "2193", "عملیات ایجاد شد", "2025-07-01 18:30:41", "2025-07-01 18:30:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6677", "2192", "عملیات با WP Cron شروع شد", "2025-07-01 18:30:41", "2025-07-01 18:30:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6688", "2196", "عملیات ایجاد شد", "2025-07-02 06:30:43", "2025-07-02 06:30:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("6687", "2193", "عملیات با WP Cron تکمیل شد", "2025-07-02 06:30:43", "2025-07-02 06:30:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("6694", "2198", "عملیات ایجاد شد", "2025-07-02 18:31:37", "2025-07-02 18:31:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("6693", "2195", "عملیات با WP Cron تکمیل شد", "2025-07-02 18:31:37", "2025-07-02 18:31:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("6702", "2197", "عملیات با WP Cron تکمیل شد", "2025-07-03 18:32:08", "2025-07-03 18:32:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("6850", "2250", "عملیات ایجاد شد", "2025-07-15 21:35:25", "2025-07-15 21:35:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("6821", "2237", "عملیات با WP Cron شروع شد", "2025-07-13 20:53:43", "2025-07-13 20:53:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("6872", "2254", "عملیات با WP Cron شروع شد", "2025-07-17 21:45:26", "2025-07-17 21:45:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("6884", "2258", "عملیات با WP Cron شروع شد", "2025-07-18 22:06:34", "2025-07-18 22:06:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("6896", "2262", "عملیات با WP Cron شروع شد", "2025-07-19 22:06:48", "2025-07-19 22:06:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("6943", "2281", "عملیات ایجاد شد", "2025-07-23 22:27:12", "2025-07-23 22:27:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("6930", "2273", "عملیات با WP Cron تکمیل شد", "2025-07-22 22:16:48", "2025-07-22 22:16:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("6945", "2278", "عملیات با WP Cron تکمیل شد", "2025-07-23 22:27:12", "2025-07-23 22:27:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("6944", "2278", "عملیات با WP Cron شروع شد", "2025-07-23 22:27:12", "2025-07-23 22:27:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("6957", "2282", "عملیات با WP Cron تکمیل شد", "2025-07-24 22:29:45", "2025-07-24 22:29:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("6956", "2282", "عملیات با WP Cron شروع شد", "2025-07-24 22:29:45", "2025-07-24 22:29:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("6968", "2286", "عملیات با WP Cron شروع شد", "2025-07-25 22:32:37", "2025-07-25 22:32:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("6965", "2285", "عملیات با WP Cron شروع شد", "2025-07-25 22:32:37", "2025-07-25 22:32:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("6692", "2195", "عملیات با WP Cron شروع شد", "2025-07-02 18:31:37", "2025-07-02 18:31:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("6678", "2192", "عملیات با WP Cron تکمیل شد", "2025-07-01 18:30:41", "2025-07-01 18:30:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6708", "2200", "عملیات با WP Cron تکمیل شد", "2025-07-03 18:32:08", "2025-07-03 18:32:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("6858", "2249", "عملیات با WP Cron تکمیل شد", "2025-07-16 21:37:13", "2025-07-16 21:37:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("6859", "2253", "عملیات ایجاد شد", "2025-07-16 21:37:13", "2025-07-16 21:37:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("6903", "2267", "عملیات با WP Cron تکمیل شد", "2025-07-20 12:38:04", "2025-07-20 12:38:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("6874", "2258", "عملیات ایجاد شد", "2025-07-17 21:45:26", "2025-07-17 21:45:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("6967", "2289", "عملیات ایجاد شد", "2025-07-25 22:32:37", "2025-07-25 22:32:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("6774", "2221", "عملیات با WP Cron تکمیل شد", "2025-07-09 20:15:10", "2025-07-09 20:15:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6773", "2221", "عملیات با WP Cron شروع شد", "2025-07-09 20:15:10", "2025-07-09 20:15:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6932", "2274", "عملیات با WP Cron شروع شد", "2025-07-22 22:16:48", "2025-07-22 22:16:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("6910", "2270", "عملیات ایجاد شد", "2025-07-20 22:06:59", "2025-07-20 22:06:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("6742", "2214", "عملیات ایجاد شد", "2025-07-06 19:09:17", "2025-07-06 19:09:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("6741", "2210", "عملیات با WP Cron تکمیل شد", "2025-07-06 19:09:17", "2025-07-06 19:09:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("6737", "2209", "عملیات با WP Cron شروع شد", "2025-07-06 19:09:17", "2025-07-06 19:09:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("6750", "2213", "عملیات با WP Cron تکمیل شد", "2025-07-07 19:10:15", "2025-07-07 19:10:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("6701", "2197", "عملیات با WP Cron شروع شد", "2025-07-03 18:32:08", "2025-07-03 18:32:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("6717", "2202", "عملیات با WP Cron تکمیل شد", "2025-07-04 18:32:47", "2025-07-04 18:32:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("6716", "2202", "عملیات با WP Cron شروع شد", "2025-07-04 18:32:47", "2025-07-04 18:32:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("6729", "2206", "عملیات با WP Cron تکمیل شد", "2025-07-05 18:36:34", "2025-07-05 18:36:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("6714", "2201", "عملیات با WP Cron تکمیل شد", "2025-07-04 18:32:47", "2025-07-04 18:32:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("6713", "2201", "عملیات با WP Cron شروع شد", "2025-07-04 18:32:47", "2025-07-04 18:32:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("6726", "2205", "عملیات با WP Cron تکمیل شد", "2025-07-05 18:36:34", "2025-07-05 18:36:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("6744", "2212", "عملیات با WP Cron تکمیل شد", "2025-07-06 19:09:17", "2025-07-06 19:09:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("6711", "2203", "عملیات با WP Cron تکمیل شد", "2025-07-04 06:32:12", "2025-07-04 06:32:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("7003", "2301", "عملیات ایجاد شد", "2025-07-28 22:37:55", "2025-07-28 22:37:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("7029", "2305", "عملیات با WP Cron تکمیل شد", "2025-07-30 22:38:12", "2025-07-30 22:38:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("6699", "2199", "عملیات با WP Cron تکمیل شد", "2025-07-03 06:32:02", "2025-07-03 06:32:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("6700", "2200", "عملیات ایجاد شد", "2025-07-03 06:32:02", "2025-07-03 06:32:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("6710", "2203", "عملیات با WP Cron شروع شد", "2025-07-04 06:32:12", "2025-07-04 06:32:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("6810", "2233", "عملیات با WP Cron تکمیل شد", "2025-07-12 20:47:13", "2025-07-12 20:47:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("6725", "2205", "عملیات با WP Cron شروع شد", "2025-07-05 18:36:34", "2025-07-05 18:36:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("6739", "2213", "عملیات ایجاد شد", "2025-07-06 19:09:17", "2025-07-06 19:09:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("7004", "2298", "عملیات با WP Cron شروع شد", "2025-07-28 22:37:55", "2025-07-28 22:37:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("7002", "2297", "عملیات با WP Cron تکمیل شد", "2025-07-28 22:37:55", "2025-07-28 22:37:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("6908", "2266", "عملیات با WP Cron شروع شد", "2025-07-20 22:06:59", "2025-07-20 22:06:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("6953", "2281", "عملیات با WP Cron شروع شد", "2025-07-24 22:29:45", "2025-07-24 22:29:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("7014", "2301", "عملیات با WP Cron تکمیل شد", "2025-07-29 22:38:04", "2025-07-29 22:38:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("6814", "2238", "عملیات ایجاد شد", "2025-07-12 20:47:13", "2025-07-12 20:47:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("6800", "2230", "عملیات با WP Cron شروع شد", "2025-07-11 20:40:39", "2025-07-11 20:40:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("6824", "2238", "عملیات با WP Cron شروع شد", "2025-07-13 20:53:43", "2025-07-13 20:53:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("6809", "2233", "عملیات با WP Cron شروع شد", "2025-07-12 20:47:13", "2025-07-12 20:47:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("6764", "2218", "عملیات با WP Cron شروع شد", "2025-07-08 19:29:01", "2025-07-08 19:29:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("6797", "2229", "عملیات با WP Cron شروع شد", "2025-07-11 20:40:39", "2025-07-11 20:40:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("6812", "2234", "عملیات با WP Cron شروع شد", "2025-07-12 20:47:13", "2025-07-12 20:47:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("6929", "2273", "عملیات با WP Cron شروع شد", "2025-07-22 22:16:48", "2025-07-22 22:16:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("6698", "2199", "عملیات با WP Cron شروع شد", "2025-07-03 06:32:02", "2025-07-03 06:32:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("7001", "2297", "عملیات با WP Cron شروع شد", "2025-07-28 22:37:55", "2025-07-28 22:37:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("7031", "2306", "عملیات با WP Cron شروع شد", "2025-07-30 22:38:12", "2025-07-30 22:38:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("6696", "2196", "عملیات با WP Cron تکمیل شد", "2025-07-02 18:31:37", "2025-07-02 18:31:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7028", "2305", "عملیات با WP Cron شروع شد", "2025-07-30 22:38:12", "2025-07-30 22:38:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("6813", "2234", "عملیات با WP Cron تکمیل شد", "2025-07-12 20:47:13", "2025-07-12 20:47:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("6727", "2209", "عملیات ایجاد شد", "2025-07-05 18:36:34", "2025-07-05 18:36:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("6707", "2200", "عملیات با WP Cron شروع شد", "2025-07-03 18:32:08", "2025-07-03 18:32:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("6801", "2230", "عملیات با WP Cron تکمیل شد", "2025-07-11 20:40:39", "2025-07-11 20:40:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("6837", "2242", "عملیات با WP Cron تکمیل شد", "2025-07-14 21:35:18", "2025-07-14 21:35:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6849", "2246", "عملیات با WP Cron تکمیل شد", "2025-07-15 21:35:25", "2025-07-15 21:35:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("6833", "2241", "عملیات با WP Cron شروع شد", "2025-07-14 21:35:18", "2025-07-14 21:35:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6846", "2245", "عملیات با WP Cron تکمیل شد", "2025-07-15 21:35:25", "2025-07-15 21:35:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("6845", "2245", "عملیات با WP Cron شروع شد", "2025-07-15 21:35:25", "2025-07-15 21:35:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("6990", "2293", "عملیات با WP Cron تکمیل شد", "2025-07-27 22:37:47", "2025-07-27 22:37:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("6989", "2293", "عملیات با WP Cron شروع شد", "2025-07-27 22:37:47", "2025-07-27 22:37:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("6977", "2289", "عملیات با WP Cron شروع شد", "2025-07-26 22:37:37", "2025-07-26 22:37:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("6942", "2277", "عملیات با WP Cron تکمیل شد", "2025-07-23 22:27:12", "2025-07-23 22:27:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("6941", "2277", "عملیات با WP Cron شروع شد", "2025-07-23 22:27:12", "2025-07-23 22:27:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("7013", "2301", "عملیات با WP Cron شروع شد", "2025-07-29 22:38:04", "2025-07-29 22:38:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("6856", "2252", "عملیات ایجاد شد", "2025-07-16 11:17:06", "2025-07-16 11:17:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("6855", "2251", "عملیات با WP Cron تکمیل شد", "2025-07-16 11:17:06", "2025-07-16 11:17:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("6854", "2251", "عملیات با WP Cron شروع شد", "2025-07-16 11:17:06", "2025-07-16 11:17:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("6857", "2249", "عملیات با WP Cron شروع شد", "2025-07-16 21:37:13", "2025-07-16 21:37:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("6868", "2256", "عملیات ایجاد شد", "2025-07-17 11:36:18", "2025-07-17 11:36:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6867", "2255", "عملیات با WP Cron تکمیل شد", "2025-07-17 11:36:18", "2025-07-17 11:36:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6866", "2255", "عملیات با WP Cron شروع شد", "2025-07-17 11:36:18", "2025-07-17 11:36:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6871", "2257", "عملیات ایجاد شد", "2025-07-17 21:45:26", "2025-07-17 21:45:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("6870", "2253", "عملیات با WP Cron تکمیل شد", "2025-07-17 21:45:26", "2025-07-17 21:45:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("6869", "2253", "عملیات با WP Cron شروع شد", "2025-07-17 21:45:26", "2025-07-17 21:45:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("6880", "2260", "عملیات ایجاد شد", "2025-07-18 11:36:56", "2025-07-18 11:36:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("6879", "2259", "عملیات با WP Cron تکمیل شد", "2025-07-18 11:36:56", "2025-07-18 11:36:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("6878", "2259", "عملیات با WP Cron شروع شد", "2025-07-18 11:36:56", "2025-07-18 11:36:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("6883", "2261", "عملیات ایجاد شد", "2025-07-18 22:06:34", "2025-07-18 22:06:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("6882", "2257", "عملیات با WP Cron تکمیل شد", "2025-07-18 22:06:34", "2025-07-18 22:06:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("6881", "2257", "عملیات با WP Cron شروع شد", "2025-07-18 22:06:34", "2025-07-18 22:06:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("6892", "2264", "عملیات ایجاد شد", "2025-07-19 12:07:17", "2025-07-19 12:07:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("6891", "2263", "عملیات با WP Cron تکمیل شد", "2025-07-19 12:07:17", "2025-07-19 12:07:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("6890", "2263", "عملیات با WP Cron شروع شد", "2025-07-19 12:07:17", "2025-07-19 12:07:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("6895", "2265", "عملیات ایجاد شد", "2025-07-19 22:06:48", "2025-07-19 22:06:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("6894", "2261", "عملیات با WP Cron تکمیل شد", "2025-07-19 22:06:48", "2025-07-19 22:06:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("6893", "2261", "عملیات با WP Cron شروع شد", "2025-07-19 22:06:48", "2025-07-19 22:06:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("6902", "2267", "عملیات با WP Cron شروع شد", "2025-07-20 12:38:04", "2025-07-20 12:38:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("6905", "2265", "عملیات با WP Cron شروع شد", "2025-07-20 22:06:59", "2025-07-20 22:06:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("6916", "2272", "عملیات ایجاد شد", "2025-07-21 13:00:35", "2025-07-21 13:00:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("6915", "2271", "عملیات با WP Cron تکمیل شد", "2025-07-21 13:00:35", "2025-07-21 13:00:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("6914", "2271", "عملیات با WP Cron شروع شد", "2025-07-21 13:00:35", "2025-07-21 13:00:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("6925", "2275", "عملیات ایجاد شد", "2025-07-22 01:06:55", "2025-07-22 01:06:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("6924", "2272", "عملیات با WP Cron تکمیل شد", "2025-07-22 01:06:55", "2025-07-22 01:06:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("6923", "2272", "عملیات با WP Cron شروع شد", "2025-07-22 01:06:55", "2025-07-22 01:06:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("6928", "2276", "عملیات ایجاد شد", "2025-07-22 13:07:01", "2025-07-22 13:07:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("6927", "2275", "عملیات با WP Cron تکمیل شد", "2025-07-22 13:07:01", "2025-07-22 13:07:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("6926", "2275", "عملیات با WP Cron شروع شد", "2025-07-22 13:07:01", "2025-07-22 13:07:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("6937", "2279", "عملیات ایجاد شد", "2025-07-23 01:07:01", "2025-07-23 01:07:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("6936", "2276", "عملیات با WP Cron تکمیل شد", "2025-07-23 01:07:01", "2025-07-23 01:07:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("6935", "2276", "عملیات با WP Cron شروع شد", "2025-07-23 01:07:01", "2025-07-23 01:07:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("6940", "2280", "عملیات ایجاد شد", "2025-07-23 13:07:06", "2025-07-23 13:07:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("6939", "2279", "عملیات با WP Cron تکمیل شد", "2025-07-23 13:07:06", "2025-07-23 13:07:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("6938", "2279", "عملیات با WP Cron شروع شد", "2025-07-23 13:07:06", "2025-07-23 13:07:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("6949", "2283", "عملیات ایجاد شد", "2025-07-24 01:07:09", "2025-07-24 01:07:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6948", "2280", "عملیات با WP Cron تکمیل شد", "2025-07-24 01:07:09", "2025-07-24 01:07:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6947", "2280", "عملیات با WP Cron شروع شد", "2025-07-24 01:07:09", "2025-07-24 01:07:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6952", "2284", "عملیات ایجاد شد", "2025-07-24 13:07:13", "2025-07-24 13:07:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("6951", "2283", "عملیات با WP Cron تکمیل شد", "2025-07-24 13:07:13", "2025-07-24 13:07:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("6950", "2283", "عملیات با WP Cron شروع شد", "2025-07-24 13:07:13", "2025-07-24 13:07:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("6961", "2287", "عملیات ایجاد شد", "2025-07-25 01:07:18", "2025-07-25 01:07:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6960", "2284", "عملیات با WP Cron تکمیل شد", "2025-07-25 01:07:18", "2025-07-25 01:07:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6959", "2284", "عملیات با WP Cron شروع شد", "2025-07-25 01:07:18", "2025-07-25 01:07:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6964", "2288", "عملیات ایجاد شد", "2025-07-25 13:25:10", "2025-07-25 13:25:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6963", "2287", "عملیات با WP Cron تکمیل شد", "2025-07-25 13:25:10", "2025-07-25 13:25:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6962", "2287", "عملیات با WP Cron شروع شد", "2025-07-25 13:25:10", "2025-07-25 13:25:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6973", "2291", "عملیات ایجاد شد", "2025-07-26 01:26:53", "2025-07-26 01:26:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("6972", "2288", "عملیات با WP Cron تکمیل شد", "2025-07-26 01:26:53", "2025-07-26 01:26:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("6971", "2288", "عملیات با WP Cron شروع شد", "2025-07-26 01:26:53", "2025-07-26 01:26:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("6976", "2292", "عملیات ایجاد شد", "2025-07-26 13:29:06", "2025-07-26 13:29:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("6975", "2291", "عملیات با WP Cron تکمیل شد", "2025-07-26 13:29:06", "2025-07-26 13:29:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("6974", "2291", "عملیات با WP Cron شروع شد", "2025-07-26 13:29:06", "2025-07-26 13:29:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("6985", "2295", "عملیات ایجاد شد", "2025-07-27 01:33:40", "2025-07-27 01:33:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("6984", "2292", "عملیات با WP Cron تکمیل شد", "2025-07-27 01:33:40", "2025-07-27 01:33:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("6983", "2292", "عملیات با WP Cron شروع شد", "2025-07-27 01:33:40", "2025-07-27 01:33:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("6988", "2296", "عملیات ایجاد شد", "2025-07-27 13:37:43", "2025-07-27 13:37:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("6987", "2295", "عملیات با WP Cron تکمیل شد", "2025-07-27 13:37:43", "2025-07-27 13:37:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("6986", "2295", "عملیات با WP Cron شروع شد", "2025-07-27 13:37:43", "2025-07-27 13:37:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("6997", "2299", "عملیات ایجاد شد", "2025-07-28 01:37:45", "2025-07-28 01:37:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("6996", "2296", "عملیات با WP Cron تکمیل شد", "2025-07-28 01:37:45", "2025-07-28 01:37:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("6995", "2296", "عملیات با WP Cron شروع شد", "2025-07-28 01:37:45", "2025-07-28 01:37:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("7000", "2300", "عملیات ایجاد شد", "2025-07-28 13:37:51", "2025-07-28 13:37:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("6999", "2299", "عملیات با WP Cron تکمیل شد", "2025-07-28 13:37:51", "2025-07-28 13:37:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("6998", "2299", "عملیات با WP Cron شروع شد", "2025-07-28 13:37:51", "2025-07-28 13:37:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("7009", "2303", "عملیات ایجاد شد", "2025-07-29 01:37:57", "2025-07-29 01:37:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("7008", "2300", "عملیات با WP Cron تکمیل شد", "2025-07-29 01:37:57", "2025-07-29 01:37:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("7007", "2300", "عملیات با WP Cron شروع شد", "2025-07-29 01:37:57", "2025-07-29 01:37:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("7012", "2304", "عملیات ایجاد شد", "2025-07-29 13:38:01", "2025-07-29 13:38:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7011", "2303", "عملیات با WP Cron تکمیل شد", "2025-07-29 13:38:01", "2025-07-29 13:38:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7010", "2303", "عملیات با WP Cron شروع شد", "2025-07-29 13:38:01", "2025-07-29 13:38:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7021", "2307", "عملیات ایجاد شد", "2025-07-30 01:38:04", "2025-07-30 01:38:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7020", "2304", "عملیات با WP Cron تکمیل شد", "2025-07-30 01:38:04", "2025-07-30 01:38:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7019", "2304", "عملیات با WP Cron شروع شد", "2025-07-30 01:38:04", "2025-07-30 01:38:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7024", "2308", "عملیات ایجاد شد", "2025-07-30 13:40:29", "2025-07-30 13:40:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("7023", "2307", "عملیات با WP Cron تکمیل شد", "2025-07-30 13:40:29", "2025-07-30 13:40:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("7022", "2307", "عملیات با WP Cron شروع شد", "2025-07-30 13:40:29", "2025-07-30 13:40:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("7036", "2312", "عملیات ایجاد شد", "2025-07-31 01:42:44", "2025-07-31 01:42:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("7035", "2308", "عملیات با WP Cron تکمیل شد", "2025-07-31 01:42:44", "2025-07-31 01:42:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("7034", "2308", "عملیات با WP Cron شروع شد", "2025-07-31 01:42:44", "2025-07-31 01:42:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6676", "2192", "عملیات ایجاد شد", "2025-06-30 01:14:59", "2025-06-30 01:14:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("6712", "2204", "عملیات ایجاد شد", "2025-07-04 06:32:12", "2025-07-04 06:32:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("6719", "2204", "عملیات با WP Cron شروع شد", "2025-07-04 18:32:47", "2025-07-04 18:32:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("6720", "2204", "عملیات با WP Cron تکمیل شد", "2025-07-04 18:32:47", "2025-07-04 18:32:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("6721", "2207", "عملیات ایجاد شد", "2025-07-04 18:32:47", "2025-07-04 18:32:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("6722", "2207", "عملیات با WP Cron شروع شد", "2025-07-05 06:33:29", "2025-07-05 06:33:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("6723", "2207", "عملیات با WP Cron تکمیل شد", "2025-07-05 06:33:29", "2025-07-05 06:33:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("6724", "2208", "عملیات ایجاد شد", "2025-07-05 06:33:29", "2025-07-05 06:33:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("6734", "2211", "عملیات با WP Cron شروع شد", "2025-07-06 06:37:44", "2025-07-06 06:37:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6735", "2211", "عملیات با WP Cron تکمیل شد", "2025-07-06 06:37:44", "2025-07-06 06:37:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6736", "2212", "عملیات ایجاد شد", "2025-07-06 06:37:44", "2025-07-06 06:37:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6745", "2215", "عملیات ایجاد شد", "2025-07-06 19:09:17", "2025-07-06 19:09:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("6746", "2215", "عملیات با WP Cron شروع شد", "2025-07-07 07:21:46", "2025-07-07 07:21:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("6747", "2215", "عملیات با WP Cron تکمیل شد", "2025-07-07 07:21:46", "2025-07-07 07:21:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("6748", "2216", "عملیات ایجاد شد", "2025-07-07 07:21:46", "2025-07-07 07:21:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("6755", "2216", "عملیات با WP Cron شروع شد", "2025-07-07 19:36:35", "2025-07-07 19:36:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("6756", "2216", "عملیات با WP Cron تکمیل شد", "2025-07-07 19:36:35", "2025-07-07 19:36:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("6757", "2219", "عملیات ایجاد شد", "2025-07-07 19:36:35", "2025-07-07 19:36:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("6758", "2219", "عملیات با WP Cron شروع شد", "2025-07-08 07:49:04", "2025-07-08 07:49:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("6759", "2219", "عملیات با WP Cron تکمیل شد", "2025-07-08 07:49:04", "2025-07-08 07:49:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("6760", "2220", "عملیات ایجاد شد", "2025-07-08 07:49:04", "2025-07-08 07:49:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("6767", "2220", "عملیات با WP Cron شروع شد", "2025-07-08 19:52:33", "2025-07-08 19:52:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("6768", "2220", "عملیات با WP Cron تکمیل شد", "2025-07-08 19:52:33", "2025-07-08 19:52:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("6769", "2223", "عملیات ایجاد شد", "2025-07-08 19:52:33", "2025-07-08 19:52:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("6770", "2223", "عملیات با WP Cron شروع شد", "2025-07-09 08:01:26", "2025-07-09 08:01:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("6771", "2223", "عملیات با WP Cron تکمیل شد", "2025-07-09 08:01:26", "2025-07-09 08:01:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("6772", "2224", "عملیات ایجاد شد", "2025-07-09 08:01:26", "2025-07-09 08:01:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("6779", "2224", "عملیات با WP Cron شروع شد", "2025-07-09 20:15:10", "2025-07-09 20:15:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6780", "2224", "عملیات با WP Cron تکمیل شد", "2025-07-09 20:15:10", "2025-07-09 20:15:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6781", "2227", "عملیات ایجاد شد", "2025-07-09 20:15:10", "2025-07-09 20:15:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6782", "2227", "عملیات با WP Cron شروع شد", "2025-07-10 09:03:53", "2025-07-10 09:03:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("6783", "2227", "عملیات با WP Cron تکمیل شد", "2025-07-10 09:03:53", "2025-07-10 09:03:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("6784", "2228", "عملیات ایجاد شد", "2025-07-10 09:03:53", "2025-07-10 09:03:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("6790", "2230", "عملیات ایجاد شد", "2025-07-10 20:22:11", "2025-07-10 20:22:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("6791", "2228", "عملیات با WP Cron شروع شد", "2025-07-10 21:25:34", "2025-07-10 21:25:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("6792", "2228", "عملیات با WP Cron تکمیل شد", "2025-07-10 21:25:34", "2025-07-10 21:25:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("6793", "2231", "عملیات ایجاد شد", "2025-07-10 21:25:34", "2025-07-10 21:25:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("6794", "2231", "عملیات با WP Cron شروع شد", "2025-07-11 09:27:08", "2025-07-11 09:27:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("6795", "2231", "عملیات با WP Cron تکمیل شد", "2025-07-11 09:27:08", "2025-07-11 09:27:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("6796", "2232", "عملیات ایجاد شد", "2025-07-11 09:27:08", "2025-07-11 09:27:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("6803", "2232", "عملیات با WP Cron شروع شد", "2025-07-11 21:28:13", "2025-07-11 21:28:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("6804", "2232", "عملیات با WP Cron تکمیل شد", "2025-07-11 21:28:13", "2025-07-11 21:28:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("6805", "2235", "عملیات ایجاد شد", "2025-07-11 21:28:13", "2025-07-11 21:28:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("6806", "2235", "عملیات با WP Cron شروع شد", "2025-07-12 09:28:46", "2025-07-12 09:28:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("6807", "2235", "عملیات با WP Cron تکمیل شد", "2025-07-12 09:28:46", "2025-07-12 09:28:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("6808", "2236", "عملیات ایجاد شد", "2025-07-12 09:28:46", "2025-07-12 09:28:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("6815", "2236", "عملیات با WP Cron شروع شد", "2025-07-12 21:31:03", "2025-07-12 21:31:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("6816", "2236", "عملیات با WP Cron تکمیل شد", "2025-07-12 21:31:03", "2025-07-12 21:31:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("6817", "2239", "عملیات ایجاد شد", "2025-07-12 21:31:03", "2025-07-12 21:31:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("6818", "2239", "عملیات با WP Cron شروع شد", "2025-07-13 09:37:49", "2025-07-13 09:37:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("6819", "2239", "عملیات با WP Cron تکمیل شد", "2025-07-13 09:37:49", "2025-07-13 09:37:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("6820", "2240", "عملیات ایجاد شد", "2025-07-13 09:37:49", "2025-07-13 09:37:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("6828", "2240", "عملیات با WP Cron تکمیل شد", "2025-07-13 21:39:05", "2025-07-13 21:39:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("6829", "2243", "عملیات ایجاد شد", "2025-07-13 21:39:05", "2025-07-13 21:39:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("6830", "2243", "عملیات با WP Cron شروع شد", "2025-07-14 09:59:54", "2025-07-14 09:59:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("6831", "2243", "عملیات با WP Cron تکمیل شد", "2025-07-14 09:59:54", "2025-07-14 09:59:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("6832", "2244", "عملیات ایجاد شد", "2025-07-14 09:59:54", "2025-07-14 09:59:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("6839", "2244", "عملیات با WP Cron شروع شد", "2025-07-14 22:06:53", "2025-07-14 22:06:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("6840", "2244", "عملیات با WP Cron تکمیل شد", "2025-07-14 22:06:53", "2025-07-14 22:06:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("6841", "2247", "عملیات ایجاد شد", "2025-07-14 22:06:53", "2025-07-14 22:06:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("6842", "2247", "عملیات با WP Cron شروع شد", "2025-07-15 10:40:32", "2025-07-15 10:40:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("6843", "2247", "عملیات با WP Cron تکمیل شد", "2025-07-15 10:40:32", "2025-07-15 10:40:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("6844", "2248", "عملیات ایجاد شد", "2025-07-15 10:40:32", "2025-07-15 10:40:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("6851", "2248", "عملیات با WP Cron شروع شد", "2025-07-15 22:59:35", "2025-07-15 22:59:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("6852", "2248", "عملیات با WP Cron تکمیل شد", "2025-07-15 22:59:35", "2025-07-15 22:59:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("6853", "2251", "عملیات ایجاد شد", "2025-07-15 22:59:35", "2025-07-15 22:59:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("6876", "2256", "عملیات با WP Cron تکمیل شد", "2025-07-17 23:36:29", "2025-07-17 23:36:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("6877", "2259", "عملیات ایجاد شد", "2025-07-17 23:36:29", "2025-07-17 23:36:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("6888", "2260", "عملیات با WP Cron تکمیل شد", "2025-07-19 00:06:35", "2025-07-19 00:06:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("6889", "2263", "عملیات ایجاد شد", "2025-07-19 00:06:35", "2025-07-19 00:06:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("6900", "2264", "عملیات با WP Cron تکمیل شد", "2025-07-20 00:36:53", "2025-07-20 00:36:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("6901", "2267", "عملیات ایجاد شد", "2025-07-20 00:36:53", "2025-07-20 00:36:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("6904", "2268", "عملیات ایجاد شد", "2025-07-20 12:38:04", "2025-07-20 12:38:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("6912", "2268", "عملیات با WP Cron تکمیل شد", "2025-07-21 00:50:52", "2025-07-21 00:50:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("6913", "2271", "عملیات ایجاد شد", "2025-07-21 00:50:52", "2025-07-21 00:50:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("6970", "2290", "عملیات ایجاد شد", "2025-07-25 22:32:37", "2025-07-25 22:32:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("6982", "2294", "عملیات ایجاد شد", "2025-07-26 22:37:37", "2025-07-26 22:37:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7006", "2302", "عملیات ایجاد شد", "2025-07-28 22:37:55", "2025-07-28 22:37:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("7025", "2309", "عملیات ایجاد شد", "2025-07-30 17:10:42", "2025-07-30 17:10:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("7026", "2309", "عملیات با WP Cron شروع شد", "2025-07-30 17:10:49", "2025-07-30 17:10:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("7027", "2309", "عملیات با WP Cron تکمیل شد", "2025-07-30 17:10:49", "2025-07-30 17:10:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("7033", "2311", "عملیات ایجاد شد", "2025-07-30 22:38:12", "2025-07-30 22:38:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("7037", "2312", "عملیات با WP Cron شروع شد", "2025-07-31 13:51:16", "2025-07-31 13:51:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7038", "2312", "عملیات با WP Cron تکمیل شد", "2025-07-31 13:51:16", "2025-07-31 13:51:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7039", "2313", "عملیات ایجاد شد", "2025-07-31 13:51:16", "2025-07-31 13:51:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7040", "2310", "عملیات با WP Cron شروع شد", "2025-07-31 22:38:21", "2025-07-31 22:38:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7041", "2310", "عملیات با WP Cron تکمیل شد", "2025-07-31 22:38:21", "2025-07-31 22:38:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7042", "2314", "عملیات ایجاد شد", "2025-07-31 22:38:21", "2025-07-31 22:38:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7043", "2311", "عملیات با WP Cron شروع شد", "2025-07-31 22:38:21", "2025-07-31 22:38:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7044", "2311", "عملیات با WP Cron تکمیل شد", "2025-07-31 22:38:21", "2025-07-31 22:38:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7045", "2315", "عملیات ایجاد شد", "2025-07-31 22:38:21", "2025-07-31 22:38:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7046", "2313", "عملیات با WP Cron شروع شد", "2025-08-01 01:59:06", "2025-08-01 01:59:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7047", "2313", "عملیات با WP Cron تکمیل شد", "2025-08-01 01:59:06", "2025-08-01 01:59:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7048", "2316", "عملیات ایجاد شد", "2025-08-01 01:59:06", "2025-08-01 01:59:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7049", "2316", "عملیات با WP Cron شروع شد", "2025-08-01 14:08:28", "2025-08-01 14:08:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("7050", "2316", "عملیات با WP Cron تکمیل شد", "2025-08-01 14:08:28", "2025-08-01 14:08:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("7051", "2317", "عملیات ایجاد شد", "2025-08-01 14:08:28", "2025-08-01 14:08:28");

/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES("147", "22", "rating", "4");
INSERT INTO `wp_commentmeta` VALUES("148", "22", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("149", "22", "oki", "3");
INSERT INTO `wp_commentmeta` VALUES("150", "22", "65g", "3");
INSERT INTO `wp_commentmeta` VALUES("151", "22", "rate3", "3");
INSERT INTO `wp_commentmeta` VALUES("152", "22", "tow0title", "3");
INSERT INTO `wp_commentmeta` VALUES("153", "22", "recommend", "recommended");
INSERT INTO `wp_commentmeta` VALUES("154", "22", "comment-title", "کیفیت عالی");
INSERT INTO `wp_commentmeta` VALUES("155", "22", "advantages", "a:1:{i:0;s:15:\"با کیفیت\";}");
INSERT INTO `wp_commentmeta` VALUES("156", "22", "disadvantage", "a:1:{i:0;s:33:\"نامناسب برای هر جا\";}");
INSERT INTO `wp_commentmeta` VALUES("191", "75", "rating", "3");
INSERT INTO `wp_commentmeta` VALUES("192", "75", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("193", "75", "Quality_rate", "4");
INSERT INTO `wp_commentmeta` VALUES("194", "75", "price_rate", "4");
INSERT INTO `wp_commentmeta` VALUES("195", "75", "Property_rate", "4");
INSERT INTO `wp_commentmeta` VALUES("196", "75", "ease_rate", "3");
INSERT INTO `wp_commentmeta` VALUES("197", "75", "comment-title", "اققبافقب");
INSERT INTO `wp_commentmeta` VALUES("198", "78", "rating", "3");
INSERT INTO `wp_commentmeta` VALUES("199", "78", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("200", "78", "Quality_rate", "3");
INSERT INTO `wp_commentmeta` VALUES("201", "78", "price_rate", "3");
INSERT INTO `wp_commentmeta` VALUES("202", "78", "Property_rate", "2");
INSERT INTO `wp_commentmeta` VALUES("203", "78", "ease_rate", "3");
INSERT INTO `wp_commentmeta` VALUES("204", "78", "comment-title", "آن کنت");
INSERT INTO `wp_commentmeta` VALUES("205", "79", "rating", "2");
INSERT INTO `wp_commentmeta` VALUES("206", "79", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("207", "79", "Quality_rate", "4");
INSERT INTO `wp_commentmeta` VALUES("208", "79", "price_rate", "4");
INSERT INTO `wp_commentmeta` VALUES("209", "79", "Property_rate", "3");
INSERT INTO `wp_commentmeta` VALUES("210", "79", "ease_rate", "4");
INSERT INTO `wp_commentmeta` VALUES("211", "79", "comment-title", "عالیس");
INSERT INTO `wp_commentmeta` VALUES("212", "79", "advantages", "a:1:{i:0;s:10:\"میممز\";}");
INSERT INTO `wp_commentmeta` VALUES("213", "79", "disadvantage", "a:1:{i:0;s:8:\"خیهب\";}");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("22", "96", "حسین", "sisusu@dhs.com", "", "5.127.24.206", "2022-02-09 17:55:34", "2022-02-09 14:25:34", "محصولی خوب با کیفیت و باداوم وفوق العاده من کاملا از این محصول راضی هستم.و پیشنهاد میکنم به دوستان عزیز که سفارش بدن و لذت ببرن ...باتشکر از پارس کالا", "0", "1", "Mozilla/5.0 (Linux; Android 11; SAMSUNG SM-M015G) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/16.0 Chrome/92.0.4515.166 Mobile Safari/537.36", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("75", "2697", "عققفقف", "lomorteza1@gmail.com", "", "91.251.60.208", "2024-10-19 18:03:45", "2024-10-19 14:33:45", "غعقق", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("78", "2702", "علی", "lomor77@gmail.com", "", "91.251.29.251", "2024-11-02 23:19:57", "2024-11-02 19:49:57", "نزمژن", "0", "0", "Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("79", "2702", "مرتضی", "lomorteza1377@gmail.com", "", "91.251.7.191", "2024-11-03 21:04:00", "2024-11-03 17:34:00", "عالییی", "0", "0", "Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("107", "2963", "ووکامرس", "", "", "", "2025-07-30 20:40:42", "2025-07-30 17:10:42", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("4", "mobile_36520250615_88d8b4daafd8a7d987d8", "2a954abed4d6d26c3581_20250801151803", "21", "2025-08-01 15:18:25", "nextapp", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-08-01 15:18:03\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:6:\"11.4.5\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:4;s:4:\"Name\";s:39:\"mobile_36520250615_88d8b4daafd8a7d987d8\";s:4:\"Hash\";s:35:\"2a954abed4d6d26c3581_20250801151803\";s:8:\"NameHash\";s:75:\"mobile_36520250615_88d8b4daafd8a7d987d8_2a954abed4d6d26c3581_20250801151803\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:85:\"mobile_36520250615_88d8b4daafd8a7d987d8_2a954abed4d6d26c3581_20250801151803_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.9\";s:6:\"WPUser\";s:7:\"nextapp\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:87:\"mobile_36520250615_88d8b4daafd8a7d987d8_2a954abed4d6d26c3581_20250801151803_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:35:\"/home/parskal1/mobile.parskalas.com\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2379;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:15749;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-08-01 15:18:03\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:6:\"11.4.5\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"mobile_36520250615_88d8b4daafd8a7d987d8\";s:4:\"Hash\";s:35:\"2a954abed4d6d26c3581_20250801151803\";s:8:\"NameHash\";s:75:\"mobile_36520250615_88d8b4daafd8a7d987d8_2a954abed4d6d26c3581_20250801151803\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:93:\"mobile_36520250615_88d8b4daafd8a7d987d8_2a954abed4d6d26c3581_20250801151803_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:49:\"/home/parskal1/mobile.parskalas.com/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:88:\"mobile_36520250615_88d8b4daafd8a7d987d8_2a954abed4d6d26c3581_20250801151803_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:156:\"/home/parskal1/mobile.parskalas.com/wp-content/backups-dup-lite/tmp/mobile_36520250615_88d8b4daafd8a7d987d8_2a954abed4d6d26c3581_20250801151803_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:44:\"/home/parskal1/mobile.parskalas.com/wp-admin\";i:1;s:47:\"/home/parskal1/mobile.parskalas.com/wp-includes\";i:2;s:56:\"/home/parskal1/mobile.parskalas.com/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:35:\"/home/parskal1/mobile.parskalas.com\";i:1;s:35:\"/home/parskal1/mobile.parskalas.com\";i:2;s:46:\"/home/parskal1/mobile.parskalas.com/wp-content\";i:3;s:54:\"/home/parskal1/mobile.parskalas.com/wp-content/uploads\";i:4;s:54:\"/home/parskal1/mobile.parskalas.com/wp-content/plugins\";i:5;s:57:\"/home/parskal1/mobile.parskalas.com/wp-content/mu-plugins\";i:6;s:53:\"/home/parskal1/mobile.parskalas.com/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:67:\"/home/parskal1/mobile.parskalas.com/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_eh_sms_verification */
INSERT INTO `wp_eh_sms_verification` VALUES("1", "09167971886", "5304", "2022-03-13 01:03:23");
INSERT INTO `wp_eh_sms_verification` VALUES("2", "09166341886", "2380", "2022-03-13 01:05:02");

/* INSERT TABLE DATA: wp_next_shopping_list */
INSERT INTO `wp_next_shopping_list` VALUES("1", "2610", "23", "تبلت اپل مدل iPad Air 5th generation Wi-Fi ظرفیت 256 گیگابایت سری گلس استیل", "09378208191", "23540000", NULL, NULL);

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://mobile.parskalas.com/", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://mobile.parskalas.com", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "فروشگاه اینترنتی پارس کالا", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "یک سایت دیگر با وردپرس فارسی", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "nextappteam@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "12", "on");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:457:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:9:\"header/?$\";s:26:\"index.php?post_type=header\";s:39:\"header/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?post_type=header&feed=$matches[1]\";s:34:\"header/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?post_type=header&feed=$matches[1]\";s:26:\"header/page/([0-9]{1,})/?$\";s:44:\"index.php?post_type=header&paged=$matches[1]\";s:9:\"footer/?$\";s:26:\"index.php?post_type=footer\";s:39:\"footer/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?post_type=footer&feed=$matches[1]\";s:34:\"footer/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?post_type=footer&feed=$matches[1]\";s:26:\"footer/page/([0-9]{1,})/?$\";s:44:\"index.php?post_type=footer&paged=$matches[1]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:9:\"prkfaq/?$\";s:26:\"index.php?post_type=prkfaq\";s:39:\"prkfaq/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?post_type=prkfaq&feed=$matches[1]\";s:34:\"prkfaq/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?post_type=prkfaq&feed=$matches[1]\";s:26:\"prkfaq/page/([0-9]{1,})/?$\";s:44:\"index.php?post_type=prkfaq&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:34:\"header/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"header/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"header/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"header/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"header/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"header/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"header/([^/]+)/embed/?$\";s:39:\"index.php?header=$matches[1]&embed=true\";s:27:\"header/([^/]+)/trackback/?$\";s:33:\"index.php?header=$matches[1]&tb=1\";s:47:\"header/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?header=$matches[1]&feed=$matches[2]\";s:42:\"header/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?header=$matches[1]&feed=$matches[2]\";s:35:\"header/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?header=$matches[1]&paged=$matches[2]\";s:42:\"header/([^/]+)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?header=$matches[1]&cpage=$matches[2]\";s:43:\"header/([^/]+)/wc/file/transient(/(.*))?/?$\";s:58:\"index.php?header=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"header/([^/]+)/wc-api(/(.*))?/?$\";s:47:\"index.php?header=$matches[1]&wc-api=$matches[3]\";s:49:\"header/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:60:\"header/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:38:\"header/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:49:\"header/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:31:\"header/([^/]+)(?:/([0-9]+))?/?$\";s:45:\"index.php?header=$matches[1]&page=$matches[2]\";s:23:\"header/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"header/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"header/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"header/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"header/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"header/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"footer/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"footer/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"footer/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"footer/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"footer/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"footer/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"footer/([^/]+)/embed/?$\";s:39:\"index.php?footer=$matches[1]&embed=true\";s:27:\"footer/([^/]+)/trackback/?$\";s:33:\"index.php?footer=$matches[1]&tb=1\";s:47:\"footer/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?footer=$matches[1]&feed=$matches[2]\";s:42:\"footer/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?footer=$matches[1]&feed=$matches[2]\";s:35:\"footer/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?footer=$matches[1]&paged=$matches[2]\";s:42:\"footer/([^/]+)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?footer=$matches[1]&cpage=$matches[2]\";s:43:\"footer/([^/]+)/wc/file/transient(/(.*))?/?$\";s:58:\"index.php?footer=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"footer/([^/]+)/wc-api(/(.*))?/?$\";s:47:\"index.php?footer=$matches[1]&wc-api=$matches[3]\";s:49:\"footer/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:60:\"footer/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:38:\"footer/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:49:\"footer/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:31:\"footer/([^/]+)(?:/([0-9]+))?/?$\";s:45:\"index.php?footer=$matches[1]&page=$matches[2]\";s:23:\"footer/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"footer/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"footer/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"footer/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"footer/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"footer/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:46:\"brand/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?brand=$matches[1]&feed=$matches[2]\";s:41:\"brand/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?brand=$matches[1]&feed=$matches[2]\";s:22:\"brand/([^/]+)/embed/?$\";s:38:\"index.php?brand=$matches[1]&embed=true\";s:34:\"brand/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?brand=$matches[1]&paged=$matches[2]\";s:16:\"brand/([^/]+)/?$\";s:27:\"index.php?brand=$matches[1]\";s:48:\"faq_cat/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?faq_cat=$matches[1]&feed=$matches[2]\";s:43:\"faq_cat/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?faq_cat=$matches[1]&feed=$matches[2]\";s:24:\"faq_cat/([^/]+)/embed/?$\";s:40:\"index.php?faq_cat=$matches[1]&embed=true\";s:36:\"faq_cat/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?faq_cat=$matches[1]&paged=$matches[2]\";s:18:\"faq_cat/([^/]+)/?$\";s:29:\"index.php?faq_cat=$matches[1]\";s:44:\"brand/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:39:\"brand/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:20:\"brand/(.+?)/embed/?$\";s:46:\"index.php?product_brand=$matches[1]&embed=true\";s:32:\"brand/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?product_brand=$matches[1]&paged=$matches[2]\";s:14:\"brand/(.+?)/?$\";s:35:\"index.php?product_brand=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:55:\"chose-selector/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?pa_chose-selector=$matches[1]&feed=$matches[2]\";s:50:\"chose-selector/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?pa_chose-selector=$matches[1]&feed=$matches[2]\";s:31:\"chose-selector/([^/]+)/embed/?$\";s:50:\"index.php?pa_chose-selector=$matches[1]&embed=true\";s:43:\"chose-selector/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?pa_chose-selector=$matches[1]&paged=$matches[2]\";s:25:\"chose-selector/([^/]+)/?$\";s:39:\"index.php?pa_chose-selector=$matches[1]\";s:55:\"color-selector/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?pa_color-selector=$matches[1]&feed=$matches[2]\";s:50:\"color-selector/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?pa_color-selector=$matches[1]&feed=$matches[2]\";s:31:\"color-selector/([^/]+)/embed/?$\";s:50:\"index.php?pa_color-selector=$matches[1]&embed=true\";s:43:\"color-selector/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?pa_color-selector=$matches[1]&paged=$matches[2]\";s:25:\"color-selector/([^/]+)/?$\";s:39:\"index.php?pa_color-selector=$matches[1]\";s:54:\"date-selector/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?pa_date-selector=$matches[1]&feed=$matches[2]\";s:49:\"date-selector/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?pa_date-selector=$matches[1]&feed=$matches[2]\";s:30:\"date-selector/([^/]+)/embed/?$\";s:49:\"index.php?pa_date-selector=$matches[1]&embed=true\";s:42:\"date-selector/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?pa_date-selector=$matches[1]&paged=$matches[2]\";s:24:\"date-selector/([^/]+)/?$\";s:38:\"index.php?pa_date-selector=$matches[1]\";s:53:\"ram-selector/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?pa_ram-selector=$matches[1]&feed=$matches[2]\";s:48:\"ram-selector/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?pa_ram-selector=$matches[1]&feed=$matches[2]\";s:29:\"ram-selector/([^/]+)/embed/?$\";s:48:\"index.php?pa_ram-selector=$matches[1]&embed=true\";s:41:\"ram-selector/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?pa_ram-selector=$matches[1]&paged=$matches[2]\";s:23:\"ram-selector/([^/]+)/?$\";s:37:\"index.php?pa_ram-selector=$matches[1]\";s:57:\"simcart-selector/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?pa_simcart-selector=$matches[1]&feed=$matches[2]\";s:52:\"simcart-selector/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?pa_simcart-selector=$matches[1]&feed=$matches[2]\";s:33:\"simcart-selector/([^/]+)/embed/?$\";s:52:\"index.php?pa_simcart-selector=$matches[1]&embed=true\";s:45:\"simcart-selector/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?pa_simcart-selector=$matches[1]&paged=$matches[2]\";s:27:\"simcart-selector/([^/]+)/?$\";s:41:\"index.php?pa_simcart-selector=$matches[1]\";s:54:\"size-selector/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?pa_size-selector=$matches[1]&feed=$matches[2]\";s:49:\"size-selector/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?pa_size-selector=$matches[1]&feed=$matches[2]\";s:30:\"size-selector/([^/]+)/embed/?$\";s:49:\"index.php?pa_size-selector=$matches[1]&embed=true\";s:42:\"size-selector/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?pa_size-selector=$matches[1]&paged=$matches[2]\";s:24:\"size-selector/([^/]+)/?$\";s:38:\"index.php?pa_size-selector=$matches[1]\";s:53:\"win-selector/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?pa_win-selector=$matches[1]&feed=$matches[2]\";s:48:\"win-selector/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?pa_win-selector=$matches[1]&feed=$matches[2]\";s:29:\"win-selector/([^/]+)/embed/?$\";s:48:\"index.php?pa_win-selector=$matches[1]&embed=true\";s:41:\"win-selector/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?pa_win-selector=$matches[1]&paged=$matches[2]\";s:23:\"win-selector/([^/]+)/?$\";s:37:\"index.php?pa_win-selector=$matches[1]\";s:62:\"پشتیبانی-از/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:63:\"index.php?pa_پشتیبانی-از=$matches[1]&feed=$matches[2]\";s:57:\"پشتیبانی-از/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:63:\"index.php?pa_پشتیبانی-از=$matches[1]&feed=$matches[2]\";s:38:\"پشتیبانی-از/([^/]+)/embed/?$\";s:57:\"index.php?pa_پشتیبانی-از=$matches[1]&embed=true\";s:50:\"پشتیبانی-از/([^/]+)/page/?([0-9]{1,})/?$\";s:64:\"index.php?pa_پشتیبانی-از=$matches[1]&paged=$matches[2]\";s:32:\"پشتیبانی-از/([^/]+)/?$\";s:46:\"index.php?pa_پشتیبانی-از=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:44:\"product/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"product/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"prkfaq/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"prkfaq/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"prkfaq/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"prkfaq/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"prkfaq/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"prkfaq/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"prkfaq/([^/]+)/embed/?$\";s:39:\"index.php?prkfaq=$matches[1]&embed=true\";s:27:\"prkfaq/([^/]+)/trackback/?$\";s:33:\"index.php?prkfaq=$matches[1]&tb=1\";s:47:\"prkfaq/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?prkfaq=$matches[1]&feed=$matches[2]\";s:42:\"prkfaq/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?prkfaq=$matches[1]&feed=$matches[2]\";s:35:\"prkfaq/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?prkfaq=$matches[1]&paged=$matches[2]\";s:42:\"prkfaq/([^/]+)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?prkfaq=$matches[1]&cpage=$matches[2]\";s:43:\"prkfaq/([^/]+)/wc/file/transient(/(.*))?/?$\";s:58:\"index.php?prkfaq=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"prkfaq/([^/]+)/wc-api(/(.*))?/?$\";s:47:\"index.php?prkfaq=$matches[1]&wc-api=$matches[3]\";s:49:\"prkfaq/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:60:\"prkfaq/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:38:\"prkfaq/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:49:\"prkfaq/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:31:\"prkfaq/([^/]+)(?:/([0-9]+))?/?$\";s:45:\"index.php?prkfaq=$matches[1]&page=$matches[2]\";s:23:\"prkfaq/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"prkfaq/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"prkfaq/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"prkfaq/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"prkfaq/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"prkfaq/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"notifications/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"notifications/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"notifications/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"notifications/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"notifications/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"notifications/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"notifications/([^/]+)/embed/?$\";s:46:\"index.php?notifications=$matches[1]&embed=true\";s:34:\"notifications/([^/]+)/trackback/?$\";s:40:\"index.php?notifications=$matches[1]&tb=1\";s:42:\"notifications/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?notifications=$matches[1]&paged=$matches[2]\";s:49:\"notifications/([^/]+)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?notifications=$matches[1]&cpage=$matches[2]\";s:50:\"notifications/([^/]+)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?notifications=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"notifications/([^/]+)/wc-api(/(.*))?/?$\";s:54:\"index.php?notifications=$matches[1]&wc-api=$matches[3]\";s:56:\"notifications/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:67:\"notifications/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:45:\"notifications/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:56:\"notifications/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:38:\"notifications/([^/]+)(?:/([0-9]+))?/?$\";s:52:\"index.php?notifications=$matches[1]&page=$matches[2]\";s:30:\"notifications/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"notifications/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"notifications/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"notifications/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"notifications/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"notifications/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"size-guide/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"size-guide/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"size-guide/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"size-guide/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"size-guide/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"size-guide/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"size-guide/([^/]+)/embed/?$\";s:47:\"index.php?prk_size_guide=$matches[1]&embed=true\";s:31:\"size-guide/([^/]+)/trackback/?$\";s:41:\"index.php?prk_size_guide=$matches[1]&tb=1\";s:39:\"size-guide/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?prk_size_guide=$matches[1]&paged=$matches[2]\";s:46:\"size-guide/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?prk_size_guide=$matches[1]&cpage=$matches[2]\";s:47:\"size-guide/([^/]+)/wc/file/transient(/(.*))?/?$\";s:66:\"index.php?prk_size_guide=$matches[1]&wc/file/transient=$matches[3]\";s:36:\"size-guide/([^/]+)/wc-api(/(.*))?/?$\";s:55:\"index.php?prk_size_guide=$matches[1]&wc-api=$matches[3]\";s:53:\"size-guide/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:64:\"size-guide/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"size-guide/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:53:\"size-guide/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:35:\"size-guide/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?prk_size_guide=$matches[1]&page=$matches[2]\";s:27:\"size-guide/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"size-guide/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"size-guide/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"size-guide/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"size-guide/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"size-guide/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"product-faq/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"product-faq/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"product-faq/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"product-faq/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"product-faq/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"product-faq/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"product-faq/([^/]+)/embed/?$\";s:44:\"index.php?product-faq=$matches[1]&embed=true\";s:32:\"product-faq/([^/]+)/trackback/?$\";s:38:\"index.php?product-faq=$matches[1]&tb=1\";s:40:\"product-faq/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product-faq=$matches[1]&paged=$matches[2]\";s:47:\"product-faq/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?product-faq=$matches[1]&cpage=$matches[2]\";s:48:\"product-faq/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?product-faq=$matches[1]&wc/file/transient=$matches[3]\";s:37:\"product-faq/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?product-faq=$matches[1]&wc-api=$matches[3]\";s:54:\"product-faq/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:65:\"product-faq/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:43:\"product-faq/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:54:\"product-faq/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:36:\"product-faq/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?product-faq=$matches[1]&page=$matches[2]\";s:28:\"product-faq/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"product-faq/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"product-faq/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"product-faq/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"product-faq/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"product-faq/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"product-feed/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"product-feed/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"product-feed/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"product-feed/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"product-feed/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"product-feed/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"product-feed/([^/]+)/embed/?$\";s:45:\"index.php?product-feed=$matches[1]&embed=true\";s:33:\"product-feed/([^/]+)/trackback/?$\";s:39:\"index.php?product-feed=$matches[1]&tb=1\";s:41:\"product-feed/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?product-feed=$matches[1]&paged=$matches[2]\";s:48:\"product-feed/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?product-feed=$matches[1]&cpage=$matches[2]\";s:49:\"product-feed/([^/]+)/wc/file/transient(/(.*))?/?$\";s:64:\"index.php?product-feed=$matches[1]&wc/file/transient=$matches[3]\";s:38:\"product-feed/([^/]+)/wc-api(/(.*))?/?$\";s:53:\"index.php?product-feed=$matches[1]&wc-api=$matches[3]\";s:55:\"product-feed/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:66:\"product-feed/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:44:\"product-feed/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"product-feed/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:37:\"product-feed/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?product-feed=$matches[1]&page=$matches[2]\";s:29:\"product-feed/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"product-feed/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"product-feed/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"product-feed/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"product-feed/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"product-feed/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:56:\"city_categories/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?city_categories=$matches[1]&feed=$matches[2]\";s:51:\"city_categories/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?city_categories=$matches[1]&feed=$matches[2]\";s:32:\"city_categories/([^/]+)/embed/?$\";s:48:\"index.php?city_categories=$matches[1]&embed=true\";s:44:\"city_categories/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?city_categories=$matches[1]&paged=$matches[2]\";s:26:\"city_categories/([^/]+)/?$\";s:37:\"index.php?city_categories=$matches[1]\";s:43:\"attribute_group/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"attribute_group/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"attribute_group/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"attribute_group/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"attribute_group/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"attribute_group/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"attribute_group/([^/]+)/embed/?$\";s:48:\"index.php?attribute_group=$matches[1]&embed=true\";s:36:\"attribute_group/([^/]+)/trackback/?$\";s:42:\"index.php?attribute_group=$matches[1]&tb=1\";s:44:\"attribute_group/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?attribute_group=$matches[1]&paged=$matches[2]\";s:51:\"attribute_group/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?attribute_group=$matches[1]&cpage=$matches[2]\";s:52:\"attribute_group/([^/]+)/wc/file/transient(/(.*))?/?$\";s:67:\"index.php?attribute_group=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"attribute_group/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?attribute_group=$matches[1]&wc-api=$matches[3]\";s:58:\"attribute_group/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:69:\"attribute_group/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:47:\"attribute_group/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:58:\"attribute_group/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:40:\"attribute_group/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?attribute_group=$matches[1]&page=$matches[2]\";s:32:\"attribute_group/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"attribute_group/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"attribute_group/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"attribute_group/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"attribute_group/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"attribute_group/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:67:\"attribute_group_categories/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?attribute_group_categories=$matches[1]&feed=$matches[2]\";s:62:\"attribute_group_categories/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?attribute_group_categories=$matches[1]&feed=$matches[2]\";s:43:\"attribute_group_categories/([^/]+)/embed/?$\";s:59:\"index.php?attribute_group_categories=$matches[1]&embed=true\";s:55:\"attribute_group_categories/([^/]+)/page/?([0-9]{1,})/?$\";s:66:\"index.php?attribute_group_categories=$matches[1]&paged=$matches[2]\";s:37:\"attribute_group_categories/([^/]+)/?$\";s:48:\"index.php?attribute_group_categories=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=1152&cpage=$matches[1]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:23:\"sit-wishlist(/(.*))?/?$\";s:35:\"index.php?&sit-wishlist=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:73:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/wc/file/transient(/(.*))?/?$\";s:110:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&wc/file/transient=$matches[6]\";s:62:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/wc-api(/(.*))?/?$\";s:99:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&wc-api=$matches[6]\";s:73:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:84:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:62:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:73:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:31:\"(.?.+?)/notification(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&notification=$matches[3]\";s:27:\"(.?.+?)/comments(/(.*))?/?$\";s:51:\"index.php?pagename=$matches[1]&comments=$matches[3]\";s:28:\"(.?.+?)/ordertrak(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&ordertrak=$matches[3]\";s:31:\"(.?.+?)/sit-wishlist(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&sit-wishlist=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "yes");
INSERT INTO `wp_options` VALUES("17112", "RTL-CareUnit-PCS", "C_QLMS5xL440STOMDPcOMPMJy7LUdoyqLDWLMtOP0nfNzjD1DC7wTK6IKC1ztfBLLU5LNXCqyMvMMS4yTvUuSs_XTzQpjcz3dDH10zYwzDcpr_C3cEl0Tsous0hLDXdLiQzI8AjVrixyt4y0BQA", "no");
INSERT INTO `wp_options` VALUES("17114", "herowp_option", "a:145:{s:16:\"herowp_preloader\";b:0;s:14:\"preloader_icon\";s:6:\"circle\";s:27:\"notification_bar_visibility\";b:1;s:26:\"notification_bar_container\";b:1;s:25:\"notification_bar_closable\";b:0;s:23:\"notification_bar_height\";i:60;s:27:\"notification_bar_text_color\";s:4:\"#000\";s:33:\"notification_bar_background_color\";s:7:\"#f9a134\";s:20:\"notification_bar_btn\";b:1;s:26:\"notification_bar_btn_color\";s:4:\"#fff\";s:31:\"notification_bar_btn_text_color\";s:4:\"#000\";s:11:\"header_type\";s:7:\"default\";s:17:\"header_full_width\";b:0;s:18:\"header_sticky_menu\";b:1;s:13:\"header_height\";i:112;s:14:\"logo_img_width\";i:200;s:12:\"logo_padding\";a:5:{s:11:\"padding-top\";s:4:\"10px\";s:13:\"padding-right\";s:4:\"20px\";s:14:\"padding-bottom\";s:4:\"10px\";s:12:\"padding-left\";s:3:\"0px\";s:5:\"units\";s:2:\"px\";}s:13:\"header_button\";b:1;s:18:\"header_button_type\";s:8:\"dropdown\";s:18:\"header_button_link\";s:7:\"account\";s:37:\"header_button_custom_text_after_login\";s:21:\"حساب کاربری\";s:11:\"header_call\";b:1;s:11:\"header_cart\";b:1;s:18:\"topbar_display_opt\";b:1;s:17:\"header_text_color\";s:7:\"#0a0909\";s:15:\"header_title_bg\";a:1:{s:16:\"background-color\";s:7:\"#ebeef1\";}s:17:\"off_canvas_search\";b:1;s:13:\"header_search\";b:1;s:12:\"search-style\";s:1:\"2\";s:16:\"opt-slider-label\";i:3;s:15:\"overlay-color-1\";a:2:{s:4:\"from\";s:7:\"#7d8dff\";s:2:\"to\";s:7:\"#ff4f81\";}s:15:\"overlay-color-2\";a:2:{s:4:\"from\";s:7:\"#ff4f81\";s:2:\"to\";s:7:\"#ff4f81\";}s:15:\"overlay-color-3\";a:2:{s:4:\"from\";s:7:\"#7d8dff\";s:2:\"to\";s:7:\"#7d8dff\";}s:15:\"overlay-color-4\";a:2:{s:4:\"from\";s:7:\"#7d8dff\";s:2:\"to\";s:7:\"#ff4f81\";}s:9:\"font_body\";a:6:{s:5:\"color\";s:7:\"#7d7e7f\";s:9:\"font-size\";s:4:\"15px\";s:11:\"line-height\";s:4:\"24px\";s:11:\"font-family\";s:8:\"Iransans\";s:6:\"google\";b:1;s:11:\"font-backup\";s:35:\"\'MS Sans Serif\', Geneva, sans-serif\";}s:12:\"menu_heading\";a:3:{s:11:\"font-family\";s:8:\"Iransans\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-size\";s:4:\"16px\";}s:12:\"submenu_font\";a:3:{s:11:\"font-family\";s:8:\"Iransans\";s:9:\"font-size\";s:4:\"14px\";s:11:\"font-weight\";s:3:\"400\";}s:9:\"h1_params\";a:5:{s:9:\"font-size\";s:4:\"26px\";s:11:\"font-weight\";s:3:\"400\";s:5:\"color\";s:7:\"#464749\";s:11:\"font-family\";s:8:\"Iransans\";s:6:\"google\";b:1;}s:9:\"h2_params\";a:5:{s:9:\"font-size\";s:4:\"24px\";s:11:\"font-weight\";s:3:\"400\";s:5:\"color\";s:7:\"#464749\";s:11:\"font-family\";s:8:\"Iransans\";s:6:\"google\";b:1;}s:9:\"h3_params\";a:5:{s:9:\"font-size\";s:4:\"22px\";s:11:\"font-weight\";s:3:\"400\";s:5:\"color\";s:7:\"#464749\";s:11:\"font-family\";s:8:\"Iransans\";s:6:\"google\";b:1;}s:9:\"h4_params\";a:5:{s:9:\"font-size\";s:4:\"18px\";s:11:\"font-weight\";s:3:\"500\";s:5:\"color\";s:7:\"#464749\";s:11:\"font-family\";s:8:\"Iransans\";s:6:\"google\";b:1;}s:9:\"h5_params\";a:5:{s:9:\"font-size\";s:4:\"18px\";s:11:\"font-weight\";s:3:\"500\";s:5:\"color\";s:7:\"#464749\";s:11:\"font-family\";s:8:\"Iransans\";s:6:\"google\";b:1;}s:9:\"h6_params\";a:5:{s:9:\"font-size\";s:4:\"16px\";s:11:\"font-weight\";s:3:\"500\";s:5:\"color\";s:7:\"#464749\";s:11:\"font-family\";s:8:\"Iransans\";s:6:\"google\";b:1;}s:13:\"primary_color\";s:7:\"#f9a134\";s:15:\"secondary_color\";s:7:\"#1e83f0\";s:12:\"shop_sidebar\";s:5:\"right\";s:15:\"courses_columns\";s:1:\"3\";s:13:\"shop_per_page\";s:1:\"8\";s:17:\"course_video_loop\";b:0;s:19:\"courses_rating_loop\";b:1;s:20:\"courses_teacher_loop\";b:1;s:19:\"courses_people_loop\";b:1;s:17:\"courses_cart_loop\";b:1;s:16:\"add_to_cart_text\";s:22:\"ثبت نام دوره\";s:19:\"course_student_text\";s:53:\"شما به این محصول دسترسی دارید\";s:30:\"course_single_sidebar_position\";s:5:\"right\";s:15:\"course_purchase\";b:1;s:16:\"course_downloads\";b:0;s:15:\"course_students\";b:1;s:15:\"course_counters\";b:1;s:18:\"file_product_title\";b:1;s:18:\"product_short_link\";b:1;s:21:\"course_detail_reviews\";b:0;s:12:\"product_tags\";b:0;s:14:\"product_seller\";b:0;s:23:\"related_courses_display\";b:1;s:15:\"course_per_page\";s:1:\"6\";s:18:\"course_share_story\";b:1;s:15:\"blog_post_style\";s:4:\"list\";s:17:\"blog_grid_columns\";s:5:\"three\";s:20:\"blog_thumbnails_size\";s:6:\"square\";s:16:\"sidebar_position\";s:5:\"right\";s:23:\"sidebar_position_single\";s:5:\"right\";s:14:\"blog_desc_text\";b:0;s:9:\"blog_cate\";b:0;s:14:\"article_author\";b:1;s:15:\"blog_navigation\";b:1;s:12:\"blog_related\";b:1;s:23:\"related-blog_post_style\";s:16:\"related-carousel\";s:14:\"blog_meta_data\";b:1;s:17:\"blog_featured_img\";b:1;s:16:\"blog_share_story\";b:1;s:11:\"footer_type\";s:7:\"default\";s:15:\"footer_selected\";s:7:\"footer1\";s:14:\"footer_widgets\";b:1;s:14:\"footer_columns\";s:5:\"three\";s:18:\"disable_copyrights\";b:1;s:17:\"copyrights-layout\";s:7:\"default\";s:19:\"copyright_developer\";b:1;s:14:\"scroll_top_btn\";b:1;s:20:\"profile-notification\";b:1;s:15:\"profile-article\";b:1;s:12:\"profile-gift\";b:1;s:18:\"profile-gift-title\";s:8:\"Energy90\";s:17:\"profile-gift-desc\";s:41:\"تخفیف 90% ویژه عید نوروز\";s:14:\"profile-social\";b:1;s:16:\"profile-telegram\";b:1;s:20:\"profile-telegram-url\";s:1:\"#\";s:17:\"profile-instagram\";b:1;s:21:\"profile-instagram-url\";s:1:\"#\";s:12:\"login-layout\";s:7:\"login-1\";s:14:\"login-subtitle\";s:64:\"خوشحالیم دوباره میبینیمت دوست عزیز\";s:17:\"register-subtitle\";s:59:\"خوشحالیم قراره به جمع ما بپیوندی\";s:17:\"portfolio_columns\";s:5:\"three\";s:17:\"portfolio_filters\";s:4:\"left\";s:18:\"portfolio_per_page\";s:1:\"9\";s:13:\"portfolio_nav\";b:1;s:13:\"course_advice\";b:1;s:22:\"fixed_right_btn_status\";b:0;s:21:\"fixed_right_btn_title\";s:36:\"مشاوره تلفنی رایگان\";s:17:\"file_store_status\";b:0;s:26:\"file_store_profile_product\";s:8:\"فایل\";s:30:\"file_store_profile_buy_product\";s:37:\"فایل های خریداری شده\";s:12:\"social_order\";a:2:{s:7:\"enabled\";a:8:{s:7:\"placebo\";s:7:\"placebo\";s:2:\"fb\";s:8:\"Facebook\";s:2:\"tw\";s:7:\"Twitter\";s:2:\"ig\";s:9:\"Instagram\";s:2:\"vm\";s:5:\"Vimeo\";s:2:\"be\";s:7:\"Behance\";s:2:\"fs\";s:10:\"Foursquare\";s:6:\"custom\";s:11:\"Custom Link\";}s:8:\"disabled\";a:21:{s:7:\"placebo\";s:7:\"placebo\";s:2:\"gp\";s:7:\"Google+\";s:3:\"lin\";s:8:\"LinkedIn\";s:2:\"yt\";s:7:\"YouTube\";s:3:\"drb\";s:8:\"Dribbble\";s:2:\"pi\";s:9:\"Pinterest\";s:2:\"vk\";s:9:\"VKontakte\";s:2:\"da\";s:10:\"DeviantArt\";s:2:\"fl\";s:6:\"Flickr\";s:2:\"vi\";s:4:\"Vine\";s:2:\"tu\";s:6:\"Tumblr\";s:2:\"sk\";s:5:\"Skype\";s:2:\"gh\";s:6:\"GitHub\";s:2:\"hz\";s:5:\"Houzz\";s:2:\"px\";s:5:\"500px\";s:2:\"xi\";s:4:\"Xing\";s:2:\"sn\";s:8:\"Snapchat\";s:2:\"em\";s:5:\"Email\";s:2:\"yp\";s:4:\"Yelp\";s:2:\"ta\";s:11:\"TripAdvisor\";s:6:\"aparat\";s:12:\"آپارات\";}}s:27:\"social_networks_target_attr\";s:6:\"_blank\";s:26:\"social_network_link_aparat\";s:0:\"\";s:31:\"social_network_aparat_link_icon\";s:6:\"aparat\";s:22:\"social_network_link_fb\";s:0:\"\";s:22:\"social_network_link_tw\";s:0:\"\";s:23:\"social_network_link_lin\";s:0:\"\";s:22:\"social_network_link_yt\";s:0:\"\";s:22:\"social_network_link_vm\";s:0:\"\";s:23:\"social_network_link_drb\";s:0:\"\";s:22:\"social_network_link_ig\";s:0:\"\";s:22:\"social_network_link_pi\";s:0:\"\";s:22:\"social_network_link_gp\";s:0:\"\";s:22:\"social_network_link_vk\";s:0:\"\";s:22:\"social_network_link_da\";s:0:\"\";s:22:\"social_network_link_tu\";s:0:\"\";s:22:\"social_network_link_be\";s:0:\"\";s:22:\"social_network_link_fl\";s:0:\"\";s:22:\"social_network_link_fs\";s:0:\"\";s:22:\"social_network_link_sk\";s:0:\"\";s:22:\"social_network_link_gh\";s:0:\"\";s:22:\"social_network_link_hz\";s:0:\"\";s:22:\"social_network_link_px\";s:0:\"\";s:22:\"social_network_link_vi\";s:0:\"\";s:22:\"social_network_link_sn\";s:0:\"\";s:22:\"social_network_link_yp\";s:0:\"\";s:22:\"social_network_link_ta\";s:0:\"\";s:22:\"social_network_link_em\";s:0:\"\";s:30:\"social_network_link_em_subject\";s:0:\"\";s:32:\"social_network_custom_link_title\";s:0:\"\";s:31:\"social_network_custom_link_link\";s:0:\"\";s:31:\"social_network_custom_link_icon\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("18011", "woocommerce_attribute_lookup_direct_updates", "no", "yes");
INSERT INTO `wp_options` VALUES("17115", "herowp_option-transients", "a:2:{s:14:\"changed_values\";a:0:{}s:9:\"last_save\";i:1656193333;}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:4:{i:1;s:23:\"elementor/elementor.php\";i:2;s:27:\"woocommerce/woocommerce.php\";i:3;s:43:\"persian-woocommerce/woocommerce-persian.php\";i:4;s:25:\"duplicator/duplicator.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "https://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "+3.5", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:5:{i:0;s:76:\"/home/parskal1/mobile.parskalas.com/wp-content/themes/parskala/functions.php\";i:2;s:72:\"/home/parskal1/mobile.parskalas.com/wp-content/themes/parskala/style.css\";i:3;s:107:\"/home2/parskal6/domains/mobile.parskalas.com/public_html/wp-content/themes/parskala/developer-functions.php\";i:4;s:93:\"/home2/parskal6/domains/mobile.parskalas.com/public_html/wp-content/themes/parskala/style.css\";i:5;s:104:\"/home2/parskal6/domains/mobile.parskalas.com/public_html/wp-content/themes/parskala/assets/js/crousel.js\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "parskala", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "parskala", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("46", "db_version", "60421", "yes");
INSERT INTO `wp_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "uninstall_plugins", "a:2:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:27:\"perfmatters/perfmatters.php\";s:21:\"perfmatters_uninstall\";}", "no");
INSERT INTO `wp_options` VALUES("80", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("82", "page_on_front", "1152", "yes");
INSERT INTO `wp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("86", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("91", "admin_email_lifespan", "1769612889", "yes");
INSERT INTO `wp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("99", "initial_db_version", "49752", "yes");
INSERT INTO `wp_options` VALUES("100", "wp_user_roles", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:157:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:8:\"dokandar\";b:1;s:25:\"dokan_view_sales_overview\";b:1;s:29:\"dokan_view_sales_report_chart\";b:1;s:23:\"dokan_view_announcement\";b:1;s:23:\"dokan_view_order_report\";b:1;s:25:\"dokan_view_review_reports\";b:1;s:32:\"dokan_view_product_status_report\";b:1;s:26:\"dokan_view_overview_report\";b:1;s:28:\"dokan_view_daily_sale_report\";b:1;s:29:\"dokan_view_top_selling_report\";b:1;s:29:\"dokan_view_top_earning_report\";b:1;s:27:\"dokan_view_statement_report\";b:1;s:16:\"dokan_view_order\";b:1;s:18:\"dokan_manage_order\";b:1;s:23:\"dokan_manage_order_note\";b:1;s:19:\"dokan_manage_refund\";b:1;s:18:\"dokan_export_order\";b:1;s:16:\"dokan_add_coupon\";b:1;s:17:\"dokan_edit_coupon\";b:1;s:19:\"dokan_delete_coupon\";b:1;s:18:\"dokan_view_reviews\";b:1;s:20:\"dokan_manage_reviews\";b:1;s:21:\"dokan_manage_withdraw\";b:1;s:17:\"dokan_add_product\";b:1;s:18:\"dokan_edit_product\";b:1;s:20:\"dokan_delete_product\";b:1;s:18:\"dokan_view_product\";b:1;s:23:\"dokan_duplicate_product\";b:1;s:20:\"dokan_import_product\";b:1;s:20:\"dokan_export_product\";b:1;s:24:\"dokan_view_overview_menu\";b:1;s:23:\"dokan_view_product_menu\";b:1;s:21:\"dokan_view_order_menu\";b:1;s:22:\"dokan_view_coupon_menu\";b:1;s:22:\"dokan_view_report_menu\";b:1;s:22:\"dokan_view_review_menu\";b:1;s:24:\"dokan_view_withdraw_menu\";b:1;s:30:\"dokan_view_store_settings_menu\";b:1;s:29:\"dokan_view_store_payment_menu\";b:1;s:30:\"dokan_view_store_shipping_menu\";b:1;s:28:\"dokan_view_store_social_menu\";b:1;s:25:\"dokan_view_store_seo_menu\";b:1;s:16:\"create_customers\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:135:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:8:\"dokandar\";b:1;s:25:\"dokan_view_sales_overview\";b:1;s:29:\"dokan_view_sales_report_chart\";b:1;s:23:\"dokan_view_announcement\";b:1;s:23:\"dokan_view_order_report\";b:1;s:25:\"dokan_view_review_reports\";b:1;s:32:\"dokan_view_product_status_report\";b:1;s:26:\"dokan_view_overview_report\";b:1;s:28:\"dokan_view_daily_sale_report\";b:1;s:29:\"dokan_view_top_selling_report\";b:1;s:29:\"dokan_view_top_earning_report\";b:1;s:27:\"dokan_view_statement_report\";b:1;s:16:\"dokan_view_order\";b:1;s:18:\"dokan_manage_order\";b:1;s:23:\"dokan_manage_order_note\";b:1;s:19:\"dokan_manage_refund\";b:1;s:18:\"dokan_export_order\";b:1;s:16:\"dokan_add_coupon\";b:1;s:17:\"dokan_edit_coupon\";b:1;s:19:\"dokan_delete_coupon\";b:1;s:18:\"dokan_view_reviews\";b:1;s:20:\"dokan_manage_reviews\";b:1;s:21:\"dokan_manage_withdraw\";b:1;s:17:\"dokan_add_product\";b:1;s:18:\"dokan_edit_product\";b:1;s:20:\"dokan_delete_product\";b:1;s:18:\"dokan_view_product\";b:1;s:23:\"dokan_duplicate_product\";b:1;s:20:\"dokan_import_product\";b:1;s:20:\"dokan_export_product\";b:1;s:24:\"dokan_view_overview_menu\";b:1;s:23:\"dokan_view_product_menu\";b:1;s:21:\"dokan_view_order_menu\";b:1;s:22:\"dokan_view_coupon_menu\";b:1;s:22:\"dokan_view_report_menu\";b:1;s:22:\"dokan_view_review_menu\";b:1;s:24:\"dokan_view_withdraw_menu\";b:1;s:30:\"dokan_view_store_settings_menu\";b:1;s:29:\"dokan_view_store_payment_menu\";b:1;s:30:\"dokan_view_store_shipping_menu\";b:1;s:28:\"dokan_view_store_social_menu\";b:1;s:25:\"dokan_view_store_seo_menu\";b:1;s:16:\"create_customers\";b:1;}}s:6:\"seller\";a:2:{s:4:\"name\";s:14:\"فروشنده\";s:12:\"capabilities\";a:67:{s:4:\"read\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:12:\"delete_posts\";b:1;s:17:\"manage_categories\";b:1;s:17:\"moderate_comments\";b:1;s:15:\"unfiltered_html\";b:1;s:12:\"upload_files\";b:1;s:16:\"edit_shop_orders\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:8:\"dokandar\";b:1;s:25:\"dokan_view_sales_overview\";b:1;s:29:\"dokan_view_sales_report_chart\";b:1;s:23:\"dokan_view_announcement\";b:1;s:23:\"dokan_view_order_report\";b:1;s:25:\"dokan_view_review_reports\";b:1;s:32:\"dokan_view_product_status_report\";b:1;s:26:\"dokan_view_overview_report\";b:1;s:28:\"dokan_view_daily_sale_report\";b:1;s:29:\"dokan_view_top_selling_report\";b:1;s:29:\"dokan_view_top_earning_report\";b:1;s:27:\"dokan_view_statement_report\";b:1;s:16:\"dokan_view_order\";b:1;s:18:\"dokan_manage_order\";b:1;s:23:\"dokan_manage_order_note\";b:1;s:19:\"dokan_manage_refund\";b:1;s:18:\"dokan_export_order\";b:1;s:16:\"dokan_add_coupon\";b:1;s:17:\"dokan_edit_coupon\";b:1;s:19:\"dokan_delete_coupon\";b:1;s:18:\"dokan_view_reviews\";b:1;s:20:\"dokan_manage_reviews\";b:1;s:21:\"dokan_manage_withdraw\";b:1;s:17:\"dokan_add_product\";b:1;s:18:\"dokan_edit_product\";b:1;s:20:\"dokan_delete_product\";b:1;s:18:\"dokan_view_product\";b:1;s:23:\"dokan_duplicate_product\";b:1;s:20:\"dokan_import_product\";b:1;s:20:\"dokan_export_product\";b:1;s:24:\"dokan_view_overview_menu\";b:1;s:23:\"dokan_view_product_menu\";b:1;s:21:\"dokan_view_order_menu\";b:1;s:22:\"dokan_view_coupon_menu\";b:1;s:22:\"dokan_view_report_menu\";b:1;s:22:\"dokan_view_review_menu\";b:1;s:24:\"dokan_view_withdraw_menu\";b:1;s:30:\"dokan_view_store_settings_menu\";b:1;s:29:\"dokan_view_store_payment_menu\";b:1;s:30:\"dokan_view_store_shipping_menu\";b:1;s:28:\"dokan_view_store_social_menu\";b:1;s:25:\"dokan_view_store_seo_menu\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("101", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("102", "WPLANG", "fa_IR", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_block", "a:15:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:170:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>نوشته‌های تازه</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:242:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>آخرین دیدگاه‌ها</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>بایگانی‌ها</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:207:\"<!-- wp:group -->\n<div class=\"wp-block-group\"><!-- wp:legacy-widget {\"idBase\":\"register_footer_apps\",\"instance\":{\"encoded\":\"YTowOnt9\",\"hash\":\"64db99f0d02f2496731d86726eb95fbb\"}} /--></div>\n<!-- /wp:group -->\";}i:8;a:1:{s:7:\"content\";s:43:\"<!-- wp:woocommerce/product-categories /-->\";}i:11;a:1:{s:7:\"content\";s:311:\"<!-- wp:image {\"id\":208,\"width\":251,\"height\":285,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full is-resized\"><img src=\"https://mobile.parskalas.com/wp-content/uploads/2022/01/side-ads.png\" alt=\"\" class=\"wp-image-208\" width=\"251\" height=\"285\"/></figure>\n<!-- /wp:image -->\";}i:13;a:1:{s:7:\"content\";s:192:\"<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"100%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:100%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\";}s:12:\"_multiwidget\";i:1;i:14;a:1:{s:7:\"content\";s:0:\"\";}i:17;a:1:{s:7:\"content\";s:0:\"\";}i:18;a:1:{s:7:\"content\";s:0:\"\";}i:19;a:1:{s:7:\"content\";s:77:\"<!-- wp:columns -->\n<div class=\"wp-block-columns\"></div>\n<!-- /wp:columns -->\";}i:20;a:1:{s:7:\"content\";s:429:\"        <div class=\"enamad-imgs\">\n              <a href=\"#\"><img src=\"https://mobile.parskalas.com/wp-content/themes/parskala/assets/img/en1.png\" alt=\"\"></a><br>\n                <a href=\"#\"> <img src=\"https://mobile.parskalas.com/wp-content/themes/parskala/assets/img/en2.png\" alt=\"\"></a><br>\n            <a href=\"#\"><img src=\"https://mobile.parskalas.com/wp-content/themes/parskala/assets/img/en3.png\" alt=\"\"></a>\n        </div>\";}i:22;a:1:{s:7:\"content\";s:41:\"<!-- wp:woocommerce/product-category /-->\";}}", "yes");
INSERT INTO `wp_options` VALUES("104", "sidebars_widgets", "a:5:{s:19:\"wp_inactive_widgets\";a:16:{i:0;s:24:\"register_footer_social-3\";i:1;s:22:\"register_footer_text-3\";i:2;s:22:\"register_footer_apps-3\";i:3;s:22:\"register_footer_apps-5\";i:4;s:8:\"block-14\";i:5;s:8:\"block-13\";i:6;s:8:\"block-17\";i:7;s:8:\"block-18\";i:8;s:8:\"block-19\";i:9;s:8:\"block-20\";i:10;s:7:\"block-5\";i:11;s:7:\"block-6\";i:12;s:7:\"block-2\";i:13;s:7:\"block-3\";i:14;s:7:\"block-4\";i:15;s:8:\"block-22\";}s:13:\"footer-widget\";a:5:{i:0;s:10:\"nav_menu-4\";i:1;s:10:\"nav_menu-3\";i:2;s:10:\"nav_menu-5\";i:3;s:24:\"register_footer_social-5\";i:4;s:22:\"register_footer_apps-7\";}s:18:\"sideby-post-widget\";a:2:{i:0;s:16:\"register_posts-3\";i:1;s:16:\"register_posts-4\";}s:17:\"sideby-pro-widget\";a:7:{i:0;s:26:\"woocommerce_price_filter-3\";i:1;s:25:\"register_product_search-3\";i:2;s:25:\"parskala_brands_prodcut-3\";i:3;s:28:\"parskala_categorys_prodcut-3\";i:4;s:25:\"woocommerce_layered_nav-3\";i:5;s:25:\"woocommerce_layered_nav-5\";i:6;s:18:\"register_pro_ads-5\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("105", "cron", "a:31:{i:1754061524;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1754061889;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1754061896;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1754062680;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1754063188;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1754064142;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1754066788;a:3:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1754066987;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1754068295;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"124b6bd0b2454c20b906d0b293615401\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:2965;}}}}i:1754069089;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1754069233;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1754069283;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1754071104;a:3:{s:50:\"remove_offers_product_invalid_inslider_daily_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:49:\"remove_offers_product_invalid_archive_daily_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:36:\"puc_cron_check_updates_theme-newkala\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1754078587;a:1:{s:45:\"woocommerce_marketplace_cron_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1754082000;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1754092800;a:1:{s:22:\"wdev_logger_clear_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1754100142;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1754101285;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1754105305;a:1:{s:25:\"zhk_guard_daily_validator\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1754121742;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1754121752;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1754122772;a:1:{s:34:\"yith_wcwl_delete_expired_wishlists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1754125794;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1754132542;a:2:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"woocommerce_cleanup_rate_limits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1754199120;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1754233983;a:2:{s:31:\"prk_delete_expired_cart_coupons\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:27:\"prk_coupon_cleanup_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:172800;}}s:32:\"prk_delete_expired_order_coupons\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:33:\"prk_order_coupon_cleanup_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:172800;}}}i:1754303400;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1754498788;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1754593967;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1755158602;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("106", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("116", "widget_nav_menu", "a:4:{s:12:\"_multiwidget\";i:1;i:3;a:2:{s:5:\"title\";s:22:\"با پارس کالا\";s:8:\"nav_menu\";i:125;}i:4;a:2:{s:5:\"title\";s:23:\"راهنمای خرید\";s:8:\"nav_menu\";i:124;}i:5;a:2:{s:5:\"title\";s:23:\"راهنمای خرید\";s:8:\"nav_menu\";i:126;}}", "yes");
INSERT INTO `wp_options` VALUES("117", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("119", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("121", "https_detection_errors", "a:1:{s:23:\"ssl_verification_failed\";a:1:{i:0;s:35:\"تأیید SSL ناموفق بود.\";}}", "off");
INSERT INTO `wp_options` VALUES("120", "theme_mods_twentytwentyone", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1642524769;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("159", "widget_register_posts", "a:3:{s:12:\"_multiwidget\";i:1;i:3;a:3:{s:11:\"title_posts\";s:23:\"راهنمای خرید\";s:9:\"num_posts\";s:2:\"10\";s:12:\"select_posts\";i:111;}i:4;a:3:{s:11:\"title_posts\";s:34:\"از پارس کالا به شما\";s:9:\"num_posts\";s:1:\"6\";s:12:\"select_posts\";i:113;}}", "yes");
INSERT INTO `wp_options` VALUES("466", "yith_woocompare_button_text", "مقایسه", "yes");
INSERT INTO `wp_options` VALUES("467", "yith_woocompare_compare_button_in_product_page", "yes", "yes");
INSERT INTO `wp_options` VALUES("468", "yith_woocompare_compare_button_in_products_list", "no", "yes");
INSERT INTO `wp_options` VALUES("146", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("150", "current_theme", "پارس کالا", "yes");
INSERT INTO `wp_options` VALUES("151", "theme_mods_parskala", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:9:\"mega-menu\";i:20;s:13:\"category-menu\";i:0;}s:18:\"custom_css_post_id\";i:1199;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1656611901;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:15:{i:0;s:24:\"register_footer_social-3\";i:1;s:22:\"register_footer_text-3\";i:2;s:22:\"register_footer_apps-3\";i:3;s:22:\"register_footer_apps-5\";i:4;s:8:\"block-14\";i:5;s:8:\"block-13\";i:6;s:8:\"block-17\";i:7;s:8:\"block-18\";i:8;s:8:\"block-19\";i:9;s:8:\"block-20\";i:10;s:7:\"block-5\";i:11;s:7:\"block-6\";i:12;s:7:\"block-2\";i:13;s:7:\"block-3\";i:14;s:7:\"block-4\";}s:13:\"footer-widget\";a:3:{i:0;s:10:\"nav_menu-4\";i:1;s:10:\"nav_menu-3\";i:2;s:10:\"nav_menu-5\";}s:18:\"sideby-post-widget\";a:5:{i:0;s:21:\"register_menu_posts-3\";i:1;s:23:\"register_search_posts-3\";i:2;s:16:\"register_posts-3\";i:3;s:23:\"register_servis_posts-3\";i:4;s:16:\"register_posts-4\";}s:17:\"sideby-pro-widget\";a:5:{i:0;s:26:\"woocommerce_price_filter-3\";i:1;s:25:\"register_product_search-3\";i:2;s:18:\"register_pro_ads-3\";i:3;s:7:\"block-8\";i:4;s:8:\"block-11\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("152", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("153", "redux_version_upgraded_from", "3.6.15", "yes");
INSERT INTO `wp_options` VALUES("154", "widget_register_footer_social", "a:3:{s:12:\"_multiwidget\";i:1;i:3;a:6:{s:12:\"title_social\";s:29:\"با ما همراه شوید\";s:11:\"title_email\";s:52:\"از جدیدترین خبرها باخبر شوید\";s:14:\"instagram_link\";N;s:12:\"twitter_link\";N;s:13:\"linkedin_link\";N;s:13:\"facebook_link\";N;}i:5;a:6:{s:12:\"title_social\";s:50:\"رسانه های پر رنگ ما در مجازی\";s:11:\"title_email\";s:34:\"عنوان باکس خبرنامه\";s:14:\"instagram_link\";N;s:12:\"twitter_link\";N;s:13:\"linkedin_link\";N;s:13:\"facebook_link\";N;}}", "yes");
INSERT INTO `wp_options` VALUES("155", "widget_register_footer_text", "a:2:{s:12:\"_multiwidget\";i:1;i:3;a:2:{s:10:\"title_text\";s:102:\"فروشگاه اینترنتی پارس کالا، بررسی، انتخاب و خرید آنلاین\";s:13:\"textarea_text\";s:718:\"پارس کالا به عنوان یکی از قدیمی‌ترین فروشگاه های اینترنتی با بیش از یک دهه تجربه، با پایبندی به سه اصل، پرداخت در محل، ۷ روز ضمانت بازگشت کالا و تضمین اصل‌بودن کالا موفق شده تا همگام با فروشگاه‌های معتبر جهان، به بزرگ‌ترین فروشگاه اینترنتی ایران تبدیل شود. به محض ورود به سایت دیجی‌کالا با دنیایی از کالا رو به رو می‌شوید! هر آنچه که نیاز دارید و به ذهن شما خطور می‌کند در اینجا پیدا خواهید کرد. \";}}", "yes");
INSERT INTO `wp_options` VALUES("156", "widget_register_footer_apps", "a:4:{s:12:\"_multiwidget\";i:1;i:3;a:0:{}i:5;a:0:{}i:7;a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("157", "widget_register_menu_posts", "a:2:{s:12:\"_multiwidget\";i:1;i:3;a:1:{s:14:\"title_category\";s:13:\"دسته ها\";}}", "yes");
INSERT INTO `wp_options` VALUES("158", "widget_register_search_posts", "a:2:{s:12:\"_multiwidget\";i:1;i:3;a:1:{s:12:\"title_search\";s:10:\"عنوان\";}}", "yes");
INSERT INTO `wp_options` VALUES("305", "woocommerce_inbox_variant_assignment", "6", "yes");
INSERT INTO `wp_options` VALUES("517", "dokan_installed_time", "1642532324", "yes");
INSERT INTO `wp_options` VALUES("160", "widget_register_servis_posts", "a:2:{s:12:\"_multiwidget\";i:1;i:3;a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("983", "elementor_active_kit", "159", "yes");
INSERT INTO `wp_options` VALUES("989", "_elementor_installed_time", "1642605496", "yes");
INSERT INTO `wp_options` VALUES("990", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:4:{i:0;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:20472;s:5:\"title\";s:10:\"test ido f\";s:9:\"thumbnail\";s:153:\"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png\";s:12:\"tmpl_created\";i:1751356263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:1;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:19968;s:5:\"title\";s:12:\"Zeyad Test 1\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg\";s:12:\"tmpl_created\";i:1670765723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:2;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:19494;s:5:\"title\";s:5:\"test2\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg\";s:12:\"tmpl_created\";i:1672308146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:3;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:87:\"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1660034300;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}", "off");
INSERT INTO `wp_options` VALUES("174597", "_transient_timeout__woocommerce_helper_subscriptions", "1754061996", "off");
INSERT INTO `wp_options` VALUES("174598", "_transient__woocommerce_helper_subscriptions", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("170018", "can_compress_scripts", "0", "auto");
INSERT INTO `wp_options` VALUES("174460", "_transient_timeout_wc_product_children_2257", "1756616218", "off");
INSERT INTO `wp_options` VALUES("174461", "_transient_wc_product_children_2257", "a:3:{s:3:\"all\";a:3:{i:0;i:2258;i:1;i:2259;i:2;i:2260;}s:7:\"visible\";a:3:{i:0;i:2258;i:1;i:2259;i:2;i:2260;}s:7:\"version\";s:10:\"1730655240\";}", "off");
INSERT INTO `wp_options` VALUES("174462", "_transient_timeout_wc_product_children_2610", "1756616218", "off");
INSERT INTO `wp_options` VALUES("174463", "_transient_wc_product_children_2610", "a:3:{s:3:\"all\";a:3:{i:0;i:2611;i:1;i:2612;i:2;i:2613;}s:7:\"visible\";a:3:{i:0;i:2611;i:1;i:2612;i:2;i:2613;}s:7:\"version\";s:10:\"1730655240\";}", "off");
INSERT INTO `wp_options` VALUES("174464", "_transient_timeout_wc_product_children_2599", "1756616218", "off");
INSERT INTO `wp_options` VALUES("174465", "_transient_wc_product_children_2599", "a:3:{s:3:\"all\";a:4:{i:0;i:2608;i:1;i:2600;i:2;i:2601;i:3;i:2602;}s:7:\"visible\";a:4:{i:0;i:2608;i:1;i:2600;i:2;i:2601;i:3;i:2602;}s:7:\"version\";s:10:\"1730655240\";}", "off");
INSERT INTO `wp_options` VALUES("174466", "_transient_timeout_wc_product_children_2590", "1756616218", "off");
INSERT INTO `wp_options` VALUES("174467", "_transient_wc_product_children_2590", "a:3:{s:3:\"all\";a:3:{i:0;i:2591;i:1;i:2592;i:2;i:2593;}s:7:\"visible\";a:3:{i:0;i:2591;i:1;i:2592;i:2;i:2593;}s:7:\"version\";s:10:\"1730655240\";}", "off");
INSERT INTO `wp_options` VALUES("174468", "_transient_timeout_wc_product_children_2580", "1756616218", "off");
INSERT INTO `wp_options` VALUES("174469", "_transient_wc_product_children_2580", "a:3:{s:3:\"all\";a:3:{i:0;i:2588;i:1;i:2589;i:2;i:2587;}s:7:\"visible\";a:3:{i:0;i:2588;i:1;i:2589;i:2;i:2587;}s:7:\"version\";s:10:\"1730655240\";}", "off");
INSERT INTO `wp_options` VALUES("174470", "_transient_timeout_wc_product_children_2615", "1756616218", "off");
INSERT INTO `wp_options` VALUES("174471", "_transient_wc_product_children_2615", "a:3:{s:3:\"all\";a:2:{i:0;i:2617;i:1;i:2618;}s:7:\"visible\";a:2:{i:0;i:2617;i:1;i:2618;}s:7:\"version\";s:10:\"1730655240\";}", "off");
INSERT INTO `wp_options` VALUES("986", "elementor_version", "3.29.2", "yes");
INSERT INTO `wp_options` VALUES("987", "elementor_install_history", "a:5:{s:5:\"3.5.3\";i:1642605493;s:5:\"3.5.4\";i:1642948402;s:5:\"3.5.5\";i:1643918960;s:5:\"3.6.6\";i:1656546455;s:6:\"3.29.2\";i:1749974536;}", "yes");
INSERT INTO `wp_options` VALUES("161", "widget_register_product_search", "a:2:{s:12:\"_multiwidget\";i:1;i:3;a:1:{s:20:\"title_product_search\";s:11:\"جستجو:\";}}", "yes");
INSERT INTO `wp_options` VALUES("162", "widget_register_free_orders", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("163", "widget_register_pro_ads", "a:3:{s:12:\"_multiwidget\";i:1;i:3;a:1:{s:10:\"select_pro\";i:39;}i:5;a:1:{s:10:\"select_pro\";i:39;}}", "yes");
INSERT INTO `wp_options` VALUES("164", "prk_option", "a:709:{s:7:\"favicon\";a:8:{s:3:\"url\";s:75:\"https://mobile.parskalas.com/wp-content/uploads/2022/08/digital-favicon.png\";s:2:\"id\";s:4:\"2464\";s:5:\"width\";s:2:\"64\";s:6:\"height\";s:2:\"64\";s:9:\"thumbnail\";s:75:\"https://mobile.parskalas.com/wp-content/uploads/2022/08/digital-favicon.png\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:15:\"digital-favicon\";s:11:\"description\";s:0:\"\";}s:14:\"favicon_retina\";a:8:{s:3:\"url\";s:75:\"https://mobile.parskalas.com/wp-content/uploads/2022/08/digital-favicon.png\";s:2:\"id\";s:4:\"2464\";s:5:\"width\";s:2:\"64\";s:6:\"height\";s:2:\"64\";s:9:\"thumbnail\";s:75:\"https://mobile.parskalas.com/wp-content/uploads/2022/08/digital-favicon.png\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:15:\"digital-favicon\";s:11:\"description\";s:0:\"\";}s:13:\"prk_preloader\";s:1:\"0\";s:14:\"preloader_type\";s:8:\"rotating\";s:18:\"prk_preloader_back\";s:0:\"\";s:19:\"prk_preloader_color\";s:0:\"\";s:17:\"prk_preloader_img\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:22:\"prk_preloader_img_size\";a:2:{s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";}s:24:\"prk_preloader_img_margin\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:14:\"google_api_key\";s:0:\"\";s:15:\"prk_topbar_true\";s:1:\"1\";s:16:\"prk_chose_topbar\";s:7:\"default\";s:15:\"prk_top_gif_img\";s:0:\"\";s:19:\"prk_top_gif_img_mob\";s:0:\"\";s:15:\"prk_top_gif_url\";s:1:\"#\";s:17:\"prk_topbar_stikey\";s:1:\"1\";s:13:\"gust_home_top\";s:1:\"0\";s:16:\"gust_top_desctop\";s:1:\"1\";s:15:\"prk_topbar_text\";s:57:\"قیمت و موجودی سایت بروز می باشد!\";s:21:\"prk_topbar_text_color\";s:7:\"#FDFDFD\";s:22:\"prk_topbar_text_center\";s:1:\"1\";s:19:\"prk_topbar_bg_color\";s:7:\"#0a3dc9\";s:17:\"prk_topbar_bg_img\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:16:\"prk_topbar_close\";s:1:\"0\";s:16:\"prk_topbar_blink\";s:1:\"0\";s:21:\"prk_topbar_blink_text\";s:0:\"\";s:20:\"prk_topbar_blink_url\";s:0:\"\";s:22:\"prk_topbar_blink_color\";s:7:\"#E82E3D\";s:25:\"prk_topbar_blink_bg_color\";s:7:\"#ECEDEC\";s:11:\"theme-style\";s:8:\"parskala\";s:17:\"header_style_type\";s:7:\"default\";s:29:\"header_gradient_general_color\";a:10:{s:16:\"background-color\";s:0:\"\";s:25:\"background-gradient-color\";s:0:\"\";s:29:\"background-gradient-direction\";s:0:\"\";s:19:\"background-position\";s:0:\"\";s:17:\"background-repeat\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:17:\"background-origin\";s:0:\"\";s:15:\"background-clip\";s:0:\"\";s:21:\"background-blend-mode\";s:0:\"\";}s:13:\"site_continer\";a:3:{s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:21:\"site_continer_product\";a:3:{s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:12:\"max_continer\";a:2:{s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";}s:20:\"max_continer_product\";a:2:{s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";}s:5:\"fonts\";s:4:\"dana\";s:11:\"fonts_admin\";s:8:\"iransans\";s:18:\"select_numer_count\";s:5:\"numfa\";s:11:\"custom_font\";s:0:\"\";s:16:\"theme_font_woff2\";s:0:\"\";s:15:\"theme_font_woff\";s:0:\"\";s:14:\"theme_font_ttf\";s:0:\"\";s:14:\"theme_font_eot\";s:0:\"\";s:14:\"theme_font_svg\";s:0:\"\";s:16:\"custom_bold_font\";s:0:\"\";s:21:\"theme_font_bold_woff2\";s:0:\"\";s:20:\"theme_font_bold_woff\";s:0:\"\";s:19:\"theme_font_bold_ttf\";s:0:\"\";s:19:\"theme_font_bold_eot\";s:0:\"\";s:19:\"theme_font_bold_svg\";s:0:\"\";s:24:\"prk_topbar_heading_texed\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"16\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:12:\"menu_heading\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:2:\"15\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:22:\"menu_heading_categoris\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:34:\"menu_heading_categoris_sub_title_1\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:33:\"menu_heading_megamenu_sub_title_1\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:14:\"heading_search\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:2:\"15\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:7:\"#212121\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:20:\"heading_account_text\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:2:\"16\";s:11:\"line-height\";s:2:\"34\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:27:\"heading_account_icon_before\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:17:\"heading_card_icon\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:28:\"section_product_off_title_v2\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:24:\"section_product_price_v2\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:33:\"section_product_off_price_sale_v2\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:28:\"section_product_off_timer_v2\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:28:\"section_product_off_title_v1\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:24:\"section_product_price_v1\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:33:\"section_product_off_price_sale_v1\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:28:\"section_product_off_timer_v1\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:25:\"section_post_title_modern\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:26:\"section_product_head_title\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:21:\"section_product_title\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:21:\"section_product_price\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:26:\"section_product_price_sale\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:20:\"single_product_title\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:26:\"single_product_title_latin\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:26:\"single_product_title_seler\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:25:\"single_product_icon_seler\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:32:\"single_product_add_to_cart_title\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:32:\"single_product_attributes_titles\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:31:\"single_product_attributes_texts\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:29:\"single_product_services_texts\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:36:\"single_product_releted_product_texts\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:27:\"single_product_ws_tabs_icon\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:28:\"single_product_ws_tabs_texts\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:20:\"footer_connect_texts\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:17:\"footer_title_menu\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:16:\"footer_text_menu\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:17:\"footer_text_about\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:21:\"footer_text_copyright\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:17:\"pragraf_text_post\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:22:\"gradient_general_color\";a:10:{s:16:\"background-color\";s:7:\"#2861ef\";s:25:\"background-gradient-color\";s:7:\"#0043ef\";s:29:\"background-gradient-direction\";s:6:\"135deg\";s:19:\"background-position\";s:0:\"\";s:17:\"background-repeat\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:17:\"background-origin\";s:0:\"\";s:15:\"background-clip\";s:0:\"\";s:21:\"background-blend-mode\";s:0:\"\";}s:13:\"general_color\";s:7:\"#094aef\";s:14:\"general_color2\";s:7:\"#dd2a2a\";s:13:\"general_links\";s:7:\"#0071e3\";s:12:\"header_color\";s:0:\"\";s:17:\"header_text_color\";s:0:\"\";s:18:\"header_color_cart1\";s:7:\"#4e4e4e\";s:21:\"header_color_cart_dot\";s:0:\"\";s:22:\"header_color_icon_menu\";s:7:\"#545d6e\";s:27:\"header_color_icon_menu_text\";s:7:\"#b4b4b4\";s:18:\"header_color_user1\";s:7:\"#4e4e4e\";s:18:\"header_color_call1\";s:7:\"#4e4e4e\";s:10:\"menu_color\";s:0:\"\";s:14:\"menu_sub_color\";s:0:\"\";s:15:\"menu_text_color\";s:0:\"\";s:12:\"footer_color\";s:0:\"\";s:17:\"footer_text_color\";s:0:\"\";s:14:\"prk_addressbar\";s:7:\"#094aef\";s:14:\"prk_body_color\";s:7:\"#ffffff\";s:18:\"prk_location_color\";s:0:\"\";s:14:\"animated_color\";s:7:\"#3b6eef\";s:16:\"prk_scroll_color\";s:0:\"\";s:17:\"prk_borline_color\";s:0:\"\";s:17:\"iconfont_selected\";a:2:{i:0;s:10:\"Remix_icon\";i:1;s:9:\"isax_icon\";}s:9:\"like_icon\";s:9:\"prk-heart\";s:15:\"like_icon_after\";s:10:\"prk-heart1\";s:10:\"share_icon\";s:14:\"flaticon-share\";s:12:\"compare_icon\";s:19:\"prk-slider-vertical\";s:10:\"chart_icon\";s:11:\"prk-diagram\";s:10:\"video_icon\";s:8:\"prk-play\";s:9:\"ques_icon\";s:20:\"prk-message-question\";s:11:\"seller_icon\";s:8:\"prk-shop\";s:9:\"gard_icon\";s:15:\"prk-shield-tick\";s:12:\"zemanat_icon\";s:21:\"prk-percentage-circle\";s:9:\"stok_icon\";s:0:\"\";s:17:\"prk_modern_mobile\";s:1:\"1\";s:26:\"modern_mobile_fixed_header\";s:1:\"1\";s:18:\"modern_mobile_icon\";s:1:\"1\";s:23:\"modern_mobile_icon_text\";s:16:\"prk-call-calling\";s:27:\"modern_mobile_left_icon_url\";s:15:\"tel:02191306517\";s:21:\"modern_mobile_toolbar\";s:1:\"1\";s:16:\"prk_toolbar_menu\";a:5:{i:0;a:5:{s:4:\"text\";s:8:\"خانه\";s:9:\"show_text\";s:1:\"1\";s:4:\"icon\";s:8:\"prk-home\";s:3:\"url\";s:28:\"https://mobile.parskalas.com\";s:5:\"color\";s:0:\"\";}i:1;a:5:{s:4:\"text\";s:10:\"جستجو\";s:9:\"show_text\";s:1:\"1\";s:4:\"icon\";s:19:\"prk-search-normal-1\";s:3:\"url\";s:35:\"https://mobile.parskalas.com/search\";s:5:\"color\";s:0:\"\";}i:2;a:5:{s:4:\"text\";s:21:\"دسته بندیها\";s:9:\"show_text\";s:1:\"1\";s:4:\"icon\";s:13:\"prk-category1\";s:3:\"url\";s:33:\"https://mobile.parskalas.com/shop\";s:5:\"color\";s:7:\"#08c96f\";}i:3;a:5:{s:4:\"text\";s:15:\"سبد خرید\";s:9:\"show_text\";s:1:\"1\";s:4:\"icon\";s:17:\"prk-shopping-cart\";s:3:\"url\";s:33:\"https://mobile.parskalas.com/cart\";s:5:\"color\";s:0:\"\";}i:4;a:5:{s:4:\"text\";s:21:\"حساب کاربری\";s:9:\"show_text\";s:1:\"1\";s:4:\"icon\";s:8:\"prk-user\";s:3:\"url\";s:39:\"https://mobile.parskalas.com/my-account\";s:5:\"color\";s:0:\"\";}}s:28:\"modern_mobile_second_toolbar\";s:1:\"1\";s:24:\"prk_toolbar_seconds_menu\";a:4:{i:0;a:7:{s:4:\"text\";s:17:\"فروش ویژه\";s:9:\"show_text\";s:1:\"1\";s:4:\"icon\";s:19:\"prk-ticket-discount\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#f30a49\";s:4:\"type\";s:5:\"paged\";s:4:\"back\";s:9:\"#f30a4926\";}i:1;a:7:{s:4:\"text\";s:14:\"فروشگاه\";s:9:\"show_text\";s:1:\"1\";s:4:\"icon\";s:8:\"prk-shop\";s:3:\"url\";s:33:\"https://mobile.parskalas.com/shop\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:6:\"iconed\";s:4:\"back\";s:0:\"\";}i:2;a:7:{s:4:\"text\";s:10:\"مقاله\";s:9:\"show_text\";s:1:\"1\";s:4:\"icon\";s:12:\"prk-document\";s:3:\"url\";s:33:\"https://mobile.parskalas.com/blog\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:6:\"iconed\";s:4:\"back\";s:0:\"\";}i:3;a:7:{s:4:\"text\";s:18:\"تماس با ما\";s:9:\"show_text\";s:1:\"1\";s:4:\"icon\";s:8:\"prk-call\";s:3:\"url\";s:15:\"tel:02191306517\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:6:\"iconed\";s:4:\"back\";s:0:\"\";}}s:26:\"modern_mobile_toolbar_blur\";s:1:\"1\";s:15:\"prk_socials_box\";s:1:\"1\";s:16:\"prk_socials_item\";a:5:{i:0;a:4:{s:4:\"text\";s:8:\"ایتا\";s:4:\"icon\";s:9:\"prk-eitaa\";s:3:\"url\";s:1:\"#\";s:5:\"color\";s:0:\"\";}i:1;a:4:{s:4:\"text\";s:6:\"بله\";s:4:\"icon\";s:8:\"prk-bale\";s:3:\"url\";s:1:\"#\";s:5:\"color\";s:0:\"\";}i:2;a:4:{s:4:\"text\";s:8:\"سروش\";s:4:\"icon\";s:11:\"prk-soroush\";s:3:\"url\";s:1:\"#\";s:5:\"color\";s:0:\"\";}i:3;a:4:{s:4:\"text\";s:12:\"آپارات\";s:4:\"icon\";s:10:\"prk-aparat\";s:3:\"url\";s:1:\"#\";s:5:\"color\";s:0:\"\";}i:4;a:4:{s:4:\"text\";s:4:\"گپ\";s:4:\"icon\";s:7:\"prk-gap\";s:3:\"url\";s:1:\"#\";s:5:\"color\";s:0:\"\";}}s:23:\"mobile-header-backcolor\";s:4:\"#fff\";s:25:\"mobile-header-color-icons\";s:7:\"#162C5B\";s:25:\"mobile-header-color-texts\";s:7:\"#666666\";s:30:\"mobile-header-typography-texts\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:11:\"header_type\";s:7:\"default\";s:18:\"fixed_header_mobit\";s:0:\"\";s:13:\"choice_header\";s:0:\"\";s:18:\"rgbaback_line_true\";s:0:\"\";s:12:\"promote_true\";s:1:\"1\";s:17:\"promote_link_type\";s:4:\"link\";s:17:\"promote_page_icon\";s:19:\"prk-ticket-discount\";s:23:\"promote_page_icon_color\";s:9:\"#f30a4952\";s:22:\"promote_page_backcolor\";s:9:\"#f30a4926\";s:18:\"promote_page_title\";s:17:\"فروش ویژه\";s:12:\"promote_page\";s:96:\"https://mobile.parskalas.com/product-category/%d9%81%d8%b1%d9%88%d8%b4-%d9%88%db%8c%da%98%d9%87/\";s:12:\"get_location\";s:1:\"1\";s:9:\"call_true\";s:1:\"1\";s:9:\"call_page\";s:15:\"tel:09167971886\";s:9:\"call_icon\";s:16:\"prk-call-calling\";s:18:\"header_sticky_menu\";s:1:\"1\";s:4:\"logo\";a:8:{s:3:\"url\";s:70:\"https://mobile.parskalas.com/wp-content/uploads/2022/08/parstypr-1.png\";s:2:\"id\";s:4:\"2578\";s:5:\"width\";s:3:\"395\";s:6:\"height\";s:3:\"175\";s:9:\"thumbnail\";s:78:\"https://mobile.parskalas.com/wp-content/uploads/2022/08/parstypr-1-150x150.png\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:8:\"parstypr\";s:11:\"description\";s:0:\"\";}s:13:\"logo_animated\";s:0:\"\";s:11:\"logo_mobile\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:9:\"logo_menu\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:11:\"logo_size_s\";a:2:{s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";}s:9:\"logo_size\";a:2:{s:5:\"width\";s:3:\"175\";s:6:\"height\";s:0:\"\";}s:11:\"logo_margin\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:15:\"logo_margin_mob\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:18:\"prk_text_icon_menu\";s:1:\"1\";s:17:\"menu_mobile_model\";s:6:\"modern\";s:14:\"header_account\";s:1:\"1\";s:21:\"prk_account_bg_border\";s:2:\"11\";s:24:\"prk_account_bg_backcolor\";s:0:\"\";s:24:\"header_icon_users_before\";s:16:\"flaticon-user-14\";s:23:\"header_icon_users_after\";s:16:\"flaticon-user-14\";s:19:\"header_account_type\";s:8:\"dropdown\";s:32:\"header_account_text_before_login\";s:24:\"ورود / ثبت نام\";s:15:\"header_minicart\";s:1:\"1\";s:17:\"header_btn_sticky\";s:0:\"\";s:21:\"headers_minicart_type\";s:4:\"icon\";s:21:\"headers_minicart_icon\";s:17:\"prk-shopping-cart\";s:20:\"headers_minicart_img\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:20:\"header_minicart_type\";s:8:\"dropdown\";s:18:\"header_search_true\";s:1:\"1\";s:23:\"prk_style_search_viewed\";s:8:\"carousel\";s:20:\"prk_search_bg_border\";s:2:\"11\";s:23:\"prk_search_bg_backcolor\";s:0:\"\";s:26:\"prk_header_search_bg_color\";s:0:\"\";s:30:\"prk_header_search_result_color\";s:0:\"\";s:33:\"prk_header_search_bg_color_submit\";s:0:\"\";s:18:\"search_placeholder\";s:56:\"جستجو در بین 1500 محصول تخفیف دار\";s:16:\"better_seardched\";a:4:{i:0;a:1:{s:14:\"searched_title\";s:24:\"گوشی و موبایل\";}i:1;a:1:{s:14:\"searched_title\";s:10:\"آیفون\";}i:2;a:1:{s:14:\"searched_title\";s:13:\"اپل واچ\";}i:3;a:1:{s:14:\"searched_title\";s:21:\"مک بوک سری ۸\";}}s:17:\"img_banner_search\";a:8:{s:3:\"url\";s:65:\"https://mobile.parskalas.com/wp-content/uploads/2022/08/pages.jpg\";s:2:\"id\";s:4:\"2353\";s:5:\"width\";s:4:\"1125\";s:6:\"height\";s:3:\"480\";s:9:\"thumbnail\";s:73:\"https://mobile.parskalas.com/wp-content/uploads/2022/08/pages-150x150.jpg\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:5:\"pages\";s:11:\"description\";s:0:\"\";}s:17:\"url_banner_search\";s:3:\"###\";s:19:\"prk_filter_location\";s:1:\"1\";s:25:\"filter_location_btn_title\";s:21:\"انتخاب مکان\";s:28:\"filter_location_btn_subtitle\";s:17:\"فیلتر شهر\";s:29:\"prk_filter_location_pop_title\";s:42:\"فیلتر بر اساس شهر محصول\";s:32:\"prk_filter_location_search_title\";s:26:\"جستجو در شهرها\";s:27:\"prk_filter_location_allcity\";s:17:\"همه شهرها\";s:28:\"prk_filter_location_sallcity\";s:19:\"همه شهرهای\";s:30:\"prk_filter_location_selectcity\";s:49:\"حداقل یک شهر را انتخاب کنید\";s:12:\"blacki_trure\";s:0:\"\";s:16:\"prk_borline_menu\";s:1:\"1\";s:19:\"prk_hover_menu_item\";s:0:\"\";s:10:\"call_true1\";s:0:\"\";s:16:\"call_page1_title\";s:45:\"سوالی دارید؟ تماس بگیرید\";s:15:\"call_page1_pish\";s:3:\"021\";s:11:\"call_pagee1\";s:10:\"-913087786\";s:10:\"call_icon1\";s:16:\"prk-call-calling\";s:17:\"tab_side_sub_menu\";a:3:{s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:13:\"tab_sub_menud\";a:3:{s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:17:\"hider_header_form\";s:1:\"1\";s:17:\"hider_footer_form\";s:0:\"\";s:20:\"logined_before_order\";s:0:\"\";s:16:\"chose_form_login\";s:8:\"sms_form\";s:16:\"form_login_style\";s:7:\"default\";s:17:\"logo_sms_form_def\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:21:\"logo_sms_form_style_2\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:31:\"gradient_sms_form_style_2_color\";a:11:{s:16:\"background-color\";s:0:\"\";s:25:\"background-gradient-color\";s:0:\"\";s:29:\"background-gradient-direction\";s:0:\"\";s:16:\"background-image\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:19:\"background-position\";s:0:\"\";s:17:\"background-repeat\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:17:\"background-origin\";s:0:\"\";s:15:\"background-clip\";s:0:\"\";s:21:\"background-blend-mode\";s:0:\"\";}s:13:\"logo_sms_form\";s:2:\"16\";s:27:\"prk_login_form_default_role\";s:8:\"customer\";s:17:\"pre_user_rej_name\";s:21:\"کاربر گرامی\";s:41:\"prk_order_status_after_save_tracking_post\";s:9:\"completed\";s:24:\"gateway_sms_pattern_code\";s:0:\"\";s:18:\"prk_notify_product\";s:1:\"1\";s:40:\"gateway_sms_pattern_code_instock_product\";s:0:\"\";s:40:\"gateway_sms_pattern_code_amazing_product\";s:0:\"\";s:15:\"chose_panel_sms\";s:5:\"smsir\";s:18:\"prk_sms_info_admin\";s:0:\"\";s:20:\"gateway_sms_username\";s:7:\"masirwp\";s:20:\"gateway_sms_password\";s:12:\"Hosein##1887\";s:24:\"gateway_sms_panel_number\";s:0:\"\";s:25:\"gateway_sms_panel_api_key\";s:64:\"7UaTZHCFYykaNFE5Vqdnyvhzg64WR1L7sFD0Bbm8ugQkUccdLo14wF8dZWAhAsXq\";s:20:\"prk_sms_phonebook_id\";s:0:\"\";s:24:\"gateway_sms_count_number\";s:1:\"4\";s:36:\"gateway_sms_count_number_expire_time\";s:3:\"120\";s:22:\"gateway_expire_Session\";s:1:\"2\";s:12:\"login_method\";s:4:\"both\";s:15:\"email_otp_title\";s:21:\"ایمیل تایید\";s:17:\"email_otp_content\";s:77:\"کاربر عزیز ، کد تایید ایمیل شما {code} میباشد.\";s:13:\"login_process\";s:4:\"both\";s:20:\"prk_story_Activation\";s:4:\"true\";s:6:\"render\";s:6:\"client\";s:5:\"style\";s:9:\"instagram\";s:11:\"full_screen\";s:0:\"\";s:12:\"video_silent\";s:0:\"\";s:11:\"story_timer\";s:0:\"\";s:20:\"single_stories_timer\";s:1:\"1\";s:20:\"public_stories_timer\";s:1:\"1\";s:16:\"story_time_value\";s:1:\"1\";s:21:\"story_background_type\";s:6:\"normal\";s:8:\"story_bg\";s:7:\"#1a1a1a\";s:14:\"story_gradient\";a:2:{s:7:\"color-1\";s:7:\"#647dee\";s:7:\"color-2\";s:7:\"#7f53ac\";}s:15:\"full_size_media\";s:0:\"\";s:12:\"swipe_button\";s:0:\"\";s:22:\"button_background_type\";s:6:\"normal\";s:9:\"button_bg\";s:16:\"rgba(0, 0, 0, 1)\";s:15:\"button_gradient\";a:2:{s:7:\"color-1\";s:7:\"#647dee\";s:7:\"color-2\";s:7:\"#7f53ac\";}s:10:\"text_color\";s:7:\"#ffffff\";s:9:\"font_size\";s:2:\"16\";s:14:\"button_padding\";a:2:{s:5:\"width\";s:2:\"12\";s:6:\"height\";s:2:\"24\";}s:13:\"button_radius\";s:1:\"5\";s:14:\"cycle_position\";s:4:\"auto\";s:21:\"cycle_background_type\";s:8:\"gradient\";s:8:\"cycle_bg\";s:0:\"\";s:14:\"cycle_gradient\";a:2:{s:7:\"color-1\";s:7:\"#ee583f\";s:7:\"color-2\";s:7:\"#bd3381\";}s:11:\"title_color\";s:4:\"#000\";s:19:\"posts_story_options\";s:1:\"1\";s:6:\"opener\";s:0:\"\";s:11:\"factor_pars\";s:1:\"1\";s:6:\"f_name\";s:49:\"فروشگاه اینترنتی پارس کالا\";s:9:\"fsub_name\";s:0:\"\";s:6:\"f_logo\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:8:\"f_states\";s:14:\"خوزستان\";s:7:\"f_citys\";s:10:\"اهواز\";s:9:\"f_address\";s:54:\"اهواز خیابان کیانپارس شمالی 13\";s:9:\"f_zipcode\";s:11:\"64659900000\";s:15:\"f_company_email\";s:17:\"info@parskalas.ir\";s:16:\"f_company_number\";s:9:\"061535990\";s:14:\"f_company_code\";s:5:\"12345\";s:10:\"f_codesabt\";s:4:\"9856\";s:6:\"f_size\";s:2:\"A4\";s:11:\"f_show_logo\";s:1:\"1\";s:24:\"prk_billing_ncode_factor\";s:1:\"1\";s:25:\"prk_billing_customer_note\";s:1:\"1\";s:21:\"prk_ncode_factor_meta\";s:13:\"billing_ncode\";s:9:\"f_preview\";s:1:\"1\";s:15:\"f_thankyou_link\";s:1:\"1\";s:12:\"f_imgproduct\";s:1:\"1\";s:11:\"f_getfactor\";s:1:\"1\";s:9:\"f_barcode\";s:1:\"1\";s:7:\"f_title\";s:1:\"1\";s:14:\"f_costom_title\";s:0:\"\";s:9:\"f_Letters\";s:0:\"\";s:18:\"f_discount_percent\";s:0:\"\";s:10:\"label_logo\";s:1:\"1\";s:13:\"label_address\";s:1:\"1\";s:13:\"label_website\";s:1:\"1\";s:13:\"label_Pmethod\";s:1:\"1\";s:16:\"label_send_order\";s:1:\"1\";s:18:\"label_order_number\";s:1:\"1\";s:16:\"label_date_print\";s:1:\"1\";s:31:\"prk_billing_customer_note_label\";s:1:\"1\";s:13:\"f_note_footer\";s:193:\"یاداشت سفارش: این سفارش جهت تست فاکتور قالب پارس کالا ثبت شده است و به راحتی در تنظیمات قالب قابل تغییر است.\";s:11:\"f_show_sign\";s:0:\"\";s:14:\"f_seller_stamp\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:12:\"f_seller_sgn\";s:35:\"مهر و امضای فروشگاه\";s:11:\"f_order_sgn\";s:33:\"مهر و امضای خریدار\";s:18:\"style_product_page\";s:7:\"default\";s:15:\"show_sticky_add\";s:0:\"\";s:23:\"show_breadcrumb_product\";s:1:\"1\";s:20:\"show_variation_stock\";s:1:\"1\";s:20:\"show_sticky_add_blur\";s:0:\"\";s:21:\"show_sticky_add_width\";s:3:\"100\";s:29:\"prk_increase_max_variation_wc\";s:2:\"50\";s:21:\"prk_show_prod_up_date\";s:0:\"\";s:22:\"prk_tab_content_styles\";s:10:\"mobile_tab\";s:15:\"show_wolfnotify\";s:1:\"1\";s:24:\"show_wolfnotify_title_op\";s:0:\"\";s:27:\"show_wolfnotify_title_email\";s:50:\"محصول مورد نظر شما موجود شد.\";s:29:\"show_wolfnotify_content_email\";s:61:\"کاربر عزیز محصول {productname} موجود شد.\";s:25:\"single_product_text_price\";s:21:\"تماس بگیرید\";s:14:\"prk_zoom_image\";s:1:\"1\";s:12:\"feed_product\";s:1:\"1\";s:14:\"better_product\";s:1:\"0\";s:8:\"ajax_add\";s:1:\"1\";s:20:\"ajax_added_cart_text\";s:63:\"محصول مورد نظر به سبد خرید اضافه شد\";s:21:\"ajax_added_cart_model\";s:6:\"modern\";s:22:\"ajax_cart_confirm_text\";s:14:\"سبدخرید\";s:21:\"ajax_cart_cancel_text\";s:19:\"ادامه خرید\";s:21:\"single_product_seller\";s:1:\"0\";s:31:\"single_product_seller_preloader\";s:1:\"0\";s:23:\"single_product_Warranty\";s:1:\"1\";s:23:\"single_texts_Warrantyss\";s:44:\"گارانتی 18 ماهه پارس کالا\";s:20:\"single_product_stock\";s:1:\"1\";s:19:\"single_product_bail\";s:1:\"0\";s:24:\"single_product_bail_text\";s:30:\"ضمانت اصالت کالا\";s:16:\"quantity_product\";s:1:\"1\";s:17:\"single_hamta_show\";s:1:\"1\";s:17:\"single_hamta_text\";s:351:\"هشدار سامانه همتا: حتما در زمان تحویل دستگاه، به کمک کد فعال‌سازی چاپ شده روی جعبه یا کارت گارانتی، دستگاه را از طریق #7777*، برای سیم‌کارت خود فعال‌سازی کنید. آموزش تصویری در آدرس اینترنتی hmti.ir/05\";s:19:\"single_product_send\";s:1:\"0\";s:25:\"single_product_send_title\";s:37:\"ارسال توسط پارس کالا\";s:24:\"single_product_send_text\";s:277:\"این کالا پس از مدت زمان مشخص شده توسط فروشنده در انبار فروشگاه اینترنتی پارس کالا تامین و آماده پردازش می‌گردد و توسط پیک در بازه انتخابی ارسال خواهد شد.\";s:30:\"posts_per_page_related_product\";s:2:\"10\";s:25:\"out_stock_related_product\";s:1:\"1\";s:24:\"small_title_show_product\";s:1:\"1\";s:23:\"prk_tag_product_viewed1\";s:0:\"\";s:22:\"sub_title_show_product\";s:1:\"1\";s:25:\"information_product_title\";s:12:\"مشخصات\";s:23:\"display_advanced_review\";s:2:\"on\";s:29:\"global_options_ratings_review\";a:4:{i:0;a:2:{s:5:\"title\";s:19:\"کیفیت ساخت\";s:4:\"slug\";s:12:\"Quality_rate\";}i:1;a:2:{s:5:\"title\";s:40:\"ارزش خرید به نسبت قیمت\";s:4:\"slug\";s:10:\"price_rate\";}i:2;a:2:{s:5:\"title\";s:35:\"امکانات و قابلیت ها\";s:4:\"slug\";s:13:\"Property_rate\";}i:3;a:2:{s:5:\"title\";s:25:\"سهولت استفاده\";s:4:\"slug\";s:9:\"ease_rate\";}}s:17:\"comment_recommend\";s:0:\"\";s:12:\"comment_text\";s:1855:\"پارس کالا: لطفا پیش از ارسال نظر، خلاصه قوانین زیر را مطالعه کنید: فارسی بنویسید و از کیبورد فارسی استفاده کنید. بهتر است از فضای خالی (Space) بیش‌از‌حدِ معمول، شکلک یا ایموجی استفاده نکنید و از کشیدن حروف یا کلمات با صفحه‌کلید بپرهیزید. نظرات خود را براساس تجربه و استفاده‌ی عملی و با دقت به نکات فنی ارسال کنید؛ بدون تعصب به محصول خاص، مزایا و معایب را بازگو کنید و بهتر است از ارسال نظرات چندکلمه‌‌ای خودداری کنید. بهتر است در نظرات خود از تمرکز روی عناصر متغیر مثل قیمت، پرهیز کنید. به کاربران و سایر اشخاص احترام بگذارید. پیام‌هایی که شامل محتوای توهین‌آمیز و کلمات نامناسب باشند، حذف می‌شوند. از ارسال لینک‌های سایت‌های دیگر و ارایه‌ی اطلاعات شخصی خودتان مثل شماره تماس، ایمیل و آی‌دی شبکه‌های اجتماعی پرهیز کنید. با توجه به ساختار بخش نظرات، از پرسیدن سوال یا درخواست راهنمایی در این بخش خودداری کرده و سوالات خود را در بخش «پرسش و پاسخ» مطرح کنید. هرگونه نقد و نظر در خصوص سایت فروشگاه ما، خدمات و درخواست کالا را با ایمیل info@yourdomain.com یا با شماره‌ی ۰۰۰۰ - ۰۲۱ در میان بگذارید و از نوشتن آن‌ها در بخش نظرات خودداری کنید.\";s:18:\"single_product_faq\";s:1:\"1\";s:25:\"single_product_attributes\";s:1:\"1\";s:24:\"product_attributes_title\";s:28:\"ویژگی های محصول\";s:24:\"product_attributes_count\";s:1:\"6\";s:24:\"cattributes_product_tabs\";s:0:\"\";s:30:\"title_cattributes_product_tabs\";s:12:\"مشخصات\";s:33:\"title_cattributes_product_content\";s:21:\"مشخصات کالا\";s:12:\"show_related\";s:1:\"9\";s:22:\"single_product_orginal\";s:1:\"1\";s:18:\"single_product_sku\";s:1:\"1\";s:13:\"product_brand\";s:1:\"1\";s:20:\"single_product_brand\";s:1:\"1\";s:18:\"show_brand_product\";s:1:\"1\";s:18:\"product_brand_slug\";s:5:\"brand\";s:18:\"product_brand_name\";s:8:\"برند\";s:21:\"single_product_sendes\";s:1:\"1\";s:18:\"product_sendes_img\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:23:\"single_product_services\";s:1:\"1\";s:22:\"single_product_top_bio\";s:0:\"\";s:18:\"single_product_bio\";s:1:\"1\";s:22:\"single_product_bio_img\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:23:\"single_product_whislist\";s:1:\"1\";s:20:\"single_product_share\";s:1:\"1\";s:20:\"single_product_vidoe\";s:1:\"1\";s:26:\"single_product_compare_btn\";s:1:\"1\";s:25:\"single_product_prk_chartp\";s:1:\"1\";s:18:\"single_product_ask\";s:1:\"1\";s:21:\"special_send_box_true\";s:1:\"1\";s:21:\"general_send_box_text\";s:30:\"شرایط ارسال کالا\";s:20:\"general_send_box_url\";s:1:\"#\";s:24:\"special_send_box_product\";a:2:{i:0;a:2:{s:13:\"send_box_text\";s:65:\"ارسال از انبار تهران: 1 الی 2 روز کاری\";s:12:\"send_box_url\";s:1:\"#\";}i:1;a:2:{s:13:\"send_box_text\";s:60:\"ارسال از انبار اصفهان: تحویل فوری\";s:12:\"send_box_url\";s:1:\"#\";}}s:15:\"send_box_border\";a:6:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:7:\"#e8e8e8\";}s:13:\"send_box_icon\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:9:\"shop_name\";s:0:\"\";s:16:\"is_featured_shop\";s:0:\"\";s:13:\"dokan_consent\";s:2:\"96\";s:12:\"dokan_supply\";s:2:\"89\";s:16:\"dokan_Commitment\";s:2:\"91\";s:15:\"dokan_reference\";s:2:\"87\";s:15:\"shop_registered\";s:8:\"1 سال\";s:12:\"stills_types\";s:5:\"great\";s:22:\"border_radius_info_box\";s:2:\"11\";s:27:\"max_continer_img_single_pro\";a:2:{s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";}s:25:\"prk_background_single_pro\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:19:\"background-position\";s:0:\"\";s:17:\"background-repeat\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:15:\"background-size\";s:0:\"\";}s:25:\"gradient_info_box_product\";a:10:{s:16:\"background-color\";s:0:\"\";s:25:\"background-gradient-color\";s:0:\"\";s:29:\"background-gradient-direction\";s:0:\"\";s:19:\"background-position\";s:0:\"\";s:17:\"background-repeat\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:17:\"background-origin\";s:0:\"\";s:15:\"background-clip\";s:0:\"\";s:21:\"background-blend-mode\";s:0:\"\";}s:23:\"border_info_box_product\";s:0:\"\";s:22:\"color_info_box_product\";s:0:\"\";s:25:\"back_add_cart_btn_product\";a:10:{s:16:\"background-color\";s:0:\"\";s:25:\"background-gradient-color\";s:0:\"\";s:29:\"background-gradient-direction\";s:0:\"\";s:19:\"background-position\";s:0:\"\";s:17:\"background-repeat\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:17:\"background-origin\";s:0:\"\";s:15:\"background-clip\";s:0:\"\";s:21:\"background-blend-mode\";s:0:\"\";}s:26:\"color_add_cart_btn_product\";s:0:\"\";s:27:\"shadow_add_cart_btn_product\";s:0:\"\";s:15:\"Conditions_page\";s:0:\"\";s:23:\"prk_myaccount_downloads\";s:1:\"1\";s:23:\"prk_myaccount_whishlist\";s:0:\"\";s:19:\"prk_myaccount_notif\";s:1:\"1\";s:23:\"myaccount_whishlist_sec\";s:1:\"1\";s:28:\"myaccount_whishlist_sec_text\";s:27:\"از لیست های شما\";s:29:\"myaccount_whishlist_lastviewd\";s:1:\"1\";s:28:\"myaccount_lastviewd_sec_text\";s:43:\"محصولات مشاهده شده اخیر\";s:22:\"single_product_compare\";s:1:\"1\";s:12:\"compare_page\";s:3:\"886\";s:22:\"prk_gattributes_enable\";s:1:\"1\";s:30:\"enableAttributeGroupCategories\";s:1:\"1\";s:26:\"multipleAttributesInGroups\";s:1:\"0\";s:10:\"showWeight\";s:1:\"1\";s:14:\"showDimensions\";s:1:\"1\";s:8:\"moreText\";s:21:\"مشخصات دیگر\";s:21:\"attributeValueDivider\";s:2:\", \";s:19:\"wc_size_guide_style\";s:110:\"https://mobile.parskalas.com/wp-content/themes/parskala/inc/prk-size-guide/assets/css/prk.sizeguide.style1.css\";s:18:\"wc_size_guide_hide\";s:2:\"no\";s:29:\"wc_size_guide_button_position\";s:20:\"prk-position-summary\";s:32:\"wc_size_guide_tab_multiple_table\";s:2:\"no\";s:26:\"wc_size_guide_button_label\";s:23:\"راهنمای سایز\";s:17:\"prk_shop_ajax_add\";s:1:\"1\";s:14:\"ajax_prod_auto\";s:1:\"1\";s:16:\"active_side_shop\";s:1:\"1\";s:13:\"sort_by_stock\";s:7:\"default\";s:12:\"show_sec_img\";s:1:\"1\";s:21:\"show_swatches_archive\";s:1:\"1\";s:21:\"swatches_archive_attr\";s:17:\"pa_chose-selector\";s:27:\"show_swatches_archive_title\";s:1:\"1\";s:29:\"enable_swatches_archive_count\";s:1:\"1\";s:22:\"swatches_archive_count\";s:1:\"4\";s:23:\"archive_product_orginal\";s:1:\"1\";s:27:\"archive_product_seller_name\";s:1:\"1\";s:21:\"archive_product_stock\";s:1:\"1\";s:12:\"product_rate\";s:1:\"1\";s:27:\"archive_product_thumbnail_2\";s:1:\"1\";s:27:\"archive_product_add_to_cart\";s:0:\"\";s:32:\"archive_product_add_to_cart_type\";s:4:\"icon\";s:32:\"archive_product_add_to_cart_icon\";s:17:\"prk-shopping-cart\";s:32:\"archive_product_add_to_cart_text\";s:24:\"افزودن به سبد\";s:33:\"archive_product_add_to_cart_color\";s:0:\"\";s:22:\"show_title_cat_archive\";s:1:\"1\";s:29:\"archive_product_subcategories\";s:0:\"\";s:32:\"archive_show_subcategories_title\";s:1:\"1\";s:35:\"archive_product_subcategories_title\";s:26:\"دسته‌بندی‌ها\";s:35:\"archive_product_subcategories_count\";s:1:\"1\";s:26:\"hide_product_subcategories\";s:0:\"\";s:35:\"archive_product_subcategories_style\";s:0:\"\";s:35:\"archive_product_subcategories_order\";s:11:\"top_sidebar\";s:19:\"border_sidebar_shop\";a:6:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:7:\"#e4e4e4\";}s:26:\"bcolor_subcategories_order\";s:0:\"\";s:18:\"border_radius_shop\";s:2:\"11\";s:19:\"bcolor_sidebar_shop\";s:0:\"\";s:18:\"title_sidebar_shop\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:22:\"prk_loop_style_product\";s:15:\"prk-item-style1\";s:24:\"prk_loop_columns_product\";s:1:\"4\";s:26:\"prk_products_per_page_loop\";s:2:\"20\";s:13:\"border_p_shop\";a:6:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:7:\"#E4E4E4\";}s:19:\"border_radius_pshop\";s:2:\"14\";s:13:\"bcolor_p_shop\";s:6:\"E4E4E4\";s:33:\"archive_product_description_order\";s:14:\"bottom_sidebar\";s:23:\"border_description_shop\";a:6:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:7:\"#e4e4e4\";}s:30:\"border_radius_description_shop\";s:2:\"11\";s:24:\"bcolor_sdescription_shop\";s:0:\"\";s:22:\"title_description_shop\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:23:\"checkout_product_styles\";s:6:\"style2\";s:20:\"checkout_header_hide\";s:1:\"1\";s:20:\"checkout_footer_hide\";s:0:\"\";s:12:\"logo_payment\";s:1:\"1\";s:20:\"prk_logo_payment_url\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:19:\"order_tracking_code\";s:0:\"\";s:25:\"order_tracking_code_title\";s:17:\"کد رهگیری\";s:21:\"checkout_manager_form\";s:0:\"\";s:34:\"prk_checkout_manager_form_callback\";s:0:\"\";s:17:\"checkout-delivery\";s:1:\"1\";s:17:\"required_day_send\";s:1:\"1\";s:23:\"prk_popup_send_delivery\";s:1:\"1\";s:23:\"popup_send_deliver_text\";s:43:\"انتخاب زمان تحویل سفارش\";s:28:\"checkout-delivery-icon-mobil\";s:13:\"ri-truck-line\";s:29:\"checkout-delivery-label-mobil\";s:43:\"انتخاب بازه زمانی تحویل\";s:26:\"checkout-delivery-label-pc\";s:32:\"انتخاب زمان تحویل\";s:14:\"delivery-dates\";a:6:{i:0;s:8:\"saturday\";i:1;s:6:\"sunday\";i:2;s:6:\"monday\";i:3;s:7:\"tuesday\";i:4;s:9:\"wednesday\";i:5;s:8:\"thursday\";}s:17:\"delivery-min-time\";s:1:\"4\";s:20:\"delivery-times-count\";s:1:\"5\";s:15:\"show_timer_send\";s:1:\"1\";s:19:\"required_timer_send\";s:1:\"1\";s:20:\"list_send_time_order\";s:0:\"\";s:12:\"checkout-map\";s:1:\"1\";s:20:\"checkout-map-address\";s:98:\"Azadi Square, District 9, Tehran, بخش مرکزی شهرستان تهران, Tehran County, Iran\";s:20:\"checkout-map-details\";a:3:{s:8:\"latitude\";s:2:\"20\";s:9:\"longitude\";s:1:\"0\";s:4:\"zoom\";s:1:\"2\";}s:23:\"border_radius_total_box\";s:2:\"11\";s:26:\"gradient_total_box_product\";a:8:{s:16:\"background-color\";s:0:\"\";s:25:\"background-gradient-color\";s:0:\"\";s:29:\"background-gradient-direction\";s:0:\"\";s:19:\"background-position\";s:0:\"\";s:17:\"background-repeat\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:17:\"background-origin\";s:0:\"\";}s:24:\"border_total_box_product\";s:0:\"\";s:23:\"color_total_box_product\";s:0:\"\";s:22:\"back_total_btn_product\";a:10:{s:16:\"background-color\";s:0:\"\";s:25:\"background-gradient-color\";s:0:\"\";s:29:\"background-gradient-direction\";s:0:\"\";s:19:\"background-position\";s:0:\"\";s:17:\"background-repeat\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:17:\"background-origin\";s:0:\"\";s:15:\"background-clip\";s:0:\"\";s:21:\"background-blend-mode\";s:0:\"\";}s:23:\"color_total_btn_product\";s:0:\"\";s:24:\"shadow_total_btn_product\";s:0:\"\";s:17:\"prk_order_tracker\";s:1:\"1\";s:16:\"title_ordertrack\";s:89:\"از این فرم جهت پیگیری وضعیت سفارش استفاده نمایید.\";s:23:\"order_tracker_myaccount\";s:1:\"1\";s:14:\"des_ordertrack\";s:124:\"می‌توانید به طور دقیق مراحل پردازش و ارسال سفارش خود را پیگیری کنید.\";s:19:\"des_ordertrack_set1\";s:20:\"در صف بررسی\";s:19:\"des_ordertrack_set2\";s:21:\"تایید سفارش\";s:19:\"des_ordertrack_set3\";s:32:\"آماده‌سازی سفارش\";s:19:\"des_ordertrack_set4\";s:35:\"خروج از مرکز پردازش\";s:19:\"des_ordertrack_set5\";s:33:\"تحویل شده به مشتری\";s:15:\"mini_cart_notie\";s:1:\"1\";s:21:\"mini_cart_title_notie\";s:23:\"یاداشت سفارش\";s:18:\"mini_cart_shipping\";s:1:\"1\";s:24:\"mini_cart_title_shipping\";s:38:\"انتخاب آدرس حمل و نقل\";s:16:\"mini_cart_coupon\";s:1:\"1\";s:22:\"mini_cart_title_coupon\";s:46:\"کوپن موجود را انتخاب کنید\";s:19:\"mini_cart_p_coupons\";s:0:\"\";s:21:\"mini_cart_total_price\";s:1:\"1\";s:24:\"mini_cart_shipping_price\";s:1:\"1\";s:23:\"mini_cart_shipping_free\";s:1:\"1\";s:20:\"free_shipping_effect\";s:1:\"1\";s:13:\"fake_purchase\";s:1:\"1\";s:25:\"fake_purchase_show_mobile\";s:0:\"\";s:16:\"fake_purchase_ct\";s:0:\"\";s:18:\"fake_purchase_posi\";s:9:\"tip-right\";s:19:\"fake_purchase_cocke\";s:2:\"12\";s:16:\"prk_faq_ajax_add\";s:1:\"1\";s:19:\"prk_search_ajax_box\";s:1:\"1\";s:17:\"title_faq_cat_box\";s:37:\"موضوع پرسش شما چیست؟\";s:20:\"subtitle_faq_cat_box\";s:115:\"موضوع موردنظرتان را جستجو کرده یا از دسته‌بندی زیر انتخاب کنید\";s:30:\"placeholder_search_faq_cat_box\";s:23:\"جستجوی موضوع\";s:18:\"gradient_faq_color\";a:11:{s:16:\"background-color\";s:0:\"\";s:25:\"background-gradient-color\";s:0:\"\";s:29:\"background-gradient-direction\";s:0:\"\";s:16:\"background-image\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:19:\"background-position\";s:0:\"\";s:17:\"background-repeat\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:17:\"background-origin\";s:0:\"\";s:15:\"background-clip\";s:0:\"\";s:21:\"background-blend-mode\";s:0:\"\";}s:8:\"faq_cats\";s:0:\"\";s:32:\"title_frequently_asked_questions\";s:38:\"پرتکرارترین پرسش‌ها\";s:26:\"frequently_asked_questions\";s:0:\"\";s:17:\"custom_post_thumb\";s:0:\"\";s:16:\"post_thumb_width\";s:3:\"300\";s:17:\"post_thumb_height\";s:3:\"300\";s:17:\"post_archive_name\";s:1:\"1\";s:16:\"post_archive_bio\";s:1:\"1\";s:32:\"archive_post_subcategories_order\";s:8:\"top_page\";s:22:\"grid_column_items_post\";s:1:\"4\";s:13:\"show_cat_post\";s:1:\"1\";s:21:\"post_archive_pcontent\";s:1:\"1\";s:19:\"post_archive_author\";s:1:\"1\";s:22:\"post_archive_show_view\";s:1:\"1\";s:17:\"post_archive_date\";s:1:\"1\";s:25:\"post_archive_time_reading\";s:1:\"1\";s:19:\"post_single_sidebar\";s:1:\"1\";s:18:\"post_single_author\";s:1:\"1\";s:20:\"post_single_tumbnail\";s:1:\"1\";s:25:\"site_post_single_tumbnail\";a:3:{s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:16:\"post_single_date\";s:1:\"1\";s:19:\"post_single_comment\";s:1:\"1\";s:24:\"post_single_time_reading\";s:1:\"1\";s:20:\"post_single_categors\";s:1:\"1\";s:16:\"post_single_tags\";s:1:\"1\";s:17:\"post_single_share\";s:1:\"1\";s:16:\"post_single_read\";s:1:\"1\";s:13:\"comment_Rules\";s:1:\"1\";s:22:\"comment_Rules_contents\";s:344:\"            <ol>\r\n                <li>دیدگاه های فینگلیش تایید نخواهند شد.</li>\r\n                <li>دیدگاه های نامرتبط به مطلب تایید نخواهد شد.</li>\r\n                <li>از درج دیدگاه های تکراری پرهیز نمایید.</li>\r\n             </ol>\r\n            \";s:20:\"border_comment_Rules\";a:6:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:19:\"rgba(89,214,235,.1)\";}s:24:\"background_comment_Rules\";a:11:{s:16:\"background-color\";s:0:\"\";s:25:\"background-gradient-color\";s:0:\"\";s:29:\"background-gradient-direction\";s:0:\"\";s:16:\"background-image\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:19:\"background-position\";s:0:\"\";s:17:\"background-repeat\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:17:\"background-origin\";s:0:\"\";s:15:\"background-clip\";s:0:\"\";s:21:\"background-blend-mode\";s:0:\"\";}s:24:\"color_comment_Rules_text\";s:0:\"\";s:26:\"border_sidebar_single_post\";a:6:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";s:5:\"style\";s:5:\"solid\";s:5:\"color\";s:7:\"#e4e4e4\";}s:25:\"border_radius_single_post\";s:2:\"11\";s:26:\"bcolor_sidebar_single_post\";s:0:\"\";s:25:\"title_sidebar_single_post\";a:12:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:6:\"subset\";s:0:\"\";s:10:\"text-align\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:5:\"color\";s:0:\"\";s:4:\"type\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:10:\"services_1\";s:23:\"تحویل اکسپرس\";s:13:\"subservices_1\";s:0:\"\";s:14:\"services_1_url\";s:1:\"#\";s:14:\"services_1_pic\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:10:\"services_2\";s:32:\"پشتیبانی ۲۴ ساعته\";s:13:\"subservices_2\";s:0:\"\";s:14:\"services_2_url\";s:1:\"#\";s:14:\"services_2_pic\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:10:\"services_3\";s:24:\"پرداخت در محل\";s:13:\"subservices_3\";s:0:\"\";s:14:\"services_3_url\";s:1:\"#\";s:14:\"services_3_pic\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:10:\"services_4\";s:42:\"۷ روز ضمانت بازگشت کالا\";s:13:\"subservices_4\";s:0:\"\";s:14:\"services_4_url\";s:1:\"#\";s:14:\"services_4_pic\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:10:\"services_5\";s:35:\"ضمانت اصل بودن کالا\";s:13:\"subservices_5\";s:0:\"\";s:14:\"services_5_url\";s:1:\"#\";s:14:\"services_5_pic\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:15:\"services_sngl_1\";s:23:\"تحویل اکسپرس\";s:19:\"services_sngl_1_url\";s:1:\"#\";s:19:\"services_sngl_1_pic\";a:8:{s:3:\"url\";s:68:\"https://mobile.parskalas.com/wp-content/uploads/2022/08/delivery.png\";s:2:\"id\";s:4:\"2468\";s:5:\"width\";s:2:\"80\";s:6:\"height\";s:2:\"80\";s:9:\"thumbnail\";s:68:\"https://mobile.parskalas.com/wp-content/uploads/2022/08/delivery.png\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:8:\"delivery\";s:11:\"description\";s:0:\"\";}s:15:\"services_sngl_2\";s:32:\"پشتیبانی ۲۴ ساعته\";s:19:\"services_sngl_2_url\";s:1:\"#\";s:19:\"services_sngl_2_pic\";a:8:{s:3:\"url\";s:63:\"https://mobile.parskalas.com/wp-content/uploads/2022/08/1-1.png\";s:2:\"id\";s:4:\"2465\";s:5:\"width\";s:2:\"80\";s:6:\"height\";s:2:\"80\";s:9:\"thumbnail\";s:63:\"https://mobile.parskalas.com/wp-content/uploads/2022/08/1-1.png\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:3:\"1-1\";s:11:\"description\";s:0:\"\";}s:15:\"services_sngl_3\";s:24:\"پرداخت در محل\";s:19:\"services_sngl_3_url\";s:1:\"#\";s:19:\"services_sngl_3_pic\";a:8:{s:3:\"url\";s:63:\"https://mobile.parskalas.com/wp-content/uploads/2022/08/2-4.png\";s:2:\"id\";s:4:\"2467\";s:5:\"width\";s:2:\"72\";s:6:\"height\";s:2:\"72\";s:9:\"thumbnail\";s:63:\"https://mobile.parskalas.com/wp-content/uploads/2022/08/2-4.png\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:3:\"2-4\";s:11:\"description\";s:0:\"\";}s:15:\"services_sngl_4\";s:42:\"۷ روز ضمانت بازگشت کالا\";s:19:\"services_sngl_4_url\";s:1:\"#\";s:19:\"services_sngl_4_pic\";a:8:{s:3:\"url\";s:63:\"https://mobile.parskalas.com/wp-content/uploads/2022/08/3-1.png\";s:2:\"id\";s:4:\"2466\";s:5:\"width\";s:2:\"80\";s:6:\"height\";s:2:\"80\";s:9:\"thumbnail\";s:63:\"https://mobile.parskalas.com/wp-content/uploads/2022/08/3-1.png\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:3:\"3-1\";s:11:\"description\";s:0:\"\";}s:15:\"services_sngl_5\";s:0:\"\";s:19:\"services_sngl_5_url\";s:0:\"\";s:19:\"services_sngl_5_pic\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:16:\"dokan_pro_active\";s:0:\"\";s:21:\"title_dash_page_dokan\";s:27:\"مرکز فروشندگان\";s:14:\"dash_page_logo\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:22:\"message_disable_seller\";s:139:\"شما در صف انتظار تایید توسط مدیر سایت هستید. پس از تایید اطلاع رسانی خواهد شد.\";s:23:\"des_more_disable_seller\";s:0:\"\";s:27:\"des_more_disable_seller_btn\";s:25:\"اطلاعات بیشتر\";s:16:\"dash_page_banner\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:23:\"dash_page_banner_banner\";s:0:\"\";s:22:\"count-post-dokan-panel\";s:1:\"4\";s:21:\"cats-post-panel-dokan\";s:0:\"\";s:19:\"dash_page_logo_foot\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:29:\"menu-items-footer-panel-dokan\";a:3:{i:0;a:3:{s:5:\"title\";s:63:\"ارتباط با مرکز فروشندگان پارس کالا\";s:3:\"url\";s:51:\"https://www.rtl-theme.com/parskala-wordpress-theme/\";s:4:\"icon\";s:0:\"\";}i:1;a:3:{s:5:\"title\";s:9:\"021000000\";s:3:\"url\";s:13:\"tel:021000000\";s:4:\"icon\";s:13:\"ri-phone-line\";}i:2;a:3:{s:5:\"title\";s:49:\"تماس با پشتیبانی فروشندگان\";s:3:\"url\";s:51:\"https://www.rtl-theme.com/parskala-wordpress-theme/\";s:4:\"icon\";s:0:\"\";}}s:24:\"copyright-en-panel-dokan\";s:67:\"تمامی حقوق متعلق به پارس کالا میباشد.\";s:21:\"copyright-panel-dokan\";s:36:\"Copyright © 2006 - 2022 masirwp.com\";s:11:\"footer_type\";s:7:\"default\";s:17:\"footer_style_type\";s:7:\"default\";s:21:\"footer_services_mobit\";s:0:\"\";s:13:\"choice_footer\";s:0:\"\";s:9:\"seen_true\";s:1:\"1\";s:10:\"seen_title\";s:42:\"کالا هایی که دیده ایید !\";s:11:\"footer_logo\";a:8:{s:3:\"url\";s:77:\"https://mobile.parskalas.com/wp-content/uploads/2022/08/parstyper-digital.png\";s:2:\"id\";s:4:\"2473\";s:5:\"width\";s:3:\"395\";s:6:\"height\";s:3:\"140\";s:9:\"thumbnail\";s:85:\"https://mobile.parskalas.com/wp-content/uploads/2022/08/parstyper-digital-150x140.png\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:17:\"parstyper-digital\";s:11:\"description\";s:0:\"\";}s:11:\"footer_tops\";s:1:\"1\";s:17:\"footer_letter_prk\";s:1:\"1\";s:13:\"footer_letter\";s:0:\"\";s:12:\"footer_calls\";s:91:\"هفت روز هفته ، 24 ساعت شبانه‌روز پاسخگوی شما هستیم.\";s:15:\"tell_foot_title\";s:20:\"شماره تماس:\";s:11:\"footer_tell\";s:13:\"061-535-10225\";s:12:\"footer_email\";s:17:\"info@parskala.com\";s:16:\"footer_copyright\";s:283:\" استفاده از مطالب فروشگاه اینترنتی پارس کالا فقط برای مقاصد غیرتجاری و با ذکر منبع بلامانع است. کلیه حقوق این سایت متعلق به پارس کالا می‌باشد. Copyright © 2006 - 2022 \";s:22:\"footer_copyright_latin\";s:36:\"Copyright © 2006 - 2018 masirwp.com\";s:16:\"application_true\";s:1:\"1\";s:29:\"application_true_bg_backcolor\";s:0:\"\";s:22:\"application_true_color\";s:0:\"\";s:16:\"application_logo\";a:8:{s:3:\"url\";s:68:\"https://mobile.parskalas.com/wp-content/uploads/2022/08/icon-app.png\";s:2:\"id\";s:4:\"2341\";s:5:\"width\";s:4:\"1221\";s:6:\"height\";s:4:\"1222\";s:9:\"thumbnail\";s:76:\"https://mobile.parskalas.com/wp-content/uploads/2022/08/icon-app-150x150.png\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:8:\"icon-app\";s:11:\"description\";s:0:\"\";}s:16:\"application_name\";s:47:\"دانلود اپلیکیشن پارس کالا\";s:15:\"application_url\";s:1:\"#\";s:16:\"application_pic1\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:16:\"application_url1\";s:1:\"#\";s:16:\"application_pic2\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:16:\"application_url2\";s:1:\"#\";s:16:\"application_pic3\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:16:\"application_url3\";s:1:\"#\";s:16:\"application_pic4\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:16:\"application_url4\";s:1:\"#\";s:10:\"info_dnapp\";s:0:\"\";s:14:\"info_dnapp_url\";s:0:\"\";s:12:\"socials_true\";s:1:\"1\";s:13:\"socials_icon1\";s:17:\"ri-instagram-line\";s:12:\"socials_url1\";s:1:\"#\";s:13:\"socials_icon2\";s:16:\"ri-whatsapp-line\";s:12:\"socials_url2\";s:1:\"#\";s:13:\"socials_icon3\";s:16:\"ri-telegram-line\";s:12:\"socials_url3\";s:1:\"#\";s:13:\"socials_icon4\";s:15:\"ri-twitter-line\";s:12:\"socials_url4\";s:1:\"#\";s:13:\"socials_icon5\";s:7:\"prk-gap\";s:12:\"socials_url5\";s:1:\"#\";s:13:\"socials_icon6\";s:10:\"prk-rubika\";s:12:\"socials_url6\";s:0:\"\";s:10:\"about_true\";s:1:\"1\";s:11:\"about_title\";s:102:\"فروشگاه اینترنتی پارس کالا، بررسی، انتخاب و خرید آنلاین\";s:9:\"about_des\";s:721:\"پارس کالا به عنوان یکی از قدیمی‌ترین فروشگاه های اینترنتی با بیش از یک دهه تجربه، با پایبندی به سه اصل، پرداخت در محل، ۷ روز ضمانت بازگشت کالا و تضمین اصل‌بودن کالا موفق شده تا همگام با فروشگاه‌های معتبر جهان، به بزرگ‌ترین فروشگاه اینترنتی ایران تبدیل شود. به محض ورود به سایت دیجی‌کالا با دنیایی از کالا رو به رو می‌شوید! هر آنچه که نیاز دارید و به ذهن شما خطور می‌کند در اینجا پیدا خواهید کرد.\r\n\r\n\";s:10:\"enmad_true\";s:1:\"1\";s:15:\"enmad_group_box\";a:3:{i:0;a:1:{s:10:\"enmad_code\";s:99:\"<a href=\"#\"><img src=\"https://pars.parskalas.com/wp-content/uploads/2022/10/enamad.png\" alt=\"\"></a>\";}i:1;a:1:{s:10:\"enmad_code\";s:102:\"<a href=\"#\"><img src=\"https://pars.parskalas.com/wp-content/uploads/2022/10/samandehi.png\" alt=\"\"></a>\";}i:2;a:1:{s:10:\"enmad_code\";s:101:\"<a href=\"#\"><img src=\"https://pars.parskalas.com/wp-content/uploads/2022/10/1e5dab5a.png\" alt=\"\"></a>\";}}s:13:\"supports_true\";s:1:\"0\";s:14:\"supports_arrow\";s:4:\"left\";s:13:\"supports_page\";s:4:\"1152\";s:13:\"supports_text\";s:57:\"جواب سوالاتتون رو پیدا نکردید ؟\";s:18:\"supports_head_text\";s:202:\"جواب سوال‌هاتون رو می‌تونید در زیر پیدا کنید. در غیر اینصورت از ما بپرسید، ما همیشه به سوالاتتون جواب می‌دهیم.\";s:14:\"supports_ques1\";s:70:\"شرایط کسب امتیاز از طریق ثبت نظر چیست؟ \";s:16:\"supports_answer1\";s:455:\"شما می توانید پس از دریافت سفارش، نظر خود را در رابطه با محصول خریداری شده در پارس کالا بنویسید. پس از تایید نظر شما توسط کارشناسان پارس کالا، امتیاز برای شما ثبت می‌شود.تا قبل از تایید نظر امتیاز شما در قسمت تاریخچه بخش امتیازات در صف نمایش داده میشود.\";s:14:\"supports_ques2\";s:82:\"چرا بایستی در حساب کاربری شماره کارت ثبت کنم؟\";s:16:\"supports_answer2\";s:296:\"در صورتی که از خرید خود منصرف شوید پارس کالا در کمترین زمان ممکن مبلغ را به شماره کارت شما برگشت می دهد. مهم است که شماره کارت به نام مالک حساب کاربری ثبت داشته باشید\";s:14:\"supports_ques3\";s:82:\"چرا بایستی در حساب کاربری آدرس ایمیل ثبت کنم؟\";s:15:\"support_answer3\";s:97:\"کلیه مکاتبات پارس کالا با آدرس ایمیل شما انجام می شود.\";s:9:\"tabs_true\";s:1:\"0\";s:10:\"tabs_style\";s:7:\"navbar1\";s:14:\"text_mob_menu1\";s:8:\"خانه\";s:14:\"icon_mob_menu1\";s:10:\"prk-home-2\";s:13:\"url_mob_menu1\";s:28:\"https://mobile.parskalas.com\";s:14:\"text_mob_menu2\";s:13:\"دسته ها\";s:14:\"icon_mob_menu2\";s:14:\"prk-category-2\";s:13:\"url_mob_menu2\";s:34:\"https://mobile.parskalas.com/shop/\";s:14:\"text_mob_menu3\";s:24:\"علاقه مندی ها\";s:14:\"icon_mob_menu3\";s:9:\"prk-heart\";s:13:\"url_mob_menu3\";s:53:\"https://mobile.parskalas.com/my-account/sit-wishlist/\";s:14:\"text_mob_menu4\";s:21:\"حساب کاربری\";s:14:\"icon_mob_menu4\";s:8:\"prk-user\";s:13:\"url_mob_menu4\";s:40:\"https://mobile.parskalas.com/my-account/\";s:9:\"apps_true\";s:1:\"0\";s:9:\"apps_text\";s:63:\"  کارایی بهتر در اپلیکیشن پارس کالا\";s:8:\"apps_pic\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:8:\"apps_btn\";s:6:\"نصب\";s:12:\"apps_btn_url\";s:1:\"#\";s:16:\"caller_tabs_true\";s:1:\"1\";s:16:\"caller_tabs_posi\";s:5:\"right\";s:15:\"caller_repaters\";a:5:{i:0;a:4:{s:11:\"caller_name\";s:28:\"تماس با فروشگاه\";s:10:\"caller_url\";s:15:\"tel:09167971886\";s:11:\"caller_icon\";s:13:\"ri-phone-line\";s:12:\"caller_color\";s:7:\"#25D366\";}i:1;a:4:{s:11:\"caller_name\";s:37:\"تماس با پشتیبان فروش\";s:10:\"caller_url\";s:15:\"tel:09167971886\";s:11:\"caller_icon\";s:18:\"ri-smartphone-line\";s:12:\"caller_color\";s:7:\"#FFA500\";}i:2;a:4:{s:11:\"caller_name\";s:39:\"ارتباط از طریق واتساپ\";s:10:\"caller_url\";s:26:\"https://wa.me/09167971886/\";s:11:\"caller_icon\";s:16:\"ri-whatsapp-line\";s:12:\"caller_color\";s:7:\"#25D366\";}i:3;a:4:{s:11:\"caller_name\";s:39:\"ارتباط از طریق تلگرام\";s:10:\"caller_url\";s:18:\"https://t.me/telmx\";s:11:\"caller_icon\";s:16:\"ri-telegram-line\";s:12:\"caller_color\";s:7:\"#20AFDE\";}i:4;a:4:{s:11:\"caller_name\";s:47:\"ارتباط از طریق اینستاگرام\";s:10:\"caller_url\";s:38:\"https://www.instagram.com/esmaliyan.ir\";s:11:\"caller_icon\";s:17:\"ri-instagram-line\";s:12:\"caller_color\";s:7:\"#cd3051\";}}s:19:\"wpjsloader_activate\";s:0:\"\";s:22:\"wpjsloader_exc_par_css\";s:0:\"\";s:20:\"wpjsloader_exc_class\";s:0:\"\";s:15:\"wpjsloader_line\";s:1:\"1\";s:20:\"wpjsloader_nprogress\";s:0:\"\";s:15:\"wpjsloader_logo\";s:0:\"\";s:21:\"prk_dis_widget_editor\";s:1:\"1\";s:20:\"prk_defualt_thumb_pr\";a:8:{s:3:\"url\";s:86:\"https://mobile.parskalas.com/wp-content/themes/parskala/assets/img/cover-thumbnail.svg\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:20:\"prk_ajax_loader_logo\";a:8:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:10:\"custom_css\";s:0:\"\";s:12:\"footer_codes\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("165", "prk_option-transients", "a:5:{s:14:\"changed_values\";a:2:{s:7:\"favicon\";a:5:{s:3:\"url\";s:73:\"https://mobile.parskalas.com/wp-content/uploads/2022/07/parskala-logo.png\";s:2:\"id\";s:4:\"2167\";s:6:\"height\";s:4:\"6621\";s:5:\"width\";s:4:\"6622\";s:9:\"thumbnail\";s:81:\"https://mobile.parskalas.com/wp-content/uploads/2022/07/parskala-logo-150x150.png\";}s:14:\"favicon_retina\";a:5:{s:3:\"url\";s:67:\"https://mobile.parskalas.com/wp-content/uploads/2022/02/favicon.png\";s:2:\"id\";s:3:\"967\";s:6:\"height\";s:4:\"5086\";s:5:\"width\";s:4:\"5086\";s:9:\"thumbnail\";s:67:\"https://mobile.parskalas.com/wp-content/uploads/2022/02/favicon.png\";}}s:9:\"last_save\";i:1659214262;s:13:\"last_compiler\";i:1659214262;s:11:\"last_import\";i:1659214262;s:7:\"notices\";a:2:{s:6:\"errors\";a:0:{}s:8:\"sanitize\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("13307", "elementor_unfiltered_files_upload", "1", "yes");
INSERT INTO `wp_options` VALUES("170", "widget_recent-comments", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("171", "widget_recent-posts", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("173", "theme_mods_twentytwenty", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1642526176;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-1\";a:0:{}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("175", "prk_words_init", "44a099f18b3f4cde5f3eaedf5a84cdd5", "yes");
INSERT INTO `wp_options` VALUES("177", "recently_activated", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("178", "action_scheduler_hybrid_store_demarkation", "8", "yes");
INSERT INTO `wp_options` VALUES("179", "schema-ActionScheduler_StoreSchema", "7.0.1749974542", "yes");
INSERT INTO `wp_options` VALUES("180", "schema-ActionScheduler_LoggerSchema", "3.0.1642526688", "yes");
INSERT INTO `wp_options` VALUES("183", "woocommerce_schema_version", "920", "yes");
INSERT INTO `wp_options` VALUES("184", "woocommerce_store_address", "ایران خوزستان خرمشهر", "yes");
INSERT INTO `wp_options` VALUES("185", "woocommerce_store_address_2", "خرمشهر", "yes");
INSERT INTO `wp_options` VALUES("186", "woocommerce_store_city", "خرمشهر", "yes");
INSERT INTO `wp_options` VALUES("187", "woocommerce_default_country", "IR:KHZ", "yes");
INSERT INTO `wp_options` VALUES("188", "woocommerce_store_postcode", "64500000000", "yes");
INSERT INTO `wp_options` VALUES("189", "woocommerce_allowed_countries", "specific", "yes");
INSERT INTO `wp_options` VALUES("190", "woocommerce_all_except_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("191", "woocommerce_specific_allowed_countries", "a:1:{i:0;s:2:\"IR\";}", "yes");
INSERT INTO `wp_options` VALUES("192", "woocommerce_ship_to_countries", "specific", "yes");
INSERT INTO `wp_options` VALUES("193", "woocommerce_specific_ship_to_countries", "a:1:{i:0;s:2:\"IR\";}", "yes");
INSERT INTO `wp_options` VALUES("194", "woocommerce_default_customer_address", "", "yes");
INSERT INTO `wp_options` VALUES("195", "woocommerce_calc_taxes", "yes", "yes");
INSERT INTO `wp_options` VALUES("196", "woocommerce_enable_coupons", "yes", "yes");
INSERT INTO `wp_options` VALUES("197", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `wp_options` VALUES("198", "woocommerce_currency", "IRT", "yes");
INSERT INTO `wp_options` VALUES("199", "woocommerce_currency_pos", "right_space", "yes");
INSERT INTO `wp_options` VALUES("200", "woocommerce_price_thousand_sep", ",", "yes");
INSERT INTO `wp_options` VALUES("201", "woocommerce_price_decimal_sep", ",", "yes");
INSERT INTO `wp_options` VALUES("202", "woocommerce_price_num_decimals", "0", "yes");
INSERT INTO `wp_options` VALUES("203", "woocommerce_shop_page_id", "9", "yes");
INSERT INTO `wp_options` VALUES("204", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `wp_options` VALUES("205", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `wp_options` VALUES("206", "woocommerce_placeholder_image", "2962", "yes");
INSERT INTO `wp_options` VALUES("207", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `wp_options` VALUES("208", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `wp_options` VALUES("209", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `wp_options` VALUES("210", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `wp_options` VALUES("211", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `wp_options` VALUES("212", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `wp_options` VALUES("213", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `wp_options` VALUES("214", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `wp_options` VALUES("215", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `wp_options` VALUES("216", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("217", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("218", "woocommerce_stock_email_recipient", "nextappteam@gmail.com", "no");
INSERT INTO `wp_options` VALUES("219", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `wp_options` VALUES("220", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `wp_options` VALUES("221", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `wp_options` VALUES("222", "woocommerce_stock_format", "", "yes");
INSERT INTO `wp_options` VALUES("223", "woocommerce_file_download_method", "force", "no");
INSERT INTO `wp_options` VALUES("224", "woocommerce_downloads_redirect_fallback_allowed", "no", "no");
INSERT INTO `wp_options` VALUES("225", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `wp_options` VALUES("226", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `wp_options` VALUES("227", "woocommerce_downloads_add_hash_to_filename", "yes", "yes");
INSERT INTO `wp_options` VALUES("228", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `wp_options` VALUES("229", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `wp_options` VALUES("230", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `wp_options` VALUES("231", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `wp_options` VALUES("232", "woocommerce_tax_classes", "", "yes");
INSERT INTO `wp_options` VALUES("233", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `wp_options` VALUES("234", "woocommerce_tax_display_cart", "excl", "yes");
INSERT INTO `wp_options` VALUES("235", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `wp_options` VALUES("236", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `wp_options` VALUES("237", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `wp_options` VALUES("238", "woocommerce_shipping_cost_requires_address", "no", "yes");
INSERT INTO `wp_options` VALUES("239", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `wp_options` VALUES("240", "woocommerce_shipping_debug_mode", "no", "yes");
INSERT INTO `wp_options` VALUES("241", "woocommerce_enable_guest_checkout", "yes", "no");
INSERT INTO `wp_options` VALUES("242", "woocommerce_enable_checkout_login_reminder", "no", "no");
INSERT INTO `wp_options` VALUES("243", "woocommerce_enable_signup_and_login_from_checkout", "no", "no");
INSERT INTO `wp_options` VALUES("244", "woocommerce_enable_myaccount_registration", "yes", "no");
INSERT INTO `wp_options` VALUES("245", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `wp_options` VALUES("246", "woocommerce_registration_generate_password", "no", "no");
INSERT INTO `wp_options` VALUES("247", "woocommerce_erasure_request_removes_order_data", "no", "no");
INSERT INTO `wp_options` VALUES("248", "woocommerce_erasure_request_removes_download_data", "no", "no");
INSERT INTO `wp_options` VALUES("249", "woocommerce_allow_bulk_remove_personal_data", "no", "no");
INSERT INTO `wp_options` VALUES("250", "woocommerce_registration_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما استفاده می‌شود، و پشتیبانی از تجربه شما در این وبسایت، و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است.", "yes");
INSERT INTO `wp_options` VALUES("251", "woocommerce_checkout_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما و پشتیبانی از تجربه شما در این وبسایت و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است استفاده می‌شود.", "yes");
INSERT INTO `wp_options` VALUES("252", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("253", "woocommerce_trash_pending_orders", "", "no");
INSERT INTO `wp_options` VALUES("254", "woocommerce_trash_failed_orders", "", "no");
INSERT INTO `wp_options` VALUES("255", "woocommerce_trash_cancelled_orders", "", "no");
INSERT INTO `wp_options` VALUES("256", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("257", "woocommerce_email_from_name", "فروشگاه اینترنتی پارس کالا", "no");
INSERT INTO `wp_options` VALUES("258", "woocommerce_email_from_address", "nextappteam@gmail.com", "no");
INSERT INTO `wp_options` VALUES("259", "woocommerce_email_header_image", "", "no");
INSERT INTO `wp_options` VALUES("260", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "no");
INSERT INTO `wp_options` VALUES("261", "woocommerce_email_base_color", "#ed3978", "no");
INSERT INTO `wp_options` VALUES("262", "woocommerce_email_background_color", "#f7f7f7", "no");
INSERT INTO `wp_options` VALUES("263", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `wp_options` VALUES("264", "woocommerce_email_text_color", "#3c3c3c", "no");
INSERT INTO `wp_options` VALUES("265", "woocommerce_merchant_email_notifications", "no", "no");
INSERT INTO `wp_options` VALUES("266", "woocommerce_cart_page_id", "10", "no");
INSERT INTO `wp_options` VALUES("267", "woocommerce_checkout_page_id", "11", "no");
INSERT INTO `wp_options` VALUES("268", "woocommerce_myaccount_page_id", "12", "no");
INSERT INTO `wp_options` VALUES("269", "woocommerce_terms_page_id", "", "no");
INSERT INTO `wp_options` VALUES("270", "woocommerce_force_ssl_checkout", "no", "yes");
INSERT INTO `wp_options` VALUES("271", "woocommerce_unforce_ssl_checkout", "no", "yes");
INSERT INTO `wp_options` VALUES("272", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `wp_options` VALUES("273", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `wp_options` VALUES("274", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `wp_options` VALUES("275", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `wp_options` VALUES("276", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `wp_options` VALUES("277", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `wp_options` VALUES("278", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `wp_options` VALUES("279", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `wp_options` VALUES("280", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `wp_options` VALUES("281", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `wp_options` VALUES("282", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `wp_options` VALUES("283", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `wp_options` VALUES("284", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `wp_options` VALUES("285", "woocommerce_api_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("286", "woocommerce_allow_tracking", "no", "on");
INSERT INTO `wp_options` VALUES("287", "woocommerce_show_marketplace_suggestions", "yes", "no");
INSERT INTO `wp_options` VALUES("288", "woocommerce_single_image_width", "600", "yes");
INSERT INTO `wp_options` VALUES("289", "woocommerce_thumbnail_image_width", "300", "yes");
INSERT INTO `wp_options` VALUES("290", "woocommerce_checkout_highlight_required_fields", "yes", "yes");
INSERT INTO `wp_options` VALUES("291", "woocommerce_demo_store", "no", "no");
INSERT INTO `wp_options` VALUES("292", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:8:\"/product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("293", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `wp_options` VALUES("294", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `wp_options` VALUES("2571", "woocommerce_analytics_enabled", "yes", "yes");
INSERT INTO `wp_options` VALUES("297", "default_product_cat", "15", "yes");
INSERT INTO `wp_options` VALUES("338", "wc_blocks_surface_cart_checkout_probability", "35", "yes");
INSERT INTO `wp_options` VALUES("299", "woocommerce_refund_returns_page_id", "13", "yes");
INSERT INTO `wp_options` VALUES("302", "woocommerce_paypal_settings", "a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:13:\"پی‌پال\";s:11:\"description\";s:168:\"پرداخت از راه پی‌پال، اگر حساب کاربری پی‌پال ندارید، می توانید با کارت اعتباری پرداخت کنید.\";s:5:\"email\";s:21:\"nextappteam@gmail.com\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:21:\"nextappteam@gmail.com\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";}", "yes");
INSERT INTO `wp_options` VALUES("303", "woocommerce_version", "9.9.3", "yes");
INSERT INTO `wp_options` VALUES("304", "woocommerce_db_version", "9.9.3", "yes");
INSERT INTO `wp_options` VALUES("312", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"PdGAkxHUnrwZbXezi2t2d12ppl8ftS3u\";}", "yes");
INSERT INTO `wp_options` VALUES("310", "action_scheduler_lock_async-request-runner", "688cdac056fe92.02927455|1754061564", "yes");
INSERT INTO `wp_options` VALUES("311", "woocommerce_admin_notices", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("314", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("315", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("316", "widget_woocommerce_layered_nav", "a:3:{s:12:\"_multiwidget\";i:1;i:3;a:4:{s:5:\"title\";s:19:\"انتخاب رنگ\";s:9:\"attribute\";s:14:\"color-selector\";s:12:\"display_type\";s:4:\"list\";s:10:\"query_type\";s:3:\"and\";}i:5;a:4:{s:5:\"title\";s:17:\"انتخاب رم\";s:9:\"attribute\";s:12:\"ram-selector\";s:12:\"display_type\";s:4:\"list\";s:10:\"query_type\";s:3:\"and\";}}", "yes");
INSERT INTO `wp_options` VALUES("317", "widget_woocommerce_price_filter", "a:2:{s:12:\"_multiwidget\";i:1;i:3;a:1:{s:5:\"title\";s:33:\"فیلتر براساس قیمت:\";}}", "yes");
INSERT INTO `wp_options` VALUES("318", "widget_woocommerce_product_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("319", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("320", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("321", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("322", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("323", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("324", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("325", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("329", "woocommerce_admin_install_timestamp", "1642526689", "yes");
INSERT INTO `wp_options` VALUES("330", "wc_remote_inbox_notifications_wca_updated", "", "off");
INSERT INTO `wp_options` VALUES("328", "woocommerce_admin_version", "3.0.3", "yes");
INSERT INTO `wp_options` VALUES("333", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:1;}", "no");
INSERT INTO `wp_options` VALUES("339", "wc_blocks_db_schema_version", "260", "yes");
INSERT INTO `wp_options` VALUES("364", "woocommerce_task_list_dismissed_tasks", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("356", "woocommerce_task_list_completed_lists", "a:2:{i:0;s:8:\"extended\";i:1;s:19:\"extended_two_column\";}", "yes");
INSERT INTO `wp_options` VALUES("362", "woocommerce_onboarding_profile", "a:10:{s:18:\"is_agree_marketing\";b:1;s:11:\"store_email\";s:21:\"nextappteam@gmail.com\";s:8:\"industry\";a:5:{i:0;a:1:{s:4:\"slug\";s:21:\"home-furniture-garden\";}i:1;a:1:{s:4:\"slug\";s:21:\"electronics-computers\";}i:2;a:1:{s:4:\"slug\";s:27:\"fashion-apparel-accessories\";}i:3;a:1:{s:4:\"slug\";s:13:\"health-beauty\";}i:4;a:1:{s:4:\"slug\";s:10:\"food-drink\";}}s:13:\"product_types\";a:1:{i:0;s:8:\"physical\";}s:13:\"product_count\";s:4:\"1-10\";s:14:\"selling_venues\";s:2:\"no\";s:12:\"setup_client\";b:0;s:19:\"business_extensions\";a:0:{}s:5:\"theme\";s:8:\"parskala\";s:9:\"completed\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("366", "woocommerce_task_list_tracked_completed_tasks", "a:7:{i:0;s:13:\"store_details\";i:1;s:8:\"products\";i:2;s:8:\"payments\";i:3;s:8:\"shipping\";i:4;s:8:\"purchase\";i:5;s:14:\"store_creation\";i:6;s:17:\"launch-your-store\";}", "yes");
INSERT INTO `wp_options` VALUES("375", "woocommerce_task_list_prompt_shown", "1", "yes");
INSERT INTO `wp_options` VALUES("376", "woocommerce_task_list_welcome_modal_dismissed", "yes", "yes");
INSERT INTO `wp_options` VALUES("40680", "item_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("398", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("463", "yit_recently_activated", "a:2:{i:0;s:33:\"yith-woocommerce-compare/init.php\";i:1;s:34:\"yith-woocommerce-wishlist/init.php\";}", "yes");
INSERT INTO `wp_options` VALUES("464", "widget_yith-woocompare-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("465", "yith_woocompare_is_button", "button", "yes");
INSERT INTO `wp_options` VALUES("469", "yith_woocompare_auto_open", "no", "yes");
INSERT INTO `wp_options` VALUES("470", "yith_woocompare_table_text", "مقایسه‌ی محصولات", "yes");
INSERT INTO `wp_options` VALUES("471", "yith_woocompare_fields_attrs", "a:9:{i:0;s:5:\"image\";i:1;s:5:\"title\";i:2;s:5:\"price\";i:3;s:11:\"add-to-cart\";i:4;s:11:\"description\";i:5;s:3:\"sku\";i:6;s:5:\"stock\";i:7;s:6:\"weight\";i:8;s:10:\"dimensions\";}", "yes");
INSERT INTO `wp_options` VALUES("472", "yith_woocompare_price_end", "yes", "yes");
INSERT INTO `wp_options` VALUES("473", "yith_woocompare_add_to_cart_end", "no", "yes");
INSERT INTO `wp_options` VALUES("474", "yith_woocompare_image_size", "a:3:{s:5:\"width\";s:3:\"220\";s:6:\"height\";s:3:\"154\";s:4:\"crop\";s:2:\"on\";}", "yes");
INSERT INTO `wp_options` VALUES("475", "yit_plugin_fw_panel_wc_default_options_set", "a:2:{s:21:\"yith_woocompare_panel\";b:1;s:15:\"yith_wcwl_panel\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("495", "woocommerce_flat_rate_2_settings", "a:3:{s:5:\"title\";s:15:\"نرخ ثابت\";s:10:\"tax_status\";s:7:\"taxable\";s:4:\"cost\";s:5:\"12000\";}", "yes");
INSERT INTO `wp_options` VALUES("496", "woocommerce_bacs_settings", "a:11:{s:7:\"enabled\";s:3:\"yes\";s:5:\"title\";s:36:\"انتقال مستقیم بانکی\";s:11:\"description\";s:325:\"پرداخت خود را مستقیما به حساب بانکی ما واریز کنید.خواهشمندیم شماره سفارش خود را بعنوان کد ارجاع پرداخت استفاده کنید.سفارش شما تا زمانی که وجوه به حساب ما وارد نشود ارسال نخواهد شد.\";s:12:\"instructions\";s:0:\"\";s:15:\"account_details\";s:0:\"\";s:12:\"account_name\";s:0:\"\";s:14:\"account_number\";s:0:\"\";s:9:\"sort_code\";s:0:\"\";s:9:\"bank_name\";s:0:\"\";s:4:\"iban\";s:0:\"\";s:3:\"bic\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("498", "woocommerce_cod_settings", "a:6:{s:7:\"enabled\";s:3:\"yes\";s:5:\"title\";s:36:\"پرداخت هنگام دریافت\";s:11:\"description\";s:42:\"پرداخت نقدی پس از تحویل\";s:12:\"instructions\";s:42:\"پرداخت نقدی پس از تحویل\";s:18:\"enable_for_methods\";a:0:{}s:18:\"enable_for_virtual\";s:3:\"yes\";}", "yes");
INSERT INTO `wp_options` VALUES("499", "woocommerce_bacs_accounts", "a:2:{i:0;a:6:{s:12:\"account_name\";s:29:\"حسین اسماعیلیان\";s:14:\"account_number\";s:18:\"580000000000000000\";s:9:\"bank_name\";s:23:\"رفاه کارگران\";s:9:\"sort_code\";s:22:\"۱۲۰۲۹۰۰۰۰۰۰\";s:4:\"iban\";s:19:\"IR10000000000000000\";s:3:\"bic\";s:0:\"\";}i:1;a:6:{s:12:\"account_name\";s:0:\"\";s:14:\"account_number\";s:0:\"\";s:9:\"bank_name\";s:0:\"\";s:9:\"sort_code\";s:0:\"\";s:4:\"iban\";s:0:\"\";s:3:\"bic\";s:0:\"\";}}", "yes");
INSERT INTO `wp_options` VALUES("501", "yith_woocompare_fields", "a:9:{s:5:\"image\";b:1;s:5:\"title\";b:1;s:5:\"price\";b:1;s:11:\"add-to-cart\";b:1;s:11:\"description\";b:1;s:3:\"sku\";b:1;s:5:\"stock\";b:1;s:6:\"weight\";b:1;s:10:\"dimensions\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("518", "dokan_pages", "a:3:{s:9:\"dashboard\";i:26;s:13:\"store_listing\";i:27;s:9:\"my_orders\";i:28;}", "yes");
INSERT INTO `wp_options` VALUES("519", "dokan_pages_created", "1", "yes");
INSERT INTO `wp_options` VALUES("520", "dokan_theme_version", "3.6.2", "yes");
INSERT INTO `wp_options` VALUES("538", "dokan_admin_setup_wizard_ready", "1", "yes");
INSERT INTO `wp_options` VALUES("531", "dokan-lite_allow_tracking", "no", "yes");
INSERT INTO `wp_options` VALUES("523", "widget_dokan-best-selling-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("524", "widget_dokan-category-menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("525", "widget_dokan-store-contact-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("526", "widget_dokan-store-location", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("527", "widget_dokan-store-menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("528", "widget_dokan-top-rated", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("529", "widget_dokan-store-open-close-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("533", "dokan-lite_tracking_skipped", "yes", "yes");
INSERT INTO `wp_options` VALUES("534", "dokan_general", "a:1:{s:16:\"custom_store_url\";s:5:\"store\";}", "yes");
INSERT INTO `wp_options` VALUES("535", "dokan_selling", "a:6:{s:22:\"shipping_fee_recipient\";s:6:\"seller\";s:17:\"tax_fee_recipient\";s:6:\"seller\";s:25:\"new_seller_enable_selling\";s:2:\"on\";s:15:\"commission_type\";s:10:\"percentage\";s:16:\"admin_percentage\";d:10;s:19:\"order_status_change\";s:2:\"on\";}", "yes");
INSERT INTO `wp_options` VALUES("536", "dokan_appearance", "a:3:{s:14:\"map_api_source\";s:11:\"google_maps\";s:12:\"gmap_api_key\";s:0:\"\";s:19:\"mapbox_access_token\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("537", "dokan_withdraw", "a:3:{s:16:\"withdraw_methods\";a:2:{s:6:\"paypal\";s:6:\"paypal\";s:4:\"bank\";s:4:\"bank\";}s:14:\"withdraw_limit\";s:2:\"50\";s:21:\"withdraw_order_status\";a:1:{s:12:\"wc-completed\";s:12:\"wc-completed\";}}", "yes");
INSERT INTO `wp_options` VALUES("543", "dokan_pointer_toplevel_page_dokan", "1", "yes");
INSERT INTO `wp_options` VALUES("548", "dokan_review_notice_hidden", "yes", "yes");
INSERT INTO `wp_options` VALUES("549", "dokan_lite_whats_new_versions", "a:1:{i:0;s:5:\"3.3.6\";}", "yes");
INSERT INTO `wp_options` VALUES("555", "dokan_hide_pro_nag", "hide", "yes");
INSERT INTO `wp_options` VALUES("2832", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("991", "elementor_remote_info_feed_data", "a:3:{i:0;a:5:{s:5:\"title\";s:100:\"Introducing Elementor 3.30: new Editor V4 capabilities, full Website Templates in the cloud, & more!\";s:7:\"excerpt\";s:361:\"Elementor 3.30 is here and it includes upgrades that accelerate your workflow, bring you a step closer to the full power of Editor V4, and help you deliver beautiful, accessible websites faster than ever. From advanced styling tools and smarter editing to full Website Templates in the cloud, this release enhances both the way you design and the way you scale.\";s:7:\"created\";i:1751974442;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-330-v4-alpha-website-templates/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:57:\"Introducing Cloud Templates: your personal design library\";s:7:\"excerpt\";s:153:\"Transform your workflow with Elementor\'s new Cloud Templates – create, save, and access your templates across all your websites with just a few clicks.\";s:7:\"created\";i:1749048239;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:127:\"https://elementor.com/blog/introducing-cloud-templates/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:74:\"Introducing Editor V4 Alpha: The Future of Website Building with Elementor\";s:7:\"excerpt\";s:242:\"Editor V4 Alpha introduces a CSS-first framework with reusable Classes and States, improved performance, a unified styling system, and fully responsive style controls—all designed to make your website building more efficient and consistent.\";s:7:\"created\";i:1748357309;s:5:\"badge\";s:4:\" NEW\";s:3:\"url\";s:119:\"https://elementor.com/blog/editor-v4-1st-alpha/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}", "off");
INSERT INTO `wp_options` VALUES("997", "elementor_scheme_color", "a:4:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";}", "yes");
INSERT INTO `wp_options` VALUES("998", "elementor_scheme_typography", "a:4:{i:1;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"600\";}i:2;a:2:{s:11:\"font_family\";s:11:\"Roboto Slab\";s:11:\"font_weight\";s:3:\"400\";}i:3;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"400\";}i:4;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"500\";}}", "yes");
INSERT INTO `wp_options` VALUES("999", "elementor_scheme_color-picker", "a:8:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";i:5;s:7:\"#4054b2\";i:6;s:7:\"#23a455\";i:7;s:4:\"#000\";i:8;s:4:\"#fff\";}", "yes");
INSERT INTO `wp_options` VALUES("1080", "woocommerce_onboarding_subscribed_to_mailchimp", "yes", "yes");
INSERT INTO `wp_options` VALUES("1138", "woocommerce_maybe_regenerate_images_hash", "991b1ca641921cf0f5baf7a2fe85861b", "yes");
INSERT INTO `wp_options` VALUES("3582", "woocommerce_meta_box_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("3260", "elementor_log", "a:39:{s:32:\"c0df1845e290be0785bcc501d3df4b97\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-01-23 18:03:22\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.5.3\";s:2:\"to\";s:5:\"3.5.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-01-23 18:03:22\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.5.3\";s:2:\"to\";s:5:\"3.5.4\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"18e3f18c1c2359de7cff2a6ab4482cee\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-01-23 18:03:22\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-01-23 18:03:22\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"c1a554eff72aa3e4fca6bb5444ad7d24\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-01-23 18:03:22\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-01-23 18:03:22\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"404e40d84835a829ab5fc783c18cc8a4\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-01-23 18:03:22\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-01-23 18:03:22\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"23298867669e2c9d70560dc0784f0554\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-01-23 18:03:22\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.5.3\";s:2:\"to\";s:5:\"3.5.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-01-23 18:03:22\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.5.3\";s:2:\"to\";s:5:\"3.5.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"b5dd0c429a82a83faa84bc6d5f5d16f4\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:5:\"29700\";s:7:\"\0*\0file\";s:93:\"https://mobile.parskalas.com/wp-content/plugins/elementor/assets/js/frontend.min.js?ver=3.5.4\";s:7:\"\0*\0line\";s:1:\"2\";s:7:\"\0*\0date\";s:19:\"2022-01-28 23:49:03\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:36:\"elementor.settings.page is undefined\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:3;s:14:\"\0*\0times_dates\";a:3:{i:0;s:19:\"2022-01-28 23:49:03\";i:1;s:19:\"2022-01-28 23:49:49\";i:2;s:19:\"2022-02-27 22:10:21\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1643413743\";s:7:\"message\";s:36:\"elementor.settings.page is undefined\";s:3:\"url\";s:93:\"https://mobile.parskalas.com/wp-content/plugins/elementor/assets/js/frontend.min.js?ver=3.5.4\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"29700\";}}s:32:\"14adbb1d0a37d270e8cc1e32b2034bf2\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:3:\"652\";s:7:\"\0*\0file\";s:72:\"https://mobile.parskalas.com/wp-includes/js/wp-auth-check.min.js?ver=5.9\";s:7:\"\0*\0line\";s:1:\"2\";s:7:\"\0*\0date\";s:19:\"2022-01-28 23:49:03\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:14:\"h is undefined\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2022-01-28 23:49:03\";i:1;s:19:\"2022-01-28 23:49:49\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1643413743\";s:7:\"message\";s:14:\"h is undefined\";s:3:\"url\";s:72:\"https://mobile.parskalas.com/wp-includes/js/wp-auth-check.min.js?ver=5.9\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:3:\"652\";}}s:32:\"b2e4422d6166e2d4e52194f4dbf1e095\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-02-03 23:39:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-02-03 23:39:20\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"27b7757ed4378f41583e0215f3434861\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-02-03 23:39:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-02-03 23:39:20\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"d6b05c9a863acc2320d36b5ae49d0448\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-02-03 23:39:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-02-03 23:39:20\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"8c27625997f0e4de55e0fada01bd8d67\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-02-03 23:39:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.5.4\";s:2:\"to\";s:5:\"3.5.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-02-03 23:39:20\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.5.4\";s:2:\"to\";s:5:\"3.5.5\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"61497a19e70bc448f9b0fd81ebbaa554\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-02-03 23:39:20\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.5.4\";s:2:\"to\";s:5:\"3.5.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-02-03 23:39:20\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.5.4\";s:2:\"to\";s:5:\"3.5.5\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"4b4efccb5f8c832c3592aa47e97d3a57\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:5:\"15257\";s:7:\"\0*\0file\";s:99:\"https://mobile.parskalas.com/wp-content/plugins/elementor/assets/js/editor-modules.min.js?ver=3.5.5\";s:7:\"\0*\0line\";s:1:\"2\";s:7:\"\0*\0date\";s:19:\"2022-03-02 11:19:41\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:61:\"Cannot read properties of null (reading \\&#039;editor\\&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:7;s:14:\"\0*\0times_dates\";a:7:{i:0;s:19:\"2022-03-02 11:19:41\";i:1;s:19:\"2022-03-02 11:19:44\";i:2;s:19:\"2022-03-02 11:19:45\";i:3;s:19:\"2022-03-02 11:19:50\";i:4;s:19:\"2022-03-02 11:19:53\";i:5;s:19:\"2022-03-02 11:19:54\";i:6;s:19:\"2022-03-02 11:20:28\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1646219981\";s:7:\"message\";s:51:\"Cannot read properties of null (reading \\\'editor\\\')\";s:3:\"url\";s:99:\"https://mobile.parskalas.com/wp-content/plugins/elementor/assets/js/editor-modules.min.js?ver=3.5.5\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"15257\";}}s:32:\"1a48d9e9962fdab7a00bd435a4e1ad19\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:113:\"/home2/parskal6/domains/mobile.parskalas.com/public_html/wp-content/plugins/elementor/includes/managers/image.php\";s:7:\"\0*\0line\";i:87;s:7:\"\0*\0date\";s:19:\"2022-03-02 20:56:14\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:51:\"Trying to access array offset on value of type bool\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-03-02 20:56:14\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:51:\"Trying to access array offset on value of type bool\";s:4:\"file\";s:113:\"/home2/parskal6/domains/mobile.parskalas.com/public_html/wp-content/plugins/elementor/includes/managers/image.php\";s:4:\"line\";i:87;s:5:\"trace\";b:1;}}s:32:\"da45c71dd8222f94fb63e4e12a5a800d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-06-30 03:17:34\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.5.5\";s:2:\"to\";s:5:\"3.6.6\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-06-30 03:17:34\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.5.5\";s:2:\"to\";s:5:\"3.6.6\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"964ddb13e193c687096b5dfd2c0b3465\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-06-30 03:17:35\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-06-30 03:17:35\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"02b2bd170c524348a57a9a879baf67bb\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-06-30 03:17:35\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-06-30 03:17:35\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"db8076b5c2b6b3edf562eb3939d92459\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-06-30 03:17:35\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-06-30 03:17:35\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"92dca0c8849df683ea90782649941a81\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-06-30 03:17:35\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.5.5\";s:2:\"to\";s:5:\"3.6.6\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-06-30 03:17:35\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.5.5\";s:2:\"to\";s:5:\"3.6.6\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"8cb1f4b40ebb85b2a47f9826be6ca953\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:3:\"739\";s:7:\"\0*\0file\";s:117:\"https://mobile.parskalas.com/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:7:\"\0*\0line\";s:2:\"24\";s:7:\"\0*\0date\";s:19:\"2022-07-19 12:57:55\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:14:\"a is undefined\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:5;s:14:\"\0*\0times_dates\";a:5:{i:0;s:19:\"2022-07-19 12:57:55\";i:1;s:19:\"2022-07-19 12:57:57\";i:2;s:19:\"2022-07-19 12:57:59\";i:3;s:19:\"2022-07-19 14:18:32\";i:4;s:19:\"2022-07-19 14:22:01\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1658235475\";s:7:\"message\";s:14:\"a is undefined\";s:3:\"url\";s:117:\"https://mobile.parskalas.com/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:4:\"line\";s:2:\"24\";s:6:\"column\";s:3:\"739\";}}s:32:\"e2c8f11f936bd2803815a5b7cce6afb1\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:5:\"19643\";s:7:\"\0*\0file\";s:97:\"https://mobile.parskalas.com/wp-content/plugins/elementor/assets/lib/pickr/pickr.min.js?ver=1.5.0\";s:7:\"\0*\0line\";s:1:\"2\";s:7:\"\0*\0date\";s:19:\"2022-07-24 13:49:05\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:37:\"this.getColorRepresentation() is null\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:13;s:14:\"\0*\0times_dates\";a:13:{i:0;s:19:\"2022-07-24 13:49:05\";i:1;s:19:\"2022-07-24 13:49:05\";i:2;s:19:\"2022-07-24 13:49:05\";i:3;s:19:\"2022-07-24 13:49:05\";i:4;s:19:\"2022-07-24 13:49:06\";i:5;s:19:\"2022-07-24 13:49:06\";i:6;s:19:\"2022-07-24 13:49:06\";i:7;s:19:\"2022-07-24 13:49:06\";i:8;s:19:\"2022-07-24 13:49:06\";i:9;s:19:\"2022-07-24 13:49:06\";i:10;s:19:\"2022-07-24 13:49:06\";i:11;s:19:\"2022-07-24 13:49:06\";i:12;s:19:\"2022-07-24 13:49:06\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1658670545\";s:7:\"message\";s:37:\"this.getColorRepresentation() is null\";s:3:\"url\";s:97:\"https://mobile.parskalas.com/wp-content/plugins/elementor/assets/lib/pickr/pickr.min.js?ver=1.5.0\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"19643\";}}s:32:\"cf93459b6b1de605f996313998fbc4ec\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:121:\"/home2/parskal6/domains/mobile.parskalas.com/public_html/wp-content/plugins/elementor/core/common/modules/ajax/module.php\";s:7:\"\0*\0line\";i:269;s:7:\"\0*\0date\";s:19:\"2022-08-03 04:01:17\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:190:\"Cannot modify header information - headers already sent by (output started at /home2/parskal6/domains/mobile.parskalas.com/public_html/wp-content/themes/parskala/inc/includes/compare.php:14)\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:6;s:14:\"\0*\0times_dates\";a:6:{i:0;s:19:\"2022-08-03 04:01:17\";i:1;s:19:\"2022-08-03 04:01:25\";i:2;s:19:\"2022-08-03 04:02:04\";i:3;s:19:\"2022-08-03 04:03:16\";i:4;s:19:\"2022-08-03 04:03:58\";i:5;s:19:\"2022-08-03 04:05:14\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:190:\"Cannot modify header information - headers already sent by (output started at /home2/parskal6/domains/mobile.parskalas.com/public_html/wp-content/themes/parskala/inc/includes/compare.php:14)\";s:4:\"file\";s:121:\"/home2/parskal6/domains/mobile.parskalas.com/public_html/wp-content/plugins/elementor/core/common/modules/ajax/module.php\";s:4:\"line\";i:269;s:5:\"trace\";b:1;}}s:32:\"e2f8710e8b5a5321c306912e939a5949\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:5:\"16820\";s:7:\"\0*\0file\";s:97:\"https://mobile.parskalas.com/wp-content/plugins/elementor/assets/lib/pickr/pickr.min.js?ver=1.5.0\";s:7:\"\0*\0line\";s:1:\"2\";s:7:\"\0*\0date\";s:19:\"2022-08-19 22:31:10\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:60:\"Cannot read properties of null (reading \\&#039;clone\\&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1172;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2022-08-19 22:48:36\";i:1;s:19:\"2022-08-19 22:48:37\";i:2;s:19:\"2022-08-19 22:48:37\";i:3;s:19:\"2022-08-19 22:48:37\";i:4;s:19:\"2022-08-19 22:48:37\";i:5;s:19:\"2022-08-19 22:48:37\";i:6;s:19:\"2022-08-19 22:48:37\";i:7;s:19:\"2022-08-19 22:48:37\";i:8;s:19:\"2022-08-19 22:48:37\";i:9;s:19:\"2022-08-19 22:48:37\";i:10;s:19:\"2022-08-19 22:48:37\";i:11;s:19:\"2022-08-19 22:48:37\";i:12;s:19:\"2022-08-19 22:48:37\";i:13;s:19:\"2022-08-19 22:48:37\";i:14;s:19:\"2022-08-19 22:48:37\";i:15;s:19:\"2022-08-19 22:48:37\";i:16;s:19:\"2022-08-19 22:48:37\";i:17;s:19:\"2022-08-19 22:48:37\";i:18;s:19:\"2022-08-19 22:48:37\";i:19;s:19:\"2022-08-19 22:48:37\";i:20;s:19:\"2022-08-19 22:48:37\";i:21;s:19:\"2022-08-19 22:48:37\";i:22;s:19:\"2022-08-19 22:48:37\";i:23;s:19:\"2022-08-19 22:48:37\";i:24;s:19:\"2022-08-19 22:48:37\";i:25;s:19:\"2022-08-19 22:48:37\";i:26;s:19:\"2022-08-19 22:48:37\";i:27;s:19:\"2022-08-19 22:48:39\";i:28;s:19:\"2022-08-19 22:48:39\";i:29;s:19:\"2022-08-19 22:48:39\";i:30;s:19:\"2022-08-19 22:48:39\";i:31;s:19:\"2022-08-19 22:48:39\";i:32;s:19:\"2022-08-19 22:48:39\";i:33;s:19:\"2022-08-19 22:48:39\";i:34;s:19:\"2022-08-19 22:48:39\";i:35;s:19:\"2022-08-19 22:48:40\";i:36;s:19:\"2022-08-19 22:48:40\";i:37;s:19:\"2022-08-19 22:48:40\";i:38;s:19:\"2022-08-19 22:48:40\";i:39;s:19:\"2022-08-19 22:48:40\";i:40;s:19:\"2022-08-19 22:48:40\";i:41;s:19:\"2022-08-19 22:48:40\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1660948270\";s:7:\"message\";s:50:\"Cannot read properties of null (reading \\\'clone\\\')\";s:3:\"url\";s:97:\"https://mobile.parskalas.com/wp-content/plugins/elementor/assets/lib/pickr/pickr.min.js?ver=1.5.0\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"16820\";}}s:32:\"717e171359922c0f1dda7c31f1a56e95\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:5:\"21012\";s:7:\"\0*\0file\";s:97:\"https://mobile.parskalas.com/wp-content/plugins/elementor/assets/lib/pickr/pickr.min.js?ver=1.5.0\";s:7:\"\0*\0line\";s:1:\"2\";s:7:\"\0*\0date\";s:19:\"2022-08-19 22:31:10\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:65:\"Cannot read properties of null (reading \\&#039;changestop\\&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:31;s:14:\"\0*\0times_dates\";a:31:{i:0;s:19:\"2022-08-19 22:31:10\";i:1;s:19:\"2022-08-19 22:31:10\";i:2;s:19:\"2022-08-19 22:31:11\";i:3;s:19:\"2022-08-19 22:31:12\";i:4;s:19:\"2022-08-19 22:31:12\";i:5;s:19:\"2022-08-19 22:31:15\";i:6;s:19:\"2022-08-19 22:31:17\";i:7;s:19:\"2022-08-19 22:31:19\";i:8;s:19:\"2022-08-19 22:31:20\";i:9;s:19:\"2022-08-19 22:31:24\";i:10;s:19:\"2022-08-19 22:31:25\";i:11;s:19:\"2022-08-19 22:31:26\";i:12;s:19:\"2022-08-19 22:31:27\";i:13;s:19:\"2022-08-19 22:31:28\";i:14;s:19:\"2022-08-19 22:31:29\";i:15;s:19:\"2022-08-19 22:31:38\";i:16;s:19:\"2022-08-19 22:38:35\";i:17;s:19:\"2022-08-19 22:38:38\";i:18;s:19:\"2022-08-19 22:38:40\";i:19;s:19:\"2022-08-19 22:38:45\";i:20;s:19:\"2022-08-19 22:38:59\";i:21;s:19:\"2022-08-19 22:44:03\";i:22;s:19:\"2022-08-19 22:44:10\";i:23;s:19:\"2022-08-19 22:44:20\";i:24;s:19:\"2022-08-19 22:44:23\";i:25;s:19:\"2022-08-19 22:44:27\";i:26;s:19:\"2022-08-19 22:44:30\";i:27;s:19:\"2022-08-19 22:48:33\";i:28;s:19:\"2022-08-19 22:48:35\";i:29;s:19:\"2022-08-19 22:48:35\";i:30;s:19:\"2022-08-19 22:48:40\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1660948270\";s:7:\"message\";s:55:\"Cannot read properties of null (reading \\\'changestop\\\')\";s:3:\"url\";s:97:\"https://mobile.parskalas.com/wp-content/plugins/elementor/assets/lib/pickr/pickr.min.js?ver=1.5.0\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"21012\";}}s:32:\"1410ec22ae5ed73a32f6d26ae0c856a1\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:110:\"/home2/parskal6/domains/mobile.parskalas.com/public_html/wp-content/plugins/elementor/core/logger/items/js.php\";s:7:\"\0*\0line\";i:17;s:7:\"\0*\0date\";s:19:\"2022-08-20 02:01:22\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:20:\"Undefined index: url\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:3;s:14:\"\0*\0times_dates\";a:3:{i:0;s:19:\"2022-08-20 02:01:22\";i:1;s:19:\"2022-08-20 02:01:37\";i:2;s:19:\"2022-08-20 02:18:39\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:20:\"Undefined index: url\";s:4:\"file\";s:110:\"/home2/parskal6/domains/mobile.parskalas.com/public_html/wp-content/plugins/elementor/core/logger/items/js.php\";s:4:\"line\";i:17;s:5:\"trace\";b:1;}}s:32:\"3c6c35d318c24c12dd804b35877cd11d\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:91:\"/home/parskal1/mobile.parskalas.com/wp-content/plugins/elementor/includes/controls/base.php\";s:7:\"\0*\0line\";i:62;s:7:\"\0*\0date\";s:19:\"2025-03-28 19:41:06\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:66:\"Out of memory (allocated 39845888) (tried to allocate 65536 bytes)\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-28 19:41:06\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:5:\"error\";s:7:\"message\";s:66:\"Out of memory (allocated 39845888) (tried to allocate 65536 bytes)\";s:4:\"file\";s:91:\"/home/parskal1/mobile.parskalas.com/wp-content/plugins/elementor/includes/controls/base.php\";s:4:\"line\";i:62;s:5:\"trace\";b:1;}}s:32:\"3e169ad46cd8b09754465c2c29b0aa8e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-15 11:32:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-15 11:32:16\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"f4c895d9c0521d669bddce102c444193\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-15 11:32:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-15 11:32:16\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"df7c49e1777ddbf8d574fbe7a797c393\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-15 11:32:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-15 11:32:16\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"b03c80afd081d4127ec6363cd52438ad\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-15 11:32:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:68:\"المنتور/Upgrades - _v_3_8_0_fix_php8_image_custom_size Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-15 11:32:16\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:68:\"المنتور/Upgrades - _v_3_8_0_fix_php8_image_custom_size Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"c1c8089b29f5678c36f7af85afc8b142\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-15 11:32:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:70:\"المنتور/Upgrades - _v_3_8_0_fix_php8_image_custom_size Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-15 11:32:16\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:70:\"المنتور/Upgrades - _v_3_8_0_fix_php8_image_custom_size Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"116a2235883586202cad72f03b76779c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-15 11:32:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:60:\"المنتور/Upgrades - _v_3_16_0_container_updates Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-15 11:32:16\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:60:\"المنتور/Upgrades - _v_3_16_0_container_updates Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"e8817cab55d18138af8c0eea777a34e2\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-15 11:32:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:62:\"المنتور/Upgrades - _v_3_16_0_container_updates Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-15 11:32:16\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:62:\"المنتور/Upgrades - _v_3_16_0_container_updates Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"c405e796c112124211387fdb5fec18dd\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-15 11:32:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:64:\"المنتور/Upgrades - _v_3_17_0_site_settings_updates Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-15 11:32:16\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:64:\"المنتور/Upgrades - _v_3_17_0_site_settings_updates Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"f8ba5f5f09a8e43713977b019992ea2f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-15 11:32:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:66:\"المنتور/Upgrades - _v_3_17_0_site_settings_updates Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-15 11:32:16\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:66:\"المنتور/Upgrades - _v_3_17_0_site_settings_updates Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"19887ca855e9ab63c19a9b1a5a18a57d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-15 11:32:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:42:\"المنتور/Upgrades - _v_3_26_0 Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-15 11:32:16\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:42:\"المنتور/Upgrades - _v_3_26_0 Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"cb1bc796bb8cddd20f3702b789d4f53e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-15 11:32:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"المنتور/Upgrades - _v_3_26_0 Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-15 11:32:16\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"المنتور/Upgrades - _v_3_26_0 Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"d3be097dc30f987e399e592a36484bce\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-15 11:32:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.6.6\";s:2:\"to\";s:6:\"3.29.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-15 11:32:16\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.6.6\";s:2:\"to\";s:6:\"3.29.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"2f6b5d495adc371a93bdd98c0f108dc4\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-15 11:32:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.6.6\";s:2:\"to\";s:6:\"3.29.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-15 11:32:16\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.6.6\";s:2:\"to\";s:6:\"3.29.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}}", "off");
INSERT INTO `wp_options` VALUES("2700", "elementor_allow_tracking", "no", "yes");
INSERT INTO `wp_options` VALUES("2701", "elementor_tracker_notice", "1", "yes");
INSERT INTO `wp_options` VALUES("3832", "db_upgraded", "", "on");
INSERT INTO `wp_options` VALUES("3837", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:21:\"nextappteam@gmail.com\";s:7:\"version\";s:5:\"6.7.1\";s:9:\"timestamp\";i:1732210297;}", "off");
INSERT INTO `wp_options` VALUES("5283", "44a099f18b3f4cde5f3eaedf5a84cdd5", "{\"starter\":\"NDVlNzM5MjctNTA2NC00MzJiLWE5M2YtNTE0NThlMTZlZTFi\",\"action\":1,\"message\":\"\\u0644\\u0627\\u06cc\\u0633\\u0646\\u0633 \\u0645\\u0639\\u062a\\u0628\\u0631 \\u0645\\u06cc\\u0628\\u0627\\u0634\\u062f.\",\"timer\":1643896078}", "yes");
INSERT INTO `wp_options` VALUES("5918", "woocommerce_sales_record_date", "2023-06-11", "yes");
INSERT INTO `wp_options` VALUES("5919", "woocommerce_sales_record_amount", "266910000", "yes");
INSERT INTO `wp_options` VALUES("5867", "PW_Options", "a:20:{s:15:\"fix_orders_list\";s:2:\"no\";s:24:\"enable_jalali_datepicker\";s:3:\"yes\";s:14:\"allowed_states\";s:3:\"all\";s:18:\"enable_iran_cities\";s:3:\"yes\";s:15:\"flip_state_city\";s:3:\"yes\";s:15:\"fix_load_states\";s:3:\"yes\";s:27:\"fix_postcode_persian_number\";s:3:\"yes\";s:19:\"postcode_validation\";s:2:\"no\";s:24:\"fix_phone_persian_number\";s:3:\"yes\";s:16:\"phone_validation\";s:2:\"no\";s:27:\"remove_extra_field_physical\";s:2:\"no\";s:21:\"enable_call_for_price\";s:2:\"no\";s:19:\"call_for_price_text\";s:38:\"<strong>تماس بگیرید</strong>\";s:30:\"call_for_price_text_on_archive\";s:38:\"<strong>تماس بگیرید</strong>\";s:27:\"call_for_price_text_on_home\";s:38:\"<strong>تماس بگیرید</strong>\";s:30:\"call_for_price_text_on_related\";s:38:\"<strong>تماس بگیرید</strong>\";s:29:\"call_for_price_hide_sale_sign\";s:2:\"no\";s:13:\"persian_price\";s:2:\"no\";s:14:\"variable_price\";s:11:\"min_regular\";s:20:\"minimum_order_amount\";s:1:\"0\";}", "yes");
INSERT INTO `wp_options` VALUES("6696", "yith_wcwl_wishlist_page_id", "889", "yes");
INSERT INTO `wp_options` VALUES("6697", "yith_wcwl_version", "3.5.0", "yes");
INSERT INTO `wp_options` VALUES("6698", "yith_wcwl_db_version", "3.0.0", "yes");
INSERT INTO `wp_options` VALUES("6699", "yith_wcwl_ajax_enable", "no", "yes");
INSERT INTO `wp_options` VALUES("6700", "yith_wfbt_enable_integration", "yes", "yes");
INSERT INTO `wp_options` VALUES("6701", "yith_wcwl_after_add_to_wishlist_behaviour", "remove", "yes");
INSERT INTO `wp_options` VALUES("6702", "yith_wcwl_show_on_loop", "no", "yes");
INSERT INTO `wp_options` VALUES("6703", "yith_wcwl_loop_position", "after_add_to_cart", "yes");
INSERT INTO `wp_options` VALUES("6704", "yith_wcwl_button_position", "shortcode", "yes");
INSERT INTO `wp_options` VALUES("6705", "yith_wcwl_add_to_wishlist_text", "", "yes");
INSERT INTO `wp_options` VALUES("6706", "yith_wcwl_product_added_text", "محصول با موفقیت اضافه شد.", "yes");
INSERT INTO `wp_options` VALUES("6707", "yith_wcwl_browse_wishlist_text", "", "yes");
INSERT INTO `wp_options` VALUES("6708", "yith_wcwl_already_in_wishlist_text", "", "yes");
INSERT INTO `wp_options` VALUES("6767", "yith_wcwl_color_add_to_wishlist", "a:6:{s:10:\"background\";s:7:\"#333333\";s:4:\"text\";s:7:\"#FFFFFF\";s:6:\"border\";s:7:\"#333333\";s:16:\"background_hover\";s:7:\"#333333\";s:10:\"text_hover\";s:7:\"#FFFFFF\";s:12:\"border_hover\";s:7:\"#333333\";}", "yes");
INSERT INTO `wp_options` VALUES("6709", "yith_wcwl_add_to_wishlist_style", "link", "yes");
INSERT INTO `wp_options` VALUES("6710", "yith_wcwl_rounded_corners_radius", "16", "yes");
INSERT INTO `wp_options` VALUES("6711", "yith_wcwl_add_to_wishlist_icon", "fa-heart-o", "yes");
INSERT INTO `wp_options` VALUES("6712", "yith_wcwl_add_to_wishlist_custom_icon", "", "yes");
INSERT INTO `wp_options` VALUES("6713", "yith_wcwl_added_to_wishlist_icon", "fa-heart", "yes");
INSERT INTO `wp_options` VALUES("6714", "yith_wcwl_added_to_wishlist_custom_icon", "", "yes");
INSERT INTO `wp_options` VALUES("6715", "yith_wcwl_custom_css", "", "yes");
INSERT INTO `wp_options` VALUES("6716", "yith_wcwl_variation_show", "", "yes");
INSERT INTO `wp_options` VALUES("6717", "yith_wcwl_price_show", "yes", "yes");
INSERT INTO `wp_options` VALUES("6718", "yith_wcwl_stock_show", "yes", "yes");
INSERT INTO `wp_options` VALUES("6719", "yith_wcwl_show_dateadded", "", "yes");
INSERT INTO `wp_options` VALUES("6720", "yith_wcwl_add_to_cart_show", "yes", "yes");
INSERT INTO `wp_options` VALUES("6721", "yith_wcwl_show_remove", "yes", "yes");
INSERT INTO `wp_options` VALUES("6722", "yith_wcwl_repeat_remove_button", "", "yes");
INSERT INTO `wp_options` VALUES("6723", "yith_wcwl_redirect_cart", "no", "yes");
INSERT INTO `wp_options` VALUES("6724", "yith_wcwl_remove_after_add_to_cart", "yes", "yes");
INSERT INTO `wp_options` VALUES("6725", "yith_wcwl_enable_share", "yes", "yes");
INSERT INTO `wp_options` VALUES("6726", "yith_wcwl_share_fb", "yes", "yes");
INSERT INTO `wp_options` VALUES("6727", "yith_wcwl_share_twitter", "yes", "yes");
INSERT INTO `wp_options` VALUES("6728", "yith_wcwl_share_pinterest", "yes", "yes");
INSERT INTO `wp_options` VALUES("6729", "yith_wcwl_share_email", "yes", "yes");
INSERT INTO `wp_options` VALUES("6730", "yith_wcwl_share_whatsapp", "yes", "yes");
INSERT INTO `wp_options` VALUES("6731", "yith_wcwl_share_url", "no", "yes");
INSERT INTO `wp_options` VALUES("6732", "yith_wcwl_socials_title", "لیست علاقه مندی های من در فروشگاه اینترنتی پارس کالا", "yes");
INSERT INTO `wp_options` VALUES("6733", "yith_wcwl_socials_text", "", "yes");
INSERT INTO `wp_options` VALUES("6734", "yith_wcwl_socials_image_url", "", "yes");
INSERT INTO `wp_options` VALUES("6735", "yith_wcwl_wishlist_title", "لیست علاقه مندی های من", "yes");
INSERT INTO `wp_options` VALUES("6736", "yith_wcwl_add_to_cart_text", "افزودن به سبد خرید", "yes");
INSERT INTO `wp_options` VALUES("6737", "yith_wcwl_add_to_cart_style", "link", "yes");
INSERT INTO `wp_options` VALUES("6738", "yith_wcwl_add_to_cart_rounded_corners_radius", "16", "yes");
INSERT INTO `wp_options` VALUES("6739", "yith_wcwl_add_to_cart_icon", "fa-shopping-cart", "yes");
INSERT INTO `wp_options` VALUES("6740", "yith_wcwl_add_to_cart_custom_icon", "", "yes");
INSERT INTO `wp_options` VALUES("7959", "r_notice_data", "Error: Network connection lost.", "yes");
INSERT INTO `wp_options` VALUES("7960", "redux_blast", "1644754454", "yes");
INSERT INTO `wp_options` VALUES("6741", "yith_wcwl_color_headers_background", "#F4F4F4", "yes");
INSERT INTO `wp_options` VALUES("6742", "yith_wcwl_fb_button_icon", "fa-facebook", "yes");
INSERT INTO `wp_options` VALUES("6743", "yith_wcwl_fb_button_custom_icon", "", "yes");
INSERT INTO `wp_options` VALUES("6744", "yith_wcwl_tw_button_icon", "fa-twitter", "yes");
INSERT INTO `wp_options` VALUES("6745", "yith_wcwl_tw_button_custom_icon", "", "yes");
INSERT INTO `wp_options` VALUES("6746", "yith_wcwl_pr_button_icon", "fa-pinterest", "yes");
INSERT INTO `wp_options` VALUES("6747", "yith_wcwl_pr_button_custom_icon", "", "yes");
INSERT INTO `wp_options` VALUES("6748", "yith_wcwl_em_button_icon", "fa-envelope-o", "yes");
INSERT INTO `wp_options` VALUES("6749", "yith_wcwl_em_button_custom_icon", "", "yes");
INSERT INTO `wp_options` VALUES("6750", "yith_wcwl_wa_button_icon", "fa-whatsapp", "yes");
INSERT INTO `wp_options` VALUES("6751", "yith_wcwl_wa_button_custom_icon", "", "yes");
INSERT INTO `wp_options` VALUES("9213", "recovery_mode_email_last_sent", "1658619846", "yes");
INSERT INTO `wp_options` VALUES("13210", "_elementor_editor_upgrade_notice_dismissed", "1736246406", "yes");
INSERT INTO `wp_options` VALUES("12942", "redirect_to_woo_sms_about_page", "no", "yes");
INSERT INTO `wp_options` VALUES("12943", "redirect_to_woo_sms_about_page_check", "no", "yes");
INSERT INTO `wp_options` VALUES("12944", "sms_main_settings", "a:12:{s:14:\"enable_plugins\";s:2:\"on\";s:16:\"enable_admin_bar\";s:2:\"on\";s:10:\"enable_sms\";s:3:\"off\";s:11:\"sms_gateway\";s:4:\"none\";s:24:\"persian_woo_sms_username\";s:0:\"\";s:24:\"persian_woo_sms_password\";s:0:\"\";s:22:\"persian_woo_sms_sender\";s:0:\"\";s:9:\"enable_tg\";s:3:\"off\";s:10:\"tg_gateway\";s:4:\"none\";s:23:\"persian_woo_tg_username\";s:0:\"\";s:23:\"persian_woo_tg_password\";s:0:\"\";s:21:\"persian_woo_tg_sender\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("12945", "sms_buyer_settings", "a:19:{s:12:\"enable_buyer\";s:2:\"on\";s:17:\"buyer_phone_label\";s:19:\"تلفن همراه\";s:18:\"force_enable_buyer\";s:3:\"yes\";s:19:\"buyer_checkbox_text\";s:106:\"میخواهم از وضعیت سفارش از طریق اس ام اس یا تلگرام آگاه شوم .\";s:14:\"enable_metabox\";s:3:\"off\";s:26:\"allow_buyer_select_pm_type\";s:2:\"no\";s:25:\"buyer_select_pm_type_text\";s:28:\"روش دریافت پیام\";s:25:\"allow_buyer_select_status\";s:2:\"no\";s:17:\"buyer_status_mode\";s:8:\"selector\";s:25:\"force_buyer_select_status\";s:2:\"no\";s:28:\"buyer_select_status_text_top\";s:104:\"وضعیت هایی که مایل به دریافت پیامک هستید را انتخاب نمایید\";s:31:\"buyer_select_status_text_bellow\";s:0:\"\";s:16:\"sms_body_pending\";s:275:\"سلام {b_first_name} {b_last_name}\r\nسفارش {order_id} دریافت شد و هم اکنون در وضعیت در انتظار پرداخت می باشد\r\nآیتم های سفارش : {all_items}\r\nمبلغ سفارش : {price}\r\nشماره تراکنش : {transaction_id}\";s:19:\"sms_body_processing\";s:267:\"سلام {b_first_name} {b_last_name}\r\nسفارش {order_id} دریافت شد و هم اکنون در وضعیت در حال انجام می باشد\r\nآیتم های سفارش : {all_items}\r\nمبلغ سفارش : {price}\r\nشماره تراکنش : {transaction_id}\";s:16:\"sms_body_on-hold\";s:273:\"سلام {b_first_name} {b_last_name}\r\nسفارش {order_id} دریافت شد و هم اکنون در وضعیت در انتظار بررسی می باشد\r\nآیتم های سفارش : {all_items}\r\nمبلغ سفارش : {price}\r\nشماره تراکنش : {transaction_id}\";s:18:\"sms_body_completed\";s:262:\"سلام {b_first_name} {b_last_name}\r\nسفارش {order_id} دریافت شد و هم اکنون در وضعیت تکمیل شده می باشد\r\nآیتم های سفارش : {all_items}\r\nمبلغ سفارش : {price}\r\nشماره تراکنش : {transaction_id}\";s:18:\"sms_body_cancelled\";s:258:\"سلام {b_first_name} {b_last_name}\r\nسفارش {order_id} دریافت شد و هم اکنون در وضعیت لغو شده می باشد\r\nآیتم های سفارش : {all_items}\r\nمبلغ سفارش : {price}\r\nشماره تراکنش : {transaction_id}\";s:17:\"sms_body_refunded\";s:262:\"سلام {b_first_name} {b_last_name}\r\nسفارش {order_id} دریافت شد و هم اکنون در وضعیت مسترد شده می باشد\r\nآیتم های سفارش : {all_items}\r\nمبلغ سفارش : {price}\r\nشماره تراکنش : {transaction_id}\";s:15:\"sms_body_failed\";s:257:\"سلام {b_first_name} {b_last_name}\r\nسفارش {order_id} دریافت شد و هم اکنون در وضعیت ناموفق می باشد\r\nآیتم های سفارش : {all_items}\r\nمبلغ سفارش : {price}\r\nشماره تراکنش : {transaction_id}\";}", "yes");
INSERT INTO `wp_options` VALUES("12946", "sms_super_admin_settings", "", "yes");
INSERT INTO `wp_options` VALUES("12947", "sms_product_admin_settings", "", "yes");
INSERT INTO `wp_options` VALUES("12948", "sms_notif_settings", "a:17:{s:21:\"enable_notif_sms_main\";s:2:\"on\";s:13:\"pm_type_notif\";a:1:{s:3:\"sms\";s:3:\"sms\";}s:26:\"allow_notif_select_pm_type\";s:2:\"no\";s:25:\"notif_select_pm_type_text\";s:28:\"روش دریافت پیام\";s:12:\"notif_old_pr\";s:2:\"no\";s:16:\"enable_notif_sms\";s:3:\"off\";s:11:\"notif_title\";s:52:\"به من از طریق پیامک اطلاع بده\";s:13:\"enable_onsale\";s:3:\"off\";s:17:\"notif_onsale_text\";s:39:\"زمانیکه محصول حراج شد\";s:16:\"notif_onsale_sms\";s:115:\"سلام\r\nمحصول {product_title} از قیمت {regular_price} به قیمت {onsale_price} کاهش یافت .\";s:21:\"enable_notif_no_stock\";s:2:\"on\";s:19:\"notif_no_stock_text\";s:41:\"زمانیکه محصول موجود شد\";s:18:\"notif_no_stock_sms\";s:100:\"سلام\r\nمحصول {product_title} هم اکنون موجود و قابل خرید می باشد .\";s:22:\"enable_notif_low_stock\";s:3:\"off\";s:20:\"notif_low_stock_text\";s:59:\"زمانیکه موجودی انبار محصول کم شد\";s:19:\"notif_low_stock_sms\";s:157:\"سلام\r\nموجودی محصول {product_title} کم می باشد . لطفا در صورت تمایل به خرید سریعتر اقدام نمایید .\";s:13:\"notif_options\";s:115:\"1:زمانیکه محصول توقف فروش شد\r\n2:زمانیکه نسخه جدید محصول منتشر شد\r\n\";}", "yes");
INSERT INTO `wp_options` VALUES("12949", "persianwoosms_send", "", "yes");
INSERT INTO `wp_options` VALUES("12958", "widget_woocommerceir_widget_sms", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("18427", "theme_mods_newkala", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1656703115;s:4:\"data\";a:8:{s:19:\"wp_inactive_widgets\";a:14:{i:0;s:8:\"block-14\";i:1;s:8:\"block-13\";i:2;s:8:\"block-17\";i:3;s:8:\"block-18\";i:4;s:8:\"block-19\";i:5;s:8:\"block-20\";i:6;s:7:\"block-5\";i:7;s:7:\"block-6\";i:8;s:7:\"block-2\";i:9;s:7:\"block-3\";i:10;s:7:\"block-4\";i:11;s:26:\"woocommerce_price_filter-3\";i:12;s:7:\"block-8\";i:13;s:8:\"block-11\";}s:15:\"archive-product\";a:2:{i:0;s:25:\"newkala_instock_prodcut-3\";i:1;s:8:\"block-22\";}s:13:\"footer-widget\";a:3:{i:0;s:10:\"nav_menu-4\";i:1;s:10:\"nav_menu-3\";i:2;s:10:\"nav_menu-5\";}s:11:\"blog-widget\";a:0:{}s:15:\"top-blog-widget\";a:0:{}s:12:\"index-widget\";a:0:{}s:20:\"logos_offices-widget\";a:0:{}s:20:\"woocommece_dashboard\";a:0:{}}}}", "off");
INSERT INTO `wp_options` VALUES("18428", "elementor_use_mini_cart_template", "no", "yes");
INSERT INTO `wp_options` VALUES("18429", "widget_newkala_ups", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("18430", "widget_newkala_instock_prodcut", "a:2:{s:12:\"_multiwidget\";i:1;i:3;a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("18431", "widget_pagelistwidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("155582", "woocommerce_attribute_lookup_enabled", "yes", "auto");
INSERT INTO `wp_options` VALUES("18035", "elementor_events_db_version", "1.0.0", "no");
INSERT INTO `wp_options` VALUES("18007", "woocommerce_task_list_reminder_bar_hidden", "yes", "yes");
INSERT INTO `wp_options` VALUES("17990", "fs_active_plugins", "O:8:\"stdClass\":0:{}", "yes");
INSERT INTO `wp_options` VALUES("17991", "fs_debug_mode", "", "yes");
INSERT INTO `wp_options` VALUES("17992", "fs_accounts", "a:6:{s:21:\"id_slug_type_path_map\";a:1:{i:8507;a:3:{s:4:\"slug\";s:47:\"map-location-picker-at-checkout-for-woocommerce\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:56:\"map-location-picker-at-checkout-for-woocommerce/lpac.php\";}}s:11:\"plugin_data\";a:1:{s:47:\"map-location-picker-at-checkout-for-woocommerce\";a:16:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:56:\"map-location-picker-at-checkout-for-woocommerce/lpac.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1656546170;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:1;s:16:\"sdk_last_version\";N;s:11:\"sdk_version\";s:5:\"2.4.3\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";N;s:14:\"plugin_version\";s:5:\"1.5.6\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";b:1;s:4:\"host\";s:9:\"localhost\";s:9:\"server_ip\";s:3:\"::1\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1656546170;s:7:\"version\";s:5:\"1.5.6\";}s:15:\"prev_is_premium\";b:0;s:12:\"is_anonymous\";a:3:{s:2:\"is\";b:1;s:9:\"timestamp\";i:1656546194;s:7:\"version\";s:5:\"1.5.6\";}}}s:13:\"file_slug_map\";a:1:{s:56:\"map-location-picker-at-checkout-for-woocommerce/lpac.php\";s:47:\"map-location-picker-at-checkout-for-woocommerce\";}s:7:\"plugins\";a:1:{s:47:\"map-location-picker-at-checkout-for-woocommerce\";O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";N;s:5:\"title\";s:43:\"Location Picker At Checkout For WooCommerce\";s:4:\"slug\";s:47:\"map-location-picker-at-checkout-for-woocommerce\";s:12:\"premium_slug\";s:55:\"map-location-picker-at-checkout-for-woocommerce-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:56:\"map-location-picker-at-checkout-for-woocommerce/lpac.php\";s:7:\"version\";s:5:\"1.5.6\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:3:\"PRO\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_da07de47a2bdd9391af9020cc646d\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"8507\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:0;}}s:9:\"unique_id\";s:32:\"d8ecd0c3c7036d1ebb16e49839486f10\";s:13:\"admin_notices\";a:1:{s:47:\"map-location-picker-at-checkout-for-woocommerce\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("17993", "fs_gdpr", "a:1:{s:2:\"u1\";a:1:{s:8:\"required\";b:0;}}", "yes");
INSERT INTO `wp_options` VALUES("17994", "lpac_first_install_date", "1656546172", "yes");
INSERT INTO `wp_options` VALUES("17995", "lpac_installed_at_version", "1.5.4", "no");
INSERT INTO `wp_options` VALUES("17996", "fs_api_cache", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("23123", "user_count", "4", "off");
INSERT INTO `wp_options` VALUES("15114", "eh_general_options", "a:10:{s:8:\"logo_url\";s:0:\"\";s:10:\"logo_title\";s:0:\"\";s:9:\"logo_text\";s:0:\"\";s:16:\"account_btn_link\";s:0:\"\";s:16:\"account_btn_text\";s:21:\"حساب کاربری\";s:18:\"reg_login_btn_link\";s:0:\"\";s:18:\"reg_login_btn_text\";s:27:\"ورود یا ثبت نام\";s:11:\"auto_verify\";b:0;s:13:\"code_char_num\";i:5;s:11:\"expire_date\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("16325", "woocommerce_admin_last_orders_milestone", "10", "yes");
INSERT INTO `wp_options` VALUES("14963", "eh_login_options", "a:7:{s:13:\"login_page_id\";i:1348;s:12:\"login_method\";s:4:\"code\";s:14:\"login_priority\";s:4:\"pass\";s:18:\"woo_checkout_login\";b:0;s:17:\"woo_account_login\";b:0;s:14:\"remember_field\";b:0;s:11:\"after_login\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("14967", "eh_sms_melipayamak", "a:4:{s:8:\"username\";s:11:\"09391929620\";s:8:\"password\";s:11:\"Hosein#1212\";s:4:\"from\";s:0:\"\";s:12:\"pattern_code\";s:5:\"79538\";}", "yes");
INSERT INTO `wp_options` VALUES("14968", "eh_sms", "a:3:{s:8:\"provider\";s:11:\"melipayamak\";s:25:\"enable_auxiliary_provider\";b:0;s:18:\"auxiliary_provider\";s:11:\"melipayamak\";}", "yes");
INSERT INTO `wp_options` VALUES("29659", "wc_downloads_approved_directories_mode", "disabled", "yes");
INSERT INTO `wp_options` VALUES("16549", "widget_parskala_brands_prodcut", "a:2:{s:12:\"_multiwidget\";i:1;i:3;a:1:{s:11:\"title_posts\";s:13:\"برند ها\";}}", "yes");
INSERT INTO `wp_options` VALUES("16543", "woo_order_options", "a:64:{s:15:\"whatsapp_number\";s:0:\"\";s:16:\"user_role_option\";s:7:\"default\";s:19:\"hide_wa_btn_desktop\";s:0:\"\";s:17:\"open_link_new_tab\";b:1;s:16:\"display_on_items\";b:1;s:13:\"hide_item_btn\";b:1;s:21:\"enquiry_btn_text_item\";s:28:\"سفارش از واتساپ\";s:17:\"message_body_item\";s:329:\"سلام وقت بخیر بنده میخوام محصولات زیر رو سفارش بدم\r\n\r\n--- نام محصول: {{product_name}}\r\n\r\n--- قیمت محصول: {{product_price}}\r\n\r\n--- شناسه محصول: {{product_sku}}\r\n\r\n--- نوع محصول: {{product_type}}\r\n\r\n--- لینک محصول: {{product_url}}\r\n\r\nباتشکر\";s:22:\"display_on_single_page\";b:1;s:13:\"hide_cart_btn\";b:1;s:16:\"enquiry_btn_text\";s:28:\"سفارش از واتساپ\";s:17:\"btn_position_hook\";s:36:\"woocommerce_after_add_to_cart_button\";s:12:\"message_body\";s:389:\"سلام وقت بخیر بنده میخوام محصولات زیر رو سفارش بدم\r\n\r\n--- نام محصول: {{product_name}}\r\n\r\n--- قیمت محصول: {{product_price}}\r\n\r\n--- شناسه محصول: {{product_sku}}\r\n\r\n--- نوع محصول: {{product_type}}\r\n\r\n--- متغییرهای محصول:{{product_variations}}\r\n\r\n--- لینک محصول: {{product_url}}\r\n\r\nباتشکر\";s:20:\"enable_category_wise\";s:0:\"\";s:24:\"select_pro_category_list\";s:0:\"\";s:20:\"display_on_cart_page\";b:1;s:17:\"hide_checkout_btn\";b:1;s:21:\"enquiry_btn_text_cart\";s:28:\"سفارش از واتساپ\";s:22:\"btn_position_hook_cart\";s:31:\"woocommerce_proceed_to_checkout\";s:16:\"body_header_cart\";s:80:\"سلام وقت بخیر بنده محصولات زیر رو سفارش دادم\";s:17:\"message_body_cart\";s:269:\"\r\n--- نام محصول: {{product_name}}\r\n\r\n--- قیمت محصول: {{product_price}}\r\n\r\n--- تعداد: {{product_quantity}}\r\n\r\n--- شناسه محصول: {{product_sku}}\r\n\r\n--- لینک محصول: {{product_url}}\r\n------------------------------------------------\r\n\";s:16:\"body_footer_cart\";s:25:\"باتشکر فراوان\";s:24:\"display_on_checkout_page\";b:1;s:20:\"body_header_checkout\";s:34:\"سفارش شما عبارت از:\";s:13:\"display_order\";b:1;s:20:\"body_footer_checkout\";s:12:\"باتشکر\";s:10:\"single_btn\";s:0:\"\";s:12:\"single_width\";s:0:\"\";s:13:\"single_margin\";s:0:\"\";s:14:\"single_padding\";s:0:\"\";s:13:\"single_radius\";s:0:\"\";s:11:\"single_font\";s:0:\"\";s:18:\"single_font_weight\";s:0:\"\";s:12:\"single_color\";s:0:\"\";s:18:\"single_color_hover\";s:0:\"\";s:16:\"single_font_icon\";s:0:\"\";s:8:\"item_btn\";s:0:\"\";s:10:\"item_width\";s:0:\"\";s:11:\"item_margin\";s:0:\"\";s:12:\"item_padding\";s:0:\"\";s:11:\"item_radius\";s:0:\"\";s:9:\"item_font\";s:0:\"\";s:16:\"item_font_weight\";s:0:\"\";s:10:\"item_color\";s:0:\"\";s:16:\"item_color_hover\";s:0:\"\";s:14:\"item_font_icon\";s:0:\"\";s:8:\"cart_btn\";s:0:\"\";s:10:\"cart_width\";s:0:\"\";s:11:\"cart_margin\";s:0:\"\";s:12:\"cart_padding\";s:0:\"\";s:11:\"cart_radius\";s:0:\"\";s:9:\"cart_font\";s:0:\"\";s:16:\"cart_font_weight\";s:0:\"\";s:10:\"cart_color\";s:0:\"\";s:16:\"cart_color_hover\";s:0:\"\";s:14:\"cart_font_icon\";s:0:\"\";s:12:\"thankyou_btn\";s:6:\"modern\";s:14:\"thankyou_width\";s:5:\"200px\";s:15:\"thankyou_radius\";s:0:\"\";s:13:\"thankyou_font\";s:0:\"\";s:20:\"thankyou_font_weight\";s:0:\"\";s:14:\"thankyou_color\";s:0:\"\";s:20:\"thankyou_color_hover\";s:0:\"\";s:18:\"thankyou_font_icon\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("30853", "dokan_reverse_withdrawal_product_id", "2278", "yes");
INSERT INTO `wp_options` VALUES("30854", "widget_dokan-filter-product", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("16547", "send_options", "a:5:{s:13:\"show_day_send\";s:1:\"1\";s:17:\"required_day_send\";s:1:\"1\";s:15:\"show_timer_send\";s:1:\"1\";s:19:\"required_timer_send\";s:1:\"1\";s:20:\"list_send_time_order\";a:1:{i:0;a:1:{s:15:\"time_send_order\";s:23:\"ساعت ۱۰ تا ۲۲\";}}}", "yes");
INSERT INTO `wp_options` VALUES("16550", "widget_parskala_categorys_prodcut", "a:2:{s:12:\"_multiwidget\";i:1;i:3;a:1:{s:11:\"title_posts\";s:22:\"دسته بندی ها\";}}", "yes");
INSERT INTO `wp_options` VALUES("17107", "theme_mods_emperor", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1656275878;s:4:\"data\";a:12:{s:19:\"wp_inactive_widgets\";a:14:{i:0;s:8:\"block-14\";i:1;s:8:\"block-13\";i:2;s:8:\"block-17\";i:3;s:8:\"block-18\";i:4;s:8:\"block-19\";i:5;s:8:\"block-20\";i:6;s:7:\"block-5\";i:7;s:7:\"block-6\";i:8;s:7:\"block-2\";i:9;s:7:\"block-3\";i:10;s:7:\"block-4\";i:11;s:26:\"woocommerce_price_filter-3\";i:12;s:7:\"block-8\";i:13;s:8:\"block-11\";}s:9:\"sidebar-1\";a:0:{}s:15:\"single_blog_ads\";a:0:{}s:12:\"sidebar_page\";a:0:{}s:13:\"course_page_1\";a:0:{}s:13:\"course_page_2\";a:0:{}s:18:\"course_page_mobile\";a:0:{}s:15:\"herowp-footer-1\";a:3:{i:0;s:10:\"nav_menu-4\";i:1;s:10:\"nav_menu-3\";i:2;s:10:\"nav_menu-5\";}s:15:\"herowp-footer-2\";a:0:{}s:15:\"herowp-footer-3\";a:0:{}s:15:\"herowp-footer-4\";a:0:{}s:12:\"sidebar_shop\";a:0:{}}}s:18:\"custom_css_post_id\";i:-1;}", "off");
INSERT INTO `wp_options` VALUES("17108", "RTL-CareUnit-PIL", "q1bKSS1LzVGyUnJMLsksSyzJzM9T0lEqLkksKS0GigaXJienFhcDhVJSi5OLMgvACqyUlGoB", "no");
INSERT INTO `wp_options` VALUES("17109", "auto_update_plugins", "a:1:{i:0;s:29:\"RTL-CareUnit/RTL-CareUnit.php\";}", "no");
INSERT INTO `wp_options` VALUES("17110", "RTL-CareUnit-FPA", "1", "yes");
INSERT INTO `wp_options` VALUES("17111", "widget_contacts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("18434", "puc_external_updates_theme-newkala", "O:8:\"stdClass\":5:{s:9:\"lastCheck\";i:1656703062;s:14:\"checkedVersion\";s:5:\"6.4.9\";s:6:\"update\";O:8:\"stdClass\":5:{s:4:\"slug\";s:7:\"newkala\";s:7:\"version\";s:5:\"6.4.9\";s:12:\"download_url\";s:56:\"https://product-mirzacode.ir/updatefiles/newkala-649.zip\";s:12:\"translations\";a:0:{}s:11:\"details_url\";s:36:\"https://product-mirzacode.ir/newkala\";}s:11:\"updateClass\";s:21:\"Puc_v4p7_Theme_Update\";s:15:\"updateBaseClass\";s:12:\"Theme_Update\";}", "no");
INSERT INTO `wp_options` VALUES("18437", "acf_version", "5.9.1", "yes");
INSERT INTO `wp_options` VALUES("18438", "timestamped_offers", "1", "yes");
INSERT INTO `wp_options` VALUES("17972", "alg_wc_pvbc_version", "1.4.8", "yes");
INSERT INTO `wp_options` VALUES("18440", "newkala", "1", "yes");
INSERT INTO `wp_options` VALUES("50802", "product_cat_children", "a:3:{i:21;a:15:{i:0;i:22;i:1;i:39;i:2;i:53;i:3;i:57;i:4;i:58;i:5;i:59;i:6;i:60;i:7;i:61;i:8;i:62;i:9;i:63;i:10;i:64;i:11;i:165;i:12;i:176;i:13;i:179;i:14;i:184;}i:16;a:2:{i:0;i:110;i:1;i:166;}i:70;a:1:{i:0;i:127;}}", "yes");
INSERT INTO `wp_options` VALUES("20217", "thwvs_swatches_design_settings", "a:8:{i:1;s:15:\"swatch_design_2\";i:2;s:15:\"swatch_design_1\";i:3;s:15:\"swatch_design_3\";i:4;s:21:\"swatch_design_default\";i:5;s:21:\"swatch_design_default\";i:6;s:21:\"swatch_design_default\";i:7;s:21:\"swatch_design_default\";i:8;s:21:\"swatch_design_default\";}", "yes");
INSERT INTO `wp_options` VALUES("20263", "thwvs_swatches_advanced_settings", "a:5:{s:21:\"swatch_design_default\";a:14:{s:11:\"design_name\";s:14:\"Default Design\";s:11:\"icon_height\";s:4:\"45px\";s:10:\"icon_width\";s:4:\"45px\";s:10:\"icon_shape\";s:6:\"square\";s:17:\"icon_label_height\";s:4:\"45px\";s:16:\"icon_label_width\";s:4:\"45px\";s:10:\"label_size\";s:4:\"16px\";s:22:\"label_background_color\";s:4:\"#fff\";s:16:\"label_text_color\";s:4:\"#000\";s:14:\"tooltip_enable\";s:3:\"yes\";s:29:\"tooltip_text_background_color\";s:7:\"#232323\";s:18:\"tooltip_text_color\";s:7:\"#ffffff\";s:26:\"icon_border_color_selected\";s:7:\"#0071e3\";s:23:\"icon_border_color_hover\";s:7:\"#cde4fd\";}s:22:\"swatch_global_settings\";a:7:{s:12:\"auto_convert\";s:2:\"no\";s:24:\"ajax_variation_threshold\";s:2:\"30\";s:12:\"clear_select\";s:3:\"yes\";s:18:\"show_item_on_label\";s:2:\"no\";s:19:\"disable_style_sheet\";s:2:\"no\";s:34:\"behavior_for_unavailable_variation\";s:15:\"blur_with_cross\";s:24:\"behavior_of_out_of_stock\";s:7:\"default\";}s:15:\"swatch_design_1\";a:14:{s:11:\"design_name\";s:8:\"Design 1\";s:11:\"icon_height\";s:4:\"35px\";s:10:\"icon_width\";s:4:\"35px\";s:10:\"icon_shape\";s:6:\"square\";s:17:\"icon_label_height\";s:4:\"35px\";s:16:\"icon_label_width\";s:4:\"35px\";s:10:\"label_size\";s:4:\"16px\";s:22:\"label_background_color\";s:4:\"#fff\";s:16:\"label_text_color\";s:4:\"#000\";s:14:\"tooltip_enable\";s:3:\"yes\";s:29:\"tooltip_text_background_color\";s:7:\"#000000\";s:18:\"tooltip_text_color\";s:7:\"#ffffff\";s:26:\"icon_border_color_selected\";s:7:\"#1a85f9\";s:23:\"icon_border_color_hover\";s:7:\"#7ec0fb\";}s:15:\"swatch_design_2\";a:14:{s:11:\"design_name\";s:8:\"Design 2\";s:11:\"icon_height\";s:4:\"35px\";s:10:\"icon_width\";s:4:\"35px\";s:10:\"icon_shape\";s:5:\"round\";s:17:\"icon_label_height\";s:4:\"45px\";s:16:\"icon_label_width\";s:4:\"45px\";s:10:\"label_size\";s:4:\"16px\";s:22:\"label_background_color\";s:4:\"#fff\";s:16:\"label_text_color\";s:4:\"#000\";s:14:\"tooltip_enable\";s:3:\"yes\";s:29:\"tooltip_text_background_color\";s:7:\"#000000\";s:18:\"tooltip_text_color\";s:7:\"#ffffff\";s:26:\"icon_border_color_selected\";s:7:\"#827d7d\";s:23:\"icon_border_color_hover\";s:7:\"#aaaaaa\";}s:15:\"swatch_design_3\";a:14:{s:11:\"design_name\";s:8:\"Design 3\";s:11:\"icon_height\";s:4:\"35px\";s:10:\"icon_width\";s:4:\"35px\";s:10:\"icon_shape\";s:6:\"square\";s:17:\"icon_label_height\";s:4:\"45px\";s:16:\"icon_label_width\";s:4:\"45px\";s:10:\"label_size\";s:4:\"16px\";s:22:\"label_background_color\";s:4:\"#fff\";s:16:\"label_text_color\";s:4:\"#000\";s:14:\"tooltip_enable\";s:3:\"yes\";s:29:\"tooltip_text_background_color\";s:7:\"#000000\";s:18:\"tooltip_text_color\";s:7:\"#ffffff\";s:26:\"icon_border_color_selected\";s:7:\"#2f90f8\";s:23:\"icon_border_color_hover\";s:7:\"#98ccfa\";}}", "yes");
INSERT INTO `wp_options` VALUES("31547", "wp-smush-settings", "a:24:{s:4:\"auto\";b:1;s:5:\"lossy\";b:1;s:10:\"strip_exif\";b:1;s:6:\"resize\";b:0;s:9:\"detection\";b:1;s:8:\"original\";b:1;s:6:\"backup\";b:1;s:8:\"no_scale\";b:0;s:10:\"png_to_jpg\";b:0;s:7:\"nextgen\";b:0;s:2:\"s3\";b:0;s:9:\"gutenberg\";b:0;s:10:\"js_builder\";b:0;s:5:\"gform\";b:0;s:3:\"cdn\";b:1;s:11:\"auto_resize\";b:0;s:4:\"webp\";b:1;s:5:\"usage\";b:0;s:17:\"accessible_colors\";b:0;s:9:\"keep_data\";b:1;s:9:\"lazy_load\";b:1;s:17:\"background_images\";b:1;s:16:\"rest_api_support\";b:0;s:8:\"webp_mod\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("31548", "wp-smush-install-type", "existing", "no");
INSERT INTO `wp_options` VALUES("31549", "wp-smush-version", "3.10.3", "no");
INSERT INTO `wp_options` VALUES("31554", "smush_global_stats", "a:9:{s:11:\"size_before\";i:58305107;s:10:\"size_after\";i:37970927;s:7:\"percent\";d:34.899999999999999;s:5:\"human\";s:19:\"19,4 مگابایت\";s:5:\"bytes\";i:20334180;s:12:\"total_images\";i:1882;s:12:\"resize_count\";i:0;s:14:\"resize_savings\";i:0;s:18:\"conversion_savings\";i:0;}", "no");
INSERT INTO `wp_options` VALUES("31557", "wp-smush-preset_configs", "a:2:{i:0;a:5:{s:2:\"id\";i:1;s:4:\"name\";s:14:\"Default config\";s:11:\"description\";s:58:\"پیکربندی توصیه شده برای هر سایت.\";s:6:\"config\";a:2:{s:7:\"configs\";a:1:{s:8:\"settings\";a:22:{s:4:\"auto\";b:1;s:5:\"lossy\";b:1;s:10:\"strip_exif\";b:1;s:6:\"resize\";b:0;s:9:\"detection\";b:0;s:8:\"original\";b:1;s:6:\"backup\";b:1;s:10:\"png_to_jpg\";b:1;s:7:\"nextgen\";b:0;s:2:\"s3\";b:0;s:9:\"gutenberg\";b:0;s:10:\"js_builder\";b:0;s:3:\"cdn\";b:0;s:11:\"auto_resize\";b:0;s:4:\"webp\";b:1;s:5:\"usage\";b:0;s:17:\"accessible_colors\";b:0;s:9:\"keep_data\";b:1;s:9:\"lazy_load\";b:0;s:17:\"background_images\";b:1;s:16:\"rest_api_support\";b:0;s:8:\"webp_mod\";b:0;}}s:7:\"strings\";a:6:{s:10:\"bulk_smush\";a:1:{i:0;s:305:\"فشرده سازی خودکار - فعال کردن سوپر اسماش - فعال کردن متا دیتا - فعال کردن تغییر اندازه تصویر - غیر فعال Original Images - فعال کردن Backup Original Images - فعال کردن تبدیل PNG به JPEG - فعال کردن\";}s:9:\"lazy_load\";a:1:{i:0;s:15:\"غیر فعال\";}s:3:\"cdn\";a:1:{i:0;s:15:\"غیر فعال\";}s:8:\"webp_mod\";a:1:{i:0;s:15:\"غیر فعال\";}s:12:\"integrations\";a:1:{i:0;s:163:\"پشتیبانی گوتنبرگ - غیر فعال صفحه ساز WPBakery - غیر فعال آمازون S3 - غیر فعال گالری NextGen - غیر فعال\";}s:8:\"settings\";a:1:{i:0;s:244:\"تشخیص تغییر اندازه تصویر - غیر فعال قابلیت دسترسی رنگ - غیر فعال ردیابی میزان مصرف - غیر فعال اطلاعات را در حالت حذف نگه دارید - فعال کردن\";}}}s:7:\"default\";b:1;}i:1;a:4:{s:2:\"id\";i:1658982913994;s:4:\"name\";s:14:\"Default config\";s:11:\"description\";s:58:\"پیکربندی توصیه شده برای هر سایت.\";s:6:\"config\";a:2:{s:7:\"configs\";a:2:{s:8:\"settings\";a:24:{s:4:\"auto\";b:1;s:5:\"lossy\";b:1;s:10:\"strip_exif\";b:1;s:6:\"resize\";b:0;s:9:\"detection\";b:1;s:8:\"original\";b:1;s:6:\"backup\";b:1;s:8:\"no_scale\";b:0;s:10:\"png_to_jpg\";b:0;s:7:\"nextgen\";b:0;s:2:\"s3\";b:0;s:9:\"gutenberg\";b:0;s:10:\"js_builder\";b:0;s:5:\"gform\";b:0;s:3:\"cdn\";b:1;s:11:\"auto_resize\";b:0;s:4:\"webp\";b:1;s:5:\"usage\";b:0;s:17:\"accessible_colors\";b:0;s:9:\"keep_data\";b:1;s:9:\"lazy_load\";b:1;s:17:\"background_images\";b:1;s:16:\"rest_api_support\";b:0;s:8:\"webp_mod\";b:1;}s:9:\"lazy_load\";a:7:{s:6:\"format\";a:6:{s:4:\"jpeg\";b:1;s:3:\"png\";b:1;s:4:\"webp\";b:1;s:3:\"gif\";b:1;s:3:\"svg\";b:1;s:6:\"iframe\";b:1;}s:6:\"output\";a:4:{s:7:\"content\";b:1;s:7:\"widgets\";b:1;s:10:\"thumbnails\";b:1;s:9:\"gravatars\";b:1;}s:9:\"animation\";a:2:{s:8:\"selected\";s:6:\"fadein\";s:6:\"fadein\";a:2:{s:8:\"duration\";s:3:\"400\";s:5:\"delay\";s:1:\"0\";}}s:7:\"include\";a:14:{s:9:\"frontpage\";b:1;s:4:\"home\";b:1;s:4:\"page\";b:1;s:6:\"single\";b:1;s:7:\"archive\";b:1;s:8:\"category\";b:1;s:3:\"tag\";b:1;s:14:\"e-landing-page\";b:1;s:17:\"elementor_library\";b:1;s:6:\"header\";b:1;s:6:\"footer\";b:1;s:4:\"blog\";b:1;s:4:\"news\";b:1;s:7:\"product\";b:1;}s:6:\"footer\";b:1;s:6:\"native\";b:0;s:8:\"noscript\";b:0;}}s:7:\"strings\";a:6:{s:10:\"bulk_smush\";a:1:{i:0;s:343:\"فشرده سازی خودکار - فعال کردن سوپر اسماش - فعال کردن متا دیتا - فعال کردن تغییر اندازه تصویر - غیر فعال Original Images - فعال کردن Backup Original Images - فعال کردن تبدیل PNG به JPEG - غیر فعال Disable Scaled Images - غیر فعال\";}s:9:\"lazy_load\";a:1:{i:0;s:614:\"بارگذاری تنبل - فعال کردن انواع رسانه - jpeg, png, webp, gif, svg, iframe موقعیت های خروجی - content, widgets, thumbnails, gravatars شامل انواع پست - frontpage, home, page, single, archive, category, tag, e-landing-page, elementor_library, header, footer, blog, news, product بارگذاری اسکریپت در فوتر - بلی لیزی لود Native فعال شده - خیر Noscript را غیرفعال کنید - خیر نمایش و انیمیشن - انتخاب شده:fadein. محو شدن با مدت زمان: 400. محو شدن با تاخیر: 0\";}s:3:\"cdn\";a:1:{i:0;s:181:\"CDN - فعال کردن تصاویر پس زمینه - فعال کردن تغییر اندازه خودکار - غیر فعال تبدیل WebP - فعال کردن - غیر فعال\";}s:8:\"webp_mod\";a:1:{i:0;s:17:\"فعال کردن\";}s:12:\"integrations\";a:1:{i:0;s:195:\"پشتیبانی گوتنبرگ - غیر فعال Gravity Forms - غیر فعال صفحه ساز WPBakery - غیر فعال آمازون S3 - غیر فعال گالری NextGen - غیر فعال\";}s:8:\"settings\";a:1:{i:0;s:246:\"تشخیص تغییر اندازه تصویر - فعال کردن قابلیت دسترسی رنگ - غیر فعال ردیابی میزان مصرف - غیر فعال اطلاعات را در حالت حذف نگه دارید - فعال کردن\";}}}}}", "no");
INSERT INTO `wp_options` VALUES("31558", "wp-smush-lazy_load", "a:9:{s:6:\"format\";a:6:{s:4:\"jpeg\";b:1;s:3:\"png\";b:1;s:4:\"webp\";b:1;s:3:\"gif\";b:1;s:3:\"svg\";b:1;s:6:\"iframe\";b:1;}s:6:\"output\";a:4:{s:7:\"content\";b:1;s:7:\"widgets\";b:1;s:10:\"thumbnails\";b:1;s:9:\"gravatars\";b:1;}s:7:\"include\";a:14:{s:9:\"frontpage\";b:0;s:4:\"home\";b:1;s:4:\"page\";b:1;s:6:\"single\";b:1;s:7:\"archive\";b:1;s:8:\"category\";b:1;s:3:\"tag\";b:1;s:14:\"e-landing-page\";b:1;s:17:\"elementor_library\";b:1;s:6:\"header\";b:1;s:6:\"footer\";b:1;s:4:\"blog\";b:1;s:4:\"news\";b:1;s:7:\"product\";b:1;}s:13:\"exclude-pages\";a:0:{}s:15:\"exclude-classes\";a:3:{i:0;s:15:\".slide-carousel\";i:1;s:9:\".owl-item\";i:2;s:3:\"img\";}s:6:\"footer\";b:1;s:6:\"native\";N;s:8:\"noscript\";N;s:9:\"animation\";a:4:{s:8:\"selected\";s:4:\"none\";s:6:\"fadein\";a:2:{s:8:\"duration\";i:400;s:5:\"delay\";i:0;}s:7:\"spinner\";a:2:{s:8:\"selected\";s:1:\"1\";s:6:\"custom\";a:0:{}}s:11:\"placeholder\";a:3:{s:8:\"selected\";s:1:\"1\";s:6:\"custom\";a:0:{}s:5:\"color\";s:7:\"#F3F3F3\";}}}", "yes");
INSERT INTO `wp_options` VALUES("31559", "skip-smush-setup", "1", "yes");
INSERT INTO `wp_options` VALUES("31560", "dir_smush_stats", "a:2:{s:9:\"dir_smush\";a:2:{s:5:\"total\";i:0;s:9:\"optimised\";i:0;}s:14:\"combined_stats\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("32530", "wp-smush-resize_sizes", "a:2:{s:5:\"width\";i:2560;s:6:\"height\";i:2560;}", "yes");
INSERT INTO `wp_options` VALUES("32551", "wp-smush-webp_hide_wizard", "", "no");
INSERT INTO `wp_options` VALUES("32642", "wp-smush-last_run_sync", "a:2:{s:4:\"time\";i:1658977326;s:5:\"fails\";i:1;}", "no");
INSERT INTO `wp_options` VALUES("33019", "rocket_cache_dir_size_check", "1", "yes");
INSERT INTO `wp_options` VALUES("33043", "zhk_rocket_settings", "bfe84da13938da825b21a3ad2735fde1", "yes");
INSERT INTO `wp_options` VALUES("33044", "bfe84da13938da825b21a3ad2735fde1", "{\"starter\":\"NTQyMTM2NGQtMjRlYy00ZTgwLWFhMzYtMzdjZjFkNDE1NzU5\",\"action\":1,\"message\":\"License code is valid.\",\"timer\":1659065398}", "yes");
INSERT INTO `wp_options` VALUES("34250", "perfmatters_options", "a:35:{s:14:\"disable_emojis\";s:1:\"1\";s:17:\"disable_dashicons\";s:1:\"1\";s:14:\"disable_embeds\";s:1:\"1\";s:14:\"disable_xmlrpc\";s:1:\"1\";s:21:\"remove_jquery_migrate\";s:1:\"1\";s:15:\"hide_wp_version\";s:1:\"1\";s:23:\"remove_wlwmanifest_link\";s:1:\"1\";s:15:\"remove_rsd_link\";s:1:\"1\";s:16:\"remove_shortlink\";s:1:\"1\";s:17:\"disable_rss_feeds\";s:1:\"1\";s:17:\"remove_feed_links\";s:1:\"1\";s:22:\"disable_self_pingbacks\";s:1:\"1\";s:16:\"disable_rest_api\";s:0:\"\";s:21:\"remove_rest_api_links\";s:1:\"1\";s:19:\"disable_google_maps\";s:1:\"1\";s:30:\"disable_google_maps_exclusions\";s:0:\"\";s:31:\"disable_password_strength_meter\";s:1:\"1\";s:19:\"remove_comment_urls\";s:1:\"1\";s:13:\"blank_favicon\";s:1:\"1\";s:20:\"remove_global_styles\";s:1:\"1\";s:17:\"disable_heartbeat\";s:0:\"\";s:19:\"heartbeat_frequency\";s:0:\"\";s:20:\"limit_post_revisions\";s:0:\"\";s:17:\"autosave_interval\";s:0:\"\";s:9:\"login_url\";s:0:\"\";s:18:\"login_url_behavior\";s:0:\"\";s:17:\"login_url_message\";s:0:\"\";s:26:\"disable_woocommerce_status\";s:1:\"1\";s:27:\"disable_woocommerce_widgets\";s:1:\"1\";s:6:\"assets\";a:13:{s:14:\"script_manager\";s:1:\"1\";s:8:\"defer_js\";s:1:\"1\";s:13:\"js_exclusions\";a:1:{i:0;s:16:\"jquery.timezz.js\";}s:17:\"delay_js_behavior\";s:0:\"\";s:19:\"delay_js_inclusions\";s:0:\"\";s:19:\"delay_js_exclusions\";s:0:\"\";s:12:\"rucss_method\";s:0:\"\";s:25:\"rucss_stylesheet_behavior\";s:0:\"\";s:26:\"rucss_excluded_stylesheets\";s:0:\"\";s:24:\"rucss_excluded_selectors\";s:0:\"\";s:11:\"header_code\";s:0:\"\";s:9:\"body_code\";s:0:\"\";s:11:\"footer_code\";s:0:\"\";}s:7:\"preload\";a:4:{s:7:\"preload\";a:0:{}s:15:\"critical_images\";s:0:\"\";s:10:\"preconnect\";a:0:{}s:12:\"dns_prefetch\";s:0:\"\";}s:8:\"lazyload\";a:7:{s:12:\"lazy_loading\";s:1:\"1\";s:22:\"exclude_leading_images\";s:0:\"\";s:23:\"lazy_loading_exclusions\";s:0:\"\";s:9:\"threshold\";s:0:\"\";s:27:\"lazy_loading_dom_monitoring\";s:1:\"1\";s:16:\"image_dimensions\";s:1:\"1\";s:24:\"css_background_selectors\";s:0:\"\";}s:5:\"fonts\";a:2:{s:20:\"disable_google_fonts\";s:1:\"1\";s:7:\"cdn_url\";s:0:\"\";}s:3:\"cdn\";a:3:{s:7:\"cdn_url\";s:0:\"\";s:15:\"cdn_directories\";s:0:\"\";s:14:\"cdn_exclusions\";s:0:\"\";}s:9:\"analytics\";a:6:{s:11:\"tracking_id\";s:0:\"\";s:22:\"tracking_code_position\";s:0:\"\";s:11:\"script_type\";s:0:\"\";s:20:\"adjusted_bounce_rate\";s:0:\"\";s:7:\"cdn_url\";s:0:\"\";s:14:\"measurement_id\";s:0:\"\";}}", "yes");
INSERT INTO `wp_options` VALUES("34251", "perfmatters_tools", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("34252", "perfmatters_version", "1.9.4", "no");
INSERT INTO `wp_options` VALUES("34333", "edd_sl_73499b5e164c73711a5f2eb6801dfa83", "a:2:{s:7:\"timeout\";i:1659454240;s:5:\"value\";s:112532:\"{\"new_version\":\"1.9.5\",\"stable_version\":\"1.9.5\",\"name\":\"perfmatters\",\"slug\":\"perfmatters\",\"url\":\"https:\\/\\/perfmatters.io\\/downloads\\/perfmatters\\/?changelog=1\",\"last_updated\":\"2022-07-19 01:04:53\",\"homepage\":\"https:\\/\\/perfmatters.io\",\"package\":\"\",\"download_link\":\"\",\"sections\":{\"description\":\"<p><a href=\\\"https:\\/\\/perfmatters.io\\/\\\">Perfmatters<\\/a> is a lightweight web performance plugin designed to help increase Google Core Web Vitals scores and fine-tune how assets load on your site.<\\/p>\\n<h4> Features <\\/h4>\\n<ul>\\n<li>Easy quick toggle options to turn off resources that shouldn\'t be loading. <\\/li>\\n<li>Disable scripts and plugins on a per post\\/page or sitewide basis with the Script Manager. <\\/li>\\n<li>Defer and delay JavaScript, including third-party scripts.<\\/li>\\n<li>Automatically remove unused CSS.<\\/li>\\n<li>Preload resources, critical images, and prefetch links for quicker load times.<\\/li>\\n<li>Lazy load images and enable click-to-play thumbnails on videos.<\\/li>\\n<li>Host Google Analytics and Google Fonts locally.<\\/li>\\n<li>Change your WordPress login URL. <\\/li>\\n<li>Disable and limit WordPress revisions.<\\/li>\\n<li>Add code to your header, body, and footer.<\\/li>\\n<li>Optimize your database.<\\/li>\\n<\\/ul>\\n<h4> Documentation <\\/h4>\\n<p>Check out our <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/\\\">documentation<\\/a> for more information on how to use Perfmatters.<\\/p>\",\"changelog\":\"<p>1.9.5<\\/p>\\n<ul>\\n<li>Added additional logic to Delay JS script to make sure the initial interaction is processed.<\\/li>\\n<li>Added additional styles to CSS Background Image feature to work with background images set on ::before selectors.<\\/li>\\n<li>Added additional default tags to various dropdowns in plugin settings for better clarification.<\\/li>\\n<li>Added default arrays for stylesheet and selector exclusions that are always needed.<\\/li>\\n<li>Adjusted perfmatters_cdn filter location for compatibility.<\\/li>\\n<li>Made some adjustments to CDN Rewrite Regex to fix some issues where unwanted strings were getting picked up as URLs in some cases.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.9.4<\\/p>\\n<ul>\\n<li>Updated EDD plugin updater class to version 1.9.2.<\\/li>\\n<li>Added default exclusion to REST API option for compatibility.<\\/li>\\n<\\/ul>\\n<p>1.9.3<\\/p>\\n<ul>\\n<li>Remove Used CSS filter adjustment to fix an issue where certain WordPress post functions wouldn\'t be available when trying to selectively disable the feature.<\\/li>\\n<li>Rolled back minor plugin UI JavaScript addition, as it was interfering with entering data on multiple lines in certain input fields.<\\/li>\\n<\\/ul>\\n<p>1.9.2<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_allow_buffer https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_used_css\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_used_css<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_allow_buffer\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_allow_buffer<\\/a> filter.<\\/li>\\n<li>Added a notice in the Script Manager when Testing Mode is enabled.<\\/li>\\n<li>Improved reliability of CSS Background Image function when child elements with additional background images are present.<\\/li>\\n<li>Script Manager style compatibility fixes.<\\/li>\\n<li>Fixed an issue where some post specific meta options were not being respected when determining if a feature should run.<\\/li>\\n<li>Fixed an issue where pressing enter on the main plugin settings page would trigger a specific form action instead of save settings.<\\/li>\\n<li>Changed CSS class initialization hook to be in the correct order with other output buffer functions.<\\/li>\\n<li>Made an adjustment to how we generate the local used stylesheet URL for better compatibility.<\\/li>\\n<li>Fixed an issue where loading attribute was still getting applied to images that were excluded from lazy loading.<\\/li>\\n<li>Fixed an issue where images inside an excluded picture element were not also getting excluded.<\\/li>\\n<li>Fixed an issue in the Script Manager where archives were not being grouped together with their respective post type.<\\/li>\\n<li>Additions to plugin UI JavaScript to allow for disabled sections to be hidden even when nested controllers are present.<\\/li>\\n<li>Moved background process library to composer autoloader.<\\/li>\\n<li>Removed BETA tag from Remove Unused CSS option.<\\/li>\\n<\\/ul>\\n<p>1.9.1<\\/p>\\n<ul>\\n<li>Added new option to lazy load <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#css-background-images\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">CSS Background Images<\\/a>.<\\/li>\\n<li>Added new option for <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/#dual-tracking\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Dual Tracking<\\/a> when using gtag.js in local analytics.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_rest_api_exceptions\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_rest_api_exceptions<\\/a> filter.<\\/li>\\n<li>Fixed an issue where individually delayed local scripts would not get correctly rewritten to load from the CDN.<\\/li>\\n<li>Fixed an issue where lazy loading would run into an error if no px or % was specified with the threshold value.<\\/li>\\n<li>Fixed an issue with buffer validation that was conflicting with certain caching setups.<\\/li>\\n<li>Fixed an issue where existing font preconnect and prefetch tags were not being detected properly when using Local Fonts.<\\/li>\\n<li>Fixed an error related to cookie constants when running MU Mode in certain environments.<\\/li>\\n<li>Fixed multiple AMP validation errors and added additional checks to prevent certain functions from running on AMP URLs.<\\/li>\\n<li>Minor adjustment to CDN rewrite regex pattern to work with encoded quotation characters.<\\/li>\\n<li>Changed toggle CSS selectors to be more specific to prevent conflicts.<\\/li>\\n<li>Moved plugin settings header output to in_admin_header action hook for compatibility.<\\/li>\\n<li>Moved JS optimization functions to new class structure to be more inline with current codebase.<\\/li>\\n<li>Improvements to critical image preloading allowed for a move to a singular output buffer.<\\/li>\\n<\\/ul>\\n<p>1.9.0<\\/p>\\n<ul>\\n<li>Fixed an issue that was causing excluded selectors to not be recognized properly after Used CSS was cleared.<\\/li>\\n<li>Minor adjustments to the new plugin UI.<\\/li>\\n<\\/ul>\\n<p>1.8.9<\\/p>\\n<ul>\\n<li>Updated plugin settings UI.<\\/li>\\n<li>Added new post meta option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/remove-unused-css\\/#clear-individual\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Clear Used CSS<\\/a> for an individual page or post type.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_rucss_excluded_selectors\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_rucss_excluded_selectors<\\/a> filter.<\\/li>\\n<li>Fixed a lazy loading issue that was preventing some images from loading properly in Safari.<\\/li>\\n<li>Migrated Delay JS Timeout dropdown to a simpler on\\/off toggle that will default to 10 seconds. Our filter is also still available to set a custom timeout value.<\\/li>\\n<li>Fixed an issue with MU plugin that was interfering with rewrite rules in some instances.<\\/li>\\n<li>Added additional excluded page builder parameter for Flatsome UX.<\\/li>\\n<li>Moved restore default functionality to a separate option on the tools page.<\\/li>\\n<li>Code refactoring.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.8.8<\\/p>\\n<ul>\\n<li>Changed default setting for Used CSS Method from file to inline, as we think this will be the more compatible solution for most users going forward. If you were previously using the file method, you may need to save that option again.<\\/li>\\n<li>Added width and height parameters to placeholder SVGs to prevent warnings for a ratio mismatch that would happen for some images.<\\/li>\\n<li>Fixed an issue where the noscript tags were getting malformed for some images inside picture tags after lazy loading.<\\/li>\\n<li>Removed placeholder SVGs on source tags since the image tag will already have one.<\\/li>\\n<li>Changed settings export file name date format to be easier to organize when managing multiples.<\\/li>\\n<li>Updated tooltip for Blank Favicon option to be more clear.<\\/li>\\n<\\/ul>\\n<p>1.8.7<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/remove-unused-css\\/#css-method\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Used CSS Method<\\/a> option to choose whether to load used CSS from a file or inline.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_cache_path\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_cache_path<\\/a> filter.<\\/li>\\n<li>Updated metabox functions to restrict metabox display to administrators only.<\\/li>\\n<li>Made some adjustments to custom login URL function to better support 3rd party tools using WP CLI.<\\/li>\\n<li>Added Fusion Builder query string parameters to excluded page builders array.<\\/li>\\n<li>Adjusted Unused CSS regex to be more consistent when stylesheets are placed in between other link tags.<\\/li>\\n<li>Changes to instances where ABSPATH was used to determine a directory location for better compatibility with certain hosts.<\\/li>\\n<li>Fixed an issue with Remove Global Styles option where duotone SVGs were not being removed on WordPress 5.9.2.<\\/li>\\n<li>Fixed an issue where WooCommerce block stylesheets were not getting correctly dequeued when Disable Scripts option was set.<\\/li>\\n<li>Fixed an issue that was causing the CSS Parser library not to get included correctly in certain cases.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.8.6<\\/p>\\n<ul>\\n<li>Added new option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/remove-global-inline-styles-wordpress\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Remove Global Styles<\\/a> related to duotone filters.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_script_manager_locale\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_script_manager_locale<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_disable_woocommerce_scripts\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_disable_woocommerce_scripts<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_page_builders\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_page_builders<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_delay_js_behavior\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_delay_js_behavior<\\/a> filter.<\\/li>\\n<li>Fixed an issue with the unused CSS parser that was incorrectly rewriting relative URLs if there was no query string present on the original stylesheet src.<\\/li>\\n<li>Added additional parameter to page builders array for compatibility.<\\/li>\\n<li>Fixed an issue that was causing the login URL disabled 404 behavior to result in an error if a 404 template was not found.<\\/li>\\n<li>Added some additional checks before creating cache directories for local fonts and used CSS.<\\/li>\\n<li>Fixed an issue that was causing the fade-in effect to conflict with child images inside a lazy loaded container.<\\/li>\\n<li>Fixed an undefined index warning coming from unused CSS settings update function.<\\/li>\\n<li>Added a default delay JS exclusion for admin only inline customize-support script.<\\/li>\\n<li>Refactored entire meta.php code to be more efficient (38% smaller) and in line with current structure.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.8.5<\\/p>\\n<ul>\\n<li>Added new feature to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/remove-unused-css\\/#remove-unused-css\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Remove Unused CSS<\\/a> (BETA).<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_remove_unused_css\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_remove_unused_css<\\/a> filter.<\\/li>\\n<li>Adjusted CDN Rewrite buffer priority for better compatibility with other features.<\\/li>\\n<li>Made an improvement to the Disable XML-RPC function to return a 403 error when xmlrpc.php is accessed directly.<\\/li>\\n<li>Script Manager stylesheet updates for better compatibility.<\\/li>\\n<li>Fixed an issue in the Script Manager where the input controls were sometimes not displaying after toggling a script off.<\\/li>\\n<li>Added additional style for YouTube preview thumbnail play button to fix an alignment issue with certain setups.<\\/li>\\n<li>Buffer adjustments for compatibility.<\\/li>\\n<\\/ul>\\n<p>1.8.4<\\/p>\\n<ul>\\n<li>Fixed an issue that was interfering with sitemap display in certain configurations.<\\/li>\\n<li>Added &lt;a&gt; element support for lazy loading inline background images.<\\/li>\\n<\\/ul>\\n<p>1.8.3<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_fade_in_speed\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_fade_in_speed<\\/a> filter.<\\/li>\\n<li>Fixed an issue that was preventing lazy loading fade in from working correctly with certain background images.<\\/li>\\n<li>Fixed an issue that was interfering with the display of certain inline SVG elements.<\\/li>\\n<li>Adjusted local analytics hook priority for better compatibility.<\\/li>\\n<li>Script Manager style updates for better compatibility.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.8.2<\\/p>\\n<ul>\\n<li>New Lazy Loading option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#exclude-leading-images\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Exclude Leading Images<\\/a>.<\\/li>\\n<li>New Lazy Loading option to add a <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#fade-in\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Fade In<\\/a> effect.<\\/li>\\n<li>New option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/preload\\/#critical-images\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Preload Critical Images<\\/a> (BETA).<\\/li>\\n<li>Expanded Disable XML-RPC function to also remove pingback link tag if it is present in the document.<\\/li>\\n<li>Added new Delay JavaScript checkbox to meta options in the post editor.<\\/li>\\n<li>Added additional integration with perfmatters_delay_js filter.<\\/li>\\n<li>Moved YouTube autoplay parameter placement on lazy loaded iframes for better compatibility with existing query strings.<\\/li>\\n<li>Optimizations to lazy loading inline CSS functions.<\\/li>\\n<li>Various optimizations and improvements to the output buffer.<\\/li>\\n<li>Migrated manual preload functionality to use the output buffer which will allow for easier integration with new features.<\\/li>\\n<li>Made some adjustments to MU plugin functions to more reliably detect post IDs when using specific permalink setups.<\\/li>\\n<li>Fixed an issue where some Current URL links in the Script Manager\'s Global View were not pointing to the right posts.<\\/li>\\n<li>Fixed an issue with a certain endpoint that was redirecting to the custom login URL.<\\/li>\\n<li>Fixed a PHP notice that was sometimes appearing when refreshing local fonts.<\\/li>\\n<li>Removed BETA tag from Delay All JS option.<\\/li>\\n<\\/ul>\\n<p>1.8.1<\\/p>\\n<ul>\\n<li>Updated Local Google Font function to more effectively remove existing font preconnect and prefetch tags.<\\/li>\\n<li>Updated Local Google Font function for better compatibility with sites that still have remnants from a previous http to https migration.<\\/li>\\n<li>Fixed an issue in the Script Manager where the home page was being treated as a post if set to display the blog feed.<\\/li>\\n<\\/ul>\\n<p>1.8.0<\\/p>\\n<ul>\\n<li>Fixed an issue with Delay All JS that was preventing certain async scripts from fully loading.<\\/li>\\n<\\/ul>\\n<p>1.7.9<\\/p>\\n<ul>\\n<li>Added new options to the Script Manager to disable assets directly by post type, archive, user status, and device type.<\\/li>\\n<li>Added support for dynamic preloading by handle for enqueued scripts and styles.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_lazyload\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_lazyload<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_cdn\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_cdn<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_delay_js_timeout\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_delay_js_timeout<\\/a> filter.<\\/li>\\n<li>Fix to Delay All JS script for better compatibility with certain page builder animations.<\\/li>\\n<li>Updated class initialization for better compatibility.<\\/li>\\n<li>Fixed an issue where the Script Manager was interpreting certain array keys as shortcodes if they were identical.<\\/li>\\n<li>Added an additional check to prevent the Script Manager from being able to load on top of a page builder.<\\/li>\\n<li>Fixed a PHP notice coming from the MU plugin.<\\/li>\\n<li>Made some changes to our plugin updater function that should help with auto-updates in a multisite environment.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.7.8<\\/p>\\n<ul>\\n<li>Added new option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/missing-width-height-images\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Add Missing Image Dimensions<\\/a>.<\\/li>\\n<li>Added the ability to delete individual Script Manager options from the Global View.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_delay_js\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_delay_js<\\/a> filter.<\\/li>\\n<li>Updated EDD plugin updater class to version 1.9.0.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.7.7<\\/p>\\n<ul>\\n<li>Fixed a PHP warning related to JavaScript deferral for specific configurations.<\\/li>\\n<li>Fixed an issue with lazy loading exclusions not being loaded correctly in some cases.<\\/li>\\n<\\/ul>\\n<p>1.7.6<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/delay-javascript\\/#behavior\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Delay Behavior<\\/a> dropdown with a new option to Delay All Scripts.<\\/li>\\n<li>Added new Lazy Loading <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#threshold\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Threshold<\\/a> option and adjusted the default value if not set to improve performance.<\\/li>\\n<li>Added confirmation message when manually running the database optimization tool.<\\/li>\\n<li>Updated disable emoji function to get rid of a PHP notice.<\\/li>\\n<li>Added additional check to MU Mode to only filter GET requests.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/defer-javascript-wordpress\\/#perfmatters_defer_js-filter\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_defer_js<\\/a> filter.<\\/li>\\n<li>Fixed an issue where Instant Page was attempting to run on the new widgets screen in WordPress 5.8.<\\/li>\\n<li>Fixed an issue with Local Google Fonts where certain invalid font URLs would still attempt to be downloaded and served.<\\/li>\\n<li>Removed BETA tag from fonts section.<\\/li>\\n<li>Delay JavaScript compatibility improvements.<\\/li>\\n<li>Added additional input validation functionality to plugin settings page.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.7.5<\\/p>\\n<ul>\\n<li>Added new custom login URL options to change the <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/change-wordpress-login-url\\/#disabled-behavior\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Disabled Behavior<\\/a> and set a custom <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/change-wordpress-login-url\\/#message\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Message<\\/a>.<\\/li>\\n<li>Migrated CDN, Analytics, and Extras tab data to separate sections in the Options tab for better organization and easier access.<\\/li>\\n<li>CDN rewrite improvements to better handle sites with multiple domain URLs.<\\/li>\\n<li>Regex adjustments to Local Fonts function for better reliability.<\\/li>\\n<li>Added exclusion checks to individual &lt;source&gt; tags when using WebP images.<\\/li>\\n<li>Added function to disable capital_P_dangit filter.<\\/li>\\n<li>Fixed a lazy loading warning that was showing in Microsoft Edge.<\\/li>\\n<li>Removed loading attribute that was getting applied to &lt;picture&gt; tags in some cases when using WebP images.<\\/li>\\n<li>Plugin UI navigation performance improvements.<\\/li>\\n<li>Plugin UI style fixes.<\\/li>\\n<li>Added a conditional check to only show WooCommerce options when WooCommerce is installed and activated.<\\/li>\\n<li>Fixed an MU Mode issue where the Home URL did not trigger a match if a query string was present.<\\/li>\\n<li>Fixed an issue where the Customizer was getting certain optimizations applied.<\\/li>\\n<li>Fixed an issue where the Disable Embeds toggle was interfering with responsive video styles.<\\/li>\\n<li>Script Manager UI fixes.<\\/li>\\n<li>Updated uninstall function to remove Perfmatters cache folder.<\\/li>\\n<li>Added readme.txt file.<\\/li>\\n<\\/ul>\\n<p>1.7.4<\\/p>\\n<ul>\\n<li>Re-enabled Local Google Fonts functionality.<\\/li>\\n<li>Refactoring of buffer-related code and various functions that were already using our main buffer filter.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.7.3<\\/p>\\n<ul>\\n<li>Rolled back the latest changes related to the new universal buffer class and Local Google Fonts while we do some more in-depth testing. We\'ll be working to release this feature next week using an alternative method.<\\/li>\\n<\\/ul>\\n<p>1.7.2<\\/p>\\n<ul>\\n<li>Added new Fonts section inside of the main Options tab.<\\/li>\\n<li>Added new option to use <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/font-display-swap\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Display Swap<\\/a> for Google fonts.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/host-google-fonts-locally\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Local Google Fonts<\\/a> option which will attempt to download any Google Font files and serve them from your local server or CDN.<\\/li>\\n<li>Integrated new universal HTML buffer library to help going forward with plugin features that manipulate DOM elements.<\\/li>\\n<li>Migrated CDN Rewrite feature to the universal buffer class.<\\/li>\\n<li>Added new perfmatters_delayed_scripts filter to modify the Delay JavaScript input array before any scripts are delayed.<\\/li>\\n<li>Added new perfmatters_preload filter to modify the Preloads data array before anything is printed.<\\/li>\\n<li>Made some compatibility improvements to the inline lazy loading JavaScript.<\\/li>\\n<li>Added attributes to delayed scripts to exclude them from being picked up by Litespeed Cache.<\\/li>\\n<li>Added exclusion for SiteGround Optimizer to the main Script Manager JavaScript file.<\\/li>\\n<li>Added CodeMirror support to all code text area inputs in plugin settings.<\\/li>\\n<li>Removed license activation check and corresponding links from the plugins page to improve back-end performance.<\\/li>\\n<\\/ul>\\n<p>1.7.1<\\/p>\\n<ul>\\n<li>Added expiration date row to license tab in plugin settings.<\\/li>\\n<li>Added support for WooCommerce shop page when setting a preload location by post ID.<\\/li>\\n<li>Fixed an issue with device exceptions not working correctly in MU Mode.<\\/li>\\n<li>Fixed a query string encoding issue that was affecting some email templates when using a custom login URL.<\\/li>\\n<\\/ul>\\n<p>1.7.0<\\/p>\\n<ul>\\n<li>Fixed an issue where Preload tags were still being printed on archive pages even if a location was set.<\\/li>\\n<li>Fixed a compatibility issue with older WordPress versions when using certain functions that check for a JSON request.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.6.9<\\/p>\\n<ul>\\n<li>New additions to preload feature, allowing specification for device type and location.<\\/li>\\n<li>Script Manager improvements to allow for Regex disable to be used alongside Current URL disables for the same script.<\\/li>\\n<li>Added new Script Manager exception for device type.<\\/li>\\n<li>Add new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/delay-javascript\\/#timeout\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Delay Timeout<\\/a> option when delaying JavaScript.<\\/li>\\n<li>Added new wheel event to user interaction script for delay function.<\\/li>\\n<li>Added new multisite network administration tool to apply default site settings to all subsites.<\\/li>\\n<li>Multiple improvements to WooCommerce disable scripts toggle for increased effectiveness.<\\/li>\\n<li>Added additional exclusions for JSON and REST requests to all asset optimization functions.<\\/li>\\n<li>Fixed an undefined index warning coming from local analytics function.<\\/li>\\n<li>Fixed an issue where YouTube preview thumbnails were getting a layout shift warning when using a theme with responsive embed support.<\\/li>\\n<li>Fixed a Script Manager bug that was not fully clearing exceptions when changing disable away from everywhere.<\\/li>\\n<li>Script Manager styling compatibility fixes.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.6.8<\\/p>\\n<ul>\\n<li>Compatibility fixes for local analytics when using MonsterInsights.<\\/li>\\n<li>Local analytics improvements for multisite.<\\/li>\\n<li>Added alt tag to YouTube preview thumbnail images.<\\/li>\\n<li>Fixed a PHP undefined index notice coming from functions.php.<\\/li>\\n<li>Translation file updates.<\\/li>\\n<\\/ul>\\n<p>1.6.7<\\/p>\\n<ul>\\n<li>Added new tool to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/purge-meta-options\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Purge Perfmatters Meta Options<\\/a>.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/disable-google-maps-api-wordpress\\/#exclude\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Exclude Post IDs<\\/a> input for existing Disable Google Maps option.<\\/li>\\n<li>Added new gtag.js option to local analytics script type selection.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/#gtag-cdn\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">CDN URL<\\/a> input to local analytics options when using gtag.js.<\\/li>\\n<li>Added new option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/#amp\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Enable AMP Support<\\/a> to local analytics.<\\/li>\\n<li>Moved Use MonsterInsights option to gtag.js script type and updated script replacement hook.<\\/li>\\n<li>Added onload function to style preloads to prevent duplicate preloads from occurring.<\\/li>\\n<li>Added exception for WP Rocket script deferral to our lazy load script.<\\/li>\\n<li>Added exception for site health tool to disable heartbeat function.<\\/li>\\n<li>Fixed an issue where background images weren\\u2019t being lazy loaded if the style attribute was the first attribute declared on the element.<\\/li>\\n<li>Script Manager styling fixes.<\\/li>\\n<li>Fixed a PHP warning coming from settings.php.<\\/li>\\n<li>Translation file updates.<\\/li>\\n<\\/ul>\\n<p>1.6.6<\\/p>\\n<ul>\\n<li>Added new Script Manager exception to select <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/script-manager-logged-in-logged-out\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">logged in or logged out<\\/a> users.<\\/li>\\n<li>Added new option in Script Manager settings to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/script-dependencies\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Display Dependencies<\\/a>.<\\/li>\\n<li>Added total plugin sizes in the Script Manager.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#viewport-threshold\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_lazyload_threshold<\\/a> filter to adjust the distance at which lazy elements are loaded.<\\/li>\\n<li>Multiple Script Manager style and UI improvements.<\\/li>\\n<li>Fixed an issue where MU mode script was attempting to run on wp-login.php.<\\/li>\\n<li>Multiple page builder compatibility fixes.<\\/li>\\n<li>Made an adjustment to prevent YouTube preview thumbnails from getting picked up by Pinterest image hover tools.<\\/li>\\n<li>Removed deprecated plugin option to Remove Query Strings. Make sure to double-check your preloads as Google needs the exact URL when preloading.<\\/li>\\n<li>PHP 8 compatibility testing.<\\/li>\\n<li>Minor adjustments to lazy load inline scripts to fix invalid markup warnings.<\\/li>\\n<\\/ul>\\n<p>1.6.5<\\/p>\\n<ul>\\n<li>Added new option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/delay-javascript\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Delay JavaScript<\\/a> from loading until user interaction.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/#script-type\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">gtag.js v4<\\/a> option to local analytics.<\\/li>\\n<li>Added new built-in option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#exclude\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Exclude from Lazy Loading<\\/a> which can be used in addition to the existing filter.<\\/li>\\n<li>Add new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#youtube-preview-thumbnails\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_lazyload_youtube_thumbnail_resolution<\\/a> filter to adjust YouTube preview thumbnail quality.<\\/li>\\n<li>Optimized analytics updater function.<\\/li>\\n<li>Updated EDD plugin updater class which will now allow for WordPress auto-update support.<\\/li>\\n<li>Removed option to Defer Inline JavaScript which is now being replaced by the new Delay JavaScript option.<\\/li>\\n<li>Adjusted Script Manager hook priority for better compatibility.<\\/li>\\n<li>Compatability fix to the DOM Monitoring lazy load option.<\\/li>\\n<li>Added compatibility fix for jQuery fitVids to lazy loading function.<\\/li>\\n<li>Fixed an issue where lazy loading was attempting to run on AMP pages.<\\/li>\\n<\\/ul>\\n<p>1.6.4<\\/p>\\n<ul>\\n<li>Fixed an issue that was causing the Reset Script Manager button to not work correctly.<\\/li>\\n<li>Fixed an issue where the Perfmatters meta box wouldn\'t display if only using Lazy Loading.<\\/li>\\n<li>Adjusted Script Manager hook priority for better compatibility.<\\/li>\\n<li>Added additional checks to MU Mode plugin file to prevent it from interfering with certain REST API requests. (Fixes a bug when running the Yoast SEO data indexer.)<\\/li>\\n<li>Added additional checks to confirm user functions are available before verifying admin status.<\\/li>\\n<li>Updated translation files.<\\/li>\\n<\\/ul>\\n<p>1.6.3<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/testing-mode\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Testing Mode<\\/a> option to the Script Manager settings.<\\/li>\\n<li>Rewrote script-manager.js entirely using vanilla JavaScript to get rid of jQuery dependency.<\\/li>\\n<li>Added additional MU Mode check to help prevent certain configurations from interfering with AJAX requests.<\\/li>\\n<li>Improved Script Manager form handling.<\\/li>\\n<li>Adjusted Script Manager disclaimer text and added a close button.<\\/li>\\n<li>Moved the Script Manager print function from the wp_footer hook to shutdown for better compatibility.<\\/li>\\n<li>Fixed an undefined index warning in the Lazy Load function.<\\/li>\\n<li>Added a Lazy Load exclusion for Gravity Forms iframes.<\\/li>\\n<li>Added a Rocket Loader exclusion to the Instant Page JS file.<\\/li>\\n<li>Added an exclusion to the CDN Rewrite for script-manager.js.<\\/li>\\n<li>Script Manager styling fixes for better compatibility.<\\/li>\\n<\\/ul>\\n<p>1.6.2<\\/p>\\n<ul>\\n<li>Updated placeholder text in Preload UI.<\\/li>\\n<li>Fixed an issue where the Password Strength Meter script was getting disabled in the admin.<\\/li>\\n<li>Small tweak to JS Deferral buffer to make sure HTML is being filtered correctly.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.6.1<\\/p>\\n<ul>\\n<li>New Local Analytics Script Type toggle with new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Minimal Analytics<\\/a> options.<\\/li>\\n<li>New <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/defer-javascript-wordpress\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">JavaScript Deferral<\\/a> options in Extras &gt; Assets.<\\/li>\\n<li>Updates to Cart Fragments and Password Strength Meter toggles to improve effectiveness.<\\/li>\\n<li>Multiple updates to Instant Page functionality for better compatibility.<\\/li>\\n<li>Multiple plugin admin UI updates and improvements.<\\/li>\\n<li>Script Manager style updates for better compatibility.<\\/li>\\n<li>MU Mode improvements for increased stability.<\\/li>\\n<li>Fixed an issue causing Preload and Preconnect settings to not save correctly in some cases.<\\/li>\\n<\\/ul>\\n<p>1.6.0<\\/p>\\n<ul>\\n<li>Added a filter to disable WordPress\' native lazy loading when Perfmatters\' lazy loading is active.<\\/li>\\n<li>Adjusted Script Manager styles to more effectively overlay the entire page while still allowing admin bar functions to be fully available.<\\/li>\\n<li>Fixed an undefined index notice that was appearing on specific lazy loading and script manager functions.<\\/li>\\n<li>Updated translation files.<\\/li>\\n<\\/ul>\\n<p>1.5.9<\\/p>\\n<ul>\\n<li>Added new Preloading section in the Extras tab, with new options for <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/link-prefetch\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Instant Page<\\/a> and <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/preload\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Preload<\\/a>.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_lazyload_forced_attributes<\\/a> filter to allow for matched elements to be skipped when checking for exclusions.<\\/li>\\n<li>Added support for WooCommerce Shop page to show up as a Current URL option in the Script Manager.<\\/li>\\n<li>Added exclusions for REST and AJAX requests to MU Mode function.<\\/li>\\n<li>Fixed a bug that was causing the MU Mode function to still run even if the Script Manager was disabled.<\\/li>\\n<li>Fixed an issue where images were being prepped for lazy loading on feed URLs.<\\/li>\\n<li>Fixed an issue where lazy loading was breaking images in embeds from the same site.<\\/li>\\n<li>Compatibility fixes for lazy load script with Autoptimize and Litespeed Cache.<\\/li>\\n<\\/ul>\\n<p>1.5.8<\\/p>\\n<ul>\\n<li>Added support for lazy loading background images, iframes, and videos.<\\/li>\\n<li>Added new lazy loading option to enable Youtube Preview Thumbnails.<\\/li>\\n<li>Added multiple page builder exclusions to our lazy load functions.<\\/li>\\n<li>Added proper support for 404 templates in the Script Manager (non-MU).<\\/li>\\n<li>Fixed some minor styling issues in the Script Manager UI.<\\/li>\\n<li>Fixed an undefined index in the database optimizer class.<\\/li>\\n<li>Removed customer email row from the license tab.<\\/li>\\n<\\/ul>\\n<p>1.5.7<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/optimize-wordpress-database\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Database Optimization<\\/a> section in the Extras tab.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">DOM Monitoring<\\/a> option to complement our existing lazy load settings.<\\/li>\\n<li>Added additional input styles in the Script Manager for better compatibility<\\/li>\\n<li>Made some changes to the Script Manager file include process for better compatibility.<\\/li>\\n<li>Fixed multiple undefined index notices.<\\/li>\\n<li>Updated translation files.<\\/li>\\n<\\/ul>\\n<p>1.5.6<\\/p>\\n<ul>\\n<li>Plugin UI improvements, new tooltip styles.<\\/li>\\n<li>Licensing workflow improvements. Simpler UI, license no longer deactivated on plugin deactivation, license auto-activates on input.<\\/li>\\n<li>Moved Script Manager javascript back to a separate plugin file for better compatibility.<\\/li>\\n<li>Added Remove Query Strings exemption to the Script Manager javascript file.<\\/li>\\n<li>Code refactoring.<\\/li>\\n<\\/ul>\\n<p>1.5.5<\\/p>\\n<ul>\\n<li>Added a new modified function to the MU plugin file which should be able to get the current post ID more effectively for certain types of URLs (custom post types, blog page, etc...).<\\/li>\\n<li>Made some improvements to the MU plugin file detection and update process.<\\/li>\\n<\\/ul>\\n<p>1.5.4<\\/p>\\n<ul>\\n<li>Added additional tooltip warning text to the MU Mode toggle.<\\/li>\\n<li>Added <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/mu-mode\\/#debug-mode\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">mu_mode=off<\\/a> URL parameter to force the page to load with MU Mode settings disabled.<\\/li>\\n<li>Added an additi0nal check to make sure MU Mode settings don\'t run if the base Perfmatters plugin is not activated.<\\/li>\\n<\\/ul>\\n<p>1.5.3<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/mu-mode\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">MU Mode<\\/a> (BETA) feature in the Script Manager which can be used to disable plugins per page.<\\/li>\\n<li>Reworked main Script Manager update function to dynamically save settings via AJAX to prevent having to reload the page every time options are saved.<\\/li>\\n<li>Moved Script Manager javascript inline to better support further updates.<\\/li>\\n<li>Fixed an issue in the Script Manager where a Current URL disable would not function correctly for an individual script if the plugin\'s scripts were disabled globally on a different Current URL.<\\/li>\\n<li>Changed hooks for Disable Google Maps and Disable Google Fonts toggles to prevent a conflict with Gutenberg.<\\/li>\\n<li>Added an exclusion attribute to our LazyLoad script to prevent it from conflicting with WP Rocket\'s JS deferral feature.<\\/li>\\n<li>Updated EDD Plugin Updater Class to version 1.7.1.<\\/li>\\n<li>Updated various translation files.<\\/li>\\n<\\/ul>\\n<p>1.5.2<\\/p>\\n<ul>\\n<li>Added new options in Extras \\u2192 Tools to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/import-export\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Import and Export Plugin Settings<\\/a>.<\\/li>\\n<li>Updated Script Manager form input names to be more specific to prevent conflicts when saving Script Manager settings.<\\/li>\\n<li>Added compatibility fix for Beaver Builder to the Script Manager dequeue function.<\\/li>\\n<li>Updated French and German translation files.<\\/li>\\n<\\/ul>\\n<p>1.5.1<\\/p>\\n<ul>\\n<li>Adjusted the Script Manager styles for better compatibility with other admin bar tools when the Script Manager UI is being displayed.<\\/li>\\n<li>Fixed an issue in the Script Manager that was causing individual script settings to not work correctly when the parent group had previously been disabled.<\\/li>\\n<li>Updated Russian (ru_RU) translation files.<\\/li>\\n<li>Updated plugin description.<\\/li>\\n<\\/ul>\\n<p>1.5.0<\\/p>\\n<ul>\\n<li>Fixed a bug that was causing the Script Manager dequeue function to interfere with the query loop in certain cases.<\\/li>\\n<\\/ul>\\n<p>1.4.9<\\/p>\\n<ul>\\n<li>Performance update to Script Manager form submission function which should help dramatically reduce the footprint when saving script configurations.<\\/li>\\n<li>Removed the Current URL option in the Script Manager when loaded on URLs without a valid post ID. (ex. dynamically generated archive templates)<\\/li>\\n<li>Added plugin settings page header with links to Contact and Support.<\\/li>\\n<li>Minor styling fixes in plugin settings UI.<\\/li>\\n<li>Updated Russian (ru_RU) translation files.<\\/li>\\n<\\/ul>\\n<p>1.4.8<\\/p>\\n<ul>\\n<li>Added new \'Body Code\' box in the Extras tab to go along with our existing header + footer boxes to give some more control there.<\\/li>\\n<li>Added some limits to the Script Manager action links in WP Admin to ensure they are only showing up for public post types.<\\/li>\\n<li>Fixed a bug that was causing the admin stylesheet not to load on the network settings page when running on a multisite.<\\/li>\\n<li>Added Russian (ru_RU) translation files. (credit: Sergey Shljahov)<\\/li>\\n<\\/ul>\\n<p>1.4.7<\\/p>\\n<ul>\\n<li>Added an exception for Gravity Forms to the Disable Heartbeat function.<\\/li>\\n<li>Added an exception for Contact Form 7 to the Disable REST API function.<\\/li>\\n<li>Added updated German (de_DE) translation files. (credit: Daniel Luttermann)<\\/li>\\n<\\/ul>\\n<p>1.4.6<\\/p>\\n<ul>\\n<li>Added a specific and more generous threshold for lazy loading.<\\/li>\\n<li>Added some additional dequeues to the Disable WooCommerce function to target inline CSS and JS.<\\/li>\\n<\\/ul>\\n<p>1.4.5<\\/p>\\n<ul>\\n<li>Updated Disable Google Maps and Disable Google Fonts toggles to not run in WP Admin.<\\/li>\\n<li>Turned off native lazy loading by default and added new option to Use Native.<\\/li>\\n<li>Added perfmatters_lazyload_excluded_attributes filter which allows for an array of attribute strings to be given that if found will exclude the matched image\\/s from lazy loading.<\\/li>\\n<li>Made some compatibility improvements to the Script Manager function that gets the ID of the current post.<\\/li>\\n<li>Added perfmatters_get_current_ID filter which allows the user to extend or modify the functionality of the Script Manager\'s current ID function.<\\/li>\\n<\\/ul>\\n<p>1.4.4<\\/p>\\n<ul>\\n<li>Fixed undefined index PHP Notice coming from the Preconnect settings display function.<\\/li>\\n<li>Added additional compatibility with Elementor when using the Script Manager to disable certain Elementor scripts + styles.<\\/li>\\n<li>Added a ignore flag class to all Lazy Load functions. Simply add the \'no-lazy\' class to any image element you want to be exempt from lazy loading.<\\/li>\\n<li>Added validation filter to Login URL input to prevent incompatible characters from being entered.<\\/li>\\n<\\/ul>\\n<p>1.4.3<\\/p>\\n<ul>\\n<li>Fixed an issue with the Lazy Load function that was causing an error with some older PHP versions.<\\/li>\\n<\\/ul>\\n<p>1.4.2<\\/p>\\n<ul>\\n<li>Added new option for <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/\\\">Lazy Loading<\\/a> images (BETA).<\\/li>\\n<\\/ul>\\n<p>1.4.1<\\/p>\\n<ul>\\n<li>New addition to the Preconnect option, you can now choose to whether or not to add the crossorigin property for each Preconnect URL.<\\/li>\\n<li>Optimization to the loading of Perfmatters admin scripts + styles.<\\/li>\\n<li>Added additional Script Manager styles for better compatibility.<\\/li>\\n<li>Added an additional function for the Custom Login URL to help rewrite certain wp-admin links in specific multisite setups.<\\/li>\\n<li>Reorganized plugin action links in the plugins table.<\\/li>\\n<\\/ul>\\n<p>1.4.0<\\/p>\\n<ul>\\n<li>Fixed an issue where the Current URL Exceptions were not loading correctly after saving in the Script Manager.<\\/li>\\n<\\/ul>\\n<p>1.3.9<\\/p>\\n<ul>\\n<li>Added new Extra options to Add Header Code and Add Footer Code.<\\/li>\\n<li>Added missing blank defaults for DNS Prefetch and Preconnect options.<\\/li>\\n<li>Added functionality to force the Admin Bar to display when the Script Manager is loaded.<\\/li>\\n<li>Script Manager styling adjustments.<\\/li>\\n<li>Added success message on save when the Script Manager options are updated.<\\/li>\\n<li>Added support for 404 page when trying to disable or enable on the Current URL.<\\/li>\\n<\\/ul>\\n<p>1.3.8<\\/p>\\n<ul>\\n<li>Added new option to Disable Comments.<\\/li>\\n<li>Updated a section of the Script Manager to better reflect the Current URL when determining if it is a match for the given regex pattern.<\\/li>\\n<\\/ul>\\n<p>1.3.7<\\/p>\\n<ul>\\n<li>Added links to the Script Manager from the posts list page and post edit page which will take you to the front end and load the Script Manager for the corresponding post.<\\/li>\\n<li>Added warning notices for both WP_POST_REVISIONS and AUTOSAVE_INTERVAL if they are set in Perfmatters while also defined elsewhere.<\\/li>\\n<\\/ul>\\n<p>1.3.6<\\/p>\\n<ul>\\n<li>Added new option to Disable Google Fonts.<\\/li>\\n<li>Removed option to Disable Completely from the Disable REST API dropdown to due core WordPress compatibility issues.<\\/li>\\n<li>Added additional object check to prevent PHP warning in certain cases when using the Separate Archives option in the Script Manager.<\\/li>\\n<li>Added some additional logic to filter duplicate scripts out of the Script Manager master array if they are present.<\\/li>\\n<li>CSS fixes in the Script Manager for better compatibility.<\\/li>\\n<li>Expanded the Script Manager current ID function for better reliability.<\\/li>\\n<\\/ul>\\n<p>1.3.5<\\/p>\\n<ul>\\n<li>Added new Disable REST API option which will disable REST API requests and display an authentication error message if the requester doesn\'t have permission.<\\/li>\\n<li>Added additional action removal to the Remove REST API Links function.<\\/li>\\n<li>Made some changes to the Script Manager save button. It is now fixed on the bottom of the screen for easier access without having to scroll.<\\/li>\\n<li>Additional Script Manager style adjustments.<\\/li>\\n<\\/ul>\\n<p>1.3.4<\\/p>\\n<ul>\\n<li>Minor update to Remove Comment URLs function priority for better compatibility with theme templates.<\\/li>\\n<\\/ul>\\n<p>1.3.3<\\/p>\\n<ul>\\n<li>Added new option to Remove Comment URLs.<\\/li>\\n<li>Added French (fr_FR) language translation.<\\/li>\\n<li>Fixed a PHP warning that would occur when saving Script Manager settings in some instances when Display Archives was also enabled.<\\/li>\\n<\\/ul>\\n<p>1.3.2<\\/p>\\n<ul>\\n<li>Added new option to Add Blank Favicon in the Extras tab.<\\/li>\\n<li>Fixed an issue in the Script Manager Global View where options set for the home page would show up as a 0 with a broken link.<\\/li>\\n<li>Added some additional styles to the main Script Manager view for better compatibility.<\\/li>\\n<\\/ul>\\n<p>1.3.1<\\/p>\\n<ul>\\n<li>Fixed a bug that would sometimes cause an enabled message to display on the front end when using the Regex option in the Script Manager.<\\/li>\\n<\\/ul>\\n<p>1.3.0<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/regex\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Regex<\\/a> option the Script Manager for both disables and exceptions.<\\/li>\\n<li>Added new Reset option in the Script Manager settings which allows for a complete wipe + reset of all configured Script Manager options.<\\/li>\\n<li>Added additional Script Manager styles to improve compatability.<\\/li>\\n<li>Added new status message in Script Manager global view when no options have been set.<\\/li>\\n<\\/ul>\\n<p>1.2.9<\\/p>\\n<ul>\\n<li>Updated uninstallation function to account for new Script Manager settings<\\/li>\\n<li>Updated Google Analytics Disable Display Features function to work correctly with Google\'s new format.<\\/li>\\n<li>Added support to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/#monster-insights\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Use MonsterInsights<\\/a> along with Perfmatters local analytics functionality.<\\/li>\\n<li>Added new option in Script Manager settings to Display Archives which will allow you to selectively enable scripts on generated archive pages.<\\/li>\\n<\\/ul>\\n<p>1.2.8<\\/p>\\n<ul>\\n<li>Added mobile + responsive styles to the Script Manager navigation.<\\/li>\\n<li>Added additional styles to the Script Manager for compatibility.<\\/li>\\n<li>Script Manager javascript changes + improvements, specifically for compatibility with sites script minification plugins.<\\/li>\\n<li>Fixed a bug where the Script Manager disclaimer would not turn back on after being switched off.<\\/li>\\n<\\/ul>\\n<p>1.2.7<\\/p>\\n<ul>\\n<li>Small patch to check for a required WP function and include core file if necessary for some setups.<\\/li>\\n<\\/ul>\\n<p>1.2.6<\\/p>\\n<ul>\\n<li>All new Script Manager! View updated documentation at\\u00a0<a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/disable-scripts-per-post-page\\/\\\">https:\\/\\/perfmatters.io\\/docs\\/disable-scripts-per-post-page\\/<\\/a>.<\\/li>\\n<li>Fix to remove Emoji DNS Prefetch when Emojis are disabled<\\/li>\\n<\\/ul>\\n<p>1.2.5<\\/p>\\n<ul>\\n<li>Fixed an issue with the Change Login URL function that was causing an error when using WP-CLI.<\\/li>\\n<li>Added some additional compatibility styles to the Script Manager.<\\/li>\\n<\\/ul>\\n<p>1.2.4<\\/p>\\n<ul>\\n<li>Fixed a bug in the Script Manager that caused Current URL Enable checkboxes to not save properly in certain situations.<\\/li>\\n<li>Updated EDD license functions to process proper SSL verification when calling the WordPress HTTP API.<\\/li>\\n<li>Updated perfmatters_default_options array with new options from recent updates.<\\/li>\\n<li>Removed BETA tag from Local Analytics option.<\\/li>\\n<li>Added more details to the Script Manager Global Settings to see which post IDs and post types have settings assigned to them.<\\/li>\\n<li>Additional styles added to the Script Manager for better compatibility.<\\/li>\\n<li>Updated .pot and translation files.<\\/li>\\n<\\/ul>\\n<p>1.2.3<\\/p>\\n<ul>\\n<li>Bugfix - Rolled back some of the heartbeat changes from the previous update to do some additional testing. Should solve some plugin conflicts that popped up.<\\/li>\\n<\\/ul>\\n<p>1.2.2<\\/p>\\n<ul>\\n<li>Added additional WooCommerce checks for WC specific pages before running disable functions.<\\/li>\\n<li>Changes to the Disable Heartbeat function to avoid causing a script dependency error.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/disable-password-meter-strength\\/\\\">Disable Password Strength Meter<\\/a> option.<\\/li>\\n<li>Fixed an issue that was causing Script Manger dropdown colors to not display correctly when jQuery was disabled.<\\/li>\\n<li>Modified admin notice to print our using \'admin_notices\' hook. (credit: Christian Follmann)<\\/li>\\n<li>Made some adjustments to Script Manager copy to remove unnecessary HTML from the translations. (credit: Christian Follmann)<\\/li>\\n<li>Props to Hasan Basri (<a href=\\\"http:\\/\\/www.hasanbasri93.com\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\" data-saferedirecturl=\\\"https:\\/\\/www.google.com\\/url?q=http:\\/\\/www.hasanbasri93.com&amp;source=gmail&amp;ust=1530375831273000&amp;usg=AFQjCNHnfwHkAwWtNxgfmCyGrwSm3NEyng\\\">www.hasanbasri93.com<\\/a>) for Indonesian (id_ID) translation.\\u00a0&#x1f44f;<\\/li>\\n<li>Updated translations based on the new .pot file.<\\/li>\\n<li>Various other minor tweaks + improvements.<\\/li>\\n<\\/ul>\\n<p>1.2.1<\\/p>\\n<ul>\\n<li>Updated Local Analytics function to improve compatibility with different server setups.<\\/li>\\n<\\/ul>\\n<p>1.2.0<\\/p>\\n<ul>\\n<li>New option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/\\\">Enable Local Analytics<\\/a>, along with a new dedicated Google Analytics tab with various related options.<\\/li>\\n<li>Added some additional logic to redirect RSS Feed URLs when Disable RSS Feeds is toggled on.<\\/li>\\n<li>Fixed an issue that was causing certain email links not to work when using a Custom Login URL.<\\/li>\\n<li>Fixed a bug that was causing the password reset link not to function properly when using a Custom Login URL in a multisite environment.<\\/li>\\n<li>Made some adjustments to the Disable Self Pingbacks function to fix an issue with case sensitivity.<\\/li>\\n<li>Updated text domain for translations in the EDD Updater class.<\\/li>\\n<li>Fixed a bug where the Clean Uninstall option would still show up on individual sites in a multisite environment.<\\/li>\\n<li>Props to\\u00a0PDPK di Mauro Panzarola\\u00a0(<a href=\\\"https:\\/\\/pdpkapp.com\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\" data-saferedirecturl=\\\"https:\\/\\/www.google.com\\/url?q=https:\\/\\/pdpkapp.com&amp;source=gmail&amp;ust=1526653041476000&amp;usg=AFQjCNHfek6Z-CMgUhd0MwvU5QGK6cm0hg\\\">https:\\/\\/pdpkapp.com<\\/a>) for Italian (it_IT) translation.\\u00a0&#x1f44f;<\\/li>\\n<\\/ul>\\n<p>1.1.9<\\/p>\\n<ul>\\n<li>Perfmatters is now translation ready! If you are interested in helping out with a translation, please <a href=\\\"https:\\/\\/perfmatters.io\\/contact\\/\\\">contact us<\\/a>.<\\/li>\\n<li>Props to Christian Foellmann (<a href=\\\"https:\\/\\/github.com\\/cfoellmann\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">cfoellmann@GitHub<\\/a>) for German (de_DE) translation.\\u00a0&#x1f44f;<\\/li>\\n<li>Fixed a PHP undefined index warning in the Script Manager.<\\/li>\\n<li>Fixed a bug that was causing issues with the Change Login URL slug when using certain permalink settings.<\\/li>\\n<\\/ul>\\n<p>1.1.8<\\/p>\\n<ul>\\n<li>Fixed a compatibility issue with Script Manager dequeue priority that could cause it to not function properly.<\\/li>\\n<li>Minor update to the uninstall function.<\\/li>\\n<\\/ul>\\n<p>1.1.7<\\/p>\\n<ul>\\n<li>Fixed a bug that was causing the remove query strings option to conflict with files that have necessary query string parameters (Google Fonts).<\\/li>\\n<\\/ul>\\n<p>1.1.6<\\/p>\\n<ul>\\n<li>Added new Clean Uninstall option in the extras tab.<\\/li>\\n<li>Added new Preconnect option in the extras tab.<\\/li>\\n<\\/ul>\\n<p>1.1.5<\\/p>\\n<ul>\\n<li>Fixed multiple PHP warnings related to settings + option initialization.<\\/li>\\n<\\/ul>\\n<p>1.1.4<\\/p>\\n<ul>\\n<li>Added multisite support with the ability to manage default network settings and network access control.<\\/li>\\n<li>Made some adjustments to plugin naming conventions throughout WordPress admin screens, menus, etc...<\\/li>\\n<li>Removed BETA tag on Change Login URL option.<\\/li>\\n<\\/ul>\\n<p>1.1.3<\\/p>\\n<ul>\\n<li>Added new Change Login URL (BETA) feature to change your WordPress login URL and block the default wp-admin and wp-login endpoints from being directly accessed.<\\/li>\\n<li>Added new Disable Dashicons feature to disable Dashicons from the front end when not logged in.<\\/li>\\n<\\/ul>\\n<p>1.1.2<\\/p>\\n<ul>\\n<li>Added character masking to the license key input field.<\\/li>\\n<\\/ul>\\n<p>1.1.1<\\/p>\\n<ul>\\n<li>Added new CDN URL Rewrite feature in a new settings tab with various settings to customize your configuration.<\\/li>\\n<li>Added new Global Settings section in the Script Manager with a visual representation of the Script Manager options set across the entire site.<\\/li>\\n<li>Made some updates to the Script Manager layout in preparation for future additional features.<\\/li>\\n<\\/ul>\\n<p>1.1.0<\\/p>\\n<ul>\\n<li>Added new Disable Google Maps toggle.<\\/li>\\n<li>Added some backend logic to the Script Manager to hide scripts that have already been disabled sitewide via the main plugin settings.<\\/li>\\n<li>Update to the EDD license activation function variables to help prevent activation conflicts with other plugins.<\\/li>\\n<\\/ul>\\n<p>1.0.9<\\/p>\\n<ul>\\n<li>Removed the toggle to disable WooCommerce reviews, as there is already a WooCommerce setting that provides that functionality.<\\/li>\\n<\\/ul>\\n<p>1.0.8<\\/p>\\n<ul>\\n<li>Added new WooCommerce section to the options tab with multiple toggles to disable or limit certain WooCommerce scripts and functionality.<\\/li>\\n<li>Added some new styles to the plugin admin page to allow for clearer organization of different sections.<\\/li>\\n<li>Fixed an undefined index notice in the Script Manager.<\\/li>\\n<li>Added some additional styles to the checkboxes in the Script Manager to fix a theme compatibility issue.<\\/li>\\n<\\/ul>\\n<p>1.0.7<\\/p>\\n<ul>\\n<li>Added functionality to remove the shortlink\\u00a0HTTP header when \'Remove Shortlink\' is toggled on.<\\/li>\\n<li>Added functionality to remove the xmlrpc.php link as well as the X-Pingback HTTP header when \'Disable XML-RPC\' is toggled on.<\\/li>\\n<\\/ul>\\n<p>1.0.6<\\/p>\\n<ul>\\n<li>Removed BETA label from Script Manager.<\\/li>\\n<li>Added new \'DNS Prefetch\' option in the Extras tab.<\\/li>\\n<\\/ul>\\n<p>1.0.5<\\/p>\\n<ul>\\n<li>Added new toggle to \'Remove REST API Links\'.<\\/li>\\n<li>Renamed \'Remove Feed Links\' toggle for more clarification.<\\/li>\\n<li>UI improvements, hovering tooltips, more links to the web documentation, etc\\u2026<\\/li>\\n<li>Added version numbers to admin scripts to avoid caching on plugin update.<\\/li>\\n<li>Refactored a good portion of the settings initialization code.<\\/li>\\n<li>Removed \\\"Beta\\\" status for script manager. It has been fully tested now and is ready to use in production.<\\/li>\\n<li><\\/li>\\n<\\/ul>\\n<p>1.0.4<\\/p>\\n<ul>\\n<li>Fixed a few PHP warnings dealing with the Script Manager option array management.<\\/li>\\n<li>Fixed a UI bug in the Script Manager causing certain post type checkboxes\\u00a0to not be selectable.<\\/li>\\n<\\/ul>\\n<p>1.0.3<\\/p>\\n<ul>\\n<li>Introduced the new Script Manager feature to disable scripts on a per page\\/post basis.<\\/li>\\n<\\/ul>\\n<p>1.0.2<\\/p>\\n<ul>\\n<li>Added Extras tab with a new option for Accessibility\\u00a0Mode. Enabling this will turn off the custom styles we use for our settings toggles and revert to standard HTML checkboxes.<\\/li>\\n<li>Additional accessibility improvements.<\\/li>\\n<li>A few style fixes.<\\/li>\\n<\\/ul>\\n<p>1.0.1<\\/p>\\n<ul>\\n<li>Accessibility improvements to the plugin settings page.<\\/li>\\n<\\/ul>\\n<p>1.0.0<\\/p>\\n<ul>\\n<li>Plugin launched.<\\/li>\\n<\\/ul>\\n\"},\"banners\":{\"high\":\"https:\\/\\/perfmatters.io\\/wp-content\\/uploads\\/edd\\/2021\\/07\\/perfmatters-plugin-banner-1544x500-1.png\",\"low\":\"https:\\/\\/perfmatters.io\\/wp-content\\/uploads\\/edd\\/2021\\/07\\/perfmatters-plugin-banner-772x250-1.png\"},\"icons\":{\"1x\":\"https:\\/\\/perfmatters.io\\/wp-content\\/uploads\\/edd\\/2021\\/11\\/perfmatters-logo-250x250-1-128x128.png\",\"2x\":\"https:\\/\\/perfmatters.io\\/wp-content\\/uploads\\/edd\\/2021\\/11\\/perfmatters-logo-250x250-1.png\"},\"msg\":\"No license key has been provided.\",\"tested\":\"6.0.1\",\"description\":[\"<p><a href=\\\"https:\\/\\/perfmatters.io\\/\\\">Perfmatters<\\/a> is a lightweight web performance plugin designed to help increase Google Core Web Vitals scores and fine-tune how assets load on your site.<\\/p>\\n<h4> Features <\\/h4>\\n<ul>\\n<li>Easy quick toggle options to turn off resources that shouldn\'t be loading. <\\/li>\\n<li>Disable scripts and plugins on a per post\\/page or sitewide basis with the Script Manager. <\\/li>\\n<li>Defer and delay JavaScript, including third-party scripts.<\\/li>\\n<li>Automatically remove unused CSS.<\\/li>\\n<li>Preload resources, critical images, and prefetch links for quicker load times.<\\/li>\\n<li>Lazy load images and enable click-to-play thumbnails on videos.<\\/li>\\n<li>Host Google Analytics and Google Fonts locally.<\\/li>\\n<li>Change your WordPress login URL. <\\/li>\\n<li>Disable and limit WordPress revisions.<\\/li>\\n<li>Add code to your header, body, and footer.<\\/li>\\n<li>Optimize your database.<\\/li>\\n<\\/ul>\\n<h4> Documentation <\\/h4>\\n<p>Check out our <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/\\\">documentation<\\/a> for more information on how to use Perfmatters.<\\/p>\"],\"changelog\":[\"<p>1.9.5<\\/p>\\n<ul>\\n<li>Added additional logic to Delay JS script to make sure the initial interaction is processed.<\\/li>\\n<li>Added additional styles to CSS Background Image feature to work with background images set on ::before selectors.<\\/li>\\n<li>Added additional default tags to various dropdowns in plugin settings for better clarification.<\\/li>\\n<li>Added default arrays for stylesheet and selector exclusions that are always needed.<\\/li>\\n<li>Adjusted perfmatters_cdn filter location for compatibility.<\\/li>\\n<li>Made some adjustments to CDN Rewrite Regex to fix some issues where unwanted strings were getting picked up as URLs in some cases.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.9.4<\\/p>\\n<ul>\\n<li>Updated EDD plugin updater class to version 1.9.2.<\\/li>\\n<li>Added default exclusion to REST API option for compatibility.<\\/li>\\n<\\/ul>\\n<p>1.9.3<\\/p>\\n<ul>\\n<li>Remove Used CSS filter adjustment to fix an issue where certain WordPress post functions wouldn\'t be available when trying to selectively disable the feature.<\\/li>\\n<li>Rolled back minor plugin UI JavaScript addition, as it was interfering with entering data on multiple lines in certain input fields.<\\/li>\\n<\\/ul>\\n<p>1.9.2<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_allow_buffer https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_used_css\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_used_css<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_allow_buffer\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_allow_buffer<\\/a> filter.<\\/li>\\n<li>Added a notice in the Script Manager when Testing Mode is enabled.<\\/li>\\n<li>Improved reliability of CSS Background Image function when child elements with additional background images are present.<\\/li>\\n<li>Script Manager style compatibility fixes.<\\/li>\\n<li>Fixed an issue where some post specific meta options were not being respected when determining if a feature should run.<\\/li>\\n<li>Fixed an issue where pressing enter on the main plugin settings page would trigger a specific form action instead of save settings.<\\/li>\\n<li>Changed CSS class initialization hook to be in the correct order with other output buffer functions.<\\/li>\\n<li>Made an adjustment to how we generate the local used stylesheet URL for better compatibility.<\\/li>\\n<li>Fixed an issue where loading attribute was still getting applied to images that were excluded from lazy loading.<\\/li>\\n<li>Fixed an issue where images inside an excluded picture element were not also getting excluded.<\\/li>\\n<li>Fixed an issue in the Script Manager where archives were not being grouped together with their respective post type.<\\/li>\\n<li>Additions to plugin UI JavaScript to allow for disabled sections to be hidden even when nested controllers are present.<\\/li>\\n<li>Moved background process library to composer autoloader.<\\/li>\\n<li>Removed BETA tag from Remove Unused CSS option.<\\/li>\\n<\\/ul>\\n<p>1.9.1<\\/p>\\n<ul>\\n<li>Added new option to lazy load <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#css-background-images\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">CSS Background Images<\\/a>.<\\/li>\\n<li>Added new option for <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/#dual-tracking\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Dual Tracking<\\/a> when using gtag.js in local analytics.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_rest_api_exceptions\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_rest_api_exceptions<\\/a> filter.<\\/li>\\n<li>Fixed an issue where individually delayed local scripts would not get correctly rewritten to load from the CDN.<\\/li>\\n<li>Fixed an issue where lazy loading would run into an error if no px or % was specified with the threshold value.<\\/li>\\n<li>Fixed an issue with buffer validation that was conflicting with certain caching setups.<\\/li>\\n<li>Fixed an issue where existing font preconnect and prefetch tags were not being detected properly when using Local Fonts.<\\/li>\\n<li>Fixed an error related to cookie constants when running MU Mode in certain environments.<\\/li>\\n<li>Fixed multiple AMP validation errors and added additional checks to prevent certain functions from running on AMP URLs.<\\/li>\\n<li>Minor adjustment to CDN rewrite regex pattern to work with encoded quotation characters.<\\/li>\\n<li>Changed toggle CSS selectors to be more specific to prevent conflicts.<\\/li>\\n<li>Moved plugin settings header output to in_admin_header action hook for compatibility.<\\/li>\\n<li>Moved JS optimization functions to new class structure to be more inline with current codebase.<\\/li>\\n<li>Improvements to critical image preloading allowed for a move to a singular output buffer.<\\/li>\\n<\\/ul>\\n<p>1.9.0<\\/p>\\n<ul>\\n<li>Fixed an issue that was causing excluded selectors to not be recognized properly after Used CSS was cleared.<\\/li>\\n<li>Minor adjustments to the new plugin UI.<\\/li>\\n<\\/ul>\\n<p>1.8.9<\\/p>\\n<ul>\\n<li>Updated plugin settings UI.<\\/li>\\n<li>Added new post meta option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/remove-unused-css\\/#clear-individual\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Clear Used CSS<\\/a> for an individual page or post type.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_rucss_excluded_selectors\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_rucss_excluded_selectors<\\/a> filter.<\\/li>\\n<li>Fixed a lazy loading issue that was preventing some images from loading properly in Safari.<\\/li>\\n<li>Migrated Delay JS Timeout dropdown to a simpler on\\/off toggle that will default to 10 seconds. Our filter is also still available to set a custom timeout value.<\\/li>\\n<li>Fixed an issue with MU plugin that was interfering with rewrite rules in some instances.<\\/li>\\n<li>Added additional excluded page builder parameter for Flatsome UX.<\\/li>\\n<li>Moved restore default functionality to a separate option on the tools page.<\\/li>\\n<li>Code refactoring.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.8.8<\\/p>\\n<ul>\\n<li>Changed default setting for Used CSS Method from file to inline, as we think this will be the more compatible solution for most users going forward. If you were previously using the file method, you may need to save that option again.<\\/li>\\n<li>Added width and height parameters to placeholder SVGs to prevent warnings for a ratio mismatch that would happen for some images.<\\/li>\\n<li>Fixed an issue where the noscript tags were getting malformed for some images inside picture tags after lazy loading.<\\/li>\\n<li>Removed placeholder SVGs on source tags since the image tag will already have one.<\\/li>\\n<li>Changed settings export file name date format to be easier to organize when managing multiples.<\\/li>\\n<li>Updated tooltip for Blank Favicon option to be more clear.<\\/li>\\n<\\/ul>\\n<p>1.8.7<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/remove-unused-css\\/#css-method\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Used CSS Method<\\/a> option to choose whether to load used CSS from a file or inline.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_cache_path\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_cache_path<\\/a> filter.<\\/li>\\n<li>Updated metabox functions to restrict metabox display to administrators only.<\\/li>\\n<li>Made some adjustments to custom login URL function to better support 3rd party tools using WP CLI.<\\/li>\\n<li>Added Fusion Builder query string parameters to excluded page builders array.<\\/li>\\n<li>Adjusted Unused CSS regex to be more consistent when stylesheets are placed in between other link tags.<\\/li>\\n<li>Changes to instances where ABSPATH was used to determine a directory location for better compatibility with certain hosts.<\\/li>\\n<li>Fixed an issue with Remove Global Styles option where duotone SVGs were not being removed on WordPress 5.9.2.<\\/li>\\n<li>Fixed an issue where WooCommerce block stylesheets were not getting correctly dequeued when Disable Scripts option was set.<\\/li>\\n<li>Fixed an issue that was causing the CSS Parser library not to get included correctly in certain cases.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.8.6<\\/p>\\n<ul>\\n<li>Added new option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/remove-global-inline-styles-wordpress\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Remove Global Styles<\\/a> related to duotone filters.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_script_manager_locale\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_script_manager_locale<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_disable_woocommerce_scripts\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_disable_woocommerce_scripts<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_page_builders\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_page_builders<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_delay_js_behavior\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_delay_js_behavior<\\/a> filter.<\\/li>\\n<li>Fixed an issue with the unused CSS parser that was incorrectly rewriting relative URLs if there was no query string present on the original stylesheet src.<\\/li>\\n<li>Added additional parameter to page builders array for compatibility.<\\/li>\\n<li>Fixed an issue that was causing the login URL disabled 404 behavior to result in an error if a 404 template was not found.<\\/li>\\n<li>Added some additional checks before creating cache directories for local fonts and used CSS.<\\/li>\\n<li>Fixed an issue that was causing the fade-in effect to conflict with child images inside a lazy loaded container.<\\/li>\\n<li>Fixed an undefined index warning coming from unused CSS settings update function.<\\/li>\\n<li>Added a default delay JS exclusion for admin only inline customize-support script.<\\/li>\\n<li>Refactored entire meta.php code to be more efficient (38% smaller) and in line with current structure.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.8.5<\\/p>\\n<ul>\\n<li>Added new feature to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/remove-unused-css\\/#remove-unused-css\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Remove Unused CSS<\\/a> (BETA).<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_remove_unused_css\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_remove_unused_css<\\/a> filter.<\\/li>\\n<li>Adjusted CDN Rewrite buffer priority for better compatibility with other features.<\\/li>\\n<li>Made an improvement to the Disable XML-RPC function to return a 403 error when xmlrpc.php is accessed directly.<\\/li>\\n<li>Script Manager stylesheet updates for better compatibility.<\\/li>\\n<li>Fixed an issue in the Script Manager where the input controls were sometimes not displaying after toggling a script off.<\\/li>\\n<li>Added additional style for YouTube preview thumbnail play button to fix an alignment issue with certain setups.<\\/li>\\n<li>Buffer adjustments for compatibility.<\\/li>\\n<\\/ul>\\n<p>1.8.4<\\/p>\\n<ul>\\n<li>Fixed an issue that was interfering with sitemap display in certain configurations.<\\/li>\\n<li>Added &lt;a&gt; element support for lazy loading inline background images.<\\/li>\\n<\\/ul>\\n<p>1.8.3<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_fade_in_speed\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_fade_in_speed<\\/a> filter.<\\/li>\\n<li>Fixed an issue that was preventing lazy loading fade in from working correctly with certain background images.<\\/li>\\n<li>Fixed an issue that was interfering with the display of certain inline SVG elements.<\\/li>\\n<li>Adjusted local analytics hook priority for better compatibility.<\\/li>\\n<li>Script Manager style updates for better compatibility.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.8.2<\\/p>\\n<ul>\\n<li>New Lazy Loading option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#exclude-leading-images\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Exclude Leading Images<\\/a>.<\\/li>\\n<li>New Lazy Loading option to add a <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#fade-in\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Fade In<\\/a> effect.<\\/li>\\n<li>New option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/preload\\/#critical-images\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Preload Critical Images<\\/a> (BETA).<\\/li>\\n<li>Expanded Disable XML-RPC function to also remove pingback link tag if it is present in the document.<\\/li>\\n<li>Added new Delay JavaScript checkbox to meta options in the post editor.<\\/li>\\n<li>Added additional integration with perfmatters_delay_js filter.<\\/li>\\n<li>Moved YouTube autoplay parameter placement on lazy loaded iframes for better compatibility with existing query strings.<\\/li>\\n<li>Optimizations to lazy loading inline CSS functions.<\\/li>\\n<li>Various optimizations and improvements to the output buffer.<\\/li>\\n<li>Migrated manual preload functionality to use the output buffer which will allow for easier integration with new features.<\\/li>\\n<li>Made some adjustments to MU plugin functions to more reliably detect post IDs when using specific permalink setups.<\\/li>\\n<li>Fixed an issue where some Current URL links in the Script Manager\'s Global View were not pointing to the right posts.<\\/li>\\n<li>Fixed an issue with a certain endpoint that was redirecting to the custom login URL.<\\/li>\\n<li>Fixed a PHP notice that was sometimes appearing when refreshing local fonts.<\\/li>\\n<li>Removed BETA tag from Delay All JS option.<\\/li>\\n<\\/ul>\\n<p>1.8.1<\\/p>\\n<ul>\\n<li>Updated Local Google Font function to more effectively remove existing font preconnect and prefetch tags.<\\/li>\\n<li>Updated Local Google Font function for better compatibility with sites that still have remnants from a previous http to https migration.<\\/li>\\n<li>Fixed an issue in the Script Manager where the home page was being treated as a post if set to display the blog feed.<\\/li>\\n<\\/ul>\\n<p>1.8.0<\\/p>\\n<ul>\\n<li>Fixed an issue with Delay All JS that was preventing certain async scripts from fully loading.<\\/li>\\n<\\/ul>\\n<p>1.7.9<\\/p>\\n<ul>\\n<li>Added new options to the Script Manager to disable assets directly by post type, archive, user status, and device type.<\\/li>\\n<li>Added support for dynamic preloading by handle for enqueued scripts and styles.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_lazyload\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_lazyload<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_cdn\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_cdn<\\/a> filter.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_delay_js_timeout\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_delay_js_timeout<\\/a> filter.<\\/li>\\n<li>Fix to Delay All JS script for better compatibility with certain page builder animations.<\\/li>\\n<li>Updated class initialization for better compatibility.<\\/li>\\n<li>Fixed an issue where the Script Manager was interpreting certain array keys as shortcodes if they were identical.<\\/li>\\n<li>Added an additional check to prevent the Script Manager from being able to load on top of a page builder.<\\/li>\\n<li>Fixed a PHP notice coming from the MU plugin.<\\/li>\\n<li>Made some changes to our plugin updater function that should help with auto-updates in a multisite environment.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.7.8<\\/p>\\n<ul>\\n<li>Added new option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/missing-width-height-images\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Add Missing Image Dimensions<\\/a>.<\\/li>\\n<li>Added the ability to delete individual Script Manager options from the Global View.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/filters\\/#perfmatters_delay_js\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_delay_js<\\/a> filter.<\\/li>\\n<li>Updated EDD plugin updater class to version 1.9.0.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.7.7<\\/p>\\n<ul>\\n<li>Fixed a PHP warning related to JavaScript deferral for specific configurations.<\\/li>\\n<li>Fixed an issue with lazy loading exclusions not being loaded correctly in some cases.<\\/li>\\n<\\/ul>\\n<p>1.7.6<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/delay-javascript\\/#behavior\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Delay Behavior<\\/a> dropdown with a new option to Delay All Scripts.<\\/li>\\n<li>Added new Lazy Loading <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#threshold\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Threshold<\\/a> option and adjusted the default value if not set to improve performance.<\\/li>\\n<li>Added confirmation message when manually running the database optimization tool.<\\/li>\\n<li>Updated disable emoji function to get rid of a PHP notice.<\\/li>\\n<li>Added additional check to MU Mode to only filter GET requests.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/defer-javascript-wordpress\\/#perfmatters_defer_js-filter\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_defer_js<\\/a> filter.<\\/li>\\n<li>Fixed an issue where Instant Page was attempting to run on the new widgets screen in WordPress 5.8.<\\/li>\\n<li>Fixed an issue with Local Google Fonts where certain invalid font URLs would still attempt to be downloaded and served.<\\/li>\\n<li>Removed BETA tag from fonts section.<\\/li>\\n<li>Delay JavaScript compatibility improvements.<\\/li>\\n<li>Added additional input validation functionality to plugin settings page.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.7.5<\\/p>\\n<ul>\\n<li>Added new custom login URL options to change the <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/change-wordpress-login-url\\/#disabled-behavior\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Disabled Behavior<\\/a> and set a custom <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/change-wordpress-login-url\\/#message\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Message<\\/a>.<\\/li>\\n<li>Migrated CDN, Analytics, and Extras tab data to separate sections in the Options tab for better organization and easier access.<\\/li>\\n<li>CDN rewrite improvements to better handle sites with multiple domain URLs.<\\/li>\\n<li>Regex adjustments to Local Fonts function for better reliability.<\\/li>\\n<li>Added exclusion checks to individual &lt;source&gt; tags when using WebP images.<\\/li>\\n<li>Added function to disable capital_P_dangit filter.<\\/li>\\n<li>Fixed a lazy loading warning that was showing in Microsoft Edge.<\\/li>\\n<li>Removed loading attribute that was getting applied to &lt;picture&gt; tags in some cases when using WebP images.<\\/li>\\n<li>Plugin UI navigation performance improvements.<\\/li>\\n<li>Plugin UI style fixes.<\\/li>\\n<li>Added a conditional check to only show WooCommerce options when WooCommerce is installed and activated.<\\/li>\\n<li>Fixed an MU Mode issue where the Home URL did not trigger a match if a query string was present.<\\/li>\\n<li>Fixed an issue where the Customizer was getting certain optimizations applied.<\\/li>\\n<li>Fixed an issue where the Disable Embeds toggle was interfering with responsive video styles.<\\/li>\\n<li>Script Manager UI fixes.<\\/li>\\n<li>Updated uninstall function to remove Perfmatters cache folder.<\\/li>\\n<li>Added readme.txt file.<\\/li>\\n<\\/ul>\\n<p>1.7.4<\\/p>\\n<ul>\\n<li>Re-enabled Local Google Fonts functionality.<\\/li>\\n<li>Refactoring of buffer-related code and various functions that were already using our main buffer filter.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.7.3<\\/p>\\n<ul>\\n<li>Rolled back the latest changes related to the new universal buffer class and Local Google Fonts while we do some more in-depth testing. We\'ll be working to release this feature next week using an alternative method.<\\/li>\\n<\\/ul>\\n<p>1.7.2<\\/p>\\n<ul>\\n<li>Added new Fonts section inside of the main Options tab.<\\/li>\\n<li>Added new option to use <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/font-display-swap\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Display Swap<\\/a> for Google fonts.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/host-google-fonts-locally\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Local Google Fonts<\\/a> option which will attempt to download any Google Font files and serve them from your local server or CDN.<\\/li>\\n<li>Integrated new universal HTML buffer library to help going forward with plugin features that manipulate DOM elements.<\\/li>\\n<li>Migrated CDN Rewrite feature to the universal buffer class.<\\/li>\\n<li>Added new perfmatters_delayed_scripts filter to modify the Delay JavaScript input array before any scripts are delayed.<\\/li>\\n<li>Added new perfmatters_preload filter to modify the Preloads data array before anything is printed.<\\/li>\\n<li>Made some compatibility improvements to the inline lazy loading JavaScript.<\\/li>\\n<li>Added attributes to delayed scripts to exclude them from being picked up by Litespeed Cache.<\\/li>\\n<li>Added exclusion for SiteGround Optimizer to the main Script Manager JavaScript file.<\\/li>\\n<li>Added CodeMirror support to all code text area inputs in plugin settings.<\\/li>\\n<li>Removed license activation check and corresponding links from the plugins page to improve back-end performance.<\\/li>\\n<\\/ul>\\n<p>1.7.1<\\/p>\\n<ul>\\n<li>Added expiration date row to license tab in plugin settings.<\\/li>\\n<li>Added support for WooCommerce shop page when setting a preload location by post ID.<\\/li>\\n<li>Fixed an issue with device exceptions not working correctly in MU Mode.<\\/li>\\n<li>Fixed a query string encoding issue that was affecting some email templates when using a custom login URL.<\\/li>\\n<\\/ul>\\n<p>1.7.0<\\/p>\\n<ul>\\n<li>Fixed an issue where Preload tags were still being printed on archive pages even if a location was set.<\\/li>\\n<li>Fixed a compatibility issue with older WordPress versions when using certain functions that check for a JSON request.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.6.9<\\/p>\\n<ul>\\n<li>New additions to preload feature, allowing specification for device type and location.<\\/li>\\n<li>Script Manager improvements to allow for Regex disable to be used alongside Current URL disables for the same script.<\\/li>\\n<li>Added new Script Manager exception for device type.<\\/li>\\n<li>Add new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/delay-javascript\\/#timeout\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Delay Timeout<\\/a> option when delaying JavaScript.<\\/li>\\n<li>Added new wheel event to user interaction script for delay function.<\\/li>\\n<li>Added new multisite network administration tool to apply default site settings to all subsites.<\\/li>\\n<li>Multiple improvements to WooCommerce disable scripts toggle for increased effectiveness.<\\/li>\\n<li>Added additional exclusions for JSON and REST requests to all asset optimization functions.<\\/li>\\n<li>Fixed an undefined index warning coming from local analytics function.<\\/li>\\n<li>Fixed an issue where YouTube preview thumbnails were getting a layout shift warning when using a theme with responsive embed support.<\\/li>\\n<li>Fixed a Script Manager bug that was not fully clearing exceptions when changing disable away from everywhere.<\\/li>\\n<li>Script Manager styling compatibility fixes.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.6.8<\\/p>\\n<ul>\\n<li>Compatibility fixes for local analytics when using MonsterInsights.<\\/li>\\n<li>Local analytics improvements for multisite.<\\/li>\\n<li>Added alt tag to YouTube preview thumbnail images.<\\/li>\\n<li>Fixed a PHP undefined index notice coming from functions.php.<\\/li>\\n<li>Translation file updates.<\\/li>\\n<\\/ul>\\n<p>1.6.7<\\/p>\\n<ul>\\n<li>Added new tool to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/purge-meta-options\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Purge Perfmatters Meta Options<\\/a>.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/disable-google-maps-api-wordpress\\/#exclude\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Exclude Post IDs<\\/a> input for existing Disable Google Maps option.<\\/li>\\n<li>Added new gtag.js option to local analytics script type selection.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/#gtag-cdn\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">CDN URL<\\/a> input to local analytics options when using gtag.js.<\\/li>\\n<li>Added new option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/#amp\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Enable AMP Support<\\/a> to local analytics.<\\/li>\\n<li>Moved Use MonsterInsights option to gtag.js script type and updated script replacement hook.<\\/li>\\n<li>Added onload function to style preloads to prevent duplicate preloads from occurring.<\\/li>\\n<li>Added exception for WP Rocket script deferral to our lazy load script.<\\/li>\\n<li>Added exception for site health tool to disable heartbeat function.<\\/li>\\n<li>Fixed an issue where background images weren\\u2019t being lazy loaded if the style attribute was the first attribute declared on the element.<\\/li>\\n<li>Script Manager styling fixes.<\\/li>\\n<li>Fixed a PHP warning coming from settings.php.<\\/li>\\n<li>Translation file updates.<\\/li>\\n<\\/ul>\\n<p>1.6.6<\\/p>\\n<ul>\\n<li>Added new Script Manager exception to select <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/script-manager-logged-in-logged-out\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">logged in or logged out<\\/a> users.<\\/li>\\n<li>Added new option in Script Manager settings to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/script-dependencies\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Display Dependencies<\\/a>.<\\/li>\\n<li>Added total plugin sizes in the Script Manager.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#viewport-threshold\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_lazyload_threshold<\\/a> filter to adjust the distance at which lazy elements are loaded.<\\/li>\\n<li>Multiple Script Manager style and UI improvements.<\\/li>\\n<li>Fixed an issue where MU mode script was attempting to run on wp-login.php.<\\/li>\\n<li>Multiple page builder compatibility fixes.<\\/li>\\n<li>Made an adjustment to prevent YouTube preview thumbnails from getting picked up by Pinterest image hover tools.<\\/li>\\n<li>Removed deprecated plugin option to Remove Query Strings. Make sure to double-check your preloads as Google needs the exact URL when preloading.<\\/li>\\n<li>PHP 8 compatibility testing.<\\/li>\\n<li>Minor adjustments to lazy load inline scripts to fix invalid markup warnings.<\\/li>\\n<\\/ul>\\n<p>1.6.5<\\/p>\\n<ul>\\n<li>Added new option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/delay-javascript\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Delay JavaScript<\\/a> from loading until user interaction.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/#script-type\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">gtag.js v4<\\/a> option to local analytics.<\\/li>\\n<li>Added new built-in option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#exclude\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Exclude from Lazy Loading<\\/a> which can be used in addition to the existing filter.<\\/li>\\n<li>Add new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/#youtube-preview-thumbnails\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_lazyload_youtube_thumbnail_resolution<\\/a> filter to adjust YouTube preview thumbnail quality.<\\/li>\\n<li>Optimized analytics updater function.<\\/li>\\n<li>Updated EDD plugin updater class which will now allow for WordPress auto-update support.<\\/li>\\n<li>Removed option to Defer Inline JavaScript which is now being replaced by the new Delay JavaScript option.<\\/li>\\n<li>Adjusted Script Manager hook priority for better compatibility.<\\/li>\\n<li>Compatability fix to the DOM Monitoring lazy load option.<\\/li>\\n<li>Added compatibility fix for jQuery fitVids to lazy loading function.<\\/li>\\n<li>Fixed an issue where lazy loading was attempting to run on AMP pages.<\\/li>\\n<\\/ul>\\n<p>1.6.4<\\/p>\\n<ul>\\n<li>Fixed an issue that was causing the Reset Script Manager button to not work correctly.<\\/li>\\n<li>Fixed an issue where the Perfmatters meta box wouldn\'t display if only using Lazy Loading.<\\/li>\\n<li>Adjusted Script Manager hook priority for better compatibility.<\\/li>\\n<li>Added additional checks to MU Mode plugin file to prevent it from interfering with certain REST API requests. (Fixes a bug when running the Yoast SEO data indexer.)<\\/li>\\n<li>Added additional checks to confirm user functions are available before verifying admin status.<\\/li>\\n<li>Updated translation files.<\\/li>\\n<\\/ul>\\n<p>1.6.3<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/testing-mode\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Testing Mode<\\/a> option to the Script Manager settings.<\\/li>\\n<li>Rewrote script-manager.js entirely using vanilla JavaScript to get rid of jQuery dependency.<\\/li>\\n<li>Added additional MU Mode check to help prevent certain configurations from interfering with AJAX requests.<\\/li>\\n<li>Improved Script Manager form handling.<\\/li>\\n<li>Adjusted Script Manager disclaimer text and added a close button.<\\/li>\\n<li>Moved the Script Manager print function from the wp_footer hook to shutdown for better compatibility.<\\/li>\\n<li>Fixed an undefined index warning in the Lazy Load function.<\\/li>\\n<li>Added a Lazy Load exclusion for Gravity Forms iframes.<\\/li>\\n<li>Added a Rocket Loader exclusion to the Instant Page JS file.<\\/li>\\n<li>Added an exclusion to the CDN Rewrite for script-manager.js.<\\/li>\\n<li>Script Manager styling fixes for better compatibility.<\\/li>\\n<\\/ul>\\n<p>1.6.2<\\/p>\\n<ul>\\n<li>Updated placeholder text in Preload UI.<\\/li>\\n<li>Fixed an issue where the Password Strength Meter script was getting disabled in the admin.<\\/li>\\n<li>Small tweak to JS Deferral buffer to make sure HTML is being filtered correctly.<\\/li>\\n<li>Translation updates.<\\/li>\\n<\\/ul>\\n<p>1.6.1<\\/p>\\n<ul>\\n<li>New Local Analytics Script Type toggle with new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Minimal Analytics<\\/a> options.<\\/li>\\n<li>New <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/defer-javascript-wordpress\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">JavaScript Deferral<\\/a> options in Extras &gt; Assets.<\\/li>\\n<li>Updates to Cart Fragments and Password Strength Meter toggles to improve effectiveness.<\\/li>\\n<li>Multiple updates to Instant Page functionality for better compatibility.<\\/li>\\n<li>Multiple plugin admin UI updates and improvements.<\\/li>\\n<li>Script Manager style updates for better compatibility.<\\/li>\\n<li>MU Mode improvements for increased stability.<\\/li>\\n<li>Fixed an issue causing Preload and Preconnect settings to not save correctly in some cases.<\\/li>\\n<\\/ul>\\n<p>1.6.0<\\/p>\\n<ul>\\n<li>Added a filter to disable WordPress\' native lazy loading when Perfmatters\' lazy loading is active.<\\/li>\\n<li>Adjusted Script Manager styles to more effectively overlay the entire page while still allowing admin bar functions to be fully available.<\\/li>\\n<li>Fixed an undefined index notice that was appearing on specific lazy loading and script manager functions.<\\/li>\\n<li>Updated translation files.<\\/li>\\n<\\/ul>\\n<p>1.5.9<\\/p>\\n<ul>\\n<li>Added new Preloading section in the Extras tab, with new options for <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/link-prefetch\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Instant Page<\\/a> and <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/preload\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Preload<\\/a>.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">perfmatters_lazyload_forced_attributes<\\/a> filter to allow for matched elements to be skipped when checking for exclusions.<\\/li>\\n<li>Added support for WooCommerce Shop page to show up as a Current URL option in the Script Manager.<\\/li>\\n<li>Added exclusions for REST and AJAX requests to MU Mode function.<\\/li>\\n<li>Fixed a bug that was causing the MU Mode function to still run even if the Script Manager was disabled.<\\/li>\\n<li>Fixed an issue where images were being prepped for lazy loading on feed URLs.<\\/li>\\n<li>Fixed an issue where lazy loading was breaking images in embeds from the same site.<\\/li>\\n<li>Compatibility fixes for lazy load script with Autoptimize and Litespeed Cache.<\\/li>\\n<\\/ul>\\n<p>1.5.8<\\/p>\\n<ul>\\n<li>Added support for lazy loading background images, iframes, and videos.<\\/li>\\n<li>Added new lazy loading option to enable Youtube Preview Thumbnails.<\\/li>\\n<li>Added multiple page builder exclusions to our lazy load functions.<\\/li>\\n<li>Added proper support for 404 templates in the Script Manager (non-MU).<\\/li>\\n<li>Fixed some minor styling issues in the Script Manager UI.<\\/li>\\n<li>Fixed an undefined index in the database optimizer class.<\\/li>\\n<li>Removed customer email row from the license tab.<\\/li>\\n<\\/ul>\\n<p>1.5.7<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/optimize-wordpress-database\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Database Optimization<\\/a> section in the Extras tab.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">DOM Monitoring<\\/a> option to complement our existing lazy load settings.<\\/li>\\n<li>Added additional input styles in the Script Manager for better compatibility<\\/li>\\n<li>Made some changes to the Script Manager file include process for better compatibility.<\\/li>\\n<li>Fixed multiple undefined index notices.<\\/li>\\n<li>Updated translation files.<\\/li>\\n<\\/ul>\\n<p>1.5.6<\\/p>\\n<ul>\\n<li>Plugin UI improvements, new tooltip styles.<\\/li>\\n<li>Licensing workflow improvements. Simpler UI, license no longer deactivated on plugin deactivation, license auto-activates on input.<\\/li>\\n<li>Moved Script Manager javascript back to a separate plugin file for better compatibility.<\\/li>\\n<li>Added Remove Query Strings exemption to the Script Manager javascript file.<\\/li>\\n<li>Code refactoring.<\\/li>\\n<\\/ul>\\n<p>1.5.5<\\/p>\\n<ul>\\n<li>Added a new modified function to the MU plugin file which should be able to get the current post ID more effectively for certain types of URLs (custom post types, blog page, etc...).<\\/li>\\n<li>Made some improvements to the MU plugin file detection and update process.<\\/li>\\n<\\/ul>\\n<p>1.5.4<\\/p>\\n<ul>\\n<li>Added additional tooltip warning text to the MU Mode toggle.<\\/li>\\n<li>Added <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/mu-mode\\/#debug-mode\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">mu_mode=off<\\/a> URL parameter to force the page to load with MU Mode settings disabled.<\\/li>\\n<li>Added an additi0nal check to make sure MU Mode settings don\'t run if the base Perfmatters plugin is not activated.<\\/li>\\n<\\/ul>\\n<p>1.5.3<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/mu-mode\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">MU Mode<\\/a> (BETA) feature in the Script Manager which can be used to disable plugins per page.<\\/li>\\n<li>Reworked main Script Manager update function to dynamically save settings via AJAX to prevent having to reload the page every time options are saved.<\\/li>\\n<li>Moved Script Manager javascript inline to better support further updates.<\\/li>\\n<li>Fixed an issue in the Script Manager where a Current URL disable would not function correctly for an individual script if the plugin\'s scripts were disabled globally on a different Current URL.<\\/li>\\n<li>Changed hooks for Disable Google Maps and Disable Google Fonts toggles to prevent a conflict with Gutenberg.<\\/li>\\n<li>Added an exclusion attribute to our LazyLoad script to prevent it from conflicting with WP Rocket\'s JS deferral feature.<\\/li>\\n<li>Updated EDD Plugin Updater Class to version 1.7.1.<\\/li>\\n<li>Updated various translation files.<\\/li>\\n<\\/ul>\\n<p>1.5.2<\\/p>\\n<ul>\\n<li>Added new options in Extras \\u2192 Tools to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/import-export\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Import and Export Plugin Settings<\\/a>.<\\/li>\\n<li>Updated Script Manager form input names to be more specific to prevent conflicts when saving Script Manager settings.<\\/li>\\n<li>Added compatibility fix for Beaver Builder to the Script Manager dequeue function.<\\/li>\\n<li>Updated French and German translation files.<\\/li>\\n<\\/ul>\\n<p>1.5.1<\\/p>\\n<ul>\\n<li>Adjusted the Script Manager styles for better compatibility with other admin bar tools when the Script Manager UI is being displayed.<\\/li>\\n<li>Fixed an issue in the Script Manager that was causing individual script settings to not work correctly when the parent group had previously been disabled.<\\/li>\\n<li>Updated Russian (ru_RU) translation files.<\\/li>\\n<li>Updated plugin description.<\\/li>\\n<\\/ul>\\n<p>1.5.0<\\/p>\\n<ul>\\n<li>Fixed a bug that was causing the Script Manager dequeue function to interfere with the query loop in certain cases.<\\/li>\\n<\\/ul>\\n<p>1.4.9<\\/p>\\n<ul>\\n<li>Performance update to Script Manager form submission function which should help dramatically reduce the footprint when saving script configurations.<\\/li>\\n<li>Removed the Current URL option in the Script Manager when loaded on URLs without a valid post ID. (ex. dynamically generated archive templates)<\\/li>\\n<li>Added plugin settings page header with links to Contact and Support.<\\/li>\\n<li>Minor styling fixes in plugin settings UI.<\\/li>\\n<li>Updated Russian (ru_RU) translation files.<\\/li>\\n<\\/ul>\\n<p>1.4.8<\\/p>\\n<ul>\\n<li>Added new \'Body Code\' box in the Extras tab to go along with our existing header + footer boxes to give some more control there.<\\/li>\\n<li>Added some limits to the Script Manager action links in WP Admin to ensure they are only showing up for public post types.<\\/li>\\n<li>Fixed a bug that was causing the admin stylesheet not to load on the network settings page when running on a multisite.<\\/li>\\n<li>Added Russian (ru_RU) translation files. (credit: Sergey Shljahov)<\\/li>\\n<\\/ul>\\n<p>1.4.7<\\/p>\\n<ul>\\n<li>Added an exception for Gravity Forms to the Disable Heartbeat function.<\\/li>\\n<li>Added an exception for Contact Form 7 to the Disable REST API function.<\\/li>\\n<li>Added updated German (de_DE) translation files. (credit: Daniel Luttermann)<\\/li>\\n<\\/ul>\\n<p>1.4.6<\\/p>\\n<ul>\\n<li>Added a specific and more generous threshold for lazy loading.<\\/li>\\n<li>Added some additional dequeues to the Disable WooCommerce function to target inline CSS and JS.<\\/li>\\n<\\/ul>\\n<p>1.4.5<\\/p>\\n<ul>\\n<li>Updated Disable Google Maps and Disable Google Fonts toggles to not run in WP Admin.<\\/li>\\n<li>Turned off native lazy loading by default and added new option to Use Native.<\\/li>\\n<li>Added perfmatters_lazyload_excluded_attributes filter which allows for an array of attribute strings to be given that if found will exclude the matched image\\/s from lazy loading.<\\/li>\\n<li>Made some compatibility improvements to the Script Manager function that gets the ID of the current post.<\\/li>\\n<li>Added perfmatters_get_current_ID filter which allows the user to extend or modify the functionality of the Script Manager\'s current ID function.<\\/li>\\n<\\/ul>\\n<p>1.4.4<\\/p>\\n<ul>\\n<li>Fixed undefined index PHP Notice coming from the Preconnect settings display function.<\\/li>\\n<li>Added additional compatibility with Elementor when using the Script Manager to disable certain Elementor scripts + styles.<\\/li>\\n<li>Added a ignore flag class to all Lazy Load functions. Simply add the \'no-lazy\' class to any image element you want to be exempt from lazy loading.<\\/li>\\n<li>Added validation filter to Login URL input to prevent incompatible characters from being entered.<\\/li>\\n<\\/ul>\\n<p>1.4.3<\\/p>\\n<ul>\\n<li>Fixed an issue with the Lazy Load function that was causing an error with some older PHP versions.<\\/li>\\n<\\/ul>\\n<p>1.4.2<\\/p>\\n<ul>\\n<li>Added new option for <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/lazy-load-wordpress\\/\\\">Lazy Loading<\\/a> images (BETA).<\\/li>\\n<\\/ul>\\n<p>1.4.1<\\/p>\\n<ul>\\n<li>New addition to the Preconnect option, you can now choose to whether or not to add the crossorigin property for each Preconnect URL.<\\/li>\\n<li>Optimization to the loading of Perfmatters admin scripts + styles.<\\/li>\\n<li>Added additional Script Manager styles for better compatibility.<\\/li>\\n<li>Added an additional function for the Custom Login URL to help rewrite certain wp-admin links in specific multisite setups.<\\/li>\\n<li>Reorganized plugin action links in the plugins table.<\\/li>\\n<\\/ul>\\n<p>1.4.0<\\/p>\\n<ul>\\n<li>Fixed an issue where the Current URL Exceptions were not loading correctly after saving in the Script Manager.<\\/li>\\n<\\/ul>\\n<p>1.3.9<\\/p>\\n<ul>\\n<li>Added new Extra options to Add Header Code and Add Footer Code.<\\/li>\\n<li>Added missing blank defaults for DNS Prefetch and Preconnect options.<\\/li>\\n<li>Added functionality to force the Admin Bar to display when the Script Manager is loaded.<\\/li>\\n<li>Script Manager styling adjustments.<\\/li>\\n<li>Added success message on save when the Script Manager options are updated.<\\/li>\\n<li>Added support for 404 page when trying to disable or enable on the Current URL.<\\/li>\\n<\\/ul>\\n<p>1.3.8<\\/p>\\n<ul>\\n<li>Added new option to Disable Comments.<\\/li>\\n<li>Updated a section of the Script Manager to better reflect the Current URL when determining if it is a match for the given regex pattern.<\\/li>\\n<\\/ul>\\n<p>1.3.7<\\/p>\\n<ul>\\n<li>Added links to the Script Manager from the posts list page and post edit page which will take you to the front end and load the Script Manager for the corresponding post.<\\/li>\\n<li>Added warning notices for both WP_POST_REVISIONS and AUTOSAVE_INTERVAL if they are set in Perfmatters while also defined elsewhere.<\\/li>\\n<\\/ul>\\n<p>1.3.6<\\/p>\\n<ul>\\n<li>Added new option to Disable Google Fonts.<\\/li>\\n<li>Removed option to Disable Completely from the Disable REST API dropdown to due core WordPress compatibility issues.<\\/li>\\n<li>Added additional object check to prevent PHP warning in certain cases when using the Separate Archives option in the Script Manager.<\\/li>\\n<li>Added some additional logic to filter duplicate scripts out of the Script Manager master array if they are present.<\\/li>\\n<li>CSS fixes in the Script Manager for better compatibility.<\\/li>\\n<li>Expanded the Script Manager current ID function for better reliability.<\\/li>\\n<\\/ul>\\n<p>1.3.5<\\/p>\\n<ul>\\n<li>Added new Disable REST API option which will disable REST API requests and display an authentication error message if the requester doesn\'t have permission.<\\/li>\\n<li>Added additional action removal to the Remove REST API Links function.<\\/li>\\n<li>Made some changes to the Script Manager save button. It is now fixed on the bottom of the screen for easier access without having to scroll.<\\/li>\\n<li>Additional Script Manager style adjustments.<\\/li>\\n<\\/ul>\\n<p>1.3.4<\\/p>\\n<ul>\\n<li>Minor update to Remove Comment URLs function priority for better compatibility with theme templates.<\\/li>\\n<\\/ul>\\n<p>1.3.3<\\/p>\\n<ul>\\n<li>Added new option to Remove Comment URLs.<\\/li>\\n<li>Added French (fr_FR) language translation.<\\/li>\\n<li>Fixed a PHP warning that would occur when saving Script Manager settings in some instances when Display Archives was also enabled.<\\/li>\\n<\\/ul>\\n<p>1.3.2<\\/p>\\n<ul>\\n<li>Added new option to Add Blank Favicon in the Extras tab.<\\/li>\\n<li>Fixed an issue in the Script Manager Global View where options set for the home page would show up as a 0 with a broken link.<\\/li>\\n<li>Added some additional styles to the main Script Manager view for better compatibility.<\\/li>\\n<\\/ul>\\n<p>1.3.1<\\/p>\\n<ul>\\n<li>Fixed a bug that would sometimes cause an enabled message to display on the front end when using the Regex option in the Script Manager.<\\/li>\\n<\\/ul>\\n<p>1.3.0<\\/p>\\n<ul>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/regex\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Regex<\\/a> option the Script Manager for both disables and exceptions.<\\/li>\\n<li>Added new Reset option in the Script Manager settings which allows for a complete wipe + reset of all configured Script Manager options.<\\/li>\\n<li>Added additional Script Manager styles to improve compatability.<\\/li>\\n<li>Added new status message in Script Manager global view when no options have been set.<\\/li>\\n<\\/ul>\\n<p>1.2.9<\\/p>\\n<ul>\\n<li>Updated uninstallation function to account for new Script Manager settings<\\/li>\\n<li>Updated Google Analytics Disable Display Features function to work correctly with Google\'s new format.<\\/li>\\n<li>Added support to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/#monster-insights\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Use MonsterInsights<\\/a> along with Perfmatters local analytics functionality.<\\/li>\\n<li>Added new option in Script Manager settings to Display Archives which will allow you to selectively enable scripts on generated archive pages.<\\/li>\\n<\\/ul>\\n<p>1.2.8<\\/p>\\n<ul>\\n<li>Added mobile + responsive styles to the Script Manager navigation.<\\/li>\\n<li>Added additional styles to the Script Manager for compatibility.<\\/li>\\n<li>Script Manager javascript changes + improvements, specifically for compatibility with sites script minification plugins.<\\/li>\\n<li>Fixed a bug where the Script Manager disclaimer would not turn back on after being switched off.<\\/li>\\n<\\/ul>\\n<p>1.2.7<\\/p>\\n<ul>\\n<li>Small patch to check for a required WP function and include core file if necessary for some setups.<\\/li>\\n<\\/ul>\\n<p>1.2.6<\\/p>\\n<ul>\\n<li>All new Script Manager! View updated documentation at\\u00a0<a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/disable-scripts-per-post-page\\/\\\">https:\\/\\/perfmatters.io\\/docs\\/disable-scripts-per-post-page\\/<\\/a>.<\\/li>\\n<li>Fix to remove Emoji DNS Prefetch when Emojis are disabled<\\/li>\\n<\\/ul>\\n<p>1.2.5<\\/p>\\n<ul>\\n<li>Fixed an issue with the Change Login URL function that was causing an error when using WP-CLI.<\\/li>\\n<li>Added some additional compatibility styles to the Script Manager.<\\/li>\\n<\\/ul>\\n<p>1.2.4<\\/p>\\n<ul>\\n<li>Fixed a bug in the Script Manager that caused Current URL Enable checkboxes to not save properly in certain situations.<\\/li>\\n<li>Updated EDD license functions to process proper SSL verification when calling the WordPress HTTP API.<\\/li>\\n<li>Updated perfmatters_default_options array with new options from recent updates.<\\/li>\\n<li>Removed BETA tag from Local Analytics option.<\\/li>\\n<li>Added more details to the Script Manager Global Settings to see which post IDs and post types have settings assigned to them.<\\/li>\\n<li>Additional styles added to the Script Manager for better compatibility.<\\/li>\\n<li>Updated .pot and translation files.<\\/li>\\n<\\/ul>\\n<p>1.2.3<\\/p>\\n<ul>\\n<li>Bugfix - Rolled back some of the heartbeat changes from the previous update to do some additional testing. Should solve some plugin conflicts that popped up.<\\/li>\\n<\\/ul>\\n<p>1.2.2<\\/p>\\n<ul>\\n<li>Added additional WooCommerce checks for WC specific pages before running disable functions.<\\/li>\\n<li>Changes to the Disable Heartbeat function to avoid causing a script dependency error.<\\/li>\\n<li>Added new <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/disable-password-meter-strength\\/\\\">Disable Password Strength Meter<\\/a> option.<\\/li>\\n<li>Fixed an issue that was causing Script Manger dropdown colors to not display correctly when jQuery was disabled.<\\/li>\\n<li>Modified admin notice to print our using \'admin_notices\' hook. (credit: Christian Follmann)<\\/li>\\n<li>Made some adjustments to Script Manager copy to remove unnecessary HTML from the translations. (credit: Christian Follmann)<\\/li>\\n<li>Props to Hasan Basri (<a href=\\\"http:\\/\\/www.hasanbasri93.com\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\" data-saferedirecturl=\\\"https:\\/\\/www.google.com\\/url?q=http:\\/\\/www.hasanbasri93.com&amp;source=gmail&amp;ust=1530375831273000&amp;usg=AFQjCNHnfwHkAwWtNxgfmCyGrwSm3NEyng\\\">www.hasanbasri93.com<\\/a>) for Indonesian (id_ID) translation.\\u00a0&#x1f44f;<\\/li>\\n<li>Updated translations based on the new .pot file.<\\/li>\\n<li>Various other minor tweaks + improvements.<\\/li>\\n<\\/ul>\\n<p>1.2.1<\\/p>\\n<ul>\\n<li>Updated Local Analytics function to improve compatibility with different server setups.<\\/li>\\n<\\/ul>\\n<p>1.2.0<\\/p>\\n<ul>\\n<li>New option to <a href=\\\"https:\\/\\/perfmatters.io\\/docs\\/local-analytics\\/\\\">Enable Local Analytics<\\/a>, along with a new dedicated Google Analytics tab with various related options.<\\/li>\\n<li>Added some additional logic to redirect RSS Feed URLs when Disable RSS Feeds is toggled on.<\\/li>\\n<li>Fixed an issue that was causing certain email links not to work when using a Custom Login URL.<\\/li>\\n<li>Fixed a bug that was causing the password reset link not to function properly when using a Custom Login URL in a multisite environment.<\\/li>\\n<li>Made some adjustments to the Disable Self Pingbacks function to fix an issue with case sensitivity.<\\/li>\\n<li>Updated text domain for translations in the EDD Updater class.<\\/li>\\n<li>Fixed a bug where the Clean Uninstall option would still show up on individual sites in a multisite environment.<\\/li>\\n<li>Props to\\u00a0PDPK di Mauro Panzarola\\u00a0(<a href=\\\"https:\\/\\/pdpkapp.com\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\" data-saferedirecturl=\\\"https:\\/\\/www.google.com\\/url?q=https:\\/\\/pdpkapp.com&amp;source=gmail&amp;ust=1526653041476000&amp;usg=AFQjCNHfek6Z-CMgUhd0MwvU5QGK6cm0hg\\\">https:\\/\\/pdpkapp.com<\\/a>) for Italian (it_IT) translation.\\u00a0&#x1f44f;<\\/li>\\n<\\/ul>\\n<p>1.1.9<\\/p>\\n<ul>\\n<li>Perfmatters is now translation ready! If you are interested in helping out with a translation, please <a href=\\\"https:\\/\\/perfmatters.io\\/contact\\/\\\">contact us<\\/a>.<\\/li>\\n<li>Props to Christian Foellmann (<a href=\\\"https:\\/\\/github.com\\/cfoellmann\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">cfoellmann@GitHub<\\/a>) for German (de_DE) translation.\\u00a0&#x1f44f;<\\/li>\\n<li>Fixed a PHP undefined index warning in the Script Manager.<\\/li>\\n<li>Fixed a bug that was causing issues with the Change Login URL slug when using certain permalink settings.<\\/li>\\n<\\/ul>\\n<p>1.1.8<\\/p>\\n<ul>\\n<li>Fixed a compatibility issue with Script Manager dequeue priority that could cause it to not function properly.<\\/li>\\n<li>Minor update to the uninstall function.<\\/li>\\n<\\/ul>\\n<p>1.1.7<\\/p>\\n<ul>\\n<li>Fixed a bug that was causing the remove query strings option to conflict with files that have necessary query string parameters (Google Fonts).<\\/li>\\n<\\/ul>\\n<p>1.1.6<\\/p>\\n<ul>\\n<li>Added new Clean Uninstall option in the extras tab.<\\/li>\\n<li>Added new Preconnect option in the extras tab.<\\/li>\\n<\\/ul>\\n<p>1.1.5<\\/p>\\n<ul>\\n<li>Fixed multiple PHP warnings related to settings + option initialization.<\\/li>\\n<\\/ul>\\n<p>1.1.4<\\/p>\\n<ul>\\n<li>Added multisite support with the ability to manage default network settings and network access control.<\\/li>\\n<li>Made some adjustments to plugin naming conventions throughout WordPress admin screens, menus, etc...<\\/li>\\n<li>Removed BETA tag on Change Login URL option.<\\/li>\\n<\\/ul>\\n<p>1.1.3<\\/p>\\n<ul>\\n<li>Added new Change Login URL (BETA) feature to change your WordPress login URL and block the default wp-admin and wp-login endpoints from being directly accessed.<\\/li>\\n<li>Added new Disable Dashicons feature to disable Dashicons from the front end when not logged in.<\\/li>\\n<\\/ul>\\n<p>1.1.2<\\/p>\\n<ul>\\n<li>Added character masking to the license key input field.<\\/li>\\n<\\/ul>\\n<p>1.1.1<\\/p>\\n<ul>\\n<li>Added new CDN URL Rewrite feature in a new settings tab with various settings to customize your configuration.<\\/li>\\n<li>Added new Global Settings section in the Script Manager with a visual representation of the Script Manager options set across the entire site.<\\/li>\\n<li>Made some updates to the Script Manager layout in preparation for future additional features.<\\/li>\\n<\\/ul>\\n<p>1.1.0<\\/p>\\n<ul>\\n<li>Added new Disable Google Maps toggle.<\\/li>\\n<li>Added some backend logic to the Script Manager to hide scripts that have already been disabled sitewide via the main plugin settings.<\\/li>\\n<li>Update to the EDD license activation function variables to help prevent activation conflicts with other plugins.<\\/li>\\n<\\/ul>\\n<p>1.0.9<\\/p>\\n<ul>\\n<li>Removed the toggle to disable WooCommerce reviews, as there is already a WooCommerce setting that provides that functionality.<\\/li>\\n<\\/ul>\\n<p>1.0.8<\\/p>\\n<ul>\\n<li>Added new WooCommerce section to the options tab with multiple toggles to disable or limit certain WooCommerce scripts and functionality.<\\/li>\\n<li>Added some new styles to the plugin admin page to allow for clearer organization of different sections.<\\/li>\\n<li>Fixed an undefined index notice in the Script Manager.<\\/li>\\n<li>Added some additional styles to the checkboxes in the Script Manager to fix a theme compatibility issue.<\\/li>\\n<\\/ul>\\n<p>1.0.7<\\/p>\\n<ul>\\n<li>Added functionality to remove the shortlink\\u00a0HTTP header when \'Remove Shortlink\' is toggled on.<\\/li>\\n<li>Added functionality to remove the xmlrpc.php link as well as the X-Pingback HTTP header when \'Disable XML-RPC\' is toggled on.<\\/li>\\n<\\/ul>\\n<p>1.0.6<\\/p>\\n<ul>\\n<li>Removed BETA label from Script Manager.<\\/li>\\n<li>Added new \'DNS Prefetch\' option in the Extras tab.<\\/li>\\n<\\/ul>\\n<p>1.0.5<\\/p>\\n<ul>\\n<li>Added new toggle to \'Remove REST API Links\'.<\\/li>\\n<li>Renamed \'Remove Feed Links\' toggle for more clarification.<\\/li>\\n<li>UI improvements, hovering tooltips, more links to the web documentation, etc\\u2026<\\/li>\\n<li>Added version numbers to admin scripts to avoid caching on plugin update.<\\/li>\\n<li>Refactored a good portion of the settings initialization code.<\\/li>\\n<li>Removed \\\"Beta\\\" status for script manager. It has been fully tested now and is ready to use in production.<\\/li>\\n<li><\\/li>\\n<\\/ul>\\n<p>1.0.4<\\/p>\\n<ul>\\n<li>Fixed a few PHP warnings dealing with the Script Manager option array management.<\\/li>\\n<li>Fixed a UI bug in the Script Manager causing certain post type checkboxes\\u00a0to not be selectable.<\\/li>\\n<\\/ul>\\n<p>1.0.3<\\/p>\\n<ul>\\n<li>Introduced the new Script Manager feature to disable scripts on a per page\\/post basis.<\\/li>\\n<\\/ul>\\n<p>1.0.2<\\/p>\\n<ul>\\n<li>Added Extras tab with a new option for Accessibility\\u00a0Mode. Enabling this will turn off the custom styles we use for our settings toggles and revert to standard HTML checkboxes.<\\/li>\\n<li>Additional accessibility improvements.<\\/li>\\n<li>A few style fixes.<\\/li>\\n<\\/ul>\\n<p>1.0.1<\\/p>\\n<ul>\\n<li>Accessibility improvements to the plugin settings page.<\\/li>\\n<\\/ul>\\n<p>1.0.0<\\/p>\\n<ul>\\n<li>Plugin launched.<\\/li>\\n<\\/ul>\\n\"],\"plugin\":\"perfmatters\\/perfmatters.php\",\"id\":\"perfmatters\\/perfmatters.php\"}\";}", "no");
INSERT INTO `wp_options` VALUES("36579", "widget_register_space_prk", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("42018", "city_categories_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("41999", "widget_woocommerce-widget-layered-nav_brand", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("42000", "widget_woocommerce-widget-layered-nav_cat", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("42001", "widget_woocommerce-widget-layered-on_stock", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("42002", "brand_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("40914", "wp_calendar_block_has_published_posts", "1", "yes");
INSERT INTO `wp_options` VALUES("41847", "duplicator_version_plugin", "1.5.12", "yes");
INSERT INTO `wp_options` VALUES("41855", "duplicator_exe_safe_mode", "", "yes");
INSERT INTO `wp_options` VALUES("50834", "_transient_shipping-transient-version", "1722687364", "yes");
INSERT INTO `wp_options` VALUES("62232", "_transient_product_query-transient-version", "1754060894", "on");
INSERT INTO `wp_options` VALUES("173589", "_transient_timeout_wc_product_children_2683", "1756399082", "off");
INSERT INTO `wp_options` VALUES("173590", "_transient_wc_product_children_2683", "a:3:{s:3:\"all\";a:3:{i:0;i:2684;i:1;i:2685;i:2;i:2686;}s:7:\"visible\";a:3:{i:0;i:2684;i:1;i:2685;i:2;i:2686;}s:7:\"version\";s:10:\"1730655240\";}", "off");
INSERT INTO `wp_options` VALUES("50841", "_transient_product-transient-version", "1730655240", "yes");
INSERT INTO `wp_options` VALUES("174434", "_transient_timeout_wc_var_prices_2683", "1756609702", "off");
INSERT INTO `wp_options` VALUES("174435", "_transient_wc_var_prices_2683", "{\"version\":\"1730655240\",\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"2684\":\"2140000\",\"2685\":\"2340000\",\"2686\":\"2140000\"},\"regular_price\":{\"2684\":\"2640000\",\"2685\":\"2740000\",\"2686\":\"2240000\"},\"sale_price\":{\"2684\":\"2140000\",\"2685\":\"2340000\",\"2686\":\"2140000\"}},\"4173c8e28f114c545d779c47fd7e2df1\":{\"price\":{\"2684\":\"2140000\",\"2685\":\"2340000\",\"2686\":\"2140000\"},\"regular_price\":{\"2684\":\"2640000\",\"2685\":\"2740000\",\"2686\":\"2240000\"},\"sale_price\":{\"2684\":\"2140000\",\"2685\":\"2340000\",\"2686\":\"2140000\"}}}", "off");
INSERT INTO `wp_options` VALUES("173591", "_transient_timeout_wc_product_children_2679", "1756399082", "off");
INSERT INTO `wp_options` VALUES("173592", "_transient_wc_product_children_2679", "a:3:{s:3:\"all\";a:2:{i:0;i:2680;i:1;i:2681;}s:7:\"visible\";a:2:{i:0;i:2680;i:1;i:2681;}s:7:\"version\";s:10:\"1730655240\";}", "off");
INSERT INTO `wp_options` VALUES("174436", "_transient_timeout_wc_var_prices_2679", "1756609702", "off");
INSERT INTO `wp_options` VALUES("174437", "_transient_wc_var_prices_2679", "{\"version\":\"1730655240\",\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"2680\":\"33410000\",\"2681\":\"34690000\"},\"regular_price\":{\"2680\":\"38410000\",\"2681\":\"38690000\"},\"sale_price\":{\"2680\":\"33410000\",\"2681\":\"34690000\"}},\"4173c8e28f114c545d779c47fd7e2df1\":{\"price\":{\"2680\":\"33410000\",\"2681\":\"34690000\"},\"regular_price\":{\"2680\":\"38410000\",\"2681\":\"38690000\"},\"sale_price\":{\"2680\":\"33410000\",\"2681\":\"34690000\"}}}", "off");
INSERT INTO `wp_options` VALUES("173593", "_transient_timeout_wc_product_children_2673", "1756399082", "off");
INSERT INTO `wp_options` VALUES("173594", "_transient_wc_product_children_2673", "a:3:{s:3:\"all\";a:2:{i:0;i:2674;i:1;i:2675;}s:7:\"visible\";a:2:{i:0;i:2674;i:1;i:2675;}s:7:\"version\";s:10:\"1730655240\";}", "off");
INSERT INTO `wp_options` VALUES("174438", "_transient_timeout_wc_var_prices_2673", "1756609702", "off");
INSERT INTO `wp_options` VALUES("174439", "_transient_wc_var_prices_2673", "{\"version\":\"1730655240\",\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"2674\":\"33410000\",\"2675\":\"34690000\"},\"regular_price\":{\"2674\":\"38410000\",\"2675\":\"38690000\"},\"sale_price\":{\"2674\":\"33410000\",\"2675\":\"34690000\"}},\"4173c8e28f114c545d779c47fd7e2df1\":{\"price\":{\"2674\":\"33410000\",\"2675\":\"34690000\"},\"regular_price\":{\"2674\":\"38410000\",\"2675\":\"38690000\"},\"sale_price\":{\"2674\":\"33410000\",\"2675\":\"34690000\"}}}", "off");
INSERT INTO `wp_options` VALUES("50854", "_transient_jetpack_autoloader_plugin_paths", "a:1:{i:0;s:29:\"{{WP_PLUGIN_DIR}}/woocommerce\";}", "yes");
INSERT INTO `wp_options` VALUES("51628", "_transient_woocommerce_reports-transient-version", "1753963262", "on");
INSERT INTO `wp_options` VALUES("41844", "action_scheduler_migration_status", "complete", "yes");
INSERT INTO `wp_options` VALUES("50825", "duplicator_pro_exe_safe_mode", "0", "yes");
INSERT INTO `wp_options` VALUES("50826", "duplicator_activate_plugins_after_installation", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("50828", "duplicator_migration_data", "{\n    \"time\": 1722687362,\n    \"installType\": -1,\n    \"restoreBackupMode\": false,\n    \"recoveryMode\": false,\n    \"archivePath\": \"\\/home2\\/parskal6\\/domains\\/mobile.parskalas.com\\/public_html\\/digital_prk_ver337_0f5051d689e02a448760_20230706013312_archive.zip\",\n    \"packageHash\": \"0f5051d-06013312\",\n    \"installerPath\": \"\\/home2\\/parskal6\\/domains\\/mobile.parskalas.com\\/public_html\\/installer.php\",\n    \"installerBootLog\": \"\\/home2\\/parskal6\\/domains\\/mobile.parskalas.com\\/public_html\\/dup-installer-bootlog__14b52f1-06013312.txt\",\n    \"installerLog\": \"\\/home2\\/parskal6\\/domains\\/mobile.parskalas.com\\/public_html\\/dup-installer\\/dup-installer-log__14b52f1-06013312.txt\",\n    \"dupInstallerPath\": \"\\/home2\\/parskal6\\/domains\\/mobile.parskalas.com\\/public_html\\/dup-installer\",\n    \"origFileFolderPath\": \"\\/home2\\/parskal6\\/domains\\/mobile.parskalas.com\\/public_html\\/dup-installer\\/original_files_0f5051d-06013312\",\n    \"safeMode\": 0,\n    \"cleanInstallerFiles\": true\n}", "no");
INSERT INTO `wp_options` VALUES("155556", "woocommerce_downloads_deliver_inline", "", "off");
INSERT INTO `wp_options` VALUES("155557", "woocommerce_downloads_count_partial", "yes", "on");
INSERT INTO `wp_options` VALUES("155558", "woocommerce_attribute_lookup_optimized_updates", "no", "on");
INSERT INTO `wp_options` VALUES("155559", "woocommerce_product_match_featured_image_by_sku", "no", "on");
INSERT INTO `wp_options` VALUES("155560", "woocommerce_shipping_hide_rates_when_free", "no", "off");
INSERT INTO `wp_options` VALUES("155561", "woocommerce_anonymize_refunded_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "off");
INSERT INTO `wp_options` VALUES("155562", "woocommerce_email_header_image_width", "120", "on");
INSERT INTO `wp_options` VALUES("155563", "woocommerce_email_header_alignment", "left", "on");
INSERT INTO `wp_options` VALUES("155564", "woocommerce_email_font_family", "Helvetica", "on");
INSERT INTO `wp_options` VALUES("155565", "woocommerce_email_footer_text_color", "#3c3c3c", "off");
INSERT INTO `wp_options` VALUES("155566", "woocommerce_email_auto_sync_with_theme", "no", "off");
INSERT INTO `wp_options` VALUES("155567", "woocommerce_custom_orders_table_created", "no", "auto");
INSERT INTO `wp_options` VALUES("155568", "woocommerce_custom_orders_table_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("155569", "woocommerce_feature_rate_limit_checkout_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("155570", "woocommerce_feature_order_attribution_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("155571", "woocommerce_feature_site_visibility_badge_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("155572", "woocommerce_feature_remote_logging_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("155573", "woocommerce_feature_email_improvements_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("155574", "woocommerce_feature_blueprint_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("155575", "woocommerce_feature_product_block_editor_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("155576", "woocommerce_hpos_fts_index_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("155577", "woocommerce_hpos_datastore_caching_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("155578", "woocommerce_feature_block_email_editor_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("155579", "woocommerce_feature_cost_of_goods_sold_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("50830", "_transient_woocommerce_webhook_ids_status_active", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("50879", "pw_notices", "a:1:{s:7:\"notices\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("50880", "_elementor_global_css", "a:6:{s:4:\"time\";i:1722687414;s:5:\"fonts\";a:0:{}s:5:\"icons\";a:0:{}s:20:\"dynamic_elements_ids\";a:0:{}s:6:\"status\";s:4:\"file\";i:0;b:0;}", "yes");
INSERT INTO `wp_options` VALUES("50798", "duplicator_uninstall_package", "1", "yes");
INSERT INTO `wp_options` VALUES("50799", "duplicator_uninstall_settings", "1", "yes");
INSERT INTO `wp_options` VALUES("155626", "duplicator_install_info", "a:3:{s:7:\"version\";s:7:\"1.5.3.1\";s:4:\"time\";i:1688607039;s:10:\"updateTime\";i:1749974598;}", "off");
INSERT INTO `wp_options` VALUES("51031", "_transient_health-check-site-status-result", "{\"good\":17,\"recommended\":2,\"critical\":4}", "yes");
INSERT INTO `wp_options` VALUES("51625", "_transient_orders-transient-version", "1753895442", "on");
INSERT INTO `wp_options` VALUES("57908", "wp_attachment_pages_enabled", "1", "on");
INSERT INTO `wp_options` VALUES("174540", "_transient_timeout_wc_var_prices_2615", "1756646471", "off");
INSERT INTO `wp_options` VALUES("174541", "_transient_wc_var_prices_2615", "{\"version\":\"1730655240\",\"4173c8e28f114c545d779c47fd7e2df1\":{\"price\":{\"2617\":\"34670000\",\"2618\":\"36670000\"},\"regular_price\":{\"2617\":\"39670000\",\"2618\":\"39670000\"},\"sale_price\":{\"2617\":\"34670000\",\"2618\":\"36670000\"}},\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"2617\":\"34670000\",\"2618\":\"36670000\"},\"regular_price\":{\"2617\":\"39670000\",\"2618\":\"39670000\"},\"sale_price\":{\"2617\":\"34670000\",\"2618\":\"36670000\"}}}", "off");
INSERT INTO `wp_options` VALUES("174536", "_transient_timeout_wc_var_prices_2599", "1756646471", "off");
INSERT INTO `wp_options` VALUES("174537", "_transient_wc_var_prices_2599", "{\"version\":\"1730655240\",\"4173c8e28f114c545d779c47fd7e2df1\":{\"price\":{\"2608\":\"16730000\",\"2600\":\"16260000\",\"2601\":\"17290000\",\"2602\":\"17560000\"},\"regular_price\":{\"2608\":\"18560000\",\"2600\":\"18260000\",\"2601\":\"18390000\",\"2602\":\"18790000\"},\"sale_price\":{\"2608\":\"16730000\",\"2600\":\"16260000\",\"2601\":\"17290000\",\"2602\":\"17560000\"}},\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"2608\":\"16730000\",\"2600\":\"16260000\",\"2601\":\"17290000\",\"2602\":\"17560000\"},\"regular_price\":{\"2608\":\"18560000\",\"2600\":\"18260000\",\"2601\":\"18390000\",\"2602\":\"18790000\"},\"sale_price\":{\"2608\":\"16730000\",\"2600\":\"16260000\",\"2601\":\"17290000\",\"2602\":\"17560000\"}}}", "off");
INSERT INTO `wp_options` VALUES("174538", "_transient_timeout_wc_var_prices_2610", "1756646471", "off");
INSERT INTO `wp_options` VALUES("174539", "_transient_wc_var_prices_2610", "{\"version\":\"1730655240\",\"4173c8e28f114c545d779c47fd7e2df1\":{\"price\":{\"2611\":\"23540000\",\"2612\":\"26740000\",\"2613\":\"27840000\"},\"regular_price\":{\"2611\":\"28540000\",\"2612\":\"28540000\",\"2613\":\"29540000\"},\"sale_price\":{\"2611\":\"23540000\",\"2612\":\"26740000\",\"2613\":\"27840000\"}},\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"2611\":\"23540000\",\"2612\":\"26740000\",\"2613\":\"27840000\"},\"regular_price\":{\"2611\":\"28540000\",\"2612\":\"28540000\",\"2613\":\"29540000\"},\"sale_price\":{\"2611\":\"23540000\",\"2612\":\"26740000\",\"2613\":\"27840000\"}}}", "off");
INSERT INTO `wp_options` VALUES("162963", "_transient_timeout_wc_var_prices_2646", "1754047814", "off");
INSERT INTO `wp_options` VALUES("162964", "_transient_wc_var_prices_2646", "{\"version\":\"1730655240\",\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"2655\":\"36510000\",\"2649\":\"36650000\"},\"regular_price\":{\"2655\":\"37650000\",\"2649\":\"37650000\"},\"sale_price\":{\"2655\":\"36510000\",\"2649\":\"36650000\"}},\"4173c8e28f114c545d779c47fd7e2df1\":{\"price\":{\"2655\":\"36510000\",\"2649\":\"36650000\"},\"regular_price\":{\"2655\":\"37650000\",\"2649\":\"37650000\"},\"sale_price\":{\"2655\":\"36510000\",\"2649\":\"36650000\"}}}", "off");
INSERT INTO `wp_options` VALUES("167158", "_transient_timeout_wc_product_children_2635", "1754294812", "off");
INSERT INTO `wp_options` VALUES("167159", "_transient_wc_product_children_2635", "a:3:{s:3:\"all\";a:3:{i:0;i:2636;i:1;i:2637;i:2;i:2638;}s:7:\"visible\";a:3:{i:0;i:2636;i:1;i:2637;i:2;i:2638;}s:7:\"version\";s:10:\"1730655240\";}", "off");
INSERT INTO `wp_options` VALUES("167156", "_transient_timeout_wc_product_children_2640", "1754294812", "off");
INSERT INTO `wp_options` VALUES("167157", "_transient_wc_product_children_2640", "a:3:{s:3:\"all\";a:3:{i:0;i:2642;i:1;i:2641;i:2;i:2643;}s:7:\"visible\";a:3:{i:0;i:2642;i:1;i:2641;i:2;i:2643;}s:7:\"version\";s:10:\"1730655240\";}", "off");
INSERT INTO `wp_options` VALUES("167160", "_transient_timeout_wc_product_children_2264", "1754294812", "off");
INSERT INTO `wp_options` VALUES("167161", "_transient_wc_product_children_2264", "a:3:{s:3:\"all\";a:4:{i:0;i:2268;i:1;i:2265;i:2;i:2266;i:3;i:2267;}s:7:\"visible\";a:4:{i:0;i:2268;i:1;i:2265;i:2;i:2266;i:3;i:2267;}s:7:\"version\";s:10:\"1730655240\";}", "off");
INSERT INTO `wp_options` VALUES("167162", "_transient_timeout_wc_product_children_2625", "1754294812", "off");
INSERT INTO `wp_options` VALUES("167163", "_transient_wc_product_children_2625", "a:3:{s:3:\"all\";a:3:{i:0;i:2626;i:1;i:2627;i:2;i:2629;}s:7:\"visible\";a:3:{i:0;i:2626;i:1;i:2627;i:2;i:2629;}s:7:\"version\";s:10:\"1730655240\";}", "off");
INSERT INTO `wp_options` VALUES("162827", "_transient_timeout_wc_var_prices_1703", "1754040403", "off");
INSERT INTO `wp_options` VALUES("162828", "_transient_wc_var_prices_1703", "{\"version\":\"1730655240\",\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"1707\":\"107000\",\"1708\":\"135000\",\"1709\":\"115000\",\"1710\":\"105000\",\"1711\":\"105000\"},\"regular_price\":{\"1707\":\"107000\",\"1708\":\"135000\",\"1709\":\"115000\",\"1710\":\"105000\",\"1711\":\"105000\"},\"sale_price\":{\"1707\":\"107000\",\"1708\":\"135000\",\"1709\":\"115000\",\"1710\":\"105000\",\"1711\":\"105000\"}},\"4173c8e28f114c545d779c47fd7e2df1\":{\"price\":{\"1707\":\"107000\",\"1708\":\"135000\",\"1709\":\"115000\",\"1710\":\"105000\",\"1711\":\"105000\"},\"regular_price\":{\"1707\":\"107000\",\"1708\":\"135000\",\"1709\":\"115000\",\"1710\":\"105000\",\"1711\":\"105000\"},\"sale_price\":{\"1707\":\"107000\",\"1708\":\"135000\",\"1709\":\"115000\",\"1710\":\"105000\",\"1711\":\"105000\"}}}", "off");
INSERT INTO `wp_options` VALUES("62383", "_transient_timeout_woocommerce_admin_remote_inbox_notifications_specs", "1754587710", "off");
INSERT INTO `wp_options` VALUES("62384", "_transient_woocommerce_admin_remote_inbox_notifications_specs", "a:55:{s:21:\"wayflyer_bnpl_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:21:\"wayflyer_bnpl_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:48:\"Grow your business with funding through Wayflyer\";s:7:\"content\";s:261:\"Fast, flexible financing to boost cash flow and help your business grow – one fee, no interest rates, penalties, equity, or personal guarantees. Based on your store’s performance, Wayflyer provides funding and analytical insights to invest in your business.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:21:\"wayflyer_bnpl_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Level up with funding\";}}s:3:\"url\";s:118:\"https://woocommerce.com/products/wayflyer/?utm_source=inbox_note&utm_medium=product&utm_campaign=wayflyer_bnpl_q4_2021\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-17 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-12-18 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:7:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AU\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"BE\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CA\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"IE\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NL\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"GB\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-affirm\";}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:32:\"afterpay-gateway-for-woocommerce\";}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:31:\"klarna-payments-for-woocommerce\";}}}}}}s:35:\"wc_shipping_mobile_app_usps_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:35:\"wc_shipping_mobile_app_usps_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:94:\"Print and manage your shipping labels with WooCommerce Shipping and the WooCommerce Mobile App\";s:7:\"content\";s:210:\"Save time by printing, purchasing, refunding, and tracking shipping labels generated by <a href=\"https://woocommerce.com/woocommerce-shipping/\">WooCommerce Shipping</a> – all directly from your mobile device!\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"wc_shipping_mobile_app_usps_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Get WooCommerce Shipping\";}}s:3:\"url\";s:135:\"https://woocommerce.com/woocommerce-shipping/?utm_source=inbox_note&utm_medium=product&utm_campaign=wc_shipping_mobile_app_usps_q4_2021\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-12 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-11-27 00:00:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:25:\"woocommerce-shipping-usps\";}}i:4;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}}}}}s:18:\"your-first-product\";O:8:\"stdClass\":8:{s:4:\"slug\";s:18:\"your-first-product\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:18:\"Your first product\";s:7:\"content\";s:467:\"That’s huge! You’re well on your way to building a successful online store — now it’s time to think about how you’ll fulfill your orders.<br/><br/>Read our shipping guide to learn best practices and options for putting together your shipping strategy. And for WooCommerce stores in the United States, you can print discounted shipping labels via USPS with <a href=\"https://href.li/?https://woocommerce.com/shipping\" target=\"_blank\">WooCommerce Shipping</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:130:\"https://woocommerce.com/posts/ecommerce-shipping-solutions-guide/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:19:13\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_were_no_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_are_now_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:2:\">=\";s:5:\"value\";i:1;}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:13:\"product_types\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"physical\";s:7:\"default\";a:0:{}}}}s:37:\"wc-admin-optimizing-the-checkout-flow\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"wc-admin-optimizing-the-checkout-flow\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:28:\"Optimizing the checkout flow\";s:7:\"content\";s:177:\"It’s crucial to get your store’s checkout as smooth as possible to avoid losing sales. Let’s take a look at how you can optimize the checkout experience for your shoppers.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:28:\"optimizing-the-checkout-flow\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:144:\"https://woocommerce.com/posts/optimizing-woocommerce-checkout?utm_source=inbox_note&utm_medium=product&utm_campaign=optimizing-the-checkout-flow\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:19:49\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"payments\";s:7:\"default\";a:0:{}}}}s:32:\"wc-payments-qualitative-feedback\";O:8:\"stdClass\":8:{s:4:\"slug\";s:32:\"wc-payments-qualitative-feedback\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:46:\"WooPayments setup - let us know what you think\";s:7:\"content\";s:137:\"Congrats on enabling WooPayments for your store. Please share your feedback in this 2 minute survey to help us improve the setup process.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"qualitative-feedback-from-new-users\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:58:\"https://automattic.survey.fm/woopayments-new-user-feedback\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:21:13\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:20:\"woocommerce-payments\";s:7:\"default\";a:0:{}}}}s:29:\"share-your-feedback-on-paypal\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"share-your-feedback-on-paypal\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:29:\"Share your feedback on PayPal\";s:7:\"content\";s:127:\"Share your feedback in this 2 minute survey about how we can make the process of accepting payments more useful for your store.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:43:\"http://automattic.survey.fm/paypal-feedback\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:21:50\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}}}s:31:\"google_listings_and_ads_install\";O:8:\"stdClass\":8:{s:4:\"slug\";s:31:\"google_listings_and_ads_install\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Drive traffic and sales with Google\";s:7:\"content\";s:123:\"Reach online shoppers to drive traffic and sales for your store by showcasing products across Google, for free or with ads.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"get-started\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Get started\";}}s:3:\"url\";s:122:\"https://woocommerce.com/products/google-listings-and-ads?utm_source=inbox_note&utm_medium=product&utm_campaign=get-started\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-06-09 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:23:\"google_listings_and_ads\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:10;}}}s:39:\"wc-subscriptions-security-update-3-0-15\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"wc-subscriptions-security-update-3-0-15\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:42:\"WooCommerce Subscriptions security update!\";s:7:\"content\";s:738:\"We recently released an important security update to WooCommerce Subscriptions. To ensure your site’s data is protected, please upgrade <strong>WooCommerce Subscriptions to version 3.0.15</strong> or later.<br/><br/>Click the button below to view and update to the latest Subscriptions version, or log in to <a href=\"https://woocommerce.com/my-dashboard\">WooCommerce.com Dashboard</a> and navigate to your <strong>Downloads</strong> page.<br/><br/>We recommend always using the latest version of WooCommerce Subscriptions, and other software running on your site, to ensure maximum security.<br/><br/>If you have any questions we are here to help — just <a href=\"https://woocommerce.com/my-account/create-a-ticket/\">open a ticket</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:30:\"update-wc-subscriptions-3-0-15\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"View latest version\";}}s:3:\"url\";s:30:\"&page=wc-addons&section=helper\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:30:32\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"woocommerce-subscriptions\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:6:\"3.0.15\";}}}s:29:\"woocommerce-core-update-5-4-0\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"woocommerce-core-update-5-4-0\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Update to WooCommerce 5.4.1 now\";s:7:\"content\";s:140:\"WooCommerce 5.4.1 addresses a checkout issue discovered in WooCommerce 5.4. We recommend upgrading to WooCommerce 5.4.1 as soon as possible.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:20:\"update-wc-core-5-4-0\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:25:\"How to update WooCommerce\";}}s:3:\"url\";s:64:\"https://docs.woocommerce.com/document/how-to-update-woocommerce/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:31:08\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.0\";}}}s:19:\"wcpay-promo-2020-11\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"wcpay-promo-2020-11\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-11\";s:7:\"content\";s:19:\"wcpay-promo-2020-11\";}}s:7:\"actions\";a:0:{}s:5:\"rules\";a:0:{}}s:19:\"wcpay-promo-2020-12\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"wcpay-promo-2020-12\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-12\";s:7:\"content\";s:19:\"wcpay-promo-2020-12\";}}s:7:\"actions\";a:0:{}s:5:\"rules\";a:0:{}}s:34:\"ppxo-pps-upgrade-paypal-payments-1\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-1\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Get the latest PayPal extension for WooCommerce\";s:7:\"content\";s:442:\"Heads up! There’s a new PayPal on the block!<br/><br/>Now is a great time to upgrade to our latest <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal extension</a> to continue to receive support and updates with PayPal.<br/><br/>Get access to a full suite of PayPal payment methods, extensive currency and country coverage, and pay later options with the all-new PayPal extension for WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-1\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:33:53\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:7;s:7:\"default\";i:1;s:9:\"operation\";s:1:\"<\";}}}s:34:\"ppxo-pps-upgrade-paypal-payments-2\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-2\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Upgrade your PayPal experience!\";s:7:\"content\";s:358:\"Get access to a full suite of PayPal payment methods, extensive currency and country coverage, offer subscription and recurring payments, and the new PayPal pay later options.<br /><br />Start using our <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">latest PayPal today</a> to continue to receive support and updates.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-2\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:34:30\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:6;s:7:\"default\";i:1;s:9:\"operation\";s:1:\">\";}}}s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:56:\"Action required: Critical vulnerabilities in WooCommerce\";s:7:\"content\";s:574:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br /><br />Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br /><br />For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:59:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:35:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.6\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.8\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.9\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.6\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.2\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.2\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.3\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.4\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.4\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.5\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.2\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.4\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.3\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.2\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.3\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.4\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.2\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.2\";}i:32;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.3\";}i:33;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.4\";}i:34;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:35;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:36;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.2\";}i:37;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.3\";}i:38;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}i:39;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"3.5.10\";}i:40;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.7\";}i:41;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.3\";}i:42;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.3\";}i:43;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.5\";}i:44;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.4\";}i:45;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.4\";}i:46;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.5\";}i:47;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.6\";}i:48;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.4\";}i:49;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.5\";}i:50;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.5\";}i:51;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.4\";}i:52;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.3\";}i:53;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.5\";}i:54;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.3\";}i:55;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.3\";}i:56;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.5\";}i:57;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.3\";}i:58;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.4\";}}}s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"Action required: Critical vulnerabilities in WooCommerce Blocks\";s:7:\"content\";s:570:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/>Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br/><br/>For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:32:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:35:42\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"2.5.16\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.6.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.7.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.8.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.9.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.0.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.1.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.2.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.1\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.1\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.2\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.1\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.1\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}}}s:45:\"woocommerce-core-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:45:\"woocommerce-core-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"Solved: Critical vulnerabilities patched in WooCommerce\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:36:18\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:23:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.6\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.8\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.9\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.6\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.2\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.4\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.2\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.1\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:62:\"Solved: Critical vulnerabilities patched in WooCommerce Blocks\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:36:54\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:31:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"2.5.16\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.6.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.7.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.8.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.9.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.0.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.1.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.2.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.1\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.1\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.2\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.2\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.1\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:19:\"habit-moment-survey\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"habit-moment-survey\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"We’re all ears! Share your experience so far with WooCommerce\";s:7:\"content\";s:136:\"We’d love your input to shape the future of WooCommerce together. Feel free to share any feedback, ideas or suggestions that you have.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:45:\"https://automattic.survey.fm/store-management\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:37:30\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:30;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:0;}}}s:42:\"woocommerce-core-paypal-march-2022-updated\";O:8:\"stdClass\":8:{s:4:\"slug\";s:42:\"woocommerce-core-paypal-march-2022-updated\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Security auto-update of WooCommerce\";s:7:\"content\";s:391:\"<strong>Your store has been updated to the latest secure version of WooCommerce</strong>. We worked with WordPress to deploy PayPal Standard security updates for stores running WooCommerce (version 3.5 to 6.3). It’s recommended to disable PayPal Standard, and use <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal Payments</a> to accept PayPal.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:88:\"https://developer.woocommerce.com/2022/03/10/woocommerce-3-5-10-6-3-1-security-releases/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:42:\"woocommerce-core-paypal-march-2022-dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-03-10 18:44:57\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:28:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"3.5.10\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.7\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.3\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.5\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.4\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.5\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.6\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.4\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.5\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.5\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.4\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.5\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.3\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.5\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.5.4\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.6.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.9.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.1.2\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.2.2\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:3:\"5.5\";}i:1;a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}}}}}}}s:47:\"woocommerce-core-paypal-march-2022-updated-nopp\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-core-paypal-march-2022-updated-nopp\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Security auto-update of WooCommerce\";s:7:\"content\";s:237:\"<strong>Your store has been updated to the latest secure version of WooCommerce</strong>. We worked with WordPress to deploy security updates related to PayPal Standard payment gateway for stores running WooCommerce (version 3.5 to 6.3).\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:88:\"https://developer.woocommerce.com/2022/03/10/woocommerce-3-5-10-6-3-1-security-releases/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-03-10 18:45:04\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:28:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"3.5.10\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.7\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.3\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.5\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.4\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.5\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.6\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.4\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.5\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.5\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.4\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.5\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.3\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.5\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.5.4\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.6.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.9.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.1.2\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.2.2\";}}}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:42:\"woocommerce-core-paypal-march-2022-updated\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}s:24:\"pinterest_03_2022_update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:24:\"pinterest_03_2022_update\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:53:\"Your Pinterest for WooCommerce plugin is out of date!\";s:7:\"content\";s:262:\"Update to the latest version of Pinterest for WooCommerce to continue using this plugin and keep your store connected with Pinterest. To update, visit <strong>Plugins &gt; Installed Plugins</strong>, and click on “update now” under Pinterest for WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:24:\"pinterest_03_2022_update\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"Update Instructions\";}}s:3:\"url\";s:148:\"https://woocommerce.com/document/pinterest-for-woocommerce/?utm_source=inbox_note&utm_medium=product&utm_campaign=pinterest_03_2022_update#section-3\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-03-23 00:00:39\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"pinterest-for-woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"1.0.8\";}}}s:33:\"store_setup_survey_survey_q2_2022\";O:8:\"stdClass\":8:{s:4:\"slug\";s:33:\"store_setup_survey_survey_q2_2022\";s:4:\"type\";s:6:\"survey\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:30:\"How is your store setup going?\";s:7:\"content\";s:232:\"Our goal is to make sure you have all the right tools to start setting up your store in the smoothest way possible.\r\nWe’d love to know if we hit our mark and how we can improve. To collect your thoughts, we made a 2-minute survey.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:53:\"store_setup_survey_survey_q2_2022_share_your_thoughts\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Tell us how it’s going\";}}s:3:\"url\";s:52:\"https://automattic.survey.fm/store-setup-survey-2022\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-05-09 08:42:10\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:7;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:9;}}}s:48:\"needs-update-eway-payment-gateway-rin-2022-12-20\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"needs-update-eway-payment-gateway-rin-2022-12-20\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:58:\"Security vulnerability patched in WooCommerce Eway Gateway\";s:7:\"content\";s:323:\"In response to a potential vulnerability identified in WooCommerce Eway Gateway versions 3.1.0 to 3.5.0, we’ve worked to deploy security fixes and have released an updated version.\r\nNo external exploits have been detected, but we recommend you update to your latest supported version 3.1.26, 3.2.3, 3.3.1, 3.4.6, or 3.5.1\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:62:\"needs-update-eway-payment-gateway-rin-action-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:16:\"/update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:63:\"needs-update-eway-payment-gateway-rin-dismiss-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:7:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-03 23:45:53\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"3.1.26\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.2.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.6\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"3.5.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"3.1.0\";}}}s:43:\"updated-eway-payment-gateway-rin-2022-12-20\";O:8:\"stdClass\":8:{s:4:\"slug\";s:43:\"updated-eway-payment-gateway-rin-2022-12-20\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"WooCommerce Eway Gateway has been automatically updated\";s:7:\"content\";s:280:\"Your store is now running the latest secure version of WooCommerce Eway Gateway. We worked with the WordPress Plugins team to deploy a software update to stores running WooCommerce Eway Gateway (versions 3.1.0 to 3.5.0) in response to a security vulnerability that was discovered.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:57:\"updated-eway-payment-gateway-rin-action-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"See all updates\";}}s:3:\"url\";s:16:\"/update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:58:\"updated-eway-payment-gateway-rin-dismiss-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-03 23:45:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"needs-update-eway-payment-gateway-rin-2022-12-20\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:5:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"3.1.26\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.2.3\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.1\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.6\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.1\";}}}}}s:31:\"ecomm-wc-navigation-survey-2023\";O:8:\"stdClass\":8:{s:4:\"slug\";s:31:\"ecomm-wc-navigation-survey-2023\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:39:\"Navigating WooCommerce on WordPress.com\";s:7:\"content\";s:166:\"We are improving the WooCommerce navigation on WordPress.com and would love your help to make it better! Please share your experience with us in this 2-minute survey.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:32:\"share-navigation-survey-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:58:\"https://automattic.survey.fm/new-ecommerce-plan-navigation\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-01-16 09:53:44\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:12:\"is_ecommerce\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:180;}}}s:39:\"woopay-beta-merchantrecruitment-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"woopay-beta-merchantrecruitment-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:319:\"WooPay, a new express checkout feature built into WooCommerce Payments, is <b>now available</b> —and we’re inviting you to be one of the first to try it. \r\n<br><br>\r\n<b>Boost conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\r\n<br><br>\r\n<b>Get started in seconds.</b>\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:48:\"woopay-beta-merchantrecruitment-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:58:\"woopay-beta-merchantrecruitment-activate-learnmore-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:155:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-activate-learnmore-04MAY23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:27\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"http://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.handinhandparenting.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://pritikinfoods.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://utahrecsports.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.hunterpta.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.smokinbeans.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://shulabeauty.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://bingeworthytvmerch.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://s91.4d8.myftpupload.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://stephanienicolenorris.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://aliensshirt.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://libertyordeathapparelllc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://cowboystatedaily.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:42:\"https://fundrgear.com/beckendorffathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:50:\"http://wordpress-528155-2231771.cloudwaysapps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://checkout.sohaprice.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://amadozstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://eliwehbe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://lunabra.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://nptixx.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://louisianapantry.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://aplusanatomy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://wildsvg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://bleachfilm.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://benabeautyspa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:47:\"http://barrettfitnessenterprises.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://goabroadable.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://alexoathletica.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.fourpurls.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.hagmannreport.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://busybeeorganics.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nallsproduce.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://bigtimebats.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://shop.cookingwithkarli.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.queenofpeacemedia.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://bigjohnsbeefjerky.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://paperbyjaney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://carolinarisemembers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://veroticaevents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://spira.farm\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://endlessassist.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://betterlifeblog.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://ashleighrenard.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.turkeymerck.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://carfiershop.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://normanmusicfestival.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"http://www.olfactoryfactoryllc.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://fundrgear.com/anthonyathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"http://tkechilifestdotcom.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:49;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:15:\"No results foun\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:50;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://pvsa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:51;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://becbatop.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:52;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wwmeconvention.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:53;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://lswmp.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:54;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bubbaskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:55;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://fusango.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:56;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://vcdpostershow.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:57;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.rileysribz.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:58;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.fakeultrasound.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:59;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://onelongfellowsquare.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:60;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://agodpod.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:61;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/littleladybulldogs\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:62;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://thecirclelarp.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:63;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://byletam.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:64;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.nachonite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:65;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://designerdab.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:66;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2151.temp.domains/~lovebyt2/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:67;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://shortporchbaseballcompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:68;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://distancecme.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:69;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://middleswarthchips.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:70;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://railblazausa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:71;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://mikescountrymeats.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:72;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://www.woodenshoe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:73;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://rockspringscafe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:74;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"http://footballfangears.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:75;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://ybtoner.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:76;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://simplyclayyy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:77;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://naturecreation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:78;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://marisrodriguez.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:79;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://asanteinternational.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:80;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://theatre55.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:81;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://carolynscreativeclassroom.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:82;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://www.miiriya.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:83;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://trendyds.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:84;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wooedbythefood.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:85;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://papasteamstores.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:86;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://omdurags.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:87;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://happydogbarkery.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:88;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://kitbose.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:89;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://seamossdeals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:90;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://zeatala.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:91;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://shop.atwaterffa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:92;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://www.brettsfirstresponders.org/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:93;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://shirtactive.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:94;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://boerneparade.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:95;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://zorahshrine.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:96;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://davidcervenka.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:97;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://addisjourney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:98;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://305ycle.cc\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:99;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"http://yourworstnightmarehaunt.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:100;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://westcoastpreps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:101;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://checkout.sohaking.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:102;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://www.theunshakeablepundit.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:103;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.stellaandchewys.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:104;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://www.raywhitcomb.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:105;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:39:\"http://constellationtheatercompany.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:106;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://stacynguyen.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:107;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:46:\"https://fundrgear.com/lakecreekgirlsbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:108;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://winslowartcenter.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:109;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://flufftastik.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:110;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mygreenbeach.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:111;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://ebookvip.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:112;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://fundrgear.com/needvillevolleyball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:113;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bifocalmedia.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:114;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://clrc.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:115;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://hyperpins.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:116;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/lakecreekboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:117;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://fundrgear.com/kparktennis\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:118;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mogadorspices.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:119;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://fundrgear.com/newcaneytrack\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:120;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://sigmascents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:121;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://bsharisemoore.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:122;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://morrflate.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:123;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://westbrosinc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:124;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://shop.danceplexaz.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:125;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://chikepod.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:126;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.advanahealth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:127;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://tatter.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:128;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://greatawakeningbrewing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:129;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://waterfowlfestival.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:130;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://preppedwellness.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:131;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://events.thus.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:132;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://stormtide.thefifthtrooper.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:133;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://www.tabsynth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:134;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"http://staging.fliptheswitchon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:135;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://duffysdough.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:136;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://fitfoodieliving.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:137;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://breakerbrotherstcg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:138;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://andymation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:139;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://recklessmetals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:140;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://sophielark.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:141;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://wp.arabtherapy.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:142;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://creativeappliques.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:143;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://altitude.win\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:42:\"woocommerce-wcpay-march-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:42:\"woocommerce-wcpay-march-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:57:\"Action required: Security update for WooCommerce Payments\";s:7:\"content\";s:296:\"<strong>Your store requires a security update for WooCommerce Payments</strong>. Please update to the latest version of WooCommerce Payments immediately to address a potential vulnerability discovered on March 22. For more information on how to update, visit this WooCommerce Developer Blog Post.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:49:\"woocommerce-wcpay-march-2023-update-needed-button\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"See Blog Post\";}}s:3:\"url\";s:122:\"https://developer.woocommerce.com/2023/03/23/critical-vulnerability-detected-in-woocommerce-payments-what-you-need-to-know\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:57:\"woocommerce-wcpay-march-2023-update-needed-dismiss-button\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:11:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-03-22 20:25:44\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.1\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.4\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.3\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.5.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"4.8.0\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"5.6.1\";}}}s:34:\"tap_to_pay_iphone_q2_2023_no_wcpay\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"tap_to_pay_iphone_q2_2023_no_wcpay\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:52:\"Accept in-person contactless payments on your iPhone\";s:7:\"content\";s:230:\"Tap to Pay on iPhone and WooCommerce Payments is quick, secure, and simple to set up — no extra terminals or card readers are needed. Accept contactless debit and credit cards, Apple Pay, and other NFC digital wallets in person.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"tap_to_pay_iphone_q2_2023_no_wcpay\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:20:\"Simplify my payments\";}}s:3:\"url\";s:143:\"https://woocommerce.com/products/woocommerce-payments/?utm_source=inbox_note&utm_medium=product&utm_campaign=tap_to_pay_iphone_q2_2023_no_wcpay\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-03 23:59:47\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}s:48:\"woocommerce-WCPreOrders-april-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-WCPreOrders-april-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:68:\"Action required: Security update of WooCommerce Pre-Orders extension\";s:7:\"content\";s:220:\"<strong>Your store requires a security update for the WooCommerce Pre-Orders extension</strong>. Please update the WooCommerce Pre-Orders extension immediately to address a potential vulnerability discovered on April 11.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:18:\"extension-settings\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:15:\"update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-12 22:16:37\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:22:\"woocommerce-pre-orders\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"2.0.0\";}}}s:46:\"woopay-beta-merchantrecruitment-update-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woopay-beta-merchantrecruitment-update-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:321:\"WooPay, a new express checkout feature built into WooCommerce Payments, is <b>now available</b> — and you’re invited to try it. \r\n<br /><br />\r\n<b>Boost conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\r\n<br /><br />\r\n<b>Update WooCommerce Payments</b> to get started.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:52:\"woopay-beta-merchantrecruitment-update-WCPay-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Update WooCommerce Payments\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:55:\"woopay-beta-merchantrecruitment-update-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"http://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.handinhandparenting.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://pritikinfoods.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://utahrecsports.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.hunterpta.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.smokinbeans.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://shulabeauty.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://bingeworthytvmerch.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://s91.4d8.myftpupload.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://stephanienicolenorris.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://aliensshirt.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://libertyordeathapparelllc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://cowboystatedaily.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:42:\"https://fundrgear.com/beckendorffathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:50:\"http://wordpress-528155-2231771.cloudwaysapps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://checkout.sohaprice.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://amadozstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://eliwehbe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://lunabra.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://nptixx.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://louisianapantry.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://aplusanatomy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://wildsvg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://bleachfilm.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://benabeautyspa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:47:\"http://barrettfitnessenterprises.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://goabroadable.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://alexoathletica.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.fourpurls.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.hagmannreport.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://busybeeorganics.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nallsproduce.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://bigtimebats.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://shop.cookingwithkarli.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.queenofpeacemedia.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://bigjohnsbeefjerky.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://paperbyjaney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://carolinarisemembers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://veroticaevents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://spira.farm\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://endlessassist.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://betterlifeblog.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://ashleighrenard.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.turkeymerck.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://carfiershop.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://normanmusicfestival.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"http://www.olfactoryfactoryllc.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://fundrgear.com/anthonyathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"http://tkechilifestdotcom.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:49;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:15:\"No results foun\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:50;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://pvsa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:51;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://becbatop.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:52;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wwmeconvention.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:53;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://lswmp.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:54;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bubbaskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:55;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://fusango.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:56;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://vcdpostershow.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:57;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.rileysribz.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:58;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.fakeultrasound.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:59;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://onelongfellowsquare.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:60;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://agodpod.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:61;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/littleladybulldogs\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:62;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://thecirclelarp.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:63;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://byletam.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:64;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.nachonite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:65;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://designerdab.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:66;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2151.temp.domains/~lovebyt2/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:67;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://shortporchbaseballcompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:68;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://distancecme.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:69;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://middleswarthchips.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:70;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://railblazausa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:71;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://mikescountrymeats.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:72;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://www.woodenshoe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:73;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://rockspringscafe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:74;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"http://footballfangears.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:75;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://ybtoner.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:76;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://simplyclayyy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:77;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://naturecreation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:78;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://marisrodriguez.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:79;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://asanteinternational.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:80;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://theatre55.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:81;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://carolynscreativeclassroom.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:82;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://www.miiriya.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:83;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://trendyds.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:84;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wooedbythefood.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:85;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://papasteamstores.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:86;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://omdurags.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:87;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://happydogbarkery.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:88;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://kitbose.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:89;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://seamossdeals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:90;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://zeatala.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:91;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://shop.atwaterffa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:92;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://www.brettsfirstresponders.org/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:93;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://shirtactive.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:94;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://boerneparade.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:95;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://zorahshrine.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:96;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://davidcervenka.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:97;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://addisjourney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:98;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://305ycle.cc\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:99;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"http://yourworstnightmarehaunt.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:100;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://westcoastpreps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:101;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://checkout.sohaking.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:102;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://www.theunshakeablepundit.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:103;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.stellaandchewys.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:104;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://www.raywhitcomb.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:105;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:39:\"http://constellationtheatercompany.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:106;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://stacynguyen.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:107;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:46:\"https://fundrgear.com/lakecreekgirlsbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:108;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://winslowartcenter.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:109;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://flufftastik.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:110;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mygreenbeach.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:111;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://ebookvip.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:112;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://fundrgear.com/needvillevolleyball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:113;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bifocalmedia.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:114;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://clrc.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:115;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://hyperpins.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:116;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/lakecreekboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:117;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://fundrgear.com/kparktennis\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:118;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mogadorspices.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:119;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://fundrgear.com/newcaneytrack\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:120;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://sigmascents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:121;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://bsharisemoore.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:122;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://morrflate.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:123;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://westbrosinc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:124;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://shop.danceplexaz.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:125;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://chikepod.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:126;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.advanahealth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:127;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://tatter.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:128;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://greatawakeningbrewing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:129;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://waterfowlfestival.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:130;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://preppedwellness.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:131;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://events.thus.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:132;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://stormtide.thefifthtrooper.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:133;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://www.tabsynth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:134;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"http://staging.fliptheswitchon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:135;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://duffysdough.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:136;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://fitfoodieliving.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:137;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://breakerbrotherstcg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:138;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://andymation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:139;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://recklessmetals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:140;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://sophielark.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:141;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://wp.arabtherapy.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:142;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://creativeappliques.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:143;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://altitude.win\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:46:\"woopay-beta-existingmerchants-noaction-27APR23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woopay-beta-existingmerchants-noaction-27APR23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:15:\"WooPay is back!\";s:7:\"content\";s:361:\"Thanks for previously trying WooPay, the<b> express checkout feature</b> built into WooCommerce Payments. We’re excited to announce that <b>WooPay availability has resumed</b>. No action is required on your part.\r\n<br /><br />\r\nYou can now <b>continue boosting conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woopay-beta-existingmerchants-noaction-documentation-27APR23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"Documentation\";}}s:3:\"url\";s:178:\"https://woocommerce.com/document/woopay-merchant-documentation/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-existingmerchants-noaction-documentation-27APR23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-26 19:00:23\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.0\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:38:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://store.startingstrongman.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://joacreativelab.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.pureskincaresalon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mariablaquier.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://getprodigital.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://dalefrickeholsters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://sstour.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://tk-txstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://humanspiritproject.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://viradadrums.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://rosariumblends.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://organicskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://stuckpigmedical.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.seattlegiftbasket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.cloverandviolet.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://gvscholarship.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://yesimadiva.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://www.old.jmtrashbgone.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://victorialansford.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://craftcosplay.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://thefossilexchange.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nextgenspeed.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://cappellarecords.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://ontimesupermarket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://new2knox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://lovestudiollc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://thehivelivebox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://socceruniformkits.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://willowcreativ.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://summitprep.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://howda.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://soapavenuecompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://subsbox.mystagingwebsite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wifflebreakers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.mps-outfitters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://howardharrisassociates.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://bettersaferadio.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://bunnyluna.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:44:\"woopay-beta-existingmerchants-update-27APR23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:44:\"woopay-beta-existingmerchants-update-27APR23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:15:\"WooPay is back!\";s:7:\"content\";s:368:\"Thanks for previously trying WooPay, the <b>express checkout feature</b> built into WooCommerce Payments. We’re excited to announce that <b>WooPay availability has resumed</b>.\r\n<br /><br />\r\n\r\nUpdate to the latest WooCommerce Payments version to <b>continue boosting conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:50:\"woopay-beta-existingmerchants-update-WCPay-27APR23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Update WooCommerce Payments\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-26 19:00:08\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.8.0\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:38:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://store.startingstrongman.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://joacreativelab.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.pureskincaresalon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mariablaquier.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://getprodigital.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://dalefrickeholsters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://sstour.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://tk-txstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://humanspiritproject.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://viradadrums.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://rosariumblends.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://organicskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://stuckpigmedical.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.seattlegiftbasket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.cloverandviolet.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://gvscholarship.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://yesimadiva.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://www.old.jmtrashbgone.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://victorialansford.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://craftcosplay.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://thefossilexchange.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nextgenspeed.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://cappellarecords.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://ontimesupermarket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://new2knox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://lovestudiollc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://thehivelivebox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://socceruniformkits.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://willowcreativ.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://summitprep.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://howda.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://soapavenuecompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://subsbox.mystagingwebsite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wifflebreakers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.mps-outfitters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://howardharrisassociates.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://bettersaferadio.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://bunnyluna.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:45:\"woopay-beta-merchantrecruitment-short-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:45:\"woopay-beta-merchantrecruitment-short-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:54:\"woopay-beta-merchantrecruitment-short-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:64:\"woopay-beta-merchantrecruitment-short-activate-learnmore-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:161:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-04MAY23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:36\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://pieroatomic3.wpcomstaging.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.bluebeautifly.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"http://indianrivernatural.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://fouroaksproducts.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:14:\"https://acb.la\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://www.sweetpotatoplant.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"http://www.gocaseyourself.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://laugun.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://nebraskadaybyday.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://vintagemarche727.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://kohai.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://gracegaze.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://aliensmeaning.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://myheritagegardens.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://shopmoresport.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://oladino.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://frogjumpstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://cagedthundermma.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/mcelwainelementary\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://mgco.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://500gp.io/pay\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://waterglassslimes.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://antiqueful.shop/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://deeperkidmin.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/cyspringsboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://houseofminifigs.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2273.temp.domains/~dreambx2/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://madebymixture.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://reliabletrash.company\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://www.daddybutter.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://circleqessentials.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://garlicbraids.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://fbdonline.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://galaxysedge.us\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://duckduckbeetfarm.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://varsitygraphics.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://jademackenzie.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://kristysketolifestyle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://covid19criticalcare.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://parkviewprep.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://rock-fest.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"http://fillinxsolutions.com/etarix/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://doughremitx.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.montanafiddlecamp.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://fococomiccon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://patricendouglas.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://hectue.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://montanamaxbbq.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://smellzoom.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:49;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://uptowne.theoandson.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:50;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://superbasic.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:51;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://ppodstore.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:52;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://kerenzan.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:53;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://a13bargains.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:54;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://colorgr.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:55;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://mindbodysoulcandles.com/Charlotte\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:56;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://peaceloveandadhd.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:57;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://seymoursmash.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:58;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mwtournament.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:59;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:43:\"https://fundrgear.com/beckendorffgirlstrack\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:60;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:15:\"No results foun\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:61;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://allswellnyc.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:62;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://childoftheredwoodsmembers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:63;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://fundrgear.com/grandoaksvolleyball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:64;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.newhollandrochester.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:65;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.purplecatvet.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:66;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:39:\"https://www.mustangmountaincoaster.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:67;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://www.roccanj.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:68;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://www.teerico.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:69;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://passportunlimited.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:70;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.paladincards20.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:71;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://giantshorties.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:72;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://visualsports.biz\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:73;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://thefreakinricanrestaurant.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:74;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://arequestionscom.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:75;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://pt.tktxcompanystore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:76;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://fitfoodiechicks.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:77;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://nutoshop.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:78;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://backwoodzhiphop.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:79;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://gartapparel.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:80;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://bodega.badiaspices.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:81;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://rampartrange.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:82;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://teeuni.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:83;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://bearsinthealley.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:84;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://vitalbooks.net/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:85;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://hair-free-hair-remover.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:86;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://gangtaynails.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:87;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://crochetfoundry.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:88;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://westcoastbelts.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:89;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://payment.sundryfiles.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:90;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://ccadunkirk.mudhenmama.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:91;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://desertsupercup.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:92;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://shops-eminem.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:93;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://75yearsofracing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:94;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://tixpls.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:95;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:44:\"http://legacyoutfitters.org/banquet/raffles/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:96;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://91170e9fc9.nxcli.io/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:97;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://beachwayrentals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:98;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://thehivelivebox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:99;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://esd.camp\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:100;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mfkgamecalls.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:101;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://1greatce.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:102;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.luthyouth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:103;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://electionintegrityidaho.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:104;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://renbundle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:105;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://premierseamoss.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:106;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://teemart.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:107;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/beckendorffgirlsbb\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:108;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://visiblechild.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:109;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://ebookvital.me/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:110;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://renemarsh.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:111;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://www.eventricate.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:112;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://transgression.party\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:113;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://profadex.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:114;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://mxsbattlegrounds.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:115;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.poeinbaltimore.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:116;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://freefall.gg\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:117;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://underthechurchhatblog.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:118;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://naksparkle.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:119;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"http://bearlyburly.gay/inventory\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:120;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.premierboneandjoint.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:121;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://farm-2-bowl.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:122;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://hollandgrill.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:123;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://lividian.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:124;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.trainingrange.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:125;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://sarakepskitchen.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:126;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.phoenixyouththeatre.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:127;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://drivenarmsco.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:128;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://audiobro.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:129;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://www.iowaabortionaccessfund.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:130;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://findthemenu.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:131;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://moderndepot.co\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:132;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://granitesupplements.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:133;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://healthyrican.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:134;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://utest.edsandbox.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:135;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://c-pounds.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:136;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://littleschoolofsmiths.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:137;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://goblinstyle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:138;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://proper-testing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:139;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.cosafoundation.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:140;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://farmsteadboxes.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:141;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://fundraise4books.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:142;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://norskenook.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:143;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://cajulove.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:52:\"woopay-beta-merchantrecruitment-short-update-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:52:\"woopay-beta-merchantrecruitment-short-update-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:227:\"Be one of the first to try WooPay, our new express checkout feature. <br><b>Boost conversions</b> by letting customers pay with a <b>single click</b>. <br><br>Update to the latest version of WooCommerce Payments to get started.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:58:\"woopay-beta-merchantrecruitment-short-update-WCPay-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Update WooCommerce Payments\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:61:\"woopay-beta-merchantrecruitment-short-update-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:20\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"http://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.bluebeautifly.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"http://indianrivernatural.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://fouroaksproducts.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:14:\"https://acb.la\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://www.sweetpotatoplant.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"http://www.gocaseyourself.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://laugun.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://nebraskadaybyday.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://vintagemarche727.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://kohai.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://gracegaze.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://aliensmeaning.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://myheritagegardens.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://shopmoresport.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://oladino.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://frogjumpstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://cagedthundermma.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/mcelwainelementary\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://mgco.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://500gp.io/pay\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://waterglassslimes.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://antiqueful.shop/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://deeperkidmin.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/cyspringsboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://houseofminifigs.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2273.temp.domains/~dreambx2/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://madebymixture.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://reliabletrash.company\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://www.daddybutter.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://circleqessentials.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://garlicbraids.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://fbdonline.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://galaxysedge.us\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://duckduckbeetfarm.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://varsitygraphics.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://jademackenzie.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://kristysketolifestyle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://covid19criticalcare.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://parkviewprep.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://rock-fest.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"http://fillinxsolutions.com/etarix/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://doughremitx.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.montanafiddlecamp.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://fococomiccon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://patricendouglas.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://hectue.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://montanamaxbbq.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://smellzoom.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:49;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://uptowne.theoandson.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:50;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://superbasic.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:51;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://ppodstore.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:52;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://kerenzan.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:53;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://a13bargains.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:54;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://colorgr.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:55;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://mindbodysoulcandles.com/Charlotte\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:56;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://peaceloveandadhd.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:57;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://seymoursmash.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:58;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mwtournament.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:59;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:43:\"https://fundrgear.com/beckendorffgirlstrack\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:60;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:15:\"No results foun\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:61;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://allswellnyc.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:62;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://childoftheredwoodsmembers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:63;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://fundrgear.com/grandoaksvolleyball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:64;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.newhollandrochester.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:65;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.purplecatvet.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:66;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:39:\"https://www.mustangmountaincoaster.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:67;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://www.roccanj.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:68;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://www.teerico.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:69;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://passportunlimited.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:70;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.paladincards20.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:71;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://giantshorties.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:72;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://visualsports.biz\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:73;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://thefreakinricanrestaurant.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:74;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://arequestionscom.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:75;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://pt.tktxcompanystore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:76;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://fitfoodiechicks.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:77;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://nutoshop.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:78;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://backwoodzhiphop.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:79;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://gartapparel.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:80;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://bodega.badiaspices.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:81;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://rampartrange.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:82;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://teeuni.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:83;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://bearsinthealley.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:84;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://vitalbooks.net/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:85;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://hair-free-hair-remover.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:86;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://gangtaynails.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:87;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://crochetfoundry.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:88;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://westcoastbelts.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:89;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://payment.sundryfiles.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:90;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://ccadunkirk.mudhenmama.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:91;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://desertsupercup.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:92;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://shops-eminem.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:93;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://75yearsofracing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:94;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://tixpls.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:95;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:44:\"http://legacyoutfitters.org/banquet/raffles/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:96;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://91170e9fc9.nxcli.io/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:97;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://beachwayrentals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:98;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://thehivelivebox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:99;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://esd.camp\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:100;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mfkgamecalls.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:101;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://1greatce.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:102;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.luthyouth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:103;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://electionintegrityidaho.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:104;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://renbundle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:105;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://premierseamoss.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:106;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://teemart.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:107;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/beckendorffgirlsbb\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:108;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://visiblechild.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:109;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://ebookvital.me/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:110;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://renemarsh.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:111;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://www.eventricate.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:112;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://transgression.party\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:113;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://profadex.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:114;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://mxsbattlegrounds.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:115;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.poeinbaltimore.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:116;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://freefall.gg\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:117;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://underthechurchhatblog.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:118;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://naksparkle.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:119;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"http://bearlyburly.gay/inventory\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:120;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.premierboneandjoint.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:121;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://farm-2-bowl.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:122;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://hollandgrill.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:123;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://lividian.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:124;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.trainingrange.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:125;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://sarakepskitchen.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:126;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.phoenixyouththeatre.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:127;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://drivenarmsco.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:128;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://audiobro.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:129;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://www.iowaabortionaccessfund.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:130;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://findthemenu.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:131;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://moderndepot.co\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:132;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://granitesupplements.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:133;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://healthyrican.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:134;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://utest.edsandbox.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:135;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://c-pounds.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:136;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://littleschoolofsmiths.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:137;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://goblinstyle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:138;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://proper-testing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:139;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.cosafoundation.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:140;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://farmsteadboxes.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:141;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://fundraise4books.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:142;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://norskenook.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:143;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://cajulove.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTA\";O:8:\"stdClass\":8:{s:4:\"slug\";s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTA\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woopay-beta-merchantrecruitment-short-activate-06MAY23-TESTA\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:22:\"Activate WooPay Test A\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:70:\"woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTA\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:167:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTA\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-05 00:01:32\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTB\";O:8:\"stdClass\":8:{s:4:\"slug\";s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTB\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woopay-beta-merchantrecruitment-short-activate-06MAY23-TESTB\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:22:\"Activate WooPay Test B\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:70:\"woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTA\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:167:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTA\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-05 20:58:43\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"http://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTC\";O:8:\"stdClass\":8:{s:4:\"slug\";s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTC\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woopay-beta-merchantrecruitment-short-activate-06MAY23-TESTC\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:22:\"Activate WooPay Test C\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:70:\"woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTC\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:167:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTC\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-05 21:03:33\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://pieroatomic3.wpcomstaging.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTD\";O:8:\"stdClass\":8:{s:4:\"slug\";s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTD\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woopay-beta-merchantrecruitment-short-activate-06MAY23-TESTD\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:22:\"Activate WooPay Test D\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:70:\"woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTD\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:167:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTD\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-05 21:32:09\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://pieroatomic3.wpcomstaging.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}s:45:\"woopay-beta-merchantrecruitment-short-09MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:45:\"woopay-beta-merchantrecruitment-short-09MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:61:\"woopay-beta-merchantrecruitment-short-activate-button-09MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:72:\"woopay-beta-merchantrecruitment-short-activate-learnmore-button2-09MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:169:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-button2-09MAY23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-08 19:18:44\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:17:\"platform_checkout\";}}}s:11:\"option_name\";s:41:\"woocommerce_woocommerce_payments_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"no\";s:7:\"default\";b:0;}i:3;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:31:\"data.platform_checkout_eligible\";}}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;s:7:\"default\";b:0;}}}s:52:\"woopay-beta-merchantrecruitment-short-update-09MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:52:\"woopay-beta-merchantrecruitment-short-update-09MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:227:\"Be one of the first to try WooPay, our new express checkout feature. <br><b>Boost conversions</b> by letting customers pay with a <b>single click</b>. <br><br>Update to the latest version of WooCommerce Payments to get started.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:58:\"woopay-beta-merchantrecruitment-short-update-WCPay-09MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Update WooCommerce Payments\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:61:\"woopay-beta-merchantrecruitment-short-update-activate-09MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-08 19:45:57\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:17:\"platform_checkout\";}}}s:11:\"option_name\";s:41:\"woocommerce_woocommerce_payments_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"no\";s:7:\"default\";b:0;}i:3;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:31:\"data.platform_checkout_eligible\";}}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;s:7:\"default\";b:0;}}}s:52:\"woocommerce-WCSubscriptions-June-2023-updated-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:52:\"woocommerce-WCSubscriptions-June-2023-updated-needed\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Action required: Security update of WooCommerce Subscriptions\";s:7:\"content\";s:197:\"<strong>Your store requires a security update for the WooCommerce Subscriptions plugin</strong>. Please update the WooCommerce Subscriptions plugin immediately to address a potential vulnerability.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:68:\"woocommerce-WCSubscriptions-June-2023-updated-needed-Plugin-Settings\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woocommerce-WCSubscriptions-June-2023-updated-needed-dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-06-06 08:00:08\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"woocommerce-subscriptions\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"2.1.0\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"woocommerce-subscriptions\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"5.1.2\";}}}s:54:\"woocommerce-WCReturnsWarranty-June-2023-updated-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:54:\"woocommerce-WCReturnsWarranty-June-2023-updated-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:87:\"Action required: Security update of WooCommerce Returns and Warranty Requests extension\";s:7:\"content\";s:270:\"<strong>Your store requires a security update for the Returns and Warranty Requests extension</strong>.  Please update to the latest version of the WooCommerce Returns and Warranty Requests extension immediately to address a potential vulnerability discovered on May 31.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:54:\"woocommerce-WCReturnsWarranty-June-2023-updated-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:54:\"woocommerce-WCReturnsWarranty-June-2023-updated-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-06-02 23:53:57\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-warranty\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"2.1.8\";}}}s:42:\"woocommerce-WCOPC-June-2023-updated-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:42:\"woocommerce-WCOPC-June-2023-updated-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:65:\"Action required: Security update of WooCommerce One Page Checkout\";s:7:\"content\";s:232:\"<strong>Your shop requires a security update to address a vulnerability in the WooCommerce One Page Checkout extension</strong>. The fix for this vulnerability was released for this extension on June 13th. Please update immediately.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:42:\"woocommerce-WCOPC-June-2023-updated-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:42:\"woocommerce-WCOPC-June-2023-updated-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-06-21 14:05:46\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:29:\"woocommerce-one-page-checkout\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"2.4.0\";}}}s:40:\"woocommerce-WCGC-July-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:40:\"woocommerce-WCGC-July-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:68:\"Action required: Security update of WooCommerce GoCardless Extension\";s:7:\"content\";s:205:\"<strong>Your shop requires a security update to address a vulnerability in the WooCommerce GoCardless extension</strong>. The fix for this vulnerability was released on July 4th. Please update immediately.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:40:\"woocommerce-WCGC-July-2023-update-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:40:\"woocommerce-WCGC-July-2023-update-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-07-04 15:36:07\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:30:\"woocommerce-gateway-gocardless\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"2.5.6\";}}}s:48:\"woocommerce-shipping-fedex-api-outage-2023-07-16\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-shipping-fedex-api-outage-2023-07-16\";s:4:\"type\";s:7:\"warning\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:40:\"Scheduled FedEx API outage — July 2023\";s:7:\"content\";s:277:\"On July 16 there will be a full outage of the FedEx API from 04:00 to 08:00 AM UTC. Due to planned maintenance by FedEx, you\'ll be unable to provide FedEx shipping rates during this time. Follow the link below for more information and recommendations on how to minimize impact.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:125:\"https://woocommerce.com/document/fedex/?utm_medium=product&utm_source=inbox_note&utm_campaign=learn-more#july-2023-api-outage\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-07-05 18:19:17\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-shipping-fedex\";}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2023-07-17 00:00:00\";}}}s:35:\"wcship-2023-07-hazmat-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:35:\"wcship-2023-07-hazmat-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:87:\"Action required: USPS HAZMAT compliance update for WooCommerce Shipping & Tax extension\";s:7:\"content\";s:251:\"<strong>Your store requires an update for the WooCommerce Shipping extension</strong>. Please update to the latest version of the WooCommerce Shipping &amp; Tax extension immediately to ensure compliance with new USPS HAZMAT rules currently in effect.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"plugin-list\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:23:\"admin.php?page=wc-admin\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-07-11 20:26:59\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-services\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"2.3.0\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}s:43:\"woocommerce-WCStripe-Aug-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:43:\"woocommerce-WCStripe-Aug-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:62:\"Action required: Security update for WooCommerce Stripe plugin\";s:7:\"content\";s:183:\"<strong>Your shop requires an important security update for the  WooCommerce Stripe plugin</strong>. The fix for this vulnerability was released on July 31. Please update immediately.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:43:\"woocommerce-WCStripe-Aug-2023-update-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:16:\"update-core.php?\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-08-03 05:00:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.6\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"7.4.2\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:11:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.3.2\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.4.5\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.5.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.6.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.9.2\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.0.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.1.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.2.2\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.3.2\";}}}}}}}s:46:\"woocommerce-WCStripe-Aug-2023-security-updated\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woocommerce-WCStripe-Aug-2023-security-updated\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:44:\"Security update of WooCommerce Stripe plugin\";s:7:\"content\";s:144:\"<strong>Your store has been updated to the latest secure version of the WooCommerce Stripe plugin</strong>. This update was released on July 31.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-08-03 05:00:07\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:11:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.3.2\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.4.5\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.5.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.6.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.9.2\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.0.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.1.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.2.2\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.3.2\";}}}}}s:49:\"woocommerce-WooPayments-Aug-2023-security-updated\";O:8:\"stdClass\":8:{s:4:\"slug\";s:49:\"woocommerce-WooPayments-Aug-2023-security-updated\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:60:\"Security update of WooPayments (WooCommerce Payments) plugin\";s:7:\"content\";s:147:\"<strong>Your store has been updated to the more secure version of WooPayments (WooCommerce Payments)</strong>. This update was released on July 31.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-08-03 05:00:13\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:17:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.4\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.4\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.3\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.6\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.5\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.3\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.5.4\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.6.4\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.7.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.8.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.9.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.0.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.1.2\";}}}}}s:24:\"avalara_q3-2023_noAvaTax\";O:8:\"stdClass\":8:{s:4:\"slug\";s:24:\"avalara_q3-2023_noAvaTax\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:40:\"Automatically calculate VAT in real time\";s:7:\"content\";s:284:\"Take the effort out of determining tax rates and sell confidently across borders with automated tax management from Avalara AvaTax— including built-in VAT calculation when you sell into or across the EU and UK. Save time and stay compliant when you let Avalara do the heavy lifting.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:24:\"avalara_q3-2023_noAvaTax\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Automate my sales tax\";}}s:3:\"url\";s:131:\"https://woocommerce.com/products/woocommerce-avatax/?utm_source=inbox_note&utm_medium=product&utm_campaign=avalara_q3-2023_noAvaTax\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-08-08 22:32:23\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2023-08-09 23:59:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:18:\"woocommerce-avatax\";}}}}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:30;}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:20:\"total_payments_value\";s:9:\"timeframe\";s:9:\"last_year\";s:5:\"value\";i:100;s:9:\"operation\";s:1:\">\";}}}s:44:\"woocommerce-usermeta-Sept2023-productvendors\";O:8:\"stdClass\":8:{s:4:\"slug\";s:44:\"woocommerce-usermeta-Sept2023-productvendors\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:37:\"Your store requires a security update\";s:7:\"content\";s:339:\"<strong>Your shop needs an update to address a vulnerability in WooCommerce.</strong> The fix was released on Sept 15. Please update WooCommerce to the latest version immediately. <a href=\"https://developer.woocommerce.com/2023/09/16/woocommerce-vulnerability-reintroduced-from-7-0-1/\" />Read our developer update</a> for more information.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:44:\"woocommerce-usermeta-Sept2023-productvendors\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:11:\"plugins.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-09-20 00:50:07\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-product-vendors\";}}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"8.1.1\";}}}s:41:\"woocommerce-STRIPE-Oct-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:41:\"woocommerce-STRIPE-Oct-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"Action required: Security update for WooCommerce Stripe Gateway\";s:7:\"content\";s:201:\"<strong>Your shop requires a security update to address a vulnerability in the WooCommerce Stripe Gateway</strong>. The fix for this vulnerability was released on October 17. Please update immediately.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:41:\"woocommerce-STRIPE-Oct-2023-update-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:15:\"update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:36:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-10-18 00:01:58\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"4.5.4\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.6\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.4\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.2\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.5.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.6.4\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.7.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.8.3\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.9.2\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.0.2\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.1.2\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.2.2\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.3.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.4.6\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.5.4\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.6.3\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.5.4\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.6.3\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.7.3\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.8.3\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.9.3\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.0.5\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.1.3\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.2.3\";}i:32;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.3.3\";}i:33;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.4.3\";}i:34;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.5.1\";}i:35;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"7.6.1\";}}}s:29:\"amazon-mcf-reviews-2023-12-07\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"amazon-mcf-reviews-2023-12-07\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:36:\"Enjoying Amazon MCF for WooCommerce?\";s:7:\"content\";s:292:\"We\'re Never Settle, the developers behind Amazon MCF for WooCommerce, and would be deeply honored to have your review. Reviews help immensely as other users can learn how MCF can solve their needs too! Not happy or need help? Please reach out for support and we’d love to make things right!\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"amazon-mcf-review-button-2023-12-07\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Leave a review\";}}s:3:\"url\";s:161:\"https://woocommerce.com/products/woocommerce-amazon-fulfillment/?review&utm_source=inbox_note&utm_medium=product&utm_campaign=amazon-mcf-review-button-2023-12-07\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:36:\"amazon-mcf-support-button-2023-12-07\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Request support\";}}s:3:\"url\";s:142:\"https://woocommerce.com/my-account/contact-support/?utm_source=inbox_note&utm_medium=product&utm_campaign=amazon-mcf-support-button-2023-12-07\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-12-06 15:21:27\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:30:\"woocommerce-amazon-fulfillment\";}}}}s:30:\"remove_estimated_deposits_2024\";O:8:\"stdClass\":8:{s:4:\"slug\";s:30:\"remove_estimated_deposits_2024\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:33:\"Estimated deposits are going away\";s:7:\"content\";s:267:\"To provide more accurate deposit information and support the expansion of instant deposits, estimated deposit details will no longer be available in WooPayments. We recommend upgrading to the latest version of WooPayments for more detailed balance status information.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:9:\"view_docs\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:29:\"Learn about Deposit schedules\";}}s:3:\"url\";s:151:\"https://woocommerce.com/document/woopayments/deposits/deposit-schedule/?utm_source=inbox_note&utm_medium=product&utm_campaign=view_docs#available-funds\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:3:\"6.9\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2024-01-21 08:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2024-01-31 23:59:59\";}}}s:5:\"fa_IR\";a:61:{s:21:\"wayflyer_bnpl_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:21:\"wayflyer_bnpl_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:48:\"Grow your business with funding through Wayflyer\";s:7:\"content\";s:261:\"Fast, flexible financing to boost cash flow and help your business grow – one fee, no interest rates, penalties, equity, or personal guarantees. Based on your store’s performance, Wayflyer provides funding and analytical insights to invest in your business.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:21:\"wayflyer_bnpl_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Level up with funding\";}}s:3:\"url\";s:118:\"https://woocommerce.com/products/wayflyer/?utm_source=inbox_note&utm_medium=product&utm_campaign=wayflyer_bnpl_q4_2021\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-17 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-12-18 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:7:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AU\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"BE\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CA\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"IE\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NL\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"GB\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-affirm\";}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:32:\"afterpay-gateway-for-woocommerce\";}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:31:\"klarna-payments-for-woocommerce\";}}}}}}s:35:\"wc_shipping_mobile_app_usps_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:35:\"wc_shipping_mobile_app_usps_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:94:\"Print and manage your shipping labels with WooCommerce Shipping and the WooCommerce Mobile App\";s:7:\"content\";s:210:\"Save time by printing, purchasing, refunding, and tracking shipping labels generated by <a href=\"https://woocommerce.com/woocommerce-shipping/\">WooCommerce Shipping</a> – all directly from your mobile device!\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"wc_shipping_mobile_app_usps_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Get WooCommerce Shipping\";}}s:3:\"url\";s:135:\"https://woocommerce.com/woocommerce-shipping/?utm_source=inbox_note&utm_medium=product&utm_campaign=wc_shipping_mobile_app_usps_q4_2021\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-12 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-11-27 00:00:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:25:\"woocommerce-shipping-usps\";}}i:4;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}}}}}s:18:\"your-first-product\";O:8:\"stdClass\":8:{s:4:\"slug\";s:18:\"your-first-product\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:18:\"Your first product\";s:7:\"content\";s:467:\"That’s huge! You’re well on your way to building a successful online store — now it’s time to think about how you’ll fulfill your orders.<br/><br/>Read our shipping guide to learn best practices and options for putting together your shipping strategy. And for WooCommerce stores in the United States, you can print discounted shipping labels via USPS with <a href=\"https://href.li/?https://woocommerce.com/shipping\" target=\"_blank\">WooCommerce Shipping</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:130:\"https://woocommerce.com/posts/ecommerce-shipping-solutions-guide/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:19:13\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_were_no_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_are_now_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:2:\">=\";s:5:\"value\";i:1;}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:13:\"product_types\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"physical\";s:7:\"default\";a:0:{}}}}s:37:\"wc-admin-optimizing-the-checkout-flow\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"wc-admin-optimizing-the-checkout-flow\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:28:\"Optimizing the checkout flow\";s:7:\"content\";s:177:\"It’s crucial to get your store’s checkout as smooth as possible to avoid losing sales. Let’s take a look at how you can optimize the checkout experience for your shoppers.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:28:\"optimizing-the-checkout-flow\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:144:\"https://woocommerce.com/posts/optimizing-woocommerce-checkout?utm_source=inbox_note&utm_medium=product&utm_campaign=optimizing-the-checkout-flow\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:19:49\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"payments\";s:7:\"default\";a:0:{}}}}s:32:\"wc-payments-qualitative-feedback\";O:8:\"stdClass\":8:{s:4:\"slug\";s:32:\"wc-payments-qualitative-feedback\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:46:\"WooPayments setup - let us know what you think\";s:7:\"content\";s:137:\"Congrats on enabling WooPayments for your store. Please share your feedback in this 2 minute survey to help us improve the setup process.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"qualitative-feedback-from-new-users\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:58:\"https://automattic.survey.fm/woopayments-new-user-feedback\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:21:13\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:20:\"woocommerce-payments\";s:7:\"default\";a:0:{}}}}s:29:\"share-your-feedback-on-paypal\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"share-your-feedback-on-paypal\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:29:\"Share your feedback on PayPal\";s:7:\"content\";s:127:\"Share your feedback in this 2 minute survey about how we can make the process of accepting payments more useful for your store.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:43:\"http://automattic.survey.fm/paypal-feedback\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:21:50\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}}}s:31:\"google_listings_and_ads_install\";O:8:\"stdClass\":8:{s:4:\"slug\";s:31:\"google_listings_and_ads_install\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Drive traffic and sales with Google\";s:7:\"content\";s:123:\"Reach online shoppers to drive traffic and sales for your store by showcasing products across Google, for free or with ads.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"get-started\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Get started\";}}s:3:\"url\";s:122:\"https://woocommerce.com/products/google-listings-and-ads?utm_source=inbox_note&utm_medium=product&utm_campaign=get-started\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-06-09 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:23:\"google_listings_and_ads\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:10;}}}s:39:\"wc-subscriptions-security-update-3-0-15\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"wc-subscriptions-security-update-3-0-15\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:42:\"WooCommerce Subscriptions security update!\";s:7:\"content\";s:738:\"We recently released an important security update to WooCommerce Subscriptions. To ensure your site’s data is protected, please upgrade <strong>WooCommerce Subscriptions to version 3.0.15</strong> or later.<br/><br/>Click the button below to view and update to the latest Subscriptions version, or log in to <a href=\"https://woocommerce.com/my-dashboard\">WooCommerce.com Dashboard</a> and navigate to your <strong>Downloads</strong> page.<br/><br/>We recommend always using the latest version of WooCommerce Subscriptions, and other software running on your site, to ensure maximum security.<br/><br/>If you have any questions we are here to help — just <a href=\"https://woocommerce.com/my-account/create-a-ticket/\">open a ticket</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:30:\"update-wc-subscriptions-3-0-15\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"View latest version\";}}s:3:\"url\";s:30:\"&page=wc-addons&section=helper\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:30:32\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"woocommerce-subscriptions\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:6:\"3.0.15\";}}}s:29:\"woocommerce-core-update-5-4-0\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"woocommerce-core-update-5-4-0\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Update to WooCommerce 5.4.1 now\";s:7:\"content\";s:140:\"WooCommerce 5.4.1 addresses a checkout issue discovered in WooCommerce 5.4. We recommend upgrading to WooCommerce 5.4.1 as soon as possible.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:20:\"update-wc-core-5-4-0\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:25:\"How to update WooCommerce\";}}s:3:\"url\";s:64:\"https://docs.woocommerce.com/document/how-to-update-woocommerce/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:31:08\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.0\";}}}s:19:\"wcpay-promo-2020-11\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"wcpay-promo-2020-11\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-11\";s:7:\"content\";s:19:\"wcpay-promo-2020-11\";}}s:7:\"actions\";a:0:{}s:5:\"rules\";a:0:{}}s:19:\"wcpay-promo-2020-12\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"wcpay-promo-2020-12\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-12\";s:7:\"content\";s:19:\"wcpay-promo-2020-12\";}}s:7:\"actions\";a:0:{}s:5:\"rules\";a:0:{}}s:34:\"ppxo-pps-upgrade-paypal-payments-1\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-1\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Get the latest PayPal extension for WooCommerce\";s:7:\"content\";s:442:\"Heads up! There’s a new PayPal on the block!<br/><br/>Now is a great time to upgrade to our latest <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal extension</a> to continue to receive support and updates with PayPal.<br/><br/>Get access to a full suite of PayPal payment methods, extensive currency and country coverage, and pay later options with the all-new PayPal extension for WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-1\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:33:53\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:7;s:7:\"default\";i:1;s:9:\"operation\";s:1:\"<\";}}}s:34:\"ppxo-pps-upgrade-paypal-payments-2\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-2\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Upgrade your PayPal experience!\";s:7:\"content\";s:358:\"Get access to a full suite of PayPal payment methods, extensive currency and country coverage, offer subscription and recurring payments, and the new PayPal pay later options.<br /><br />Start using our <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">latest PayPal today</a> to continue to receive support and updates.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-2\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:34:30\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:6;s:7:\"default\";i:1;s:9:\"operation\";s:1:\">\";}}}s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:56:\"Action required: Critical vulnerabilities in WooCommerce\";s:7:\"content\";s:574:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br /><br />Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br /><br />For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:59:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:35:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.6\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.8\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.9\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.6\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.2\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.2\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.3\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.4\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.4\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.5\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.2\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.4\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.3\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.2\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.3\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.4\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.2\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.2\";}i:32;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.3\";}i:33;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.4\";}i:34;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:35;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:36;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.2\";}i:37;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.3\";}i:38;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}i:39;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"3.5.10\";}i:40;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.7\";}i:41;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.3\";}i:42;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.3\";}i:43;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.5\";}i:44;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.4\";}i:45;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.4\";}i:46;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.5\";}i:47;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.6\";}i:48;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.4\";}i:49;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.5\";}i:50;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.5\";}i:51;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.4\";}i:52;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.3\";}i:53;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.5\";}i:54;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.3\";}i:55;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.3\";}i:56;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.5\";}i:57;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.3\";}i:58;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.4\";}}}s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"Action required: Critical vulnerabilities in WooCommerce Blocks\";s:7:\"content\";s:570:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/>Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br/><br/>For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:32:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:35:42\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"2.5.16\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.6.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.7.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.8.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.9.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.0.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.1.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.2.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.1\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.1\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.2\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.1\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.1\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}}}s:45:\"woocommerce-core-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:45:\"woocommerce-core-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"Solved: Critical vulnerabilities patched in WooCommerce\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:36:18\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:23:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.6\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.8\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.9\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.6\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.2\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.4\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.2\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.1\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:62:\"Solved: Critical vulnerabilities patched in WooCommerce Blocks\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:36:54\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:31:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"2.5.16\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.6.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.7.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.8.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.9.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.0.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.1.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.2.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.1\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.1\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.2\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.2\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.1\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:19:\"habit-moment-survey\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"habit-moment-survey\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"We’re all ears! Share your experience so far with WooCommerce\";s:7:\"content\";s:136:\"We’d love your input to shape the future of WooCommerce together. Feel free to share any feedback, ideas or suggestions that you have.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:45:\"https://automattic.survey.fm/store-management\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:37:30\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:30;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:0;}}}s:42:\"woocommerce-core-paypal-march-2022-updated\";O:8:\"stdClass\":8:{s:4:\"slug\";s:42:\"woocommerce-core-paypal-march-2022-updated\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Security auto-update of WooCommerce\";s:7:\"content\";s:391:\"<strong>Your store has been updated to the latest secure version of WooCommerce</strong>. We worked with WordPress to deploy PayPal Standard security updates for stores running WooCommerce (version 3.5 to 6.3). It’s recommended to disable PayPal Standard, and use <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal Payments</a> to accept PayPal.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:88:\"https://developer.woocommerce.com/2022/03/10/woocommerce-3-5-10-6-3-1-security-releases/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:42:\"woocommerce-core-paypal-march-2022-dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-03-10 18:44:57\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:28:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"3.5.10\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.7\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.3\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.5\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.4\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.5\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.6\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.4\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.5\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.5\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.4\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.5\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.3\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.5\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.5.4\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.6.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.9.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.1.2\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.2.2\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:3:\"5.5\";}i:1;a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}}}}}}}s:47:\"woocommerce-core-paypal-march-2022-updated-nopp\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-core-paypal-march-2022-updated-nopp\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Security auto-update of WooCommerce\";s:7:\"content\";s:237:\"<strong>Your store has been updated to the latest secure version of WooCommerce</strong>. We worked with WordPress to deploy security updates related to PayPal Standard payment gateway for stores running WooCommerce (version 3.5 to 6.3).\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:88:\"https://developer.woocommerce.com/2022/03/10/woocommerce-3-5-10-6-3-1-security-releases/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-03-10 18:45:04\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:28:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"3.5.10\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.7\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.3\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.5\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.4\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.5\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.6\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.4\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.5\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.5\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.4\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.5\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.3\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.5\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.5.4\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.6.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.9.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.1.2\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.2.2\";}}}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:42:\"woocommerce-core-paypal-march-2022-updated\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}s:24:\"pinterest_03_2022_update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:24:\"pinterest_03_2022_update\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:53:\"Your Pinterest for WooCommerce plugin is out of date!\";s:7:\"content\";s:262:\"Update to the latest version of Pinterest for WooCommerce to continue using this plugin and keep your store connected with Pinterest. To update, visit <strong>Plugins &gt; Installed Plugins</strong>, and click on “update now” under Pinterest for WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:24:\"pinterest_03_2022_update\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"Update Instructions\";}}s:3:\"url\";s:148:\"https://woocommerce.com/document/pinterest-for-woocommerce/?utm_source=inbox_note&utm_medium=product&utm_campaign=pinterest_03_2022_update#section-3\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-03-23 00:00:39\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"pinterest-for-woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"1.0.8\";}}}s:33:\"store_setup_survey_survey_q2_2022\";O:8:\"stdClass\":8:{s:4:\"slug\";s:33:\"store_setup_survey_survey_q2_2022\";s:4:\"type\";s:6:\"survey\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:30:\"How is your store setup going?\";s:7:\"content\";s:232:\"Our goal is to make sure you have all the right tools to start setting up your store in the smoothest way possible.\r\nWe’d love to know if we hit our mark and how we can improve. To collect your thoughts, we made a 2-minute survey.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:53:\"store_setup_survey_survey_q2_2022_share_your_thoughts\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Tell us how it’s going\";}}s:3:\"url\";s:52:\"https://automattic.survey.fm/store-setup-survey-2022\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-05-09 08:42:10\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:7;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:9;}}}s:48:\"needs-update-eway-payment-gateway-rin-2022-12-20\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"needs-update-eway-payment-gateway-rin-2022-12-20\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:58:\"Security vulnerability patched in WooCommerce Eway Gateway\";s:7:\"content\";s:323:\"In response to a potential vulnerability identified in WooCommerce Eway Gateway versions 3.1.0 to 3.5.0, we’ve worked to deploy security fixes and have released an updated version.\r\nNo external exploits have been detected, but we recommend you update to your latest supported version 3.1.26, 3.2.3, 3.3.1, 3.4.6, or 3.5.1\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:62:\"needs-update-eway-payment-gateway-rin-action-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:16:\"/update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:63:\"needs-update-eway-payment-gateway-rin-dismiss-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:7:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-03 23:45:53\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"3.1.26\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.2.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.6\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"3.5.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"3.1.0\";}}}s:43:\"updated-eway-payment-gateway-rin-2022-12-20\";O:8:\"stdClass\":8:{s:4:\"slug\";s:43:\"updated-eway-payment-gateway-rin-2022-12-20\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"WooCommerce Eway Gateway has been automatically updated\";s:7:\"content\";s:280:\"Your store is now running the latest secure version of WooCommerce Eway Gateway. We worked with the WordPress Plugins team to deploy a software update to stores running WooCommerce Eway Gateway (versions 3.1.0 to 3.5.0) in response to a security vulnerability that was discovered.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:57:\"updated-eway-payment-gateway-rin-action-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"See all updates\";}}s:3:\"url\";s:16:\"/update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:58:\"updated-eway-payment-gateway-rin-dismiss-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-03 23:45:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"needs-update-eway-payment-gateway-rin-2022-12-20\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:5:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"3.1.26\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.2.3\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.1\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.6\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.1\";}}}}}s:31:\"ecomm-wc-navigation-survey-2023\";O:8:\"stdClass\":8:{s:4:\"slug\";s:31:\"ecomm-wc-navigation-survey-2023\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:39:\"Navigating WooCommerce on WordPress.com\";s:7:\"content\";s:166:\"We are improving the WooCommerce navigation on WordPress.com and would love your help to make it better! Please share your experience with us in this 2-minute survey.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:32:\"share-navigation-survey-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:58:\"https://automattic.survey.fm/new-ecommerce-plan-navigation\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-01-16 09:53:44\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:12:\"is_ecommerce\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:180;}}}s:39:\"woopay-beta-merchantrecruitment-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"woopay-beta-merchantrecruitment-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:319:\"WooPay, a new express checkout feature built into WooCommerce Payments, is <b>now available</b> —and we’re inviting you to be one of the first to try it. \r\n<br><br>\r\n<b>Boost conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\r\n<br><br>\r\n<b>Get started in seconds.</b>\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:48:\"woopay-beta-merchantrecruitment-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:58:\"woopay-beta-merchantrecruitment-activate-learnmore-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:155:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-activate-learnmore-04MAY23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:27\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"http://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.handinhandparenting.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://pritikinfoods.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://utahrecsports.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.hunterpta.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.smokinbeans.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://shulabeauty.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://bingeworthytvmerch.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://s91.4d8.myftpupload.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://stephanienicolenorris.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://aliensshirt.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://libertyordeathapparelllc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://cowboystatedaily.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:42:\"https://fundrgear.com/beckendorffathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:50:\"http://wordpress-528155-2231771.cloudwaysapps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://checkout.sohaprice.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://amadozstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://eliwehbe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://lunabra.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://nptixx.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://louisianapantry.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://aplusanatomy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://wildsvg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://bleachfilm.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://benabeautyspa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:47:\"http://barrettfitnessenterprises.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://goabroadable.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://alexoathletica.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.fourpurls.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.hagmannreport.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://busybeeorganics.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nallsproduce.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://bigtimebats.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://shop.cookingwithkarli.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.queenofpeacemedia.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://bigjohnsbeefjerky.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://paperbyjaney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://carolinarisemembers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://veroticaevents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://spira.farm\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://endlessassist.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://betterlifeblog.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://ashleighrenard.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.turkeymerck.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://carfiershop.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://normanmusicfestival.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"http://www.olfactoryfactoryllc.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://fundrgear.com/anthonyathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"http://tkechilifestdotcom.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:49;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:15:\"No results foun\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:50;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://pvsa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:51;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://becbatop.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:52;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wwmeconvention.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:53;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://lswmp.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:54;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bubbaskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:55;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://fusango.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:56;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://vcdpostershow.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:57;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.rileysribz.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:58;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.fakeultrasound.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:59;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://onelongfellowsquare.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:60;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://agodpod.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:61;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/littleladybulldogs\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:62;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://thecirclelarp.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:63;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://byletam.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:64;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.nachonite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:65;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://designerdab.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:66;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2151.temp.domains/~lovebyt2/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:67;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://shortporchbaseballcompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:68;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://distancecme.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:69;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://middleswarthchips.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:70;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://railblazausa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:71;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://mikescountrymeats.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:72;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://www.woodenshoe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:73;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://rockspringscafe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:74;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"http://footballfangears.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:75;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://ybtoner.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:76;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://simplyclayyy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:77;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://naturecreation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:78;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://marisrodriguez.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:79;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://asanteinternational.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:80;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://theatre55.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:81;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://carolynscreativeclassroom.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:82;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://www.miiriya.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:83;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://trendyds.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:84;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wooedbythefood.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:85;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://papasteamstores.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:86;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://omdurags.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:87;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://happydogbarkery.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:88;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://kitbose.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:89;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://seamossdeals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:90;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://zeatala.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:91;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://shop.atwaterffa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:92;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://www.brettsfirstresponders.org/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:93;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://shirtactive.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:94;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://boerneparade.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:95;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://zorahshrine.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:96;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://davidcervenka.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:97;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://addisjourney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:98;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://305ycle.cc\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:99;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"http://yourworstnightmarehaunt.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:100;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://westcoastpreps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:101;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://checkout.sohaking.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:102;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://www.theunshakeablepundit.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:103;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.stellaandchewys.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:104;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://www.raywhitcomb.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:105;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:39:\"http://constellationtheatercompany.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:106;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://stacynguyen.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:107;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:46:\"https://fundrgear.com/lakecreekgirlsbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:108;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://winslowartcenter.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:109;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://flufftastik.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:110;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mygreenbeach.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:111;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://ebookvip.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:112;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://fundrgear.com/needvillevolleyball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:113;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bifocalmedia.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:114;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://clrc.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:115;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://hyperpins.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:116;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/lakecreekboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:117;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://fundrgear.com/kparktennis\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:118;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mogadorspices.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:119;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://fundrgear.com/newcaneytrack\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:120;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://sigmascents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:121;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://bsharisemoore.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:122;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://morrflate.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:123;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://westbrosinc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:124;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://shop.danceplexaz.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:125;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://chikepod.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:126;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.advanahealth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:127;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://tatter.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:128;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://greatawakeningbrewing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:129;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://waterfowlfestival.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:130;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://preppedwellness.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:131;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://events.thus.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:132;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://stormtide.thefifthtrooper.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:133;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://www.tabsynth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:134;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"http://staging.fliptheswitchon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:135;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://duffysdough.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:136;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://fitfoodieliving.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:137;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://breakerbrotherstcg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:138;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://andymation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:139;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://recklessmetals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:140;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://sophielark.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:141;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://wp.arabtherapy.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:142;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://creativeappliques.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:143;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://altitude.win\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:42:\"woocommerce-wcpay-march-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:42:\"woocommerce-wcpay-march-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:57:\"Action required: Security update for WooCommerce Payments\";s:7:\"content\";s:296:\"<strong>Your store requires a security update for WooCommerce Payments</strong>. Please update to the latest version of WooCommerce Payments immediately to address a potential vulnerability discovered on March 22. For more information on how to update, visit this WooCommerce Developer Blog Post.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:49:\"woocommerce-wcpay-march-2023-update-needed-button\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"See Blog Post\";}}s:3:\"url\";s:122:\"https://developer.woocommerce.com/2023/03/23/critical-vulnerability-detected-in-woocommerce-payments-what-you-need-to-know\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:57:\"woocommerce-wcpay-march-2023-update-needed-dismiss-button\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:11:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-03-22 20:25:44\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.1\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.4\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.3\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.5.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"4.8.0\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"5.6.1\";}}}s:34:\"tap_to_pay_iphone_q2_2023_no_wcpay\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"tap_to_pay_iphone_q2_2023_no_wcpay\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:52:\"Accept in-person contactless payments on your iPhone\";s:7:\"content\";s:230:\"Tap to Pay on iPhone and WooCommerce Payments is quick, secure, and simple to set up — no extra terminals or card readers are needed. Accept contactless debit and credit cards, Apple Pay, and other NFC digital wallets in person.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"tap_to_pay_iphone_q2_2023_no_wcpay\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:20:\"Simplify my payments\";}}s:3:\"url\";s:143:\"https://woocommerce.com/products/woocommerce-payments/?utm_source=inbox_note&utm_medium=product&utm_campaign=tap_to_pay_iphone_q2_2023_no_wcpay\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-03 23:59:47\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}s:48:\"woocommerce-WCPreOrders-april-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-WCPreOrders-april-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:68:\"Action required: Security update of WooCommerce Pre-Orders extension\";s:7:\"content\";s:220:\"<strong>Your store requires a security update for the WooCommerce Pre-Orders extension</strong>. Please update the WooCommerce Pre-Orders extension immediately to address a potential vulnerability discovered on April 11.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:18:\"extension-settings\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:15:\"update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-12 22:16:37\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:22:\"woocommerce-pre-orders\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"2.0.0\";}}}s:46:\"woopay-beta-merchantrecruitment-update-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woopay-beta-merchantrecruitment-update-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:321:\"WooPay, a new express checkout feature built into WooCommerce Payments, is <b>now available</b> — and you’re invited to try it. \r\n<br /><br />\r\n<b>Boost conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\r\n<br /><br />\r\n<b>Update WooCommerce Payments</b> to get started.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:52:\"woopay-beta-merchantrecruitment-update-WCPay-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Update WooCommerce Payments\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:55:\"woopay-beta-merchantrecruitment-update-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"http://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.handinhandparenting.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://pritikinfoods.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://utahrecsports.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.hunterpta.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.smokinbeans.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://shulabeauty.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://bingeworthytvmerch.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://s91.4d8.myftpupload.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://stephanienicolenorris.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://aliensshirt.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://libertyordeathapparelllc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://cowboystatedaily.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:42:\"https://fundrgear.com/beckendorffathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:50:\"http://wordpress-528155-2231771.cloudwaysapps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://checkout.sohaprice.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://amadozstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://eliwehbe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://lunabra.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://nptixx.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://louisianapantry.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://aplusanatomy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://wildsvg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://bleachfilm.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://benabeautyspa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:47:\"http://barrettfitnessenterprises.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://goabroadable.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://alexoathletica.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.fourpurls.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.hagmannreport.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://busybeeorganics.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nallsproduce.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://bigtimebats.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://shop.cookingwithkarli.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.queenofpeacemedia.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://bigjohnsbeefjerky.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://paperbyjaney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://carolinarisemembers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://veroticaevents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://spira.farm\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://endlessassist.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://betterlifeblog.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://ashleighrenard.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.turkeymerck.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://carfiershop.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://normanmusicfestival.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"http://www.olfactoryfactoryllc.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://fundrgear.com/anthonyathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"http://tkechilifestdotcom.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:49;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:15:\"No results foun\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:50;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://pvsa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:51;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://becbatop.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:52;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wwmeconvention.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:53;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://lswmp.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:54;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bubbaskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:55;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://fusango.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:56;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://vcdpostershow.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:57;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.rileysribz.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:58;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.fakeultrasound.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:59;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://onelongfellowsquare.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:60;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://agodpod.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:61;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/littleladybulldogs\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:62;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://thecirclelarp.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:63;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://byletam.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:64;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.nachonite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:65;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://designerdab.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:66;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2151.temp.domains/~lovebyt2/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:67;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://shortporchbaseballcompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:68;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://distancecme.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:69;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://middleswarthchips.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:70;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://railblazausa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:71;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://mikescountrymeats.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:72;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://www.woodenshoe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:73;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://rockspringscafe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:74;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"http://footballfangears.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:75;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://ybtoner.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:76;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://simplyclayyy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:77;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://naturecreation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:78;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://marisrodriguez.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:79;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://asanteinternational.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:80;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://theatre55.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:81;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://carolynscreativeclassroom.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:82;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://www.miiriya.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:83;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://trendyds.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:84;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wooedbythefood.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:85;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://papasteamstores.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:86;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://omdurags.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:87;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://happydogbarkery.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:88;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://kitbose.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:89;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://seamossdeals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:90;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://zeatala.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:91;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://shop.atwaterffa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:92;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://www.brettsfirstresponders.org/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:93;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://shirtactive.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:94;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://boerneparade.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:95;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://zorahshrine.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:96;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://davidcervenka.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:97;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://addisjourney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:98;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://305ycle.cc\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:99;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"http://yourworstnightmarehaunt.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:100;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://westcoastpreps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:101;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://checkout.sohaking.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:102;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://www.theunshakeablepundit.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:103;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.stellaandchewys.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:104;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://www.raywhitcomb.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:105;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:39:\"http://constellationtheatercompany.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:106;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://stacynguyen.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:107;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:46:\"https://fundrgear.com/lakecreekgirlsbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:108;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://winslowartcenter.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:109;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://flufftastik.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:110;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mygreenbeach.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:111;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://ebookvip.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:112;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://fundrgear.com/needvillevolleyball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:113;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bifocalmedia.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:114;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://clrc.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:115;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://hyperpins.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:116;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/lakecreekboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:117;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://fundrgear.com/kparktennis\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:118;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mogadorspices.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:119;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://fundrgear.com/newcaneytrack\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:120;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://sigmascents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:121;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://bsharisemoore.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:122;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://morrflate.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:123;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://westbrosinc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:124;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://shop.danceplexaz.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:125;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://chikepod.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:126;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.advanahealth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:127;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://tatter.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:128;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://greatawakeningbrewing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:129;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://waterfowlfestival.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:130;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://preppedwellness.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:131;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://events.thus.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:132;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://stormtide.thefifthtrooper.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:133;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://www.tabsynth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:134;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"http://staging.fliptheswitchon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:135;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://duffysdough.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:136;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://fitfoodieliving.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:137;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://breakerbrotherstcg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:138;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://andymation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:139;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://recklessmetals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:140;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://sophielark.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:141;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://wp.arabtherapy.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:142;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://creativeappliques.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:143;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://altitude.win\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:46:\"woopay-beta-existingmerchants-noaction-27APR23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woopay-beta-existingmerchants-noaction-27APR23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:15:\"WooPay is back!\";s:7:\"content\";s:361:\"Thanks for previously trying WooPay, the<b> express checkout feature</b> built into WooCommerce Payments. We’re excited to announce that <b>WooPay availability has resumed</b>. No action is required on your part.\r\n<br /><br />\r\nYou can now <b>continue boosting conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woopay-beta-existingmerchants-noaction-documentation-27APR23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"Documentation\";}}s:3:\"url\";s:178:\"https://woocommerce.com/document/woopay-merchant-documentation/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-existingmerchants-noaction-documentation-27APR23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-26 19:00:23\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.0\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:38:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://store.startingstrongman.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://joacreativelab.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.pureskincaresalon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mariablaquier.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://getprodigital.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://dalefrickeholsters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://sstour.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://tk-txstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://humanspiritproject.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://viradadrums.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://rosariumblends.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://organicskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://stuckpigmedical.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.seattlegiftbasket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.cloverandviolet.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://gvscholarship.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://yesimadiva.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://www.old.jmtrashbgone.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://victorialansford.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://craftcosplay.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://thefossilexchange.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nextgenspeed.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://cappellarecords.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://ontimesupermarket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://new2knox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://lovestudiollc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://thehivelivebox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://socceruniformkits.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://willowcreativ.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://summitprep.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://howda.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://soapavenuecompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://subsbox.mystagingwebsite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wifflebreakers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.mps-outfitters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://howardharrisassociates.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://bettersaferadio.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://bunnyluna.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:44:\"woopay-beta-existingmerchants-update-27APR23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:44:\"woopay-beta-existingmerchants-update-27APR23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:15:\"WooPay is back!\";s:7:\"content\";s:368:\"Thanks for previously trying WooPay, the <b>express checkout feature</b> built into WooCommerce Payments. We’re excited to announce that <b>WooPay availability has resumed</b>.\r\n<br /><br />\r\n\r\nUpdate to the latest WooCommerce Payments version to <b>continue boosting conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:50:\"woopay-beta-existingmerchants-update-WCPay-27APR23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Update WooCommerce Payments\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-26 19:00:08\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.8.0\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:38:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://store.startingstrongman.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://joacreativelab.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.pureskincaresalon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mariablaquier.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://getprodigital.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://dalefrickeholsters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://sstour.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://tk-txstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://humanspiritproject.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://viradadrums.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://rosariumblends.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://organicskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"op