<?php

namespace Prk\Admin\Hub;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Class PRK_Hub
 * Handles the content callback for the ParsKala Hub tab in WooCommerce product page.
 */
class prk_child_theme {
    /**
     * Holds the single instance of the class
     * @var prk_child_theme|null
     */
    private static ?prk_child_theme $instance = null;

    /**
     * Get the single instance of the class
     * @return prk_child_theme
     */
    public static function get_instance(): prk_child_theme {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * PRK_Hub constructor.
     * Private to enforce singleton pattern.
     */
    private function __construct() {

        add_action('admin_enqueue_scripts', [ $this, 'enqueue_assets' ]);
        
    }

    /**
     * Enqueue the common CSS and JS files for all tabs
     */
    public function enqueue_assets(): void {
        $css_path = get_template_directory_uri() . '/app/Admin/assets/css/child-theme.css';
        $js_path = get_template_directory_uri() . '/app/Admin/assets/js/child-theme.js';

        $data = [
            'ajax_url' => admin_url('admin-ajax.php'),
            'msg' => [
                'on_process' => __('Processing', 'ahura'),
            ],
        ];
        wp_enqueue_style('admin-child-css', $css_path,'1.0.0');
        wp_enqueue_script('admin-child-js', $js_path, false, true);
        wp_localize_script('admin-child-js', 'ahura_child_data', $data);
    }

    /**
     * Display the content of the ParsKala Hub tab
     */
    public function display_child_content(): void {
        $template_path = __DIR__ . '/template/main-child.php';

        if ( file_exists( $template_path ) ) {
            require $template_path;
        } else {
            echo '<div style="color: red;">Template file not found: ' . esc_html( $template_path ) . '</div>';
        }
    }
}
