<?php

namespace Prk\Admin\Hub;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Class PRK_studio
 * Handles the content callback for the ParsKala Hub tab in WooCommerce product page.
 */
class prk_studio {
    /**
     * Holds the single instance of the class
     * @var prk_studio|null
     */
    private static ?prk_studio $instance = null;

    /**
     * Get the single instance of the class
     * @return prk_studio
     */
    public static function get_instance(): prk_studio {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * PRK_studio constructor.
     * Private to enforce singleton pattern.
     */
    private function __construct() {

    }


    /**
     * Display the content of the ParsKala Hub tab
     */
    public function display_studio_content(): void {
        $template_path = __DIR__ . '/template/main-studio.php';

        if ( file_exists( $template_path ) ) {
            require $template_path;
        } else {
            echo '<div style="color: red;">Template file not found: ' . esc_html( $template_path ) . '</div>';
        }
    }
}
