<?php



function prk_display_next_update_info() {


  if (!is_theme_options_page()) {
      return;
  }

  if ( isset($_GET['clear_next_update']) ) {
    delete_transient('prk_next_update');
  }
  // کش کردن داده
  $cached_data = get_transient('prk_next_update');

  if (!$cached_data) {
      $res = wp_remote_get('https://parskalas.com/docs/wp-json/wp/v2/pages/9614');
      if (!is_wp_error($res)) {
          $body = wp_remote_retrieve_body($res);
          $data = json_decode($body, true);

          if (isset($data['content']['rendered'])) {
              $cached_data = $data['content']['rendered'];
              set_transient('prk_next_update', $cached_data, 6 * HOUR_IN_SECONDS);
          }
      }
  }

  if ($cached_data) {
     echo wp_kses_post($cached_data);
  }else{
    echo 'محتوایی وجود ندارد.';
  }

}

function prk_display_latest_announcements() {

  if (!is_theme_options_page()) {
      return;
  }

  if ( isset($_GET['clear_next_update']) ) {
    delete_transient('prk_latest_announcements');
  }
  
  // کش داده‌ها
  $cached_data = get_transient('prk_latest_announcements');

  if (!$cached_data) {
      $res = wp_remote_get('https://parskalas.com/docs/wp-json/wp/v2/pages/9623'); // آیدی برگه اطلاعیه‌ها
      if (!is_wp_error($res)) {
          $body = wp_remote_retrieve_body($res);
          $data = json_decode($body, true);

          if (isset($data['content']['rendered'])) {
              $cached_data = $data['content']['rendered'];
              set_transient('prk_latest_announcements', $cached_data, 6 * HOUR_IN_SECONDS);
          }
      }
  }

  if ($cached_data) {
    echo wp_kses_post($cached_data);
  }else{
    echo 'محتوایی وجود ندارد.';
  }

}

function render_tab_shortcuts() {

$demo_icon = '<svg width="17" height="17" viewBox="0 0 17 17" fill="none" xmlns="http://www.w3.org/2000/svg">
<path opacity="0.4" d="M6.37516 7.08333C7.15757 7.08333 7.79183 6.44907 7.79183 5.66667C7.79183 4.88426 7.15757 4.25 6.37516 4.25C5.59276 4.25 4.9585 4.88426 4.9585 5.66667C4.9585 6.44907 5.59276 7.08333 6.37516 7.08333Z" stroke="#444444" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.20817 1.41666H6.37484C2.83317 1.41666 1.4165 2.83332 1.4165 6.37499V10.625C1.4165 14.1667 2.83317 15.5833 6.37484 15.5833H10.6248C14.1665 15.5833 15.5832 14.1667 15.5832 10.625V7.08332" stroke="#444444" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<g opacity="0.4">
<path d="M12.75 1.41666V5.66666L14.1667 4.24999" stroke="#444444" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.7502 5.66667L11.3335 4.25" stroke="#444444" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</g>
<path opacity="0.4" d="M1.89111 13.4229L5.3832 11.0783C5.94278 10.7029 6.75028 10.7454 7.2532 11.1775L7.48695 11.3829C8.03945 11.8575 8.93195 11.8575 9.48445 11.3829L12.4311 8.85417C12.9836 8.37958 13.8761 8.37958 14.4286 8.85417L15.5832 9.84583" stroke="#444444" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>';

$sms_icon = '<svg width="17" height="17" viewBox="0 0 17 17" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.5833 7.08342V9.20842C15.5833 12.0417 14.1666 13.4584 11.3333 13.4584H10.9791C10.7595 13.4584 10.547 13.5647 10.4125 13.7417L9.34996 15.1584C8.88246 15.7817 8.11746 15.7817 7.64996 15.1584L6.58746 13.7417C6.47413 13.5859 6.21204 13.4584 6.02079 13.4584H5.66663C2.83329 13.4584 1.41663 12.7501 1.41663 9.20842V5.66675C1.41663 2.83341 2.83329 1.41675 5.66663 1.41675H9.91663" stroke="#444444" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
<path opacity="0.4" d="M13.8125 4.95842C14.7905 4.95842 15.5833 4.16559 15.5833 3.18758C15.5833 2.20958 14.7905 1.41675 13.8125 1.41675C12.8345 1.41675 12.0416 2.20958 12.0416 3.18758C12.0416 4.16559 12.8345 4.95842 13.8125 4.95842Z" stroke="#444444" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path opacity="0.4" d="M11.3309 7.79167H11.3372" stroke="#444444" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
<path opacity="0.4" d="M8.49676 7.79167H8.50312" stroke="#444444" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
<path opacity="0.4" d="M5.66278 7.79167H5.66914" stroke="#444444" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
</svg>';

$plugin_icon = '<svg width="17" height="17" viewBox="0 0 17 17" fill="none" xmlns="http://www.w3.org/2000/svg">
<path opacity="0.4" d="M6.3252 1.41675L6.34644 2.50052C6.36061 3.07427 6.83519 3.54175 7.40894 3.54175H9.54812C10.136 3.54175 10.6106 3.06008 10.6106 2.47925V1.41675" stroke="#444444" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path opacity="0.4" d="M12.0417 12.0417L10.625 13.4584L12.0417 14.8751" stroke="#444444" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
<path opacity="0.4" d="M14.167 12.0417L15.5837 13.4584L14.167 14.8751" stroke="#444444" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M9.20833 15.5834H5.66667C3.1875 15.5834 2.125 14.1667 2.125 12.0417V4.95841C2.125 2.83341 3.1875 1.41675 5.66667 1.41675H11.3333C13.8125 1.41675 14.875 2.83341 14.875 4.95841V9.91675" stroke="#444444" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
</svg>';

$buider_icon = '<svg width="17" height="17" viewBox="0 0 17 17" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.343 7.39511L14.6488 10.3559C14.0538 12.913 12.878 13.9472 10.668 13.7347C10.3138 13.7064 9.93129 13.6426 9.52045 13.5434L8.33045 13.2601C5.3767 12.5589 4.46295 11.0997 5.15712 8.13886L5.85129 5.17094C5.99295 4.56886 6.16295 4.04469 6.37545 3.61261C7.2042 1.89844 8.61379 1.43802 10.9796 1.99761L12.1625 2.27386C15.1305 2.96802 16.0371 4.43427 15.343 7.39511Z" stroke="#444444" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path opacity="0.4" d="M10.668 13.7349C10.2288 14.0324 9.67632 14.2803 9.0034 14.4999L7.88424 14.8682C5.07215 15.7749 3.59174 15.017 2.67799 12.2049L1.77132 9.40696C0.864652 6.59488 1.61549 5.10738 4.42757 4.20071L5.54674 3.83238C5.83715 3.74029 6.1134 3.66238 6.37549 3.61279C6.16299 4.04488 5.99299 4.56904 5.85132 5.17113L5.15715 8.13904C4.46299 11.0999 5.37674 12.559 8.33049 13.2603L9.52049 13.5436C9.93132 13.6428 10.3138 13.7065 10.668 13.7349Z" stroke="#444444" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path opacity="0.4" d="M8.95312 6.04199L12.3885 6.91324" stroke="#444444" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path opacity="0.4" d="M8.25977 8.7832L10.3139 9.30737" stroke="#444444" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>';

$factor_icon = '<svg width="17" height="17" viewBox="0 0 17 17" fill="none" xmlns="http://www.w3.org/2000/svg">
<path opacity="0.4" d="M5.13525 4.95841H11.8644V3.54175C11.8644 2.12508 11.3332 1.41675 9.73942 1.41675H7.26025C5.6665 1.41675 5.13525 2.12508 5.13525 3.54175V4.95841Z" stroke="#444444" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M11.3332 10.625V13.4583C11.3332 14.875 10.6248 15.5833 9.20817 15.5833H7.7915C6.37484 15.5833 5.6665 14.875 5.6665 13.4583V10.625H11.3332Z" stroke="#444444" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M14.875 7.08325V10.6249C14.875 12.0416 14.1667 12.7499 12.75 12.7499H11.3333V10.6249H5.66667V12.7499H4.25C2.83333 12.7499 2.125 12.0416 2.125 10.6249V7.08325C2.125 5.66659 2.83333 4.95825 4.25 4.95825H12.75C14.1667 4.95825 14.875 5.66659 14.875 7.08325Z" stroke="#444444" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M12.0418 10.625H11.1847H4.9585" stroke="#444444" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
<path opacity="0.4" d="M4.9585 7.79175H7.0835" stroke="#444444" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
</svg>';

$mobile_icon = '<svg width="13" height="17" viewBox="0 0 13 17" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.1668 4.95841V12.0417C12.1668 14.8751 11.4585 15.5834 8.62516 15.5834H4.37516C1.54183 15.5834 0.833496 14.8751 0.833496 12.0417V4.95841C0.833496 2.12508 1.54183 1.41675 4.37516 1.41675H8.62516C11.4585 1.41675 12.1668 2.12508 12.1668 4.95841Z" stroke="#444444" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path opacity="0.4" d="M7.91683 3.89575H5.0835" stroke="#444444" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path opacity="0.4" d="M6.49977 13.5291C7.10614 13.5291 7.59769 13.0375 7.59769 12.4312C7.59769 11.8248 7.10614 11.3333 6.49977 11.3333C5.89341 11.3333 5.40186 11.8248 5.40186 12.4312C5.40186 13.0375 5.89341 13.5291 6.49977 13.5291Z" stroke="#444444" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>';

  $tabs = [
    [
      'label' => 'استدیو نصب دموها',
      'slug' =>  'جعبه‌ ابزار',
      'icon'  => $demo_icon,
    ],
    [
      'label' => 'مدیریت افزونه ها',
      'slug' => 'جعبه-ابزار--نصب-افزونه',
      'icon'  => $plugin_icon,
    ],
        [
      'label' => 'صفحه ساز پوسته',
      'url'   => admin_url('edit.php?post_type=ag-themer'),
      'icon'  => $buider_icon,
    ],
    [
      'label' => 'پیکربندی پیامک',
      'slug' => 'پیکربندی سیستم پیامک',
      'icon'  => $sms_icon,
    ],

    [
      'label' => 'پیکربندی فاکتور',
      'slug' => 'پیکربندی-فاکتور-پارس-کالا',
      'icon'  => $factor_icon,
    ],

    [
      'label' => 'پیکربندی موبایل',
      'slug' => 'پیکربندی-قالب-موبایل',
      'icon'  => $mobile_icon,
    ],
  ];


  echo '<ul class="feature-list ">';
  foreach ($tabs as $tab) {
    $is_external = !empty($tab['url']);

    $slug = '';
    if (!$is_external && !empty($tab['slug'])) {
      $slug_raw = preg_replace('/[‌\s]+/u', '-', $tab['slug']);
      $slug = prk_sanitize_slug($slug_raw);
    }

    echo '<li class="csf-tab-item">';

    if ($is_external) {
      echo '<a href="' . esc_url($tab['url']) . '" target="_blank">';
    } else {
      echo '<a href="#tab=' . esc_attr($slug) . '" data-tab-id="' . esc_attr($slug) . '">';
    }

    echo '<i class="feature">' . $tab['icon'] . '</i>';
    echo '<span>' . esc_html($tab['label']) . '</span>';
    echo '</a>';

    echo '</li>';
  }
  echo '</ul>';

}

function render_feature_tab_shortcuts() {



$changelog_icon = '<svg width="17" height="17" viewBox="0 0 17 17" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M5.66699 4.073C5.37658 4.073 5.13574 3.83216 5.13574 3.54175V1.41675C5.13574 1.12633 5.37658 0.885498 5.66699 0.885498C5.95741 0.885498 6.19824 1.12633 6.19824 1.41675V3.54175C6.19824 3.83216 5.95741 4.073 5.66699 4.073Z" fill="#07C865"/>
<path d="M11.333 4.073C11.0426 4.073 10.8018 3.83216 10.8018 3.54175V1.41675C10.8018 1.12633 11.0426 0.885498 11.333 0.885498C11.6234 0.885498 11.8643 1.12633 11.8643 1.41675V3.54175C11.8643 3.83216 11.6234 4.073 11.333 4.073Z" fill="#07C865"/>
<path d="M10.6247 8.323H4.95801C4.66759 8.323 4.42676 8.08216 4.42676 7.79175C4.42676 7.50133 4.66759 7.2605 4.95801 7.2605H10.6247C10.9151 7.2605 11.1559 7.50133 11.1559 7.79175C11.1559 8.08216 10.9151 8.323 10.6247 8.323Z" fill="#07C865"/>
<path d="M8.49967 11.1562H4.95801C4.66759 11.1562 4.42676 10.9154 4.42676 10.625C4.42676 10.3346 4.66759 10.0938 4.95801 10.0938H8.49967C8.79009 10.0938 9.03092 10.3346 9.03092 10.625C9.03092 10.9154 8.79009 11.1562 8.49967 11.1562Z" fill="#07C865"/>
<path d="M10.625 16.1147H6.375C2.39417 16.1147 1.59375 14.2376 1.59375 11.2059V6.8355C1.59375 3.478 2.72708 2.11091 5.63833 1.948H11.3333C14.2729 2.11091 15.4062 3.478 15.4062 6.8355V11.3334C15.4062 11.6238 15.1654 11.8647 14.875 11.8647C14.5846 11.8647 14.3437 11.6238 14.3437 11.3334V6.8355C14.3437 3.74716 13.3167 3.12383 11.305 3.0105H5.66667C3.68333 3.12383 2.65625 3.74716 2.65625 6.8355V11.2059C2.65625 13.9188 3.17333 15.0522 6.375 15.0522H10.625C10.9154 15.0522 11.1562 15.293 11.1562 15.5834C11.1562 15.8738 10.9154 16.1147 10.625 16.1147Z" fill="#07C865"/>
<path d="M10.625 16.1145C10.5542 16.1145 10.4904 16.1003 10.4196 16.072C10.2213 15.987 10.0938 15.7958 10.0938 15.5833V13.4583C10.0938 11.7441 11.0358 10.802 12.75 10.802H14.875C15.0875 10.802 15.2858 10.9295 15.3638 11.1278C15.4488 11.3262 15.3992 11.5528 15.2504 11.7087L11.0004 15.9587C10.9012 16.0578 10.7667 16.1145 10.625 16.1145ZM12.75 11.8645C11.6308 11.8645 11.1562 12.3391 11.1562 13.4583V14.3012L13.5929 11.8645H12.75Z" fill="#07C865"/>
</svg>';

$doc_icon = '<svg width="17" height="17" viewBox="0 0 17 17" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.50033 15.64C8.28783 15.64 8.07533 15.5904 7.89824 15.4912C6.57366 14.7687 4.24324 14.0037 2.78408 13.8125L2.57866 13.7842C1.65074 13.6708 0.885742 12.7996 0.885742 11.8575V3.30082C0.885742 2.74123 1.10533 2.23124 1.50908 1.8629C1.91283 1.49457 2.43699 1.31749 2.98949 1.36707C4.54783 1.48749 6.89949 2.26665 8.23116 3.10249L8.40116 3.20165C8.45074 3.22998 8.55699 3.22999 8.59949 3.20874L8.71283 3.1379C10.0445 2.30207 12.3962 1.50874 13.9616 1.37415C13.9757 1.37415 14.0324 1.37415 14.0466 1.37415C14.5637 1.32457 15.0949 1.50874 15.4916 1.87707C15.8953 2.2454 16.1149 2.7554 16.1149 3.31498V11.8646C16.1149 12.8137 15.3499 13.6779 14.4149 13.7912L14.1812 13.8196C12.722 14.0108 10.3845 14.7829 9.08824 15.4983C8.91824 15.5975 8.71283 15.64 8.50033 15.64ZM2.81949 2.42249C2.59283 2.42249 2.38741 2.5004 2.22449 2.64915C2.04741 2.81207 1.94824 3.04582 1.94824 3.30082V11.8575C1.94824 12.2754 2.30949 12.6792 2.71324 12.7358L2.92574 12.7642C4.51949 12.9767 6.96324 13.7771 8.37991 14.5492C8.44366 14.5775 8.53574 14.5846 8.57116 14.5704C9.98783 13.7842 12.4457 12.9767 14.0466 12.7642L14.2874 12.7358C14.6912 12.6862 15.0524 12.2754 15.0524 11.8575V3.3079C15.0524 3.04582 14.9532 2.81915 14.7762 2.64915C14.592 2.48624 14.3582 2.40832 14.0962 2.42249C14.082 2.42249 14.0253 2.42249 14.0112 2.42249C12.6582 2.5429 10.4766 3.27249 9.28658 4.01624L9.17324 4.09415C8.78366 4.33499 8.23116 4.33498 7.85574 4.10123L7.68574 4.00207C6.47449 3.25832 4.29283 2.53582 2.90449 2.42249C2.87616 2.42249 2.84783 2.42249 2.81949 2.42249Z" fill="#07C865"/>
<path d="M8.5 15.0449C8.20958 15.0449 7.96875 14.8041 7.96875 14.5137V3.88867C7.96875 3.59826 8.20958 3.35742 8.5 3.35742C8.79042 3.35742 9.03125 3.59826 9.03125 3.88867V14.5137C9.03125 14.8112 8.79042 15.0449 8.5 15.0449Z" fill="#07C865"/>
<path d="M5.48926 6.54492H3.89551C3.60509 6.54492 3.36426 6.30409 3.36426 6.01367C3.36426 5.72326 3.60509 5.48242 3.89551 5.48242H5.48926C5.77967 5.48242 6.02051 5.72326 6.02051 6.01367C6.02051 6.30409 5.77967 6.54492 5.48926 6.54492Z" fill="#07C865"/>
<path d="M6.02051 8.66992H3.89551C3.60509 8.66992 3.36426 8.42909 3.36426 8.13867C3.36426 7.84826 3.60509 7.60742 3.89551 7.60742H6.02051C6.31092 7.60742 6.55176 7.84826 6.55176 8.13867C6.55176 8.42909 6.31092 8.66992 6.02051 8.66992Z" fill="#07C865"/>
</svg>';

$vide_icon = '<svg width="17" height="17" viewBox="0 0 17 17" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10.6248 16.1146H6.37484C2.52859 16.1146 0.885254 14.4713 0.885254 10.625V6.37501C0.885254 2.52876 2.52859 0.885422 6.37484 0.885422H10.6248C14.4711 0.885422 16.1144 2.52876 16.1144 6.37501V10.625C16.1144 14.4713 14.4711 16.1146 10.6248 16.1146ZM6.37484 1.94792C3.10942 1.94792 1.94775 3.10959 1.94775 6.37501V10.625C1.94775 13.8904 3.10942 15.0521 6.37484 15.0521H10.6248C13.8903 15.0521 15.0519 13.8904 15.0519 10.625V6.37501C15.0519 3.10959 13.8903 1.94792 10.6248 1.94792H6.37484Z" fill="#07C865"/>
<path d="M7.62188 11.5954C7.32438 11.5954 7.04813 11.5246 6.80021 11.3829C6.23355 11.0571 5.90771 10.3912 5.90771 9.54833V7.45167C5.90771 6.61583 6.23355 5.94292 6.80021 5.61708C7.36688 5.29125 8.10355 5.34083 8.83313 5.76583L10.6535 6.81417C11.376 7.23208 11.794 7.84833 11.794 8.5C11.794 9.15167 11.376 9.76792 10.6535 10.1858L8.83313 11.2342C8.4223 11.475 8.00438 11.5954 7.62188 11.5954ZM7.62897 6.46708C7.51563 6.46708 7.41646 6.48833 7.33855 6.53792C7.11188 6.6725 6.9773 7.00542 6.9773 7.45167V9.54833C6.9773 9.99458 7.1048 10.3275 7.33855 10.4621C7.56521 10.5967 7.91938 10.54 8.30896 10.3133L10.1294 9.265C10.519 9.03833 10.7385 8.76208 10.7385 8.5C10.7385 8.23792 10.519 7.95458 10.1294 7.735L8.30896 6.68667C8.05396 6.53792 7.82022 6.46708 7.62897 6.46708Z" fill="#07C865"/>
</svg>';

$security_icon = '<svg width="17" height="17" viewBox="0 0 17 17" fill="none" xmlns="http://www.w3.org/2000/svg">
<path opacity="0.4" d="M12.9837 4.01609L4.6679 12.3319C4.35623 12.6436 3.83206 12.6011 3.57706 12.2327C2.69872 10.9507 2.18164 9.43482 2.18164 7.87649V4.76692C2.18164 4.18608 2.62081 3.52734 3.15914 3.30775L7.10457 1.69275C7.99707 1.32442 8.98874 1.32442 9.88124 1.69275L12.7429 2.8615C13.2175 3.05275 13.3379 3.66192 12.9837 4.01609Z" fill="#07C865"/>
<path d="M13.6494 4.98665C14.1098 4.59707 14.8111 4.92998 14.8111 5.53206V7.87664C14.8111 11.3404 12.2965 14.5846 8.8611 15.5337C8.62735 15.5975 8.37235 15.5975 8.13152 15.5337C7.12569 15.2504 6.19067 14.7758 5.39025 14.1525C5.05025 13.8904 5.01485 13.3946 5.31235 13.09C6.85651 11.5104 11.3757 6.90624 13.6494 4.98665Z" fill="#07C865"/>
</svg>
';

$child_icon = '<svg width="17" height="17" viewBox="0 0 17 17" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.5834 4.04458V10.8304C15.5834 12.7854 13.9967 14.3721 12.0417 14.3721H4.95839C4.63256 14.3721 4.32089 14.3296 4.01631 14.2446C3.57714 14.1242 3.43548 13.5646 3.76131 13.2387L11.2909 5.70916C11.4467 5.55333 11.6805 5.51791 11.9001 5.56041C12.1267 5.60291 12.3746 5.53916 12.5517 5.36916L14.3721 3.54166C15.038 2.87583 15.5834 3.09541 15.5834 4.04458Z" fill="#07C865"></path>
<path opacity="0.4" d="M10.3701 5.21333L2.95383 12.6296C2.61383 12.9696 2.04716 12.8846 1.8205 12.4596C1.55841 11.9779 1.41675 11.4183 1.41675 10.8304V4.04458C1.41675 3.09542 1.96216 2.87583 2.628 3.54167L4.4555 5.37625C4.73175 5.64542 5.18508 5.64542 5.46133 5.37625L7.99716 2.83333C8.27341 2.55708 8.72675 2.55708 9.003 2.83333L10.3772 4.2075C10.6463 4.48375 10.6463 4.93708 10.3701 5.21333Z" fill="#07C865"></path>
</svg>';

$speed_icon = '<svg width="17" height="17" viewBox="0 0 17 17" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.49995 2.59958V14.4004L7.93328 15.045C7.14703 15.9375 6.50245 15.6967 6.50245 14.5067V9.40666H4.3137C3.32203 9.40666 3.04578 8.7975 3.70453 8.05375L8.49995 2.59958Z" fill="#07C865"></path>
<path opacity="0.4" d="M13.2954 8.94625L8.5 14.4004V2.59958L9.06667 1.955C9.85292 1.0625 10.4975 1.30333 10.4975 2.49333V7.59333H12.6862C13.6779 7.59333 13.9542 8.2025 13.2954 8.94625Z" fill="#07C865"></path>
</svg>
';

  $tabs = [
    [
      'label' => 'لیست تغیرات',
      'url' =>  'https://parskalas.com/docs/changelog',
      'icon'  => $changelog_icon,
    ],
    [
      'label' => 'مستندات آنلاین',
      'url' =>  'https://parskalas.com/docs',
      'icon'  => $doc_icon,
    ],
    [
      'label' => 'ویدیو های آموزشی',
      'url' =>  'https://www.rtl-theme.com/parskala-wordpress-theme/manuals/',
      'icon'  => $vide_icon,
    ],
    [
      'label' => 'امنیت سایت',
      'slug' =>  'جعبه-ابزار/پوسته-فرزند',
      'icon'  => $security_icon,
    ],
    [
      'label' => 'پوسته فرزند',
      'slug' =>  'جعبه-ابزار/پوسته-فرزند',
      'icon'  => $child_icon,
    ],
    [
      'label' => 'بهینه سازی',
      'slug' =>  'جعبه-ابزار/پوسته-فرزند',
      'icon'  => $speed_icon,
    ],
  ];


  echo '<ul class="feature-list ">';
  foreach ($tabs as $tab) {
    $is_external = !empty($tab['url']);

    $slug = '';
    if (!$is_external && !empty($tab['slug'])) {
      $slug_raw = preg_replace('/[‌\s]+/u', '-', $tab['slug']);
      $slug = prk_sanitize_slug($slug_raw);
    }

    echo '<li class="csf-tab-item">';

    if ($is_external) {
      echo '<a href="' . esc_url($tab['url']) . '" target="_blank">';
    } else {
      echo '<a href="#tab=' . esc_attr($slug) . '" data-tab-id="' . esc_attr($slug) . '">';
    }

    echo '<i class="toolbox">' . $tab['icon'] . '</i>';
    echo '<span>' . esc_html($tab['label']) . '</span>';
    echo '</a>';

    echo '</li>';
  }
  echo '</ul>';

}


function prk_sanitize_slug($slug) {
  // تبدیل فاصله و ZWNJ به "-"
  $slug = preg_replace('/[‌\s]+/u', '-', $slug);

  // تبدیل "--" به "/" برای شبیه‌سازی زیرمنو
  $slug = str_replace('--', '/', $slug);

  // همون کاری که sanitize_title برای Codestar میکنه: حروف خاص حذف، فقط نگه‌داشتن حروف و اعداد و -
  $slug_parts = explode('/', $slug); // برای حفظ زیرشاخه‌ها
  $slug_parts = array_map(function($part) {
    return sanitize_title($part);
  }, $slug_parts);

  return implode('/', $slug_parts);
}

?>

<div class="main-content prk-hob">

        <section class="feature-section">

          <div class="quick-access-box">

            <h3 class="feature-title heading-3">دسترسی های سریع</h3>

            <?= render_tab_shortcuts(); ?>

          </div>


          <div class="tools-box">

            <h3 class="feature-title heading-3">ابزار ها</h3>

            <?= render_feature_tab_shortcuts(); ?>

            
          </div>

        </section>


        <section class="messages">

          <div class="messages-card">

            <div class="messages-text">
              <h4 class="messages-title heading-3">اطلاعیه های جدید</h4>
              <?= prk_display_latest_announcements(); ?>
            </div>

            <div class="messages-banner">

            <img class="bammer-img" width="110px" src="<?= get_parent_theme_file_uri('app/admin/assets/img/banner-news.svg' );?>" alt="banner news">

              <p>

               <img src="<?= get_parent_theme_file_uri('app/admin/assets/img/banner-title1.svg' );?>" alt="banner title 2">

              </p>
            </div>
          </div>


          <div class="messages-card">
            <div class="messages-text">
              <h4 class="messages-title heading-3 messages-update-title">در نسخه بعدی چه خبر است؟!</h4>

              <?= prk_display_next_update_info(); ?>

            </div>

            <div class="messages-banner messages-banner-update">
     
            <img class="bammer-img" width="120px" src="<?= get_parent_theme_file_uri('app/admin/assets/img/banner-update.svg' );?>" alt="banner next update">

              <p class="messages-banner-update-text">

              <img src="<?= get_parent_theme_file_uri('app/admin/assets/img/banner-title2.svg' );?>" alt="banner title 2">

              </p>

            </div>
          </div>

        </section>

      </div>