<?php
$tabs = \prk\Admin\Studio::get_filter_tabs();
$demos = \prk\Admin\Studio_Demo::get_demo_list();
$demo_options = \prk\Admin\Studio_Demo::get_demo_options();
$demo_base_url = '';
$tabs_cls_arr = array_map(function ($i) {
  return "." . $i;
}, array_keys($tabs));


?>




<section class="demo-section">

  <div class="demo-header">

    <h3 class="demo-title heading-3">سایت های آماده</h3>


    <div class="demo-search">
      <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path
          d="M7.66659 14C11.1644 14 13.9999 11.1645 13.9999 7.66668C13.9999 4.16887 11.1644 1.33334 7.66659 1.33334C4.16878 1.33334 1.33325 4.16887 1.33325 7.66668C1.33325 11.1645 4.16878 14 7.66659 14Z"
          stroke="#DBDBDC" stroke-linecap="round" stroke-linejoin="round" />
        <path d="M14.6666 14.6667L13.3333 13.3333" stroke="#DBDBDC" stroke-linecap="round"
          stroke-linejoin="round" />
      </svg>

      <input class="demo-search-input" type="text" placeholder="جستجوی نام دمو">
    </div>

  </div>

  <!-- تب سایت های از پیش ساخته -->
  <div class="prk-filter-tabs">

    <ul class="demo-categories">

      <li class="demo-category active">
        <a href="javascript:void()" data-filter="<?php echo implode(',', $tabs_cls_arr) ?>"><?php echo esc_attr__('همه', 'parskala') ?></a>
      </li>

      <?php foreach ($tabs as $key => $value): ?>
        <li class="demo-category">
          <a href="javascript:void()" data-filter=".<?php echo $key ?>"><?php echo $value ?></a>
        <?php endforeach; ?>
        </li>

    </ul>

  </div>

  <?php if ($demos): ?>

    <div class="demo-list">

      <!--  آیتم نصب دموها -->
      <?php
      $i = 0;
      foreach ($demos as $demo):
        $title = $demo['import_file_name'];
        $cat = isset($demo['import_demo_cat']) ? $demo['import_demo_cat'] : '';
        $name = isset($demo['import_demo_name']) ? $demo['import_demo_name'] : '';
        $demo_slug = isset($demo['import_demo_id']) ? $demo['import_demo_id'] : $name;
        $demo_img = isset($demo['import_demo_img']) ? $demo['import_demo_img'] : '';
        $preview_url = isset($demo['preview_url']) ? $demo['preview_url'] : '';
      ?>
        <div class="demo-item filter-item <?php echo $cat ?>" data-cat="<?php echo $cat ?>">

          <div class="demo-item-img">
            <img src="<?= $demo_img ?>" alt="demo">
          </div>

          <h6 class="demo-item-title"><?= $title ?></h6>

          <div class="demo-item-actions">
            <button id="open-popup" data-modal-id="popup-<?= $demo_slug ?>" class="demo-install-btn" type="button">
              <svg width="9" height="10" viewBox="0 0 9 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M3.375 4.293V6.543L4.125 5.793" stroke="#07C865" stroke-width="0.5625"
                  stroke-linecap="round" stroke-linejoin="round" />
                <path d="M3.375 6.543L2.625 5.793" stroke="#07C865" stroke-width="0.5625" stroke-linecap="round"
                  stroke-linejoin="round" />
                <path
                  d="M8.25 3.918V5.793C8.25 7.668 7.5 8.418 5.625 8.418H3.375C1.5 8.418 0.75 7.668 0.75 5.793V3.543C0.75 1.668 1.5 0.917999 3.375 0.917999H5.25"
                  stroke="#07C865" stroke-width="0.5625" stroke-linecap="round" stroke-linejoin="round" />
                <path d="M8.25 3.918H6.75C5.625 3.918 5.25 3.543 5.25 2.418V0.917999L8.25 3.918Z" stroke="#07C865"
                  stroke-width="0.5625" stroke-linecap="round" stroke-linejoin="round" />
              </svg>

              نصب دمو
            </button>
            <a class="demo-preview-link" href="<?= $preview_url ?>" target="_blank">
              <svg width="10" height="11" viewBox="0 0 10 11" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path
                  d="M6.49163 5.16801C6.49163 5.99301 5.82497 6.65967 4.99997 6.65967C4.17497 6.65967 3.5083 5.99301 3.5083 5.16801C3.5083 4.343 4.17497 3.67634 4.99997 3.67634C5.82497 3.67634 6.49163 4.343 6.49163 5.16801Z"
                  stroke="black" stroke-width="0.625" stroke-linecap="round" stroke-linejoin="round" />
                <path
                  d="M5.00018 8.61386C6.47101 8.61386 7.84185 7.74719 8.79601 6.24719C9.17101 5.65969 9.17101 4.67219 8.79601 4.08469C7.84185 2.58469 6.47101 1.71803 5.00018 1.71803C3.52935 1.71803 2.15851 2.58469 1.20435 4.08469C0.829346 4.67219 0.829346 5.65969 1.20435 6.24719C2.15851 7.74719 3.52935 8.61386 5.00018 8.61386Z"
                  stroke="black" stroke-width="0.625" stroke-linecap="round" stroke-linejoin="round" />
              </svg>

              پیش نمایش
            </a>
          </div>

        </div>
      <?php $i++;
      endforeach; ?>


      <!-- پاپ آپ نصب دموها -->
      <?php
      $i = 0;
      foreach ($demos as $demo):
        $title = $demo['import_file_name'];
        $cat = isset($demo['import_demo_cat']) ? $demo['import_demo_cat'] : '';
        $name = isset($demo['import_demo_name']) ? $demo['import_demo_name'] : '';
        $demo_slug = isset($demo['import_demo_id']) ? $demo['import_demo_id'] : $name;
        $demo_img = isset($demo['import_demo_img']) ? $demo['import_demo_img'] : '';
        $preview_url = isset($demo['preview_url']) ? $demo['preview_url'] : '';
      ?>
      
        <div id="popup-<?= $demo_slug ?>" class="popup" data-popup-id="<?= $demo_slug ?>">
        
          <div class="demo-upload-options">

            <div class="demo-upload-options-header">
              <div class="demo-upload-options-header-text">
                <h3 class="heading-3">درون ریز محتوای دمو</h3>
                <p class="subtext"><?= $title ?></p>
              </div>
              <div class="demo-warning demo-install-warning">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path d="M12 13.75C11.59 13.75 11.25 13.41 11.25 13V7.75C11.25 7.34 11.59 7 12 7C12.41 7 12.75 7.34 12.75 7.75V13C12.75 13.41 12.41 13.75 12 13.75Z" fill="#FFA802" />
                  <path d="M12 17.25C11.73 17.25 11.48 17.15 11.29 16.96C11.2 16.86 11.13 16.75 11.07 16.63C11.02 16.51 11 16.38 11 16.25C11 15.99 11.11 15.73 11.29 15.54C11.66 15.17 12.34 15.17 12.71 15.54C12.89 15.73 13 15.99 13 16.25C13 16.38 12.97 16.51 12.92 16.63C12.87 16.75 12.8 16.86 12.71 16.96C12.52 17.15 12.27 17.25 12 17.25Z" fill="#FFA802" />
                  <path d="M12.0002 22.75C11.3302 22.75 10.6502 22.58 10.0502 22.23L4.11017 18.8C2.91017 18.1 2.16016 16.81 2.16016 15.42V8.57999C2.16016 7.18999 2.91017 5.89999 4.11017 5.19999L10.0502 1.77C11.2502 1.07 12.7402 1.07 13.9502 1.77L19.8902 5.19999C21.0902 5.89999 21.8402 7.18999 21.8402 8.57999V15.42C21.8402 16.81 21.0902 18.1 19.8902 18.8L13.9502 22.23C13.3502 22.58 12.6702 22.75 12.0002 22.75ZM12.0002 2.74998C11.5902 2.74998 11.1702 2.85998 10.8002 3.06998L4.86017 6.49998C4.12017 6.92998 3.66016 7.71999 3.66016 8.57999V15.42C3.66016 16.27 4.12017 17.07 4.86017 17.5L10.8002 20.93C11.5402 21.36 12.4602 21.36 13.1902 20.93L19.1302 17.5C19.8702 17.07 20.3302 16.28 20.3302 15.42V8.57999C20.3302 7.72999 19.8702 6.92998 19.1302 6.49998L13.1902 3.06998C12.8302 2.85998 12.4102 2.74998 12.0002 2.74998Z" fill="#FFA802" />
                </svg>

                <p>نصب دمو ممکن است زمان بر باشد ، از بستن صفحه خودداری کنید!</p>
              </div>
            </div>

            <div class="main-upload-options-box">
              <div class="upload-options-box">
                <div class="upload-options-img">
                  <img src="<?= $demo_img ?>" alt="img">

                  <div class="demo-loader MuiBox-root"
                    style="transform: none; transition: transform 225ms cubic-bezier(0.4, 0, 0.2, 1);">
                    <div class="demo-loader-box MuiBox-root css-uuvmrc">
                      <div class="demo-loader-logo MuiBox-root css-0">پارس کالا</div>
                    </div>
                    <div class="demo-loader-box MuiBox-root css-142rqe3"></div>
                    <div class="demo-loader-box MuiBox-root css-2fh29p"></div>
                    <div class="demo-loader-box MuiBox-root css-ode1o"></div>
                    <div class="demo-loader-box MuiBox-root css-17ih97k"></div>
                    <div class="demo-loader-box MuiBox-root css-w5q0fx"></div>
                    <div class="demo-loader-box MuiBox-root css-b4ga6z"></div>
                    <div class="demo-loader-box MuiBox-root css-ynfyzx"></div>
                  </div>

                </div>



                  <?php if ($demo_options): ?>
                    <div class="filter-item-options">
                    
                      <ul class="merlin__drawer merlin__drawer--import-content js-merlin-drawer-import-content">

                        <div class="tooltip confirmationTooltip">
                          <p>
                        آیا مطمعن هستید؟
                          در صورت فعال سازی این گزینه، تمام اطلاعات سایت شما حذف خواهد شد.
                          </p>
                          <button class="confirmButton">بله</button>
                          <button class="cancelButton">لغو</button>
                        </div>

                        <?php foreach ($demo_options as $key => $value): ?>
                          <li class="merlin__drawer--import-content__list-item status status--Pending upload-option" data-content="<?php echo $key ?>">
                            <div class="round-check-wrap upload-option-box">
                              <div class="round-check upload-option-checkbox">
                                <input type="checkbox" name="default_content[<?php echo $key ?>]" class="checkbox checkbox-<?php echo $key ?><?= $key == 'reset' ? ' deleteCheckbox' : ''; ?>" id="default_content_<?php echo $key ?>_<?php echo $demo_slug ?>"
                                value="1" >
                                <label for="default_content_<?php echo $key ?>_<?php echo $demo_slug ?>" class="upload-option-lbl"></label>
                              </div>
                              <label for="default_content_<?php echo $key ?>_<?php echo $demo_slug ?>" class="upload-options-txt">
                                <i></i><span><?php echo $value ?></span>
                              </label>
                            </div>
                          </li>
                        
                        <?php endforeach; ?>

                      </ul>

                    </div>
                  <?php endif; ?>

              </div>

              <div class="progress-box">
                <div class="progress-bar">
                  <span class="progress-bar-fill btn-progress"></span>
                </div>

                <p class="progress-percentage"></p>

              </div>

              <div class="demo-warning damo-lose-content-warning">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path d="M12 13.75C11.59 13.75 11.25 13.41 11.25 13V7.75C11.25 7.34 11.59 7 12 7C12.41 7 12.75 7.34 12.75 7.75V13C12.75 13.41 12.41 13.75 12 13.75Z" fill="#FFA802" />
                  <path d="M12 17.25C11.73 17.25 11.48 17.15 11.29 16.96C11.2 16.86 11.13 16.75 11.07 16.63C11.02 16.51 11 16.38 11 16.25C11 15.99 11.11 15.73 11.29 15.54C11.66 15.17 12.34 15.17 12.71 15.54C12.89 15.73 13 15.99 13 16.25C13 16.38 12.97 16.51 12.92 16.63C12.87 16.75 12.8 16.86 12.71 16.96C12.52 17.15 12.27 17.25 12 17.25Z" fill="#FFA802" />
                  <path d="M12.0002 22.75C11.3302 22.75 10.6502 22.58 10.0502 22.23L4.11017 18.8C2.91017 18.1 2.16016 16.81 2.16016 15.42V8.57999C2.16016 7.18999 2.91017 5.89999 4.11017 5.19999L10.0502 1.77C11.2502 1.07 12.7402 1.07 13.9502 1.77L19.8902 5.19999C21.0902 5.89999 21.8402 7.18999 21.8402 8.57999V15.42C21.8402 16.81 21.0902 18.1 19.8902 18.8L13.9502 22.23C13.3502 22.58 12.6702 22.75 12.0002 22.75ZM12.0002 2.74998C11.5902 2.74998 11.1702 2.85998 10.8002 3.06998L4.86017 6.49998C4.12017 6.92998 3.66016 7.71999 3.66016 8.57999V15.42C3.66016 16.27 4.12017 17.07 4.86017 17.5L10.8002 20.93C11.5402 21.36 12.4602 21.36 13.1902 20.93L19.1302 17.5C19.8702 17.07 20.3302 16.28 20.3302 15.42V8.57999C20.3302 7.72999 19.8702 6.92998 19.1302 6.49998L13.1902 3.06998C12.8302 2.85998 12.4102 2.74998 12.0002 2.74998Z" fill="#FFA802" />
                </svg>

                <p>توجه : اگر محتوای مهمی دارید، یک نسخه پشتیبان تهیه کنید ، زیرا محتوای فعلی سایت شما حذف خواهد شد!</p>
              </div>
            </div>

            <!-- .border-top اضافه کردن هنگامی که فرایند نصب در حال انجام نیست -->
            <div class="upload-option-actions">
              <a class="demo-preview-link" href="<?= $preview_url ?>">
                <svg width="10" height="11" viewBox="0 0 10 11" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path
                    d="M6.49163 5.16801C6.49163 5.99301 5.82497 6.65967 4.99997 6.65967C4.17497 6.65967 3.5083 5.99301 3.5083 5.16801C3.5083 4.343 4.17497 3.67634 4.99997 3.67634C5.82497 3.67634 6.49163 4.343 6.49163 5.16801Z"
                    stroke="black" stroke-width="0.625" stroke-linecap="round" stroke-linejoin="round" />
                  <path
                    d="M5.00018 8.61386C6.47101 8.61386 7.84185 7.74719 8.79601 6.24719C9.17101 5.65969 9.17101 4.67219 8.79601 4.08469C7.84185 2.58469 6.47101 1.71803 5.00018 1.71803C3.52935 1.71803 2.15851 2.58469 1.20435 4.08469C0.829346 4.67219 0.829346 5.65969 1.20435 6.24719C2.15851 7.74719 3.52935 8.61386 5.00018 8.61386Z"
                    stroke="black" stroke-width="0.625" stroke-linecap="round" stroke-linejoin="round" />
                </svg>

                پیش نمایش
              </a>

              <div class="upload-option-actions-button">
                <button class="install-btn" type="button"
                  data-callback="install_content"
                  data-demo-title="<?php echo $title ?>"
                  data-demo-id="<?php echo $i ?>"
                  data-demo-slug="<?php echo $demo_slug ?>"
                  data-demo-name="<?php echo $name ?>">
                  <span class="install-btn-text studio-install-demo">شروع نصب</span>
                  <div class="loading-dots install-btn-progress-dots">
                    <span></span>
                    <span></span>
                    <span></span>
                  </div>
                </button>
                <button class="cancel-btn" type="button">لغو</button>
              </div>
            </div>

          </div>

        </div>

      <?php $i++;
      endforeach; ?>

    </div>

  <?php endif; ?>

</section>







<script>
  var openPopupButtons = document.querySelectorAll(".demo-install-btn");
  var closePopupButtons = document.querySelectorAll(".cancel-btn");

  openPopupButtons.forEach(function(button) {
    button.onclick = function() {
      const modalId = button.getAttribute('data-modal-id');
      const modal = document.getElementById(modalId);
      document.body.classList.add('scroll-hidden');
      modal.classList.add('show');
    }
  });

  closePopupButtons.forEach(function(button) {
    button.onclick = function() {
      const modal = button.closest('.popup');
      if (modal.classList.contains('installing')) {
        return;
      } else {
        document.body.classList.remove('scroll-hidden');
        modal.classList.remove('show');
      }
    }
  });


  window.onclick = function(event) {
    document.querySelectorAll(".popup").forEach(function(popup) {
      if (event.target == popup) {
        if (popup.classList.contains('installing')) {
          return;
        } else {
          document.body.classList.remove('scroll-hidden');
          popup.classList.remove('show');
        }
      }
    })
  }

  document.addEventListener('keydown', function(event) {
    if (event.key === 'Escape' || event.key === 'Esc') {
      document.querySelectorAll(".popup").forEach(function(popup) {
        if (popup.classList.contains('show')) {
          if (popup.classList.contains('installing')) {
            return;
          } else {
            document.body.classList.remove('scroll-hidden');
            popup.classList.remove('show');
          }
        }
      });
    }
  });
</script>

<script>
  // شناسایی چک باکس اصلی
  var checkboxes = document.querySelectorAll('.checkbox');

  checkboxes.forEach(function(checkbox) {
    if (checkbox.classList.contains('deleteCheckbox')) {
      return
    } else {
      checkbox.checked = true;
      checkbox.setAttribute('checked', 'checked');
      checkbox.setAttribute('value', '1');
    }
  })

  checkboxes.forEach(checkbox => {
        checkbox.addEventListener('change', function () {
            if (this.checked) {
            
              this.setAttribute('checked', 'checked');
              this.setAttribute('value', '1');
            } else {
        
              this.removeAttribute('checked');
              this.setAttribute('value', '0');
            }
        });
    });

</script>

<script>
  function initInstallGroups() {
    const installGroups = document.querySelectorAll('.demo-upload-options');

    installGroups.forEach(group => {
      const progressPercentage = group.querySelector('.progress-percentage');
      const btnProgress = group.querySelector('.btn-progress');
      const demoLoader = group.querySelector('.demo-loader');
      const installBtnText = group.querySelector('.install-btn-text');
      const installBtnProgressDots = group.querySelector('.install-btn-progress-dots');
      const popup = group.closest('.popup');

      let lastProgress = -1;

      function updateProgress() {
        const btnWidth = btnProgress.style.width || "0%";
        const percentage = parseInt(btnWidth);

        // const percentage = parseInt(btnProgress.dataset.progress || "0");
        // const percentage = parseInt(btnProgress.getAttribute('percent') || "0");

        // progressPercentage.textContent = btnWidth;

        if (percentage !== lastProgress) {
          lastProgress = percentage;

          // آپدیت درصد و نوار
          progressPercentage.textContent = percentage + "%";
          //   btnProgress.style.width = percentage + "%";

          // مدیریت حالات نصب
          if (percentage > 0 && percentage <= 50) {
            demoLoader.classList.remove('v-hidden', 'css-after80', 'css-after50');
            demoLoader.classList.add('css-before50');
            installBtnProgressDots.classList.add('show');
            installBtnText.textContent = 'در حال نصب';
            popup.classList.add('installing');
            
          } else if (percentage > 50 && percentage <= 93) {
            demoLoader.classList.remove('v-hidden', 'css-before50', 'css-after80');
            demoLoader.classList.add('css-after50');
            installBtnProgressDots.classList.add('show');
            installBtnText.textContent = 'در حال نصب';
            popup.classList.add('installing');
          } else if (percentage > 93) {
            demoLoader.classList.remove('v-hidden', 'css-after50', 'css-before50');
            demoLoader.classList.add('css-after80');
            installBtnProgressDots.classList.add('show');
            installBtnText.textContent = 'در حال نصب';
            popup.classList.add('installing');
          } else {
            demoLoader.classList.add('v-hidden');
            installBtnProgressDots.classList.remove('show');
            installBtnText.textContent = 'شروع نصب';
            popup.classList.remove('installing');
          }
        }

        requestAnimationFrame(updateProgress);
      }

      updateProgress();
    });
  }

  initInstallGroups();
</script>

<script>
  document.querySelectorAll('.deleteCheckbox').forEach(function(deleteCheckbox) {
    deleteCheckbox.addEventListener('click', function(event) {
      if (this.checked) {
        const parentPopup = this.closest('div[id^="popup-"]'); // پیدا کردن پاپ‌آپ یونیک
        const tooltip = parentPopup.querySelector('.confirmationTooltip');

        if (tooltip) {
          tooltip.style.display = 'block';
          event.preventDefault(); // جلوگیری از انتخاب چک‌باکس
        }
      } else {        
        this.checked = false;
        this.removeAttribute('checked');
        this.setAttribute('value', '0');
      }
    });
  });

  document.querySelectorAll('.confirmButton').forEach(function(confirmButton) {
    confirmButton.addEventListener('click', function(e) {
      e.preventDefault();
      const tooltip = this.closest('.confirmationTooltip');
      const parentPopup = tooltip.closest('div[id^="popup-"]');
      const checkbox = parentPopup.querySelector('.deleteCheckbox');

      if (checkbox) {
        checkbox.checked = true;
        checkbox.setAttribute('checked', 'checked');
        checkbox.setAttribute('value', '1');
      }

      tooltip.style.display = 'none';
    });
  });

  document.querySelectorAll('.cancelButton').forEach(function(cancelButton) {
    cancelButton.addEventListener('click', function(e) {
      e.preventDefault();
      const tooltip = this.closest('.confirmationTooltip');
      tooltip.style.display = 'none';
    });
  });
</script>