<?php
/**
 * Plugins Template
 *
 * @package YourThemeName
 */
?>


<section class="plugins-section">

    <div class="plugins-section-header">

        <h3 class="plugins-section-title heading-3">
            <?php esc_html_e( 'فعال سازی افزونه ها', 'parskala' ); ?>
        </h3>
        
        <p class="plugins-section-subtitle">
            <?php esc_html_e( 'افزونه ها را برای سایت خود نصب و فعال کنید.', 'parskala' ); ?>
        </p>
        
    </div>



    <div class="plugins-list">

    <?php foreach ( $plugins as $slug => $plugin ) : ?>

        <div class="prk-plugin-wrapper plugin-item plugin-item-disable">

            <div class="plugin-item-status">

                <?php if ( $plugin['status'] === 'deactivate' ) : ?>

                    <span class="plugin-item-status-active">
                        <?php esc_html_e( 'فعال شده', 'parskala' ); ?>
                    </span>

                <?php elseif ( isset( $plugin['required'] ) && $plugin['required'] ) : ?>

                    <span class="plugin-item-status-required">
                        <?php esc_html_e( 'ضروری', 'parskala' ); ?>
                    </span>

                <?php endif; ?>

                <span class="plugin-item-status-version">
                <?php echo esc_html( $plugin['version'] ); ?>
                </span>

            </div>

            <div class="plugin-item-icon-box">
                <div class="plugin-item-icon">

                    <img
                    src="<?php echo esc_url( parskala_URI . '/app/Admin/assets/img/' . $plugin['slug'] . '.png' ); ?>"
                    alt="<?php esc_attr_e( 'preview', 'parskala' ); ?>"
                    >

                </div>
            </div>

            <h6 class="plugin-item-name"><?php echo esc_html( $plugin['name'] ); ?></h6>

            <div class="plugin-item-action">

                <?php if ( is_plugin_active_for_network( $plugin['file_path'] ) ) : ?>

                    <?php esc_html_e( 'Plugin activated globally.', 'xts-theme' ); ?>

                <?php elseif ( 'require_update' !== $plugin['status'] ) : ?>

                    <a class="plugin-disable-btn prk-ajax-plugin prk-<?php echo esc_html( $plugin['status'] ); ?>-now"
                        href="<?php echo esc_url( $this->get_action_url( $slug, $plugin['status'] ) ); ?>"
                        data-plugin="<?php echo esc_attr( $slug ); ?>"
                        data-action="<?php echo esc_attr( $plugin['status'] ); ?>">

                        <span><?php echo esc_html( $this->get_action_text( $plugin['status'] ) ); ?></span>

                    </a>

                <?php else : ?>

                    <?php esc_html_e( 'Required Update not Available', 'xts-theme' ); ?>

                <?php endif; ?>

            </div>


        </div>

    <?php endforeach; ?>

    
    <script>
        var xtsPluginsData = <?php echo wp_json_encode( $plugins ); ?>
    </script>

    <div class="prk-plugin-response"></div>

    </div>

     <div class="plugins-section-footer<?php echo esc_attr( $classes ); ?>">

     <p class="plugins-section-text">فعال سازی گروهی تمامی افزونه های مکمل پوسـته.</p>
     <button class="plugins-enable-all-btn prk-ajax-all-plugins" type="button">فعال سازی همه</button>

     </div>

</section>
