<?php
namespace Prk\Admin;

class Studio_Demo extends Studio {
    protected $demo_name = 'demo';
    private $demo_id = 0;

    /**
     * 
     * Get demo list
     *
     * @return array
     * 
     */
    public static function get_demo_list(){
   
        $demos = array(
            array(
                'import_demo_id'             => '1',
                'import_demo_cat'            => 'services',
                'import_demo_name'           => 'book',
                'import_file_name'           => __('پارس کتاب','ahura'),
                'import_file_url'            => 'https://www.parskalas.com/demo/book/pars-options.xml',
                'import_widget_file_url'     => 'https://www.parskalas.com/demo/book/pars-options.wie',
                'import_customizer_file_url' => 'https://www.parskalas.com/demo/book/pars-options.dat',
                'import_demo_img'            => 'https://parskalas.com/api/demos/book/book.jpg',
                'preview_url'                => 'https://book.parskalas.com',
            ),
            array(
                'import_demo_id'             => '2',
                'import_demo_cat'            => 'shop',
                'import_demo_name'           => 'tools',
                'import_file_name'           => __('پارس ابزار','ahura'),
                'import_file_url'            => 'https://www.parskalas.com/demo/book/pars-options.xml',
                'import_widget_file_url'     => 'https://www.parskalas.com/demo/book/pars-options.wie',
                'import_customizer_file_url' => 'https://www.parskalas.com/demo/book/pars-options.dat',
                'import_demo_img'            => 'https://parskalas.com/api/demos/tools/tools.jpg',
                'preview_url'                => 'https://tools.parskalas.com',
            ),
            array(
                'import_demo_id'             => '3',
                'import_demo_cat'            => 'shop',
                'import_demo_name'           => 'game',
                'import_file_name'           => __('پارس گیم','ahura'),
                // 'import_file_url'            => 'https://www.parskalas.com/demo/book/pars-options.xml',
                // 'import_widget_file_url'     => 'https://www.parskalas.com/demo/book/pars-options.wie',
                // 'import_customizer_file_url' => 'https://www.parskalas.com/demo/book/pars-options.dat',
                'import_demo_img'            => 'https://parskalas.com/api/demos/book/book.jpg',
                'preview_url'                => 'https://game.parskalas.com',
            ),
        );

        $demos = apply_filters('ahura_studio_get_demo_list', $demos);

        return $demos;
    }

    public static function get_demo_options(){
        $options = array(
            'reset' => __('ریسیت کردن (همه اطلاعات سایت حذف خواهد شد!)', 'parskala'),
            'options' => __('آپشن پوسته', 'parskala'),
            'widgets' => __('ابزارک ها', 'parskala'),
			'media' => __('رسانه', 'parskala'),
            'content' => __('محتوا', 'parskala'),
            'after_import' => __('پیکربندی اتوماتیک', 'parskala'),
        );
        $options = apply_filters('ahura_studio_get_demo_options', $options);
        return $options;
    }

    public function set_demo_id($demo_id = 0){
        $this->demo_id = $demo_id;
        return $this;
    }

    public function get_demo_id(){
        return $this->demo_id;
    }

    public function clear_site_content()
    {
        global $wpdb;
    
        $post_types = [
            'page',
            'post',
            'product',
            'team',
            'portfolio',
            'testimonial',
            'attachment',
            'section_builder',
            'nav_menu_item',
        ];
    
        $wpdb->query('START TRANSACTION');
        try {
            // حذف همه پست تایپ‌ها
            foreach ($post_types as $post_type) {
                $wpdb->query($wpdb->prepare("DELETE FROM {$wpdb->posts} WHERE post_type = %s", $post_type));
            }
    
            // حذف متای پست‌های یتیم
            $wpdb->query("DELETE FROM {$wpdb->postmeta} WHERE post_id NOT IN (SELECT ID FROM {$wpdb->posts})");
    
            // حذف روابط و دسته‌بندی‌ها
            $wpdb->query("DELETE FROM {$wpdb->term_relationships}");
            $wpdb->query("DELETE FROM {$wpdb->term_taxonomy}");
            $wpdb->query("DELETE FROM {$wpdb->terms}");
    
            // حذف منوها
            $wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE 'nav_menu%'");
            $wpdb->query("DELETE FROM {$wpdb->term_taxonomy} WHERE taxonomy = 'nav_menu'");
    
            // ✨ حذف ابزارک‌ها (ویجت‌ها)
            $wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE 'widget_%'");
    
            // ✨ ریست تنظیمات قالب (مثلا prk_option)
            delete_option('prk_option');
    
            $wpdb->query('COMMIT');
        } catch (\Exception $e) {
            $wpdb->query('ROLLBACK');
            return false;
        }
    
        return true;
    }

    /**
     *
     * Get demo content from api
     *
     * @return boolean|array|object
     */
    public function get_demo_from_api(){
        // $demo_name  = isset($_POST['selected_demo_name']) ? $_POST['selected_demo_name'] : '' ;

        $demos = self::get_demo_list();

        $demo_id = $this->get_demo_id();

        $demo_name = isset($demos[$demo_id]) ? $demos[$demo_id]['import_demo_name'] : false;

        if (!$demo_name)
            return false;
        if (empty($demo_name))
            return false;

        $demo_url =   "https://parskalas.com/api/demos/{$demo_name}/demo.json";
        $args = ['timeout' => 300, 'sslverify' => true];
        $remote = wp_remote_get($demo_url, $args);
        $json = !is_wp_error($remote) && wp_remote_retrieve_response_code($remote) === 200 ? wp_remote_retrieve_body($remote) : false;
        return !is_wp_error($json) && ahura_is_json($json) ? $json : false;

   
    }

    /**
     *
     * Get demo content path
     *
     * @return string
     */
    public function get_demo_path(){
        $path = wp_upload_dir();
        $dir = $path['basedir'] . '/prk-import-demo/';
        if(!is_dir($dir)){
            mkdir($dir, 0755, true);
        }
        return $dir;
    }

    /**
     *
     * Get demo file path
     *
     * @return string
     */
    public function get_demo_file_path($ext = 'json'){
        return $this->get_demo_path() . $this->demo_name . '.' . $ext;
    }

    /**
     *
     * Get demo content
     *
     * @return false|mixed
     */
    public function get_demo_content(){
        $file = $this->get_demo_file_path();
        $content = file_exists($file) && is_readable($file) ? file_get_contents($file) : false;
        return $content && ahura_is_json($content) ? json_decode($content, true) : false;
    }

    /**
     *
     * Get demo content from api and save to server
     *
     * @return void
     */
    public function generate_demo_file(){
        $this->remove_demo_file();
        $json = $this->get_demo_from_api();
   
            $data = json_decode($json, true);

            $network_url = $data['extra']['network_url'];
            $home_url = $data['extra']['home_url'];
            $site_upload_url = isset($data['extra']['site_upload_url']) ? $data['extra']['site_upload_url'] : '';
            $upload_url = $data['extra']['upload_url'];

            $data = $this->replace_urls_recursive($data, [
                'site_upload_url' => $site_upload_url,
                'upload_url' => $upload_url,
                'home_url' => $home_url,
                'network_url' => $network_url,
            ]);

            $json = json_encode($data);

            do_action('ahura_before_generate_demo_import_file', $json);
            file_put_contents($this->get_demo_file_path(), $json);
        
    }

    /**
     * @param $data
     * @param $urls
     * @return mixed
     */
    function replace_urls_recursive($data, $urls) {
        foreach ($data as $key => $value) {
            if ($key === 'guid')
                continue;

            $json = is_string($value) ? json_decode($value, true, 512, JSON_BIGINT_AS_STRING) : false;
            $value = $json !== null && $json != false ? $json : $value;
            if (is_array($value)) {
                $data[$key] = $this->replace_urls_recursive($value, $urls);
            } elseif (is_string($value)) {
                $upload = wp_upload_dir();
                if (isset($urls['site_upload_url']) && !empty($urls['site_upload_url'])){
                    $value = str_replace($urls['site_upload_url'], $upload['baseurl'], $value);
                }
                $value = str_replace($urls['upload_url'], $upload['baseurl'], $value);
                $value = str_replace($urls['home_url'], get_home_url(), $value);
                $value = str_replace($urls['network_url'], site_url('/'), $value);
                $data[$key] = $value;
            }
        }
        return $data;
    }

    /**
     *
     * Remove demo content file
     *
     * @return void
     */
    public function remove_demo_file(){
        $path = $this->get_demo_file_path();
        if(file_exists($path)){
            unlink($path);
        }
    }
}
