<?php
namespace Prk\Classes;

defined('ABSPATH') || exit;

class Mobile_Class {

    /**
     * Instance of the class.
     *
     * @var Mobile_Class|null
     */
    private static ?Mobile_Class $instance = null;

    /**
     * Get the singleton instance of the class.
     *
     * @return Mobile_Class
     */
    public static function get_instance(): Mobile_Class {
        if (is_null(self::$instance)) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * Mobile_Class constructor.
     */
    private function __construct() {
        add_action('wp_enqueue_scripts', [ $this, 'enqueue_scripts' ], 5);
        add_action('wp_footer', [ $this, 'render_mobile_navbar' ]);

        // Remove breadcrumb from before main content and add it after
        remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);
        add_action('woocommerce_after_main_content', 'woocommerce_breadcrumb', 10);
    }

    /**
     * Enqueue mobile-specific styles and scripts.
     */
    public function enqueue_scripts(): void {
      if (!wp_is_mobile()) return;
        wp_enqueue_style('prk-mobile-style', get_template_directory_uri() . '/assets/css/prk-mobile.css', [], '4.3.3', 'all');
        wp_enqueue_script('prk-mobile-script', get_template_directory_uri() . '/assets/js/prk-mobile.js', ['jquery'], PRK_VERSION, true);

        # ceck woocommerce plugins and after load js files
        if (class_exists( 'WooCommerce' )){
            if ( is_product()){
                if ( mobile_cheker() || tablet_cheker() ) {
                    wp_enqueue_script('prk-mobile-product', parskala_URI . '/app/Woocommerce/Single/Features/assets/js/prk-mobile-product.js', array ( 'jquery' ),PRK_VERSION, true);
                }
            }
        }
    }

    /**
     * Render the mobile navbar template.
     */
    public function render_mobile_navbar(): void {
        get_template_part('/inc/template/header/mobile-navbar');
    }

}
