<?php

namespace Prk\Classes;

class prk_Ajax {


    private static $instance = null;

    private function __construct() {
      
        add_action('wp_enqueue_scripts', [$this, 'enqueue_script']);
        add_action('wp_ajax_nopriv_prk_ajax_faq_search', [$this, 'faq_search'], 999);
        add_action('wp_ajax_prk_ajax_faq_search', [$this, 'faq_search'], 999);
        add_action('wp_ajax_nopriv_prk_ajax_compare_search', [$this, 'compare_search'], 999);
        add_action('wp_ajax_prk_ajax_compare_search', [$this, 'compare_search'], 999);
        add_action( 'wp_ajax_nopriv_get_quick_view', [$this, 'get_quick_view'] );
        add_action( 'wp_ajax_get_quick_view', [$this, 'get_quick_view'] );
        add_action( 'wp_ajax_prk_ajax_product_list', [$this, 'prk_ajax_product_list'] );
        add_action( 'wp_ajax_nopriv_prk_ajax_product_list', [$this, 'prk_ajax_product_list'] );

    }

 
    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function enqueue_script($hook) {
        wp_enqueue_script(
            'prk-product-editor-js',
            get_template_directory_uri() . '/assets/js/theme-ajax.js',
            ['jquery'],
            '1.0.0',
            true
        );

       

    }

    public function faq_search(){

        $keyword = trim(esc_attr($_GET['s']));
        $current_page = trim(esc_attr($_GET['current_page']));

        echo '<span class="prk_close_fag_search_result"><i class="ri-close-circle-fill"></i></span>';

        $args = array(
            's'                   => $keyword,
            'posts_per_page'      => 5,
            'post_type'           => 'prkfaq',
            'post_status'         => 'publish',
            'ignore_sticky_posts' => 1,
            'order'               => 'DECS',
        );
        $query = new \WP_Query( $args );
        if($query->have_posts()){
                while ($query->have_posts()):
                    $query->the_post();
                    echo '<a class="result_post_search" href="'.$current_page.'?question='.get_the_ID().'" >'.get_the_title().'</a>';
                endwhile;
            wp_reset_postdata();
            $has_result = true;
        } else {
            echo '<span class="not_resulted">موردی یافت نشد</span>';
            $has_result = false;
        }

        do_action('prk_after_result_search_ajax', $keyword, $has_result);
        $title_question = 'موضوع پرسش شما چیست؟';
        ?>

        <script>
        jQuery('.prk_close_fag_search_result').on('click',function(){

            jQuery('.main_result_ajax_ask_search').hide(0);
            jQuery('#text_search').val('');
        jQuery('.faq_headerbox .circle_btn_icon').html('<i class="ri-question-mark"></i>');
        jQuery('.faq_headerbox .page_title').html('<?php echo $title_question;?>');
        jQuery('.faq_headerbox .page_subtitle').removeClass('fadeOut');

        });
        </script>

        <?php
        exit();
    }




    public function get_quick_view() {
        ?>

        <?php
                $args = array(
                        'post_type'      => 'product',
            'p'  => $_POST['productId'],
            );

                $loop = new \WP_Query( $args );

                while ( $loop->have_posts() ) : $loop->the_post();
                global $product;
                global $woocommerce;
                $currency = get_woocommerce_currency_symbol();
                $price = get_post_meta( get_the_ID(), '_regular_price', true);
                $sale = get_post_meta( get_the_ID(), '_sale_price', true);
                            ?>
                <div class="main_product_view">

                    <div class="gallery_tombnail_view">

                        <!-- start of product-gallery -->
                        <div class="product-gallery">
                            <div class="gallery-img-container">
                                <!-- Slider main container -->
                                <div class="swiper gallery-swiper-slider noselect">
                                    <!-- Additional required wrapper -->
                                    <div class="swiper-wrapper">

                                    <?php
                                        if ( $product->get_image_id() ) {
                                            $image_link = wp_get_attachment_url( $post_thumbnail_id );
                                            echo '<div class="swiper-slide"><div class="gallery-img">';

                                            echo get_the_post_thumbnail( $post , 'shop_single' );
                                            echo '</div></div>';
                                        } else {
                                            echo '<div class="swiper-slide"><div class="gallery-img">';

                                            echo sprintf( '<img src="%s" alt="%s" class="wp-post-image" />', esc_url( wc_placeholder_img_src( 'woocommerce_single' ) ), esc_html__( 'Awaiting product image', 'woocommerce' ) );

                                            echo '</div></div>';

                                        }
                                        ?>
                                        <?php
                                            $attachment_ids = $product->get_gallery_image_ids();
                                            if ( $attachment_ids && has_post_thumbnail() ) {

                                            foreach ( $attachment_ids as $attachment_id ) {

                                                $image_link = wp_get_attachment_url( $attachment_id );
                                                echo '<div class="swiper-slide"><div class="gallery-img">';

                                                echo wp_get_attachment_image( $attachment_id, 'shop_single' );

                                                echo '</div></div>';

                                            }

                                            }

                                        ?>

                                    </div>

                                    <!-- If we need pagination -->
                                    <div class="swiper-pagination"></div>

                                    <!-- If we need navigation buttons -->
                                    <div class="swiper-button-prev view_nav"></div>
                                    <div class="swiper-button-next view_nav"></div>

                                </div>
                                <!-- Slider main container -->
                                <div class="swiper gallery-thumbs-swiper-slider noselect">
                                    <!-- Additional required wrapper -->
                                    <div class="swiper-wrapper">

                                        <!-- Slides -->
                                        <?php
                                            if ( $product->get_image_id() ) {
                                            $image_link = wp_get_attachment_url( $post_thumbnail_id );
                                            echo '<div class="swiper-slide"><div class="gallery-thumb">';

                                            echo get_the_post_thumbnail( $post , 'shop_single' );
                                            echo '</div></div>';

                                            } else {
                                            echo '<div class="swiper-slide"><div class="gallery-thumb">';

                                            echo sprintf( '<img src="%s" alt="%s" class="wp-post-image" />', esc_url( wc_placeholder_img_src( 'woocommerce_single' ) ), esc_html__( 'Awaiting product image', 'woocommerce' ) );

                                            echo '</div></div>';

                                            }
                                        ?>
                                        <?php
                                            $attachment_ids = $product->get_gallery_image_ids();
                                            if ( $attachment_ids && has_post_thumbnail() ) {

                                                foreach ( $attachment_ids as $attachment_id ) {

                                                $image_link = wp_get_attachment_url( $attachment_id );
                                                echo '<div class="swiper-slide"><div class="gallery-thumb">';

                                                echo wp_get_attachment_image( $attachment_id, 'shop_single' );

                                                echo '</div></div>';

                                                }

                                            }

                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end of product-gallery -->
                        <script>
                            jQuery(function ($) {
                            if ($(".gallery-swiper-slider").length) {
                            const gallerySwiperSlider = new Swiper(".gallery-swiper-slider", {
                            centeredSlides: true,
                            });
                            const galleryThumbsSwiperSlider = new Swiper(
                            ".gallery-thumbs-swiper-slider",
                            {
                                slidesPerView: 4,
                                slideToClickedSlide: true,
                                centeredSlides: true,
                                spaceBetween: 15,
                                navigation: {
                                nextEl: ".swiper-button-next.view_nav",
                                prevEl: ".swiper-button-prev.view_nav",
                                },
                            }
                            );
                            gallerySwiperSlider.controller.control = galleryThumbsSwiperSlider;
                            galleryThumbsSwiperSlider.controller.control = gallerySwiperSlider;
                        }

                            });
                        </script>
                    </div>

                    <div class="content_product_view">

                        <div class="viwe_breadcrumb">

                        <?php
                            echo breadcrumb_product();
                        ?>

                        </div>

                        <div class="viwe_title_product">

                        <?php echo $product->get_name(); ?>
                        </div>

                        <div class="viwe_pro_name">

                        <?php echo product_pro_name(); ?>

                        </div>

                        <div class="viwe_count_recommended">

                        <?php echo count_recommended(); ?>

                        </div>

                        <div class="viwe_ratings_counters">

                        <?php echo ratings_counters(); ?>

                        </div>

                        <div class="viwe_product_sku">

                        <?php echo product_sku(); ?>

                        </div>
                        <div class="viwe_attributes">
                        <?php echo costom_attributes(); ?>
                        </div>

                        <div class="viewe_single_price">
                        <!--price-->
                                            <div class="index-prices-pro">

                                                <div class="price_onsale_ar">

                                                            <?php if ($price|| $product->is_type( 'variable' )) {
                                                                echo $product->get_price_html();
                                                            }else{
                                                                echo '<p class="call_pro">', _e('call' , 'parskala'). '</p>';}
                                                            ?>

                                                </div>
                                            </div>
                        </div>



                    </div>


                </div>
                <div class="remodal-footer">

                    <button type="button" name="button" class="close_modal_view" data-remodal-action="close" >بستن</button>
                    <a href="<?php echo get_permalink(); ?>" alt= "جزئیات بیشتر" title= "جزئیات بیشتر" target="_blank" class="go_link_view">دیدن محصول</a>

                </div>
                            <?php
                endwhile;

                wp_reset_query();
        ?>



        <?php


        wp_die();
    }



    public function compare_search(){
    

    global $post,$product;

    $all_product = @$_GET['data_string'];
    $array_products = explode(',', $all_product);

        $keyword = trim(esc_attr($_GET['s']));
        $compare_short = get_permalink();
    // $current_page = trim(esc_attr($_GET['current_page']));


    $first_product_id = $array_products[0];
    $terms = get_the_terms( $first_product_id, 'product_cat' );

        $args = array(
            's'                   => $keyword,
            'post_type'           => 'product',
            'post_status'         => 'publish',
        'post__not_in' => $array_products,
            'ignore_sticky_posts' => 1,
            'order'               => 'DECS',
        );
        $query = new \WP_Query( $args );
        if($query->have_posts()){
                while ($query->have_posts()):
                    $query->the_post();

                    ?>
            <li>
                        <a href="<?php echo $compare_short;?><?php echo '?products='.$_GET['data_string'].','.$post->ID; ?>" >
                <?php the_post_thumbnail(); ?>
                <h2><?php the_title(); ?></h2>
                </a>
            </li>
                    <?php

                endwhile;
            wp_reset_postdata();
            $has_result = true;
        } else {
            echo '<span class="not_resulted">موردی یافت نشد</span>';
            $has_result = false;
        }

        do_action('prk_after_result_search_ajax_compare', $keyword, $has_result);

        exit();
    }

    
    public function prk_ajax_product_list() {

    
        $eventHandler = sanitize_text_field($_POST['eventH']);

        $number = sanitize_text_field($_POST['number']);
        $number = intval($number);
        $offset=0;
        if($eventHandler=='scroll' || $eventHandler=='scroll_no_tab'){
            $offset = sanitize_text_field($_POST['offset']);
            $offset = (intval($offset)*$number)+1;
        }
    
        $stock = sanitize_text_field($_POST['stock']);
        $type = sanitize_text_field($_POST['type']);

        $taxonomy = 'product_cat';

        if(!empty($_POST['group']) && !empty($_POST['group_ids'])){
        
                $taxonomyIds = $_POST['group_ids'];
                switch(sanitize_text_field($_POST['group'])){
                    case 'category':
                        $taxonomy = 'product_cat';
                        break;
                    case 'tag':
                        $taxonomy = 'product_tag';
                        break;
                    case 'brand':
                        $taxonomy = 'product_brand';
                        break;
                }

        }
    
    

        if($eventHandler != 'scroll_no_tab'){
        $cat = sanitize_text_field($_POST['cat']);
        $taxonomyIds = $cat;
        $seeallcat = sanitize_text_field($_POST['seeallcat']);
        $auth = sanitize_text_field($_POST['auth']);
        $seeallcat_bgcolor = sanitize_text_field($_POST['seeallcat_bgcolor']);
        $seeallcat_bgwalp = sanitize_text_field($_POST['seeallcat_bgwalp']);
        $seeallcat_link = sanitize_url($_POST['seeallcat_link']);
        $seeallcat_link_ext = sanitize_text_field($_POST['seeallcat_link_ext']);
        $seeallcat_link_follow = sanitize_text_field($_POST['seeallcat_link_follow']);
        $seeallcat_title = sanitize_text_field($_POST['seeallcat_title']);
        $seeallcat_titlecolor = sanitize_text_field($_POST['seeallcat_titlecolor']);
        
        if($seeallcat == 'yes'){

            switch($seeallcat_link){
                case '':
                    $seeallcat_link = '#';
                    break;
                default:
                    $seeallcat_link = $seeallcat_link;
                    break;
            }
            switch($seeallcat_link_ext){
                case 'on':
                    $seeallcat_link_ext = '_blank';
                    break;
                default:
                    $seeallcat_link_ext = '_self';
                    break;
            }
            switch($seeallcat_link_follow){
                case 'on':
                    $seeallcat_link_follow = 'nofollow';
                    break;
                default:
                    $seeallcat_link_follow = 'follow';
                    break;
            }
            switch($seeallcat_bgcolor){
                case '':
                    $seeallcat_bgcolor = '#00000000';
                    break;
                default:
                    $seeallcat_bgwalp = '#';
                    break;
            }
            switch($seeallcat_titlecolor){
                case '':
                    $seeallcat_titlecolor = "#000";
                    break;
            }
        }
    }

        $product_ids = $meta_key = $order = $orderby = $meta_query = '';
        switch ($type) {
            case 'featured':
                $product_ids = wc_get_featured_product_ids();
                break;
            case 'sale':
                $product_ids = wc_get_product_ids_on_sale();
                break;
            case 'bestsellings':
            case 'saled':
                $meta_key = 'total_sales';
                $order = 'DESC';
                $orderby = 'meta_value_num';
                break;
            case 'lowsellings':
                $meta_key = 'total_sales';
                $order = 'ASC';
                $orderby = 'meta_value_num';
                break;
            case 'lastedited':
                $orderby = 'modified';
                break;
            case 'olds':
                $order = 'ASC';
                break;
            case 'news':
            case 'latest':
            $order = 'DESC';
            $orderby = 'date';

            break;
            case 'rand':
            case 'random':
                $orderby = 'rand';
                break;
            default:
                $product_ids = '';
                break;
        }

        switch ($stock){
            case 'only_instocks':
            case 'yes':
                $meta_query = array(
                    array(
                        'key' => '_stock_status',
                        'value' => 'instock',
                        'compare' => '=',
                    ),
                );
                break;
            case 'only_not_instocks':
                $meta_query = array(
                    array(
                        'key' => '_stock_status',
                        'value' => 'outofstock',
                        'compare' => '=',
                    ),
                );
                break;
        }

        if (!empty($taxonomyIds)){//Cats
            $tax_query = array(
                array(
                    'taxonomy' => $taxonomy,
                    'field' => 'term_id',
                    'terms' => $taxonomyIds,
                    'operator' => 'IN'
                ),
            );
        }else $tax_query = '';



        ob_start(); //start the output buffering

        $args = array(
            'post_type' => 'product',
            'post_status' => 'publish',
            'posts_per_page' => $number,
            'post__in'=> $product_ids,
            'meta_key' => $meta_key,
            'order' => $order,
            'orderby'  => $orderby,
            'tax_query' => $tax_query,
            'meta_query' => $meta_query,
            'offset' => $offset,
        );
        
                
        //start the loop on products
        $auth = 1;
        if ($auth == '1'){//show only to logged in users

        
        $loop = new \WP_Query( $args );

        while ( $loop->have_posts()) {

            $loop->the_post();
            global $product;
            $product_label = get_post_meta(get_the_ID(), 'prk_product_label', true );
            $price = get_post_meta( get_the_ID(), '_regular_price', true);

            ?> 
            
            
            
            <article class="item-pro">

<?php if ($product_label): ?>
    <div class="custom_label"><span><?php echo $product_label;?></span></div>
<?php endif; ?>

<a href="<?php the_permalink();?>">

        <!--thumbnail-->
        <?php echo pr_img(); ?>

<div class="index-title-pro">
    <h2><?php echo wp_trim_words(get_the_title(),12,'...') ;?></h2>
</div>

        <?php
        echo '<div class="index-prices-pro">';

            if ( $product->is_in_stock() ) {

                echo '<div class="price_onsale_ar">';

                            if ($price || $product->is_type( 'variable' )) {
                                echo $product->get_price_html();
                            }else{
                                echo '<p class="call_pro">', _e('call' , 'parskala'). '</p>';
                            }

                echo '</div>';

            }
            echo '</div>';
        ?>

                <?php if( $product->is_purchasable() && $product->is_in_stock()):?>


                        <div class="lists_add_to_cart">
                            <?php echo do_shortcode("[ajax_cart_item]");?>
                        </div>

            

            <?php endif;?>


</a>
</article>
<?php 
        
            
        }
        if($eventHandler != 'scroll_no_tab'){

        if ($seeallcat == 'yes'){ ?> 
            <div class="off-product mories">
                                <a href="<?php echo $seeallcat_link; ?>" target="<?=$seeallcat_link_ext;?>" rel="<?=$seeallcat_link_follow?>">
        
        
                                <div class='seealcat-inner w-categorys-link' style='background-color:<?=$seeallcat_bgcolor?>; background-image: url(<?=$seeallcat_bgwalp?>);'><i class="ri-arrow-left-line"></i><p style='color:<?=$seeallcat_titlecolor;?>'> 
                                        <span><?=$seeallcat_title; ?></span></p></div>
                                
                                    
                                </a>
                            </div>
                    <?php  }
        }
        wp_reset_postdata();
            

        }else {
            ?> <div class="prk-ajax-mssg">برای مشاهده این محصولات ابتدا وارد شوید</div> <?php
        }
        
        //render the output
        $content = ob_get_contents();
        ob_end_clean();
            
        echo $content;
    
        wp_die();
    }

    



}