<?php

namespace Prk\Classes;

class prk_metaboxes {

    private static $instance = null;

    public function __construct() {
        add_filter( 'woocommerce_product_data_tabs', [$this, 'add_my_custom_product_data_tabs']);
        add_action('woocommerce_product_data_panels', [$this, 'render_metabox']);
        add_action('woocommerce_admin_process_product_object', [$this, 'save_product_meta']);
        add_action('admin_enqueue_scripts', [$this, 'product_edit_enqueue_script']);
    }

    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function product_edit_enqueue_script($hook) {
        global $post;

        // بررسی می‌کنیم که در صفحه ویرایش محصول هستیم
        if ($hook === 'post.php' || $hook === 'post-new.php') {
            if (isset($post) && $post->post_type === 'product') {
                wp_enqueue_script(
                    'prk-product-editor-js',
                    get_template_directory_uri() . '/assets/js/admin/product-editor.js',
                    ['jquery'],
                    '1.0.0',
                    true
                );
            }
        }
    }

    public function add_my_custom_product_data_tabs( $product_data_tabs ) {
        $product_data_tabs['my-custom-tab'] = array(
            'label' => __( 'پارس کالا', 'my_text_domain' ),
            'target' => 'my_customs_product_data',
        );
        return $product_data_tabs;
    }
    
    public function render_metabox() {
        global $post;
        ?>
        <div id="my_customs_product_data" class="panel woocommerce_options_panel">
            <?php
            $this->add_checkbox('onsales_round', 'پیشنهادات شگفت انگیز', 'درصورت فعال سازی این گزینه محصول به لیست محصولات شگفت انگیز اضافه میشود','','yes');
            $this->add_checkbox('product_facke_brand_show', 'محصول غیر اصل', 'بله', 'checkbox product_facke_brand_show','yes');
            $this->add_text_input('product_facke_brand_text', 'متن محصول غیر اصل', 'متن محصول غیر اصل', $this->product_facke_value(), 'product_facke_brand_text');
            $this->add_checkbox('special_send_box_single', 'حذف سکشن شرایط ارسال کالا', '', 'checkbox', 'yes');
            $this->add_checkbox('product_return_show', 'امکان بازگشت محصول', 'محصول امکان بازگشت', 'checkbox product_return_show','yes');
            $this->add_text_input('product_return_text', 'متن امکان بازگشت محصول', 'متن امکان بازگشت محصول را تنظیم کنید.', $this->product_return_value(), 'product_return_text');
            
            
                $this->add_checkbox('product_granti_show', 'فاقد گارانتی', 'حذف گارانتی برای این محصول ؟', 'checkbox product_granti_show','yes');
                $this->add_text_input('product_granti_text', 'متن گارانتی محصول', 'در صورت خالی گذاشتن گارانتی پیشفرض نمایش داده میشود.', $this->general_granty_value(), 'product_granti_text');
            
            
           
                $this->add_checkbox('product_Original_show', 'فاقد ضمانت محصول', 'حذف ضمانت کالا برای این محصول ؟', 'checkbox product_Original_show','yes');
                $this->add_text_input('product_Original_text', 'متن ضمانت اصالت محصول', 'در صورت خالی گذاشتن متن پیشفرض ضمانت اصالت نمایش داده میشود.', $this->general_orginal_value(), 'product_Original_text');
            
            
            $this->add_checkbox('product_hamta_show', 'هشدار سامانه همتا', 'پیام هشدار سامانه همتا قابل تنظیم در تنظیمات پوسته', 'checkbox product_hamta_show','yes');
            $this->add_textarea('product_hamta_text', 'متن هشدار سامانه همتا', 'متن هشدار سامانه همتا', $this->general_hamta_value(), 'product_hamta_text');

            $progress_sales = get_post_meta($post->ID, 'progress_sales', true);
            $prk_add_to_cart_label = get_post_meta($post->ID, 'prk_add_to_cart_label', true);
            $prk_product_label = get_post_meta($post->ID, 'prk_product_label', true);
            $this->add_text_input('progress_sales', 'درصد فروش رفته', 'رقم درصد را وارد کنید', $progress_sales,'','رقم درصد را وارد کنید');
            $this->add_text_input('prk_add_to_cart_label', 'لیبل دکمه افزودن به سبد خرید','این لیبل جایگزین متن پیشفرض افزودن به سبدخرید میشود.', $prk_add_to_cart_label);
            $this->add_text_input('prk_product_label', 'لیبل سفارشی','این لیبل در کارت آتم محصول نمایش داده میشود', $prk_product_label);
            ?>
        </div>
        <?php
    }

    private function add_checkbox($id, $label, $description = '', $class = 'checkbox', $cbvalue = '') {
        woocommerce_wp_checkbox([
            'id' => $id,
            'label' => __($label, 'my_text_domain'),
            'description' => __($description, 'my_text_domain'),
            'desc_tip' => false,
            'class' => $class,
            'cbvalue' => $cbvalue
        ]);
    }

    private function add_text_input($id, $label, $description = '', $value = '', $class = '',$placeholder = '') {
        woocommerce_wp_text_input([
            'id' => $id,
            'label' => __($label, 'my_text_domain'),
            'description' => __($description, 'my_text_domain'),
            'desc_tip' => true,
            'value' => $value,
            'class' => $class,
            'placeholder' => $placeholder
        ]);
    }

    private function add_textarea($id, $label, $description = '', $value = '', $class = '',$placeholder = '') {
        woocommerce_wp_textarea_input([
            'id' => $id,
            'label' => __($label, 'my_text_domain'),
            'description' => __($description, 'my_text_domain'),
            'desc_tip' => true,
            'value' => $value,
            'class' => $class,
            'placeholder' => $placeholder
        ]);
    }

    
    // متن پیشفرض محصول غیر اصل
    private function product_facke_value() {

        $def_date = '';
        if (empty(get_post_meta(get_the_ID(), 'product_facke_brand_text', true ))) {
        $def_date = 'این محصول به وسیله تولید کننده اصلی(برند) تولید نشده است.';
        }else {
        $def_date = get_post_meta(get_the_ID(), 'product_facke_brand_text', true );
        }
        return $def_date;

    }

    // متن پیشفرض امکان بازگشت
    private function product_return_value() {

        $def_date = '';
        if (empty(get_post_meta(get_the_ID(), 'product_return_text', true ))) {
        $def_date = 'امکان برگشت کالا با دلیل "انصراف از خرید" تنها در صورتی مورد قبول است که پلمب کالا باز نشده باشد.';
        }else {
        $def_date = get_post_meta(get_the_ID(), 'product_return_text', true );
        }
        return $def_date;

    }

    // متن پیشفرض گارانتی محصول
    private function general_granty_value() {

        $granty_value = '';
        $general_granty = prk_option('single_texts_Warrantyss');
        if ( empty( get_post_meta(get_the_ID(), 'product_granti_text', true) ) ) {
        $granty_value = $general_granty;
        }elseif( !empty( get_post_meta(get_the_ID(), 'product_granti_text', true) ) ){
        $granty_value = get_post_meta(get_the_ID(), 'product_granti_text', true );
        }else {
        $granty_value = '';
        }
        return $granty_value;

    }

    // متن پیشفرض ضمانت محصول
    private function general_orginal_value() {

        $orginal_value = '';
        $general_orginal = prk_option('single_product_bail_text');
        if (empty(get_post_meta(get_the_ID(), 'product_Original_text', true ))) {
        $orginal_value = $general_orginal;
        }else{
        $orginal_value = get_post_meta(get_the_ID(), 'product_Original_text', true );
        }
        return $orginal_value;

    }

    // متن پیشفرض هشدار سامانه همتا
    private function general_hamta_value() {

        $hamta_value = '';
        $general_hamta = prk_option('single_hamta_text');
        if (empty(get_post_meta(get_the_ID(), 'product_hamta_text', true ))) {
        $hamta_value = $general_hamta;
        }else{
        $hamta_value = get_post_meta(get_the_ID(), 'product_hamta_text', true );
        }
        return $hamta_value;

    }

    public function save_product_meta($product) {
        $default_meta = [
            'product_facke_brand_show'  => 'no',
            'product_return_show'       => 'no',
            'special_send_box_single'   => 'no',
            'product_granti_show'       => 'no',
            'product_Original_show'     => 'no',
            'onsales_round'             => 'no',
            'product_hamta_show'        => 'no',
        ];

        // مقداردهی اولیه متاها
        foreach ($default_meta as $key => $value) {
            update_post_meta($product->get_id(), $key, $value);
        }

        // فیلدهایی که نیاز به ذخیره دارند
        $meta_fields = [
            'product_facke_brand_show',
            'product_facke_brand_text',
            'product_return_show',
            'product_return_text',
            'product_granti_show',
            'product_granti_text',
            'product_Original_show',
            'product_Original_text',
            'product_hamta_show',
            'product_hamta_text',
            'special_send_box_single',
            'img_up_pro',
            'onsales_round',
            'progress_sales',
            'prk_add_to_cart_label',
            'prk_product_label',
        ];

        // ذخیره متاها در صورت ارسال از فرم
        foreach ($meta_fields as $field) {
            if (isset($_POST[$field])) {
                update_post_meta($product->get_id(), $field, wc_clean(wp_unslash($_POST[$field])));
            }
        }
    }
}

