<?php

namespace Prk\Classes;

class prk_taxonomy {

    private static $instance = null;
    private $brand_slug;

    private function __construct() {
         if (prk_option('product_brand') == '1' || prk_option('product_brand') == ''){
            $this->brand_slug = prk_option('product_brand_slug') ?: 'brand';
            add_action('init', [$this, 'register_brand_taxonomy'],0);
         }
    }

    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function register_brand_taxonomy() {
        $labels = [
            'name'              => __('برندها', 'parskala'),
            'singular_name'     => __('برند', 'parskala'),
            'menu_name'         => __('برندها', 'parskala'),
            'all_items'         => __('همه برندها', 'parskala'),
            'edit_item'         => __('ویرایش برند', 'parskala'),
            'update_item'       => __('بروزرسانی برند', 'parskala'),
            'add_new_item'      => __('افزودن برند جدید', 'parskala'),
            'new_item_name'     => __('نام برند جدید', 'parskala'),
            'search_items'      => __('جستجوی برند', 'parskala'),
            'not_found'         => __('برندی یافت نشد', 'parskala')
        ];

        $args = [
            'labels'            => $labels,
            'hierarchical'      => true,
            'public'            => true,
            'show_ui'           => true,
            'show_admin_column' => true,
            'query_var'         => true,
            'show_in_rest'      => true,
            'rewrite'           => ['slug' => $this->brand_slug]
        ];

        register_taxonomy($this->brand_slug, ['product'], $args);
        register_taxonomy_for_object_type( $this->brand_slug, ['product'] );

    }

}

