<?php
namespace Prk\Elementor;

if (!defined('ABSPATH')) exit; // امنیت

use Elementor\Widgets_Manager;

class Elementor_Loader {

    private function __construct() {
        add_action('elementor/widgets/widgets_registered', [$this, 'register_widgets']);
        add_action('wp_enqueue_scripts', [$this, 'enqueue_widget_assets']);
    }

    public function register_widgets(Widgets_Manager $widgets_manager) {
        $widget_classes = $this->get_widgets_for_current_page();
        foreach ($widget_classes as $widget_class) {
            if (class_exists($widget_class)) {
                $widgets_manager->register(new $widget_class()); // ثبت ویجت‌ها
            }
        }
    }

    private function get_widgets_for_current_page() {
      
        $widgets = [];
        $widgets = [
            'Prk\Elementor\Widgets\Archive\Archive_Title_Widget\Archive_Title_Widget',
            'Prk\Elementor\Widgets\Archive\Archive_Sidebar_Widget\Archive_Sidebar_Widget',
            'Prk\Elementor\Widgets\Archive\Archive_Products_Widget\Archive_Products_Widget',
            'Prk\Elementor\Widgets\Header\Header_searchbox\Header_searchbox',
        ];
        return $widgets;
    }

    public function enqueue_widget_assets() {
        $widget_classes = $this->get_widgets_for_current_page();
        foreach ($widget_classes as $widget_class) {
            $this->enqueue_widget_assets_by_class($widget_class);
        }
    }

    private function enqueue_widget_assets_by_class($widget_class) {
       
        $class_parts = explode('\\', $widget_class);

        $widget_type = $class_parts[3]; // بخش Archive, Header, Footer و...
        $widget_name = $class_parts[5]; // نام ویجت (مثل Archive_Title_Widget)

        // ساخت مسیر دقیق ویجت
        $widget_path = $widget_type . '/' . $widget_name;

        // تغییر نام ویجت به فرمت مناسب برای نامگذاری در وردپرس
        $widget_name_slug = strtolower(str_replace('_', '-', $widget_name));

      
        $base_url = get_template_directory_uri(); // آدرس URL قالب
        $base_path = get_template_directory(); // مسیر دایرکتوری قالب

        // تنظیم آدرس و مسیر دقیق برای فایل‌های استایل و اسکریپت
        $css_file_url = "$base_url/app/Elementor/Widgets/$widget_path/assets/style.css";
        $js_file_url = "$base_url/app/Elementor/Widgets/$widget_path/assets/script.js";
        $css_file_path = "$base_path/app/Elementor/Widgets/$widget_path/assets/style.css";
        $js_file_path = "$base_path/app/Elementor/Widgets/$widget_path/assets/script.js";

        if (file_exists($css_file_path)) {
            wp_enqueue_style("prk-{$widget_name_slug}-css", $css_file_url, [], filemtime($css_file_path));
        }
        if (file_exists($js_file_path)) {
            wp_enqueue_script("prk-{$widget_name_slug}-js", $js_file_url, ['jquery'], filemtime($js_file_path), true);
        }
     
    }

    private static $instance;
    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
}
