<?php


namespace Prk\Elementor\Widgets\Archive\Archive_Products_Widget;

use Elementor\Widget_Base;

if (!defined('ABSPATH')) exit; // امنیت

class Archive_Products_Widget extends Widget_Base {
    public function get_name() { return 'Archive_Products_Widget'; }
    public function get_title() { return 'ویجت محصولات آرشیو'; }
    public function get_icon() { return 'eicon-products-archive'; }
    public function get_categories() { return ['prk-category']; }

    protected function render() {
       

        if ( woocommerce_product_loop() ) {

        
            /**
             * Hook: woocommerce_before_shop_loop.
             *
             * @hooked woocommerce_output_all_notices - 10
             * @hooked woocommerce_result_count - 20
             * @hooked woocommerce_catalog_ordering - 30
             */
        
            echo '<ul class="product-box ' .prk_option('prk_loop_style_product').'" '.prk_grid_loop_columns_product().' >';
        
              woocommerce_product_loop_start();
        
              if ( wc_get_loop_prop( 'total' ) ) {
                  while ( have_posts() ) {
                      the_post();
        
                      /**
                       * Hook: woocommerce_shop_loop.
                       */
                      do_action( 'woocommerce_shop_loop' );
        
                      wc_get_template_part( 'content', 'product' );
                  }
              }
        
          woocommerce_product_loop_end();
        
            /**
             * Hook: woocommerce_after_shop_loop.
             *
             * @hooked woocommerce_pagination - 10
             */
            echo '</ul>';
   
        } else {
            /**
             * Hook: woocommerce_no_products_found.
             *
             * @hooked wc_no_products_found - 10
             */
            do_action( 'woocommerce_no_products_found' );
        }
                
    }
}