<?php

namespace Prk\Modules\Add2cart;

if (!defined('ABSPATH')) exit;

class add_2cart {
    
    private static $instance = null;

    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    public function __construct() {
        add_action('wp_enqueue_scripts', [$this, 'add2cart_load_assets']);
        add_action('woocommerce_after_shop_loop_item', [$this, 'quick_add2cart_button'], 1);
        add_action('woocommerce_before_shop_loop_item', [$this, 'prk_woocommerce_before_shop_loop_item'], 1);
        add_action('woocommerce_after_shop_loop_item', [$this, 'prk_woocommerce_after_shop_loop_item'], 1);
        add_action('prk_el_woocommerce_before_shop_loop_item', [$this, 'prk_woocommerce_before_shop_loop_item'], 1);
        add_action('prk_el_woocommerce_after_shop_loop_item', [$this, 'prk_woocommerce_after_shop_loop_item'], 1);
        add_action('wp_ajax_wcqv_get_product', [$this, 'wcqv_get_product']);
        add_action('wp_ajax_nopriv_wcqv_get_product', [$this, 'wcqv_get_product']);
        add_action('wcqv_product_data', 'woocommerce_template_single_add_to_cart');
        add_filter('add_to_cart_bottom', [$this, 'quick_add2cart_button_el'], 10, 2);
    }

    /**
     * بارگذاری استایل‌ها و اسکریپت‌های مورد نیاز
     */
    public function add2cart_load_assets() {
          
        $base_path  = parskala_URI.'/app/Modules/Add2cart/';
        wp_enqueue_style('add2cart-css', $base_path. 'css/style.css');
        wp_register_script('wcqv_frontend_js', $base_path. 'js/frontend.js', ['jquery'], true);
        
        $frontend_data = [
            'wcqv_nonce' => wp_create_nonce('wcqv_nonce'),
            'ajaxurl' => admin_url('admin-ajax.php'),
            'wcqv_base_path' => $base_path
        ];

        wp_localize_script('wcqv_frontend_js', 'wcqv_frontend_obj', $frontend_data);
        wp_enqueue_script('jquery');
        wp_enqueue_script('wcqv_frontend_js');
        wp_enqueue_script('wc-add-to-cart-variation');
        wp_enqueue_script('thickbox');
    }

    /**
     * دکمه افزودن سریع به سبد خرید
     */
    public function quick_add2cart_button() {
        global $post, $product;
        $icon_class = prk_option('archive_product_add_to_cart_icon') ?: 'prk-shopping-cart';
        $icon_text = prk_option('archive_product_add_to_cart_text') ?: 'افزودن به سبد';

        if ($product->is_in_stock() && (prk_option('archive_product_add_to_cart') == '1' || prk_option('archive_product_add_to_cart') == '')) {
            if (prk_option('archive_product_add_to_cart_type') == 'icon' || empty(prk_option('archive_product_add_to_cart_type'))) {
                echo '<a data-product-id="' . $post->ID . '" class="quick_add2cart button"><span><i class="' . $icon_class . '"></i></span></a>';
            } else {
                echo '<a data-product-id="' . $post->ID . '" class="quick_add2cart text"><span>' . $icon_text . '</span></a>';
            }
        }
    }

    /**
     * دکمه افزودن به سبد خرید در المنتور
     */
    public function quick_add2cart_button_el($cart_text, $type_add_to_cart) {
        global $post;
        if ($type_add_to_cart == 'text') {
            return $cart_text;
        }
        return '<a data-product-id="' . $post->ID . '" class="quick_add2cart button"><span><i class="prk-shopping-cart"></i></span></a>';
    }

    /**
     * استایل‌بندی در ابتدای محصول در لیست فروشگاه
     */
    public function prk_woocommerce_before_shop_loop_item() {
        echo '<div class="product-box-inner"><div class="info-product">';
    }

    /**
     * استایل‌بندی در انتهای محصول در لیست فروشگاه
     */
    public function prk_woocommerce_after_shop_loop_item() {
        ?>
        </div>
        <div class="variable-cart-product add2cart--wrapper">
            <button class="back-to-product"><i class="prk-arrow-right-1"></i></button>
            <?= prk_loading_modern() ?>
            <div class="wcqv_contend"></div>
        </div>
        </div>
        <?php
    }

    /**
     * دریافت اطلاعات محصول از طریق درخواست AJAX
     */
    public function wcqv_get_product() {
        global $woocommerce;
        $product_id = $_POST['product_id'];

        if (intval($product_id)) {
            wp('p=' . $product_id . '&post_type=product');
            ob_start();
            while (have_posts()) : the_post(); ?>
                <script>
                    var wc_add_to_cart_variation_params = {"ajax_url": "<?php echo admin_url('admin-ajax.php'); ?>"};
                    jQuery.getScript("<?php echo $woocommerce->plugin_url(); ?>/assets/js/frontend/add-to-cart-variation.min.js");
                </script>
                <div class="product">
                    <div id="product-<?php the_ID(); ?>">
                        <div class="summary entry-summary scrollable"><?php do_action('wcqv_product_data'); ?></div>
                        <div class="scrollbar_bg"></div>
                    </div>
                </div>
            <?php endwhile;
            echo ob_get_clean();
            exit();
        }
    }
}


// افزودن کلاس به کلاس‌های محصول در فروشگاه
add_filter('post_class', function($classes, $class, $product_id) {
    if (is_shop() || is_product_category()) {
        $classes = array_merge(['prob-item'], $classes);
    }
    return $classes;
}, 10, 3);
