<?php

namespace Prk\Modules\OrderTrack;

// جلوگیری از دسترسی مستقیم
if ( !defined( 'ABSPATH' ) ) exit;

class order_track {

    private static $instance;

   
    public static function get_instance() {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
       
        add_action('wp_enqueue_scripts', [ $this, 'enqueue_scripts' ]);
        $this->include_files();
    }

    /**
     * بارگذاری فایل‌های ماژول
     */
    private function include_files() {
        
        $base_path = get_template_directory() . '/app/Modules/ordertrack/inc/';
        require_once $base_path . 'custom.php';
        require_once $base_path . 'hooks.php';
        require_once $base_path . 'shortcode.php';
        if ( prk_option('prk_order_tracker') && prk_option('order_tracker_myaccount') ) {
            require_once $base_path . 'add-endpoint.php';
        }
        
    }

    /**
     * لود کردن استایل و اسکریپت‌های مورد نیاز
     */
    public function enqueue_scripts() {


		
		if ( ( is_account_page() && prk_option('prk_order_tracker') && prk_option('order_tracker_myaccount') ) || has_shortcode( get_post_field('post_content', get_the_ID()), 'prk-order-tracker' ) ) {

			wp_enqueue_style(
				'cbwct-tracker-style',
				get_template_directory_uri() . '/app/Modules/ordertrack/css/style.css'
			);

			wp_enqueue_script(
				'cbwct-tracker-ajax',
				get_template_directory_uri() . '/app/Modules/ordertrack/js/ajax-active.js',
				['jquery'],
				'1.0',
				true
			);

			wp_localize_script(
				'cbwct-tracker-ajax',
				'cbwct_tracker',
				[ 'ajaxurl' => admin_url('admin-ajax.php') ]
			);
		}

	}

 
}
