<?php
namespace Prk\Modules\whishlist;

// جلوگیری از دسترسی مستقیم
if ( !defined( 'ABSPATH' ) ) exit;


/**
 * Some Useful Constant
 */
define( 'SIT_PLUGIN_LOCATION', plugin_dir_path(__FILE__));
define( 'SIT_USER_META_KEY', 'sit_wishlist_ids' );
define( 'SIT_BEFORE_ADDED_BTN_HTML', 'sit_wishlist_before_html' );
define( 'SIT_AFTER_ADDED_BTN_HTML', 'sit_wishlist_after_html' );
define( 'SIT_DEFAULT_WISHLIST_BTN_VISIBILITY', 'sit_wishlist_btn_visibility' );
define( 'SIT_PLUGIN_URL' , plugin_dir_url(__FILE__));


class prk_wishlist{


	private static $instance;

    public static function get_instance() {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function __construct() {
		$this->includes();
		add_action('wp_enqueue_scripts', [$this, 'load_assets']);
	}

	    /**
     * بارگذاری استایل‌ها و اسکریپت‌های مورد نیاز
     */
    public function load_assets() {
          
        $base_path  = parskala_URI.'/app/Modules/whishlist/';
        wp_enqueue_style('whishlist-css', $base_path. 'assets/style.css');
  
    }

	

    public function includes() {
		require __DIR__ . '/inc/overwrite-templates.php'; 	// Overwrite the plugin file
		require __DIR__ . '/inc/useful-functions.php'; 	// Overwrite the plugin file
		require __DIR__ . '/inc/add-to-wishlist-btn.php'; 	// add the button to front-end
		require __DIR__ . '/inc/ajax.php'; 					// Ajax function for add remove the wishlist
		require __DIR__ . '/inc/add-endpoint.php'; 			// Add woocommerce end point
	}
}


