<?php

namespace Prk;

class Theme_Setup {

    private static ?self $instance = null;

    /**
     * Singleton pattern to ensure single instance.
     */
    public static function get_instance(): self {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * Initialize theme functionalities.
     */
    private function __construct() {
        $menu_counter = 0;
        add_action('wp_head', [ $this, 'prk_favicon' ], 1);
        add_action('init', [ $this, 'parskala_load_textdomain' ]);
        add_action('init', [ $this, 'prk_register_menus' ]);
        add_action('init', [ $this, 'add_post_thumbnail_support' ]);
        add_action('admin_menu', [ $this, 'prk_add_parent_menu' ]);
        add_filter('nav_menu_item_id',[$this, 'change_nav_menu_id'],10,2);

    }

    public static function get_theme_version() {
        $theme = wp_get_theme(); // گرفتن آبجکت WP_Theme
        return $theme->get('Version'); // گرفتن نسخه قالب
    }

    /**
     * Load theme textdomain for translations.
     */
    public function parskala_load_textdomain(): void {
        load_theme_textdomain('parskala', get_template_directory() . '/languages');
        
        if ( function_exists('wp_get_theme') && wp_get_theme()->get('TextDomain') ) {
            $text_domain = wp_get_theme()->get('TextDomain');
            $languages_path = get_template_directory() . '/languages';
        } else {
            $text_domain = dirname(plugin_basename(__FILE__));
            $languages_path = plugin_dir_path(__FILE__) . 'languages';
        }
        if ( version_compare( $GLOBALS['wp_version'], '6.7', '<' ) ) {
            load_plugin_textdomain( $text_domain, false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
        } else {
            $locale = determine_locale();
            $mo_file = $languages_path . "/$text_domain-$locale.mo";
    
            if ( is_readable( $mo_file ) ) {
                load_textdomain( $text_domain, $mo_file );
            }
        }

    }

    /**
     * Add theme menus to WordPress.
     */
    public function prk_register_menus(): void {
        register_nav_menus([
            'mega-menu' => __('منو هدر', 'parskala'),
            'mobile-menu' => __('منو موبایل', 'parskala'),
        ]);
    }

    /**
     * Add theme favicon to head.
     */
    public function prk_favicon(): void {
        $favicon = prk_option('favicon')['url'] ?? '';
        $touch_icon = prk_option('favicon_retina')['url'] ?? '';

        if ($favicon) {
            echo "<link rel='shortcut icon' href='" . esc_url($favicon) . "'>\n<link rel='icon' href='" . esc_url($favicon) . "'>\n";
        }
    }

    /**
     * Add parent menu to the admin panel.
     */
    public function prk_add_parent_menu(): void {
        add_menu_page('پارس کالا', 'پارس کالا', 'manage_options', 'prk-theme', '', parskala_IMG . '/icon/icon-app.png', 21);

        if (isset($_GET['page']) && $_GET['page'] === 'prk-theme') {
            wp_redirect(admin_url('admin.php?page=theme-options'));
            exit;
        }
    }

        /**
     * Add support for post thumbnails.
     */
    public function add_post_thumbnail_support() {
        add_theme_support('post-thumbnails');
        add_image_size('blog-size', 460, 460, true);
        add_image_size('img-logo', 200, 100, true);

        if (prk_option('custom_post_thumb')) {
            $width = prk_option('post_thumb_width');
            $height = prk_option('post_thumb_height');
            add_image_size('dpost_thumbnail', $width, $height, true);
        }
    }

        /**
     * Display Post Thumbnail based on user setting.
     */
    public static function prk_po_img() {
        if (has_post_thumbnail()) {
            if (prk_option('custom_post_thumb')) {
                the_post_thumbnail('dpost_thumbnail');
            } else {
                the_post_thumbnail('woocommerce_thumbnail');
            }
        } else {
            prod_defualt_thumb();
        }
    }

        /**
     * Display Full Size Post Thumbnail.
     */
    public static function prk_img_full_size() {
        if (has_post_thumbnail()) {
            the_post_thumbnail();
        } else {
            prod_defualt_thumb();
        }
    }

    
        /**
     * Change Nav Menu ID.
     */
    public function change_nav_menu_id($current_id,$item_details){
    global $menu_counter;
    return 'navi';
    }
    
}
