<?php
namespace Prk\Woocommerce\Archive;

class class_widgets {

    private static $instance = null;
    private $widgets_path;

    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function __construct() {       
        $this->widgets_path = get_template_directory() . '/app/Woocommerce/Archive/widgets/';
        
        $this->load_widgets();
    }

 
    public function load_widgets() {
        $widget_files = [
            'brands-filter.php',
            'categorys-filter.php',
            'stock-status.php',
        ];

        foreach ($widget_files as $file) {
            $file_path = $this->widgets_path . $file;
            if (file_exists($file_path)) {
                require_once $file_path;

                // ثبت ابزارک اگه کلاسش تعریف شده باشه
                $widget_class = str_replace('.php', '', $file);
                if (class_exists($widget_class)) {
                    register_widget($widget_class);
                }
            }
        }
    }
}