<?php
namespace Prk\Woocommerce\Globals;


class Set_location {

    private static $instance;

    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        $rrprefix='prskala_search';
        add_action("init", [$this, "cpt_city_cats"]);
        add_action( "wp_ajax_".$rrprefix."_getCityChildern", [$this, "so_wp_ajax_".$rrprefix."_getCityChildern"]);
        add_action( "wp_ajax_nopriv_".$rrprefix."_getCityChildern", [$this, "so_wp_ajax_".$rrprefix."_getCityChildern"] );
        add_action( "wp_ajax_".$rrprefix."_getCities", [$this, "so_wp_ajax_".$rrprefix."_getCities"]);
        add_action( "wp_ajax_nopriv_".$rrprefix."_getCities", [$this, "so_wp_ajax_".$rrprefix."_getCities"] );
        add_action( "wp_ajax_".$rrprefix."_searchCityByName", [$this, "so_wp_ajax_".$rrprefix."_searchCityByName"]);
        add_action( "wp_ajax_nopriv_".$rrprefix."_searchCityByName", [$this, "so_wp_ajax_".$rrprefix."_searchCityByName"] );
        add_action('add_meta_boxes', array($this, 'register_city_categories_metabox'));
    }

        /**
     * Register City Categories Metabox
     *
     * Adds a custom meta box for selecting city categories in post edit screen.
     *
     * @return void
     */
    public function register_city_categories_metabox() {
        add_meta_box(
            'city_categoriesdiv',                        // Metabox ID
            'شهرها',
            'product', // فقط برای محصولات                                      // Metabox Title
            'post_categories_meta_box',                  // Callback function (وردپرس خودش هندلش میکنه)
            null,                                         // Post type (null یعنی همه‌ی پست‌ها)
            'advanced',                                   // Context (advanced, side, normal)
            'default',                                    // Priority (high, low, default)
            array(
                'taxonomy' => 'city_categories',         // نام تاکسونومی
                '__back_compat_meta_box' => true         // استفاده از کامپوننت قدیمی
            )
        );
    }

    public function cpt_city_cats(){
        $labels = ["name" => 'استان و شهر', "singular_name" =>  'استان و شهر', "menu_name" => 'استان و شهر', "all_items" =>  'استان و شهرها', "parent_item" => 'استان', "parent_item_colon" => 'استان', "new_item_name" =>'افزودن', "add_new_item" => 'افزودن', "edit_item" =>'.یرایش', "update_item" => 'بروزرسانی', "separate_items_with_commas" => __("Separate with commas", "charsoogh"), "search_items" => 'جستجو', "add_or_remove_items" =>'ازودن و یا حذف', "choose_from_most_used" => __("Choose from the most used items", "charsoogh")];
        $args = ["labels" => $labels, "hierarchical" => true, "public" => true, "show_ui" => true, "show_admin_column" => true, "show_in_nav_menus" => true, "show_tagcloud" => true];
        register_taxonomy("city_categories", ["product"], $args);
        register_taxonomy_for_object_type("city_categories", "product");
    }
    
    public function so_wp_ajax_prskala_search_getCities(){
        $cities = get_terms('city_categories', array('hide_empty' => 0, 'parent' => 0));
        echo json_encode($cities);
        wp_die();
    }
    public function so_wp_ajax_prskala_search_getCityChildern(){
    
        $cityid=sanitize_text_field($_POST['cityid']);
        $children = get_terms('city_categories', array('hide_empty' => 0, 'parent' => $cityid));
        echo json_encode($children);
        wp_die();
    }
    
    public function so_wp_ajax_prskala_search_searchCityByName(){
        $txt=sanitize_text_field($_POST['txt']);
        $args = array(
            "hide_empty" => false,
            "taxonomy" => "city_categories",
            "childless" => false,
            'name__like' => $txt,
        );
        $res = get_terms($args);
        echo json_encode($res);
        wp_die();
    
    }
    
}