<?php

namespace Prk\Woocommerce\Myaccount;

class Class_comments {

    private static $instance;

    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        add_action('init', [$this, 'add_comments_endpoint']);
        add_filter('woocommerce_account_menu_items', [$this, 'add_comments_menu_item']);
        add_action('woocommerce_account_comments_endpoint', [$this, 'comments_content']);
    }

    /**
     * ثبت اندپوینت نظرات
     */
    public function add_comments_endpoint() {
        add_rewrite_endpoint('comments', EP_ROOT | EP_PAGES);
        flush_rewrite_rules();
    }

    /**
     * اضافه کردن آیتم نظرات به منوی حساب کاربری
     */
    public function add_comments_menu_item($items) {
        $items = array_slice($items, 0, 5, true)
               + ['comments' => __('نظرات', 'parskala')]
               + array_slice($items, 5, NULL, true);

        return $items;
    }

    /**
     * محتوای صفحه نظرات
     */
    public function comments_content() {

        include get_template_directory() . '/woocommerce/myaccount/comments.php';

    }

}