<?php

namespace Prk\Woocommerce\Myaccount;

class Class_notification {

    private static $instance;
    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
       
        add_action( 'init', [$this,'announcements_posttype'] );
        add_action( 'woocommerce_account_notification_endpoint', [$this, 'notification_my_account_endpoint_content'] );
        add_filter ( 'woocommerce_account_menu_items', [$this, 'misha_log_history_link'], 40 );
        add_action( 'init', [$this, 'misha_add_endpoint'] );
    }

    public function announcements_posttype() {
        register_post_type( 'notifications',
            array(
                'labels' => array(
                'name'          => __( 'اعلانات کاربری', 'parskala' ),
                'singular_name' => 'dashboard_notifications',
                ),
                'public'              => false,
                'show_ui'             => true,
                'has_archive'         => false,
                'show_in_rest'        => false,
                'exclude_from_search' => true,
                'supports'            => array( 'title', 'editor', 'thumbnail'),
                'show_in_menu'        => 'edit.php?post_type=product', // اضافه کردن به منوی محصولات ووکامرس
            )
        );
    }

    // add castom menu on woocommerce account menu
    public function misha_log_history_link( $menu_links ){
        $menu_links = array_slice( $menu_links, 0, 5, true )
        + array(
        'notification' => __( 'اعلانات من', 'parskala' ),
    )
        + array_slice( $menu_links, 5, NULL, true );
        return $menu_links;
    }
    
    public function misha_add_endpoint() {
        add_rewrite_endpoint( 'notification', EP_PAGES );
    }
  
    public function notification_my_account_endpoint_content() {
        ?>
        <div class="sp_Ports">
            <?php
                global $post;
            if( isset( $_GET['announcement'] ) ){
                $user_id = get_current_user_id();
                $announcement_id = $_GET['announcement'];
                echo '<div class="announcement_box"><h1 class="title">'.get_post_field( 'post_title', $announcement_id ).'</h1>';
                echo '<div class="content_box"><p>'.do_shortcode( get_post_field('post_content', $announcement_id) ).'</p></div>';
                echo '<div class="date">'.date_i18n("Y-m-d", strtotime( get_post_field( 'post_date', $announcement_id ) )).'</div></div>';
                if(empty( $post_read = get_user_meta($user_id, 'announcements', true) )){
                $post_read = array();
                $post_read[] = $announcement_id;
                update_user_meta($user_id, 'announcements', $post_read);
                }else{
                $post_read = get_user_meta($user_id, 'announcements', true);
                $post_read[] = $announcement_id ;
                update_user_meta($user_id, 'announcements', $post_read);
                }

            } else {
                $args = array(
                        'post_type' => 'notifications',
                        'posts_per_page' => 20,
                    );
                    $loop = new \WP_Query( $args );
                    if ( $loop->have_posts() ) {
                    while ( $loop->have_posts() ) : $loop->the_post();
                    $type_vidoe = get_post_meta( $post->ID , 'type_notif', true);
                ?>
            <div class="comments_contienr noti">
            <div class="comment_thumb noti">
            <?php the_post_thumbnail();?>
            </div>
                    <div class="comment_box noti">
                        <div class="notif_box">
                    <div class="name_content_product">
                        <a href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ) ?>notification/?announcement=<?php echo $post->ID ?>"><?php the_title(); ?></a>
                <div class="date"><?php echo date_i18n("Y-m-d", strtotime( get_post_field( 'post_date' ) )) ?></div>
                </div>
                <?php the_excerpt(15) ?>
                        </div>

                    </div>
                </div>
                <?php
                    endwhile;
            }else{
                echo '<p class="no_announcement">'.__( 'اعلانی وجود ندارد!', 'parskala' ).'</p>';
            }

            }
            ?>
        </div>

        <?php
    }
}